/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ROMClassesIterator
implements Iterator<J9ROMClassPointer> {
    private J9MemorySegmentPointer nextSegment;
    protected J9ROMClassPointer nextClass;
    protected final PrintStream out;

    public ROMClassesIterator(PrintStream printStream, J9MemorySegmentListPointer j9MemorySegmentListPointer) {
        this.out = printStream;
        if (j9MemorySegmentListPointer == null) {
            this.nextSegment = J9MemorySegmentPointer.NULL;
        } else {
            try {
                this.nextSegment = j9MemorySegmentListPointer.nextSegment();
            }
            catch (CorruptDataException corruptDataException) {
                this.nextSegment = J9MemorySegmentPointer.NULL;
            }
        }
        this.nextClass = J9ROMClassPointer.NULL;
    }

    @Override
    public boolean hasNext() {
        return J9ROMClassPointer.NULL != this.getNextClass().getClassPointer();
    }

    @Override
    public J9ROMClassPointer next() {
        ClassAndSegment classAndSegment = this.getNextClass();
        J9ROMClassPointer j9ROMClassPointer = classAndSegment.getClassPointer();
        if (j9ROMClassPointer == J9ROMClassPointer.NULL) {
            throw new NoSuchElementException();
        }
        this.nextClass = j9ROMClassPointer;
        this.nextSegment = classAndSegment.getSegmentPointer();
        return this.nextClass;
    }

    private ClassAndSegment getNextClass() {
        J9MemorySegmentPointer j9MemorySegmentPointer;
        J9ROMClassPointer j9ROMClassPointer;
        block7: {
            j9ROMClassPointer = J9ROMClassPointer.NULL;
            j9MemorySegmentPointer = this.nextSegment;
            try {
                if (this.nextSegment.isNull()) break block7;
                long l = 0L;
                l = this.nextClass == J9ROMClassPointer.NULL ? j9MemorySegmentPointer.heapBase().longValue() : this.nextClass.getAddress() + this.nextClass.romSize().longValue();
                do {
                    if (j9MemorySegmentPointer.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_ROM_CLASS) && l < j9MemorySegmentPointer.heapAlloc().longValue()) {
                        j9ROMClassPointer = J9ROMClassPointer.cast(l);
                        try {
                            if (!j9ROMClassPointer.romSize().eq(0L)) {
                                return new ClassAndSegment(j9ROMClassPointer, j9MemorySegmentPointer);
                            }
                            this.out.append("Size of ROMClass at " + j9ROMClassPointer.getHexAddress() + "is invalid. Skipping to next segment.\n");
                            j9ROMClassPointer = J9ROMClassPointer.NULL;
                        }
                        catch (CorruptDataException corruptDataException) {
                            this.out.append("Unable to read size of ROMClass at " + j9ROMClassPointer.getHexAddress() + ". Skipping to next segment.\n");
                            j9ROMClassPointer = J9ROMClassPointer.NULL;
                        }
                    }
                    if ((j9MemorySegmentPointer = j9MemorySegmentPointer.nextSegment()).isNull()) continue;
                    l = j9MemorySegmentPointer.heapBase().longValue();
                } while (!j9MemorySegmentPointer.isNull());
            }
            catch (CorruptDataException corruptDataException) {
                j9ROMClassPointer = J9ROMClassPointer.NULL;
            }
        }
        return new ClassAndSegment(j9ROMClassPointer, j9MemorySegmentPointer);
    }

    public J9MemorySegmentPointer getMemorySegmentPointer() {
        return this.nextSegment;
    }

    @Override
    public void remove() {
    }

    class ClassAndSegment {
        J9ROMClassPointer classPointer;
        J9MemorySegmentPointer segmentPointer;

        ClassAndSegment(J9ROMClassPointer j9ROMClassPointer, J9MemorySegmentPointer j9MemorySegmentPointer) {
            this.classPointer = j9ROMClassPointer;
            this.segmentPointer = j9MemorySegmentPointer;
        }

        public J9ROMClassPointer getClassPointer() {
            return this.classPointer;
        }

        public J9MemorySegmentPointer getSegmentPointer() {
            return this.segmentPointer;
        }
    }
}

