/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class BoolPointer
extends Pointer {
    public static final int SIZEOF = DataType.SIZEOF_BOOL;
    public static final BoolPointer NULL = new BoolPointer(0L);

    protected BoolPointer(long l) {
        super(l);
    }

    public static BoolPointer cast(AbstractPointer abstractPointer) {
        return BoolPointer.cast(abstractPointer.getAddress());
    }

    public static BoolPointer cast(UDATA uDATA) {
        return BoolPointer.cast(uDATA.longValue());
    }

    public static BoolPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new BoolPointer(l);
    }

    @Override
    public boolean boolAt(long l) throws CorruptDataException {
        return this.getBoolAtOffset((long)SIZEOF * l);
    }

    @Override
    public BoolPointer at(long l) throws CorruptDataException {
        throw new UnsupportedOperationException("Use boolAt(long index)");
    }

    @Override
    public BoolPointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public BoolPointer add(long l) {
        return new BoolPointer(this.address + (long)SIZEOF * l);
    }

    @Override
    public BoolPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public BoolPointer addOffset(long l) {
        return new BoolPointer(this.address + l);
    }

    @Override
    public BoolPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public BoolPointer sub(long l) {
        return new BoolPointer(this.address - (long)SIZEOF * l);
    }

    @Override
    public BoolPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public BoolPointer subOffset(long l) {
        return new BoolPointer(this.address - l);
    }

    @Override
    public BoolPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public BoolPointer untag() {
        throw new UnsupportedOperationException("Use BoolPointer.untag(long mask) insetead");
    }

    @Override
    public BoolPointer untag(long l) {
        return new BoolPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

