/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.UDATA;

public class U16Pointer
extends Pointer {
    public static final int SIZEOF = 2;
    public static final U16Pointer NULL = new U16Pointer(0L);

    protected U16Pointer(long l) {
        super(l);
    }

    public static U16Pointer cast(AbstractPointer abstractPointer) {
        return U16Pointer.cast(abstractPointer.getAddress());
    }

    public static U16Pointer cast(UDATA uDATA) {
        return U16Pointer.cast(uDATA.longValue());
    }

    public static U16Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new U16Pointer(l);
    }

    @Override
    public U16 at(long l) throws CorruptDataException {
        return new U16(this.getShortAtOffset(l * 2L));
    }

    @Override
    public U16 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public U16Pointer untag() {
        return this.untag(1L);
    }

    @Override
    public U16Pointer untag(long l) {
        return new U16Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public U16Pointer add(long l) {
        return new U16Pointer(this.address + 2L * l);
    }

    @Override
    public U16Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public U16Pointer addOffset(long l) {
        return new U16Pointer(this.address + l);
    }

    @Override
    public U16Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public U16Pointer sub(long l) {
        return new U16Pointer(this.address - 2L * l);
    }

    @Override
    public U16Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public U16Pointer subOffset(long l) {
        return new U16Pointer(this.address - l);
    }

    @Override
    public U16Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 2L;
    }
}

