/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I16Pointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.I8Pointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.WideSelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9UTF8;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassWalker;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class LinearDumper
implements IClassWalkCallbacks {
    private List<J9ClassRegion> classRegions = new LinkedList<J9ClassRegion>();
    private long firstJ9_ROM_UTF8 = Long.MAX_VALUE;
    private long lastJ9_ROM_UTF8 = Long.MIN_VALUE;

    @Override
    public void addSlot(StructurePointer structurePointer, IClassWalkCallbacks.SlotType slotType, AbstractPointer abstractPointer, String string) throws CorruptDataException {
        this.addSlot(structurePointer, slotType, abstractPointer, string, "");
    }

    @Override
    public void addSlot(StructurePointer structurePointer, IClassWalkCallbacks.SlotType slotType, AbstractPointer abstractPointer, String string, String string2) throws CorruptDataException {
        try {
            switch (slotType) {
                case J9_ROM_UTF8: {
                    long l = abstractPointer.getAddress() - structurePointer.getAddress();
                    this.classRegions.add(new J9ClassRegion(abstractPointer, IClassWalkCallbacks.SlotType.J9_SRP_TO_STRING, string, string2, slotType.getSize(), l, true));
                    VoidPointer voidPointer = SelfRelativePointer.cast(abstractPointer).get();
                    this.addUTF8Region(structurePointer, string, string2, voidPointer);
                    break;
                }
                case J9_UTF8: {
                    this.addUTF8Region(structurePointer, string, string2, abstractPointer);
                    break;
                }
                case J9_SRPNAS: {
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = J9ROMNameAndSignaturePointer.cast(SelfRelativePointer.cast(abstractPointer).get());
                    if (j9ROMNameAndSignaturePointer.notNull()) {
                        this.addSlot(structurePointer, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, j9ROMNameAndSignaturePointer.nameEA(), "name");
                        this.addSlot(structurePointer, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, j9ROMNameAndSignaturePointer.signatureEA(), "signature");
                    }
                    this.addSlot(structurePointer, IClassWalkCallbacks.SlotType.J9_SRP, abstractPointer, "cpFieldNAS");
                    break;
                }
                case J9_NAS: {
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = J9ROMNameAndSignaturePointer.cast(abstractPointer);
                    this.addSlot(structurePointer, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, j9ROMNameAndSignaturePointer.nameEA(), "name");
                    this.addSlot(structurePointer, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, j9ROMNameAndSignaturePointer.signatureEA(), "signature");
                    break;
                }
                case J9_IntermediateClassData: {
                    long l = abstractPointer.getAddress() - structurePointer.getAddress();
                    this.classRegions.add(new J9ClassRegion(abstractPointer, slotType, string, string2, ((J9ROMClassPointer)structurePointer).intermediateClassDataLength().longValue(), l, true));
                    break;
                }
                default: {
                    long l = abstractPointer.getAddress() - structurePointer.getAddress();
                    this.classRegions.add(new J9ClassRegion(abstractPointer, slotType, string, string2, slotType.getSize(), l, true));
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addUTF8Region(StructurePointer structurePointer, String string, String string2, AbstractPointer abstractPointer) throws CorruptDataException {
        long l = abstractPointer.getAddress() - structurePointer.getAddress();
        long l2 = ((J9ROMClassPointer)structurePointer).romSize().longValue();
        if (l > 0L && l < l2 && abstractPointer.notNull()) {
            long l3 = this.getUTF8Length(J9UTF8Pointer.cast(abstractPointer));
            if (abstractPointer.getAddress() < this.firstJ9_ROM_UTF8) {
                this.firstJ9_ROM_UTF8 = abstractPointer.getAddress();
            }
            if (abstractPointer.getAddress() + l3 > this.lastJ9_ROM_UTF8) {
                this.lastJ9_ROM_UTF8 = abstractPointer.getAddress() + l3;
            }
            this.classRegions.add(new J9ClassRegion(abstractPointer, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, string, string2, l3, l, true));
        }
    }

    public void addRegion(StructurePointer structurePointer, IClassWalkCallbacks.SlotType slotType, AbstractPointer abstractPointer, String string, long l, boolean bl) throws CorruptDataException {
        this.classRegions.add(new J9ClassRegion(abstractPointer, slotType, string, "", l, abstractPointer.getAddress() - structurePointer.getAddress(), bl));
    }

    @Override
    public void addSection(StructurePointer structurePointer, AbstractPointer abstractPointer, long l, String string, boolean bl) throws CorruptDataException {
        if (0L != l) {
            this.addRegion(structurePointer, IClassWalkCallbacks.SlotType.J9_SECTION_START, abstractPointer, string, l, bl);
            this.addRegion(structurePointer, IClassWalkCallbacks.SlotType.J9_SECTION_END, abstractPointer.addOffset(l), string, l, bl);
        }
    }

    public J9ClassRegionNode getAllRegions(ClassWalker classWalker) throws CorruptDataException {
        classWalker.allSlotsInObjectDo(this);
        StructurePointer structurePointer = classWalker.getClazz();
        if (this.firstJ9_ROM_UTF8 != Long.MAX_VALUE) {
            this.addSection(structurePointer, PointerPointer.cast(this.firstJ9_ROM_UTF8), this.lastJ9_ROM_UTF8 - this.firstJ9_ROM_UTF8, "UTF8", true);
        }
        this.groupSectionByName(structurePointer, "methodDebugInfo", false);
        this.groupSectionByName(structurePointer, "variableInfo", false);
        AbstractPointer abstractPointer = PointerPointer.NULL;
        J9ClassRegionNode j9ClassRegionNode = new J9ClassRegionNode(null);
        Stack<J9ClassRegionNode> stack = new Stack<J9ClassRegionNode>();
        J9ClassRegion j9ClassRegion = null;
        Collections.sort(this.classRegions);
        for (J9ClassRegion j9ClassRegion2 : this.classRegions) {
            if (this.isSameRegion(j9ClassRegion, j9ClassRegion2)) {
                j9ClassRegion = j9ClassRegion2;
                continue;
            }
            j9ClassRegion = j9ClassRegion2;
            if (IClassWalkCallbacks.SlotType.J9_SECTION_START == j9ClassRegion2.getType()) {
                if (j9ClassRegion2.getComputePadding() && abstractPointer.notNull() && !abstractPointer.eq(j9ClassRegion2.getSlotPtr())) {
                    j9ClassRegionNode.addChild(new J9ClassRegionNode(new J9ClassRegion(abstractPointer, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", j9ClassRegion2.getSlotPtr().getAddress() - abstractPointer.getAddress(), 0L, true)));
                }
                if (j9ClassRegion2.getComputePadding()) {
                    abstractPointer = j9ClassRegion2.getSlotPtr();
                }
                stack.push(j9ClassRegionNode);
                J9ClassRegionNode j9ClassRegionNode2 = new J9ClassRegionNode(j9ClassRegion2);
                j9ClassRegionNode.addChild(j9ClassRegionNode2);
                j9ClassRegionNode = j9ClassRegionNode2;
                continue;
            }
            if (IClassWalkCallbacks.SlotType.J9_SECTION_END == j9ClassRegion2.getType()) {
                if (j9ClassRegion2.getComputePadding()) {
                    long l = j9ClassRegion2.getSlotPtr().getAddress() - abstractPointer.getAddress();
                    if (l != 0L) {
                        j9ClassRegionNode.addChild(new J9ClassRegionNode(new J9ClassRegion(abstractPointer, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", l, 0L, true)));
                    }
                    abstractPointer = j9ClassRegion2.getSlotPtr();
                }
                j9ClassRegionNode = (J9ClassRegionNode)stack.pop();
                continue;
            }
            boolean bl = false;
            if (j9ClassRegionNode.getNodeValue() != null) {
                bl = j9ClassRegionNode.getNodeValue().getComputePadding();
            }
            if (bl && abstractPointer.notNull() && !abstractPointer.eq(j9ClassRegion2.getSlotPtr())) {
                j9ClassRegionNode.addChild(new J9ClassRegionNode(new J9ClassRegion(abstractPointer, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", j9ClassRegion2.getSlotPtr().getAddress() - abstractPointer.getAddress(), 0L, true)));
            }
            if (bl) {
                abstractPointer = j9ClassRegion2.getSlotPtr().addOffset(j9ClassRegion2.length);
            }
            j9ClassRegionNode.addChild(new J9ClassRegionNode(j9ClassRegion2));
        }
        if (structurePointer instanceof J9ROMClassPointer) {
            long l = J9ROMClassPointer.cast(structurePointer).romSize().longValue();
            long l2 = structurePointer.longValue() + l - abstractPointer.longValue();
            if (l2 != 0L) {
                j9ClassRegionNode.addChild(new J9ClassRegionNode(new J9ClassRegion(abstractPointer, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", l2, 0L, true)));
                Collections.sort(j9ClassRegionNode.getChildren());
            }
        }
        return j9ClassRegionNode;
    }

    private void groupSectionByName(StructurePointer structurePointer, String string, boolean bl) throws CorruptDataException {
        AbstractPointer abstractPointer = null;
        AbstractPointer abstractPointer2 = null;
        for (J9ClassRegion j9ClassRegion : this.classRegions) {
            if (IClassWalkCallbacks.SlotType.J9_SECTION_START != j9ClassRegion.getType() || !j9ClassRegion.getName().equals(string)) continue;
            if (abstractPointer == null || j9ClassRegion.getSlotPtr().lt(abstractPointer)) {
                abstractPointer = j9ClassRegion.getSlotPtr();
            }
            if (abstractPointer2 != null && !j9ClassRegion.getSlotPtr().add(j9ClassRegion.getLength()).gt(abstractPointer2)) continue;
            abstractPointer2 = j9ClassRegion.getSlotPtr().addOffset(j9ClassRegion.getLength());
        }
        if (abstractPointer != null && abstractPointer2 != null) {
            UDATA uDATA = UDATA.cast(abstractPointer2).sub(UDATA.cast(abstractPointer));
            this.addSection(structurePointer, PointerPointer.cast(abstractPointer), uDATA.longValue(), string + "s", bl);
        }
    }

    public void gatherLayoutInfo(PrintStream printStream, ClassWalker classWalker, long l) throws CorruptDataException {
        J9ClassRegionNode j9ClassRegionNode = this.getAllRegions(classWalker);
        LinearDumper.printAllRegions(printStream, classWalker.getClazz(), l, j9ClassRegionNode, 0);
    }

    public static void printAllRegions(PrintStream printStream, StructurePointer structurePointer, long l, J9ClassRegionNode j9ClassRegionNode, int n) throws CorruptDataException {
        Object object;
        J9ClassRegion j9ClassRegion = j9ClassRegionNode.getNodeValue();
        if ((long)n == l || j9ClassRegionNode.getChildren().size() == 0) {
            LinearDumper.printRegionLine(j9ClassRegion, printStream);
            return;
        }
        if ((long)n > l) {
            return;
        }
        if (j9ClassRegion != null) {
            object = String.format("Section Start: %s (%d bytes)", j9ClassRegion.getName(), j9ClassRegion.getLength());
            printStream.println();
            printStream.println(String.format("=== %-85s ===", object));
        }
        for (J9ClassRegionNode j9ClassRegionNode2 : j9ClassRegionNode.getChildren()) {
            LinearDumper.printAllRegions(printStream, structurePointer, l, j9ClassRegionNode2, n + 1);
        }
        if (j9ClassRegion != null) {
            object = String.format("Section End: %s", j9ClassRegion.getName());
            printStream.println();
            printStream.println(String.format("=== %-85s ===", object));
        }
    }

    private static void printRegionLine(J9ClassRegion j9ClassRegion, PrintStream printStream) {
        try {
            long l;
            long l2;
            if (j9ClassRegion.getType() == IClassWalkCallbacks.SlotType.J9_SECTION_START) {
                l2 = j9ClassRegion.getSlotPtr().getAddress();
                l = j9ClassRegion.getSlotPtr().getAddress() + j9ClassRegion.getLength();
            } else {
                l2 = j9ClassRegion.getSlotPtr().getAddress();
                l = j9ClassRegion.getSlotPtr().getAddress() + j9ClassRegion.getLength();
            }
            String string = String.format("%s-%s [ %20s %-28s ] %s", UDATAPointer.cast(l2).getHexAddress(), UDATAPointer.cast(l).getHexAddress(), LinearDumper.getRegionValueString(j9ClassRegion), j9ClassRegion.getName(), LinearDumper.getRegionDetailString(j9ClassRegion));
            printStream.println(string);
        }
        catch (CorruptDataException corruptDataException) {
            printStream.println(corruptDataException.getMessage());
        }
    }

    private static Object getRegionDetailString(J9ClassRegion j9ClassRegion) throws CorruptDataException {
        String string = "";
        switch (j9ClassRegion.getType()) {
            case J9_SECTION_START: {
                string = String.format(" %5d bytes", j9ClassRegion.getLength());
                break;
            }
            case J9_RAM_UTF8: {
                UDATAPointer uDATAPointer = UDATAPointer.cast(j9ClassRegion.getSlotPtr());
                if (uDATAPointer.at(0L).longValue() == 0L) break;
                string = J9ObjectHelper.stringValue(J9ObjectPointer.cast(uDATAPointer.at(0L)));
                break;
            }
            case J9_ROM_UTF8: 
            case J9_UTF8: {
                string = J9UTF8Helper.stringValue(J9UTF8Pointer.cast(j9ClassRegion.getSlotPtr()));
                break;
            }
            case J9_iTableMethod: {
                AbstractPointer abstractPointer = j9ClassRegion.getSlotPtr().subOffset(j9ClassRegion.offset);
                long l = j9ClassRegion.getSlotPtr().at(0L).longValue();
                abstractPointer = abstractPointer.addOffset(l);
                string = j9ClassRegion.additionalInfo + " " + abstractPointer.getHexAddress();
                break;
            }
            case J9_SRP: {
                VoidPointer voidPointer = SelfRelativePointer.cast(j9ClassRegion.getSlotPtr()).get();
                if (!voidPointer.notNull()) break;
                string = " -> " + voidPointer.getHexAddress();
                break;
            }
            case J9_WSRP: {
                VoidPointer voidPointer = WideSelfRelativePointer.cast(j9ClassRegion.getSlotPtr()).get();
                if (!voidPointer.notNull()) break;
                string = " -> " + voidPointer.getHexAddress();
                break;
            }
            case J9_SRP_TO_STRING: {
                VoidPointer voidPointer = SelfRelativePointer.cast(j9ClassRegion.getSlotPtr()).get();
                if (!voidPointer.notNull()) break;
                string = " -> " + voidPointer.getHexAddress();
                string = string + " " + J9UTF8Helper.stringValue(J9UTF8Pointer.cast(voidPointer));
                break;
            }
            case J9_Padding: {
                string = j9ClassRegion.length + " byte(s)";
                break;
            }
            case J9_IntermediateClassData: {
                string = j9ClassRegion.length + " byte(s) " + j9ClassRegion.additionalInfo;
                break;
            }
            default: {
                long l;
                String string2 = "";
                long l2 = l = UDATAPointer.cast(j9ClassRegion.getSlotPtr()).at(0L).longValue();
                if (null != j9ClassRegion.additionalInfo && j9ClassRegion.additionalInfo.length() != 0) {
                    if ("classAndFlags".equals(j9ClassRegion.name) && UDATA.MASK != l) {
                        l &= J9JavaAccessFlags.J9StaticFieldRefFlagBits ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    string2 = string2 + j9ClassRegion.additionalInfo + String.format(" 0x%08X", l);
                    if (0L != l && j9ClassRegion.additionalInfo.equals("!j9class")) {
                        try {
                            string2 = string2 + " - " + J9UTF8Helper.stringValue(J9ClassPointer.cast(l).romClass().className());
                            if ("classAndFlags".equals(j9ClassRegion.name)) {
                                String string3 = "";
                                if (0L != (J9JavaAccessFlags.J9StaticFieldRefBaseType & l2)) {
                                    string3 = string3 + "J9StaticFieldRefBaseType, ";
                                }
                                if (0L != (J9JavaAccessFlags.J9StaticFieldRefDouble & l2)) {
                                    string3 = string3 + "J9StaticFieldRefDouble, ";
                                }
                                if (0L != (J9JavaAccessFlags.J9StaticFieldRefVolatile & l2)) {
                                    string3 = string3 + "J9StaticFieldRefVolatile, ";
                                }
                                if (0 < string3.length()) {
                                    string3 = string3.substring(0, string3.length() - 2);
                                    string2 = string2 + "\t Flag(s) = " + string3;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                string = string2;
            }
        }
        return string;
    }

    private static String getRegionValueString(J9ClassRegion j9ClassRegion) throws CorruptDataException {
        switch (j9ClassRegion.getType()) {
            case J9_SECTION_START: {
                return "(SECTION)";
            }
            case J9_ROM_UTF8: 
            case J9_UTF8: 
            case J9_RAM_UTF8: {
                return "UTF8";
            }
            case J9_I8: {
                return I8Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_U8: {
                return U8Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_I16: {
                return I16Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_U16: {
                return U16Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_I32: {
                return I32Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_U32: {
                return U32Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_I64: {
                return I64Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_U64: {
                return U64Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_SRP: {
                return I32Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_WSRP: {
                return IDATAPointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_SRP_TO_STRING: {
                return I32Pointer.cast(j9ClassRegion.getSlotPtr()).getHexValue();
            }
            case J9_IntermediateClassData: 
            case J9_Padding: {
                return "";
            }
        }
        return j9ClassRegion.getSlotPtr().hexAt(0L);
    }

    private int getUTF8Length(J9UTF8Pointer j9UTF8Pointer) throws CorruptDataException {
        UDATA uDATA = new UDATA(j9UTF8Pointer.length().longValue() + J9UTF8.SIZEOF - 2L);
        if (uDATA.anyBitsIn(1L)) {
            uDATA = uDATA.add(1L);
        }
        return uDATA.intValue();
    }

    private boolean isSameRegion(J9ClassRegion j9ClassRegion, J9ClassRegion j9ClassRegion2) {
        boolean bl;
        if (j9ClassRegion == null || j9ClassRegion2 == null) {
            return false;
        }
        boolean bl2 = bl = j9ClassRegion.offset == j9ClassRegion2.offset && j9ClassRegion.getLength() == j9ClassRegion2.getLength();
        if (bl && (IClassWalkCallbacks.SlotType.J9_SECTION_START == j9ClassRegion.getType() || IClassWalkCallbacks.SlotType.J9_SECTION_END == j9ClassRegion.getType())) {
            bl = false;
        }
        return bl;
    }

    public static class J9ClassRegionNode
    implements Comparable<J9ClassRegionNode> {
        private J9ClassRegion nodeValue;
        private LinkedList<J9ClassRegionNode> children;

        public J9ClassRegionNode(J9ClassRegion j9ClassRegion) {
            this.nodeValue = j9ClassRegion;
            this.children = new LinkedList();
        }

        public J9ClassRegion getNodeValue() {
            return this.nodeValue;
        }

        public List<J9ClassRegionNode> getChildren() {
            return this.children;
        }

        public void addChild(J9ClassRegionNode j9ClassRegionNode) {
            this.children.addLast(j9ClassRegionNode);
        }

        @Override
        public int compareTo(J9ClassRegionNode j9ClassRegionNode) {
            AbstractPointer abstractPointer;
            AbstractPointer abstractPointer2 = this.nodeValue.getSlotPtr();
            if (abstractPointer2.lt(abstractPointer = j9ClassRegionNode.nodeValue.getSlotPtr())) {
                return -1;
            }
            if (abstractPointer2.gt(abstractPointer)) {
                return 1;
            }
            return 0;
        }
    }

    public static class J9ClassRegion
    implements Comparable<J9ClassRegion> {
        private final AbstractPointer slotPtr;
        private final IClassWalkCallbacks.SlotType type;
        private final String name;
        final String additionalInfo;
        private final long length;
        final long offset;
        private final boolean computePadding;

        public J9ClassRegion(AbstractPointer abstractPointer, IClassWalkCallbacks.SlotType slotType, String string, String string2, long l, long l2, boolean bl) {
            this.slotPtr = abstractPointer;
            this.type = slotType;
            this.name = string;
            this.additionalInfo = string2;
            this.length = l;
            this.offset = l2;
            this.computePadding = bl;
        }

        @Override
        public int compareTo(J9ClassRegion j9ClassRegion) {
            J9ClassRegion j9ClassRegion2 = this;
            boolean bl = false;
            long l = 0L;
            long l2 = 0L;
            try {
                l = j9ClassRegion2.getSlotPtr().longValue();
            }
            catch (CorruptDataException corruptDataException) {
                bl = true;
            }
            try {
                l2 = j9ClassRegion.getSlotPtr().longValue();
                if (bl) {
                    return 1;
                }
            }
            catch (CorruptDataException corruptDataException) {
                if (bl) {
                    return 0;
                }
                return -1;
            }
            int n = Long.compare(l, l2);
            if (0 == n) {
                IClassWalkCallbacks.SlotType slotType = j9ClassRegion2.getType();
                IClassWalkCallbacks.SlotType slotType2 = j9ClassRegion.getType();
                n = Integer.compare(slotType2.ordinal(), slotType.ordinal());
                if (0 == n) {
                    switch (slotType) {
                        case J9_SECTION_START: 
                        case J9_SECTION_END: {
                            n = Long.compare(j9ClassRegion.getLength(), j9ClassRegion2.getLength());
                            if (0 == n) {
                                n = Integer.compare(j9ClassRegion.getName().length(), j9ClassRegion2.getName().length());
                            }
                            if (slotType != IClassWalkCallbacks.SlotType.J9_SECTION_END) break;
                            n = -n;
                            break;
                        }
                    }
                }
            }
            return n;
        }

        public String getName() {
            return this.name;
        }

        public long getLength() {
            return this.length;
        }

        public IClassWalkCallbacks.SlotType getType() {
            return this.type;
        }

        public AbstractPointer getSlotPtr() {
            return this.slotPtr;
        }

        public boolean getComputePadding() {
            return this.computePadding;
        }
    }
}

