/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.MonitorTable;
import com.ibm.j9ddr.vm29.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.StackWalkCommand;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class ThreadsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public ThreadsCommand() {
        this.addCommand("threads", "cmd|help", "Lists VM threads");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.displayThreads(printStream);
        } else {
            String string2 = stringArray[0];
            if (string2.equalsIgnoreCase("help")) {
                this.help(printStream);
            } else {
                printStream.append("Attached Threads List. For more options, run !threads help\n");
                printStream.append(nl);
                if (string2.equalsIgnoreCase("stack")) {
                    this.stack(printStream, context, "");
                } else if (string2.equalsIgnoreCase("stackslots")) {
                    this.stack(printStream, context, "!stackslots");
                } else if (string2.equalsIgnoreCase("flags")) {
                    this.flags(printStream);
                } else if (string2.equalsIgnoreCase("debugEventData")) {
                    if (J9BuildFlags.interp_debugSupport) {
                        this.debugEventData(printStream);
                    }
                } else if (string2.equalsIgnoreCase("search")) {
                    this.search(printStream, new UDATA(Long.decode(stringArray[1])));
                } else if (string2.equalsIgnoreCase("monitors")) {
                    this.monitors(printStream);
                } else if (string2.equalsIgnoreCase("trace")) {
                    this.trace(printStream);
                }
            }
        }
    }

    public static String getThreadName(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        U8Pointer u8Pointer = j9VMThreadPointer.omrVMThread().threadName();
        StringBuffer stringBuffer = new StringBuffer();
        if (u8Pointer.isNull()) {
            stringBuffer.append("<NULL>");
        } else {
            while (!u8Pointer.at(0L).eq(0L)) {
                U8 u8 = u8Pointer.at(0L);
                stringBuffer.append((char)u8.intValue());
                u8Pointer = u8Pointer.add(1L);
            }
        }
        return stringBuffer.toString();
    }

    private void trace(PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            if (j9VMThreadPointer.notNull()) {
                J9VMThreadPointer j9VMThreadPointer2 = j9JavaVMPointer.mainThread();
                do {
                    printStream.append(String.format("    !stack 0x%s  !j9vmthread 0x%s  !j9thread 0x%s  tid 0x%s (%d) !utthreaddata 0x%s // %s", Long.toHexString(j9VMThreadPointer2.getAddress()), Long.toHexString(j9VMThreadPointer2.getAddress()), Long.toHexString(j9VMThreadPointer2.osThread().getAddress()), Long.toHexString(j9VMThreadPointer2.osThread().tid().longValue()), j9VMThreadPointer2.osThread().tid().longValue(), Long.toHexString(j9VMThreadPointer2.omrVMThread()._trace$uteThread().getAddress()), ThreadsCommand.getThreadName(j9VMThreadPointer2)));
                    printStream.append(nl);
                } while (!(j9VMThreadPointer2 = j9VMThreadPointer2.linkNext()).eq(j9VMThreadPointer));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void monitors(PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            MonitorTableListIterator monitorTableListIterator = new MonitorTableListIterator();
            MonitorTable monitorTable = null;
            while (monitorTableListIterator.hasNext()) {
                J9ObjectMonitorPointer j9ObjectMonitorPointer = monitorTableListIterator.next();
                MonitorTable monitorTable2 = monitorTableListIterator.currentMonitorTable();
                if (!monitorTable2.equals(monitorTable)) {
                    printStream.append("Table = " + monitorTable2.getTableName() + ", itemCount=" + monitorTable2.getCount());
                    printStream.append(nl);
                }
                printStream.append(String.format("\n    !j9thread 0x%s    !j9threadmonitor 0x%s", Long.toHexString(j9ObjectMonitorPointer.monitor().owner().getAddress()), Long.toHexString(j9ObjectMonitorPointer.monitor().getAddress())));
                printStream.append(nl);
                monitorTable = monitorTable2;
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void search(PrintStream printStream, UDATA uDATA) throws DDRInteractiveCommandException {
        block3: {
            try {
                J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
                J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
                if (!j9VMThreadPointer.notNull()) break block3;
                J9VMThreadPointer j9VMThreadPointer2 = j9JavaVMPointer.mainThread();
                do {
                    if (!j9VMThreadPointer2.osThread().tid().eq(uDATA)) continue;
                    printStream.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x (%d) // %s", j9VMThreadPointer2.getAddress(), j9VMThreadPointer2.getAddress(), j9VMThreadPointer2.osThread().getAddress(), j9VMThreadPointer2.osThread().tid().longValue(), j9VMThreadPointer2.osThread().tid().longValue(), ThreadsCommand.getThreadName(j9VMThreadPointer2)));
                    break;
                } while (!(j9VMThreadPointer2 = j9VMThreadPointer2.linkNext()).eq(j9VMThreadPointer));
            }
            catch (CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException(corruptDataException);
            }
        }
    }

    private void debugEventData(PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            if (j9VMThreadPointer.notNull()) {
                J9VMThreadPointer j9VMThreadPointer2 = j9JavaVMPointer.mainThread();
                do {
                    printStream.append(String.format("    !j9vmthread 0x%s %s %s %s %s %s %s %s %s", Long.toHexString(j9VMThreadPointer2.getAddress()), Long.toHexString(j9VMThreadPointer2.debugEventData1().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData2().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData3().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData4().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData5().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData6().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData7().longValue()), Long.toHexString(j9VMThreadPointer2.debugEventData8().longValue())));
                    printStream.append(nl);
                } while (!(j9VMThreadPointer2 = j9VMThreadPointer2.linkNext()).eq(j9VMThreadPointer));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void flags(PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            if (j9VMThreadPointer.notNull()) {
                J9VMThreadPointer j9VMThreadPointer2 = j9JavaVMPointer.mainThread();
                do {
                    printStream.append(String.format("    !j9vmthread 0x%s publicFlags=%s privateFlags=%s inNative=%s // %s", Long.toHexString(j9VMThreadPointer2.getAddress()), Long.toHexString(j9VMThreadPointer2.publicFlags().longValue()), Long.toHexString(j9VMThreadPointer2.privateFlags().longValue()), Long.toHexString(j9VMThreadPointer2.inNative().longValue()), ThreadsCommand.getThreadName(j9VMThreadPointer2)));
                    printStream.append(nl);
                } while (!(j9VMThreadPointer2 = j9VMThreadPointer2.linkNext()).eq(j9VMThreadPointer));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void stack(PrintStream printStream, Context context, String string) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            StackWalkCommand stackWalkCommand = new StackWalkCommand();
            if (j9VMThreadPointer.notNull()) {
                J9VMThreadPointer j9VMThreadPointer2 = j9JavaVMPointer.mainThread();
                do {
                    printStream.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x (%d) // %s", j9VMThreadPointer2.getAddress(), j9VMThreadPointer2.getAddress(), j9VMThreadPointer2.osThread().getAddress(), j9VMThreadPointer2.osThread().tid().longValue(), j9VMThreadPointer2.osThread().tid().longValue(), ThreadsCommand.getThreadName(j9VMThreadPointer2)));
                    printStream.append(nl);
                    stackWalkCommand.run(string, new String[]{Long.toString(j9VMThreadPointer2.getAddress())}, context, printStream);
                    printStream.append(nl);
                } while (!(j9VMThreadPointer2 = j9VMThreadPointer2.linkNext()).eq(j9VMThreadPointer));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void help(PrintStream printStream) {
        printStream.append("!threads            -- list all threads in the VM");
        printStream.append(nl);
        printStream.append("!threads stack      -- list stacks for all threads in the VM");
        printStream.append(nl);
        printStream.append("!threads stackslots -- list stackslots for all threads in the VM");
        printStream.append(nl);
        printStream.append("!threads flags      -- print the public and private flags field for each thread");
        printStream.append(nl);
        if (J9BuildFlags.interp_debugSupport) {
            printStream.append("!threads debugEventData -- print the debugEventData fields for each thread");
            printStream.append(nl);
        }
        printStream.append("!threads search     -- find a thread by thread id");
        printStream.append(nl);
        printStream.append("!threads monitors     -- list all monitors owned by each thread");
        printStream.append(nl);
        printStream.append("!threads trace     -- show UTE thread information");
        printStream.append(nl);
    }

    private void displayThreads(PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            if (j9VMThreadPointer.notNull()) {
                J9VMThreadPointer j9VMThreadPointer2 = j9JavaVMPointer.mainThread();
                do {
                    printStream.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x (%d) // (%s)", j9VMThreadPointer2.getAddress(), j9VMThreadPointer2.getAddress(), j9VMThreadPointer2.osThread().getAddress(), j9VMThreadPointer2.osThread().tid().longValue(), j9VMThreadPointer2.osThread().tid().longValue(), ThreadsCommand.getThreadName(j9VMThreadPointer2)));
                } while (!(j9VMThreadPointer2 = j9VMThreadPointer2.linkNext()).eq(j9VMThreadPointer));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

