/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;

public class TraceSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private BigInteger startPlatform;
    private BigInteger startSystem;
    private int type;
    private int generations;
    private int pointerSize = 4;

    public TraceSection(TraceFile traceFile, int n) throws IOException {
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.startPlatform = traceFile.readBigInteger(8);
        this.startSystem = traceFile.readBigInteger(8);
        this.type = traceFile.readI();
        this.generations = traceFile.readI();
        this.pointerSize = traceFile.readI();
        Util.setProperty("POINTER_SIZE", String.valueOf(this.pointerSize));
        Message.setPointerSize();
        TraceFormat.setStartSystem(this.startSystem);
        TraceFormat.setStartPlatform(this.startPlatform);
        TraceFormat.setGenerations(this.generations);
        Util.Debug.println("TraceSection: eyecatcher:          " + this.eyecatcher_string);
        Util.Debug.println("TraceSection: length:              " + this.length);
        Util.Debug.println("TraceSection: version:             " + this.version);
        Util.Debug.println("TraceSection: modification:        " + this.modification);
        Util.Debug.println("TraceSection: startPlatform:       " + this.startPlatform);
        Util.Debug.println("TraceSection: startSystem:         " + this.startSystem);
        Util.Debug.println("TraceSection: type:                " + this.type);
        Util.Debug.println("TraceSection: generations:         " + this.generations);
        Util.Debug.println("TraceSection: pointerSize:         " + this.pointerSize);
    }

    protected final int getTraceType() {
        return this.type;
    }
}

