/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.Component;
import com.ibm.jvm.trace.format.api.Message;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;

public final class MessageFile {
    TraceContext context;
    private BufferedReader reader;
    private String formatName;
    protected float verMod = 0.0f;
    private HashMap messages = new HashMap();
    private HashMap componentList = new HashMap();
    private final String fromDATFile = ".definedInDatFile";
    private boolean processingDATFile = false;
    int counter = 0;
    String savedComponentName = "not_a_component";
    Component savedComponent = null;

    public HashMap getStatistics() {
        HashMap<Object, Properties> hashMap = new HashMap<Object, Properties>();
        for (Object object : this.messages.keySet()) {
            Message message = (Message)this.messages.get(object);
            if (message == null) continue;
            hashMap.put(object, message.getStatistics());
        }
        for (Message message : this.componentList.keySet()) {
            Component component = (Component)this.componentList.get(message);
            if (component == null) continue;
            int n = 0;
            for (n = 0; n < component.messageList.size(); ++n) {
                Message message2 = (Message)component.messageList.get(n);
                if (message2 == null) continue;
                hashMap.put(component.getName() + "." + n, message2.getStatistics());
            }
        }
        return hashMap;
    }

    private void initialize(TraceContext traceContext, InputStream inputStream) throws IOException {
        this.context = traceContext;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.read();
    }

    private MessageFile(TraceContext traceContext, File file) throws IOException {
        this.formatName = file.getName();
        this.initialize(traceContext, new FileInputStream(file));
    }

    private MessageFile(TraceContext traceContext, InputStream inputStream) throws IOException {
        this.initialize(traceContext, inputStream);
    }

    public float getVersion() {
        return this.verMod;
    }

    private void read() throws IOException {
        String string = this.reader.readLine();
        if (string == null) {
            throw new IOException("file is empty");
        }
        this.readHeader(string);
        this.processingDATFile = true;
        try {
            String string2 = this.reader.readLine();
            if ((double)this.verMod >= 5.0) {
                while (string2 != null && string2.length() != 0) {
                    this.addMessage_50(string2);
                    string2 = this.reader.readLine();
                }
            } else {
                while (string2 != null) {
                    this.addMessage_12(string2);
                    string2 = this.reader.readLine();
                }
            }
        }
        finally {
            this.processingDATFile = false;
        }
    }

    private void failParse(String string, String string2) throws IOException {
        this.context.error(this, "File: '" + this.formatName + "' bad.  Reason: " + string + "Contents:  <" + string2 + ">");
        throw new IOException(string);
    }

    private void readHeader(String string) throws IOException {
        int n = string.indexOf(" ");
        if (n != -1) {
            this.failParse("Trace format file '" + this.formatName + "' header malformed.", string);
        }
        try {
            this.verMod = Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            if (string.equals("dg")) {
                this.failParse("Trace format file '" + this.formatName + "' obsolete, no version number.", "");
            }
            this.failParse("Trace format file '" + this.formatName + "' appears to be corrupted.", string);
        }
    }

    protected void addMessage(String string) {
        this.addMessage_12(string);
    }

    private void addMessage_50(String string) {
        int n;
        int n2 = string.indexOf(" ");
        int n3 = string.indexOf(" ", n2 + 1);
        int n4 = string.indexOf(" ", n3 + 1);
        int n5 = string.indexOf(" ", n4 + 1);
        int n6 = string.indexOf(" ", n5 + 1);
        int n7 = string.indexOf(" ", n6 + 1);
        String string2 = null;
        int n8 = -1;
        String string3 = null;
        String string4 = null;
        string2 = new String(string.substring(0, n2));
        if (this.verMod >= 5.1f && (n = string2.indexOf(46)) != -1) {
            String string5 = string2.substring(0, n);
            String string6 = string2.substring(n + 1);
            n8 = Integer.parseInt(string6);
            string2 = string5;
        }
        if (!string2.equals(this.savedComponentName)) {
            this.savedComponentName = string2;
            this.savedComponent = (Component)this.componentList.get(string2);
            if (this.savedComponent == null) {
                this.savedComponent = new Component(string2);
                this.componentList.put(string2, this.savedComponent);
                this.messages.put(string2 + ".definedInDatFile", null);
                this.savedComponent.setBase(0);
            }
            this.counter = 0;
        }
        n = this.counter++;
        if (n8 >= 0 && n != n8) {
            throw new Error("Tracepoint number out of order: component = " + string2 + ", tpid = " + n + ", in file '" + this.formatName + "'");
        }
        int n9 = Integer.parseInt(string.substring(n2 + 1, n3));
        int n10 = Integer.parseInt(string.substring(n4 + 1, n5));
        string3 = string.substring(n6 + 1, n7);
        string4 = string.substring(n7 + 2, string.length() - 1);
        Message message = new Message(n9, string4, n, n10, string2, string3, this.context);
        this.savedComponent.addMessage(message, n);
    }

    private void addMessage_12(String string) {
        int n = string.indexOf(" ");
        int n2 = string.indexOf(" ", n + 1);
        int n3 = string.indexOf(" ", n2 + 1);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n4 = Integer.parseInt(string.substring(0, n), 16);
        int n5 = Integer.parseInt(string.substring(n + 1, n2));
        int n6 = 1;
        if (this.verMod < 1.2f) {
            string3 = string.substring(n2 + 1, n3);
            string4 = string.substring(n3 + 2, string.length() - 1);
        } else {
            int n7 = string.indexOf(" ", n3 + 1);
            int n8 = string.indexOf(" ", n7 + 1);
            int n9 = string.indexOf(" ", n8 + 1);
            n6 = Integer.parseInt(string.substring(n3 + 1, n7));
            string3 = string.substring(n8 + 1, n9);
            string4 = string.substring(n9 + 2, string.length() - 1);
        }
        Message message = new Message(n5, string4, n4, n6, string2, string3, this.context);
        this.messages.put(n4, message);
    }

    protected Message getMessageFromID(int n) {
        if ((double)this.verMod >= 5.0) {
            this.context.error(this, "Trying to retrieve an old style message (0x" + Long.toString(n) + ") from 5.0 or newer message file");
            return null;
        }
        return (Message)this.messages.get(n);
    }

    protected synchronized Message getMessageFromID(String string, int n) {
        String string2;
        Message message;
        if ((double)this.verMod < 5.0) {
            this.context.error(this, "Trying to retrieve a new style message (" + string + "." + n + ") from 1.1 or older message file");
            return null;
        }
        Component component = (Component)this.componentList.get(string);
        if (component != null) {
            message = component.getMessageByID(n);
        } else {
            string2 = new String(string + "." + n);
            message = (Message)this.messages.get(string2);
        }
        if (message == null) {
            if (this.componentIsFromDATFile(string)) {
                this.context.error(this, string + "." + n + " not in dat file: corrupted trace point or dat file mismatch against source VM.");
                message = new Message(14, "This tracepoint's format string was not available in dat file.", n, -1, string, " ", this.context);
            } else {
                message = string.equals("ApplicationTrace") ? new Message(13, "%s", n, -1, string, "%s", this.context) : new Message(13, "raw parameter data [%.*s]", n, -1, string, "%s", this.context);
            }
            if (component != null && n >= 0) {
                component.addMessage(message, n);
            } else {
                string2 = new String(string + "." + n);
                this.messages.put(string2, message);
            }
        }
        return message;
    }

    public boolean componentIsFromDATFile(String string) {
        return this.messages != null && this.messages.containsKey(string + ".definedInDatFile");
    }

    public static MessageFile getMessageFile(InputStream inputStream, TraceContext traceContext) throws IOException {
        return new MessageFile(traceContext, inputStream);
    }

    public static MessageFile getMessageFile(File file, TraceContext traceContext) throws IOException {
        return new MessageFile(traceContext, file);
    }
}

