/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.Address64;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class ELF64FileReader
extends ELFFileReader {
    public ELF64FileReader(File file, ByteOrder byteOrder, long l) throws FileNotFoundException, IOException, InvalidDumpFormatException {
        super(file, byteOrder, l);
    }

    public ELF64FileReader(File file, ByteOrder byteOrder) throws FileNotFoundException, IOException, InvalidDumpFormatException {
        super(file, byteOrder, 0L);
    }

    public ELF64FileReader(ImageInputStream imageInputStream, long l) throws IOException, InvalidDumpFormatException {
        super(imageInputStream, l);
    }

    public boolean validDump(byte[] byArray, long l) {
        return 127 == byArray[0] && 69 == byArray[1] && 76 == byArray[2] && 70 == byArray[3] && 2 == byArray[4];
    }

    @Override
    protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
        int n = this.is.readInt();
        int n2 = this.is.readInt();
        long l = this.is.readLong();
        long l2 = this.is.readLong();
        long l3 = this.is.readLong();
        long l4 = this.is.readLong();
        long l5 = this.is.readLong();
        long l6 = this.is.readLong();
        return new ProgramHeaderEntry(n, l, l4, l2, l3, l5, n2, l6, this);
    }

    @Override
    protected long padToWordBoundary(long l) {
        return (l + 7L) / 8L * 8L;
    }

    @Override
    protected long readElfWord() throws IOException {
        return this.is.readLong();
    }

    @Override
    protected Address readElfWordAsAddress() throws IOException {
        return new Address64(this.is.readLong());
    }

    @Override
    protected int addressSizeBits() {
        return 64;
    }

    @Override
    protected List<ELFSymbol> readSymbolsAt(SectionHeaderEntry sectionHeaderEntry) throws IOException {
        if (0L != sectionHeaderEntry.size % 24L) {
            return Collections.emptyList();
        }
        this.seek(sectionHeaderEntry.offset);
        long l = (int)(sectionHeaderEntry.size / 24L);
        l = Math.min(Math.abs(l), 8096L);
        ArrayList<ELFSymbol> arrayList = new ArrayList<ELFSymbol>((int)l);
        for (long i = 0L; i < l; ++i) {
            long l2 = (long)this.is.readInt() & 0xFFFFFFFFL;
            byte by = this.is.readByte();
            byte by2 = this.is.readByte();
            int n = this.is.readShort() & 0xFFFF;
            long l3 = this.is.readLong();
            long l4 = this.is.readLong();
            arrayList.add(new ELFSymbol(l2, l3, l4, by, by2, n));
        }
        return arrayList;
    }
}

