/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.MutableAddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Dll;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllFunction;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Emulator;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionEmulator {
    private AddressSpace space;
    private Emulator em;
    private long functionEntryPoint;
    private BitSet ignoreFunctionTrace = new BitSet();
    private MutableAddressSpace mspace;
    private int[] args = new int[3];
    private long returnValue;
    private long stackBase;
    private boolean printOffsets;
    private Function callTreeRoot;
    private Function currentFunction;
    private boolean recordTrace;
    private ArrayList traceEntries;
    private HashMap replacedFunctions = new HashMap();
    private ObjectMap enteredFunctions = new ObjectMap();
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public FunctionEmulator(AddressSpace addressSpace, String string) throws IOException, NoSuchMethodException {
        DllFunction dllFunction = Dll.getFunction(addressSpace, string);
        if (dllFunction == null) {
            throw new NoSuchMethodException("cannot find function: " + string);
        }
        log.fine("creating emulator for function " + string + " address " + FunctionEmulator.hex(dllFunction.address) + " env " + FunctionEmulator.hex(dllFunction.env));
        this.createEmulator(addressSpace, dllFunction.address, dllFunction.env);
        if (((addressSpace.readInt(dllFunction.address) & 0xFF00F000) != -1879031808 || (addressSpace.readInt(dllFunction.address + 4L) & Short.MIN_VALUE) != -1488289792) && (addressSpace.readInt(dllFunction.address) & 0xFFFFF000) == 1206972416) {
            this.em.setRegister(15, (int)dllFunction.address);
            this.em.setRegister(13, this.stackBase + 4096L);
            assert (!addressSpace.is64bit());
            this.mspace.writeInt(this.em.getRegister(13) + 76L, (int)this.stackBase + 8192);
            this.em.setRegister(4, -559038737);
            this.em.setRegister(14, this.em.getRegister(7));
            this.em.setRegister(7, -559038737);
        }
    }

    public FunctionEmulator(AddressSpace addressSpace, long l, long l2) throws IOException, NoSuchMethodException {
        this.createEmulator(addressSpace, l, l2);
    }

    void createEmulator(AddressSpace addressSpace, long l, long l2) throws IOException {
        this.functionEntryPoint = l;
        this.space = addressSpace;
        try {
            this.em = (Emulator)Class.forName("com.ibm.zebedee.emulator.EmulatorImpl").newInstance();
        }
        catch (Exception exception) {
            throw new Error("unable to instantiate com.ibm.zebedee.emulator.EmulatorImpl");
        }
        this.mspace = new MutableAddressSpace(addressSpace);
        int n = 65536;
        this.stackBase = this.mspace.malloc(n);
        this.em.setRegister(4, this.stackBase + (long)n - 4096L);
        this.em.setRegister(5, l2);
        this.em.setRegister(6, l);
        this.createDummyReturnAddress();
    }

    public long getStackFloor() {
        return this.stackBase;
    }

    public long createDummyReturnAddress() throws IOException {
        long l = this.mspace.rmalloc(1);
        this.em.setRegister(7, l);
        Emulator.CallbackFunction callbackFunction = new Emulator.CallbackFunction(){

            @Override
            public boolean call(Emulator emulator) {
                emulator.stop();
                FunctionEmulator.this.returnValue = emulator.getRegister(3);
                return false;
            }
        };
        this.em.registerCallbackFunction(l, callbackFunction);
        this.em.registerCallbackFunction(l + 2L, callbackFunction);
        this.em.registerCallbackFunction(l + 4L, callbackFunction);
        return l;
    }

    public void setPrintOffsets(boolean bl) {
        this.printOffsets = bl;
    }

    public void setInstructionTracing(boolean bl) {
        this.em.setTraceListener(bl ? new TraceListener() : null);
    }

    public void setInstructionRecording(boolean bl) {
        this.em.setTraceListener(bl ? new TraceListener() : null);
        if (bl) {
            this.recordTrace = true;
            this.traceEntries = new ArrayList();
        } else {
            this.recordTrace = false;
        }
    }

    public List getTraceEntries() {
        return this.traceEntries;
    }

    public void setBranchInstructionTracing(boolean bl) {
        this.em.setBranchTraceListener(bl ? new BranchTraceListener() : null);
    }

    public void setCallTreeCapture() {
        this.currentFunction = this.callTreeRoot = new Function("root", null);
        this.em.setBranchTraceListener(new BranchTraceListener(){

            @Override
            protected void enterFunction(String string, long l) {
                FunctionEmulator.this.currentFunction = FunctionEmulator.this.currentFunction.addChild(string);
            }

            @Override
            protected void exitFunction(String string) {
                FunctionEmulator.this.currentFunction = FunctionEmulator.this.currentFunction.getParent();
                if (FunctionEmulator.this.currentFunction == null) {
                    assert (false) : "shouldn't happen in theory";
                    FunctionEmulator.this.currentFunction = FunctionEmulator.this.callTreeRoot;
                }
            }
        });
    }

    public Function getCallTreeRoot() {
        return this.callTreeRoot;
    }

    public Function getCurrentFunction() {
        return this.currentFunction;
    }

    public Emulator getEmulator() {
        return this.em;
    }

    public void setArgument(int n, int n2) {
        if (n < 4) {
            this.em.setRegister(n, n2);
        } else {
            try {
                this.mspace.writeInt(this.em.getRegister(4) + 2112L + (long)(n - 1 << 2), n2);
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
        }
    }

    public void setArgument(int n, long l) {
        if (n < 4) {
            this.em.setRegister(n, l);
        } else {
            try {
                if (this.mspace.is64bit()) {
                    this.mspace.writeLong(this.em.getRegister(4) + 2176L + (long)(n - 1 << 3), l);
                } else {
                    this.mspace.writeInt(this.em.getRegister(4) + 2112L + (long)(n - 1 << 2), (int)l);
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
        }
    }

    public long getArgument(int n) {
        if (n < 4) {
            return this.em.getRegister(n);
        }
        try {
            if (this.mspace.is64bit()) {
                return this.mspace.readLong(this.em.getRegister(4) + 2176L + (long)(n - 1 << 3));
            }
            return this.mspace.readInt(this.em.getRegister(4) + 2112L + (long)(n - 1 << 2));
        }
        catch (IOException iOException) {
            throw new Error("oops: " + iOException);
        }
    }

    public MutableAddressSpace getMutableAddressSpace() {
        return this.mspace;
    }

    public long registerCallbackFunction(final CallbackFunction callbackFunction) {
        try {
            long l = this.mspace.malloc(1);
            long l2 = this.mspace.malloc(32);
            if (this.mspace.is64bit()) {
                this.mspace.writeLong(l2 + 8L, l);
            } else {
                this.mspace.writeInt(l2 + 20L, (int)l);
            }
            this.em.registerCallbackFunction(l, new Emulator.CallbackFunction(){

                @Override
                public boolean call(Emulator emulator) throws IOException {
                    try {
                        long l = callbackFunction.call(FunctionEmulator.this);
                        emulator.setRegister(3, l);
                        return false;
                    }
                    catch (CallOriginalException callOriginalException) {
                        assert (false);
                        return true;
                    }
                }
            });
            this.ignoreFunctionTrace.set((int)l & Integer.MAX_VALUE);
            return l2;
        }
        catch (IOException iOException) {
            throw new Error("oops: " + iOException);
        }
    }

    public void overrideFunction(String string, CallbackFunction callbackFunction) throws IOException, NoSuchMethodException {
        DllFunction dllFunction = Dll.getFunction(this.space, string);
        if (dllFunction == null) {
            throw new NoSuchMethodException("cannot find function: " + string);
        }
        this.overrideFunction(dllFunction.address, callbackFunction);
    }

    public void overrideFunction(long l, final CallbackFunction callbackFunction) throws IOException, NoSuchMethodException {
        this.em.registerCallbackFunction(l, new Emulator.CallbackFunction(){

            @Override
            public boolean call(Emulator emulator) throws IOException {
                try {
                    long l = callbackFunction.call(FunctionEmulator.this);
                    emulator.setRegister(3, l);
                    return false;
                }
                catch (CallOriginalException callOriginalException) {
                    return true;
                }
            }
        });
    }

    public void overrideFunction(String string, long l, boolean bl) {
        this.replacedFunctions.put(string, new Replace(l, bl));
        this.em.setFunctionReplacer(new Emulator.FunctionReplacer(){

            @Override
            public boolean replace(Emulator emulator, long l) throws IOException {
                Replace replace;
                String string = (String)FunctionEmulator.this.enteredFunctions.get(l);
                if (string == null) {
                    string = DsaStackFrame.getEntryPointName(FunctionEmulator.this.space, FunctionEmulator.this.stripTopBit(l));
                    FunctionEmulator.this.enteredFunctions.put(l, string);
                }
                if ((replace = (Replace)FunctionEmulator.this.replacedFunctions.get(string)) != null) {
                    if (replace.protect) {
                        try {
                            emulator.saveState();
                            long l2 = FunctionEmulator.this.createDummyReturnAddress();
                            emulator.setRegister(7, l2);
                            emulator.run(FunctionEmulator.this.mspace, l);
                            long l3 = emulator.getRegister(3);
                            emulator.restoreState();
                            emulator.setRegister(3, l3);
                        }
                        catch (IOException iOException) {
                            log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.FunctionEmulator.overrideFunction(...).FunctionReplacer", "replace", "Unexpected Exception", iOException);
                            emulator.restoreState();
                            emulator.setRegister(3, replace.retVal);
                        }
                        emulator.resume();
                        return true;
                    }
                    emulator.setRegister(3, replace.retVal);
                    return true;
                }
                return false;
            }
        });
    }

    public void overrideFunction(String string, long l) {
        this.overrideFunction(string, l, false);
    }

    private long stripTopBit(long l) {
        return this.mspace.is64bit() ? l : l & Integer.MAX_VALUE;
    }

    public long run() throws IOException {
        this.em.run(this.mspace, this.functionEntryPoint);
        return this.returnValue;
    }

    public long run(long l) throws IOException {
        long l2;
        long l3;
        if (this.mspace.is64bit()) {
            l3 = this.mspace.readLong(l + 8L);
            l2 = this.mspace.readLong(l + 0L);
        } else {
            l3 = this.mspace.readInt(l + 20L);
            l2 = this.mspace.readInt(l + 16L);
        }
        this.em.setRegister(5, l2);
        long l4 = this.createDummyReturnAddress();
        this.em.setRegister(7, l4);
        long l5 = this.functionEntryPoint;
        this.functionEntryPoint = l3;
        this.em.run(this.mspace, this.functionEntryPoint);
        this.functionEntryPoint = l5;
        this.mspace.free(l4);
        return this.returnValue;
    }

    private void setEnvReg(long l) {
        this.em.setRegister(5, l);
        try {
            long l2 = this.mspace.readInt(l);
            l2 &= 0xFFFFFFFFFFFFF000L;
            int n = 0;
            while (n < 3) {
                try {
                    this.mspace.readInt(l2);
                }
                catch (IOException iOException) {
                    this.mspace.allocPage(l2);
                    log.fine("Filled in hole at " + FunctionEmulator.hex(l2));
                }
                ++n;
                l2 += 4096L;
            }
        }
        catch (IOException iOException) {
            log.fine("Cannot read env: " + FunctionEmulator.hex(l));
        }
    }

    public long run(String string) throws IOException, NoSuchMethodException {
        DllFunction dllFunction = Dll.getFunction(this.space, string);
        if (dllFunction == null) {
            throw new NoSuchMethodException("cannot find function: " + string);
        }
        this.setEnvReg(dllFunction.env);
        this.createDummyReturnAddress();
        this.em.run(this.mspace, dllFunction.address);
        return this.returnValue;
    }

    public void recordCalledFunctions() throws IOException {
        this.em.setBranchTraceListener(new BranchTraceListener(){

            @Override
            protected void enterFunction(String string, long l) {
                long l2 = FunctionEmulator.this.getEmulator().getRegister(5);
                DllFunction dllFunction = new DllFunction(string, l, null, l2);
                Dll.addFunction(FunctionEmulator.this.space, string, dllFunction);
                log.fine("Adding " + string);
            }

            @Override
            protected void exitFunction(String string) {
            }
        });
        this.runAllPaths();
    }

    public void recordAllCalledFunctions() throws IOException {
        this.em.setBranchTraceListener(new BranchTraceListener(){

            @Override
            protected void enterFunction(String string, long l) {
                long l2 = FunctionEmulator.this.getEmulator().getRegister(5);
                DllFunction dllFunction = new DllFunction(string, l, null, l2);
                Dll.addFunction(FunctionEmulator.this.space, string, dllFunction);
                log.fine("Adding " + string);
            }

            @Override
            protected void exitFunction(String string) {
            }
        });
        this.run();
    }

    public void runAllPaths() throws IOException {
        this.em.runAllPaths(this.mspace, this.functionEntryPoint);
    }

    static String hex(long l) {
        return Long.toHexString(l);
    }

    static String hexpad(long l) {
        String string = FunctionEmulator.hex(l);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static String hexpad(int n) {
        String string = FunctionEmulator.hex(n);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    private class BranchTraceListener
    implements Emulator.BranchTraceListener {
        ObjectMap map = new ObjectMap();
        long lastTargetAddress;
        long lastReturnAddress;
        int indent;

        private BranchTraceListener() {
        }

        protected void enterFunction(String string, long l) {
            System.out.println("[" + this.indent + "] enter " + string);
            ++this.indent;
        }

        protected void exitFunction(String string) {
            --this.indent;
            System.out.println("[" + this.indent + "] exit " + string);
        }

        @Override
        public void traceBranchAndSave(Emulator emulator, Emulator.Instruction instruction, long l, long l2) throws IOException {
            this.doTraceBranchAndSave(emulator, instruction, l, l2);
        }

        void doTraceBranchAndSave(Emulator emulator, Emulator.Instruction instruction, long l, long l2) throws IOException {
            l &= Integer.MAX_VALUE;
            if ((l2 &= Integer.MAX_VALUE) == this.lastReturnAddress) {
                this.doTraceBranchOnCondition(emulator, instruction, true, l2);
                this.lastReturnAddress = 0L;
            } else if (!FunctionEmulator.this.ignoreFunctionTrace.get((int)l2)) {
                Emulator.BranchRelative branchRelative;
                String string = DsaStackFrame.getEntryPointName(FunctionEmulator.this.space, l2);
                if (instruction.id() == 2677 && (branchRelative = (Emulator.BranchRelative)((Object)instruction)).getOffset() > 0L && branchRelative.getOffset() < 32L && string.equals("(unknown)")) {
                    return;
                }
                this.map.put(l, string);
                this.enterFunction(string, l2);
            }
            this.lastReturnAddress = l;
            this.lastTargetAddress = 0L;
        }

        @Override
        public void traceBranchOnCondition(Emulator emulator, Emulator.Instruction instruction, boolean bl, long l) throws IOException {
            this.doTraceBranchOnCondition(emulator, instruction, bl, l);
        }

        void doTraceBranchOnCondition(Emulator emulator, Emulator.Instruction instruction, boolean bl, long l) throws IOException {
            if (instruction.id() == 2676) {
                return;
            }
            String string = (String)this.map.get((l &= Integer.MAX_VALUE) - 4L);
            if (string == null) {
                string = (String)this.map.get(l);
            }
            if (string == null) {
                string = (String)this.map.get(l - 2L);
            }
            if (string != null && l != this.lastTargetAddress + 4L) {
                this.exitFunction(string);
            }
            this.lastTargetAddress = l;
        }
    }

    private class TraceListener
    extends BranchTraceListener
    implements Emulator.TraceListener {
        TraceEntry entry;

        private TraceListener() {
        }

        public void trace(Emulator.Instruction instruction) throws IOException {
            this.entry = new TraceEntry(instruction.address(), instruction.address() - FunctionEmulator.this.functionEntryPoint, instruction.toString());
        }

        void recordOrPrint(TraceEntry traceEntry) {
            if (FunctionEmulator.this.recordTrace) {
                FunctionEmulator.this.traceEntries.add(traceEntry);
            } else {
                log.fine(traceEntry.toString());
            }
        }

        @Override
        protected void enterFunction(String string, long l) {
            if (!string.equals("(unknown)")) {
                this.entry.result = this.entry.result + " (enter " + string + ")";
            }
        }

        @Override
        protected void exitFunction(String string) {
            if (!string.equals("(unknown)")) {
                this.entry.result = this.entry.result + " (exit " + string + ")";
            }
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction) throws IOException {
            this.trace(instruction);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, int[] nArray) throws IOException {
            this.trace(instruction);
            for (int i = 0; i < nArray.length; ++i) {
                this.entry.result = this.entry.result + FunctionEmulator.hexpad(nArray[i]) + " ";
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, long[] lArray) throws IOException {
            this.trace(instruction);
            for (int i = 0; i < lArray.length; ++i) {
                this.entry.result = this.entry.result + FunctionEmulator.hexpad(lArray[i]) + " ";
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, String string) throws IOException {
            this.trace(instruction);
            this.entry.result = string;
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, int n) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(n);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, double d) throws IOException {
            this.trace(instruction);
            this.entry.result = "" + d;
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, int n, int n2) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(n) + " " + FunctionEmulator.hexpad(n2);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, double d, double d2) throws IOException {
            this.trace(instruction);
            this.entry.result = "" + d + " " + d2;
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, long l) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(l);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, long l, long l2) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(l) + " " + FunctionEmulator.hexpad(l2);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, int n, long l) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(n) + " " + FunctionEmulator.hexpad(l);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void trace(Emulator emulator, Emulator.Instruction instruction, double d, long l) throws IOException {
            this.trace(instruction);
            this.entry.result = "" + d + " " + FunctionEmulator.hexpad(l);
            this.recordOrPrint(this.entry);
        }

        @Override
        public void traceBranchAndSave(Emulator emulator, Emulator.Instruction instruction, long l, long l2) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(l2);
            try {
                this.doTraceBranchAndSave(emulator, instruction, l, l2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void traceBranchOnCondition(Emulator emulator, Emulator.Instruction instruction, boolean bl, long l) throws IOException {
            this.trace(instruction);
            this.entry.result = FunctionEmulator.hexpad(l);
            try {
                this.doTraceBranchOnCondition(emulator, instruction, bl, l);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.recordOrPrint(this.entry);
        }

        @Override
        public void traceBranchOnCount(Emulator emulator, Emulator.Instruction instruction, int n) throws IOException {
            this.trace(instruction);
            this.entry.result = "" + n;
            this.recordOrPrint(this.entry);
        }
    }

    public static interface CallbackFunction {
        public long call(FunctionEmulator var1) throws IOException, CallOriginalException;
    }

    public static class CallOriginalException
    extends Exception {
    }

    class Replace {
        long retVal;
        boolean protect;

        Replace(long l, boolean bl) {
            this.retVal = l;
            this.protect = bl;
        }
    }

    public class TraceEntry {
        public long address;
        public long offset;
        public String instruction;
        public String opcode;
        public String args;
        public String result = "";

        TraceEntry(long l, long l2, String string) {
            int n;
            this.instruction = string;
            this.address = l;
            this.offset = l2;
            if (n != -1) {
                this.opcode = string.substring(0, n);
                for (n = string.indexOf(32); n < string.length() && string.charAt(n) == ' '; ++n) {
                }
                this.args = n < string.length() ? string.substring(n) : "";
            } else {
                this.opcode = string;
                this.args = "";
            }
        }

        public String toString() {
            String string = FunctionEmulator.this.printOffsets ? " + " + FunctionEmulator.hexpad(this.offset).substring(5) : "";
            return FunctionEmulator.hexpad(this.address) + string + ": " + this.instruction + " " + this.result;
        }
    }

    public class Function {
        private String name;
        private Function parent;
        private ArrayList children = new ArrayList();
        private HashMap childMap = new HashMap();

        Function(String string, Function function) {
            this.name = string;
            this.parent = function;
        }

        public Function getParent() {
            return this.parent;
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public String getName() {
            return this.name;
        }

        public Function addChild(String string) {
            Function function = (Function)this.childMap.get(string);
            if (function == null) {
                function = new Function(string, this);
                this.children.add(function);
                this.childMap.put(string, function);
            }
            return function;
        }
    }
}

