/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.PrimitiveArray;

public final class IntegerArray
extends PrimitiveArray {
    int[][] chunks;

    public IntegerArray(int n) {
        this.shift = n;
        this.CHUNK_SIZE = 1 << n;
        this.mask = this.CHUNK_SIZE - 1;
        this.chunks = new int[1][this.CHUNK_SIZE];
    }

    public IntegerArray() {
        this(12);
    }

    public IntegerArray(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            this.add(n2);
        }
    }

    public Object clone() {
        IntegerArray integerArray = new IntegerArray();
        integerArray.chunks = new int[this.chunks.length][this.CHUNK_SIZE];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, integerArray.chunks[i], 0, this.CHUNK_SIZE);
        }
        integerArray.chunkOffset = this.chunkOffset;
        integerArray.size = this.size;
        return integerArray;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, nArray, i << this.shift, i == this.chunks.length - 1 ? this.chunkOffset : this.CHUNK_SIZE);
        }
        return nArray;
    }

    public void add(int n) {
        if (this.chunkOffset >= this.CHUNK_SIZE) {
            int[][] nArrayArray = new int[this.chunks.length + 1][];
            for (int i = 0; i < this.chunks.length; ++i) {
                nArrayArray[i] = this.chunks[i];
            }
            nArrayArray[this.chunks.length] = new int[this.CHUNK_SIZE];
            this.chunks = nArrayArray;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = n;
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new Error("Attempt to get " + n + " greater than size " + this.size);
        }
        return this.chunks[n >> this.shift][n & this.mask];
    }

    @Override
    long lget(int n) {
        return this.get(n);
    }

    public void put(int n, int n2) {
        if (n >= this.size) {
            throw new Error("Attempt to put " + n + " greater than size " + this.size);
        }
        this.chunks[n >> this.shift][n & this.mask] = n2;
    }

    @Override
    void lput(int n, long l) {
        this.put(n, (int)l);
    }

    public void add(int n, int n2) {
        for (int i = 0; i < n + 1 - this.size; ++i) {
            this.add(0);
        }
        this.put(n, n2);
    }

    public void putAll(int n) {
        for (int i = 0; i < this.size; ++i) {
            this.put(i, n);
        }
    }

    public int memoryUsage() {
        return this.chunks.length * this.CHUNK_SIZE * 4;
    }
}

