/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.AbstractLruCache;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntEnumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public final class IntegerLruCache
extends AbstractLruCache {
    int[] values = new int[17];
    private boolean doCheck = true;

    public IntegerLruCache(int n) {
        super(n);
    }

    @Override
    Object getValuesArray() {
        return this.values;
    }

    @Override
    void allocNewValuesArray(int n) {
        super.allocNewValuesArray(n);
        this.values = new int[n];
    }

    @Override
    void put(long l, Object object, int n) {
        int[] nArray = (int[])object;
        this.put(l, nArray[n]);
    }

    public synchronized int get(long l) {
        int n = this.getIndexAndPromote(l);
        if (n != -1) {
            return this.values[n];
        }
        return -1;
    }

    public synchronized void put(long l, int n) {
        int n2 = this.putIndexAndPromote(l);
        this.values[n2] = n;
        this.checkRehash();
    }

    private void test() {
        Random random = new Random(23L);
        LruCache lruCache = new LruCache(1000);
        for (int i = 0; i < 50000; ++i) {
            long l = random.nextLong();
            int n = random.nextInt();
            if (this.get(l) != -1) continue;
            this.put(l, n);
            if (!this.doCheck) continue;
            lruCache.put(new Long(l), new Integer(n));
            if (this.get(l) == n) continue;
            throw new Error("found " + this.get(l) + " expected " + n);
        }
        if (this.doCheck) {
            Long[] longArray = lruCache.keySet().toArray(new Long[0]);
            for (int i = 0; i < longArray.length; ++i) {
                long l = longArray[i];
                int n = (Integer)lruCache.get(longArray[i]);
                if (this.get(l) == n) continue;
                throw new Error("at " + i + " found " + this.get(l) + " expected " + n + " key " + l);
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        IntegerLruCache integerLruCache = new IntegerLruCache(20);
        for (n2 = 0; n2 < 20; ++n2) {
            integerLruCache.put(n2, n2);
        }
        for (n2 = 19; n2 >= 0; --n2) {
            n = integerLruCache.get(n2);
            if (n2 == n) continue;
            throw new Error("j is " + n + " for i " + n2);
        }
        for (n2 = 20; n2 < 30; ++n2) {
            integerLruCache.put(n2, n2);
        }
        for (n2 = 0; n2 < 30; ++n2) {
            n = integerLruCache.get(n2);
            if (!(n2 >= 20 || n2 < 10 ? n2 != n : n != -1)) continue;
            throw new Error("j is " + n + " for i " + n2);
        }
        integerLruCache = new IntegerLruCache(1000);
        integerLruCache.test();
        IntEnumeration intEnumeration = integerLruCache.getKeys();
        while (intEnumeration.hasMoreElements()) {
            long l = intEnumeration.nextInt();
            if (integerLruCache.get(l) != -1) continue;
            throw new Error("uh oh");
        }
        System.out.println("finished!");
    }

    private class LruCache
    extends LinkedHashMap {
        int maxSize;

        LruCache(int n) {
            super(16, 0.75f, true);
            this.maxSize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.maxSize;
        }
    }
}

