/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.PrimitiveArray;

public final class LongArray
extends PrimitiveArray {
    long[][] chunks;

    public LongArray() {
        this.chunks = new long[1][this.CHUNK_SIZE];
    }

    public LongArray(int n, long l) {
        this.chunks = new long[1][this.CHUNK_SIZE];
        for (int i = 0; i < n; ++i) {
            this.add(l);
        }
    }

    public Object clone() {
        LongArray longArray = new LongArray();
        longArray.chunks = new long[this.chunks.length][this.CHUNK_SIZE];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, longArray.chunks[i], 0, this.CHUNK_SIZE);
        }
        longArray.chunkOffset = this.chunkOffset;
        longArray.size = this.size;
        return longArray;
    }

    public long[] toArray() {
        long[] lArray = new long[this.size()];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, lArray, i << this.shift, i == this.chunks.length - 1 ? this.chunkOffset : this.CHUNK_SIZE);
        }
        return lArray;
    }

    public void add(long l) {
        if (this.chunkOffset >= this.CHUNK_SIZE) {
            long[][] lArrayArray = new long[this.chunks.length + 1][];
            for (int i = 0; i < this.chunks.length; ++i) {
                lArrayArray[i] = this.chunks[i];
            }
            lArrayArray[this.chunks.length] = new long[this.CHUNK_SIZE];
            this.chunks = lArrayArray;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = l;
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    long lget(int n) {
        if (n >= this.size) {
            throw new Error("Attempt to get " + n + " greater than size " + this.size);
        }
        return this.chunks[n >> this.shift][n & this.mask];
    }

    public long get(int n) {
        return this.lget(n);
    }

    @Override
    void lput(int n, long l) {
        if (n >= this.size) {
            throw new Error("Attempt to put " + n + " greater than size " + this.size);
        }
        this.chunks[n >> this.shift][n & this.mask] = l;
    }

    public void put(int n, long l) {
        this.lput(n, l);
    }

    public void add(int n, long l) {
        for (int i = 0; i < n + 1 - this.size; ++i) {
            this.add(0L);
        }
        this.put(n, l);
    }

    public void putAll(long l) {
        for (int i = 0; i < this.size; ++i) {
            this.put(i, l);
        }
    }

    public int memoryUsage() {
        return this.chunks.length * this.CHUNK_SIZE * 8;
    }
}

