/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;

public class J9DDRImageModule
implements ImageModule {
    private final IProcess process;
    private final IModule delegate;
    private final String moduleNameOverride;

    public J9DDRImageModule(IProcess iProcess, IModule iModule, String string) {
        if (iModule == null) {
            throw new NullPointerException("Module cannot be null");
        }
        if (iProcess == null) {
            throw new NullPointerException("Process cannot be null");
        }
        this.process = iProcess;
        this.delegate = iModule;
        this.moduleNameOverride = string;
    }

    public J9DDRImageModule(IProcess iProcess, IModule iModule) {
        this(iProcess, iModule, null);
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.moduleNameOverride != null) {
            return this.moduleNameOverride;
        }
        try {
            return this.delegate.getName();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
    }

    public Properties getProperties() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.delegate.getProperties();
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, dataUnavailableException.getMessage()), dataUnavailableException);
        }
    }

    public Iterator getSections() {
        Collection<? extends IMemoryRange> collection = this.delegate.getMemoryRanges();
        ArrayList<J9DDRImageSection> arrayList = new ArrayList<J9DDRImageSection>(collection.size());
        for (IMemoryRange iMemoryRange : collection) {
            arrayList.add(new J9DDRImageSection(this.process, iMemoryRange.getBaseAddress(), iMemoryRange.getSize(), iMemoryRange.getName()));
        }
        return arrayList.iterator();
    }

    public Iterator<?> getSymbols() {
        Collection<? extends ISymbol> collection;
        try {
            collection = this.delegate.getSymbols();
        }
        catch (DataUnavailableException dataUnavailableException) {
            Collection<? extends IMemoryRange> collection2 = this.delegate.getMemoryRanges();
            long l = 0L;
            for (IMemoryRange iMemoryRange : collection2) {
                if (!iMemoryRange.getName().contains(".text")) continue;
                l = iMemoryRange.getBaseAddress();
                break;
            }
            return Collections.singletonList(new J9DDRCorruptData(this.process, dataUnavailableException.getMessage(), l)).iterator();
        }
        ArrayList<J9DDRImageSymbol> arrayList = new ArrayList<J9DDRImageSymbol>(collection.size());
        for (ISymbol iSymbol : collection) {
            arrayList.add(new J9DDRImageSymbol(iSymbol.getName(), new J9DDRImagePointer(this.process, iSymbol.getAddress())));
        }
        return arrayList.iterator();
    }

    public boolean equals(Object object) {
        if (object instanceof J9DDRImageModule) {
            J9DDRImageModule j9DDRImageModule = (J9DDRImageModule)object;
            if (!this.process.equals(j9DDRImageModule.process)) {
                return false;
            }
            return this.delegate.equals(j9DDRImageModule.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        try {
            return "ImageModule: " + this.getName();
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return "ImageModule: <couldn't get name>";
        }
    }

    public long getLoadAddress() throws DataUnavailable {
        return this.delegate.getLoadAddress();
    }
}

