/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.reflect.Method;

public abstract class DataType {
    protected static IProcess process;
    protected static byte SIZEOF_BOOL;
    protected static byte BITFIELD_FORMAT;
    static J9RASPointer J9RASPOINTER;
    protected static String pointerPackageName;
    protected static String structurePackageName;

    public static void init(IProcess iProcess, StructureReader structureReader) {
        process = iProcess;
        SIZEOF_BOOL = structureReader.getSizeOfBool();
        BITFIELD_FORMAT = structureReader.getBitFieldFormat();
        pointerPackageName = structureReader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_DOT_NAME);
        structurePackageName = structureReader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_DOT_NAME);
    }

    public static void setJ9RASPointer(J9RASPointer j9RASPointer) {
        J9RASPOINTER = j9RASPointer;
    }

    public static J9RASPointer getJ9RASPointer() {
        return J9RASPOINTER;
    }

    public static IProcess getProcess() {
        return process;
    }

    public static DataType getStructure(String string, long l) {
        if (l == 0L) {
            return null;
        }
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(pointerPackageName + "." + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName(UDATAPointer.class.getPackage().getName() + "." + string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw classNotFoundException;
                }
            }
            return (DataType)DataType.getStructure(clazz, l);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Cannot create the structure " + string, exception);
        }
    }

    public static DataType getStructure(String string, UDATA uDATA) {
        return DataType.getStructure(string, uDATA.longValue());
    }

    public static <T> T getStructure(Class<T> clazz, long l) {
        if (l == 0L) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod("cast", Long.TYPE);
            Object object = method.invoke(null, l);
            return (T)object;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Cannot create the structure " + clazz.getSimpleName(), exception);
        }
    }

    public abstract long longValue() throws CorruptDataException;

    public String formatShortInteractive() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName().toLowerCase());
        stringBuilder.append(": 0x");
        try {
            stringBuilder.append(Long.toHexString(this.longValue()));
        }
        catch (CorruptDataException corruptDataException) {
            stringBuilder.append("FAULT");
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            stringBuilder.append("<FAULT : " + invalidDataTypeException.getMessage() + ">");
        }
        stringBuilder.append(" (");
        try {
            stringBuilder.append(this.longValue());
        }
        catch (CorruptDataException corruptDataException) {
            stringBuilder.append("FAULT");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getPointerPackageName() {
        return pointerPackageName;
    }

    public static String getStructurePackageName() {
        return structurePackageName;
    }
}

