/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.IHashTable;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MonitorTableListEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;

public class MonitorTable
implements IHashTable<J9ObjectMonitorPointer> {
    protected HashTable<PointerPointer> monitorTable;
    protected HashMap<J9ObjectPointer, J9ObjectMonitorPointer> cachedMonitorTable;
    protected J9HashTablePointer hashTable;
    protected J9MonitorTableListEntryPointer monitorTableListEntry;

    protected MonitorTable(J9MonitorTableListEntryPointer j9MonitorTableListEntryPointer) throws CorruptDataException {
        HashTable.HashEqualFunction<PointerPointer> hashEqualFunction = MonitorTable.getEqualFunction();
        HashTable.HashFunction<PointerPointer> hashFunction = MonitorTable.getHashFunction();
        this.monitorTableListEntry = j9MonitorTableListEntryPointer;
        this.hashTable = j9MonitorTableListEntryPointer.monitorTable();
        this.monitorTable = HashTable.fromJ9HashTable(this.hashTable, true, PointerPointer.class, hashEqualFunction, hashFunction);
    }

    public J9HashTablePointer getJ9HashTablePointer() {
        return this.hashTable;
    }

    public String extraInfo() throws CorruptDataException {
        String string = "Default Monitor Table";
        return String.format("<%s>, \"%s\", itemCount=%d", this.monitorTableListEntry.formatShortInteractive(), string, this.getCount());
    }

    public J9MonitorTableListEntryPointer getMonitorTableListEntryPointer() {
        return this.monitorTableListEntry;
    }

    public static MonitorTable from(J9MonitorTableListEntryPointer j9MonitorTableListEntryPointer) throws CorruptDataException {
        return new MonitorTable(j9MonitorTableListEntryPointer);
    }

    private static HashTable.HashFunction<PointerPointer> getHashFunction() {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_MONITOR_HASH_FUNCTION_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new MonitorHashFunction_V1();
    }

    private static HashTable.HashEqualFunction<PointerPointer> getEqualFunction() {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_MONITOR_EQUAL_FUNCTION_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new MonitorEqualFunction_V1();
    }

    @Override
    public SlotIterator<J9ObjectMonitorPointer> iterator() {
        return new SlotIterator<J9ObjectMonitorPointer>(){
            SlotIterator<PointerPointer> monitorTableIterator;
            {
                this.monitorTableIterator = MonitorTable.this.monitorTable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.monitorTableIterator.hasNext();
            }

            @Override
            public J9ObjectMonitorPointer next() {
                return J9ObjectMonitorPointer.cast((AbstractPointer)this.monitorTableIterator.next());
            }

            @Override
            public VoidPointer nextAddress() {
                return this.monitorTableIterator.nextAddress();
            }

            @Override
            public void remove() {
                this.monitorTableIterator.remove();
            }
        };
    }

    @Override
    public long getCount() {
        return this.monitorTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.monitorTable.getTableName();
    }

    public J9ObjectMonitorPointer peek(J9ObjectPointer j9ObjectPointer) {
        if (this.cachedMonitorTable == null) {
            this.initializedCachedMonitorTable();
        }
        return this.cachedMonitorTable.get(j9ObjectPointer);
    }

    private void initializedCachedMonitorTable() {
        this.cachedMonitorTable = new HashMap();
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                J9ObjectMonitorPointer j9ObjectMonitorPointer = (J9ObjectMonitorPointer)iterator.next();
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(j9ObjectMonitorPointer.monitor().userData());
                this.cachedMonitorTable.put(j9ObjectPointer, j9ObjectMonitorPointer);
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error building cached monitor table", corruptDataException, false);
        }
    }

    protected static class MonitorEqualFunction_V1
    implements HashTable.HashEqualFunction<PointerPointer> {
        protected MonitorEqualFunction_V1() {
        }

        @Override
        public boolean equal(PointerPointer pointerPointer, PointerPointer pointerPointer2) {
            try {
                J9ObjectMonitorPointer j9ObjectMonitorPointer = J9ObjectMonitorPointer.cast(pointerPointer);
                J9ObjectMonitorPointer j9ObjectMonitorPointer2 = J9ObjectMonitorPointer.cast(pointerPointer2);
                J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast(j9ObjectMonitorPointer.monitor());
                J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer2 = J9ThreadAbstractMonitorPointer.cast(j9ObjectMonitorPointer2.monitor());
                return j9ThreadAbstractMonitorPointer.userData().eq(j9ThreadAbstractMonitorPointer2.userData());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error checking equality", corruptDataException, true);
                return false;
            }
        }
    }

    protected static class MonitorHashFunction_V1
    implements HashTable.HashFunction<PointerPointer> {
        protected MonitorHashFunction_V1() {
        }

        @Override
        public UDATA hash(PointerPointer pointerPointer) {
            try {
                J9ObjectMonitorPointer j9ObjectMonitorPointer = J9ObjectMonitorPointer.cast(pointerPointer);
                J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast(j9ObjectMonitorPointer.monitor());
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(j9ThreadAbstractMonitorPointer.userData());
                return new UDATA(ObjectAccessBarrier.getObjectHashCode(j9ObjectPointer));
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", corruptDataException, false);
                return new UDATA(0L);
            }
        }
    }
}

