/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPuddleListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPuddlePointer;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public class Pool_29_V0<StructType extends DataType>
extends Pool<StructType>
implements SlotIterator<StructType> {
    private static int POOLSTATE_FOLLOW_NEXT_POINTERS = 1;
    private final boolean isInline;
    private final State state = new State();
    private int slot = 0;
    private VoidPointer nextItem = null;
    StructType nextStruct = null;
    boolean inited = false;

    protected <T extends DataType> Pool_29_V0(J9PoolPointer j9PoolPointer, Class<T> clazz, boolean bl) throws CorruptDataException {
        super(j9PoolPointer, clazz);
        this.isInline = bl;
    }

    @Override
    public boolean includesElement(StructType StructType) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public SlotIterator<StructType> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextStruct != null) {
            return true;
        }
        try {
            this.nextItem = !this.inited ? this.pool_startDo() : this.pool_nextDo();
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error creating iterator", corruptDataException, true);
            this.nextItem = null;
        }
        finally {
            this.inited = true;
        }
        while (this.nextItem != null && this.nextItem.notNull()) {
            try {
                if (!this.isInline) {
                    PointerPointer pointerPointer = PointerPointer.cast(this.nextItem);
                    this.nextItem = pointerPointer.at(0L);
                }
                this.nextStruct = (DataType)DataType.getStructure(this.structType, this.nextItem.getAddress());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next pool item", corruptDataException, false);
            }
            if (this.nextStruct != null) break;
            try {
                this.nextItem = this.pool_nextDo();
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error creating iterator", corruptDataException, true);
                this.nextItem = null;
            }
        }
        return this.nextStruct != null;
    }

    @Override
    public StructType next() {
        if (this.hasNext()) {
            StructType StructType = this.nextStruct;
            this.nextStruct = null;
            return StructType;
        }
        throw new NoSuchElementException();
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            this.nextStruct = null;
            return this.nextItem;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long numElements() {
        try {
            return J9PoolPuddleListPointer.cast(this.pool.puddleList()).numElements().longValue();
        }
        catch (CorruptDataException corruptDataException) {
            return 0L;
        }
    }

    @Override
    public long capacity() {
        long l = 0L;
        try {
            J9PoolPuddleListPointer j9PoolPuddleListPointer = J9PoolPuddleListPointer.cast(this.pool.puddleList());
            J9PoolPuddlePointer j9PoolPuddlePointer = j9PoolPuddleListPointer.nextPuddle();
            while (!j9PoolPuddlePointer.isNull()) {
                l += this.pool.elementsPerPuddle().longValue();
                j9PoolPuddlePointer = j9PoolPuddlePointer.nextPuddle();
            }
        }
        catch (CorruptDataException corruptDataException) {
            return 0L;
        }
        return l;
    }

    private VoidPointer pool_startDo() throws CorruptDataException {
        this.slot = 0;
        J9PoolPuddleListPointer j9PoolPuddleListPointer = J9PoolPuddleListPointer.cast(this.pool.puddleList());
        return this.poolPuddle_startDo(j9PoolPuddleListPointer.nextPuddle(), true);
    }

    private VoidPointer poolPuddle_startDo(J9PoolPuddlePointer j9PoolPuddlePointer, boolean bl) throws CorruptDataException {
        UDATAPointer uDATAPointer = null;
        if (this.pool.isNull() || j9PoolPuddlePointer.isNull()) {
            return null;
        }
        if (j9PoolPuddlePointer.usedElements().longValue() == 0L) {
            if (j9PoolPuddlePointer.nextPuddle().notNull() && bl) {
                return this.poolPuddle_startDo(j9PoolPuddlePointer.nextPuddle(), bl);
            }
            return null;
        }
        while (this.isPuddleSlotFree(j9PoolPuddlePointer)) {
            ++this.slot;
        }
        uDATAPointer = UDATAPointer.cast(j9PoolPuddlePointer.firstElementAddress().getAddress() + this.elementSize * (long)this.slot);
        this.state.currentPuddle = j9PoolPuddlePointer;
        this.state.lastSlot = this.slot;
        this.state.leftToDo = j9PoolPuddlePointer.usedElements().intValue() - 1;
        this.state.flags = 0;
        if (bl) {
            this.state.flags |= POOLSTATE_FOLLOW_NEXT_POINTERS;
        }
        if (this.state.leftToDo == 0) {
            if (bl) {
                this.state.currentPuddle = this.state.currentPuddle.nextPuddle();
                this.state.lastSlot = -1;
            } else {
                this.state.currentPuddle = null;
            }
        }
        logger.fine(String.format("Next pool item 0x%016x", uDATAPointer.getAddress()));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.state.toString());
        }
        return VoidPointer.cast(uDATAPointer);
    }

    private boolean isPuddleSlotFree(J9PoolPuddlePointer j9PoolPuddlePointer) throws CorruptDataException {
        int n;
        U32Pointer u32Pointer = U32Pointer.cast(j9PoolPuddlePointer.add(1L));
        long l = (u32Pointer = u32Pointer.add(this.slot / 32)).at(0L).longValue();
        return (l & (long)(n = 1 << 31 - this.slot % 32)) != 0L;
    }

    private VoidPointer pool_nextDo() throws CorruptDataException {
        this.slot = 1 + this.state.lastSlot;
        UDATAPointer uDATAPointer = null;
        if (this.state.leftToDo == 0) {
            if (this.state.currentPuddle != null && this.state.currentPuddle.notNull()) {
                return this.poolPuddle_startDo(this.state.currentPuddle, true);
            }
            return null;
        }
        while (this.isPuddleSlotFree(this.state.currentPuddle)) {
            ++this.slot;
        }
        uDATAPointer = UDATAPointer.cast(this.state.currentPuddle.firstElementAddress().getAddress() + this.elementSize * (long)this.slot);
        this.state.lastSlot = this.slot;
        --this.state.leftToDo;
        if (this.state.leftToDo == 0) {
            if ((this.state.flags & POOLSTATE_FOLLOW_NEXT_POINTERS) == POOLSTATE_FOLLOW_NEXT_POINTERS) {
                this.state.currentPuddle = this.state.currentPuddle.nextPuddle();
                this.state.lastSlot = -1;
            } else {
                this.state.currentPuddle = null;
            }
        }
        logger.fine(String.format("Next pool item 0x%016x", uDATAPointer.getAddress()));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.state.toString());
        }
        return VoidPointer.cast(uDATAPointer);
    }

    private class State {
        J9PoolPuddlePointer currentPuddle = null;
        int lastSlot = 0;
        int leftToDo = 0;
        int flags = 0;

        private State() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Pool walker state\n\tCurrent Puddle : 0x");
            stringBuilder.append(Long.toHexString(this.currentPuddle.getAddress()));
            stringBuilder.append("\n\tLast Slot : ");
            stringBuilder.append(this.lastSlot);
            stringBuilder.append("\n\tLeft to do : ");
            stringBuilder.append(this.leftToDo);
            stringBuilder.append("\n\tFlags : ");
            stringBuilder.append(this.flags);
            return stringBuilder.toString();
        }
    }
}

