/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolIterator;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySubSpaceGenericPointer;
import java.util.NoSuchElementException;

class GCStandardMemoryPoolIterator
extends GCMemoryPoolIterator {
    protected MM_MemoryPoolPointer _currentMemoryPool = null;
    protected GCHeapRegionIterator _regionIterator = null;
    protected GCHeapRegionDescriptor _region = null;
    private IteratorState _state = IteratorState.mm_heapmp_iterator_next_region;

    public GCStandardMemoryPoolIterator() throws CorruptDataException {
        this._regionIterator = GCHeapRegionIterator.from();
        this.advancePool();
    }

    private void advancePool() {
        try {
            boolean bl = false;
            MM_MemoryPoolPointer mM_MemoryPoolPointer = null;
            while (!bl && this._regionIterator.hasNext()) {
                switch (this._state) {
                    case mm_heapmp_iterator_next_region: {
                        this._region = this._regionIterator.next();
                        MM_MemorySubSpaceGenericPointer mM_MemorySubSpaceGenericPointer = MM_MemorySubSpaceGenericPointer.cast(this._region.getSubSpace());
                        if (!mM_MemorySubSpaceGenericPointer.notNull() || !(mM_MemoryPoolPointer = mM_MemorySubSpaceGenericPointer._memoryPool()).notNull()) break;
                        if (mM_MemoryPoolPointer._children().notNull()) {
                            mM_MemoryPoolPointer = mM_MemoryPoolPointer._children();
                        }
                        this._state = IteratorState.mm_heapmp_iterator_next_memory_pool;
                        bl = true;
                        break;
                    }
                    case mm_heapmp_iterator_next_memory_pool: {
                        mM_MemoryPoolPointer = this._currentMemoryPool._next();
                        if (mM_MemoryPoolPointer.isNull()) {
                            this._state = IteratorState.mm_heapmp_iterator_next_region;
                            break;
                        }
                        bl = true;
                    }
                }
            }
            this._currentMemoryPool = bl ? mM_MemoryPoolPointer : null;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Memory Pool corruption detected", corruptDataException, false);
            this._currentMemoryPool = null;
        }
    }

    @Override
    public GCMemoryPool next() {
        GCMemoryPool gCMemoryPool = null;
        if (this.hasNext()) {
            try {
                gCMemoryPool = GCMemoryPool.fromMemoryPoolPointerInRegion(this._region, this._currentMemoryPool);
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Memory Pool corruption detected", corruptDataException, false);
            }
            this.advancePool();
            return gCMemoryPool;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public boolean hasNext() {
        return null != this._currentMemoryPool;
    }

    @Override
    public String toString() {
        GCStandardMemoryPoolIterator gCStandardMemoryPoolIterator = null;
        try {
            gCStandardMemoryPoolIterator = new GCStandardMemoryPoolIterator();
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption detected", corruptDataException, false);
            return corruptDataException.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        while (gCStandardMemoryPoolIterator.hasNext()) {
            stringBuilder.append(gCStandardMemoryPoolIterator.next() + string);
        }
        return stringBuilder.toString();
    }

    static enum IteratorState {
        mm_heapmp_iterator_next_region,
        mm_heapmp_iterator_next_memory_pool,
        NULL;

    }
}

