/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMSystemPropertyPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import java.util.Iterator;
import java.util.Properties;

public class J9JavaVMHelper {
    public static Properties getSystemProperties(J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        Properties properties = new Properties();
        Pool<J9VMSystemPropertyPointer> pool = Pool.fromJ9Pool(j9JavaVMPointer.systemProperties(), J9VMSystemPropertyPointer.class);
        SlotIterator<J9VMSystemPropertyPointer> slotIterator = pool.iterator();
        int n = 0;
        while (slotIterator.hasNext()) {
            J9VMSystemPropertyPointer j9VMSystemPropertyPointer = (J9VMSystemPropertyPointer)slotIterator.next();
            if (j9VMSystemPropertyPointer != null) {
                String string = null;
                try {
                    string = j9VMSystemPropertyPointer.name().getCStringAtOffset(0L);
                }
                catch (CorruptDataException corruptDataException) {
                    string = "Corrupt System Property[" + n + "]";
                }
                String string2 = null;
                try {
                    string2 = j9VMSystemPropertyPointer.value().getCStringAtOffset(0L);
                }
                catch (CorruptDataException corruptDataException) {
                    string2 = "Corrupt Value";
                }
                properties.setProperty(string, string2);
            }
            ++n;
        }
        return properties;
    }

    public static J9MethodPointer getMethodFromPC(J9JavaVMPointer j9JavaVMPointer, U8Pointer u8Pointer) throws CorruptDataException {
        GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
        while (gCClassLoaderIterator.hasNext()) {
            J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
            Iterator<J9ClassPointer> iterator = ClassIterator.fromJ9Classloader(j9ClassLoaderPointer);
            while (iterator.hasNext()) {
                J9ClassPointer j9ClassPointer = iterator.next();
                J9MethodPointer j9MethodPointer = J9ClassHelper.getMethodFromPCAndClass(j9ClassPointer, u8Pointer);
                if (j9MethodPointer.isNull()) continue;
                return j9MethodPointer;
            }
        }
        return J9MethodPointer.NULL;
    }

    public static boolean extendedRuntimeFlagIsSet(J9JavaVMPointer j9JavaVMPointer, long l) throws CorruptDataException {
        return j9JavaVMPointer.extendedRuntimeFlags().allBitsIn(l);
    }
}

