/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.math.BigInteger;

public class UDATA
extends UScalar {
    public static final int SIZEOF = J9BuildFlags.env_data64 ? 8 : 4;
    public static final long MASK = SIZEOF == 8 ? -1L : 0xFFFFFFFFL;
    public static final UDATA MIN = new UDATA(0L);
    public static final UDATA MAX = SIZEOF == 8 ? new UDATA(-1L) : new UDATA(0xFFFFFFFFL);

    public UDATA(long l) {
        super(l & MASK);
    }

    public UDATA(Scalar scalar) {
        super(scalar);
    }

    public UDATA add(long l) {
        return new UDATA(this.data + l);
    }

    public UDATA add(UScalar uScalar) {
        return new UDATA(this.data + uScalar.data);
    }

    public U64 add(U64 u64) {
        return new U64(this).add(u64);
    }

    public UDATA add(IScalar iScalar) {
        return this.add(new UDATA(iScalar));
    }

    public boolean eq(IScalar iScalar) {
        return this.eq(new UDATA(iScalar));
    }

    public UDATA sub(long l) {
        return new UDATA(this.data - l);
    }

    public UDATA sub(UScalar uScalar) {
        return new UDATA(this.data - uScalar.data);
    }

    public U64 sub(U64 u64) {
        return new U64(this).sub(u64);
    }

    public UDATA sub(I8 i8) {
        return this.sub(new UDATA(i8));
    }

    public UDATA sub(I16 i16) {
        return this.sub(new UDATA(i16));
    }

    public UDATA sub(I32 i32) {
        return this.sub(new UDATA(i32));
    }

    public UDATA sub(IDATA iDATA) {
        return this.sub(new UDATA(iDATA));
    }

    @Override
    public int intValue() {
        long l = this.data;
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new InvalidDataTypeException("UDATA contains value larger than Integer.MAX_VALUE");
        }
        return (int)l;
    }

    public UDATA bitOr(int n) {
        return new UDATA(this.data | (long)n);
    }

    public UDATA bitOr(long l) {
        return new UDATA(this.data | l);
    }

    public UDATA bitOr(UScalar uScalar) {
        return new UDATA(this.data | uScalar.data);
    }

    public U64 bitOr(U64 u64) {
        return new U64(this).bitOr(u64);
    }

    public UDATA bitOr(I8 i8) {
        return this.bitOr(new UDATA(i8));
    }

    public UDATA bitOr(I16 i16) {
        return this.bitOr(new UDATA(i16));
    }

    public UDATA bitOr(I32 i32) {
        return this.bitOr(new UDATA(i32));
    }

    public UDATA bitOr(IDATA iDATA) {
        return this.bitOr(new UDATA(iDATA));
    }

    public UDATA bitXor(int n) {
        return new UDATA(this.data ^ (long)n);
    }

    public UDATA bitXor(long l) {
        return new UDATA(this.data ^ l);
    }

    public UDATA bitXor(Scalar scalar) {
        return this.bitXor(new UDATA(scalar));
    }

    public UDATA bitXor(UDATA uDATA) {
        return new UDATA(this.data ^ uDATA.data);
    }

    public I64 bitXor(I64 i64) {
        return new I64(this).bitXor(i64);
    }

    public U64 bitXor(U64 u64) {
        return new U64(this).bitXor(u64);
    }

    public UDATA bitAnd(int n) {
        return new UDATA(this.data & (long)n);
    }

    public UDATA bitAnd(long l) {
        return new UDATA(this.data & l);
    }

    public UDATA bitAnd(UScalar uScalar) {
        return new UDATA(this.data & uScalar.data);
    }

    public U64 bitAnd(U64 u64) {
        return new U64(this).bitAnd(u64);
    }

    public UDATA bitAnd(I8 i8) {
        return this.bitAnd(new UDATA(i8));
    }

    public UDATA bitAnd(I16 i16) {
        return this.bitAnd(new UDATA(i16));
    }

    public UDATA bitAnd(I32 i32) {
        return this.bitAnd(new UDATA(i32));
    }

    public UDATA bitAnd(IDATA iDATA) {
        return this.bitAnd(new UDATA(iDATA));
    }

    public UDATA leftShift(int n) {
        return new UDATA(this.data << n);
    }

    public UDATA leftShift(UDATA uDATA) {
        return new UDATA(this.data << (int)uDATA.longValue());
    }

    public UDATA rightShift(int n) {
        return new UDATA(this.data >>> n);
    }

    public UDATA rightShift(UDATA uDATA) {
        return new UDATA(this.data >>> (int)uDATA.longValue());
    }

    public UDATA bitNot() {
        return new UDATA(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public UDATA mult(int n) {
        return new UDATA(this.data * (long)n);
    }

    public UDATA mult(long l) {
        return new UDATA(this.data * l);
    }

    public UDATA mult(UDATA uDATA) {
        return this.mult(uDATA.longValue());
    }

    public UDATA mod(int n) {
        return this.mod((long)n);
    }

    public UDATA mod(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("mod by negative number is not supported, yet");
        }
        if (this.data < 0L && 8 == this.sizeof()) {
            long l2 = this.data & 1L;
            long l3 = this.data >>> 1;
            long l4 = (l3 % l * 2L + l2) % l;
            return new UDATA(l4);
        }
        return new UDATA(this.data % l);
    }

    public UDATA mod(Scalar scalar) {
        return this.mod(scalar.longValue());
    }

    public UDATA div(long l) {
        long l2 = this.data;
        if (l >= 0L && l2 >= 0L) {
            return new UDATA(l2 / l);
        }
        BigInteger bigInteger = new BigInteger(Long.toHexString(l2), 16);
        BigInteger bigInteger2 = new BigInteger(Long.toHexString(l), 16);
        return new UDATA(bigInteger.divide(bigInteger2).longValue());
    }

    public UDATA div(Scalar scalar) {
        return this.div(scalar.longValue());
    }

    public int numberOfLeadingZeros() {
        int n = Long.numberOfLeadingZeros(this.data);
        int n2 = 64 - SIZEOF * 8;
        return n - n2;
    }

    public int numberOfTrailingZeros() {
        if (0L == this.data) {
            return SIZEOF * 8;
        }
        int n = Long.numberOfTrailingZeros(this.data);
        return n;
    }

    public static UDATA cast(AbstractPointer abstractPointer) {
        if (abstractPointer != null) {
            return new UDATA(abstractPointer.getAddress());
        }
        return new UDATA(0L);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }
}

