/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.java.IDTFJJavaField;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import java.util.HashMap;
import java.util.Map;

public abstract class DTFJJavaField
implements JavaField,
IDTFJJavaField {
    protected static final Class<?>[] whitelist = new Class[]{IllegalArgumentException.class};
    protected static final int FIELD_BOOLEAN = 1;
    protected static final int FIELD_BYTE = 2;
    protected static final int FIELD_SHORT = 4;
    protected static final int FIELD_CHAR = 8;
    protected static final int FIELD_INTEGER = 16;
    protected static final int FIELD_FLOAT = 32;
    protected static final int FIELD_LONG = 64;
    protected static final int FIELD_DOUBLE = 128;
    protected static final int FIELD_ARRAY = 256;
    protected static final int FIELD_OBJECT = 512;
    protected final J9ROMFieldShapePointer j9field;
    protected final J9ObjectFieldOffset fieldOffset;
    protected final String name;
    protected DTFJJavaClass clazz = null;
    protected int modifiers = 0;
    private char sigFlag = '\u0000';
    private static Map<J9ROMFieldShapePointer, String> signatureCache = new HashMap<J9ROMFieldShapePointer, String>();

    public DTFJJavaField(DTFJJavaClass dTFJJavaClass, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        this.clazz = dTFJJavaClass;
        this.fieldOffset = j9ObjectFieldOffset;
        this.j9field = j9ObjectFieldOffset.getField();
        this.modifiers = J9ROMFieldShapeHelper.getReflectModifiers(this.j9field);
        this.name = J9ROMFieldShapeHelper.getName(this.j9field);
    }

    protected char getSigFlag() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.sigFlag == '\u0000') {
                this.sigFlag = this.getSignature().charAt(0);
            }
            switch (this.sigFlag) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': 
                case 'Z': 
                case '[': {
                    return this.sigFlag;
                }
            }
            throw J9DDRDTFJUtils.newCorruptDataException(DTFJContext.getProcess(), new CorruptDataException("Signature flag for this field is invalid: " + this.sigFlag + String.format("[\\u%04x]", this.sigFlag)));
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    protected DTFJJavaObject validateJavaObject(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException {
        if (!(javaObject instanceof DTFJJavaObject)) {
            throw new IllegalArgumentException(String.format("Unregonised JavaObject implementor : %s", javaObject.getClass().getName()));
        }
        if (!this.isAncestorOf(javaObject.getJavaClass())) {
            throw new IllegalArgumentException("The class for the JavaObject specified as a parameter does not match with the declaring class of this JavaField.");
        }
        return (DTFJJavaObject)javaObject;
    }

    protected long checkDataTypeConversion(DTFJJavaObject dTFJJavaObject, int n) throws com.ibm.dtfj.image.CorruptDataException {
        try {
            switch (this.getSigFlag()) {
                case 'Z': {
                    if ((n & 1) != 1) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return 0L;
                }
                case 'B': {
                    if ((n & 2) != 2) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getByteField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case 'C': {
                    if ((n & 8) != 8) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getCharField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case 'S': {
                    if ((n & 4) != 4) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getShortField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case 'I': {
                    if ((n & 0x10) != 16) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getIntField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case 'F': {
                    if ((n & 0x20) != 32) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getIntField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case 'J': {
                    if ((n & 0x40) != 64) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getLongField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case 'D': {
                    if ((n & 0x80) != 128) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return J9ObjectHelper.getLongField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                }
                case '[': {
                    if ((n & 0x100) != 256) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return 0L;
                }
                case 'L': {
                    if ((n & 0x200) != 512) {
                        throw new IllegalArgumentException(String.format("The field type : %c cannot be converted to the requested data type", Character.valueOf(this.sigFlag)));
                    }
                    return 0L;
                }
            }
            throw new IllegalArgumentException("Cannot determine the correct data size");
        }
        catch (CorruptDataException corruptDataException) {
            throw J9DDRDTFJUtils.newCorruptDataException(DTFJContext.getProcess(), corruptDataException);
        }
    }

    protected boolean isAncestorOf(JavaClass javaClass) {
        if (null == javaClass) {
            return false;
        }
        if (this.clazz.equals(javaClass)) {
            return true;
        }
        try {
            return this.isAncestorOf(javaClass.getSuperclass());
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return false;
        }
    }

    public JavaClass getDeclaringClass() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        if (this.clazz == null) {
            throw new DataUnavailable("The declaring class is not available");
        }
        return this.clazz;
    }

    public int getModifiers() throws com.ibm.dtfj.image.CorruptDataException {
        return this.modifiers;
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        return this.name;
    }

    @Override
    public String getSignature() throws com.ibm.dtfj.image.CorruptDataException {
        String string = signatureCache.get(this.j9field);
        if (null == string) {
            try {
                string = J9ROMFieldShapeHelper.getSignature(this.j9field);
                signatureCache.put(this.j9field, string);
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaField) {
            boolean bl2;
            JavaField javaField = (JavaField)object;
            try {
                bl2 = this.name.equals(javaField.getName());
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                bl2 = false;
            }
            try {
                bl = bl2 && this.getClass().equals(javaField.getClass()) && this.clazz.equals(javaField.getDeclaringClass());
            }
            catch (Throwable throwable) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.getName());
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            stringBuilder.append("Instance Field [unknown name]");
        }
        stringBuilder.append(" @0x");
        stringBuilder.append(Long.toHexString(this.j9field.getAddress()));
        return stringBuilder.toString();
    }
}

