/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMR_VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9VMThread;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJJavaSystemMonitor
implements JavaMonitor {
    private final Logger log = DTFJContext.getLogger();
    private final J9ThreadMonitorPointer monitor;
    private String name = null;

    public DTFJJavaSystemMonitor(J9ThreadMonitorPointer j9ThreadMonitorPointer) {
        this.monitor = j9ThreadMonitorPointer;
        this.log.fine(String.format("Created object monitor 0x%016x", j9ThreadMonitorPointer.getAddress()));
    }

    public Iterator getEnterWaiters() {
        try {
            return this.scanThreads(J9VMThread.J9VMTHREAD_STATE_BLOCKED);
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    public ImagePointer getID() {
        return DTFJContext.getImagePointer(this.monitor.getAddress());
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.name == null) {
            try {
                this.name = this.monitor.name().getCStringAtOffset(0L);
            }
            catch (MemoryFault memoryFault) {
                this.name = "Unknown monitor name";
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return this.name;
    }

    public Iterator getNotifyWaiters() {
        try {
            return this.scanThreads(J9VMThread.J9VMTHREAD_STATE_WAITING);
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    public JavaObject getObject() {
        try {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(this.monitor.userData());
            if (j9ObjectPointer.isNull()) {
                return null;
            }
            return new DTFJJavaObject(j9ObjectPointer);
        }
        catch (Throwable throwable) {
            this.log.log(Level.FINE, "Throwable when getting object", throwable);
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            return null;
        }
    }

    public JavaThread getOwner() throws com.ibm.dtfj.image.CorruptDataException {
        DTFJJavaThread dTFJJavaThread = null;
        try {
            J9ThreadPointer j9ThreadPointer = this.monitor.owner();
            if (!j9ThreadPointer.isNull()) {
                int n = DTFJContext.getVm().omrVM()._vmThreadKey().intValue() - 1;
                OMR_VMThreadPointer oMR_VMThreadPointer = OMR_VMThreadPointer.cast(j9ThreadPointer.tlsEA().at(n));
                if (!oMR_VMThreadPointer.isNull()) {
                    dTFJJavaThread = new DTFJJavaThread(J9VMThreadPointer.cast(oMR_VMThreadPointer._language_vmthread()));
                }
            }
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return dTFJJavaThread;
    }

    private Iterator<DTFJJavaThread> scanThreads(long l) throws CorruptDataException {
        List<J9VMThreadPointerUtil.ThreadInfo> list = DTFJContext.getThreadInfoCache();
        ArrayList<DTFJJavaThread> arrayList = new ArrayList<DTFJJavaThread>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                J9VMThreadPointerUtil.ThreadInfo threadInfo = list.get(i);
                if ((threadInfo.getState() & l) == 0L || threadInfo.getRawLock() == null || !threadInfo.getRawLock().eq(this.monitor)) continue;
                DTFJJavaThread dTFJJavaThread = new DTFJJavaThread(threadInfo.getThread());
                arrayList.add(dTFJJavaThread);
                continue;
            }
            catch (Throwable throwable) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return arrayList.iterator();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTFJJavaSystemMonitor)) {
            return false;
        }
        DTFJJavaSystemMonitor dTFJJavaSystemMonitor = (DTFJJavaSystemMonitor)object;
        return this.monitor.eq(dTFJJavaSystemMonitor.monitor);
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }
}

