/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.internal.BaseRow;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;

public class Row
extends BaseRow
implements Serializable,
Cloneable {
    static final long serialVersionUID = 5047859032611314762L;
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    public Row(int n) {
        this.origVals = new Object[n];
        this.currentVals = new Object[n];
        this.colsChanged = new BitSet(n);
        this.numCols = n;
    }

    public Row(int n, Object[] objectArray) {
        this.origVals = new Object[n];
        System.arraycopy((Object)objectArray, 0, (Object)this.origVals, 0, n);
        this.currentVals = new Object[n];
        this.colsChanged = new BitSet(n);
        this.numCols = n;
    }

    public void initColumnObject(int n, Object object) {
        this.origVals[n - 1] = object;
    }

    @Override
    public void setColumnObject(int n, Object object) {
        this.currentVals[n - 1] = object;
        this.setColUpdated(n - 1);
    }

    @Override
    public Object getColumnObject(int n) throws SQLException {
        if (this.getColUpdated(n - 1)) {
            return this.currentVals[n - 1];
        }
        return this.origVals[n - 1];
    }

    public boolean getColUpdated(int n) {
        return this.colsChanged.get(n);
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void clearDeleted() {
        this.deleted = false;
    }

    public void setInserted() {
        this.inserted = true;
    }

    public boolean getInserted() {
        return this.inserted;
    }

    public void clearInserted() {
        this.inserted = false;
    }

    public boolean getUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        for (int i = 0; i < this.numCols; ++i) {
            if (!this.getColUpdated(i)) continue;
            this.updated = true;
            return;
        }
    }

    private void setColUpdated(int n) {
        this.colsChanged.set(n);
    }

    public void clearUpdated() {
        this.updated = false;
        for (int i = 0; i < this.numCols; ++i) {
            this.currentVals[i] = null;
            this.colsChanged.clear(i);
        }
    }

    public void moveCurrentToOrig() {
        for (int i = 0; i < this.numCols; ++i) {
            if (!this.getColUpdated(i)) continue;
            this.origVals[i] = this.currentVals[i];
            this.currentVals[i] = null;
            this.colsChanged.clear(i);
        }
        this.updated = false;
    }

    public BaseRow getCurrentRow() {
        return null;
    }
}

