/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import com.sun.security.jgss.AuthorizationDataEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import org.ietf.jgss.GSSException;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerValue;

class InitSecContextToken
extends InitialToken {
    private static final boolean ACCEPTOR_USE_INITIATOR_SEQNUM;
    private KrbApReq apReq = null;

    InitSecContextToken(Krb5Context krb5Context, Credentials credentials, Credentials credentials2) throws KrbException, IOException, GSSException {
        boolean bl = krb5Context.getMutualAuthState();
        boolean bl2 = true;
        boolean bl3 = true;
        InitialToken.OverloadedChecksum overloadedChecksum = new InitialToken.OverloadedChecksum(this, krb5Context, credentials, credentials2);
        Checksum checksum = overloadedChecksum.getChecksum();
        krb5Context.setTktFlags(credentials2.getFlags());
        krb5Context.setAuthTime(new KerberosTime(credentials2.getAuthTime()).toString());
        this.apReq = new KrbApReq(credentials2, bl, bl2, bl3, checksum);
        krb5Context.resetMySequenceNumber(this.apReq.getSeqNumber());
        EncryptionKey encryptionKey = this.apReq.getSubKey();
        if (encryptionKey != null) {
            krb5Context.setKey(1, encryptionKey);
        } else {
            krb5Context.setKey(0, credentials2.getSessionKey());
        }
        if (!bl) {
            krb5Context.resetPeerSequenceNumber(ACCEPTOR_USE_INITIATOR_SEQNUM ? this.apReq.getSeqNumber() : 0);
        }
    }

    InitSecContextToken(Krb5Context krb5Context, Krb5AcceptCredential krb5AcceptCredential, InputStream inputStream) throws IOException, GSSException, KrbException {
        Serializable serializable;
        int n = inputStream.read() << 8 | inputStream.read();
        if (n != 256) {
            throw new GSSException(10, -1, "AP_REQ token id does not match!");
        }
        byte[] byArray = new DerValue(inputStream).toByteArray();
        InetAddress inetAddress = null;
        if (krb5Context.getChannelBinding() != null) {
            inetAddress = krb5Context.getChannelBinding().getInitiatorAddress();
        }
        this.apReq = new KrbApReq(byArray, krb5AcceptCredential, inetAddress);
        EncryptionKey encryptionKey = this.apReq.getCreds().getSessionKey();
        EncryptionKey encryptionKey2 = this.apReq.getSubKey();
        if (encryptionKey2 != null) {
            krb5Context.setKey(1, encryptionKey2);
        } else {
            krb5Context.setKey(0, encryptionKey);
        }
        InitialToken.OverloadedChecksum overloadedChecksum = new InitialToken.OverloadedChecksum(this, krb5Context, this.apReq.getChecksum(), encryptionKey, encryptionKey2);
        overloadedChecksum.setContextFlags(krb5Context);
        Credentials credentials = overloadedChecksum.getDelegatedCreds();
        if (credentials != null) {
            serializable = Krb5InitCredential.getInstance((Krb5NameElement)krb5Context.getSrcName(), credentials);
            krb5Context.setDelegCred((Krb5CredElement)((Object)serializable));
        }
        int n2 = (serializable = this.apReq.getSeqNumber()) != null ? (Integer)serializable : 0;
        krb5Context.resetPeerSequenceNumber(n2);
        if (!krb5Context.getMutualAuthState()) {
            krb5Context.resetMySequenceNumber(ACCEPTOR_USE_INITIATOR_SEQNUM ? n2 : 0);
        }
        krb5Context.setAuthTime(new KerberosTime(this.apReq.getCreds().getAuthTime()).toString());
        krb5Context.setTktFlags(this.apReq.getCreds().getFlags());
        AuthorizationData authorizationData = this.apReq.getCreds().getAuthzData();
        if (authorizationData == null) {
            krb5Context.setAuthzData(null);
        } else {
            AuthorizationDataEntry[] authorizationDataEntryArray = new AuthorizationDataEntry[authorizationData.count()];
            for (int i = 0; i < authorizationData.count(); ++i) {
                authorizationDataEntryArray[i] = new AuthorizationDataEntry(authorizationData.item((int)i).adType, authorizationData.item((int)i).adData);
            }
            krb5Context.setAuthzData(authorizationDataEntryArray);
        }
    }

    public final KrbApReq getKrbApReq() {
        return this.apReq;
    }

    @Override
    public final byte[] encode() throws IOException {
        byte[] byArray = this.apReq.getMessage();
        byte[] byArray2 = new byte[2 + byArray.length];
        InitSecContextToken.writeInt(256, byArray2, 0);
        System.arraycopy((Object)byArray, 0, (Object)byArray2, 2, byArray.length);
        return byArray2;
    }

    static {
        String string = "sun.security.krb5.acceptor.sequence.number.nonmutual";
        String string2 = GetPropertyAction.privilegedGetProperty(string, "initiator");
        if (string2.equals("initiator")) {
            ACCEPTOR_USE_INITIATOR_SEQNUM = true;
        } else if (string2.equals("zero") || string2.equals("0")) {
            ACCEPTOR_USE_INITIATOR_SEQNUM = false;
        } else {
            throw new AssertionError((Object)("Unrecognized value for " + string + ": " + string2));
        }
    }
}

