/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public class JCJavaClass
implements JavaClass {
    private final JCJavaRuntime fJavaRuntime;
    private JavaClassLoader fJavaClassLoader;
    private JavaObject fJavaObject;
    private long fClassID;
    private long fSuperClassID;
    private final String fClassName;
    private ImagePointer fClassPointer;
    private int fModifiers;
    private LinkedHashSet fMethods;
    private Vector fConstantPoolReferences;
    private Vector fDeclaredFields;
    private Vector fInterfaces;

    public JCJavaClass(JCJavaRuntime jCJavaRuntime, String string) throws JCInvalidArgumentsException {
        if (jCJavaRuntime == null) {
            throw new JCInvalidArgumentsException("Must pass a valid java runtime and class name");
        }
        if (string == null) {
            throw new JCInvalidArgumentsException("Must pass either a valid className or ID at construction time");
        }
        this.fClassName = string;
        this.fJavaRuntime = jCJavaRuntime;
        this.fClassPointer = null;
        this.fJavaClassLoader = null;
        this.fJavaObject = null;
        this.fClassID = -1L;
        this.fSuperClassID = -1L;
        this.fModifiers = -1;
        this.fMethods = new LinkedHashSet();
        this.fConstantPoolReferences = new Vector();
        this.fDeclaredFields = new Vector();
        this.fInterfaces = new Vector();
        this.fJavaRuntime.addJavaClass(this);
    }

    @Override
    public JavaClassLoader getClassLoader() throws CorruptDataException {
        if (this.fJavaClassLoader == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fJavaClassLoader;
    }

    @Override
    public JavaClass getComponentType() throws CorruptDataException {
        throw new CorruptDataException(new JCCorruptData(null));
    }

    @Override
    public Iterator getConstantPoolReferences() {
        return this.fConstantPoolReferences.iterator();
    }

    @Override
    public Iterator getDeclaredFields() {
        return this.fDeclaredFields.iterator();
    }

    @Override
    public Iterator getDeclaredMethods() {
        return this.fMethods.iterator();
    }

    @Override
    public ImagePointer getID() {
        if (this.fClassPointer == null && this.fClassID != -1L) {
            this.fClassPointer = this.fJavaRuntime.getImageProcess().getImageAddressSpace().getPointer(this.fClassID);
        }
        return this.fClassPointer;
    }

    @Override
    public Iterator getInterfaces() {
        return this.fInterfaces.iterator();
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        if (this.fModifiers == -1) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fModifiers;
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.fClassName == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fClassName;
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        if (this.fJavaObject == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fJavaObject;
    }

    @Override
    public JavaClass getSuperclass() throws CorruptDataException {
        JCJavaClass jCJavaClass = this.fJavaRuntime.findJavaClass(this.fSuperClassID);
        if (jCJavaClass == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fJavaRuntime.findJavaClass(this.fSuperClassID);
    }

    @Override
    public long getInstanceSize() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("Instance size is not available in a javacore");
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        String string = this.getName();
        return string.startsWith("[");
    }

    public void setID(long l) throws JCInvalidArgumentsException {
        if (!this.fJavaRuntime.getImageProcess().getImageAddressSpace().isValidAddressID(l)) {
            throw new JCInvalidArgumentsException("Must pass a valid class ID (non zero value)");
        }
        this.fClassID = l;
        this.fJavaRuntime.addJavaClass(this);
    }

    public String internalGetName() {
        return this.fClassName;
    }

    public void setClassLoader(JavaClassLoader javaClassLoader) {
        this.fJavaClassLoader = javaClassLoader;
    }

    public void setJavaSuperClass(long l) {
        this.fSuperClassID = l;
    }

    public void setJavaObject(JavaObject javaObject) {
        this.fJavaObject = javaObject;
    }

    public void setModifiers(int n) {
        this.fModifiers = n;
    }

    @Override
    public Iterator getReferences() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void addMethod(JavaMethod javaMethod) {
        this.fMethods.add(javaMethod);
    }

    @Override
    public JavaObject getProtectionDomain() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getProtectionDomain");
    }
}

