#include <unistd.h>	/* close */
#include <fcntl.h>	/* open, O_* */
#include <stdio.h>	/* printf */

#include <ringbuf.h>
#include <debug.h>


static char buf[256];

int main()
{
	ssize_t n, m, p;
	int fd, x;
	RING *r;

/******/

	printf("\nRINGTEST\n\n");

	r = ring_new(24);
	printf("ring_new(%d): %p\n",
		24, r);

	if (!r) {
		printf("\nNo memory!\n");
		return 1;
	}

	printf(" ring_maxget: %ld\n"
	       " ring_maxput: %ld\n",
	       (long)ring_maxget(r),
	       (long)ring_maxput(r));

	n = ring_put(r, "TESTTEST", 8);
	printf("\nring_put(8): %s (%ld)\n",
	       "TESTTEST", (long)n);

	printf(" ring_maxget: %ld\n"
	       " ring_maxput: %ld\n",
	       (long)ring_maxget(r),
	       (long)ring_maxput(r));

	n = ring_get(r, buf, 6); buf[6] = 0;
	printf("\nring_get(6): %s (%ld)\n",
	       buf, (long)n);

	printf(" ring_maxget: %ld\n"
	       " ring_maxput: %ld\n",
	       (long)ring_maxget(r),
	       (long)ring_maxput(r));

	n = ring_put(r, "abcdefghijklmnopqrstuvwxyz", 26);
	printf("\nring_put(26): %s (%ld)\n",
	       "abcdefghijklmnopqrstuvwxyz", (long)n);

	printf(" ring_maxget: %ld\n"
	       " ring_maxput: %ld\n",
	       (long)ring_maxget(r),
	       (long)ring_maxput(r));

	n = ring_get(r, buf, 7); buf[7] = 0;
	printf("\nring_get(7): %s (%ld)\n",
	       buf, (long)n);

	printf(" ring_maxget: %ld\n"
	       " ring_maxput: %ld\n",
	       (long)ring_maxget(r),
	       (long)ring_maxput(r));

	m = ring_maxget(r) * 2;
	n = ring_get(r, buf, m); buf[m] = 0;
	printf("\nring_get(%ld): %s (%ld)\n",
	       (long)m, buf, (long)n);		

/******/

	printf("\nFILE INPUT\n");
	fd = open("ringtest1.file", O_RDONLY);
	if (fd == -1) {
		perror("open ringtest.file RO");
		return 1;
	}

	m = ring_read(r, fd, &n);
	printf("\n  ring_read: transfered %ld, returned %ld\n",(long)n,(long)m);

	m = 11;
	n = ring_get(r, buf, m); buf[m] = 0;
	printf("\nring_get(%ld): %s (%ld)\n",
	       (long)m, buf, (long)n);

	m = ring_read(r, fd, &n);
	printf("\n  ring_read: transfered %ld, returned %ld\n",(long)n,(long)m);
	close(fd);

	m = ring_maxget(r) * 2;
	n = ring_get(r, buf, m); buf[m] = 0;
	printf("\nring_get(%ld): %s (%ld)\n",
	       (long)m, buf, (long)n);

/******/

	ring_del(r);

	printf("\nPEEKING FUNCTIONS\n\n");

	n = 128;
	r = ring_new(n);
	printf("ring_new(%ld): %p\n\n",
		(long)n, r);

	if (!r) {
		printf("No memory!\n");
		return 1;
	}

	fd = open("ringtest2.file", O_RDONLY);
	if (fd == -1) {
		perror("open ringbuf.c RO");
		return 1;
	}

	for(x = 1; ; x++) {

		p = ring_read(r, fd, 0);

		if (ring_isempty(r)) { 
			printf("---> still empty after read, so EOF\n");
			break;
		}

		n = ring_strcspn(r, "\r\n", 3);
		if (n > 0) n = ring_get(r, buf, n); 
		buf[n] = 0;

		m = 1 + ((ring_peek(r, 0) == '\r' && ring_peek(r, 1) == '\n') ||
			 (ring_peek(r, 0) == '\n' && ring_peek(r, 1) == '\r'));
		ring_discard(r, m);

		printf("%06d (%03ld - %03ld:%03ld): %s\n", 
		       x, (long)p, (long)n, (long)m, buf);

/*		ring_debug(r);	*/
	}

	close(fd);
	
	ring_del(r);

	return 0;
}

