<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:pz="http://www.indexdata.com/pazpar2/1.0"
    xmlns:marc="http://www.loc.gov/MARC21/slim">
  
  <xsl:output indent="yes" method="xml" version="1.0" encoding="UTF-8"/>

<!-- Extract metadata from MARC21/USMARC 
      http://www.loc.gov/marc/bibliographic/ecbdhome.html
-->  
  <xsl:template name="record-hook"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="marc:collection">
    <pz:collection>
        <xsl:apply-templates/>
    </pz:collection>
  </xsl:template>

  <xsl:template match="marc:record">
    <xsl:variable name="title_medium" select="marc:datafield[@tag='245']/marc:subfield[@code='h']"/>
    <xsl:variable name="journal_title" select="marc:datafield[@tag='773']/marc:subfield[@code='t']"/>
    <xsl:variable name="electronic_location_url" select="marc:datafield[@tag='856']/marc:subfield[@code='u']"/>
    <xsl:variable name="fulltext_a" select="marc:datafield[@tag='900']/marc:subfield[@code='a']"/>
    <xsl:variable name="fulltext_b" select="marc:datafield[@tag='900']/marc:subfield[@code='b']"/>
    <xsl:variable name="medium">
      <xsl:choose>
	<xsl:when test="$title_medium">
	  <xsl:value-of select="translate($title_medium, ' []/', '')"/>
	</xsl:when>
	<xsl:when test="$fulltext_a">
	  <xsl:text>electronic resource</xsl:text>
	</xsl:when>
	<xsl:when test="$fulltext_b">
	  <xsl:text>electronic resource</xsl:text>
	</xsl:when>
	<xsl:when test="$journal_title">
	  <xsl:text>article</xsl:text>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:text>book</xsl:text>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="has_fulltext">
      <xsl:choose>
        <xsl:when test="marc:datafield[@tag='856']/marc:subfield[@code='q']">
          <xsl:text>yes</xsl:text>
        </xsl:when>
        <xsl:when test="marc:datafield[@tag='856']/marc:subfield[@code='i']='TEXT*'">
          <xsl:text>yes</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>no</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="oclc_number">
      <xsl:variable name="c001" select='marc:controlfield[@tag="001"]' />
      <xsl:choose>
        <xsl:when test='contains(marc:controlfield[@tag="001"],"ocn") or
                        contains(marc:controlfield[@tag="001"],"ocm") or
                        contains(marc:controlfield[@tag="001"],"OCoLC")'>
            <xsl:value-of select="marc:controlfield[@tag='001']"/>
        </xsl:when>
        <xsl:when test='contains(marc:datafield[@tag="035"]/marc:subfield[@code="a"],"ocn") or
                        contains(marc:datafield[@tag="035"]/marc:subfield[@code="a"],"ocm") or
                        contains(marc:datafield[@tag="035"]/marc:subfield[@code="a"],"OCoLC") '>
         <xsl:value-of select="marc:datafield[@tag='035']/marc:subfield[@code='a']"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="date_008">
      <xsl:choose>
        <xsl:when test="contains('cestpudikmr', substring(marc:controlfield[@tag='008'], 7, 1))">
          <xsl:value-of select="substring(marc:controlfield[@tag='008'], 8, 4)" />
        </xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="date_end_008">
      <xsl:choose>
        <xsl:when test="contains('dikmr', substring(marc:controlfield[@tag='008'], 7, 1))">
          <xsl:value-of select="substring(marc:controlfield[@tag='008'], 12, 4)" />
        </xsl:when>
      </xsl:choose>
    </xsl:variable>

    <pz:record>
      <xsl:for-each select="marc:controlfield[@tag='001']">
        <pz:metadata type="id">
          <xsl:value-of select="."/>
        </pz:metadata>
      </xsl:for-each>

      <pz:metadata type="oclc-number">
        <xsl:value-of select="$oclc_number" />
      </pz:metadata>

      <xsl:for-each select="marc:datafield[@tag='010']">
        <pz:metadata type="lccn">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='020']">
        <pz:metadata type="isbn">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='022']">
        <pz:metadata type="issn">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='027']">
        <pz:metadata type="tech-rep-nr">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='035']">
        <pz:metadata type="system-control-nr">
          <xsl:choose>
            <xsl:when test="marc:subfield[@code='a']">
              <xsl:value-of select="marc:subfield[@code='a']"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="marc:subfield[@code='b']"/>
            </xsl:otherwise>
          </xsl:choose>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='100']">
	<pz:metadata type="author">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
	<pz:metadata type="author-title">
	  <xsl:value-of select="marc:subfield[@code='c']"/>
	</pz:metadata>
	<pz:metadata type="author-date">
	  <xsl:value-of select="marc:subfield[@code='d']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='110']">
	<pz:metadata type="corporate-name">
	    <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
	<pz:metadata type="corporate-location">
	    <xsl:value-of select="marc:subfield[@code='c']"/>
	</pz:metadata>
	<pz:metadata type="corporate-date">
	    <xsl:value-of select="marc:subfield[@code='d']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='111']">
	<pz:metadata type="meeting-name">
	    <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
	<pz:metadata type="meeting-location">
	    <xsl:value-of select="marc:subfield[@code='c']"/>
	</pz:metadata>
	<pz:metadata type="meeting-date">
	    <xsl:value-of select="marc:subfield[@code='d']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='130']">
        <pz:metadata type="title-uniform">
          <xsl:value-of select="marc:subfield[@code='a']" />
        </pz:metadata>
        <pz:metadata type="title-uniform-media">
          <xsl:value-of select="marc:subfield[@code='m']" />
        </pz:metadata>
        <pz:metadata type="title-uniform-parts">
          <xsl:value-of select="marc:subfield[@code='n']" />
        </pz:metadata>
        <pz:metadata type="title-uniform-partname">
          <xsl:value-of select="marc:subfield[@code='p']" />
        </pz:metadata>
        <pz:metadata type="title-uniform-key">
          <xsl:value-of select="marc:subfield[@code='r']" />
        </pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='260']">
        <pz:metadata type="date">
          <xsl:value-of select="translate(marc:subfield[@code='c'], 'cp[].', '')" />
        </pz:metadata>
      </xsl:for-each>

      <xsl:if test="$date_008 and not(marc:datafield[@tag='260'])">
        <pz:metadata type="date">
          <xsl:choose>
            <xsl:when test="$date_end_008">
              <xsl:value-of select="concat($date_008,'-',$date_end_008)" />
            </xsl:when>
            <xsl:otherwise> 
              <xsl:value-of select="$date_008" />
            </xsl:otherwise>
          </xsl:choose>
        </pz:metadata>
      </xsl:if>

      <xsl:for-each select="marc:datafield[@tag='245']">
        <pz:metadata type="title">
          <xsl:value-of select="marc:subfield[@code='a']"/>
        </pz:metadata>
        <pz:metadata type="title-remainder">
          <xsl:value-of select="marc:subfield[@code='b']"/>
        </pz:metadata>
        <pz:metadata type="title-responsibility">
          <xsl:value-of select="marc:subfield[@code='c']"/>
        </pz:metadata>
        <pz:metadata type="title-dates">
          <xsl:value-of select="marc:subfield[@code='f']"/>
        </pz:metadata>
        <pz:metadata type="title-medium">
          <xsl:value-of select="marc:subfield[@code='h']"/>
        </pz:metadata>
        <pz:metadata type="title-number-section">
          <xsl:value-of select="marc:subfield[@code='n']"/>
        </pz:metadata>
        <pz:metadata type="title-complete">
          <xsl:value-of select="marc:subfield[@code='a']" />
          <xsl:if test="marc:subfield[@code='b']" ><xsl:value-of select="concat(' ', marc:subfield[@code='b'])" /></xsl:if>
        </pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='250']">
	<pz:metadata type="edition">
	    <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='260']">
        <pz:metadata type="publication-place">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
        <pz:metadata type="publication-name">
	  <xsl:value-of select="marc:subfield[@code='b']"/>
	</pz:metadata>
        <pz:metadata type="publication-date">
	  <xsl:value-of select="marc:subfield[@code='c']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='300']">
	<pz:metadata type="physical-extent">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
	<pz:metadata type="physical-format">
	  <xsl:value-of select="marc:subfield[@code='b']"/>
	</pz:metadata>
	<pz:metadata type="physical-dimensions">
	  <xsl:value-of select="marc:subfield[@code='c']"/>
	</pz:metadata>
	<pz:metadata type="physical-accomp">
	  <xsl:value-of select="marc:subfield[@code='e']"/>
	</pz:metadata>
	<pz:metadata type="physical-unittype">
	  <xsl:value-of select="marc:subfield[@code='f']"/>
	</pz:metadata>
	<pz:metadata type="physical-unitsize">
	  <xsl:value-of select="marc:subfield[@code='g']"/>
	</pz:metadata>
	<pz:metadata type="physical-specified">
	  <xsl:value-of select="marc:subfield[@code='3']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='440']">
	<pz:metadata type="series-title">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag = '500' or @tag = '505' or
      		@tag = '518' or @tag = '520' or @tag = '522']">
	<pz:metadata type="description">
            <xsl:value-of select="*/text()"/>
        </pz:metadata>
      </xsl:for-each>

	<xsl:for-each
		select="marc:datafield[@tag='600' or @tag='610' or @tag='611' or @tag='630' or @tag='648' or @tag='650' or @tag='651' or @tag='653' or @tag='654' or @tag='655' or @tag='656' or @tag='657' or @tag='658' or @tag='662' or @tag='69X']">
		<pz:metadata type="subject">
			<xsl:value-of select="marc:subfield[@code='a']" />
		</pz:metadata>
		<pz:metadata type="subject-long">
			<xsl:for-each select="node()/text()">
				<xsl:if test="position() > 1">
					<xsl:text>, </xsl:text>
				</xsl:if>
				<xsl:variable name='value'>
					<xsl:value-of select='normalize-space(.)' />
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="substring($value,string-length($value)) = ','">
						<xsl:value-of select="substring($value,1,string-length($value)-1)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$value" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</pz:metadata>
	</xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='856']">
	<pz:metadata type="electronic-url">
	  <xsl:value-of select="marc:subfield[@code='u']"/>
	</pz:metadata>
	<pz:metadata type="electronic-text">
	  <xsl:value-of select="marc:subfield[@code='y' or @code='3' or @code='a']"/>
	</pz:metadata>
	<pz:metadata type="electronic-note">
	  <xsl:value-of select="marc:subfield[@code='z']"/>
	</pz:metadata>
	<pz:metadata type="electronic-format-instruction">
	  <xsl:value-of select="marc:subfield[@code='i']"/>
	</pz:metadata>
	<pz:metadata type="electronic-format-type">
	  <xsl:value-of select="marc:subfield[@code='q']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='773']">
    	<pz:metadata type="citation">
	      <xsl:for-each select="*">
	        <xsl:value-of select="normalize-space(.)"/>
	        <xsl:text> </xsl:text>
    	  </xsl:for-each>
        </pz:metadata>
        <xsl:if test="marc:subfield[@code='t']">
    	  <pz:metadata type="journal-title">
	        <xsl:value-of select="marc:subfield[@code='t']"/>
          </pz:metadata>          
        </xsl:if>
        <xsl:if test="marc:subfield[@code='g']">
    	  <pz:metadata type="journal-subpart">
	        <xsl:value-of select="marc:subfield[@code='g']"/>
          </pz:metadata>          
        </xsl:if>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='852']">
        <xsl:if test="marc:subfield[@code='y']">
	  <pz:metadata type="publicnote">
	    <xsl:value-of select="marc:subfield[@code='y']"/>
	  </pz:metadata>
	</xsl:if>
	<xsl:if test="marc:subfield[@code='h']">
	  <pz:metadata type="callnumber">
	    <xsl:value-of select="marc:subfield[@code='h']"/>
	  </pz:metadata>
	</xsl:if>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='900']/marc:subfield[@code='a']">
        <pz:metadata type="fulltext">
          <xsl:value-of select="."/>
        </pz:metadata>
      </xsl:for-each>

      <pz:metadata type="medium">
        <xsl:value-of select="$medium"/>
      </pz:metadata>

      <pz:metadata type="has-fulltext">
        <xsl:value-of select="$has_fulltext"/> 
      </pz:metadata>

      <xsl:for-each select="marc:datafield[@tag='900']/marc:subfield[@code='b']">
        <pz:metadata type="fulltext">
          <xsl:value-of select="."/>
        </pz:metadata>
      </xsl:for-each>

      <!-- <xsl:if test="$fulltext_b">
	<pz:metadata type="fulltext">
	  <xsl:value-of select="$fulltext_b"/>
	</pz:metadata>
      </xsl:if> -->

      <xsl:for-each select="marc:datafield[@tag='907' or @tag='901']">
        <pz:metadata type="iii-id">
	  <xsl:value-of select="marc:subfield[@code='a']"/>
	</pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='926']">
        <pz:metadata type="holding">
	  <xsl:for-each select="marc:subfield">
	    <xsl:if test="position() > 1">
	      <xsl:text> </xsl:text>
	    </xsl:if>
	    <xsl:value-of select="."/>
	  </xsl:for-each>
        </pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='948']">
        <pz:metadata type="holding">
	  <xsl:for-each select="marc:subfield">
	    <xsl:if test="position() > 1">
	      <xsl:text> </xsl:text>
	    </xsl:if>
	    <xsl:value-of select="."/>
	  </xsl:for-each>
        </pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='991']">
        <pz:metadata type="holding">
	  <xsl:for-each select="marc:subfield">
	    <xsl:if test="position() > 1">
	      <xsl:text> </xsl:text>
	    </xsl:if>
	    <xsl:value-of select="."/>
	  </xsl:for-each>
        </pz:metadata>
      </xsl:for-each>

      <xsl:for-each select="marc:datafield[@tag='999']">
        <pz:metadata type="localid">
          <xsl:choose>
            <xsl:when test="marc:subfield[@code='a']">
              <xsl:value-of select="marc:subfield[@code='a']"/>
            </xsl:when>
            <xsl:when test="marc:subfield[@code='c']">
              <xsl:value-of select="marc:subfield[@code='c']"/>
            </xsl:when> 
            <xsl:otherwise>
              <xsl:value-of select="marc:subfield[@code='d']"/>
            </xsl:otherwise>
          </xsl:choose>
        </pz:metadata>
      </xsl:for-each>

      <!-- passthrough id data -->
      <xsl:for-each select="pz:metadata">
          <xsl:copy-of select="."/>
      </xsl:for-each>

      <!-- other stylesheets importing this might want to define this -->
      <xsl:call-template name="record-hook"/>

    </pz:record>    
  </xsl:template>
  
  <xsl:template match="text()"/>

</xsl:stylesheet>
