<?php
// Call Gtk2_IndexedComboBoxTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "Gtk2_IndexedComboBoxTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once "Gtk2/IndexedComboBox.php";

/**
 * Test class for Gtk2_IndexedComboBox.
 * Generated by PHPUnit2_Util_Skeleton on 2006-04-05 at 08:27:56.
 */
class Gtk2_IndexedComboBoxTest extends PHPUnit_Framework_TestCase {
    protected $cmb = null;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("Gtk2_IndexedComboBoxTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        $this->cmb = new Gtk2_IndexedComboBox();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    /**
     */
    public function testAppend() {
        $this->cmb->append(1, 'one');
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->append(2, 'two');
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->append(null, 'two');
        $this->assertTrue($this->cmb->set_active_key(null));
        $this->assertEquals(null, $this->cmb->get_active_key());
        $this->assertEquals(null, $this->cmb->get_active_text());
    }

    /**
     */
    public function testAppend_array() {
        $this->cmb->append_array(array(1 => 'one'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->append_array(array(2 => 'two'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->append_array(array(3 => 'three', 4 => 'four'));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertTrue($this->cmb->set_active_key(3));
        $this->assertTrue($this->cmb->set_active_key(4));
        $this->assertFalse($this->cmb->set_active_key(5));
    }

    /**
     */
    public function testGet_active_key() {
        $this->cmb->append_array(array(1 => 'one', 2 => 'two'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertEquals('1', $this->cmb->get_active_key());

        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertEquals('2', $this->cmb->get_active_key());

        $this->assertFalse($this->cmb->set_active_key(3));
        $this->assertEquals('2', $this->cmb->get_active_key());

        $this->assertTrue($this->cmb->set_active_key(null));
        $this->assertEquals(null, $this->cmb->get_active_key());
    }

    /**
     */
    public function testGet_active_text() {
        $this->cmb->append_array(array(1 => 'one', 2 => 'two'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertEquals('one', $this->cmb->get_active_text());

        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertEquals('two', $this->cmb->get_active_text());

        $this->assertFalse($this->cmb->set_active_key(3));
        $this->assertEquals('two', $this->cmb->get_active_text());

        $this->assertTrue($this->cmb->set_active_key(null));
        $this->assertEquals(null, $this->cmb->get_active_text());
    }

    /**
     */
    public function testGet_array() {
        $this->assertEquals(array(), $this->cmb->get_array());

        $this->cmb->append_array(array(1 => 'one', 2 => 'two'));
        $this->assertEquals(array(1 => 'one', 2 => 'two'), $this->cmb->get_array());
    }

    /**
     */
    public function testGet_cell_renderer() {
        $this->assertTrue($this->cmb->get_cell_renderer() instanceof GtkCellRenderer);
    }

    /**
     */
    public function testInsert() {
        $this->cmb->insert(0, 1, 'one');
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->insert(1, 2, 'two');
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));
    }

    /**
     */
    public function testInsert_array() {
        $this->cmb->insert_array(0, array(1 => 'one'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->insert_array(1, array(2 => 'two'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->insert_array(2, array(3 => 'three', 4 => 'four'));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertTrue($this->cmb->set_active_key(3));
        $this->assertTrue($this->cmb->set_active_key(4));
        $this->assertFalse($this->cmb->set_active_key(5));
    }

    /**
     */
    public function testPrepend() {
        $this->cmb->prepend(1, 'one');
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));

        $this->cmb->prepend(2, 'two');
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertFalse($this->cmb->set_active_key(3));
    }

    /**
     */
    public function testPrepend_array() {
        $this->cmb->prepend_array(array(1 => 'one', 2 => 'two'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertEquals('1', $this->cmb->get_active_key());

        $this->assertTrue($this->cmb->set_active_key(2));
        $this->assertEquals('2', $this->cmb->get_active_key());

        $this->assertFalse($this->cmb->set_active_key(3));
        $this->assertEquals('2', $this->cmb->get_active_key());
    }

    /**
     */
    public function testRemove_key() {
        $this->assertFalse($this->cmb->remove_key(1));

        $this->cmb->append(1, 'one');
        $this->assertTrue($this->cmb->remove_key(1));
        $this->assertFalse($this->cmb->set_active_key(1));

        $this->cmb->append(1, 'one');
        $this->cmb->append(2, 'two');
        $this->assertTrue($this->cmb->remove_key(1));
        $this->assertTrue($this->cmb->remove_key(2));
        $this->assertFalse($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
    }

    /**
     */
    public function testSet_active_key() {
        $this->cmb->append_array(array(1 => 'one', 2 => 'two'));
        $this->assertTrue($this->cmb->set_active_key(1));
        $this->assertEquals('1', $this->cmb->get_active_key());

        $this->assertTrue($this->cmb->set_active_key(null));
        $this->assertEquals(null, $this->cmb->get_active_key());
    }

    /**
     */
    public function testSet_array() {
        $this->cmb->append_array(array(1 => 'one', 2 => 'two'));
        $this->cmb->set_array(array(3 => 'three', 4 => 'four'));
        $this->assertFalse($this->cmb->set_active_key(1));
        $this->assertFalse($this->cmb->set_active_key(2));
        $this->assertTrue($this->cmb->set_active_key(3));
        $this->assertTrue($this->cmb->set_active_key(4));
    }

    /**
     */
    public function testAppendArray() {
        //just an alias method
    }

    /**
     */
    public function testGetActiveKey() {
        //just an alias method
    }

    /**
     */
    public function testGetActiveText() {
        //just an alias method
    }

    /**
     */
    public function testGetCellRenderer() {
        //just an alias method
    }

    /**
     */
    public function testInsertArray() {
        //just an alias method
    }

    /**
     */
    public function testPrependArray() {
        //just an alias method
    }

    /**
     */
    public function testRemoveKey() {
        //just an alias method
    }

    /**
     */
    public function testSetActiveKey() {
        //just an alias method
    }

    /**
     */
    public function testSetArray() {
        //just an alias method
    }
}

// Call Gtk2_IndexedComboBoxTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "Gtk2_IndexedComboBoxTest::main") {
    Gtk2_IndexedComboBoxTest::main();
}
?>
