<?php
/**
* @author Paul Querna <chip@force-elite.com>
* @package Net_IRC-ChiBot
*/
global $ircd;

set_time_limit(0);

include '../../IRC.php';

$ircd = new Net_IRC;

echo "Adding NetGamers\n";
$options = array(
    'server'    => 'irc.netgamers.org',
    'port'      => 6667,
    'nick'      => 'ChiBot',
    'host'      => '10.0.0.8',
    'log_types'  => array(0,1,2,3,4, 5, 6),
);

$id_ng = $ircd->Add_Connection($options);


echo "Adding JustIRC\n";
$options = array(
    'server'    => 'irc.justirc.net',
    'port'      => 6667,
    'nick'      => 'ChiBot',
    'host'      => '10.0.0.8',
    'log_types'  => array(0,1,2,3,4, 5, 6),
);
$id_js = $ircd->Add_Connection($options);


function privmsg($server_id, &$irc, $origin, $orighost, $target, $params) {
	global $ircd;
	$GLOBALS['my_data'] = array($server_id, $origin, $orighost, $target, $params);
	include('functions/privmsg.php');
}

function welcome($server_id, &$irc, $origin, $orighost, $target, $params) {
	global $ircd;
	$GLOBALS['my_data'] = array($server_id, $origin, $orighost, $target, $params);
	include('functions/welcome.php');
}

function discon($server_id, &$irc, $origin, $orighost, $target, $params){
	$irc->disconnect($server_id);
}

$ircd->Add_Callback('DISCONNECT', discon);
$ircd->Add_Callback('PRIVMSG', privmsg);
$ircd->Add_Callback('RPL_WELCOME', welcome);


$ircd->Run();
