CREATE TABLE php_manual (
  id mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(48) NOT NULL default '',
  PHP_VER varchar(48) NOT NULL default '',
  return varchar(8) NOT NULL default '',
  args varchar(254) NOT NULL default '',
  purpose varchar(254) NOT NULL default '',
  modtime int(11) NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

INSERT INTO php_manual VALUES (2, 'apache_child_terminate', 'PHP 4 >= 4.0.5', 'bool', 'void', 'Terminate apache process after this request', 1042390496);
INSERT INTO php_manual VALUES (3, 'apache_lookup_uri', 'PHP 3>= 3.0.4, PHP 4', 'object', 'string filename', ' Perform a partial request for the specified URI and return all info about it', 1042390496);
INSERT INTO php_manual VALUES (4, 'apache_note', 'PHP 3>= 3.0.2, PHP 4', 'string', 'string note_name, [string note_value]', 'Get and set apache request notes', 1042390496);
INSERT INTO php_manual VALUES (5, 'apache_request_headers', 'PHP 4 >= 4.3.0', 'array', 'void', 'Fetch all HTTP request headers', 1042390496);
INSERT INTO php_manual VALUES (6, 'apache_response_headers', 'PHP 4 >= 4.3.0', 'array', 'void', ' Fetch all HTTP response headers', 1042390496);
INSERT INTO php_manual VALUES (7, 'apache_setenv', 'PHP 4 >= 4.2.0', 'int', 'string variable, string value, [bool walk_to_top]', 'Set an Apache subprocess_env variable', 1042390496);
INSERT INTO php_manual VALUES (8, 'ascii2ebcdic', 'PHP 3>= 3.0.17', 'int', 'string ascii_str', 'Translate string from ASCII to EBCDIC', 1042390496);
INSERT INTO php_manual VALUES (9, 'ebcdic2ascii', 'PHP 3>= 3.0.17', 'int', 'string ebcdic_str', 'Translate string from EBCDIC to ASCII', 1042390496);
INSERT INTO php_manual VALUES (10, 'getallheaders', 'PHP 3, PHP 4', 'array', 'void', 'Fetch all HTTP request headers', 1042390496);
INSERT INTO php_manual VALUES (11, 'virtual', 'PHP 3, PHP 4', 'int', 'string filename', 'Perform an Apache sub-request', 1042390496);
INSERT INTO php_manual VALUES (12, 'array_change_key_case', 'PHP 4 >= 4.2.0', 'array', 'array input, [int case]', 'Returns an array with all string keys lowercased or uppercased', 1042390496);
INSERT INTO php_manual VALUES (13, 'array_chunk', 'PHP 4 >= 4.2.0', 'array', 'array input, int size, [bool preserve_keys]', 'Split an array into chunks', 1042390496);
INSERT INTO php_manual VALUES (14, 'array_count_values', 'PHP 4', 'array', 'array input', 'Counts all the values of an array', 1042390496);
INSERT INTO php_manual VALUES (15, 'array_diff_assoc', 'PHP 4 >= 4.3.0', 'array', 'array array1, array array2, [array ...]', 'Computes the difference of arrays with additional index check', 1042390496);
INSERT INTO php_manual VALUES (16, 'array_diff', 'PHP 4 >= 4.0.1', 'array', 'array array1, array array2, [array ...]', 'Computes the difference of arrays', 1042390496);
INSERT INTO php_manual VALUES (17, 'array_fill', 'PHP 4 >= 4.2.0', 'array', 'int start_index, int num, mixed value', 'Fill an array with values', 1042390496);
INSERT INTO php_manual VALUES (18, 'array_filter', 'PHP 4 >= 4.0.6', 'array', 'array input, [callback function]', ' Filters elements of an array using a callback function', 1042390496);
INSERT INTO php_manual VALUES (19, 'array_flip', 'PHP 4', 'array', 'array trans', 'Exchanges all keys with their associated values in an array', 1042390496);
INSERT INTO php_manual VALUES (20, 'array_intersect_assoc', 'PHP 4 >= 4.3.0', 'array', 'array array1, array array2, [array ...]', 'Computes the intersection of arrays with additional index check', 1042390496);
INSERT INTO php_manual VALUES (21, 'array_intersect', 'PHP 4 >= 4.0.1', 'array', 'array array1, array array2, [array ...]', 'Computes the intersection of arrays', 1042390496);
INSERT INTO php_manual VALUES (22, 'array_key_exists', 'PHP 4 >= 4.1.0', 'bool', 'mixed key, array search', 'Checks if the given key or index exists in the array', 1042390496);
INSERT INTO php_manual VALUES (23, 'array_keys', 'PHP 4', 'array', 'array input, [mixed search_value ]', 'Return all the keys of an array', 1042390497);
INSERT INTO php_manual VALUES (24, 'array_map', 'PHP 4 >= 4.0.6', 'array', 'callback function, array arr1, [array arr2...]', ' Applies the callback to the elements of the given arrays', 1042390497);
INSERT INTO php_manual VALUES (25, 'array_merge_recursive', 'PHP 4 >= 4.0.1', 'array', 'array array1, array array2, [array ...]', 'Merge two or more arrays recursively', 1042390497);
INSERT INTO php_manual VALUES (26, 'array_merge', 'PHP 4', 'array', 'array array1, array array2, [array ...]', 'Merge two or more arrays', 1042390497);
INSERT INTO php_manual VALUES (27, 'array_pad', 'PHP 4', 'array', 'array input, int pad_size, mixed pad_value', ' Pad array to the specified length with a value', 1042390497);
INSERT INTO php_manual VALUES (28, 'array_multisort', 'PHP 4', 'bool', 'array ar1, [mixed arg], [mixed ...], [array ...]', 'Sort multiple or multi-dimensional arrays', 1042390497);
INSERT INTO php_manual VALUES (29, 'array_pop', 'PHP 4', 'mixed', 'array array', 'Pop the element off the end of array', 1042390497);
INSERT INTO php_manual VALUES (30, 'array_push', 'PHP 4', 'int', 'array array, mixed var, [mixed ...]', ' Push one or more elements onto the end of array', 1042390497);
INSERT INTO php_manual VALUES (31, 'array_rand', 'PHP 4', 'mixed', 'array input, [int num_req]', ' Pick one or more random entries out of an array', 1042390497);
INSERT INTO php_manual VALUES (32, 'array_reduce', 'PHP 4 >= 4.0.5', 'mixed', 'array input, callback function, [int initial]', ' Iteratively reduce the array to a single value using a callback function', 1042390497);
INSERT INTO php_manual VALUES (33, 'array_reverse', 'PHP 4', 'array', 'array array, [bool preserve_keys]', ' Return an array with elements in reverse order', 1042390497);
INSERT INTO php_manual VALUES (34, 'array_search', 'PHP 4 >= 4.0.5', 'mixed', 'mixed needle, array haystack, [bool strict]', ' Searches the array for a given value and returns the corresponding key if successful', 1042390497);
INSERT INTO php_manual VALUES (35, 'array_shift', 'PHP 4', 'mixed', 'array array', ' Shift an element off the beginning of array', 1042390497);
INSERT INTO php_manual VALUES (36, 'array_slice', 'PHP 4', 'array', 'array array, int offset, [int length ]', 'Extract a slice of the array', 1042390497);
INSERT INTO php_manual VALUES (37, 'array_splice', 'PHP 4', 'array', 'array input, int offset, [int length], [array replacement ]', ' Remove a portion of the array and replace it with something else', 1042390497);
INSERT INTO php_manual VALUES (38, 'array_sum', 'PHP 4 >= 4.0.4', 'mixed', 'array array', ' Calculate the sum of values in an array.', 1042390497);
INSERT INTO php_manual VALUES (39, 'array_unique', 'PHP 4 >= 4.0.1', 'array', 'array array', 'Removes duplicate values from an array', 1042390497);
INSERT INTO php_manual VALUES (40, 'array_unshift', 'PHP 4', 'int', 'array array, mixed var, [mixed ... ]', ' Prepend one or more elements to the beginning of array', 1042390497);
INSERT INTO php_manual VALUES (41, 'array_values', 'PHP 4', 'array', 'array input', 'Return all the values of an array', 1042390497);
INSERT INTO php_manual VALUES (42, 'array_walk', 'PHP 3>= 3.0.3, PHP 4', 'int', 'array array, callback function, [mixed userdata]', ' Apply a user function to every member of an array', 1042390497);
INSERT INTO php_manual VALUES (43, 'array', '', 'array', '[mixed ...]', ' Create an array', 1042390497);
INSERT INTO php_manual VALUES (44, 'arsort', 'PHP 3, PHP 4', 'void', 'array array, [int sort_flags]', ' Sort an array in reverse order and maintain index association', 1042390497);
INSERT INTO php_manual VALUES (45, 'asort', 'PHP 3, PHP 4', 'void', 'array array, [int sort_flags]', 'Sort an array and maintain index association', 1042390497);
INSERT INTO php_manual VALUES (46, 'compact', 'PHP 4', 'array', 'mixed varname, [mixed ...]', ' Create array containing variables and their values', 1042390497);
INSERT INTO php_manual VALUES (47, 'count', 'PHP 3, PHP 4', 'int', 'mixed var', 'Count elements in a variable', 1042390497);
INSERT INTO php_manual VALUES (48, 'current', 'PHP 3, PHP 4', 'mixed', 'array array', 'Return the current element in an array', 1042390497);
INSERT INTO php_manual VALUES (49, 'each', 'PHP 3, PHP 4', 'array', 'array array', ' Return the current key and value pair from an array and advance the array cursor', 1042390497);
INSERT INTO php_manual VALUES (50, 'end', 'PHP 3, PHP 4', 'mixed', 'array array', ' Set the internal pointer of an array to its last element', 1042390497);
INSERT INTO php_manual VALUES (51, 'extract', 'PHP 3>= 3.0.7, PHP 4', 'int', 'array var_array, [int extract_type], [string prefix]', ' Import variables into the current symbol table from an array', 1042390498);
INSERT INTO php_manual VALUES (52, 'in_array', 'PHP 4', '', 'void', '', 1042390498);
INSERT INTO php_manual VALUES (53, 'key', 'PHP 3, PHP 4', 'mixed', 'array array', 'Fetch a key from an associative array', 1042390498);
INSERT INTO php_manual VALUES (54, 'krsort', 'PHP 3>= 3.0.13, PHP 4', 'int', 'array array, [int sort_flags]', 'Sort an array by key in reverse order', 1042390498);
INSERT INTO php_manual VALUES (55, 'ksort', 'PHP 3, PHP 4', 'int', 'array array, [int sort_flags]', 'Sort an array by key', 1042390498);
INSERT INTO php_manual VALUES (56, 'list', '', 'void', 'mixed ...', ' Assign variables as if they were an array', 1042390498);
INSERT INTO php_manual VALUES (57, 'natcasesort', 'PHP 4', 'void', 'array array', ' Sort an array using a case insensitive "natural order" algorithm', 1042390498);
INSERT INTO php_manual VALUES (58, 'natsort', 'PHP 4', 'void', 'array array', ' Sort an array using a "natural order" algorithm', 1042390498);
INSERT INTO php_manual VALUES (59, 'next', 'PHP 3, PHP 4', 'mixed', 'array array', ' Advance the internal array pointer of an array', 1042390498);
INSERT INTO php_manual VALUES (60, 'pos', 'PHP 3, PHP 4', 'mixed', 'array array', 'Get the current element from an array', 1042390498);
INSERT INTO php_manual VALUES (61, 'prev', 'PHP 3, PHP 4', 'mixed', 'array array', 'Rewind the internal array pointer', 1042390498);
INSERT INTO php_manual VALUES (62, 'range', 'PHP 3>= 3.0.8, PHP 4', 'array', 'mixed low, mixed high, [int step]', ' Create an array containing a range of elements', 1042390498);
INSERT INTO php_manual VALUES (63, 'reset', 'PHP 3, PHP 4', 'mixed', 'array array', ' Set the internal pointer of an array to its first element', 1042390498);
INSERT INTO php_manual VALUES (64, 'rsort', 'PHP 3, PHP 4', 'void', 'array array, [int sort_flags]', 'Sort an array in reverse order', 1042390498);
INSERT INTO php_manual VALUES (65, 'shuffle', 'PHP 3>= 3.0.8, PHP 4', 'void', 'array array', 'Shuffle an array', 1042390498);
INSERT INTO php_manual VALUES (66, 'sizeof', 'PHP 3, PHP 4', 'int', 'mixed var', 'Get the number of elements in variable', 1042390498);
INSERT INTO php_manual VALUES (67, 'sort', 'PHP 3, PHP 4', 'void', 'array array, [int sort_flags]', 'Sort an array', 1042390498);
INSERT INTO php_manual VALUES (68, 'uasort', 'PHP 3>= 3.0.4, PHP 4', 'void', 'array array, callback cmp_function', ' Sort an array with a user-defined comparison function and maintain index association', 1042390498);
INSERT INTO php_manual VALUES (69, 'uksort', 'PHP 3>= 3.0.4, PHP 4', 'void', 'array array, callback cmp_function', ' Sort an array by keys using a user-defined comparison function', 1042390498);
INSERT INTO php_manual VALUES (70, 'usort', 'PHP 3>= 3.0.3, PHP 4', 'void', 'array array, callback cmp_function', ' Sort an array by values using a user-defined comparison function', 1042390498);
INSERT INTO php_manual VALUES (71, 'aspell_check_raw', 'PHP 3>= 3.0.7, PHP 4  <= 4.2.3', 'bool', 'int dictionary_link, string word', ' Check a word without changing its case or trying to trim it [deprecated]', 1042390498);
INSERT INTO php_manual VALUES (72, 'aspell_check', 'PHP 3>= 3.0.7, PHP 4  <= 4.2.3', 'bool', 'int dictionary_link, string word', 'Check a word [deprecated]', 1042390498);
INSERT INTO php_manual VALUES (73, 'aspell_new', 'PHP 3>= 3.0.7, PHP 4  <= 4.2.3', 'int', 'string master, [string personal]', 'Load a new dictionary [deprecated]', 1042390498);
INSERT INTO php_manual VALUES (74, 'aspell_suggest', 'PHP 3>= 3.0.7, PHP 4  <= 4.2.3', 'array', 'int dictionary_link, string word', 'Suggest spellings of a word [deprecated]', 1042390498);
INSERT INTO php_manual VALUES (75, 'bcadd', 'PHP 3, PHP 4', 'string', 'string left_operand, string right_operand, [int scale]', 'Add two arbitrary precision numbers', 1042390498);
INSERT INTO php_manual VALUES (76, 'bccomp', 'PHP 3, PHP 4', 'int', 'string left_operand, string right_operand, [int scale]', 'Compare two arbitrary precision numbers', 1042390498);
INSERT INTO php_manual VALUES (77, 'bcdiv', 'PHP 3, PHP 4', 'string', 'string left_operand, string right_operand, [int scale]', 'Divide two arbitrary precision numbers', 1042390498);
INSERT INTO php_manual VALUES (78, 'bcmod', 'PHP 3, PHP 4', 'string', 'string left_operand, string modulus', ' Get modulus of an arbitrary precision number', 1042390498);
INSERT INTO php_manual VALUES (79, 'bcmul', 'PHP 3, PHP 4', 'string', 'string left_operand, string right_operand, [int scale]', 'Multiply two arbitrary precision number', 1042390498);
INSERT INTO php_manual VALUES (80, 'bcpow', 'PHP 3, PHP 4', 'string', 'string x, string y, [int scale]', ' Raise an arbitrary precision number to another', 1042390498);
INSERT INTO php_manual VALUES (81, 'bcpowmod', 'PHP 4  CVS only', 'string', 'string x, string y, string modulus, [int scale]', ' Raise an arbitrary precision number to another, reduced by a specified modulus.', 1042390498);
INSERT INTO php_manual VALUES (82, 'bcscale', 'PHP 3, PHP 4', 'string', 'int scale', ' Set default scale parameter for all bc math functions', 1042390498);
INSERT INTO php_manual VALUES (83, 'bcsqrt', 'PHP 3, PHP 4', 'string', 'string operand, [int scale]', ' Get the square root of an arbitrary precision number', 1042390498);
INSERT INTO php_manual VALUES (84, 'bcsub', 'PHP 3, PHP 4', 'string', 'string left_operand, string right_operand, [int scale]', ' Subtract one arbitrary precision number from another', 1042390498);
INSERT INTO php_manual VALUES (85, 'bzclose', 'PHP 4 >= 4.0.4', 'int', 'resource bz', 'Close a bzip2 file pointer', 1042390498);
INSERT INTO php_manual VALUES (86, 'bzcompress', 'PHP 4 >= 4.0.4', 'string', 'string source, [int blocksize], [int workfactor]', 'Compress a string into bzip2 encoded data', 1042390499);
INSERT INTO php_manual VALUES (87, 'bzdecompress', 'PHP 4 >= 4.0.4', 'string', 'string source, [int small]', 'Decompresses bzip2 encoded data', 1042390499);
INSERT INTO php_manual VALUES (88, 'bzerrno', 'PHP 4 >= 4.0.4', 'int', 'resource bz', 'Returns a bzip2 error number', 1042390499);
INSERT INTO php_manual VALUES (89, 'bzerror', 'PHP 4 >= 4.0.4', 'array', 'resource bz', 'Returns the bzip2 error number and error string in an array', 1042390499);
INSERT INTO php_manual VALUES (90, 'bzerrstr', 'PHP 4 >= 4.0.4', 'string', 'resource bz', 'Returns a bzip2 error string', 1042390499);
INSERT INTO php_manual VALUES (91, 'bzflush', 'PHP 4 >= 4.0.4', 'int', 'resource bz', 'Force a write of all buffered data', 1042390499);
INSERT INTO php_manual VALUES (92, 'bzopen', 'PHP 4 >= 4.0.4', 'resource', 'string filename, string mode', 'Open a bzip2 compressed file', 1042390499);
INSERT INTO php_manual VALUES (93, 'bzread', 'PHP 4 >= 4.0.4', 'string', 'resource bz, [int length]', 'Binary safe bzip2 file read', 1042390499);
INSERT INTO php_manual VALUES (94, 'bzwrite', 'PHP 4 >= 4.0.4', 'int', 'resource bz, string data, [int length]', 'Binary safe bzip2 file write', 1042390499);
INSERT INTO php_manual VALUES (95, 'cal_days_in_month', 'PHP 4 >= 4.1.0', 'int', 'int calendar, int month, int year', 'Return the number of days in a month for a given year and calendar', 1042390499);
INSERT INTO php_manual VALUES (96, 'cal_from_jd', 'PHP 4 >= 4.1.0', 'array', 'int jd, int calendar', 'Converts from Julian Day Count to a supported calendar and return extended information', 1042390499);
INSERT INTO php_manual VALUES (97, 'cal_info', 'PHP 4 >= 4.1.0', 'array', 'int calendar', 'Returns information about a particular calendar', 1042390499);
INSERT INTO php_manual VALUES (98, 'cal_to_jd', 'PHP 4 >= 4.1.0', 'int', 'int calendar, int month, int day, int year', 'Converts from a supported calendar to Julian Day Count', 1042390499);
INSERT INTO php_manual VALUES (99, 'easter_date', 'PHP 3>= 3.0.9, PHP 4', 'int', '[int year]', ' Get UNIX timestamp for midnight on Easter of a given year', 1042390499);
INSERT INTO php_manual VALUES (100, 'easter_days', 'PHP 3>= 3.0.9, PHP 4', 'int', '[int year], [int method]', ' Get number of days after March 21 on which Easter falls for a given year', 1042390499);
INSERT INTO php_manual VALUES (101, 'FrenchToJD', 'PHP 3, PHP 4', 'int', 'int month, int day, int year', ' Converts a date from the French Republican Calendar to a Julian Day Count', 1042390499);
INSERT INTO php_manual VALUES (102, 'GregorianToJD', 'PHP 3, PHP 4', 'int', 'int month, int day, int year', ' Converts a Gregorian date to Julian Day Count', 1042390499);
INSERT INTO php_manual VALUES (103, 'JDDayOfWeek', 'PHP 3, PHP 4', 'mixed', 'int julianday, int mode', 'Returns the day of the week', 1042390499);
INSERT INTO php_manual VALUES (104, 'JDMonthName', 'PHP 3, PHP 4', 'string', 'int julianday, int mode', 'Returns a month name', 1042390499);
INSERT INTO php_manual VALUES (105, 'JDToFrench', 'PHP 3, PHP 4', 'string', 'int juliandaycount', ' Converts a Julian Day Count to the French Republican Calendar', 1042390499);
INSERT INTO php_manual VALUES (106, 'JDToGregorian', 'PHP 3, PHP 4', 'string', 'int julianday', 'Converts Julian Day Count to Gregorian date', 1042390499);
INSERT INTO php_manual VALUES (107, 'JDToJewish', 'PHP 3, PHP 4', 'string', 'int julianday', ' Converts a Julian Day Count to the Jewish Calendar', 1042390499);
INSERT INTO php_manual VALUES (108, 'JDToJulian', 'PHP 3, PHP 4', 'string', 'int julianday', ' Converts a Julian Day Count to a Julian Calendar Date', 1042390499);
INSERT INTO php_manual VALUES (109, 'jdtounix', 'PHP 4', 'int', 'int jday', 'Convert Julian Day to UNIX timestamp', 1042390499);
INSERT INTO php_manual VALUES (110, 'JewishToJD', 'PHP 3, PHP 4', 'int', 'int month, int day, int year', ' Converts a date in the Jewish Calendar to Julian Day Count', 1042390499);
INSERT INTO php_manual VALUES (111, 'JulianToJD', 'PHP 3, PHP 4', 'int', 'int month, int day, int year', ' Converts a Julian Calendar date to Julian Day Count', 1042390499);
INSERT INTO php_manual VALUES (112, 'unixtojd', 'PHP 4', 'int', '[int timestamp]', 'Convert UNIX timestamp to Julian Day', 1042390499);
INSERT INTO php_manual VALUES (113, 'ccvs_add', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice, string argtype, string argval', 'Add data to a transaction', 1042390499);
INSERT INTO php_manual VALUES (114, 'ccvs_auth', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', ' Perform credit authorization test on a transaction', 1042390499);
INSERT INTO php_manual VALUES (115, 'ccvs_command', '4.0.2 - 4.2.3 only', 'string', 'string session, string type, string argval', ' Performs a command which is peculiar to a single protocol, and thus is not available in the general CCVS API', 1042390499);
INSERT INTO php_manual VALUES (116, 'ccvs_count', '4.0.2 - 4.2.3 only', 'int', 'string session, string type', ' Find out how many transactions of a given type are stored in the system', 1042390499);
INSERT INTO php_manual VALUES (117, 'ccvs_delete', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', 'Delete a transaction', 1042390499);
INSERT INTO php_manual VALUES (118, 'ccvs_done', '4.0.2 - 4.2.3 only', 'string', 'string sess', 'Terminate CCVS engine and do cleanup work', 1042390499);
INSERT INTO php_manual VALUES (119, 'ccvs_init', '4.0.2 - 4.2.3 only', 'string', 'string name', 'Initialize CCVS for use', 1042390499);
INSERT INTO php_manual VALUES (120, 'ccvs_lookup', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice, int inum', ' Look up an item of a particular type in the database #', 1042390499);
INSERT INTO php_manual VALUES (121, 'ccvs_new', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', 'Create a new, blank transaction', 1042390499);
INSERT INTO php_manual VALUES (122, 'ccvs_report', '4.0.2 - 4.2.3 only', 'string', 'string session, string type', 'Return the status of the background communication process', 1042390499);
INSERT INTO php_manual VALUES (123, 'ccvs_return', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', ' Transfer funds from the merchant to the credit card holder', 1042390499);
INSERT INTO php_manual VALUES (124, 'ccvs_reverse', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', ' Perform a full reversal on an already-processed authorization', 1042390499);
INSERT INTO php_manual VALUES (125, 'ccvs_sale', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', ' Transfer funds from the credit card holder to the merchant', 1042390499);
INSERT INTO php_manual VALUES (126, 'ccvs_status', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', 'Check the status of an invoice', 1042390499);
INSERT INTO php_manual VALUES (127, 'ccvs_textvalue', '4.0.2 - 4.2.3 only', 'string', 'string session', 'Get text return value for previous function call', 1042390499);
INSERT INTO php_manual VALUES (128, 'ccvs_void', '4.0.2 - 4.2.3 only', 'string', 'string session, string invoice', ' Perform a full reversal on a completed transaction', 1042390499);
INSERT INTO php_manual VALUES (129, 'call_user_method_array', 'PHP 4 >= 4.0.5', 'mixed', 'string method_name, object obj, [array paramarr]', ' Call a user method given with an array of parameters [deprecated]', 1042390499);
INSERT INTO php_manual VALUES (130, 'call_user_method', 'PHP 3>= 3.0.3, PHP 4', 'mixed', 'string method_name, object obj, [mixed parameter], [mixed ...]', ' Call a user method on an specific object [deprecated]', 1042390499);
INSERT INTO php_manual VALUES (131, 'class_exists', 'PHP 4', 'bool', 'string class_name', 'Checks if the class has been defined', 1042390499);
INSERT INTO php_manual VALUES (132, 'get_class_vars', 'PHP 4', 'array', 'string class_name', ' Returns an array of default properties of the class', 1042390500);
INSERT INTO php_manual VALUES (133, 'get_class', 'PHP 4', 'string', 'object obj', 'Returns the name of the class of an object', 1042390500);
INSERT INTO php_manual VALUES (134, 'get_declared_classes', 'PHP 4', 'array', 'void', 'Returns an array with the name of the defined classes', 1042390500);
INSERT INTO php_manual VALUES (135, 'get_object_vars', 'PHP 4', 'array', 'object obj', 'Returns an associative array of object properties', 1042390500);
INSERT INTO php_manual VALUES (136, 'get_parent_class', 'PHP 4', 'string', 'mixed obj', 'Retrieves the parent class name for object or class', 1042390500);
INSERT INTO php_manual VALUES (137, 'is_a', 'PHP 4 >= 4.2.0', '', 'void', '', 1042390500);
INSERT INTO php_manual VALUES (138, 'is_subclass_of', 'PHP 4', '', 'void', '', 1042390500);
INSERT INTO php_manual VALUES (139, 'method_exists', 'PHP 4', 'bool', 'object object, string method_name', 'Checks if the class method exists', 1042390500);
INSERT INTO php_manual VALUES (140, 'COM', '', 'string', 'string module_name, [string server_name], [int codepage]', 'COM class', 1042390500);
INSERT INTO php_manual VALUES (141, 'VARIANT', '', 'string', '[mixed value], [int type], [int codepage]', 'VARIANT class', 1042390500);
INSERT INTO php_manual VALUES (142, 'com_addref', 'PHP 4 >= 4.1.0', 'void', 'void', ' Increases the components reference counter.', 1042390500);
INSERT INTO php_manual VALUES (143, 'com_isenum', 'PHP 4 >= 4.1.0', 'void', 'object com_module', 'Grabs an IEnumVariant', 1042390500);
INSERT INTO php_manual VALUES (144, 'com_load_typelib', 'PHP 4 >= 4.1.0', 'void', 'string typelib_name, [int case_insensitive]', 'Loads a Typelib', 1042390500);
INSERT INTO php_manual VALUES (145, 'com_load', 'PHP 4 >= 4.0.5', 'string', 'string module name, [string server name ], [int codepage ]', ' Creates a new reference to a COM component', 1042390500);
INSERT INTO php_manual VALUES (146, 'com_release', 'PHP 4 >= 4.1.0', 'void', 'void', ' Decreases the components reference counter.', 1042390500);
INSERT INTO php_manual VALUES (147, 'cpdf_add_annotation', 'PHP 3>= 3.0.12, PHP 4', 'void', 'int pdf document, float llx, float lly, float urx, float ury, string title, string content, [int mode]', 'Adds annotation', 1042390500);
INSERT INTO php_manual VALUES (148, 'cpdf_add_outline', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document, string text', 'Adds bookmark for current page', 1042390500);
INSERT INTO php_manual VALUES (149, 'cpdf_arc', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, float radius, float start, float end, [int mode]', 'Draws an arc', 1042390500);
INSERT INTO php_manual VALUES (150, 'cpdf_begin_text', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Starts text section', 1042390500);
INSERT INTO php_manual VALUES (151, 'cpdf_circle', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, float radius, [int mode]', 'Draw a circle', 1042390500);
INSERT INTO php_manual VALUES (152, 'cpdf_clip', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Clips to current path', 1042390500);
INSERT INTO php_manual VALUES (153, 'cpdf_close', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Closes the pdf document', 1042390500);
INSERT INTO php_manual VALUES (154, 'cpdf_closepath_fill_stroke', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Close, fill and stroke current path', 1042390500);
INSERT INTO php_manual VALUES (155, 'cpdf_closepath_stroke', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Close path and draw line along path', 1042390500);
INSERT INTO php_manual VALUES (156, 'cpdf_closepath', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Close path', 1042390500);
INSERT INTO php_manual VALUES (157, 'cpdf_continue_text', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, string text', 'Output text in next line', 1042390500);
INSERT INTO php_manual VALUES (158, 'cpdf_curveto', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x1, float y1, float x2, float y2, float x3, float y3, [int mode]', 'Draws a curve', 1042390500);
INSERT INTO php_manual VALUES (159, 'cpdf_end_text', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Ends text section', 1042390500);
INSERT INTO php_manual VALUES (160, 'cpdf_fill_stroke', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Fill and stroke current path', 1042390500);
INSERT INTO php_manual VALUES (161, 'cpdf_fill', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Fill current path', 1042390500);
INSERT INTO php_manual VALUES (162, 'cpdf_setrgbcolor_stroke', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float red value, float green value, float blue value', 'Sets drawing color to rgb color value', 1042390500);
INSERT INTO php_manual VALUES (163, 'cpdf_finalize_page', 'PHP 3>= 3.0.10, PHP 4', 'void', 'int pdf document, int page number', 'Ends page', 1042390500);
INSERT INTO php_manual VALUES (164, 'cpdf_finalize', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Ends document', 1042390500);
INSERT INTO php_manual VALUES (165, 'cpdf_global_set_document_limits', 'PHP 4', 'void', 'int maxpages, int maxfonts, int maximages, int maxannotations, int maxobjects', 'Sets document limits for any pdf document', 1042390500);
INSERT INTO php_manual VALUES (166, 'cpdf_import_jpeg', 'PHP 3>= 3.0.9, PHP 4', 'int', 'int pdf document, string file name, float x-coor, float y-coor, float angle, float width, float height, float x-scale, float y-scale, [int mode]', 'Opens a JPEG image', 1042390500);
INSERT INTO php_manual VALUES (167, 'cpdf_lineto', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, [int mode]', 'Draws a line', 1042390501);
INSERT INTO php_manual VALUES (168, 'cpdf_moveto', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, [int mode]', 'Sets current point', 1042390501);
INSERT INTO php_manual VALUES (169, 'cpdf_newpath', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document', 'Starts a new path', 1042390501);
INSERT INTO php_manual VALUES (170, 'cpdf_open', 'PHP 3>= 3.0.8, PHP 4', 'int', 'int compression, [string filename]', 'Opens a new pdf document', 1042390501);
INSERT INTO php_manual VALUES (171, 'cpdf_output_buffer', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document', 'Outputs the pdf document in memory buffer', 1042390501);
INSERT INTO php_manual VALUES (172, 'cpdf_page_init', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, int page number, int orientation, float height, float width, [float unit]', 'Starts new page', 1042390501);
INSERT INTO php_manual VALUES (173, 'cpdf_place_inline_image', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document, int image, float x-coor, float y-coor, float angle, float width, float height, [int mode]', 'Places an image on the page', 1042390501);
INSERT INTO php_manual VALUES (174, 'cpdf_rect', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, float width, float height, [int mode]', 'Draw a rectangle', 1042390501);
INSERT INTO php_manual VALUES (175, 'cpdf_restore', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Restores formerly saved environment', 1042390501);
INSERT INTO php_manual VALUES (176, 'cpdf_rlineto', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, [int mode]', 'Draws a line', 1042390501);
INSERT INTO php_manual VALUES (177, 'cpdf_rmoveto', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, [int mode]', 'Sets current point', 1042390501);
INSERT INTO php_manual VALUES (178, 'cpdf_rotate_text', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdfdoc, float angle', ' Sets text rotation angle', 1042390501);
INSERT INTO php_manual VALUES (179, 'cpdf_rotate', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float angle', 'Sets rotation', 1042390501);
INSERT INTO php_manual VALUES (180, 'cpdf_save_to_file', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, string filename', 'Writes the pdf document into a file', 1042390501);
INSERT INTO php_manual VALUES (181, 'cpdf_save', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Saves current environment', 1042390501);
INSERT INTO php_manual VALUES (182, 'cpdf_scale', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-scale, float y-scale', 'Sets scaling', 1042390501);
INSERT INTO php_manual VALUES (183, 'cpdf_set_action_url', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdfdoc, float xll, float yll, float xur, float xur, string url, [int mode]', ' Sets hyperlink', 1042390501);
INSERT INTO php_manual VALUES (184, 'cpdf_set_char_spacing', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float space', 'Sets character spacing', 1042390501);
INSERT INTO php_manual VALUES (185, 'cpdf_set_creator', 'PHP 3>= 3.0.8, PHP 4', 'void', 'string creator', 'Sets the creator field in the pdf document', 1042390501);
INSERT INTO php_manual VALUES (186, 'cpdf_set_current_page', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document, int page number', 'Sets current page', 1042390501);
INSERT INTO php_manual VALUES (187, 'cpdf_set_font_directories', 'PHP 4 >= 4.0.6', 'void', 'int pdfdoc, string pfmdir, string pfbdir', ' Sets directories to search when using external fonts', 1042390501);
INSERT INTO php_manual VALUES (188, 'cpdf_set_font_map_file', 'PHP 4 >= 4.0.6', 'void', 'int pdfdoc, string filename', ' Sets fontname to filename translation map when using external fonts', 1042390501);
INSERT INTO php_manual VALUES (189, 'cpdf_set_font', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, string font name, float size, string encoding', 'Select the current font face and size', 1042390501);
INSERT INTO php_manual VALUES (190, 'cpdf_set_horiz_scaling', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float scale', 'Sets horizontal scaling of text', 1042390501);
INSERT INTO php_manual VALUES (191, 'cpdf_set_keywords', 'PHP 3>= 3.0.8, PHP 4', 'void', 'string keywords', 'Sets the keywords field of the pdf document', 1042390501);
INSERT INTO php_manual VALUES (192, 'cpdf_set_leading', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float distance', 'Sets distance between text lines', 1042390501);
INSERT INTO php_manual VALUES (193, 'cpdf_set_page_animation', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdf document, int transition, float duration', 'Sets duration between pages', 1042390501);
INSERT INTO php_manual VALUES (194, 'cpdf_set_subject', 'PHP 3>= 3.0.8, PHP 4', 'void', 'string subject', 'Sets the subject field of the pdf document', 1042390501);
INSERT INTO php_manual VALUES (195, 'cpdf_set_text_matrix', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, array matrix', 'Sets the text matrix', 1042390501);
INSERT INTO php_manual VALUES (196, 'cpdf_set_text_pos', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, [int mode]', 'Sets text position', 1042390501);
INSERT INTO php_manual VALUES (197, 'cpdf_set_text_rendering', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, int mode', 'Determines how text is rendered', 1042390501);
INSERT INTO php_manual VALUES (198, 'cpdf_set_text_rise', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float value', 'Sets the text rise', 1042390501);
INSERT INTO php_manual VALUES (199, 'cpdf_set_title', 'PHP 3>= 3.0.8, PHP 4', 'void', 'string title', 'Sets the title field of the pdf document', 1042390501);
INSERT INTO php_manual VALUES (200, 'cpdf_set_viewer_preferences', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int pdfdoc, array preferences', ' How to show the document in the viewer', 1042390501);
INSERT INTO php_manual VALUES (201, 'cpdf_set_word_spacing', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float space', 'Sets spacing between words', 1042390501);
INSERT INTO php_manual VALUES (202, 'cpdf_setdash', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float white, float black', 'Sets dash pattern', 1042390501);
INSERT INTO php_manual VALUES (203, 'cpdf_setflat', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float value', 'Sets flatness', 1042390501);
INSERT INTO php_manual VALUES (204, 'cpdf_setgray_fill', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float value', 'Sets filling color to gray value', 1042390501);
INSERT INTO php_manual VALUES (205, 'cpdf_setgray_stroke', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float gray value', 'Sets drawing color to gray value', 1042390501);
INSERT INTO php_manual VALUES (206, 'cpdf_setgray', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float gray value', 'Sets drawing and filling color to gray value', 1042390501);
INSERT INTO php_manual VALUES (207, 'cpdf_setlinecap', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, int value', 'Sets linecap parameter', 1042390501);
INSERT INTO php_manual VALUES (208, 'cpdf_setlinejoin', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, long value', 'Sets linejoin parameter', 1042390501);
INSERT INTO php_manual VALUES (209, 'cpdf_setlinewidth', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float width', 'Sets line width', 1042390501);
INSERT INTO php_manual VALUES (210, 'cpdf_setmiterlimit', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float value', 'Sets miter limit', 1042390501);
INSERT INTO php_manual VALUES (211, 'cpdf_setrgbcolor_fill', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float red value, float green value, float blue value', 'Sets filling color to rgb color value', 1042390501);
INSERT INTO php_manual VALUES (212, 'cpdf_setrgbcolor', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float red value, float green value, float blue value', 'Sets drawing and filling color to rgb color value', 1042390502);
INSERT INTO php_manual VALUES (213, 'cpdf_show_xy', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, string text, float x-coor, float y-coor, [int mode]', 'Output text at position', 1042390502);
INSERT INTO php_manual VALUES (214, 'cpdf_show', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, string text', 'Output text at current position', 1042390502);
INSERT INTO php_manual VALUES (215, 'cpdf_stringwidth', 'PHP 3>= 3.0.8, PHP 4', 'float', 'int pdf document, string text', 'Returns width of text in current font', 1042390502);
INSERT INTO php_manual VALUES (216, 'cpdf_stroke', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document', 'Draw line along path', 1042390502);
INSERT INTO php_manual VALUES (217, 'cpdf_text', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, string text, float x-coor, float y-coor, [int mode], [float orientation], [int alignmode]', 'Output text with parameters', 1042390502);
INSERT INTO php_manual VALUES (218, 'cpdf_translate', 'PHP 3>= 3.0.8, PHP 4', 'void', 'int pdf document, float x-coor, float y-coor, [int mode]', 'Sets origin of coordinate system', 1042390502);
INSERT INTO php_manual VALUES (219, 'crack_check', 'PHP 4 >= 4.0.5', 'bool', '[resource dictionary], string password', 'Performs an obscure check with the given password', 1042390502);
INSERT INTO php_manual VALUES (220, 'crack_closedict', 'PHP 4 >= 4.0.5', 'bool', '[resource dictionary]', 'Closes an open CrackLib dictionary', 1042390502);
INSERT INTO php_manual VALUES (221, 'crack_getlastmessage', 'PHP 4 >= 4.0.5', 'string', 'void', 'Returns the message from the last obscure check', 1042390502);
INSERT INTO php_manual VALUES (222, 'crack_opendict', 'PHP 4 >= 4.0.5', 'resource', 'string dictionary', 'Opens a new CrackLib dictionary', 1042390502);
INSERT INTO php_manual VALUES (223, 'ctype_alnum', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for alphanumeric character(s)', 1042390502);
INSERT INTO php_manual VALUES (224, 'ctype_alpha', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for alphabetic character(s)', 1042390502);
INSERT INTO php_manual VALUES (225, 'ctype_cntrl', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for control character(s)', 1042390502);
INSERT INTO php_manual VALUES (226, 'ctype_digit', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for numeric character(s)', 1042390502);
INSERT INTO php_manual VALUES (227, 'ctype_graph', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for any printable character(s) except space', 1042390502);
INSERT INTO php_manual VALUES (228, 'ctype_lower', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for lowercase character(s)', 1042390502);
INSERT INTO php_manual VALUES (229, 'ctype_print', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for printable character(s)', 1042390502);
INSERT INTO php_manual VALUES (230, 'ctype_punct', 'PHP 4 >= 4.0.4', 'bool', 'string text', ' Check for any printable character which is not whitespace or an alphanumeric character', 1042390502);
INSERT INTO php_manual VALUES (231, 'ctype_space', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for whitespace character(s)', 1042390502);
INSERT INTO php_manual VALUES (232, 'ctype_upper', 'PHP 4 >= 4.0.4', 'bool', 'string text', 'Check for uppercase character(s)', 1042390502);
INSERT INTO php_manual VALUES (233, 'ctype_xdigit', 'PHP 4 >= 4.0.4', 'bool', 'string text', ' Check for character(s) representing a hexadecimal digit', 1042390502);
INSERT INTO php_manual VALUES (234, 'curl_close', 'PHP 4 >= 4.0.2', 'void', 'resource ch', 'Close a CURL session', 1042390502);
INSERT INTO php_manual VALUES (235, 'curl_errno', 'PHP 4 >= 4.0.3', 'int', 'resource ch', 'Return an integer containing the last error number', 1042390502);
INSERT INTO php_manual VALUES (236, 'curl_error', 'PHP 4 >= 4.0.3', 'string', 'resource ch', ' Return a string containing the last error for the current session', 1042390502);
INSERT INTO php_manual VALUES (237, 'curl_exec', 'PHP 4 >= 4.0.2', 'bool', 'resource ch', 'Perform a CURL session', 1042390502);
INSERT INTO php_manual VALUES (238, 'curl_getinfo', 'PHP 4 >= 4.0.4', 'string', 'resource ch, int opt', ' Get information regarding a specific transfer', 1042390502);
INSERT INTO php_manual VALUES (239, 'curl_init', 'PHP 4 >= 4.0.2', 'resource', '[string url]', 'Initialize a CURL session', 1042390502);
INSERT INTO php_manual VALUES (240, 'curl_setopt', 'PHP 4 >= 4.0.2', 'bool', 'resource ch, string option, mixed value', 'Set an option for a CURL transfer', 1042390502);
INSERT INTO php_manual VALUES (241, 'curl_version', 'PHP 4 >= 4.0.2', 'string', 'void', 'Return the current CURL version', 1042390502);
INSERT INTO php_manual VALUES (242, 'cybercash_base64_decode', 'PHP 4  <= 4.2.3', 'string', 'string inbuff', 'base64 decode data for Cybercash', 1042390502);
INSERT INTO php_manual VALUES (243, 'cybercash_base64_encode', 'PHP 4  <= 4.2.3', 'string', 'string inbuff', 'base64 encode data for Cybercash', 1042390502);
INSERT INTO php_manual VALUES (244, 'cybercash_decr', 'PHP 4  <= 4.2.3', 'array', 'string wmk, string sk, string inbuff', 'Cybercash decrypt', 1042390502);
INSERT INTO php_manual VALUES (245, 'cybercash_encr', 'PHP 4  <= 4.2.3', 'array', 'string wmk, string sk, string inbuff', 'Cybercash encrypt', 1042390502);
INSERT INTO php_manual VALUES (246, 'cybermut_creerformulairecm', '4.0.5 - 4.2.3 only', 'string', 'string url_CM, string version, string TPE, string montant, string ref_commande, string texte_libre, string url_retour, string url_retour_ok, string url_retour_err, string langue, string code_societe, string texte_bouton', 'Generate HTML form of request for payment', 1042390502);
INSERT INTO php_manual VALUES (247, 'cybermut_creerreponsecm', '4.0.5 - 4.2.3 only', 'string', 'string phrase', ' Generate the acknowledgement of delivery of the confirmation of payment', 1042390502);
INSERT INTO php_manual VALUES (248, 'cybermut_testmac', '4.0.5 - 4.2.3 only', 'bool', 'string code_MAC, string version, string TPE, string cdate, string montant, string ref_commande, string texte_libre, string code-retour', ' Make sure that there no was data diddling contained in the received message of confirmation', 1042390502);
INSERT INTO php_manual VALUES (249, 'cyrus_authenticate', 'PHP 4 >= 4.1.0', 'bool', 'resource connection, [string mechlist], [string service], [string user], [int minssf], [int maxssf]', 'Authenticate against a Cyrus IMAP server', 1042390502);
INSERT INTO php_manual VALUES (250, 'cyrus_bind', 'PHP 4 >= 4.1.0', 'bool', 'resource connection, array callbacks', 'Bind callbacks to a Cyrus IMAP connection', 1042390502);
INSERT INTO php_manual VALUES (251, 'cyrus_close', 'PHP 4 >= 4.1.0', 'bool', 'resource connection', 'Close connection to a Cyrus IMAP server', 1042390502);
INSERT INTO php_manual VALUES (252, 'cyrus_connect', 'PHP 4 >= 4.1.0', 'resource', '[string host], [string port], [int flags]', 'Connect to a Cyrus IMAP server', 1042390503);
INSERT INTO php_manual VALUES (253, 'cyrus_query', 'PHP 4 >= 4.1.0', 'bool', 'resource connection, string query', 'Send a query to a Cyrus IMAP server', 1042390503);
INSERT INTO php_manual VALUES (254, 'cyrus_unbind', 'PHP 4 >= 4.1.0', 'bool', 'resource connection, string trigger_name', 'Unbind ...', 1042390503);
INSERT INTO php_manual VALUES (255, 'checkdate', 'PHP 3, PHP 4', 'bool', 'int month, int day, int year', 'Validate a gregorian date', 1042390503);
INSERT INTO php_manual VALUES (256, 'date', 'PHP 3, PHP 4', 'string', 'string format, [int timestamp ]', 'Format a local time/date', 1042390503);
INSERT INTO php_manual VALUES (257, 'getdate', 'PHP 3, PHP 4', 'array', '[int timestamp]', 'Get date/time information', 1042390503);
INSERT INTO php_manual VALUES (258, 'gettimeofday', 'PHP 3>= 3.0.7, PHP 4', 'array', 'void', 'Get current time', 1042390503);
INSERT INTO php_manual VALUES (259, 'gmdate', 'PHP 3, PHP 4', 'string', 'string format, [int timestamp]', 'Format a GMT/CUT date/time', 1042390503);
INSERT INTO php_manual VALUES (260, 'gmmktime', 'PHP 3, PHP 4', 'int', 'int hour, int minute, int second, int month, int day, int year, [int is_dst]', 'Get UNIX timestamp for a GMT date', 1042390503);
INSERT INTO php_manual VALUES (261, 'gmstrftime', 'PHP 3>= 3.0.12, PHP 4', 'string', 'string format, [int timestamp]', ' Format a GMT/CUT time/date according to locale settings', 1042390503);
INSERT INTO php_manual VALUES (262, 'localtime', 'PHP 4', 'array', '[int timestamp ], [bool is_associative ]', 'Get the local time', 1042390503);
INSERT INTO php_manual VALUES (263, 'microtime', 'PHP 3, PHP 4', 'string', 'void', ' Return current UNIX timestamp with microseconds', 1042390503);
INSERT INTO php_manual VALUES (264, 'mktime', 'PHP 3, PHP 4', 'int', 'int hour, int minute, int second, int month, int day, int year, [int is_dst]', 'Get UNIX timestamp for a date', 1042390503);
INSERT INTO php_manual VALUES (265, 'strftime', 'PHP 3, PHP 4', 'string', 'string format, [int timestamp ]', ' Format a local time/date according to locale settings', 1042390503);
INSERT INTO php_manual VALUES (266, 'strtotime', 'PHP 3>= 3.0.12, PHP 4', 'int', 'string time, [int now]', ' Parse about any English textual datetime description into a UNIX timestamp', 1042390503);
INSERT INTO php_manual VALUES (267, 'time', 'PHP 3, PHP 4', 'int', 'void', 'Return current UNIX timestamp', 1042390503);
INSERT INTO php_manual VALUES (268, 'dba_close', 'PHP 3>= 3.0.8, PHP 4', 'void', 'resource handle', 'Close database', 1042390503);
INSERT INTO php_manual VALUES (269, 'dba_delete', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'string key, resource handle', 'Delete entry specified by key', 1042390503);
INSERT INTO php_manual VALUES (270, 'dba_exists', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'string key, resource handle', 'Check whether key exists', 1042390503);
INSERT INTO php_manual VALUES (271, 'dba_fetch', 'PHP 3>= 3.0.8, PHP 4', 'string', 'string key, [int skip], resource handle', 'Fetch data specified by key', 1042390503);
INSERT INTO php_manual VALUES (272, 'dba_firstkey', 'PHP 3>= 3.0.8, PHP 4', 'string', 'resource handle', 'Fetch first key', 1042390503);
INSERT INTO php_manual VALUES (273, 'dba_handlers', 'PHP 4 >= 4.3.0', 'array', 'void', 'List handlers available', 1042390503);
INSERT INTO php_manual VALUES (274, 'dba_insert', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'string key, string value, resource handle', 'Insert entry', 1042390503);
INSERT INTO php_manual VALUES (275, 'dba_list', 'PHP 4 >= 4.3.0', 'array', 'void', 'List all open database files', 1042390503);
INSERT INTO php_manual VALUES (276, 'dba_nextkey', 'PHP 3>= 3.0.8, PHP 4', 'string', 'resource handle', 'Fetch next key', 1042390503);
INSERT INTO php_manual VALUES (277, 'dba_open', 'PHP 3>= 3.0.8, PHP 4', 'resource', 'string path, string mode, string handler, [ ...]', 'Open database', 1042390503);
INSERT INTO php_manual VALUES (278, 'dba_optimize', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'resource handle', 'Optimize database', 1042390503);
INSERT INTO php_manual VALUES (279, 'dba_popen', 'PHP 3>= 3.0.8, PHP 4', 'resource', 'string path, string mode, string handler, [ ...]', 'Open database persistently', 1042390503);
INSERT INTO php_manual VALUES (280, 'dba_replace', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'string key, string value, resource handle', 'Replace or insert entry', 1042390503);
INSERT INTO php_manual VALUES (281, 'dba_sync', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'resource handle', 'Synchronize database', 1042390503);
INSERT INTO php_manual VALUES (282, 'dbase_add_record', 'PHP 3, PHP 4', 'bool', 'int dbase_identifier, array record', 'Add a record to a dBase database', 1042390504);
INSERT INTO php_manual VALUES (283, 'dbase_close', 'PHP 3, PHP 4', 'bool', 'int dbase_identifier', 'Close a dBase database', 1042390504);
INSERT INTO php_manual VALUES (284, 'dbase_create', 'PHP 3, PHP 4', 'int', 'string filename, array fields', 'Creates a dBase database', 1042390504);
INSERT INTO php_manual VALUES (285, 'dbase_delete_record', 'PHP 3, PHP 4', 'bool', 'int dbase_identifier, int record', 'Deletes a record from a dBase database', 1042390504);
INSERT INTO php_manual VALUES (286, 'dbase_get_record_with_names', 'PHP 3>= 3.0.4, PHP 4', 'array', 'int dbase_identifier, int record', ' Gets a record from a dBase database as an associative array', 1042390504);
INSERT INTO php_manual VALUES (287, 'dbase_get_record', 'PHP 3, PHP 4', 'array', 'int dbase_identifier, int record', 'Gets a record from a dBase database', 1042390504);
INSERT INTO php_manual VALUES (288, 'dbase_numfields', 'PHP 3, PHP 4', 'int', 'int dbase_identifier', ' Find out how many fields are in a dBase database', 1042390504);
INSERT INTO php_manual VALUES (289, 'dbase_numrecords', 'PHP 3, PHP 4', 'int', 'int dbase_identifier', ' Find out how many records are in a dBase database', 1042390504);
INSERT INTO php_manual VALUES (290, 'dbase_open', 'PHP 3, PHP 4', 'int', 'string filename, int flags', 'Opens a dBase database', 1042390504);
INSERT INTO php_manual VALUES (291, 'dbase_pack', 'PHP 3, PHP 4', 'bool', 'int dbase_identifier', 'Packs a dBase database', 1042390504);
INSERT INTO php_manual VALUES (292, 'dbase_replace_record', 'PHP 3>= 3.0.11, PHP 4', 'bool', 'int dbase_identifier, array record, int dbase_record_number', 'Replace a record in a dBase database', 1042390504);
INSERT INTO php_manual VALUES (293, 'dblist', 'PHP 3, PHP 4', 'string', 'void', ' Describes the DBM-compatible library being used', 1042390504);
INSERT INTO php_manual VALUES (294, 'dbmclose', 'PHP 3, PHP 4', 'bool', 'resource dbm_identifier', 'Closes a dbm database', 1042390504);
INSERT INTO php_manual VALUES (295, 'dbmdelete', 'PHP 3, PHP 4', 'bool', 'resource dbm_identifier, string key', ' Deletes the value for a key from a DBM database', 1042390504);
INSERT INTO php_manual VALUES (296, 'dbmexists', 'PHP 3, PHP 4', 'bool', 'resource dbm_identifier, string key', ' Tells if a value exists for a key in a DBM database', 1042390504);
INSERT INTO php_manual VALUES (297, 'dbmfetch', 'PHP 3, PHP 4', 'string', 'resource dbm_identifier, string key', ' Fetches a value for a key from a DBM database', 1042390504);
INSERT INTO php_manual VALUES (298, 'dbmfirstkey', 'PHP 3, PHP 4', 'string', 'resource dbm_identifier', ' Retrieves the first key from a DBM database', 1042390504);
INSERT INTO php_manual VALUES (299, 'dbminsert', 'PHP 3, PHP 4', 'int', 'resource dbm_identifier, string key, string value', ' Inserts a value for a key in a DBM database', 1042390504);
INSERT INTO php_manual VALUES (300, 'dbmnextkey', 'PHP 3, PHP 4', 'string', 'resource dbm_identifier, string key', ' Retrieves the next key from a DBM database', 1042390504);
INSERT INTO php_manual VALUES (301, 'dbmopen', 'PHP 3, PHP 4', 'resource', 'string filename, string flags', 'Opens a DBM database', 1042390504);
INSERT INTO php_manual VALUES (302, 'dbmreplace', 'PHP 3, PHP 4', 'int', 'resource dbm_identifier, string key, string value', ' Replaces the value for a key in a DBM database', 1042390504);
INSERT INTO php_manual VALUES (303, 'dbplus_add', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple', 'Add a tuple to a relation', 1042390504);
INSERT INTO php_manual VALUES (304, 'dbplus_aql', '4.1.0 - 4.2.3 only', 'resource', 'string query, [string server], [string dbpath]', 'Perform AQL query', 1042390504);
INSERT INTO php_manual VALUES (305, 'dbplus_chdir', '4.1.0 - 4.2.3 only', 'string', '[string newdir]', 'Get/Set database virtual current directory', 1042390504);
INSERT INTO php_manual VALUES (306, 'dbplus_close', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Close a relation', 1042390504);
INSERT INTO php_manual VALUES (307, 'dbplus_curr', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple', 'Get current tuple from relation', 1042390504);
INSERT INTO php_manual VALUES (308, 'dbplus_errcode', '4.1.0 - 4.2.3 only', 'string', 'int errno', ' Get error string for given errorcode or last error', 1042390504);
INSERT INTO php_manual VALUES (309, 'dbplus_errno', '4.1.0 - 4.2.3 only', 'int', 'void', 'Get error code for last operation', 1042390504);
INSERT INTO php_manual VALUES (310, 'dbplus_find', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array constraints, mixed tuple', 'Set a constraint on a relation', 1042390504);
INSERT INTO php_manual VALUES (311, 'dbplus_first', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple', 'Get first tuple from relation', 1042390504);
INSERT INTO php_manual VALUES (312, 'dbplus_flush', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Flush all changes made on a relation', 1042390504);
INSERT INTO php_manual VALUES (313, 'dbplus_freealllocks', '4.1.0 - 4.2.3 only', 'int', 'void', 'Free all locks held by this client', 1042390504);
INSERT INTO php_manual VALUES (314, 'dbplus_freelock', '4.1.0 - 4.2.3 only', 'int', 'resource relation, string tname', 'Release write lock on tuple', 1042390504);
INSERT INTO php_manual VALUES (315, 'dbplus_freerlocks', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Free all tuple locks on given relation', 1042390504);
INSERT INTO php_manual VALUES (316, 'dbplus_getlock', '4.1.0 - 4.2.3 only', 'int', 'resource relation, string tname', 'Get a write lock on a tuple', 1042390504);
INSERT INTO php_manual VALUES (317, 'dbplus_getunique', '4.1.0 - 4.2.3 only', 'int', 'resource relation, int uniqueid', 'Get a id number unique to a relation', 1042390504);
INSERT INTO php_manual VALUES (318, 'dbplus_info', '4.1.0 - 4.2.3 only', 'int', 'resource relation, string key', '???', 1042390504);
INSERT INTO php_manual VALUES (319, 'dbplus_last', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple', 'Get last tuple from relation', 1042390504);
INSERT INTO php_manual VALUES (320, 'dbplus_lockrel', '', 'int', 'resource relation', 'Request write lock on relation', 1042390504);
INSERT INTO php_manual VALUES (321, 'dbplus_next', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Get next tuple from relation', 1042390504);
INSERT INTO php_manual VALUES (322, 'dbplus_open', '4.1.0 - 4.2.3 only', 'resource', 'string name', 'Open relation file', 1042390504);
INSERT INTO php_manual VALUES (323, 'dbplus_prev', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple', 'Get previous tuple from relation', 1042390504);
INSERT INTO php_manual VALUES (324, 'dbplus_rchperm', '4.1.0 - 4.2.3 only', 'int', 'resource relation, int mask, string user, string group', 'Change relation permissions', 1042390504);
INSERT INTO php_manual VALUES (325, 'dbplus_rcreate', '4.1.0 - 4.2.3 only', 'resource', 'string name, mixed domlist, [boolean overwrite]', 'Creates a new DB++ relation', 1042390504);
INSERT INTO php_manual VALUES (326, 'dbplus_rcrtexact', '4.1.0 - 4.2.3 only', 'resource', 'string name, resource relation, boolean overwrite', 'Creates an exact but empty copy of a relation including indices', 1042390504);
INSERT INTO php_manual VALUES (327, 'dbplus_rcrtlike', '4.1.0 - 4.2.3 only', 'resource', 'string name, resource relation, int flag', 'Creates an empty copy of a relation with default indices', 1042390504);
INSERT INTO php_manual VALUES (328, 'dbplus_resolve', '4.1.0 - 4.2.3 only', 'int', 'string relation_name', 'Resolve host information for relation', 1042390504);
INSERT INTO php_manual VALUES (329, 'dbplus_restorepos', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple', '???', 1042390504);
INSERT INTO php_manual VALUES (330, 'dbplus_rkeys', '4.1.0 - 4.2.3 only', 'resource', 'resource relation, mixed domlist', 'Specify new primary key for a relation', 1042390504);
INSERT INTO php_manual VALUES (331, 'dbplus_ropen', '4.1.0 - 4.2.3 only', 'resource', 'string name', 'Open relation file local', 1042390504);
INSERT INTO php_manual VALUES (332, 'dbplus_rquery', '4.1.0 - 4.2.3 only', 'int', 'string query, string dbpath', 'Perform local (raw) AQL query', 1042390504);
INSERT INTO php_manual VALUES (333, 'dbplus_rrename', '4.1.0 - 4.2.3 only', 'int', 'resource relation, string name', 'Rename a relation', 1042390504);
INSERT INTO php_manual VALUES (334, 'dbplus_rsecindex', '4.1.0 - 4.2.3 only', 'resource', 'resource relation, mixed domlist, int type', ' Create a new secondary index for a relation', 1042390504);
INSERT INTO php_manual VALUES (335, 'dbplus_runlink', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Remove relation from filesystem', 1042390504);
INSERT INTO php_manual VALUES (336, 'dbplus_rzap', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Remove all tuples from relation', 1042390504);
INSERT INTO php_manual VALUES (337, 'dbplus_savepos', '4.1.0 - 4.2.3 only', 'int', 'resource relation', '???', 1042390504);
INSERT INTO php_manual VALUES (338, 'dbplus_setindex', '4.1.0 - 4.2.3 only', 'int', 'resource relation, string idx_name', '???', 1042390504);
INSERT INTO php_manual VALUES (339, 'dbplus_setindexbynumber', '4.1.0 - 4.2.3 only', 'int', 'resource relation, int idx_number', '???', 1042390504);
INSERT INTO php_manual VALUES (340, 'dbplus_sql', '4.1.0 - 4.2.3 only', 'resource', 'string query, string server, string dbpath', 'Perform SQL query', 1042390505);
INSERT INTO php_manual VALUES (341, 'dbplus_tcl', '4.1.0 - 4.2.3 only', 'int', 'int sid, string script', 'Execute TCL code on server side', 1042390505);
INSERT INTO php_manual VALUES (342, 'dbplus_tremove', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array tuple, [array current]', 'Remove tuple and return new current tuple', 1042390505);
INSERT INTO php_manual VALUES (343, 'dbplus_undo', '4.1.0 - 4.2.3 only', 'int', 'resource relation', '???', 1042390505);
INSERT INTO php_manual VALUES (344, 'dbplus_undoprepare', '4.1.0 - 4.2.3 only', 'int', 'resource relation', '???', 1042390505);
INSERT INTO php_manual VALUES (345, 'dbplus_unlockrel', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Give up write lock on relation', 1042390505);
INSERT INTO php_manual VALUES (346, 'dbplus_unselect', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Remove a constraint from relation', 1042390505);
INSERT INTO php_manual VALUES (347, 'dbplus_update', '4.1.0 - 4.2.3 only', 'int', 'resource relation, array old, array new', 'Update specified tuple in relation', 1042390505);
INSERT INTO php_manual VALUES (348, 'dbplus_xlockrel', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Request exclusive lock on relation', 1042390505);
INSERT INTO php_manual VALUES (349, 'dbplus_xunlockrel', '4.1.0 - 4.2.3 only', 'int', 'resource relation', 'Free exclusive lock on relation', 1042390505);
INSERT INTO php_manual VALUES (350, 'dbx_close', 'PHP 4 >= 4.0.6', 'bool', 'object link_identifier', 'Close an open connection/database', 1042390505);
INSERT INTO php_manual VALUES (351, 'dbx_compare', 'PHP 4 >= 4.1.0', 'int', 'array row_a, array row_b, string column_key, [int flags]', 'Compare two rows for sorting purposes', 1042390505);
INSERT INTO php_manual VALUES (352, 'dbx_connect', 'PHP 4 >= 4.0.6', 'object', 'mixed module, string host, string database, string username, string password, [int persistent]', 'Open a connection/database', 1042390505);
INSERT INTO php_manual VALUES (353, 'dbx_error', 'PHP 4 >= 4.0.6', 'string', 'object link_identifier', ' Report the error message of the latest function call in the module (not just in the connection)', 1042390505);
INSERT INTO php_manual VALUES (354, 'dbx_escape_string', 'PHP 4 >= 4.3.0', 'string', 'object link_identifier, string text', ' Escape a string so it can safely be used in an sql-statement.', 1042390505);
INSERT INTO php_manual VALUES (355, 'dbx_query', 'PHP 4 >= 4.0.6', 'object', 'object link_identifier, string sql_statement, [long flags]', 'Send a query and fetch all results (if any)', 1042390505);
INSERT INTO php_manual VALUES (356, 'dbx_sort', 'PHP 4 >= 4.0.6', 'bool', 'object result, string user_compare_function', ' Sort a result from a dbx_query by a custom sort function', 1042390505);
INSERT INTO php_manual VALUES (357, 'dio_close', 'PHP 4 >= 4.2.0', 'void', 'resource fd', 'Closes the file descriptor given by fd', 1042390505);
INSERT INTO php_manual VALUES (358, 'dio_fcntl', 'PHP 4 >= 4.2.0', 'mixed', 'resource fd, int cmd, [mixed arg]', 'Performs a c library fcntl on fd', 1042390505);
INSERT INTO php_manual VALUES (359, 'dio_open', 'PHP 4 >= 4.2.0', 'resource', 'string filename, int flags, [int mode]', ' Opens a new filename with specified permissions of flags and creation permissions of mode', 1042390505);
INSERT INTO php_manual VALUES (360, 'dio_read', 'PHP 4 >= 4.2.0', 'string', 'resource fd, [int n]', ' Reads n bytes from fd and returns them, if n is not specified, reads 1k block', 1042390505);
INSERT INTO php_manual VALUES (361, 'dio_seek', 'PHP 4 >= 4.2.0', 'int', 'resource fd, int pos, int whence', 'Seeks to pos on fd from whence', 1042390505);
INSERT INTO php_manual VALUES (362, 'dio_stat', 'PHP 4 >= 4.2.0', 'array', 'resource fd', ' Gets stat information about the file descriptor fd', 1042390505);
INSERT INTO php_manual VALUES (363, 'dio_tcsetattr', 'PHP 4 >= 4.3.0', '', 'resource fd, array options', ' Sets terminal attributes and baud rate for a serial port', 1042390505);
INSERT INTO php_manual VALUES (364, 'dio_truncate', 'PHP 4 >= 4.2.0', 'bool', 'resource fd, int offset', ' Truncates file descriptor fd to offset bytes', 1042390505);
INSERT INTO php_manual VALUES (365, 'dio_write', 'PHP 4 >= 4.2.0', 'int', 'resource fd, string data, [int len]', ' Writes data to fd with optional truncation at length', 1042390505);
INSERT INTO php_manual VALUES (366, 'chdir', 'PHP 3, PHP 4', 'bool', 'string directory', 'change directory', 1042390505);
INSERT INTO php_manual VALUES (367, 'chroot', 'PHP 4 >= 4.0.5', 'bool', 'string directory', 'change the root directory', 1042390505);
INSERT INTO php_manual VALUES (368, 'dir', 'PHP 3, PHP 4', '', 'void', 'directory class', 1042390505);
INSERT INTO php_manual VALUES (369, 'closedir', 'PHP 3, PHP 4', 'void', 'resource dir_handle', 'close directory handle', 1042390505);
INSERT INTO php_manual VALUES (370, 'getcwd', 'PHP 4', 'string', 'void', 'gets the current working directory', 1042390505);
INSERT INTO php_manual VALUES (371, 'opendir', 'PHP 3, PHP 4', 'resource', 'string path', 'open directory handle', 1042390505);
INSERT INTO php_manual VALUES (372, 'readdir', 'PHP 3, PHP 4', 'string', 'resource dir_handle', 'read entry from directory handle', 1042390505);
INSERT INTO php_manual VALUES (373, 'rewinddir', 'PHP 3, PHP 4', 'void', 'resource dir_handle', 'rewind directory handle', 1042390505);
INSERT INTO php_manual VALUES (374, 'DomAttribute->name', '', 'bool', 'void', ' Returns name of attribute', 1042390505);
INSERT INTO php_manual VALUES (375, 'DomAttribute->specified', '', 'bool', 'void', ' Checks if attribute is specified', 1042390505);
INSERT INTO php_manual VALUES (376, 'DomAttribute->value', '', 'bool', 'void', ' Returns value of attribute', 1042390505);
INSERT INTO php_manual VALUES (377, 'DomDocument->add_root [deprecated]', '', 'resource', 'string name', ' Adds a root node', 1042390505);
INSERT INTO php_manual VALUES (378, 'DomDocument->create_attribute', '', 'object', 'string name, string value', ' Create new attribute', 1042390505);
INSERT INTO php_manual VALUES (379, 'DomDocument->create_cdata_section', '', 'string', 'string content', ' Create new cdata node', 1042390505);
INSERT INTO php_manual VALUES (380, 'DomDocument->create_comment', '', 'object', 'string content', ' Create new comment node', 1042390505);
INSERT INTO php_manual VALUES (381, 'DomDocument->create_element_ns', '', 'object', 'string uri, string name, [string prefix]', ' Create new element node with an associated namespace', 1042390506);
INSERT INTO php_manual VALUES (382, 'DomDocument->create_element', '', 'object', 'string name', ' Create new element node', 1042390506);
INSERT INTO php_manual VALUES (383, 'DomDocument->create_entity_reference', '', 'object', 'string content', '', 1042390506);
INSERT INTO php_manual VALUES (384, 'DomDocument->create_text_node', '', 'object', 'string content', ' Create new text node', 1042390506);
INSERT INTO php_manual VALUES (385, 'DomNode->node_value', '', 'string', 'void', ' Returns value of a node', 1042390506);
INSERT INTO php_manual VALUES (386, 'DomDocument->create_processing_instruction', '', 'string', 'string content', ' Creates new PI node', 1042390506);
INSERT INTO php_manual VALUES (387, 'DomDocument->doctype', '', 'object', 'void', ' Returns the document type', 1042390506);
INSERT INTO php_manual VALUES (388, 'DomDocument->document_element', '', 'object', 'void', ' Returns root element node', 1042390506);
INSERT INTO php_manual VALUES (389, 'DomDocument->dump_file', '', 'string', 'string filename, [bool compressionmode], [bool format]', ' Dumps the internal XML tree back into a file', 1042390506);
INSERT INTO php_manual VALUES (390, 'DomDocument->dump_mem', '', 'string', '[bool format], [string encoding]', ' Dumps the internal XML tree back into a string', 1042390506);
INSERT INTO php_manual VALUES (391, 'DomDocument->get_element_by_id', '', 'object', 'string id', ' Searches for an element with a certain id', 1042390506);
INSERT INTO php_manual VALUES (392, 'DomDocument->get_elements_by_tagname', '', 'array', 'string name', '', 1042390506);
INSERT INTO php_manual VALUES (393, 'DomDocument->html_dump_mem', '', 'string', 'void', ' Dumps the internal XML tree back into a string as HTML', 1042390506);
INSERT INTO php_manual VALUES (394, 'DomDocument->xinclude', '', 'int', 'void', ' Substitutes XIncludes in a DomDocument Object.', 1042390506);
INSERT INTO php_manual VALUES (395, 'DomDocumentType->entities', '', 'array', 'void', ' Returns list of entities', 1042390506);
INSERT INTO php_manual VALUES (396, 'DomDocumentType->internal_subset', '', 'bool', 'void', ' Returns internal subset', 1042390506);
INSERT INTO php_manual VALUES (397, 'DomDocumentType->name', '', 'string', 'void', ' Returns name of document type', 1042390506);
INSERT INTO php_manual VALUES (398, 'DomDocumentType->notations', '', 'array', 'void', ' Returns list of notations', 1042390506);
INSERT INTO php_manual VALUES (399, 'DomDocumentType->public_id', '', 'string', 'void', ' Returns public id of document type', 1042390506);
INSERT INTO php_manual VALUES (400, 'DomDocumentType->system_id', '', 'string', 'void', ' Returns system id of document type', 1042390506);
INSERT INTO php_manual VALUES (401, 'DomElement->get_attribute_node', '', 'object', 'object attr', ' Returns value of attribute', 1042390506);
INSERT INTO php_manual VALUES (402, 'DomElement->get_attribute', '', 'object', 'string name', ' Returns value of attribute', 1042390506);
INSERT INTO php_manual VALUES (403, 'DomElement->get_elements_by_tagname', '', 'bool', 'string name', ' Gets elements by tagname', 1042390506);
INSERT INTO php_manual VALUES (404, 'DomElement->has_attribute', '', 'bool', 'string name', ' Checks to see if attribute exists', 1042390506);
INSERT INTO php_manual VALUES (405, 'DomElement->remove_attribute', '', 'bool', 'string name', ' Removes attribute', 1042390506);
INSERT INTO php_manual VALUES (406, 'DomElement->set_attribute', '', 'bool', 'string name, string value', ' Adds new attribute', 1042390506);
INSERT INTO php_manual VALUES (407, 'DomElement->tagname', '', 'string', 'void', ' Returns name of element', 1042390506);
INSERT INTO php_manual VALUES (408, 'DomNode->add_namespace', '', 'bool', 'string uri, string prefix', ' Adds a namespace declaration to a node.', 1042390506);
INSERT INTO php_manual VALUES (409, 'xptr_eval', 'PHP 4 >= 4.0.4', 'int', '[object xpath_context], string eval_str', ' Evaluate the XPtr Location Path in the given string', 1042390506);
INSERT INTO php_manual VALUES (410, 'DomNode->append_child', '', 'object', 'object newnode', ' Adds new child at the end of the children', 1042390506);
INSERT INTO php_manual VALUES (411, 'DomNode->append_sibling', '', 'object', 'object newnode', ' Adds new sibling to a node', 1042390506);
INSERT INTO php_manual VALUES (412, 'DomNode->attributes', '', 'array', 'void', ' Returns list of attributes', 1042390506);
INSERT INTO php_manual VALUES (413, 'DomNode->child_nodes', '', 'array', 'void', ' Returns children of node', 1042390506);
INSERT INTO php_manual VALUES (414, 'DomNode->clone_node', '', 'object', 'void', ' Clones a node', 1042390506);
INSERT INTO php_manual VALUES (415, 'DomNode->dump_node', '', 'string', 'void', ' Dumps a single node', 1042390506);
INSERT INTO php_manual VALUES (416, 'DomNode->first_child', '', 'bool', 'void', ' Returns first child of node', 1042390506);
INSERT INTO php_manual VALUES (417, 'DomNode->get_content', '', 'string', 'void', ' Gets content of node', 1042390506);
INSERT INTO php_manual VALUES (418, 'DomNode->has_attributess', '', 'bool', 'void', ' Checks if node has attributes', 1042390506);
INSERT INTO php_manual VALUES (419, 'DomNode->has_child_nodes', '', 'bool', 'void', ' Checks if node has children', 1042390506);
INSERT INTO php_manual VALUES (420, 'DomNode->insert_before', '', 'object', 'object newnode, object refnode', ' Inserts new node as child', 1042390506);
INSERT INTO php_manual VALUES (421, 'DomNode->is_blank_node', '', 'bool', 'void', ' Checks if node is blank', 1042390506);
INSERT INTO php_manual VALUES (422, 'DomNode->last_child', '', 'object', 'void', ' Returns last child of node', 1042390506);
INSERT INTO php_manual VALUES (423, 'DomNode->next_sibling', '', 'object', 'void', ' Returns the next sibling of node', 1042390506);
INSERT INTO php_manual VALUES (424, 'DomNode->node_name', '', 'string', 'void', ' Returns name of node', 1042390506);
INSERT INTO php_manual VALUES (425, 'DomNode->node_type', '', 'int', 'void', ' Returns type of node', 1042390506);
INSERT INTO php_manual VALUES (426, 'DomNode->owner_document', '', 'object', 'void', ' Returns the document this node belongs to', 1042390506);
INSERT INTO php_manual VALUES (427, 'DomNode->parent_node', '', 'object', 'void', ' Returns the parent of the node', 1042390506);
INSERT INTO php_manual VALUES (428, 'DomNode->prefix', '', 'string', 'void', ' Returns name space prefix of node', 1042390506);
INSERT INTO php_manual VALUES (429, 'DomNode->previous_sibling', '', 'object', 'void', ' Returns the previous sibling of node', 1042390506);
INSERT INTO php_manual VALUES (430, 'DomNode->remove_child', '', 'object', 'object oldchild', ' Removes child from list of children', 1042390507);
INSERT INTO php_manual VALUES (431, 'DomNode->replace_child', '', 'object', 'object oldnode, object newnode', ' Replaces a child', 1042390507);
INSERT INTO php_manual VALUES (432, 'DomNode->replace_node', '', 'object', 'object newnode', ' Replaces node', 1042390507);
INSERT INTO php_manual VALUES (433, 'DomNode->set_content', '', 'bool', 'void', ' Sets content of node', 1042390507);
INSERT INTO php_manual VALUES (434, 'DomNode->set_name', '', 'bool', 'void', ' Sets name of node', 1042390507);
INSERT INTO php_manual VALUES (435, 'DomNode->set_namespace', '', 'void', 'string uri, [string prefix]', ' Sets namespace of a node.', 1042390507);
INSERT INTO php_manual VALUES (436, 'DomNode->unlink_node', '', 'object', 'void', ' Deletes node', 1042390507);
INSERT INTO php_manual VALUES (437, 'DomProcessingInstruction->data', '', 'string', 'void', ' Returns data of pi node', 1042390507);
INSERT INTO php_manual VALUES (438, 'DomProcessingInstruction->target', '', 'string', 'void', ' Returns target of pi node', 1042390507);
INSERT INTO php_manual VALUES (439, 'DomXsltStylesheet->process', '', 'object', 'object DomDocument, [array xslt_parameters], [bool param_is_xpath]', ' Applies the XSLT-Transformation on a DomDocument Object.', 1042390507);
INSERT INTO php_manual VALUES (440, 'DomXsltStylesheet->result_dump_file', '', 'string', 'object DomDocument, string filename', ' Dumps the result from a XSLT-Transformation into a file', 1042390507);
INSERT INTO php_manual VALUES (441, 'DomXsltStylesheet->result_dump_mem', '', 'string', 'object DomDocument', ' Dumps the result from a XSLT-Transformation back into a string', 1042390507);
INSERT INTO php_manual VALUES (442, 'domxml_new_doc', 'PHP 4 >= 4.2.1', 'object', 'string version', ' Creates new empty XML document', 1042390507);
INSERT INTO php_manual VALUES (443, 'domxml_open_file', 'PHP 4 >= 4.2.1', 'object', 'string filename', 'Creates a DOM object from XML file', 1042390507);
INSERT INTO php_manual VALUES (444, 'domxml_open_mem', 'PHP 4 >= 4.2.1', 'object', 'string str', 'Creates a DOM object of an XML document', 1042390507);
INSERT INTO php_manual VALUES (445, 'domxml_version', 'PHP 4 >= 4.1.0', 'string', 'void', ' Get XML library version', 1042390507);
INSERT INTO php_manual VALUES (446, 'domxml_xmltree', 'PHP 4 >= 4.2.1', 'object', 'string str', ' Creates a tree of PHP objects from an XML document', 1042390507);
INSERT INTO php_manual VALUES (447, 'domxml_xslt_stylesheet_doc', 'PHP 4 >= 4.2.0', 'object', 'object DocDocument Object', ' Creates a DomXsltStylesheet Object from a DomDocument Object.', 1042390507);
INSERT INTO php_manual VALUES (448, 'domxml_xslt_stylesheet_file', 'PHP 4 >= 4.2.0', 'object', 'string xsl file', ' Creates a DomXsltStylesheet Object from a xsl document in a file.', 1042390507);
INSERT INTO php_manual VALUES (449, 'domxml_xslt_stylesheet', 'PHP 4 >= 4.2.0', 'object', 'string xsl document', ' Creates a DomXsltStylesheet Object from a xml document in a string.', 1042390507);
INSERT INTO php_manual VALUES (450, 'xpath_eval_expression', 'PHP 4 >= 4.0.4', 'array', 'object xpath_context', ' Evaluates the XPath Location Path in the given string', 1042390507);
INSERT INTO php_manual VALUES (451, 'xpath_eval', 'PHP 4 >= 4.0.4', 'array', 'object xpath context, string xpath expression, [object contextnode]', ' Evaluates the XPath Location Path in the given string', 1042390507);
INSERT INTO php_manual VALUES (452, 'xpath_new_context', 'PHP 4 >= 4.0.4', 'object', 'object dom document', ' Creates new xpath context', 1042390507);
INSERT INTO php_manual VALUES (453, 'xptr_new_context', 'PHP 4 >= 4.0.4', 'string', '[object doc_handle]', ' Create new XPath Context', 1042390507);
INSERT INTO php_manual VALUES (454, 'dotnet_load', '', 'int', 'string assembly_name, [string datatype_name], [int codepage]', 'Loads a DOTNET module', 1042390507);
INSERT INTO php_manual VALUES (455, 'error_log', 'PHP 3, PHP 4', 'int', 'string message, [int message_type], [string destination], [string extra_headers]', 'send an error message somewhere', 1042390507);
INSERT INTO php_manual VALUES (456, 'error_reporting', 'PHP 3, PHP 4', 'int', '[int level]', 'set which PHP errors are reported', 1042390507);
INSERT INTO php_manual VALUES (457, 'restore_error_handler', 'PHP 4 >= 4.0.1', 'void', 'void', ' Restores the previous error handler function', 1042390507);
INSERT INTO php_manual VALUES (458, 'set_error_handler', 'PHP 4 >= 4.0.1', 'string', 'callback error_handler', ' Sets a user-defined error handler function.', 1042390507);
INSERT INTO php_manual VALUES (459, 'trigger_error', 'PHP 4 >= 4.0.1', 'void', 'string error_msg, [int error_type]', ' Generates a user-level error/warning/notice message', 1042390507);
INSERT INTO php_manual VALUES (460, 'user_error', 'PHP 4', 'void', 'string error_msg, [int error_type]', ' Generates a user-level error/warning/notice message', 1042390507);
INSERT INTO php_manual VALUES (461, 'escapeshellarg', 'PHP 4 >= 4.0.3', 'string', 'string arg', 'escape a string to be used as a shell argument', 1042390507);
INSERT INTO php_manual VALUES (462, 'escapeshellcmd', 'PHP 3, PHP 4', 'string', 'string command', 'escape shell metacharacters', 1042390507);
INSERT INTO php_manual VALUES (463, 'exec', 'PHP 3, PHP 4', 'string', 'string command, [array output ], [int return_var]', 'Execute an external program', 1042390507);
INSERT INTO php_manual VALUES (464, 'passthru', 'PHP 3, PHP 4', 'void', 'string command, [int return_var]', ' Execute an external program and display raw output', 1042390507);
INSERT INTO php_manual VALUES (465, 'proc_close', 'PHP 4 >= 4.3.0', 'int', 'resource process', ' Close a process opened by proc_open and return the exit code of that process.', 1042390507);
INSERT INTO php_manual VALUES (466, 'proc_open', 'PHP 4 >= 4.3.0', 'resource', 'string cmd, array descriptorspec, array pipes', ' Execute a command and open file pointers for input/output', 1042390507);
INSERT INTO php_manual VALUES (467, 'shell_exec', 'PHP 4', 'string', 'string cmd', ' Execute command via shell and return complete output as string', 1042390507);
INSERT INTO php_manual VALUES (468, 'system', 'PHP 3, PHP 4', 'string', 'string command, [int return_var]', 'Execute an external program and display output', 1042390507);
INSERT INTO php_manual VALUES (469, 'fbsql_affected_rows', 'PHP 4 >= 4.0.6', 'int', '[resource link_identifier ]', ' Get number of affected rows in previous FrontBase operation', 1042390507);
INSERT INTO php_manual VALUES (470, 'fbsql_autocommit', 'PHP 4 >= 4.0.6', 'bool', 'resource link_identifier, [bool OnOff]', 'Enable or disable autocommit', 1042390507);
INSERT INTO php_manual VALUES (471, 'fbsql_change_user', '', 'resource', 'string user, string password, [string database ], [resource link_identifier ]', ' Change logged in user of the active connection', 1042390507);
INSERT INTO php_manual VALUES (472, 'fbsql_close', 'PHP 4 >= 4.0.6', 'boolean', '[resource link_identifier ]', 'Close FrontBase connection', 1042390507);
INSERT INTO php_manual VALUES (473, 'fbsql_commit', 'PHP 4 >= 4.0.6', 'bool', '[resource link_identifier ]', 'Commits a transaction to the database', 1042390507);
INSERT INTO php_manual VALUES (474, 'fbsql_connect', 'PHP 4 >= 4.0.6', 'resource', '[string hostname], [string username], [string password]', 'Open a connection to a FrontBase Server', 1042390507);
INSERT INTO php_manual VALUES (475, 'fbsql_create_blob', 'PHP 4 >= 4.2.0', 'string', 'string blob_data, [resource link_identifier ]', 'Create a BLOB', 1042390508);
INSERT INTO php_manual VALUES (476, 'fbsql_create_clob', 'PHP 4 >= 4.2.0', 'string', 'string clob_data, [resource link_identifier ]', 'Create a CLOB', 1042390508);
INSERT INTO php_manual VALUES (477, 'fbsql_create_db', 'PHP 4 >= 4.0.6', 'bool', 'string database name, [resource link_identifier ]', 'Create a FrontBase database', 1042390508);
INSERT INTO php_manual VALUES (478, 'fbsql_data_seek', 'PHP 4 >= 4.0.6', 'bool', 'resource result_identifier, int row_number', 'Move internal result pointer', 1042390508);
INSERT INTO php_manual VALUES (479, 'fbsql_database_password', 'PHP 4 >= 4.0.6', 'string', 'resource link_identifier, [string database_password ]', ' Sets or retrieves the password for a FrontBase database', 1042390508);
INSERT INTO php_manual VALUES (480, 'fbsql_database', 'PHP 4 >= 4.0.6', 'string', 'resource link_identifier, [string database]', 'Get or set the database name used with a connection', 1042390508);
INSERT INTO php_manual VALUES (481, 'fbsql_db_query', 'PHP 4 >= 4.0.6', 'resource', 'string database, string query, [resource link_identifier ]', 'Send a FrontBase query', 1042390508);
INSERT INTO php_manual VALUES (482, 'fbsql_db_status', 'PHP 4 >= 4.1.0', 'int', 'string database_name, [resource link_identifier ]', 'Get the status for a given database', 1042390508);
INSERT INTO php_manual VALUES (483, 'fbsql_drop_db', 'PHP 4 >= 4.0.6', 'bool', 'string database_name, [resource link_identifier ]', 'Drop (delete) a FrontBase database', 1042390508);
INSERT INTO php_manual VALUES (484, 'fbsql_errno', 'PHP 4 >= 4.0.6', 'int', '[resource link_identifier ]', ' Returns the numerical value of the error message from previous FrontBase operation', 1042390508);
INSERT INTO php_manual VALUES (485, 'fbsql_error', 'PHP 4 >= 4.0.6', 'string', '[resource link_identifier ]', ' Returns the text of the error message from previous FrontBase operation', 1042390508);
INSERT INTO php_manual VALUES (486, 'fbsql_fetch_array', 'PHP 4 >= 4.0.6', 'array', 'resource result, [int result_type ]', ' Fetch a result row as an associative array, a numeric array, or both', 1042390508);
INSERT INTO php_manual VALUES (487, 'fbsql_fetch_assoc', 'PHP 4 >= 4.0.6', 'array', 'resource result', ' Fetch a result row as an associative array', 1042390508);
INSERT INTO php_manual VALUES (488, 'fbsql_fetch_field', 'PHP 4 >= 4.0.6', 'object', 'resource result, [int field_offset ]', ' Get column information from a result and return as an object', 1042390508);
INSERT INTO php_manual VALUES (489, 'fbsql_fetch_lengths', 'PHP 4 >= 4.0.6', 'array', '[resource result]', ' Get the length of each output in a result', 1042390508);
INSERT INTO php_manual VALUES (490, 'fbsql_fetch_object', 'PHP 4 >= 4.0.6', 'object', 'resource result, [int result_type ]', 'Fetch a result row as an object', 1042390508);
INSERT INTO php_manual VALUES (491, 'fbsql_fetch_row', 'PHP 4 >= 4.0.6', 'array', 'resource result', 'Get a result row as an enumerated array', 1042390508);
INSERT INTO php_manual VALUES (492, 'fbsql_field_flags', 'PHP 4 >= 4.0.6', 'string', 'resource result, int field_offset', ' Get the flags associated with the specified field in a result', 1042390508);
INSERT INTO php_manual VALUES (493, 'fbsql_field_len', 'PHP 4 >= 4.0.6', 'int', 'resource result, int field_offset', ' Returns the length of the specified field', 1042390508);
INSERT INTO php_manual VALUES (494, 'fbsql_field_name', 'PHP 4 >= 4.0.6', 'string', 'resource result, int field_index', ' Get the name of the specified field in a result', 1042390508);
INSERT INTO php_manual VALUES (495, 'fbsql_field_seek', 'PHP 4 >= 4.0.6', 'bool', 'resource result, int field_offset', ' Set result pointer to a specified field offset', 1042390508);
INSERT INTO php_manual VALUES (496, 'fbsql_field_table', 'PHP 4 >= 4.0.6', 'string', 'resource result, int field_offset', ' Get name of the table the specified field is in', 1042390508);
INSERT INTO php_manual VALUES (497, 'fbsql_field_type', 'PHP 4 >= 4.0.6', 'string', 'resource result, int field_offset', ' Get the type of the specified field in a result', 1042390508);
INSERT INTO php_manual VALUES (498, 'fbsql_free_result', 'PHP 4 >= 4.0.6', 'bool', 'resource result', 'Free result memory', 1042390508);
INSERT INTO php_manual VALUES (499, 'fbsql_get_autostart_info', 'PHP 4 >= 4.1.0', 'array', '[resource link_identifier]', 'No description given yet', 1042390508);
INSERT INTO php_manual VALUES (500, 'fbsql_hostname', 'PHP 4 >= 4.0.6', 'string', 'resource link_identifier, [string host_name]', 'Get or set the host name used with a connection', 1042390508);
INSERT INTO php_manual VALUES (501, 'fbsql_insert_id', 'PHP 4 >= 4.0.6', 'int', '[resource link_identifier ]', ' Get the id generated from the previous INSERT operation', 1042390508);
INSERT INTO php_manual VALUES (502, 'fbsql_list_dbs', 'PHP 4 >= 4.0.6', 'resource', '[resource link_identifier ]', ' List databases available on a FrontBase server', 1042390508);
INSERT INTO php_manual VALUES (503, 'fbsql_list_fields', 'PHP 4 >= 4.0.6', 'resource', 'string database_name, string table_name, [resource link_identifier ]', 'List FrontBase result fields', 1042390508);
INSERT INTO php_manual VALUES (504, 'fbsql_list_tables', 'PHP 4 >= 4.0.6', 'resource', 'string database, [resource link_identifier ]', 'List tables in a FrontBase database', 1042390508);
INSERT INTO php_manual VALUES (505, 'fbsql_next_result', 'PHP 4 >= 4.0.6', 'bool', 'resource result_id', ' Move the internal result pointer to the next result', 1042390508);
INSERT INTO php_manual VALUES (506, 'fbsql_num_fields', 'PHP 4 >= 4.0.6', 'int', 'resource result', 'Get number of fields in result', 1042390508);
INSERT INTO php_manual VALUES (507, 'fbsql_num_rows', 'PHP 4 >= 4.0.6', 'int', 'resource result', 'Get number of rows in result', 1042390508);
INSERT INTO php_manual VALUES (508, 'fbsql_password', 'PHP 4 >= 4.0.6', 'string', 'resource link_identifier, [string password]', 'Get or set the user password used with a connection', 1042390508);
INSERT INTO php_manual VALUES (509, 'fbsql_pconnect', 'PHP 4 >= 4.0.6', 'resource', '[string hostname], [string username], [string password]', ' Open a persistent connection to a FrontBase Server', 1042390508);
INSERT INTO php_manual VALUES (510, 'fbsql_query', 'PHP 4 >= 4.0.6', 'resource', 'string query, [resource link_identifier]', 'Send a FrontBase query', 1042390508);
INSERT INTO php_manual VALUES (511, 'fbsql_read_blob', 'PHP 4 >= 4.2.0', 'string', 'string blob_handle, [resource link_identifier ]', 'Read a BLOB from the database', 1042390508);
INSERT INTO php_manual VALUES (512, 'fbsql_read_clob', 'PHP 4 >= 4.2.0', 'string', 'string clob_handle, [resource link_identifier ]', 'Read a CLOB from the database', 1042390508);
INSERT INTO php_manual VALUES (513, 'fbsql_result', 'PHP 4 >= 4.0.6', 'mixed', 'resource result, int row, [mixed field ]', 'Get result data', 1042390508);
INSERT INTO php_manual VALUES (514, 'fbsql_rollback', 'PHP 4 >= 4.0.6', 'bool', '[resource link_identifier ]', 'Rollback a transaction to the database', 1042390508);
INSERT INTO php_manual VALUES (515, 'fbsql_select_db', 'PHP 4 >= 4.0.6', 'bool', 'string database_name, [resource link_identifier ]', 'Select a FrontBase database', 1042390508);
INSERT INTO php_manual VALUES (516, 'fbsql_set_lob_mode', 'PHP 4 >= 4.2.0', 'bool', 'resource result, string database_name', ' Set the LOB retrieve mode for a FrontBase result set', 1042390508);
INSERT INTO php_manual VALUES (517, 'fbsql_set_transaction', 'PHP 4 >= 4.2.0', 'void', 'resource link_identifier, int Locking, int Isolation', ' Set the transaction locking and isolation', 1042390508);
INSERT INTO php_manual VALUES (518, 'fbsql_start_db', 'PHP 4 >= 4.0.6', 'bool', 'string database_name, [resource link_identifier ]', 'Start a database on local or remote server', 1042390508);
INSERT INTO php_manual VALUES (519, 'fbsql_stop_db', 'PHP 4 >= 4.0.6', 'bool', 'string database_name, [resource link_identifier ]', 'Stop a database on local or remote server', 1042390508);
INSERT INTO php_manual VALUES (520, 'fbsql_tablename', 'PHP 4 >= 4.2.0', 'string', 'resource result, int i', 'Get table name of field', 1042390509);
INSERT INTO php_manual VALUES (521, 'fbsql_username', 'PHP 4 >= 4.0.6', 'string', 'resource link_identifier, [string username]', 'Get or set the host user used with a connection', 1042390509);
INSERT INTO php_manual VALUES (522, 'fbsql_warnings', 'PHP 4 >= 4.0.6', 'bool', '[bool OnOff ]', 'Enable or disable FrontBase warnings', 1042390509);
INSERT INTO php_manual VALUES (523, 'fdf_add_doc_javascript', 'PHP 4 >= 4.3.0', 'bool', 'resource fdfdoc, string script_name, string script_code', 'Adds javascript code to the FDF document', 1042390509);
INSERT INTO php_manual VALUES (524, 'fdf_add_template', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'int fdfdoc, int newpage, string filename, string template, int rename', 'Adds a template into the FDF document', 1042390509);
INSERT INTO php_manual VALUES (525, 'fdf_close', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource fdf_document', 'Close an FDF document', 1042390509);
INSERT INTO php_manual VALUES (526, 'fdf_create', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'void', 'Create a new FDF document', 1042390509);
INSERT INTO php_manual VALUES (527, 'fdf_errno', 'PHP 4 >= 4.3.0', 'int', 'void', 'Return error code for last fdf operation', 1042390509);
INSERT INTO php_manual VALUES (528, 'fdf_error', 'PHP 4 >= 4.3.0', 'string', '[int error_code]', 'Return error description for fdf error code', 1042390509);
INSERT INTO php_manual VALUES (529, 'fdf_get_ap', 'PHP 4 >= 4.3.0', 'bool', 'resource fdf_document, string field, int face, string filename', 'Get the appearance of a field', 1042390509);
INSERT INTO php_manual VALUES (530, 'fdf_get_attachment', 'PHP 4 >= 4.3.0', 'array', 'resource fdf_document, string fieldname, string savepath', 'Extracts uploaded file embedded in the FDF', 1042390509);
INSERT INTO php_manual VALUES (531, 'fdf_get_encoding', 'PHP 4 >= 4.3.0', 'string', 'resource fdf_document', 'Get the value of the /Encoding key', 1042390509);
INSERT INTO php_manual VALUES (532, 'fdf_get_file', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource fdf_document', 'Get the value of the /F key', 1042390509);
INSERT INTO php_manual VALUES (533, 'fdf_get_status', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource fdf_document', 'Get the value of the /STATUS key', 1042390509);
INSERT INTO php_manual VALUES (534, 'fdf_get_value', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource fdf_document, string fieldname, [int which]', 'Get the value of a field', 1042390509);
INSERT INTO php_manual VALUES (535, 'fdf_get_version', 'PHP 4 >= 4.3.0', 'string', '[resource fdf_document]', 'Gets version number for FDF api or file', 1042390509);
INSERT INTO php_manual VALUES (536, 'fdf_header', 'PHP 4 >= 4.3.0', 'bool', 'void', 'Sets FDF-specific output headers', 1042390509);
INSERT INTO php_manual VALUES (537, 'fdf_next_field_name', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource fdf_document, [string fieldname]', 'Get the next field name', 1042390509);
INSERT INTO php_manual VALUES (538, 'fdf_open_string', 'PHP 4 >= 4.3.0', 'resource', 'string fdf_data', 'Read a FDF document from a string', 1042390509);
INSERT INTO php_manual VALUES (539, 'fdf_open', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'string filename', 'Open a FDF document', 1042390509);
INSERT INTO php_manual VALUES (540, 'fdf_save_string', 'PHP 4 >= 4.3.0', 'string', 'resource fdf_document', 'Returns the FDF document as a string', 1042390509);
INSERT INTO php_manual VALUES (541, 'fdf_save', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource fdf_document, [string filename]', 'Save a FDF document', 1042390509);
INSERT INTO php_manual VALUES (542, 'fdf_set_ap', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource fdf_document, string field_name, int face, string filename, int page_number', 'Set the appearance of a field', 1042390509);
INSERT INTO php_manual VALUES (543, 'fdf_set_encoding', 'PHP 4 >= 4.1.0', 'bool', 'resource fdf_document, string encoding', 'Sets FDF character encoding', 1042390509);
INSERT INTO php_manual VALUES (544, 'fdf_set_file', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource fdf_document, string url, [string target_frame]', 'Set PDF document to display FDF data in', 1042390509);
INSERT INTO php_manual VALUES (545, 'fdf_set_flags', 'PHP 4 >= 4.0.2', 'bool', 'resource fdf_document, string fieldname, int whichFlags, int newFlags', 'Sets a flag of a field', 1042390509);
INSERT INTO php_manual VALUES (546, 'fdf_set_javascript_action', 'PHP 4 >= 4.0.2', 'bool', 'resource fdf_document, string fieldname, int trigger, string script', 'Sets an javascript action of a field', 1042390509);
INSERT INTO php_manual VALUES (547, 'fdf_set_opt', 'PHP 4 >= 4.0.2', 'bool', 'resource fdf_document, string fieldname, int element, string str1, string str2', 'Sets an option of a field', 1042390509);
INSERT INTO php_manual VALUES (548, 'fdf_set_status', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource fdf_document, string status', 'Set the value of the /STATUS key', 1042390509);
INSERT INTO php_manual VALUES (549, 'fdf_set_submit_form_action', 'PHP 4 >= 4.0.2', 'bool', 'resource fdf_document, string fieldname, int trigger, string script, int flags', 'Sets a submit form action of a field', 1042390509);
INSERT INTO php_manual VALUES (550, 'fdf_set_target_frame', 'PHP 4 >= 4.3.0', 'bool', 'resource fdf_document, string frame_name', 'Set target frame for form display', 1042390509);
INSERT INTO php_manual VALUES (551, 'fdf_set_value', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource fdf_document, string fieldname, mixed value, [int isName]', 'Set the value of a field', 1042390509);
INSERT INTO php_manual VALUES (552, 'fdf_set_version', 'PHP 4 >= 4.3.0', 'string', 'resource fdf_document, string version', 'Sets version number for a FDF file', 1042390509);
INSERT INTO php_manual VALUES (553, 'filepro_fieldcount', 'PHP 3, PHP 4', 'int', 'void', 'Find out how many fields are in a filePro database', 1042390509);
INSERT INTO php_manual VALUES (554, 'filepro_fieldname', 'PHP 3, PHP 4', 'string', 'int field_number', 'Gets the name of a field', 1042390509);
INSERT INTO php_manual VALUES (555, 'filepro_fieldtype', 'PHP 3, PHP 4', 'string', 'int field_number', 'Gets the type of a field', 1042390509);
INSERT INTO php_manual VALUES (556, 'filepro_fieldwidth', 'PHP 3, PHP 4', 'int', 'int field_number', 'Gets the width of a field', 1042390509);
INSERT INTO php_manual VALUES (557, 'filepro_retrieve', 'PHP 3, PHP 4', 'string', 'int row_number, int field_number', 'Retrieves data from a filePro database', 1042390509);
INSERT INTO php_manual VALUES (558, 'filepro_rowcount', 'PHP 3, PHP 4', 'int', 'void', 'Find out how many rows are in a filePro database', 1042390509);
INSERT INTO php_manual VALUES (559, 'filepro', 'PHP 3, PHP 4', 'bool', 'string directory', 'Read and verify the map file', 1042390509);
INSERT INTO php_manual VALUES (560, 'basename', 'PHP 3, PHP 4', 'string', 'string path, [string suffix]', 'Returns filename component of path', 1042390509);
INSERT INTO php_manual VALUES (561, 'chgrp', 'PHP 3, PHP 4', 'int', 'string filename, mixed group', 'Changes file group', 1042390509);
INSERT INTO php_manual VALUES (562, 'chmod', 'PHP 3, PHP 4', 'int', 'string filename, int mode', 'Changes file mode', 1042390509);
INSERT INTO php_manual VALUES (563, 'chown', 'PHP 3, PHP 4', 'int', 'string filename, mixed user', 'Changes file owner', 1042390509);
INSERT INTO php_manual VALUES (564, 'clearstatcache', 'PHP 3, PHP 4', 'void', 'void', 'Clears file status cache', 1042390510);
INSERT INTO php_manual VALUES (565, 'copy', 'PHP 3, PHP 4', 'int', 'string source, string dest', 'Copies file', 1042390510);
INSERT INTO php_manual VALUES (566, 'delete', '', 'void', 'string file', 'See unlink or unset', 1042390510);
INSERT INTO php_manual VALUES (567, 'dirname', 'PHP 3, PHP 4', 'string', 'string path', 'Returns directory name component of path', 1042390510);
INSERT INTO php_manual VALUES (568, 'disk_free_space', 'PHP 4 >= 4.1.0', 'float', 'string directory', 'Returns available space in directory', 1042390510);
INSERT INTO php_manual VALUES (569, 'disk_total_space', 'PHP 4 >= 4.1.0', 'float', 'string directory', 'Returns the total size of a directory', 1042390510);
INSERT INTO php_manual VALUES (570, 'diskfreespace', 'PHP 3>= 3.0.7, PHP 4', 'float', 'string directory', 'Alias of disk_free_space', 1042390510);
INSERT INTO php_manual VALUES (571, 'fclose', 'PHP 3, PHP 4', 'bool', 'int fp', 'Closes an open file pointer', 1042390510);
INSERT INTO php_manual VALUES (572, 'feof', 'PHP 3, PHP 4', 'int', 'int fp', 'Tests for end-of-file on a file pointer', 1042390510);
INSERT INTO php_manual VALUES (573, 'fflush', 'PHP 4 >= 4.0.1', 'int', 'int fp', 'Flushes the output to a file', 1042390510);
INSERT INTO php_manual VALUES (574, 'fgetc', 'PHP 3, PHP 4', 'string', 'int fp', 'Gets character from file pointer', 1042390510);
INSERT INTO php_manual VALUES (575, 'fgetcsv', 'PHP 3>= 3.0.8, PHP 4', 'array', 'int fp, int length, [string delimiter], [string enclosure]', 'Gets line from file pointer and parse for CSV fields', 1042390510);
INSERT INTO php_manual VALUES (576, 'fgets', 'PHP 3, PHP 4', 'string', 'int fp, [int length]', 'Gets line from file pointer', 1042390510);
INSERT INTO php_manual VALUES (577, 'fgetss', 'PHP 3, PHP 4', 'string', 'int fp, int length, [string allowable_tags]', 'Gets line from file pointer and strip HTML tags', 1042390510);
INSERT INTO php_manual VALUES (578, 'file_exists', 'PHP 3, PHP 4', 'bool', 'string filename', 'Checks whether a file exists', 1042390510);
INSERT INTO php_manual VALUES (579, 'file', 'PHP 3, PHP 4', 'array', 'string filename, [int use_include_path]', 'Reads entire file into an array', 1042390510);
INSERT INTO php_manual VALUES (580, 'file_get_contents', 'PHP 4 >= 4.3.0', 'string', 'string filename, [int use_include_path]', 'Reads entire file into a string', 1042390510);
INSERT INTO php_manual VALUES (581, 'fileatime', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets last access time of file', 1042390510);
INSERT INTO php_manual VALUES (582, 'filectime', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets inode change time of file', 1042390510);
INSERT INTO php_manual VALUES (583, 'filegroup', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets file group', 1042390510);
INSERT INTO php_manual VALUES (584, 'fileinode', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets file inode', 1042390510);
INSERT INTO php_manual VALUES (585, 'filemtime', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets file modification time', 1042390510);
INSERT INTO php_manual VALUES (586, 'fileowner', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets file owner', 1042390510);
INSERT INTO php_manual VALUES (587, 'fileperms', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets file permissions', 1042390510);
INSERT INTO php_manual VALUES (588, 'filesize', 'PHP 3, PHP 4', 'int', 'string filename', 'Gets file size', 1042390510);
INSERT INTO php_manual VALUES (589, 'filetype', 'PHP 3, PHP 4', 'string', 'string filename', 'Gets file type', 1042390510);
INSERT INTO php_manual VALUES (590, 'flock', 'PHP 3>= 3.0.7, PHP 4', 'bool', 'int fp, int operation, [int &wouldblock]', 'Portable advisory file locking', 1042390510);
INSERT INTO php_manual VALUES (591, 'fnmatch', 'PHP 4 >= 4.3.0', 'array', 'string pattern, string string, [int flags]', 'Match filename against a pattern', 1042390510);
INSERT INTO php_manual VALUES (592, 'fopen', 'PHP 3, PHP 4', 'int', 'string filename, string mode, [int use_include_path], [resource zcontext]', 'Opens file or URL', 1042390510);
INSERT INTO php_manual VALUES (593, 'fpassthru', 'PHP 3, PHP 4', 'int', 'int fp', 'Output all remaining data on a file pointer', 1042390510);
INSERT INTO php_manual VALUES (594, 'fputs', 'PHP 3, PHP 4', 'int', 'int fp, string str, [int length]', 'Writes to a file pointer', 1042390510);
INSERT INTO php_manual VALUES (595, 'fread', 'PHP 3, PHP 4', 'string', 'int fp, int length', 'Binary-safe file read', 1042390510);
INSERT INTO php_manual VALUES (596, 'fscanf', 'PHP 4 >= 4.0.1', 'mixed', 'int handle, string format, [string var1]', 'Parses input from a file according to a format', 1042390510);
INSERT INTO php_manual VALUES (597, 'fseek', 'PHP 3, PHP 4', 'int', 'int fp, int offset, [int whence]', 'Seeks on a file pointer', 1042390510);
INSERT INTO php_manual VALUES (598, 'fstat', 'PHP 4', 'array', 'int fp', 'Gets information about a file using an open file pointer', 1042390510);
INSERT INTO php_manual VALUES (599, 'ftell', 'PHP 3, PHP 4', 'int', 'int fp', 'Tells file pointer read/write position', 1042390510);
INSERT INTO php_manual VALUES (600, 'ftruncate', 'PHP 4', 'int', 'int fp, int size', 'Truncates a file to a given length', 1042390510);
INSERT INTO php_manual VALUES (601, 'fwrite', 'PHP 3, PHP 4', 'int', 'int fp, string string, [int length]', 'Binary-safe file write', 1042390510);
INSERT INTO php_manual VALUES (602, 'glob', 'PHP 4 >= 4.3.0', 'array', 'string pattern, [int flags]', 'Find pathnames matching a pattern', 1042390510);
INSERT INTO php_manual VALUES (603, 'is_dir', 'PHP 3, PHP 4', 'bool', 'string filename', 'Tells whether the filename is a directory', 1042390510);
INSERT INTO php_manual VALUES (604, 'is_executable', 'PHP 3, PHP 4', 'bool', 'string filename', 'Tells whether the filename is executable', 1042390510);
INSERT INTO php_manual VALUES (605, 'is_file', 'PHP 3, PHP 4', 'bool', 'string filename', 'Tells whether the filename is a regular file', 1042390510);
INSERT INTO php_manual VALUES (606, 'is_link', 'PHP 3, PHP 4', 'bool', 'string filename', 'Tells whether the filename is a symbolic link', 1042390510);
INSERT INTO php_manual VALUES (607, 'is_readable', 'PHP 3, PHP 4', 'bool', 'string filename', 'Tells whether the filename is readable', 1042390510);
INSERT INTO php_manual VALUES (608, 'is_uploaded_file', 'PHP 3>= 3.0.17, PHP 4 >= 4.0.3', 'bool', 'string filename', 'Tells whether the file was uploaded via HTTP POST', 1042390510);
INSERT INTO php_manual VALUES (609, 'is_writable', 'PHP 4', 'bool', 'string filename', 'Tells whether the filename is writable', 1042390510);
INSERT INTO php_manual VALUES (610, 'is_writeable', 'PHP 3, PHP 4', 'bool', 'string filename', 'Tells whether the filename is writable', 1042390510);
INSERT INTO php_manual VALUES (611, 'link', 'PHP 3, PHP 4', 'int', 'string target, string link', 'Create a hard link', 1042390511);
INSERT INTO php_manual VALUES (612, 'linkinfo', 'PHP 3, PHP 4', 'int', 'string path', 'Gets information about a link', 1042390511);
INSERT INTO php_manual VALUES (613, 'lstat', 'PHP 3>= 3.0.4, PHP 4', 'array', 'string filename', 'Gives information about a file or symbolic link', 1042390511);
INSERT INTO php_manual VALUES (614, 'mkdir', 'PHP 3, PHP 4', 'int', 'string pathname, [int mode]', 'Makes directory', 1042390511);
INSERT INTO php_manual VALUES (615, 'move_uploaded_file', 'PHP 4 >= 4.0.3', 'bool', 'string filename, string destination', 'Moves an uploaded file to a new location', 1042390511);
INSERT INTO php_manual VALUES (616, 'parse_ini_file', 'PHP 4', 'array', 'string filename, [bool process_sections]', 'Parse a configuration file', 1042390511);
INSERT INTO php_manual VALUES (617, 'pathinfo', 'PHP 4 >= 4.0.3', 'array', 'string path', 'Returns information about a file path', 1042390511);
INSERT INTO php_manual VALUES (618, 'pclose', 'PHP 3, PHP 4', 'int', 'int fp', 'Closes process file pointer', 1042390511);
INSERT INTO php_manual VALUES (619, 'popen', 'PHP 3, PHP 4', 'int', 'string command, string mode', 'Opens process file pointer', 1042390511);
INSERT INTO php_manual VALUES (620, 'readfile', 'PHP 3, PHP 4', 'int', 'string filename, [int use_include_path]', 'Outputs a file', 1042390511);
INSERT INTO php_manual VALUES (621, 'readlink', 'PHP 3, PHP 4', 'string', 'string path', 'Returns the target of a symbolic link', 1042390511);
INSERT INTO php_manual VALUES (622, 'realpath', 'PHP 4', 'string', 'string path', 'Returns canonicalized absolute pathname', 1042390511);
INSERT INTO php_manual VALUES (623, 'rename', 'PHP 3, PHP 4', 'bool', 'string oldname, string newname', 'Renames a file', 1042390511);
INSERT INTO php_manual VALUES (624, 'rewind', 'PHP 3, PHP 4', 'int', 'int fp', 'Rewind the position of a file pointer', 1042390511);
INSERT INTO php_manual VALUES (625, 'rmdir', 'PHP 3, PHP 4', 'bool', 'string dirname', 'Removes directory', 1042390511);
INSERT INTO php_manual VALUES (626, 'set_file_buffer', 'PHP 3>= 3.0.8, PHP 4 >= 4.0.1', '', 'void', 'Alias of stream_set_write_buffer', 1042390511);
INSERT INTO php_manual VALUES (627, 'stat', 'PHP 3, PHP 4', 'array', 'string filename', 'Gives information about a file', 1042390511);
INSERT INTO php_manual VALUES (628, 'symlink', 'PHP 3, PHP 4', 'int', 'string target, string link', 'Creates a symbolic link', 1042390511);
INSERT INTO php_manual VALUES (629, 'tempnam', 'PHP 3, PHP 4', 'string', 'string dir, string prefix', 'Create file with unique file name', 1042390511);
INSERT INTO php_manual VALUES (630, 'tmpfile', 'PHP 3>= 3.0.13, PHP 4', 'int', 'void', 'Creates a temporary file', 1042390511);
INSERT INTO php_manual VALUES (631, 'touch', 'PHP 3, PHP 4', 'int', 'string filename, [int time], [int atime]', 'Sets access and modification time of file', 1042390511);
INSERT INTO php_manual VALUES (632, 'umask', 'PHP 3, PHP 4', 'int', '[int mask]', 'Changes the current umask', 1042390511);
INSERT INTO php_manual VALUES (633, 'unlink', 'PHP 3, PHP 4', 'int', 'string filename', 'Deletes a file', 1042390511);
INSERT INTO php_manual VALUES (634, 'fribidi_log2vis', 'PHP 4 >= 4.0.4', 'string', 'string str, string direction, int charset', 'Convert a logical string to a visual one', 1042390511);
INSERT INTO php_manual VALUES (635, 'ftp_cdup', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream', 'Changes to the parent directory', 1042390511);
INSERT INTO php_manual VALUES (636, 'ftp_chdir', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string directory', 'Changes directories on a FTP server', 1042390511);
INSERT INTO php_manual VALUES (637, 'ftp_close', 'PHP 4 >= 4.2.0', 'void', 'resource ftp_stream', 'Closes an FTP connection', 1042390511);
INSERT INTO php_manual VALUES (638, 'ftp_connect', 'PHP 3>= 3.0.13, PHP 4', 'resource', 'string host, [int port], [int timeout]', 'Opens an FTP connection', 1042390511);
INSERT INTO php_manual VALUES (639, 'ftp_delete', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string path', 'Deletes a file on the FTP server', 1042390511);
INSERT INTO php_manual VALUES (640, 'ftp_exec', 'PHP 4 >= 4.0.3', 'bool', 'resource ftp_stream, string command', 'Requests execution of a program on the FTP server', 1042390511);
INSERT INTO php_manual VALUES (641, 'ftp_fget', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, resource fp, string remote_file, int mode, [int resumepos]', 'Downloads a file from the FTP server and saves to an open file', 1042390511);
INSERT INTO php_manual VALUES (642, 'ftp_fput', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string remote_file, resource fp, int mode, [int startpos]', 'Uploads from an open file to the FTP server', 1042390511);
INSERT INTO php_manual VALUES (643, 'ftp_get_option', 'PHP 4 >= 4.2.0', 'mixed', 'resource ftp_stream, int option', 'Retrieves various runtime behaviours of the current FTP stream', 1042390511);
INSERT INTO php_manual VALUES (644, 'ftp_get', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string local_file, string remote_file, int mode, [int resumepos]', 'Downloads a file from the FTP server', 1042390511);
INSERT INTO php_manual VALUES (645, 'ftp_login', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string username, string password', 'Logs in to an FTP connection', 1042390511);
INSERT INTO php_manual VALUES (646, 'ftp_mdtm', 'PHP 3>= 3.0.13, PHP 4', 'int', 'resource ftp_stream, string remote_file', 'Returns the last modified time of the given file', 1042390511);
INSERT INTO php_manual VALUES (647, 'ftp_mkdir', 'PHP 3>= 3.0.13, PHP 4', 'string', 'resource ftp_stream, string directory', 'Creates a directory', 1042390511);
INSERT INTO php_manual VALUES (648, 'ftp_nb_continue', 'PHP 4 >= 4.3.0', 'bool', 'resource ftp_stream', 'Continues retrieving/sending a file (non-blocking)', 1042390511);
INSERT INTO php_manual VALUES (649, 'ftp_nb_fget', 'PHP 4 >= 4.3.0', 'bool', 'resource ftp_stream, resource fp, string remote_file, int mode, [int resumepos]', 'Retrieves a file from the FTP server and writes it to an open file (non-blocking)', 1042390511);
INSERT INTO php_manual VALUES (650, 'ftp_nb_fput', 'PHP 4 >= 4.3.0', 'bool', 'resource ftp_stream, string remote_file, resource fp, int mode, [int startpos]', 'Stores a file from an open file to the FTP server (non-blocking)', 1042390511);
INSERT INTO php_manual VALUES (651, 'ftp_nb_get', 'PHP 4 >= 4.3.0', 'bool', 'resource ftp_stream, string local_file, string remote_file, int mode, [int resumepos]', 'Retrieves a file from the FTP server and writes it to a local file (non-blocking)', 1042390511);
INSERT INTO php_manual VALUES (652, 'ftp_nb_put', 'PHP 4 >= 4.3.0', 'bool', 'resource ftp_stream, string remote_file, string local_file, int mode, [int startpos]', 'Stores a file on the FTP server (non-blocking)', 1042390511);
INSERT INTO php_manual VALUES (653, 'ftp_nlist', 'PHP 3>= 3.0.13, PHP 4', 'array', 'resource ftp_stream, string directory', 'Returns a list of files in the given directory', 1042390512);
INSERT INTO php_manual VALUES (654, 'ftp_pasv', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, bool pasv', 'Turns passive mode on or off', 1042390512);
INSERT INTO php_manual VALUES (655, 'ftp_put', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string remote_file, string local_file, int mode, [int startpos]', 'Uploads a file to the FTP server', 1042390512);
INSERT INTO php_manual VALUES (656, 'ftp_pwd', 'PHP 3>= 3.0.13, PHP 4', 'string', 'resource ftp_stream', 'Returns the current directory name', 1042390512);
INSERT INTO php_manual VALUES (657, 'ftp_quit', 'PHP 3>= 3.0.13, PHP 4', 'void', 'resource ftp_stream', 'Closes an FTP connection', 1042390512);
INSERT INTO php_manual VALUES (658, 'ftp_rawlist', 'PHP 3>= 3.0.13, PHP 4', 'array', 'resource ftp_stream, string directory', 'Returns a detailed list of files in the given directory', 1042390512);
INSERT INTO php_manual VALUES (659, 'ftp_rename', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string from, string to', 'Renames a file on the FTP server', 1042390512);
INSERT INTO php_manual VALUES (660, 'ftp_rmdir', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'resource ftp_stream, string directory', 'Removes a directory', 1042390512);
INSERT INTO php_manual VALUES (661, 'ftp_set_option', 'PHP 4 >= 4.2.0', 'bool', 'resource ftp_stream, int option, mixed value', 'Set miscellaneous runtime FTP options', 1042390512);
INSERT INTO php_manual VALUES (662, 'ftp_site', 'PHP 3>= 3.0.15, PHP 4', 'bool', 'resource ftp_stream, string cmd', 'Sends a SITE command to the server', 1042390512);
INSERT INTO php_manual VALUES (663, 'ftp_size', 'PHP 3>= 3.0.13, PHP 4', 'int', 'resource ftp_stream, string remote_file', 'Returns the size of the given file', 1042390512);
INSERT INTO php_manual VALUES (664, 'ftp_ssl_connect', 'PHP 4 >= 4.3.0', 'resource', 'string host, [int port], [int timeout]', 'Opens an Secure SSL-FTP connection', 1042390512);
INSERT INTO php_manual VALUES (665, 'ftp_systype', 'PHP 3>= 3.0.13, PHP 4', 'string', 'resource ftp_stream', 'Returns the system type identifier of the remote FTP server', 1042390512);
INSERT INTO php_manual VALUES (666, 'call_user_func_array', 'PHP 4 >= 4.0.4', 'mixed', 'callback function, [array paramarr]', ' Call a user function given with an array of parameters', 1042390512);
INSERT INTO php_manual VALUES (667, 'call_user_func', 'PHP 3>= 3.0.3, PHP 4', 'mixed', 'callback function, [mixed parameter], [mixed ...]', ' Call a user function given by the first parameter', 1042390512);
INSERT INTO php_manual VALUES (668, 'create_function', 'PHP 4 >= 4.0.1', 'string', 'string args, string code', 'Create an anonymous (lambda-style) function', 1042390512);
INSERT INTO php_manual VALUES (669, 'func_get_arg', 'PHP 4', 'mixed', 'int arg_num', 'Return an item from the argument list', 1042390512);
INSERT INTO php_manual VALUES (670, 'func_num_args', 'PHP 4', 'int', 'void', ' Returns the number of arguments passed to the function', 1042390512);
INSERT INTO php_manual VALUES (671, 'function_exists', 'PHP 3>= 3.0.7, PHP 4', '', 'void', '', 1042390512);
INSERT INTO php_manual VALUES (672, 'get_defined_functions', 'PHP 4 >= 4.0.4', 'array', 'void', ' Returns an array of all defined functions', 1042390512);
INSERT INTO php_manual VALUES (673, 'register_shutdown_function', 'PHP 3>= 3.0.4, PHP 4', 'int', 'callback function', ' Register a function for execution on shutdown', 1042390512);
INSERT INTO php_manual VALUES (674, 'register_tick_function', 'PHP 4 >= 4.0.3', 'void', 'callback function, [mixed arg]', ' Register a function for execution on each tick', 1042390512);
INSERT INTO php_manual VALUES (675, 'unregister_tick_function', 'PHP 4 >= 4.0.3', 'void', 'callback function, [mixed arg]', ' De-register a function for execution on each tick', 1042390512);
INSERT INTO php_manual VALUES (676, 'bind_textdomain_codeset', 'PHP 4 >= 4.2.0', 'string', 'string domain, string codeset', ' Specify the character encoding in which the messages from the DOMAIN message catalog will be returned', 1042390512);
INSERT INTO php_manual VALUES (677, 'bindtextdomain', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string domain, string directory', 'Sets the path for a domain', 1042390512);
INSERT INTO php_manual VALUES (678, 'dcgettext', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string domain, string message, int category', 'Overrides the domain for a single lookup', 1042390512);
INSERT INTO php_manual VALUES (679, 'dcngettext', 'PHP 4 >= 4.2.0', 'string', 'string domain, string msgid1, string msgid2, int n, int category', 'Plural version of dcgettext', 1042390512);
INSERT INTO php_manual VALUES (680, 'dgettext', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string domain, string message', 'Override the current domain', 1042390512);
INSERT INTO php_manual VALUES (681, 'dngettext', 'PHP 4 >= 4.2.0', 'string', 'string domain, string msgid1, string msgid2, int n', 'Plural version of dgettext', 1042390512);
INSERT INTO php_manual VALUES (682, 'gettext', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string message', 'Lookup a message in the current domain', 1042390512);
INSERT INTO php_manual VALUES (683, 'ngettext', 'PHP 4 >= 4.2.0', 'string', 'string msgid1, string msgid2, int n', 'Plural version of gettext', 1042390512);
INSERT INTO php_manual VALUES (684, 'textdomain', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string text_domain', 'Sets the default domain', 1042390512);
INSERT INTO php_manual VALUES (685, 'gmp_abs', 'PHP 4 >= 4.0.4', 'resource', 'resource a', 'Absolute value', 1042390512);
INSERT INTO php_manual VALUES (686, 'gmp_add', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Add numbers', 1042390512);
INSERT INTO php_manual VALUES (687, 'gmp_and', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Logical AND', 1042390512);
INSERT INTO php_manual VALUES (688, 'gmp_clrbit', 'PHP 4 >= 4.0.4', 'resource', 'resource &a, int index', 'Clear bit', 1042390512);
INSERT INTO php_manual VALUES (689, 'gmp_cmp', 'PHP 4 >= 4.0.4', 'int', 'resource a, resource b', 'Compare numbers', 1042390512);
INSERT INTO php_manual VALUES (690, 'gmp_div_q', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b, [int round]', 'Divide numbers', 1042390512);
INSERT INTO php_manual VALUES (691, 'gmp_div_qr', 'PHP 4 >= 4.0.4', 'array', 'resource n, resource d, [int round]', 'Divide numbers and get quotient and remainder', 1042390512);
INSERT INTO php_manual VALUES (692, 'gmp_div_r', 'PHP 4 >= 4.0.4', 'resource', 'resource n, resource d, [int round]', 'Remainder of the division of numbers', 1042390512);
INSERT INTO php_manual VALUES (693, 'gmp_div', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Divide numbers', 1042390512);
INSERT INTO php_manual VALUES (694, 'gmp_divexact', 'PHP 4 >= 4.0.4', 'resource', 'resource n, resource d', 'Exact division of numbers', 1042390512);
INSERT INTO php_manual VALUES (695, 'gmp_fact', 'PHP 4 >= 4.0.4', 'resource', 'int a', 'Factorial', 1042390512);
INSERT INTO php_manual VALUES (696, 'gmp_gcd', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Calculate GCD', 1042390512);
INSERT INTO php_manual VALUES (697, 'gmp_gcdext', 'PHP 4 >= 4.0.4', 'array', 'resource a, resource b', 'Calculate GCD and multipliers', 1042390513);
INSERT INTO php_manual VALUES (698, 'gmp_hamdist', 'PHP 4 >= 4.0.4', 'int', 'resource a, resource b', 'Hamming distance', 1042390513);
INSERT INTO php_manual VALUES (699, 'gmp_init', 'PHP 4 >= 4.0.4', 'resource', 'mixed number', 'Create GMP number', 1042390513);
INSERT INTO php_manual VALUES (700, 'gmp_intval', 'PHP 4 >= 4.0.4', 'int', 'resource gmpnumber', 'Convert GMP number to integer', 1042390513);
INSERT INTO php_manual VALUES (701, 'gmp_invert', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Inverse by modulo', 1042390513);
INSERT INTO php_manual VALUES (702, 'gmp_jacobi', 'PHP 4 >= 4.0.4', 'int', 'resource a, resource p', 'Jacobi symbol', 1042390513);
INSERT INTO php_manual VALUES (703, 'gmp_mod', 'PHP 4 >= 4.0.4', 'resource', 'resource n, resource d', 'Modulo operation', 1042390513);
INSERT INTO php_manual VALUES (704, 'gmp_legendre', 'PHP 4 >= 4.0.4', 'int', 'resource a, resource p', 'Legendre symbol', 1042390513);
INSERT INTO php_manual VALUES (705, 'gmp_mul', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Multiply numbers', 1042390513);
INSERT INTO php_manual VALUES (706, 'gmp_neg', 'PHP 4 >= 4.0.4', 'resource', 'resource a', 'Negate number', 1042390513);
INSERT INTO php_manual VALUES (707, 'gmp_or', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Logical OR', 1042390513);
INSERT INTO php_manual VALUES (708, 'gmp_perfect_square', 'PHP 4 >= 4.0.4', 'bool', 'resource a', 'Perfect square check', 1042390513);
INSERT INTO php_manual VALUES (709, 'gmp_popcount', 'PHP 4 >= 4.0.4', 'int', 'resource a', 'Population count', 1042390513);
INSERT INTO php_manual VALUES (710, 'gmp_pow', 'PHP 4 >= 4.0.4', 'resource', 'resource base, int exp', 'Raise number into power', 1042390513);
INSERT INTO php_manual VALUES (711, 'gmp_powm', 'PHP 4 >= 4.0.4', 'resource', 'resource base, resource exp, resource mod', 'Raise number into power with modulo', 1042390513);
INSERT INTO php_manual VALUES (712, 'gmp_prob_prime', 'PHP 4 >= 4.0.4', 'int', 'resource a, [int reps]', 'Check if number is "probably prime"', 1042390513);
INSERT INTO php_manual VALUES (713, 'gmp_random', 'PHP 4 >= 4.0.4', 'resource', 'int limiter', 'Random number', 1042390513);
INSERT INTO php_manual VALUES (714, 'gmp_scan0', 'PHP 4 >= 4.0.4', 'int', 'resource a, int start', 'Scan for 0', 1042390513);
INSERT INTO php_manual VALUES (715, 'gmp_scan1', 'PHP 4 >= 4.0.4', 'int', 'resource a, int start', 'Scan for 1', 1042390513);
INSERT INTO php_manual VALUES (716, 'gmp_setbit', 'PHP 4 >= 4.0.4', 'resource', 'resource &a, int index, [bool set_clear]', 'Set bit', 1042390513);
INSERT INTO php_manual VALUES (717, 'gmp_sign', 'PHP 4 >= 4.0.4', 'int', 'resource a', 'Sign of number', 1042390513);
INSERT INTO php_manual VALUES (718, 'gmp_sqrt', 'PHP 4 >= 4.0.4', 'resource', 'resource a', 'Square root', 1042390513);
INSERT INTO php_manual VALUES (719, 'gmp_sqrtrm', '', 'array', 'resource a', 'Square root with remainder', 1042390513);
INSERT INTO php_manual VALUES (720, 'gmp_strval', 'PHP 4 >= 4.0.4', 'string', 'resource gmpnumber, [int base]', 'Convert GMP number to string', 1042390513);
INSERT INTO php_manual VALUES (721, 'gmp_sub', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Subtract numbers', 1042390513);
INSERT INTO php_manual VALUES (722, 'gmp_xor', 'PHP 4 >= 4.0.4', 'resource', 'resource a, resource b', 'Logical XOR', 1042390513);
INSERT INTO php_manual VALUES (723, 'header', 'PHP 3, PHP 4', 'int', 'string string, [bool replace], [int http_reponse_code]', 'Send a raw HTTP header', 1042390513);
INSERT INTO php_manual VALUES (724, 'headers_sent', 'PHP 3>= 3.0.8, PHP 4', 'boolean', '[string &file], [int &line]', 'Checks if or where headers have been sent', 1042390513);
INSERT INTO php_manual VALUES (725, 'setcookie', 'PHP 3, PHP 4', 'boolean', 'string name, [string value], [int expire], [string path], [string domain], [int secure]', 'Send a cookie', 1042390513);
INSERT INTO php_manual VALUES (726, 'hw_Array2Objrec', 'PHP 3>= 3.0.4, PHP 4', 'strin', 'array object_array', 'convert attributes from object array to object record', 1042390513);
INSERT INTO php_manual VALUES (727, 'hw_changeobject', 'PHP 3>= 3.0.3, PHP 4', 'void', 'int link, int objid, array attributes', ' Changes attributes of an object (obsolete)', 1042390513);
INSERT INTO php_manual VALUES (728, 'hw_Children', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object ids of children', 1042390513);
INSERT INTO php_manual VALUES (729, 'hw_ChildrenObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object records of children', 1042390513);
INSERT INTO php_manual VALUES (730, 'hw_Close', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection', 'closes the Hyperwave connection', 1042390513);
INSERT INTO php_manual VALUES (731, 'hw_Connect', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string host, int port, string username, string password', 'opens a connection', 1042390513);
INSERT INTO php_manual VALUES (732, 'hw_connection_info', 'PHP 3>= 3.0.3, PHP 4', 'void', 'int link', ' Prints information about the connection to Hyperwave server', 1042390513);
INSERT INTO php_manual VALUES (733, 'hw_Cp', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, array object_id_array, int destination id', 'copies objects', 1042390513);
INSERT INTO php_manual VALUES (734, 'hw_Deleteobject', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int object_to_delete', 'deletes object', 1042390513);
INSERT INTO php_manual VALUES (735, 'hw_DocByAnchor', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int anchorID', 'object id object belonging to anchor', 1042390513);
INSERT INTO php_manual VALUES (736, 'hw_DocByAnchorObj', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int connection, int anchorID', 'object record object belonging to anchor', 1042390513);
INSERT INTO php_manual VALUES (737, 'hw_Document_Attributes', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int hw_document', 'object record of hw_document', 1042390513);
INSERT INTO php_manual VALUES (738, 'hw_Document_BodyTag', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int hw_document', 'body tag of hw_document', 1042390513);
INSERT INTO php_manual VALUES (739, 'hw_Document_Content', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int hw_document', 'returns content of hw_document', 1042390513);
INSERT INTO php_manual VALUES (740, 'hw_Document_SetContent', 'PHP 4', 'string', 'int hw_document, string content', 'sets/replaces content of hw_document', 1042390513);
INSERT INTO php_manual VALUES (741, 'hw_Info', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int connection', 'info about connection', 1042390513);
INSERT INTO php_manual VALUES (742, 'hw_Document_Size', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int hw_document', 'size of hw_document', 1042390513);
INSERT INTO php_manual VALUES (743, 'hw_dummy', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int link, int id, int msgid', ' Hyperwave dummy function', 1042390513);
INSERT INTO php_manual VALUES (744, 'hw_EditText', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int hw_document', 'retrieve text document', 1042390513);
INSERT INTO php_manual VALUES (745, 'hw_Error', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection', 'error number', 1042390513);
INSERT INTO php_manual VALUES (746, 'hw_ErrorMsg', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int connection', 'returns error message', 1042390513);
INSERT INTO php_manual VALUES (747, 'hw_Free_Document', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int hw_document', 'frees hw_document', 1042390513);
INSERT INTO php_manual VALUES (748, 'hw_GetAnchors', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object ids of anchors of document', 1042390513);
INSERT INTO php_manual VALUES (749, 'hw_GetAnchorsObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object records of anchors of document', 1042390513);
INSERT INTO php_manual VALUES (750, 'hw_GetAndLock', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int connection, int objectID', 'return bject record and lock object', 1042390513);
INSERT INTO php_manual VALUES (751, 'hw_GetChildColl', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object ids of child collections', 1042390514);
INSERT INTO php_manual VALUES (752, 'hw_GetChildCollObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object records of child collections', 1042390514);
INSERT INTO php_manual VALUES (753, 'hw_GetChildDocColl', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object ids of child documents of collection', 1042390514);
INSERT INTO php_manual VALUES (754, 'hw_GetChildDocCollObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object records of child documents of collection', 1042390514);
INSERT INTO php_manual VALUES (755, 'hw_GetObject', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, [int|array] objectID, string query', 'object record', 1042390514);
INSERT INTO php_manual VALUES (756, 'hw_GetObjectByQuery', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, string query, int max_hits', 'search object', 1042390514);
INSERT INTO php_manual VALUES (757, 'hw_GetObjectByQueryColl', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID, string query, int max_hits', 'search object in collection', 1042390514);
INSERT INTO php_manual VALUES (758, 'hw_GetObjectByQueryCollObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID, string query, int max_hits', 'search object in collection', 1042390514);
INSERT INTO php_manual VALUES (759, 'hw_GetObjectByQueryObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, string query, int max_hits', 'search object', 1042390514);
INSERT INTO php_manual VALUES (760, 'hw_GetParents', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object ids of parents', 1042390514);
INSERT INTO php_manual VALUES (761, 'hw_GetParentsObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'object records of parents', 1042390514);
INSERT INTO php_manual VALUES (762, 'hw_getrellink', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int link, int rootid, int sourceid, int destid', ' Get link from source to dest relative to rootid', 1042390514);
INSERT INTO php_manual VALUES (763, 'hw_GetRemote', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int objectID', 'Gets a remote document', 1042390514);
INSERT INTO php_manual VALUES (764, 'hw_GetRemoteChildren', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, string object record', 'Gets children of remote document', 1042390514);
INSERT INTO php_manual VALUES (765, 'hw_GetSrcByDestObj', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, int objectID', 'Returns anchors pointing at object', 1042390514);
INSERT INTO php_manual VALUES (766, 'hw_GetText', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int objectID, [mixed rootID/prefix ]', 'retrieve text document', 1042390514);
INSERT INTO php_manual VALUES (767, 'hw_getusername', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int connection', 'name of currently logged in user', 1042390514);
INSERT INTO php_manual VALUES (768, 'hw_Identify', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string username, string password', 'identifies as user', 1042390514);
INSERT INTO php_manual VALUES (769, 'hw_InCollections', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int connection, array object_id_array, array collection_id_array, int return_collections', 'check if object ids in collections', 1042390514);
INSERT INTO php_manual VALUES (770, 'hw_InsColl', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int objectID, array object_array', 'insert collection', 1042390514);
INSERT INTO php_manual VALUES (771, 'hw_InsDoc', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int parentID, string object_record, string text', 'insert document', 1042390514);
INSERT INTO php_manual VALUES (772, 'hw_insertanchors', 'PHP 4 >= 4.0.4', 'string', 'int hwdoc, array anchorecs, array dest, [array urlprefixes]', ' Inserts only anchors into text', 1042390514);
INSERT INTO php_manual VALUES (773, 'hw_InsertDocument', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int parent_id, int hw_document', 'upload any document', 1042390514);
INSERT INTO php_manual VALUES (774, 'hw_InsertObject', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, string object rec, string parameter', 'inserts an object record', 1042390514);
INSERT INTO php_manual VALUES (775, 'hw_mapid', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int connection, int server id, int object id', 'Maps global id on virtual local id', 1042390514);
INSERT INTO php_manual VALUES (776, 'hw_Mv', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, array object id array, int source id, int destination id', 'moves objects', 1042390514);
INSERT INTO php_manual VALUES (777, 'hw_Modifyobject', 'PHP 3>= 3.0.7, PHP 4', 'int', 'int connection, int object_to_change, array remove, array add, int mode', 'modifies object record', 1042390514);
INSERT INTO php_manual VALUES (778, 'hw_New_Document', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string object_record, string document_data, int document_size', 'create new document', 1042390514);
INSERT INTO php_manual VALUES (779, 'hw_Objrec2Array', 'PHP 3>= 3.0.3, PHP 4', 'array', 'string object_record, [array format ]', 'convert attributes from object record to object array', 1042390514);
INSERT INTO php_manual VALUES (780, 'hw_Output_Document', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int hw_document', 'prints hw_document', 1042390514);
INSERT INTO php_manual VALUES (781, 'hw_pConnect', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string host, int port, string username, string password', 'make a persistent database connection', 1042390514);
INSERT INTO php_manual VALUES (782, 'hw_PipeDocument', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int objectID', 'retrieve any document', 1042390514);
INSERT INTO php_manual VALUES (783, 'hw_Root', 'PHP 3>= 3.0.3, PHP 4', 'int', '', 'root object id', 1042390514);
INSERT INTO php_manual VALUES (784, 'hw_setlinkroot', 'PHP 3>= 3.0.3, PHP 4', 'void', 'int link, int rootid', ' Set the id to which links are calculated', 1042390514);
INSERT INTO php_manual VALUES (785, 'hw_stat', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int link', ' Returns status string', 1042390514);
INSERT INTO php_manual VALUES (786, 'hw_Unlock', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection, int objectID', 'unlock object', 1042390514);
INSERT INTO php_manual VALUES (787, 'hw_Who', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int connection', 'List of currently logged in users', 1042390514);
INSERT INTO php_manual VALUES (788, 'hw_api_attribute->key', '', 'string', '', 'Returns key of the attribute', 1042390514);
INSERT INTO php_manual VALUES (789, 'hw_api_attribute->langdepvalue', '', 'string', 'string language', 'Returns value for a given language', 1042390514);
INSERT INTO php_manual VALUES (790, 'hw_api_attribute->value', '', 'string', '', 'Returns value of the attribute', 1042390514);
INSERT INTO php_manual VALUES (791, 'hw_api_attribute->values', '', 'array', '', 'Returns all values of the attribute', 1042390514);
INSERT INTO php_manual VALUES (792, 'hw_api_attribute', '', 'object', '[string name], [string value]', 'Creates instance of class hw_api_attribute', 1042390514);
INSERT INTO php_manual VALUES (793, 'hw_api->checkin', '', 'object', 'array parameter', 'Checks in an object', 1042390515);
INSERT INTO php_manual VALUES (794, 'hw_api->checkout', '', 'object', 'array parameter', 'Checks out an object', 1042390515);
INSERT INTO php_manual VALUES (795, 'hw_api->children', '', 'array', 'array parameter', 'Returns children of an object', 1042390515);
INSERT INTO php_manual VALUES (796, 'hw_api_content->mimetype', '', 'string', '', 'Returns mimetype', 1042390515);
INSERT INTO php_manual VALUES (797, 'hw_api_content->read', '', 'string', 'string buffer, integer len', 'Read content', 1042390515);
INSERT INTO php_manual VALUES (798, 'hw_api->content', '', 'object', 'array parameter', 'Returns content of an object', 1042390515);
INSERT INTO php_manual VALUES (799, 'hw_api->copy', '', 'object', 'array parameter', 'Copies physically', 1042390515);
INSERT INTO php_manual VALUES (800, 'hw_api->dbstat', '', 'object', 'array parameter', 'Returns statistics about database server', 1042390515);
INSERT INTO php_manual VALUES (801, 'hw_api->dcstat', '', 'object', 'array parameter', 'Returns statistics about document cache server', 1042390515);
INSERT INTO php_manual VALUES (802, 'hw_api->dstanchors', '', 'object', 'array parameter', 'Returns a list of all destination anchors', 1042390515);
INSERT INTO php_manual VALUES (803, 'hw_api->dstofsrcanchors', '', 'object', 'array parameter', 'Returns destination of a source anchor', 1042390515);
INSERT INTO php_manual VALUES (804, 'hw_api_error->count', '', 'int', '', 'Returns number of reasons', 1042390515);
INSERT INTO php_manual VALUES (805, 'hw_api_error->reason', '', 'object', '', 'Returns reason of error', 1042390515);
INSERT INTO php_manual VALUES (806, 'hw_api->find', '', 'array', 'array parameter', 'Search for objects', 1042390515);
INSERT INTO php_manual VALUES (807, 'hw_api->ftstat', '', 'object', 'array parameter', 'Returns statistics about fulltext server', 1042390515);
INSERT INTO php_manual VALUES (808, 'hwapi_hgcsp', '', 'object', 'string hostname, [int port]', 'Returns object of class hw_api', 1042390515);
INSERT INTO php_manual VALUES (809, 'hw_api->hwstat', '', 'object', 'array parameter', 'Returns statistics about Hyperwave server', 1042390515);
INSERT INTO php_manual VALUES (810, 'hw_api->identify', '', 'object', 'array parameter', 'Log into Hyperwave Server', 1042390515);
INSERT INTO php_manual VALUES (811, 'hw_api->info', '', 'object', 'array parameter', 'Returns information about server configuration', 1042390515);
INSERT INTO php_manual VALUES (812, 'hw_api->insert', '', 'object', 'array parameter', 'Inserts a new object', 1042390515);
INSERT INTO php_manual VALUES (813, 'hw_api->insertanchor', '', 'object', 'array parameter', 'Inserts a new object of type anchor', 1042390515);
INSERT INTO php_manual VALUES (814, 'hw_api->insertcollection', '', 'object', 'array parameter', 'Inserts a new object of type collection', 1042390515);
INSERT INTO php_manual VALUES (815, 'hw_api->insertdocument', '', 'object', 'array parameter', 'Inserts a new object of type document', 1042390515);
INSERT INTO php_manual VALUES (816, 'hw_api->link', '', 'object', 'array parameter', 'Creates a link to an object', 1042390515);
INSERT INTO php_manual VALUES (817, 'hw_api->lock', '', 'object', 'array parameter', 'Locks an object', 1042390515);
INSERT INTO php_manual VALUES (818, 'hw_api->move', '', 'object', 'array parameter', 'Moves object between collections', 1042390515);
INSERT INTO php_manual VALUES (819, 'hw_api_content', '', 'string', 'string content, string mimetype', 'Create new instance of class hw_api_content', 1042390515);
INSERT INTO php_manual VALUES (820, 'hw_api_object->assign', '', 'object', 'array parameter', 'Clones object', 1042390515);
INSERT INTO php_manual VALUES (821, 'hw_api_object->attreditable', '', 'bool', 'array parameter', 'Checks whether an attribute is editable', 1042390515);
INSERT INTO php_manual VALUES (822, 'hw_api_object->count', '', 'int', 'array parameter', 'Returns number of attributes', 1042390515);
INSERT INTO php_manual VALUES (823, 'hw_api_object->insert', '', 'bool', 'object attribute', 'Inserts new attribute', 1042390515);
INSERT INTO php_manual VALUES (824, 'hw_api_object', '', 'object', 'array parameter', 'Creates a new instance of class hw_api_object', 1042390515);
INSERT INTO php_manual VALUES (825, 'hw_api_object->remove', '', 'bool', 'string name', 'Removes attribute', 1042390515);
INSERT INTO php_manual VALUES (826, 'hw_api_object->title', '', 'string', 'array parameter', 'Returns the title attribute', 1042390515);
INSERT INTO php_manual VALUES (827, 'hw_api_object->value', '', 'string', 'string name', 'Returns value of attribute', 1042390515);
INSERT INTO php_manual VALUES (828, 'hw_api->object', '', 'object', 'array parameter', 'Retrieve attribute information', 1042390515);
INSERT INTO php_manual VALUES (829, 'hw_api->objectbyanchor', '', 'object', 'array parameter', 'Returns the object an anchor belongs to', 1042390515);
INSERT INTO php_manual VALUES (830, 'hw_api->parents', '', 'array', 'array parameter', 'Returns parents of an object', 1042390515);
INSERT INTO php_manual VALUES (831, 'hw_api_reason->description', '', 'string', '', 'Returns description of reason', 1042390515);
INSERT INTO php_manual VALUES (832, 'hw_api_reason->type', '', 'object', '', 'Returns type of reason', 1042390515);
INSERT INTO php_manual VALUES (833, 'hw_api->remove', '', 'object', 'array parameter', 'Delete an object', 1042390515);
INSERT INTO php_manual VALUES (834, 'hw_api->user', '', 'object', 'array parameter', 'Returns the own user object', 1042390515);
INSERT INTO php_manual VALUES (835, 'hw_api->replace', '', 'object', 'array parameter', 'Replaces an object', 1042390515);
INSERT INTO php_manual VALUES (836, 'hw_api->setcommitedversion', '', 'object', 'array parameter', 'Commits version other than last version', 1042390515);
INSERT INTO php_manual VALUES (837, 'hw_api->srcanchors', '', 'object', 'array parameter', 'Returns a list of all source anchors', 1042390515);
INSERT INTO php_manual VALUES (838, 'hw_api->srcsofdst', '', 'object', 'array parameter', 'Returns source of a destination object', 1042390515);
INSERT INTO php_manual VALUES (839, 'hw_api->unlock', '', 'object', 'array parameter', 'Unlocks a locked object', 1042390515);
INSERT INTO php_manual VALUES (840, 'hw_api->userlist', '', 'object', 'array parameter', 'Returns a list of all logged in users', 1042390515);
INSERT INTO php_manual VALUES (841, 'ibase_blob_add', 'PHP 3>= 3.0.7, PHP 4', 'int', 'int blob_id, string data', ' Add data into created blob', 1042390515);
INSERT INTO php_manual VALUES (842, 'ibase_blob_cancel', 'PHP 3>= 3.0.7, PHP 4', 'int', 'int blob_id', ' Cancel creating blob', 1042390515);
INSERT INTO php_manual VALUES (843, 'ibase_blob_close', 'PHP 3>= 3.0.7, PHP 4', 'int', 'int blob_id', ' Close blob', 1042390515);
INSERT INTO php_manual VALUES (844, 'ibase_blob_create', 'PHP 3>= 3.0.7, PHP 4', 'int', '[int link_identifier]', ' Create blob for adding data', 1042390515);
INSERT INTO php_manual VALUES (845, 'ibase_blob_echo', 'PHP 3>= 3.0.7, PHP 4', 'int', 'string blob_id_str', ' Output blob contents to browser', 1042390515);
INSERT INTO php_manual VALUES (846, 'ibase_blob_get', 'PHP 3>= 3.0.7, PHP 4', 'string', 'int blob_id, int len', ' Get len bytes data from open blob', 1042390516);
INSERT INTO php_manual VALUES (847, 'ibase_blob_import', 'PHP 3>= 3.0.7, PHP 4', 'string', '[int link_identifier], int file_id', ' Create blob, copy file in it, and close it', 1042390516);
INSERT INTO php_manual VALUES (848, 'ibase_blob_info', 'PHP 3>= 3.0.7, PHP 4', 'object', 'string blob_id_str', ' Return blob length and other useful info', 1042390516);
INSERT INTO php_manual VALUES (849, 'ibase_blob_open', 'PHP 3>= 3.0.7, PHP 4', 'int', 'string blob_id', ' Open blob for retrieving data parts', 1042390516);
INSERT INTO php_manual VALUES (850, 'ibase_close', 'PHP 3>= 3.0.6, PHP 4', 'int', '[int connection_id]', ' Close a connection to an InterBase database', 1042390516);
INSERT INTO php_manual VALUES (851, 'ibase_commit', 'PHP 3>= 3.0.7, PHP 4', 'int', '[int link_identifier], int trans_number', 'Commit a transaction', 1042390516);
INSERT INTO php_manual VALUES (852, 'ibase_connect', 'PHP 3>= 3.0.6, PHP 4', 'int', 'string database, [string username], [string password], [string charset], [int buffers], [int dialect], [string role]', ' Open a connection to an InterBase database', 1042390516);
INSERT INTO php_manual VALUES (853, 'ibase_errmsg', 'PHP 3>= 3.0.7, PHP 4', 'string', 'void', ' Returns error messages', 1042390516);
INSERT INTO php_manual VALUES (854, 'ibase_execute', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int query, [int bind_args]', 'Execute a previously prepared query', 1042390516);
INSERT INTO php_manual VALUES (855, 'ibase_fetch_object', 'PHP 3>= 3.0.7, PHP 4', 'object', 'int result_id', 'Get an object from a InterBase database', 1042390516);
INSERT INTO php_manual VALUES (856, 'ibase_fetch_row', 'PHP 3>= 3.0.6, PHP 4', 'array', 'int result_identifier', 'Fetch a row from an InterBase database', 1042390516);
INSERT INTO php_manual VALUES (857, 'ibase_field_info', 'PHP 3>= 3.0.7, PHP 4', 'array', 'int result, int field number', ' Get information about a field', 1042390516);
INSERT INTO php_manual VALUES (858, 'ibase_free_query', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int query', ' Free memory allocated by a prepared query', 1042390516);
INSERT INTO php_manual VALUES (859, 'ibase_free_result', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int result_identifier', 'Free a result set', 1042390516);
INSERT INTO php_manual VALUES (860, 'ibase_num_fields', 'PHP 3>= 3.0.7, PHP 4', 'int', 'int result_id', ' Get the number of fields in a result set', 1042390516);
INSERT INTO php_manual VALUES (861, 'ibase_pconnect', 'PHP 3>= 3.0.6, PHP 4', 'int', 'string database, [string username], [string password], [string charset], [int buffers], [int dialect], [string role]', ' Creates an persistent connection to an InterBase database', 1042390516);
INSERT INTO php_manual VALUES (862, 'ibase_prepare', 'PHP 3>= 3.0.6, PHP 4', 'int', '[int link_identifier], string query', ' Prepare a query for later binding of parameter placeholders and execution', 1042390516);
INSERT INTO php_manual VALUES (863, 'ibase_query', 'PHP 3>= 3.0.6, PHP 4', 'int', '[int link_identifier], string query, [int bind_args]', 'Execute a query on an InterBase database', 1042390516);
INSERT INTO php_manual VALUES (864, 'ibase_rollback', 'PHP 3>= 3.0.7, PHP 4', 'int', '[int link_identifier], int trans_number', 'Rolls back a transaction', 1042390516);
INSERT INTO php_manual VALUES (865, 'ibase_timefmt', 'PHP 3>= 3.0.6, PHP 4', 'int', 'string format, [int columntype]', ' Sets the format of timestamp, date and time type columns returned from queries', 1042390516);
INSERT INTO php_manual VALUES (866, 'ibase_trans', 'PHP 3>= 3.0.7, PHP 4', 'int', '[int trans_args], [int link_identifier]', 'Begin a transaction', 1042390516);
INSERT INTO php_manual VALUES (867, 'icap_close', '', 'int', 'int icap_stream, [int flags]', 'Close an ICAP stream', 1042390516);
INSERT INTO php_manual VALUES (868, 'icap_create_calendar', 'PHP 4  <= 4.2.3', 'string', 'int stream_id, string calendar', ' Create a new calendar', 1042390516);
INSERT INTO php_manual VALUES (869, 'icap_delete_calendar', 'PHP 4  <= 4.2.3', 'string', 'int stream_id, string calendar', ' Delete a calendar', 1042390516);
INSERT INTO php_manual VALUES (870, 'icap_delete_event', 'PHP 4  <= 4.2.3', 'string', 'int stream_id, int uid', 'Delete an event from an ICAP calendar', 1042390516);
INSERT INTO php_manual VALUES (871, 'icap_fetch_event', 'PHP 4  <= 4.2.3', 'int', 'int stream_id, int event_id, [int options]', 'Fetches an event from the calendar stream/', 1042390516);
INSERT INTO php_manual VALUES (872, 'icap_list_alarms', 'PHP 4  <= 4.2.3', 'int', 'int stream_id, array date, array time', ' Return a list of events that has an alarm triggered at the given datetime', 1042390516);
INSERT INTO php_manual VALUES (873, 'icap_list_events', 'PHP 4  <= 4.2.3', 'array', 'int stream_id, int begin_date, [int end_date]', ' Return a list of events between two given datetimes', 1042390516);
INSERT INTO php_manual VALUES (874, 'icap_open', 'PHP 4  <= 4.2.3', 'stream', 'string calendar, string username, string password, string options', 'Opens up an ICAP connection', 1042390516);
INSERT INTO php_manual VALUES (875, 'icap_rename_calendar', 'PHP 4  <= 4.2.3', 'string', 'int stream_id, string old_name, string new_name', ' Rename a calendar', 1042390516);
INSERT INTO php_manual VALUES (876, 'icap_reopen', 'PHP 4  <= 4.2.3', 'int', 'int stream_id, string calendar, [int options]', ' Reopen ICAP stream to new calendar', 1042390516);
INSERT INTO php_manual VALUES (877, 'icap_snooze', 'PHP 4  <= 4.2.3', 'string', 'int stream_id, int uid', 'Snooze an alarm', 1042390516);
INSERT INTO php_manual VALUES (878, 'icap_store_event', 'PHP 4  <= 4.2.3', 'string', 'int stream_id, object event', 'Store an event into an ICAP calendar', 1042390516);
INSERT INTO php_manual VALUES (879, 'iconv_get_encoding', 'PHP 4 >= 4.0.5', 'array', '[string type]', 'Get current setting for character encoding conversion', 1042390516);
INSERT INTO php_manual VALUES (880, 'iconv_set_encoding', 'PHP 4 >= 4.0.5', 'bool', 'string type, string charset', 'Set current setting for character encoding conversion', 1042390516);
INSERT INTO php_manual VALUES (881, 'iconv', 'PHP 4 >= 4.0.5', 'string', 'string in_charset, string out_charset, string str', 'Convert string to requested character encoding', 1042390516);
INSERT INTO php_manual VALUES (882, 'ob_iconv_handler', 'PHP 4 >= 4.0.5', 'array', 'string contents, int status', 'Convert character encoding as output buffer handler', 1042390516);
INSERT INTO php_manual VALUES (883, 'ifx_affected_rows', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result_id', 'Get number of rows affected by a query', 1042390516);
INSERT INTO php_manual VALUES (884, 'ifx_blobinfile_mode', 'PHP 3>= 3.0.4, PHP 4', 'void', 'int mode', 'Set the default blob mode for all select queries', 1042390516);
INSERT INTO php_manual VALUES (885, 'ifx_byteasvarchar', 'PHP 3>= 3.0.4, PHP 4', 'void', 'int mode', 'Set the default byte mode', 1042390516);
INSERT INTO php_manual VALUES (886, 'ifx_close', 'PHP 3>= 3.0.3, PHP 4', 'int', '[int link_identifier]', 'Close Informix connection', 1042390516);
INSERT INTO php_manual VALUES (887, 'ifx_connect', 'PHP 3>= 3.0.3, PHP 4', 'int', '[string database ], [string userid ], [string password ]', 'Open Informix server connection', 1042390516);
INSERT INTO php_manual VALUES (888, 'ifx_copy_blob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int bid', 'Duplicates the given blob object', 1042390516);
INSERT INTO php_manual VALUES (889, 'ifx_create_blob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int type, int mode, string param', 'Creates an blob object', 1042390516);
INSERT INTO php_manual VALUES (890, 'ifx_create_char', 'PHP 3>= 3.0.6, PHP 4', 'int', 'string param', 'Creates an char object', 1042390516);
INSERT INTO php_manual VALUES (891, 'ifx_do', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int result_id', ' Execute a previously prepared SQL-statement', 1042390516);
INSERT INTO php_manual VALUES (892, 'ifx_error', 'PHP 3>= 3.0.3, PHP 4', 'string', 'void', 'Returns error code of last Informix call', 1042390516);
INSERT INTO php_manual VALUES (893, 'ifx_errormsg', 'PHP 3>= 3.0.4, PHP 4', 'string', '[int errorcode]', 'Returns error message of last Informix call', 1042390517);
INSERT INTO php_manual VALUES (894, 'ifx_fetch_row', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int result_id, [mixed position]', 'Get row as enumerated array', 1042390517);
INSERT INTO php_manual VALUES (895, 'ifx_fieldproperties', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int result_id', 'List of SQL fieldproperties', 1042390517);
INSERT INTO php_manual VALUES (896, 'ifx_fieldtypes', 'PHP 3>= 3.0.3, PHP 4', 'array', 'int result_id', 'List of Informix SQL fields', 1042390517);
INSERT INTO php_manual VALUES (897, 'ifx_free_blob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int bid', 'Deletes the blob object', 1042390517);
INSERT INTO php_manual VALUES (898, 'ifx_free_char', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int bid', 'Deletes the char object', 1042390517);
INSERT INTO php_manual VALUES (899, 'ifx_free_result', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result_id', 'Releases resources for the query', 1042390517);
INSERT INTO php_manual VALUES (900, 'ifx_get_blob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int bid', 'Return the content of a blob object', 1042390517);
INSERT INTO php_manual VALUES (901, 'ifx_get_char', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int bid', 'Return the content of the char object', 1042390517);
INSERT INTO php_manual VALUES (902, 'ifx_getsqlca', 'PHP 3>= 3.0.8, PHP 4', 'array', 'int result_id', ' Get the contents of sqlca.sqlerrd[0..5] after a query', 1042390517);
INSERT INTO php_manual VALUES (903, 'ifx_htmltbl_result', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result_id, [string html_table_options]', ' Formats all rows of a query into a HTML table', 1042390517);
INSERT INTO php_manual VALUES (904, 'ifx_nullformat', 'PHP 3>= 3.0.4, PHP 4', 'void', 'int mode', ' Sets the default return value on a fetch row', 1042390517);
INSERT INTO php_manual VALUES (905, 'ifx_num_fields', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result_id', 'Returns the number of columns in the query', 1042390517);
INSERT INTO php_manual VALUES (906, 'ifx_num_rows', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result_id', 'Count the rows already fetched from a query', 1042390517);
INSERT INTO php_manual VALUES (907, 'ifx_pconnect', 'PHP 3>= 3.0.3, PHP 4', 'int', '[string database], [string userid], [string password]', 'Open persistent Informix connection', 1042390517);
INSERT INTO php_manual VALUES (908, 'ifx_prepare', 'PHP 3>= 3.0.4, PHP 4', 'int', 'string query, int conn_id, [int cursor_def], mixed blobidarray', 'Prepare an SQL-statement for execution', 1042390517);
INSERT INTO php_manual VALUES (909, 'ifx_query', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string query, int link_identifier, [int cursor_type], [mixed blobidarray ]', 'Send Informix query', 1042390517);
INSERT INTO php_manual VALUES (910, 'ifx_textasvarchar', 'PHP 3>= 3.0.4, PHP 4', 'void', 'int mode', 'Set the default text mode', 1042390517);
INSERT INTO php_manual VALUES (911, 'ifx_update_blob', 'PHP 3>= 3.0.4, PHP 4', '', 'int bid, string content', 'Updates the content of the blob object', 1042390517);
INSERT INTO php_manual VALUES (912, 'ifx_update_char', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int bid, string content', 'Updates the content of the char object', 1042390517);
INSERT INTO php_manual VALUES (913, 'ifxus_close_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int bid', 'Deletes the slob object', 1042390517);
INSERT INTO php_manual VALUES (914, 'ifxus_create_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int mode', 'Creates an slob object and opens it', 1042390517);
INSERT INTO php_manual VALUES (915, 'ifxus_free_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int bid', 'Deletes the slob object', 1042390517);
INSERT INTO php_manual VALUES (916, 'ifxus_open_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'long bid, int mode', 'Opens an slob object', 1042390517);
INSERT INTO php_manual VALUES (917, 'ifxus_read_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'long bid, long nbytes', 'Reads nbytes of the slob object', 1042390517);
INSERT INTO php_manual VALUES (918, 'ifxus_seek_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'long bid, int mode, long offset', 'Sets the current file or seek position', 1042390517);
INSERT INTO php_manual VALUES (919, 'ifxus_tell_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'long bid', 'Returns the current file or seek position', 1042390517);
INSERT INTO php_manual VALUES (920, 'ifxus_write_slob', 'PHP 3>= 3.0.4, PHP 4', 'int', 'long bid, string content', 'Writes a string into the slob object', 1042390517);
INSERT INTO php_manual VALUES (921, 'iis_add_server', '', 'int', 'string path, string comment, string server_ip, int port, string host_name, int rights, int start_server', 'Creates a new virtual web server', 1042390517);
INSERT INTO php_manual VALUES (922, 'iis_get_dir_security', '', 'int', 'int server_instance, string virtual_path', 'Gets Directory Security', 1042390517);
INSERT INTO php_manual VALUES (923, 'iis_get_script_map', '', 'int', 'int server_instance, string virtual_path, string script_extension', 'Gets script mapping on a virtual directory for a specific extention', 1042390517);
INSERT INTO php_manual VALUES (924, 'iis_get_server_by_comment', '', 'int', 'string comment', 'Return the instance number associated with the Comment', 1042390517);
INSERT INTO php_manual VALUES (925, 'iis_get_server_by_path', '', 'int', 'string path', 'Return the instance number associated with the Path', 1042390517);
INSERT INTO php_manual VALUES (926, 'iis_get_server_rights', '', 'int', 'int server_instance, string virtual_path', 'Gets server rights', 1042390517);
INSERT INTO php_manual VALUES (927, 'iis_get_service_state', '', 'int', 'string service_id', 'Starts the service defined by ServiceId', 1042390517);
INSERT INTO php_manual VALUES (928, 'iis_remove_server', '', 'int', 'int server_instance', 'Removes the virtual web server indicated by ServerInstance', 1042390517);
INSERT INTO php_manual VALUES (929, 'iis_set_app_settings', '', 'int', 'int server_instance, string virtual_path, string application_scope', 'Creates application scope for a virtual directory', 1042390517);
INSERT INTO php_manual VALUES (930, 'iis_set_dir_security', '', 'int', 'int server_instance, string virtual_path, int directory_flags', 'Sets Directory Security', 1042390517);
INSERT INTO php_manual VALUES (931, 'iis_set_script_map', '', 'int', 'int server_instance, string virtual_path, string script_extension, string engine_path, int allow_scripting', 'Sets script mapping on a virtual directory', 1042390517);
INSERT INTO php_manual VALUES (932, 'iis_set_server_rights', '', 'int', 'int server_instance, string virtual_path, int directory_flags', 'Sets server rights', 1042390517);
INSERT INTO php_manual VALUES (933, 'iis_start_server', '', 'int', 'int server_instance', 'Starts the virtual web server', 1042390517);
INSERT INTO php_manual VALUES (934, 'iis_start_service', '', 'int', 'string service_id', 'Starts the service defined by ServiceId', 1042390517);
INSERT INTO php_manual VALUES (935, 'iis_stop_server', '', 'int', 'int server_instance', 'Stops the virtual web server', 1042390517);
INSERT INTO php_manual VALUES (936, 'iis_stop_service', '', 'int', 'string service_id', 'Stops the service defined by ServiceId', 1042390517);
INSERT INTO php_manual VALUES (937, 'exif_imagetype', 'PHP 4 >= 4.3.0', 'int|fals', 'string filename', 'Determine the type of an image', 1042390517);
INSERT INTO php_manual VALUES (938, 'exif_read_data', 'PHP 4 >= 4.2.0', 'array', 'string filename, [string sections], [bool arrays], [bool thumbnail]', 'Read the EXIF headers from JPEG or TIFF. This way you can read meta data generated by digital cameras.', 1042390517);
INSERT INTO php_manual VALUES (939, 'exif_thumbnail', 'PHP 4 >= 4.2.0', 'string', 'string filename, [int &width], [int &height], [int &imagetype]', 'Retrieve the embedded thumbnail of a TIFF or JPEG image', 1042390517);
INSERT INTO php_manual VALUES (940, 'getimagesize', 'PHP 3, PHP 4', 'array', 'string filename, [array imageinfo]', 'Get the size of an image', 1042390517);
INSERT INTO php_manual VALUES (941, 'image_type_to_mime_type', 'PHP 4 >= 4.3.0', 'string', 'int imagetype', 'Get Mime-Type for image-type returned by getimagesize, exif_read_data, exif_thumbnail, exif_imagetype', 1042390518);
INSERT INTO php_manual VALUES (942, 'image2wbmp', 'PHP 4 >= 4.0.5', 'int', 'resource image, [string filename], [int threshold]', 'Output image to browser or file', 1042390518);
INSERT INTO php_manual VALUES (943, 'imagealphablending', 'PHP 4 >= 4.0.6', 'int', 'resource image, bool blendmode', 'Set the blending mode for an image', 1042390518);
INSERT INTO php_manual VALUES (944, 'imagearc', 'PHP 3, PHP 4', 'int', 'resource image, int cx, int cy, int w, int h, int s, int e, int col', 'Draw a partial ellipse', 1042390518);
INSERT INTO php_manual VALUES (945, 'imagechar', 'PHP 3, PHP 4', 'int', 'resource image, int font, int x, int y, string c, int col', 'Draw a character horizontally', 1042390518);
INSERT INTO php_manual VALUES (946, 'imagecharup', 'PHP 3, PHP 4', 'int', 'resource image, int font, int x, int y, string c, int col', 'Draw a character vertically', 1042390518);
INSERT INTO php_manual VALUES (947, 'imagecolorallocate', 'PHP 3, PHP 4', 'int', 'resource image, int red, int green, int blue', 'Allocate a color for an image', 1042390518);
INSERT INTO php_manual VALUES (948, 'imagecolorat', 'PHP 3, PHP 4', 'int', 'resource image, int x, int y', 'Get the index of the color of a pixel', 1042390518);
INSERT INTO php_manual VALUES (949, 'imagecolorclosest', 'PHP 3, PHP 4', 'int', 'resource image, int red, int green, int blue', 'Get the index of the closest color to the specified color', 1042390518);
INSERT INTO php_manual VALUES (950, 'imagecolorclosestalpha', 'PHP 4 >= 4.0.6', 'int', 'resource image, int red, int green, int blue, int alpha', 'Get the index of the closest color to the specified color + alpha', 1042390518);
INSERT INTO php_manual VALUES (951, 'imagecolorclosesthwb', 'PHP 4 >= 4.0.1', 'int', 'resource image, int red, int green, int blue', ' Get the index of the color which has the hue, white and blackness nearest to the given color', 1042390518);
INSERT INTO php_manual VALUES (952, 'imagecolordeallocate', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource image, int color', 'De-allocate a color for an image', 1042390518);
INSERT INTO php_manual VALUES (953, 'imagecolorexact', 'PHP 3, PHP 4', 'int', 'resource image, int red, int green, int blue', 'Get the index of the specified color', 1042390518);
INSERT INTO php_manual VALUES (954, 'imagecolorexactalpha', 'PHP 4 >= 4.0.6', 'int', 'resource image, int red, int green, int blue, int alpha', 'Get the index of the specified color + alpha', 1042390518);
INSERT INTO php_manual VALUES (955, 'imagecolorresolve', 'PHP 3>= 3.0.2, PHP 4', 'int', 'resource image, int red, int green, int blue', ' Get the index of the specified color or its closest possible alternative', 1042390518);
INSERT INTO php_manual VALUES (956, 'imagecolorresolvealpha', 'PHP 4 >= 4.0.6', 'int', 'resource image, int red, int green, int blue, int alpha', ' Get the index of the specified color + alpha or its closest possible alternative', 1042390518);
INSERT INTO php_manual VALUES (957, 'imagecolorset', 'PHP 3, PHP 4', 'bool', 'resource image, int index, int red, int green, int blue', 'Set the color for the specified palette index', 1042390518);
INSERT INTO php_manual VALUES (958, 'imagecolorsforindex', 'PHP 3, PHP 4', 'array', 'resource image, int index', 'Get the colors for an index', 1042390518);
INSERT INTO php_manual VALUES (959, 'imagecolortransparent', 'PHP 3, PHP 4', 'int', 'resource image, [int color]', 'Define a color as transparent', 1042390518);
INSERT INTO php_manual VALUES (960, 'imagecopy', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h', 'Copy part of an image', 1042390518);
INSERT INTO php_manual VALUES (961, 'imagecopymerge', 'PHP 4 >= 4.0.1', 'int', 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct', 'Copy and merge part of an image', 1042390518);
INSERT INTO php_manual VALUES (962, 'imagecopymergegray', 'PHP 4 >= 4.0.6', 'int', 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct', 'Copy and merge part of an image with gray scale', 1042390518);
INSERT INTO php_manual VALUES (963, 'imagecopyresampled', 'PHP 4 >= 4.0.6', 'int', 'resource dst_im, resource src_im, int dstX, int dstY, int srcX, int srcY, int dstW, int dstH, int srcW, int srcH', 'Copy and resize part of an image with resampling', 1042390518);
INSERT INTO php_manual VALUES (964, 'imagecopyresized', 'PHP 3, PHP 4', 'int', 'resource dst_im, resource src_im, int dstX, int dstY, int srcX, int srcY, int dstW, int dstH, int srcW, int srcH', 'Copy and resize part of an image', 1042390518);
INSERT INTO php_manual VALUES (965, 'imagecreate', 'PHP 3, PHP 4', 'resource', 'int x_size, int y_size', 'Create a new palette based image', 1042390518);
INSERT INTO php_manual VALUES (966, 'imagecreatefromgd', 'PHP 4 >= 4.1.0', 'resource', 'string filename', 'Create a new image from GD file or URL', 1042390518);
INSERT INTO php_manual VALUES (967, 'imagecreatefromgd2', 'PHP 4 >= 4.1.0', 'resource', 'string filename', 'Create a new image from GD2 file or URL', 1042390518);
INSERT INTO php_manual VALUES (968, 'imagecreatefromgd2part', 'PHP 4 >= 4.1.0', 'resource', 'string filename, int srcX, int srcY, int width, int height', 'Create a new image from a given part of GD2 file or URL', 1042390518);
INSERT INTO php_manual VALUES (969, 'imagecreatefromgif', 'PHP 3, PHP 4', 'resource', 'string filename', 'Create a new image from file or URL', 1042390518);
INSERT INTO php_manual VALUES (970, 'imagecreatefromjpeg', 'PHP 3>= 3.0.16, PHP 4', 'resource', 'string filename', 'Create a new image from file or URL', 1042390518);
INSERT INTO php_manual VALUES (971, 'imagecreatefrompng', 'PHP 3>= 3.0.13, PHP 4', 'resource', 'string filename', 'Create a new image from file or URL', 1042390518);
INSERT INTO php_manual VALUES (972, 'imagecreatefromstring', 'PHP 4 >= 4.0.4', 'resource', 'string image', 'Create a new image from the image stream in the string', 1042390518);
INSERT INTO php_manual VALUES (973, 'imagecreatefromwbmp', 'PHP 4 >= 4.0.1', 'resource', 'string filename', 'Create a new image from file or URL', 1042390518);
INSERT INTO php_manual VALUES (974, 'imagecreatefromxbm', 'PHP 4 >= 4.0.1', 'resource', 'string filename', 'Create a new image from file or URL', 1042390518);
INSERT INTO php_manual VALUES (975, 'imagecreatefromxpm', 'PHP 4 >= 4.0.1', 'resource', 'string filename', 'Create a new image from file or URL', 1042390518);
INSERT INTO php_manual VALUES (976, 'imagecreatetruecolor', 'PHP 4 >= 4.0.6', 'resource', 'int x_size, int y_size', 'Create a new true color image', 1042390518);
INSERT INTO php_manual VALUES (977, 'imagedashedline', 'PHP 3, PHP 4', 'int', 'resource image, int x1, int y1, int x2, int y2, int col', 'Draw a dashed line', 1042390519);
INSERT INTO php_manual VALUES (978, 'imagedestroy', 'PHP 3, PHP 4', 'int', 'resource image', 'Destroy an image', 1042390519);
INSERT INTO php_manual VALUES (979, 'imageellipse', 'PHP 4 >= 4.0.6', 'int', 'resource image, int cx, int cy, int w, int h, int col', 'Draw an ellipse', 1042390519);
INSERT INTO php_manual VALUES (980, 'imagefill', 'PHP 3, PHP 4', 'int', 'resource image, int x, int y, int col', 'Flood fill', 1042390519);
INSERT INTO php_manual VALUES (981, 'imagefilledarc', 'PHP 4 >= 4.0.6', 'int', 'resource image, int cx, int cy, int w, int h, int s, int e, int col, int style', 'Draw a partial ellipse and fill it', 1042390519);
INSERT INTO php_manual VALUES (982, 'imagefilledellipse', 'PHP 4 >= 4.0.6', 'int', 'resource image, int cx, int cy, int w, int h, int col', 'Draw a filled ellipse', 1042390519);
INSERT INTO php_manual VALUES (983, 'imagefilledpolygon', 'PHP 3, PHP 4', 'int', 'resource image, array points, int num_points, int col', 'Draw a filled polygon', 1042390519);
INSERT INTO php_manual VALUES (984, 'imagefilledrectangle', 'PHP 3, PHP 4', 'int', 'resource image, int x1, int y1, int x2, int y2, int col', 'Draw a filled rectangle', 1042390519);
INSERT INTO php_manual VALUES (985, 'imagefilltoborder', 'PHP 3, PHP 4', 'int', 'resource image, int x, int y, int border, int col', 'Flood fill to specific color', 1042390519);
INSERT INTO php_manual VALUES (986, 'imagefontheight', 'PHP 3, PHP 4', 'int', 'int font', 'Get font height', 1042390519);
INSERT INTO php_manual VALUES (987, 'imagefontwidth', 'PHP 3, PHP 4', 'int', 'int font', 'Get font width', 1042390519);
INSERT INTO php_manual VALUES (988, 'imageftbbox', 'PHP 4 >= 4.1.0', 'array', 'int size, int angle, string font_file, string text, [array extrainfo]', 'Give the bounding box of a text using fonts via freetype2', 1042390519);
INSERT INTO php_manual VALUES (989, 'imagefttext', 'PHP 4 >= 4.1.0', 'array', 'resource image, int size, int angle, int x, int y, int col, string font_file, string text, [array extrainfo]', 'Write text to the image using fonts using FreeType 2', 1042390519);
INSERT INTO php_manual VALUES (990, 'imagegammacorrect', 'PHP 3>= 3.0.13, PHP 4', 'int', 'resource image, float inputgamma, float outputgamma', 'Apply a gamma correction to a GD image', 1042390519);
INSERT INTO php_manual VALUES (991, 'imagegd', 'PHP 4 >= 4.1.0', 'int', 'resource image, [string filename]', 'Output GD image to browser or file', 1042390519);
INSERT INTO php_manual VALUES (992, 'imagegd2', 'PHP 4 >= 4.1.0', 'int', 'resource image, [string filename]', 'Output GD2 image to browser or file', 1042390519);
INSERT INTO php_manual VALUES (993, 'imagegif', 'PHP 3, PHP 4', 'int', 'resource image, [string filename]', 'Output image to browser or file', 1042390519);
INSERT INTO php_manual VALUES (994, 'imageinterlace', 'PHP 3, PHP 4', 'int', 'resource image, [int interlace]', 'Enable or disable interlace', 1042390519);
INSERT INTO php_manual VALUES (995, 'imagejpeg', 'PHP 3>= 3.0.16, PHP 4', 'int', 'resource image, [string filename], [int quality]', 'Output image to browser or file', 1042390519);
INSERT INTO php_manual VALUES (996, 'imageline', 'PHP 3, PHP 4', 'int', 'resource image, int x1, int y1, int x2, int y2, int col', 'Draw a line', 1042390519);
INSERT INTO php_manual VALUES (997, 'imageloadfont', 'PHP 3, PHP 4', 'int', 'string file', 'Load a new font', 1042390519);
INSERT INTO php_manual VALUES (998, 'imagepalettecopy', 'PHP 4 >= 4.0.1', 'int', 'resource destination, resource source', 'Copy the palette from one image to another', 1042390519);
INSERT INTO php_manual VALUES (999, 'imagepng', 'PHP 3>= 3.0.13, PHP 4', 'int', 'resource image, [string filename]', 'Output a PNG image to either the browser or a file', 1042390519);
INSERT INTO php_manual VALUES (1000, 'imagepolygon', 'PHP 3, PHP 4', 'int', 'resource image, array points, int num_points, int col', 'Draw a polygon', 1042390519);
INSERT INTO php_manual VALUES (1001, 'imagesx', 'PHP 3, PHP 4', 'int', 'resource image', 'Get image width', 1042390519);
INSERT INTO php_manual VALUES (1002, 'imagepsbbox', 'PHP 3>= 3.0.9, PHP 4', 'array', 'string text, int font, int size, [int space], [int tightness], [float angle]', ' Give the bounding box of a text rectangle using PostScript Type1 fonts', 1042390519);
INSERT INTO php_manual VALUES (1003, 'imagepscopyfont', 'PHP 3>= 3.0.9, PHP 4', 'int', 'int fontindex', ' Make a copy of an already loaded font for further modification', 1042390519);
INSERT INTO php_manual VALUES (1004, 'imagepsencodefont', 'PHP 3>= 3.0.9, PHP 4', 'int', 'int font_index, string encodingfile', 'Change the character encoding vector of a font', 1042390519);
INSERT INTO php_manual VALUES (1005, 'imagepsextendfont', 'PHP 3>= 3.0.9, PHP 4', 'bool', 'int font_index, float extend', 'Extend or condense a font', 1042390519);
INSERT INTO php_manual VALUES (1006, 'imagepsfreefont', 'PHP 3>= 3.0.9, PHP 4', 'void', 'int fontindex', 'Free memory used by a PostScript Type 1 font', 1042390519);
INSERT INTO php_manual VALUES (1007, 'imagepsloadfont', 'PHP 3>= 3.0.9, PHP 4', 'int', 'string filename', 'Load a PostScript Type 1 font from file', 1042390519);
INSERT INTO php_manual VALUES (1008, 'imagepsslantfont', 'PHP 3>= 3.0.9, PHP 4', 'bool', 'int font_index, float slant', 'Slant a font', 1042390519);
INSERT INTO php_manual VALUES (1009, 'imagepstext', 'PHP 3>= 3.0.9, PHP 4', 'array', 'resource image, string text, int font, int size, int foreground, int background, int x, int y, [int space ], [int tightness ], [float angle ], [int antialias_steps ]', 'To draw a text string over an image using PostScript Type1 fonts', 1042390519);
INSERT INTO php_manual VALUES (1010, 'imagerectangle', 'PHP 3, PHP 4', 'int', 'resource image, int x1, int y1, int x2, int y2, int col', 'Draw a rectangle', 1042390519);
INSERT INTO php_manual VALUES (1011, 'imagerotate', 'PHP 4 >= 4.3.0', 'ressourc', 'resource src_im, float angle, int bgd_color', 'Rotate an image with a given angle', 1042390520);
INSERT INTO php_manual VALUES (1012, 'imagesetbrush', 'PHP 4 >= 4.0.6', 'int', 'resource image, resource brush', 'Set the brush image for line drawing', 1042390520);
INSERT INTO php_manual VALUES (1013, 'imagesetpixel', 'PHP 3, PHP 4', 'int', 'resource image, int x, int y, int col', 'Set a single pixel', 1042390520);
INSERT INTO php_manual VALUES (1014, 'imagesetstyle', 'PHP 4 >= 4.0.6', 'int', 'resource image, array style', 'Set the style for line drawing', 1042390520);
INSERT INTO php_manual VALUES (1015, 'imagesetthickness', 'PHP 4 >= 4.0.6', 'void', 'resource image, int thickness', 'Set the thickness for line drawing', 1042390520);
INSERT INTO php_manual VALUES (1016, 'imagesettile', 'PHP 4 >= 4.0.6', 'int', 'resource image, resource tile', 'Set the tile image for filling', 1042390520);
INSERT INTO php_manual VALUES (1017, 'imagestring', 'PHP 3, PHP 4', 'int', 'resource image, int font, int x, int y, string s, int col', 'Draw a string horizontally', 1042390520);
INSERT INTO php_manual VALUES (1018, 'imagestringup', 'PHP 3, PHP 4', 'int', 'resource image, int font, int x, int y, string s, int col', 'Draw a string vertically', 1042390520);
INSERT INTO php_manual VALUES (1019, 'imagesy', 'PHP 3, PHP 4', 'int', 'resource image', 'Get image height', 1042390520);
INSERT INTO php_manual VALUES (1020, 'imagetruecolortopalette', 'PHP 4 >= 4.0.6', 'void', 'resource image, bool dither, int ncolors', 'Convert a true color image to a palette image', 1042390520);
INSERT INTO php_manual VALUES (1021, 'imagettfbbox', 'PHP 3>= 3.0.1, PHP 4', 'array', 'int size, int angle, string fontfile, string text', 'Give the bounding box of a text using TrueType fonts', 1042390520);
INSERT INTO php_manual VALUES (1022, 'imagettftext', 'PHP 3, PHP 4', 'array', 'resource image, int size, int angle, int x, int y, int col, string fontfile, string text', 'Write text to the image using TrueType fonts', 1042390520);
INSERT INTO php_manual VALUES (1023, 'imagetypes', 'PHP 3 CVS only, PHP 4 >= 4.0.2', 'int', 'void', 'Return the image types supported by this PHP build', 1042390520);
INSERT INTO php_manual VALUES (1024, 'imagewbmp', 'PHP 3>= 3.0.15, PHP 4 >= 4.0.1', 'int', 'resource image, [string filename], [int foreground]', 'Output image to browser or file', 1042390520);
INSERT INTO php_manual VALUES (1025, 'iptcembed', 'PHP 3>= 3.0.7, PHP 4', 'array', 'string iptcdata, string jpeg_file_name, [int spool]', 'Embed binary IPTC data into a JPEG image', 1042390520);
INSERT INTO php_manual VALUES (1026, 'iptcparse', 'PHP 3>= 3.0.6, PHP 4', '', 'void', '', 1042390520);
INSERT INTO php_manual VALUES (1027, 'jpeg2wbmp', 'PHP 4 >= 4.0.5', 'int', 'string jpegname, string wbmpname, int d_height, int d_width, int threshold', 'Convert JPEG image file to WBMP image file', 1042390520);
INSERT INTO php_manual VALUES (1028, 'png2wbmp', 'PHP 4 >= 4.0.5', 'int', 'string pngname, string wbmpname, int d_height, int d_width, int threshold', 'Convert PNG image file to WBMP image file', 1042390520);
INSERT INTO php_manual VALUES (1029, 'read_exif_data', 'PHP 4 >= 4.0.1', 'array', 'string filename, string sections, bool arrays, bool thumbnail', 'Reads header information stored in TIFF and JPEG images', 1042390520);
INSERT INTO php_manual VALUES (1030, 'imap_8bit', 'PHP 3, PHP 4', 'string', 'string string', ' Convert an 8bit string to a quoted-printable string', 1042390520);
INSERT INTO php_manual VALUES (1031, 'imap_alerts', 'PHP 3>= 3.0.12, PHP 4', 'array', 'void', ' This function returns all IMAP alert messages (if any) that have occurred during this page request or since the alert stack was reset', 1042390520);
INSERT INTO php_manual VALUES (1032, 'imap_append', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string mbox, string message, [string options]', ' Append a string message to a specified mailbox', 1042390520);
INSERT INTO php_manual VALUES (1033, 'imap_base64', 'PHP 3, PHP 4', 'string', 'string text', 'Decode BASE64 encoded text', 1042390520);
INSERT INTO php_manual VALUES (1034, 'imap_binary', 'PHP 3>= 3.0.2, PHP 4', 'string', 'string string', ' Convert an 8bit string to a base64 string', 1042390520);
INSERT INTO php_manual VALUES (1035, 'imap_body', 'PHP 3, PHP 4', 'string', 'resource imap_stream, int msg_number, [int options]', 'Read the message body', 1042390520);
INSERT INTO php_manual VALUES (1036, 'imap_bodystruct', 'PHP 3>= 3.0.4, PHP 4', 'object', 'resource stream_id, int msg_no, int section', ' Read the structure of a specified body section of a specific message', 1042390520);
INSERT INTO php_manual VALUES (1037, 'imap_check', 'PHP 3, PHP 4', 'object', 'resource imap_stream', 'Check current mailbox', 1042390520);
INSERT INTO php_manual VALUES (1038, 'imap_clearflag_full', 'PHP 3>= 3.0.3, PHP 4', 'bool', 'resource stream, string sequence, string flag, string options', 'Clears flags on messages', 1042390520);
INSERT INTO php_manual VALUES (1039, 'imap_close', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, [int options]', 'Close an IMAP stream', 1042390520);
INSERT INTO php_manual VALUES (1040, 'imap_createmailbox', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string mbox', 'Create a new mailbox', 1042390520);
INSERT INTO php_manual VALUES (1041, 'imap_delete', 'PHP 3, PHP 4', 'bool', 'int imap_stream, int msg_number, [int options]', ' Mark a messge for deletion from current mailbox', 1042390520);
INSERT INTO php_manual VALUES (1042, 'imap_deletemailbox', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string mbox', 'Delete a mailbox', 1042390520);
INSERT INTO php_manual VALUES (1043, 'imap_errors', 'PHP 3>= 3.0.12, PHP 4', 'array', 'void', ' This function returns all of the IMAP errors (if any) that have occurred during this page request or since the error stack was reset.', 1042390520);
INSERT INTO php_manual VALUES (1044, 'imap_expunge', 'PHP 3, PHP 4', 'bool', 'resource imap_stream', 'Delete all messages marked for deletion', 1042390520);
INSERT INTO php_manual VALUES (1045, 'imap_fetch_overview', 'PHP 3>= 3.0.4, PHP 4', 'array', 'resource imap_stream, string sequence, [int options]', ' Read an overview of the information in the headers of the given message', 1042390520);
INSERT INTO php_manual VALUES (1046, 'imap_fetchbody', 'PHP 3, PHP 4', 'string', 'resource imap_stream, int msg_number, string part_number, [flags options]', ' Fetch a particular section of the body of the message', 1042390520);
INSERT INTO php_manual VALUES (1047, 'imap_fetchheader', 'PHP 3>= 3.0.3, PHP 4', 'string', 'resource imap_stream, int msgno, int options', 'Returns header for a message', 1042390520);
INSERT INTO php_manual VALUES (1048, 'imap_fetchstructure', 'PHP 3, PHP 4', 'object', 'resource imap_stream, int msg_number, [int options]', ' Read the structure of a particular message', 1042390520);
INSERT INTO php_manual VALUES (1049, 'imap_get_quota', 'PHP 4 >= 4.0.5', 'array', 'resource imap_stream, string quota_root', ' Retrieve the quota level settings, and usage statics per mailbox', 1042390521);
INSERT INTO php_manual VALUES (1050, 'imap_get_quotaroot', 'PHP 4 >= 4.3.0', 'array', 'resource imap_stream, string quota_root', ' Retrieve the quota settings per user', 1042390521);
INSERT INTO php_manual VALUES (1051, 'imap_getmailboxes', 'PHP 3>= 3.0.12, PHP 4', 'array', 'resource imap_stream, string ref, string pattern', ' Read the list of mailboxes, returning detailed information on each one', 1042390521);
INSERT INTO php_manual VALUES (1052, 'imap_getsubscribed', 'PHP 3>= 3.0.12, PHP 4', 'array', 'resource imap_stream, string ref, string pattern', 'List all the subscribed mailboxes', 1042390521);
INSERT INTO php_manual VALUES (1053, 'imap_header', 'PHP 3, PHP 4', 'object', 'resource imap_stream, int msg_number, [int fromlength], [int subjectlength], [string defaulthost]', 'Read the header of the message', 1042390521);
INSERT INTO php_manual VALUES (1054, 'imap_headerinfo', 'PHP 3, PHP 4', 'object', 'resource imap_stream, int msg_number, [int fromlength], [int subjectlength], [string defaulthost]', 'Read the header of the message', 1042390521);
INSERT INTO php_manual VALUES (1055, 'imap_headers', 'PHP 3, PHP 4', 'array', 'resource imap_stream', ' Returns headers for all messages in a mailbox', 1042390521);
INSERT INTO php_manual VALUES (1056, 'imap_last_error', 'PHP 3>= 3.0.12, PHP 4', 'string', 'void', ' This function returns the last IMAP error (if any) that occurred during this page request', 1042390521);
INSERT INTO php_manual VALUES (1057, 'imap_list', 'PHP 3>= 3.0.4, PHP 4', 'array', 'resource imap_stream, string ref, string pattern', 'Read the list of mailboxes', 1042390521);
INSERT INTO php_manual VALUES (1058, 'imap_listmailbox', 'PHP 3, PHP 4', 'array', 'resource imap_stream, string ref, string pattern', 'Read the list of mailboxes', 1042390521);
INSERT INTO php_manual VALUES (1059, 'imap_listscan', '', 'array', 'resource imap_stream, string ref, string pattern, string content', ' Read the list of mailboxes, takes a string to search for in the text of the mailbox', 1042390521);
INSERT INTO php_manual VALUES (1060, 'imap_listsubscribed', 'PHP 3, PHP 4', 'array', 'resource imap_stream, string ref, string pattern', 'List all the subscribed mailboxes', 1042390521);
INSERT INTO php_manual VALUES (1061, 'imap_lsub', 'PHP 3>= 3.0.4, PHP 4', 'array', 'resource imap_stream, string ref, string pattern', 'List all the subscribed mailboxes', 1042390521);
INSERT INTO php_manual VALUES (1062, 'imap_mail_compose', 'PHP 3>= 3.0.5, PHP 4', 'string', 'array envelope, array body', ' Create a MIME message based on given envelope and body sections', 1042390521);
INSERT INTO php_manual VALUES (1063, 'imap_mail_copy', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string msglist, string mbox, [int options]', 'Copy specified messages to a mailbox', 1042390521);
INSERT INTO php_manual VALUES (1064, 'imap_mail_move', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string msglist, string mbox, [int options]', 'Move specified messages to a mailbox', 1042390521);
INSERT INTO php_manual VALUES (1065, 'imap_mail', 'PHP 3>= 3.0.14, PHP 4', 'string', 'string to, string subject, string message, [string additional_headers], [string cc], [string bcc], [string rpath]', ' Send an email message', 1042390521);
INSERT INTO php_manual VALUES (1066, 'imap_mailboxmsginfo', 'PHP 3>= 3.0.2, PHP 4', 'object', 'resource imap_stream', 'Get information about the current mailbox', 1042390521);
INSERT INTO php_manual VALUES (1067, 'imap_mime_header_decode', 'PHP 3>= 3.0.17, PHP 4', 'array', 'string text', 'Decode MIME header elements', 1042390521);
INSERT INTO php_manual VALUES (1068, 'imap_msgno', 'PHP 3>= 3.0.3, PHP 4', 'int', 'resource imap_stream, int uid', ' This function returns the message sequence number for the given UID', 1042390521);
INSERT INTO php_manual VALUES (1069, 'imap_num_msg', 'PHP 3, PHP 4', 'int', 'resource imap_stream', ' Gives the number of messages in the current mailbox', 1042390521);
INSERT INTO php_manual VALUES (1070, 'imap_num_recent', 'PHP 3, PHP 4', 'int', 'resource imap_stream', 'Gives the number of recent messages in current mailbox', 1042390521);
INSERT INTO php_manual VALUES (1071, 'imap_open', 'PHP 3, PHP 4', 'resource', 'string mailbox, string username, string password, [int options]', 'Open an IMAP stream to a mailbox', 1042390521);
INSERT INTO php_manual VALUES (1072, 'imap_ping', 'PHP 3, PHP 4', 'bool', 'resource imap_stream', 'Check if the IMAP stream is still active', 1042390521);
INSERT INTO php_manual VALUES (1073, 'imap_qprint', 'PHP 3, PHP 4', 'string', 'string string', 'Convert a quoted-printable string to an 8 bit string', 1042390521);
INSERT INTO php_manual VALUES (1074, 'imap_renamemailbox', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string old_mbox, string new_mbox', 'Rename an old mailbox to new mailbox', 1042390521);
INSERT INTO php_manual VALUES (1075, 'imap_reopen', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string mailbox, [string options]', 'Reopen IMAP stream to new mailbox', 1042390521);
INSERT INTO php_manual VALUES (1076, 'imap_rfc822_parse_adrlist', 'PHP 3>= 3.0.2, PHP 4', 'array', 'string address, string default_host', 'Parses an address string', 1042390521);
INSERT INTO php_manual VALUES (1077, 'imap_rfc822_parse_headers', 'PHP 4', 'object', 'string headers, [string defaulthost]', 'Parse mail headers from a string', 1042390521);
INSERT INTO php_manual VALUES (1078, 'imap_rfc822_write_address', 'PHP 3>= 3.0.2, PHP 4', 'string', 'string mailbox, string host, string personal', ' Returns a properly formatted email address given the mailbox, host, and personal info.', 1042390521);
INSERT INTO php_manual VALUES (1079, 'imap_scanmailbox', 'PHP 3, PHP 4', 'array', 'resource imap_stream, string ref, string pattern, string content', ' Read the list of mailboxes, takes a string to search for in the text of the mailbox', 1042390521);
INSERT INTO php_manual VALUES (1080, 'imap_search', 'PHP 3>= 3.0.12, PHP 4', 'array', 'resource imap_stream, string criteria, int options', ' This function returns an array of messages matching the given search criteria', 1042390521);
INSERT INTO php_manual VALUES (1081, 'imap_set_quota', 'PHP 4 >= 4.0.5', 'bool', 'resource imap_stream, string quota_root, int quota_limit', 'Sets a quota for a given mailbox', 1042390521);
INSERT INTO php_manual VALUES (1082, 'imap_setacl', 'PHP 4 >= 4.1.0', 'bool', 'resource stream_id, string mailbox, string id, string rights', ' Sets the ACL for a giving mailbox', 1042390521);
INSERT INTO php_manual VALUES (1083, 'imap_setflag_full', 'PHP 3>= 3.0.3, PHP 4', 'bool', 'resource stream, string sequence, string flag, string options', 'Sets flags on messages', 1042390521);
INSERT INTO php_manual VALUES (1084, 'imap_sort', 'PHP 3>= 3.0.3, PHP 4', 'array', 'resource stream, int criteria, int reverse, [int options], [string search_criteria]', 'Sort an array of message headers', 1042390521);
INSERT INTO php_manual VALUES (1085, 'imap_status', 'PHP 3>= 3.0.4, PHP 4', 'object', 'resource imap_stream, string mailbox, int options', ' This function returns status information on a mailbox other than the current one', 1042390521);
INSERT INTO php_manual VALUES (1086, 'imap_subscribe', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, string mbox', 'Subscribe to a mailbox', 1042390521);
INSERT INTO php_manual VALUES (1087, 'imap_thread', 'PHP 4 >= 4.1.0', 'array', 'resource stream_id, [int options]', ' Return threaded by REFERENCES tree', 1042390521);
INSERT INTO php_manual VALUES (1088, 'imap_uid', 'PHP 3>= 3.0.3, PHP 4', 'int', 'resource imap_stream, int msgno', ' This function returns the UID for the given message sequence number', 1042390521);
INSERT INTO php_manual VALUES (1089, 'imap_undelete', 'PHP 3, PHP 4', 'bool', 'resource imap_stream, int msg_number', ' Unmark the message which is marked deleted', 1042390521);
INSERT INTO php_manual VALUES (1090, 'imap_unsubscribe', 'PHP 3, PHP 4', 'bool', 'string imap_stream, string mbox', 'Unsubscribe from a mailbox', 1042390522);
INSERT INTO php_manual VALUES (1091, 'imap_utf7_decode', 'PHP 3>= 3.0.15, PHP 4', 'string', 'string text', ' Decodes a modified UTF-7 encoded string.', 1042390522);
INSERT INTO php_manual VALUES (1092, 'imap_utf7_encode', 'PHP 3>= 3.0.15, PHP 4', 'string', 'string data', ' Converts 8bit data to modified UTF-7 text.', 1042390522);
INSERT INTO php_manual VALUES (1093, 'imap_utf8', 'PHP 3>= 3.0.13, PHP 4', 'string', 'string text', ' Converts text to UTF8', 1042390522);
INSERT INTO php_manual VALUES (1094, 'assert_options', 'PHP 4', 'mixed', 'int what, [mixed value]', 'Set/get the various assert flags', 1042390522);
INSERT INTO php_manual VALUES (1095, 'assert', 'PHP 4', '', 'void', '', 1042390522);
INSERT INTO php_manual VALUES (1096, 'dl', 'PHP 3, PHP 4', 'bool', 'string library', 'Loads a PHP extension at runtime', 1042390522);
INSERT INTO php_manual VALUES (1097, 'extension_loaded', 'PHP 3>= 3.0.10, PHP 4', 'bool', 'string name', 'Find out whether an extension is loaded', 1042390522);
INSERT INTO php_manual VALUES (1098, 'get_cfg_var', 'PHP 3, PHP 4', 'string', 'string varname', ' Gets the value of a PHP configuration option', 1042390522);
INSERT INTO php_manual VALUES (1099, 'get_current_user', 'PHP 3, PHP 4', 'string', 'void', ' Gets the name of the owner of the current PHP script', 1042390522);
INSERT INTO php_manual VALUES (1100, 'get_defined_constants', 'PHP 4 >= 4.1.0', 'array', 'void', ' Returns an associative array with the names of all the constants and their values', 1042390522);
INSERT INTO php_manual VALUES (1101, 'get_extension_funcs', 'PHP 4', 'array', 'string module_name', ' Returns an array with the names of the functions of a module', 1042390522);
INSERT INTO php_manual VALUES (1102, 'get_included_files', 'PHP 4', 'array', 'void', ' Returns an array with the names of included or required files', 1042390522);
INSERT INTO php_manual VALUES (1103, 'get_loaded_extensions', 'PHP 4', 'array', 'void', ' Returns an array with the names of all modules compiled and loaded', 1042390522);
INSERT INTO php_manual VALUES (1104, 'get_magic_quotes_gpc', 'PHP 3>= 3.0.6, PHP 4', 'int', 'void', ' Gets the current active configuration setting of magic quotes gpc', 1042390522);
INSERT INTO php_manual VALUES (1105, 'get_magic_quotes_runtime', 'PHP 3>= 3.0.6, PHP 4', 'long', 'void', ' Gets the current active configuration setting of magic_quotes_runtime', 1042390522);
INSERT INTO php_manual VALUES (1106, 'get_required_files', 'PHP 4', 'array', 'void', ' Returns an array with the names of included or required files', 1042390522);
INSERT INTO php_manual VALUES (1107, 'getenv', 'PHP 3, PHP 4', 'string', 'string varname', 'Gets the value of an environment variable', 1042390522);
INSERT INTO php_manual VALUES (1108, 'getlastmod', 'PHP 3, PHP 4', 'int', 'void', 'Gets time of last page modification', 1042390522);
INSERT INTO php_manual VALUES (1109, 'getmyinode', 'PHP 3, PHP 4', 'int', 'void', 'Gets the inode of the current script', 1042390522);
INSERT INTO php_manual VALUES (1110, 'getopt', 'PHP 4 >= 4.3.0', 'string', 'string options', 'Gets options from the command line argument list', 1042390522);
INSERT INTO php_manual VALUES (1111, 'getrusage', 'PHP 3>= 3.0.7, PHP 4', 'array', '[int who]', 'Gets the current resource usages', 1042390522);
INSERT INTO php_manual VALUES (1112, 'ini_alter', 'PHP 4', 'string', 'string varname, string newvalue', ' Changes the value of a configuration option', 1042390522);
INSERT INTO php_manual VALUES (1113, 'ini_get_all', 'PHP 4 >= 4.2.0', 'array', '[string extension]', 'Gets all configuration options', 1042390522);
INSERT INTO php_manual VALUES (1114, 'ini_get', 'PHP 4', 'string', 'string varname', 'Gets the value of a configuration option', 1042390522);
INSERT INTO php_manual VALUES (1115, 'ini_restore', 'PHP 4', 'string', 'string varname', 'Restores the value of a configuration option', 1042390522);
INSERT INTO php_manual VALUES (1116, 'ini_set', 'PHP 4', 'string', 'string varname, string newvalue', 'Sets the value of a configuration option', 1042390522);
INSERT INTO php_manual VALUES (1117, 'php_ini_scanned_files', 'PHP 4 >= 4.3.0', 'string', 'void', 'Return a list of .ini files parsed from the additional ini dir', 1042390522);
INSERT INTO php_manual VALUES (1118, 'php_logo_guid', 'PHP 4', 'string', 'void', 'Gets the logo guid', 1042390522);
INSERT INTO php_manual VALUES (1119, 'php_sapi_name', 'PHP 4 >= 4.0.1', 'string', 'void', ' Returns the type of interface between web server and PHP', 1042390522);
INSERT INTO php_manual VALUES (1120, 'php_uname', 'PHP 4 >= 4.0.2', 'string', 'void', ' Returns information about the operating system PHP was built on', 1042390522);
INSERT INTO php_manual VALUES (1121, 'phpcredits', 'PHP 4', 'void', '[int flag]', 'Prints out the credits for PHP', 1042390522);
INSERT INTO php_manual VALUES (1122, 'phpinfo', 'PHP 3, PHP 4', 'int', '[int what]', 'Outputs lots of PHP information', 1042390522);
INSERT INTO php_manual VALUES (1123, 'phpversion', 'PHP 3, PHP 4', 'string', 'void', 'Gets the current PHP version', 1042390522);
INSERT INTO php_manual VALUES (1124, 'putenv', 'PHP 3, PHP 4', 'void', 'string setting', 'Sets the value of an environment variable', 1042390522);
INSERT INTO php_manual VALUES (1125, 'set_magic_quotes_runtime', 'PHP 3>= 3.0.6, PHP 4', 'long', 'int new_setting', ' Sets the current active configuration setting of magic_quotes_runtime', 1042390522);
INSERT INTO php_manual VALUES (1126, 'set_time_limit', 'PHP 3, PHP 4', 'void', 'int seconds', 'Limits the maximum execution time', 1042390522);
INSERT INTO php_manual VALUES (1127, 'version_compare', 'PHP 4 >= 4.1.0', 'int', 'string version1, string version2, [string operator ]', ' Compares two "PHP-standardized" version number strings', 1042390522);
INSERT INTO php_manual VALUES (1128, 'zend_logo_guid', 'PHP 4', 'string', 'void', 'Gets the zend guid', 1042390522);
INSERT INTO php_manual VALUES (1129, 'zend_version', 'PHP 4', 'string', 'void', 'Gets the version of the current Zend engine', 1042390522);
INSERT INTO php_manual VALUES (1130, 'ingres_autocommit', 'PHP 4 >= 4.0.2', 'bool', '[resource link]', 'Switch autocommit on or off', 1042390522);
INSERT INTO php_manual VALUES (1131, 'ingres_close', 'PHP 4 >= 4.0.2', 'bool', '[resource link]', 'Close an Ingres II database connection', 1042390522);
INSERT INTO php_manual VALUES (1132, 'ingres_commit', 'PHP 4 >= 4.0.2', 'bool', '[resource link]', 'Commit a transaction', 1042390522);
INSERT INTO php_manual VALUES (1133, 'ingres_connect', 'PHP 4 >= 4.0.2', 'resource', '[string database], [string username], [string password]', ' Open a connection to an Ingres II database', 1042390522);
INSERT INTO php_manual VALUES (1134, 'ingres_fetch_array', 'PHP 4 >= 4.0.2', 'array', '[int result_type], [resource link]', 'Fetch a row of result into an array', 1042390523);
INSERT INTO php_manual VALUES (1135, 'ingres_fetch_object', 'PHP 4 >= 4.0.2', 'object', '[int result_type], [resource link]', 'Fetch a row of result into an object.', 1042390523);
INSERT INTO php_manual VALUES (1136, 'ingres_fetch_row', 'PHP 4 >= 4.0.2', 'array', '[resource link]', ' Fetch a row of result into an enumerated array', 1042390523);
INSERT INTO php_manual VALUES (1137, 'ingres_field_length', 'PHP 4 >= 4.0.2', 'int', 'int index, [resource link]', 'Get the length of a field', 1042390523);
INSERT INTO php_manual VALUES (1138, 'ingres_field_name', 'PHP 4 >= 4.0.2', 'string', 'int index, [resource link]', 'Get the name of a field in a query result.', 1042390523);
INSERT INTO php_manual VALUES (1139, 'ingres_field_nullable', 'PHP 4 >= 4.0.2', 'bool', 'int index, [resource link]', 'Test if a field is nullable', 1042390523);
INSERT INTO php_manual VALUES (1140, 'ingres_field_precision', 'PHP 4 >= 4.0.2', 'int', 'int index, [resource link]', 'Get the precision of a field', 1042390523);
INSERT INTO php_manual VALUES (1141, 'ingres_field_scale', 'PHP 4 >= 4.0.2', 'int', 'int index, [resource link]', 'Get the scale of a field', 1042390523);
INSERT INTO php_manual VALUES (1142, 'ingres_field_type', 'PHP 4 >= 4.0.2', 'string', 'int index, [resource link]', ' Get the type of a field in a query result', 1042390523);
INSERT INTO php_manual VALUES (1143, 'ingres_num_fields', 'PHP 4 >= 4.0.2', 'int', '[resource link]', ' Get the number of fields returned by the last query', 1042390523);
INSERT INTO php_manual VALUES (1144, 'ingres_num_rows', 'PHP 4 >= 4.0.2', 'int', '[resource link]', ' Get the number of rows affected or returned by the last query', 1042390523);
INSERT INTO php_manual VALUES (1145, 'ingres_pconnect', 'PHP 4 >= 4.0.2', 'resource', '[string database], [string username], [string password]', ' Open a persistent connection to an Ingres II database', 1042390523);
INSERT INTO php_manual VALUES (1146, 'ingres_query', 'PHP 4 >= 4.0.2', 'bool', 'string query, [resource link]', 'Send a SQL query to Ingres II', 1042390523);
INSERT INTO php_manual VALUES (1147, 'ingres_rollback', 'PHP 4 >= 4.0.2', 'bool', '[resource link]', 'Roll back a transaction', 1042390523);
INSERT INTO php_manual VALUES (1148, 'ircg_channel_mode', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string channel, string mode_spec, string nick', ' Set channel mode flags for user', 1042390523);
INSERT INTO php_manual VALUES (1149, 'ircg_disconnect', 'PHP 4 >= 4.0.4', 'boolean', 'resource connection, string reason', ' Close connection to server', 1042390523);
INSERT INTO php_manual VALUES (1150, 'ircg_fetch_error_msg', 'PHP 4 >= 4.1.0', 'array', 'resource connection', ' Returns the error from previous IRCG operation', 1042390523);
INSERT INTO php_manual VALUES (1151, 'ircg_get_username', 'PHP 4 >= 4.1.0', 'string', 'resource connection', ' Get username for connection', 1042390523);
INSERT INTO php_manual VALUES (1152, 'ircg_html_encode', 'PHP 4 >= 4.0.5', 'boolean', 'string html_string', ' Encodes HTML preserving output', 1042390523);
INSERT INTO php_manual VALUES (1153, 'ircg_ignore_add', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string nick', ' Add a user to your ignore list on a server', 1042390523);
INSERT INTO php_manual VALUES (1154, 'ircg_ignore_del', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string nick', ' Remove a user from your ignore list on a server', 1042390523);
INSERT INTO php_manual VALUES (1155, 'ircg_is_conn_alive', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection', ' Check connection status', 1042390523);
INSERT INTO php_manual VALUES (1156, 'ircg_join', 'PHP 4 >= 4.0.4', 'boolean', 'resource connection, string channel, [string key]', ' Join a channel on a connected server', 1042390523);
INSERT INTO php_manual VALUES (1157, 'ircg_kick', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string channel, string nick, string reason', ' Kick a user out of a channel on server', 1042390523);
INSERT INTO php_manual VALUES (1158, 'ircg_lookup_format_messages', 'PHP 4 >= 4.0.5', 'boolean', 'string name', ' Check for the existence of a format message set', 1042390523);
INSERT INTO php_manual VALUES (1159, 'ircg_msg', 'PHP 4 >= 4.0.4', 'boolean', 'resource connection, string recipient, string message, [boolean suppress]', ' Send message to channel or user on server', 1042390523);
INSERT INTO php_manual VALUES (1160, 'ircg_nick', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string nick', ' Change nickname on server', 1042390523);
INSERT INTO php_manual VALUES (1161, 'ircg_nickname_escape', 'PHP 4 >= 4.0.6', 'string', 'string nick', ' Encode special characters in nickname to be IRC-compliant', 1042390523);
INSERT INTO php_manual VALUES (1162, 'ircg_notice', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string message', ' Send a notice to a user on server', 1042390523);
INSERT INTO php_manual VALUES (1163, 'ircg_nickname_unescape', 'PHP 4 >= 4.0.6', 'string', 'string nick', ' Decodes encoded nickname', 1042390523);
INSERT INTO php_manual VALUES (1164, 'ircg_part', 'PHP 4 >= 4.0.4', 'boolean', 'resource connection, string channel', ' Leave a channel on server', 1042390523);
INSERT INTO php_manual VALUES (1165, 'ircg_pconnect', 'PHP 4 >= 4.0.4', 'resource', 'string username, [string server_ip], [int server_port], [string msg_format], [array ctcp_messages], [array user_settings]', ' Connect to an IRC server', 1042390523);
INSERT INTO php_manual VALUES (1166, 'ircg_register_format_messages', 'PHP 4 >= 4.0.5', 'boolean', 'string name, array messages', ' Register a format message set', 1042390523);
INSERT INTO php_manual VALUES (1167, 'ircg_set_current', 'PHP 4 >= 4.0.4', 'boolean', 'resource connection', ' Set current connection for output', 1042390523);
INSERT INTO php_manual VALUES (1168, 'ircg_set_file', 'PHP 4 >= 4.2.0', 'bool', 'resource connection, string path', ' Set logfile for connection', 1042390523);
INSERT INTO php_manual VALUES (1169, 'ircg_set_on_die', 'PHP 4 >= 4.2.0', 'bool', 'resource connection, string host, int port, string data', ' Set action to be executed when connection dies', 1042390523);
INSERT INTO php_manual VALUES (1170, 'ircg_topic', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string channel, string new_topic', ' Set topic for channel on server', 1042390523);
INSERT INTO php_manual VALUES (1171, 'ircg_whois', 'PHP 4 >= 4.0.5', 'boolean', 'resource connection, string nick', ' Query server for user information', 1042390523);
INSERT INTO php_manual VALUES (1172, 'java_last_exception_clear', 'PHP 4 >= 4.0.2', 'void', 'void', 'Clear last Java exception', 1042390523);
INSERT INTO php_manual VALUES (1173, 'java_last_exception_get', 'PHP 4 >= 4.0.2', 'exceptio', 'void', 'Get last Java exception', 1042390523);
INSERT INTO php_manual VALUES (1174, 'ldap_8859_to_t61', 'PHP 4 >= 4.0.2', 'string', 'string value', ' Translate 8859 characters to t61 characters', 1042390523);
INSERT INTO php_manual VALUES (1175, 'ldap_add', 'PHP 3, PHP 4', 'bool', 'resource link_identifier, string dn, array entry', 'Add entries to LDAP directory', 1042390523);
INSERT INTO php_manual VALUES (1176, 'ldap_bind', 'PHP 3, PHP 4', 'bool', 'resource link_identifier, [string bind_rdn], [string bind_password]', 'Bind to LDAP directory', 1042390523);
INSERT INTO php_manual VALUES (1177, 'ldap_close', 'PHP 3, PHP 4', 'bool', 'resource link_identifier', 'Close link to LDAP server', 1042390523);
INSERT INTO php_manual VALUES (1178, 'ldap_compare', 'PHP 4 >= 4.0.2', 'bool', 'resource link_identifier, string dn, string attribute, string value', 'Compare value of attribute found in entry specified with DN', 1042390523);
INSERT INTO php_manual VALUES (1179, 'ldap_connect', 'PHP 3, PHP 4', 'resource', '[string hostname], [int port]', 'Connect to an LDAP server', 1042390523);
INSERT INTO php_manual VALUES (1180, 'ldap_count_entries', 'PHP 3, PHP 4', 'int', 'resource link_identifier, resource result_identifier', 'Count the number of entries in a search', 1042390523);
INSERT INTO php_manual VALUES (1181, 'ldap_delete', 'PHP 3, PHP 4', 'bool', 'resource link_identifier, string dn', 'Delete an entry from a directory', 1042390523);
INSERT INTO php_manual VALUES (1182, 'ldap_dn2ufn', 'PHP 3, PHP 4', 'string', 'string dn', 'Convert DN to User Friendly Naming format', 1042390523);
INSERT INTO php_manual VALUES (1183, 'ldap_err2str', 'PHP 3>= 3.0.13, PHP 4', 'string', 'int errno', ' Convert LDAP error number into string error message', 1042390523);
INSERT INTO php_manual VALUES (1184, 'ldap_errno', 'PHP 3>= 3.0.12, PHP 4', 'int', 'resource link_identifier', ' Return the LDAP error number of the last LDAP command', 1042390523);
INSERT INTO php_manual VALUES (1185, 'ldap_error', 'PHP 3>= 3.0.12, PHP 4', 'string', 'resource link_identifier', ' Return the LDAP error message of the last LDAP command', 1042390524);
INSERT INTO php_manual VALUES (1186, 'ldap_explode_dn', 'PHP 3, PHP 4', 'array', 'string dn, int with_attrib', 'Splits DN into its component parts', 1042390524);
INSERT INTO php_manual VALUES (1187, 'ldap_first_attribute', 'PHP 3, PHP 4', 'string', 'resource link_identifier, resource result_entry_identifier, int ber_identifier', 'Return first attribute', 1042390524);
INSERT INTO php_manual VALUES (1188, 'ldap_first_entry', 'PHP 3, PHP 4', 'resource', 'resource link_identifier, resource result_identifier', 'Return first result id', 1042390524);
INSERT INTO php_manual VALUES (1189, 'ldap_first_reference', 'PHP 4 >= 4.0.5', 'resource', 'resource link, resource result', ' Return first reference', 1042390524);
INSERT INTO php_manual VALUES (1190, 'ldap_free_result', 'PHP 3, PHP 4', 'bool', 'resource result_identifier', 'Free result memory', 1042390524);
INSERT INTO php_manual VALUES (1191, 'ldap_get_attributes', 'PHP 3, PHP 4', 'array', 'resource link_identifier, resource result_entry_identifier', 'Get attributes from a search result entry', 1042390524);
INSERT INTO php_manual VALUES (1192, 'ldap_get_dn', 'PHP 3, PHP 4', 'string', 'resource link_identifier, resource result_entry_identifier', 'Get the DN of a result entry', 1042390524);
INSERT INTO php_manual VALUES (1193, 'ldap_get_entries', 'PHP 3, PHP 4', 'array', 'resource link_identifier, resource result_identifier', 'Get all result entries', 1042390524);
INSERT INTO php_manual VALUES (1194, 'ldap_get_option', 'PHP 4 >= 4.0.4', 'bool', 'resource link_identifier, int option, mixed retval', 'Get the current value for given option', 1042390524);
INSERT INTO php_manual VALUES (1195, 'ldap_get_values_len', 'PHP 3>= 3.0.13, PHP 4', 'array', 'resource link_identifier, resource result_entry_identifier, string attribute', 'Get all binary values from a result entry', 1042390524);
INSERT INTO php_manual VALUES (1196, 'ldap_get_values', 'PHP 3, PHP 4', 'array', 'resource link_identifier, resource result_entry_identifier, string attribute', 'Get all values from a result entry', 1042390524);
INSERT INTO php_manual VALUES (1197, 'ldap_list', 'PHP 3, PHP 4', 'resource', 'resource link_identifier, string base_dn, string filter, [array attributes], [int attrsonly], [int sizelimit], [int timelimit], [int deref]', 'Single-level search', 1042390524);
INSERT INTO php_manual VALUES (1198, 'ldap_mod_add', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'resource link_identifier, string dn, array entry', 'Add attribute values to current attributes', 1042390524);
INSERT INTO php_manual VALUES (1199, 'ldap_mod_del', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'resource link_identifier, string dn, array entry', 'Delete attribute values from current attributes', 1042390524);
INSERT INTO php_manual VALUES (1200, 'ldap_mod_replace', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'resoure link_identifier, string dn, array entry', 'Replace attribute values with new ones', 1042390524);
INSERT INTO php_manual VALUES (1201, 'ldap_modify', 'PHP 3, PHP 4', 'bool', 'resource link_identifier, string dn, array entry', 'Modify an LDAP entry', 1042390524);
INSERT INTO php_manual VALUES (1202, 'ldap_next_attribute', 'PHP 3, PHP 4', 'string', 'resource link_identifier, resource result_entry_identifier, resource ber_identifier', 'Get the next attribute in result', 1042390524);
INSERT INTO php_manual VALUES (1203, 'ldap_next_entry', 'PHP 3, PHP 4', 'resource', 'resource link_identifier, resource result_entry_identifier', 'Get next result entry', 1042390524);
INSERT INTO php_manual VALUES (1204, 'ldap_next_reference', 'PHP 4 >= 4.0.5', 'resource', 'resource link, resource entry', ' Get next reference', 1042390524);
INSERT INTO php_manual VALUES (1205, 'ldap_parse_reference', 'PHP 4 >= 4.0.5', 'bool', 'resource link, resource entry, array referrals', ' Extract information from reference entry', 1042390524);
INSERT INTO php_manual VALUES (1206, 'ldap_parse_result', 'PHP 4 >= 4.0.5', 'bool', 'resource link, resource result, int errcode, string matcheddn, string errmsg, array referrals', ' Extract information from result', 1042390524);
INSERT INTO php_manual VALUES (1207, 'ldap_read', 'PHP 3, PHP 4', 'resource', 'resource link_identifier, string base_dn, string filter, [array attributes], [int attrsonly], [int sizelimit], [int timelimit], [int deref]', 'Read an entry', 1042390524);
INSERT INTO php_manual VALUES (1208, 'ldap_rename', 'PHP 4 >= 4.0.5', 'bool', 'resource link_identifier, string dn, string newrdn, string newparent, bool deleteoldrdn', 'Modify the name of an entry', 1042390524);
INSERT INTO php_manual VALUES (1209, 'ldap_search', 'PHP 3, PHP 4', 'resource', 'resource link_identifier, string base_dn, string filter, [array attributes], [int attrsonly], [int sizelimit], [int timelimit], [int deref]', 'Search LDAP tree', 1042390524);
INSERT INTO php_manual VALUES (1210, 'ldap_set_option', 'PHP 4 >= 4.0.4', 'bool', 'resource link_identifier, int option, mixed newval', 'Set the value of the given option', 1042390524);
INSERT INTO php_manual VALUES (1211, 'ldap_set_rebind_proc', 'PHP 4 >= 4.2.0', 'bool', 'resource link, string callback', ' Set a callback function to do re-binds on referral chasing.', 1042390524);
INSERT INTO php_manual VALUES (1212, 'ldap_sort', 'PHP 4 >= 4.2.0', 'bool', 'resource link, resource result, string sortfilter', ' Sort LDAP result entries', 1042390524);
INSERT INTO php_manual VALUES (1213, 'ldap_start_tls', 'PHP 4 >= 4.2.0', 'bool', 'resource link', ' Start TLS', 1042390524);
INSERT INTO php_manual VALUES (1214, 'ldap_t61_to_8859', 'PHP 4 >= 4.0.2', 'string', 'string value', ' Translate t61 characters to 8859 characters', 1042390524);
INSERT INTO php_manual VALUES (1215, 'ldap_unbind', 'PHP 3, PHP 4', 'bool', 'resource link_identifier', 'Unbind from LDAP directory', 1042390524);
INSERT INTO php_manual VALUES (1216, 'ezmlm_hash', 'PHP 3>= 3.0.17, PHP 4 >= 4.0.2', 'int', 'string addr', 'Calculate the hash value needed by EZMLM', 1042390524);
INSERT INTO php_manual VALUES (1217, 'mail', 'PHP 3, PHP 4', 'bool', 'string to, string subject, string message, [string additional_headers], [string additional_parameters]', 'send mail', 1042390524);
INSERT INTO php_manual VALUES (1218, 'mailparse_determine_best_xfer_encoding', '4.1.0 - 4.1.2 only', 'int', 'resource fp', ' Figures out the best way of encoding the content read from the file pointer fp, which must be seek-able', 1042390524);
INSERT INTO php_manual VALUES (1219, 'mailparse_msg_create', '4.1.0 - 4.1.2 only', 'int', 'void', 'Returns a handle that can be used to parse a message', 1042390524);
INSERT INTO php_manual VALUES (1220, 'mailparse_msg_extract_part_file', '4.1.0 - 4.1.2 only', 'string', 'resource rfc2045, string filename, [string callbackfunc]', 'Extracts/decodes a message section, decoding the transfer encoding', 1042390524);
INSERT INTO php_manual VALUES (1221, 'mailparse_msg_extract_part', '4.1.0 - 4.1.2 only', 'void', 'resource rfc2045, string msgbody, [string callbackfunc]', ' Extracts/decodes a message section. If callbackfunc is not specified, the contents will be sent to "stdout"', 1042390524);
INSERT INTO php_manual VALUES (1222, 'mailparse_msg_free', '4.1.0 - 4.1.2 only', 'void', 'resource rfc2045buf', 'Frees a handle allocated by mailparse_msg_crea', 1042390524);
INSERT INTO php_manual VALUES (1223, 'mailparse_msg_get_part_data', '4.1.0 - 4.1.2 only', 'array', 'resource rfc2045', 'Returns an associative array of info about the message', 1042390524);
INSERT INTO php_manual VALUES (1224, 'mailparse_msg_get_part', '4.1.0 - 4.1.2 only', 'int', 'resource rfc2045, string mimesection', 'Returns a handle on a given section in a mimemessage', 1042390524);
INSERT INTO php_manual VALUES (1225, 'mailparse_msg_get_structure', '4.1.0 - 4.1.2 only', 'array', 'resource rfc2045', 'Returns an array of mime section names in the supplied message', 1042390524);
INSERT INTO php_manual VALUES (1226, 'mailparse_msg_parse_file', '4.1.0 - 4.1.2 only', 'resource', 'string filename', 'Parse file and return a resource representing the structure', 1042390524);
INSERT INTO php_manual VALUES (1227, 'mailparse_msg_parse', '4.1.0 - 4.1.2 only', 'void', 'resource rfc2045buf, string data', 'Incrementally parse data into buffer', 1042390524);
INSERT INTO php_manual VALUES (1228, 'mailparse_rfc822_parse_addresses', '4.1.0 - 4.1.2 only', 'array', 'string addresses', ' Parse addresses and returns a hash containing that data', 1042390524);
INSERT INTO php_manual VALUES (1229, 'mailparse_stream_encode', '4.1.0 - 4.1.2 only', 'bool', 'resource sourcefp, resource destfp, string encoding', ' Streams data from source file pointer, apply encoding and write to destfp', 1042390524);
INSERT INTO php_manual VALUES (1230, 'mailparse_uudecode_all', '', 'array', 'resource fp', ' Scans the data from fp and extract each embedded uuencoded file. Returns an array listing filename information', 1042390524);
INSERT INTO php_manual VALUES (1231, 'abs', 'PHP 3, PHP 4', 'mixed', 'mixed number', 'Absolute value', 1042390524);
INSERT INTO php_manual VALUES (1232, 'acos', 'PHP 3, PHP 4', 'float', 'float arg', 'Arc cosine', 1042390524);
INSERT INTO php_manual VALUES (1233, 'acosh', 'PHP 4 >= 4.1.0', 'float', 'float arg', 'Inverse hyperbolic cosine', 1042390524);
INSERT INTO php_manual VALUES (1234, 'asin', 'PHP 3, PHP 4', 'float', 'float arg', 'Arc sine', 1042390524);
INSERT INTO php_manual VALUES (1235, 'asinh', 'PHP 4 >= 4.1.0', 'float', 'float arg', 'Inverse hyperbolic sine', 1042390524);
INSERT INTO php_manual VALUES (1236, 'atan', 'PHP 3, PHP 4', 'float', 'float arg', 'Arc tangent', 1042390524);
INSERT INTO php_manual VALUES (1237, 'atan2', 'PHP 3>= 3.0.5, PHP 4', 'float', 'float y, float x', 'arc tangent of two variables', 1042390524);
INSERT INTO php_manual VALUES (1238, 'atanh', 'PHP 4 >= 4.1.0', 'float', 'float arg', 'Inverse hyperbolic tangent', 1042390525);
INSERT INTO php_manual VALUES (1239, 'base_convert', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string number, int frombase, int tobase', 'Convert a number between arbitrary bases', 1042390525);
INSERT INTO php_manual VALUES (1240, 'bindec', 'PHP 3, PHP 4', 'int', 'string binary_string', 'Binary to decimal', 1042390525);
INSERT INTO php_manual VALUES (1241, 'ceil', 'PHP 3, PHP 4', 'float', 'float value', 'Round fractions up', 1042390525);
INSERT INTO php_manual VALUES (1242, 'cos', 'PHP 3, PHP 4', 'float', 'float arg', 'Cosine', 1042390525);
INSERT INTO php_manual VALUES (1243, 'cosh', 'PHP 4 >= 4.1.0', 'float', 'float arg', 'Hyperbolic cosine', 1042390525);
INSERT INTO php_manual VALUES (1244, 'decbin', 'PHP 3, PHP 4', 'string', 'int number', 'Decimal to binary', 1042390525);
INSERT INTO php_manual VALUES (1245, 'dechex', 'PHP 3, PHP 4', 'string', 'int number', 'Decimal to hexadecimal', 1042390525);
INSERT INTO php_manual VALUES (1246, 'decoct', 'PHP 3, PHP 4', 'string', 'int number', 'Decimal to octal', 1042390525);
INSERT INTO php_manual VALUES (1247, 'deg2rad', 'PHP 3>= 3.0.4, PHP 4', 'float', 'float number', ' Converts the number in degrees to the radian equivalent', 1042390525);
INSERT INTO php_manual VALUES (1248, 'exp', 'PHP 3, PHP 4', 'float', 'float arg', 'Calculates the exponent of e (the Neperian or Natural logarithm base)', 1042390525);
INSERT INTO php_manual VALUES (1249, 'expm1', 'PHP 4 >= 4.1.0', 'float', 'float number', ' Returns exp(number) - 1, computed in a way that is accurate even when the value of number is close to zero', 1042390525);
INSERT INTO php_manual VALUES (1250, 'floor', 'PHP 3, PHP 4', 'float', 'float value', 'Round fractions down', 1042390525);
INSERT INTO php_manual VALUES (1251, 'fmod', 'PHP 4 >= 4.2.0', 'float', 'float x, float y', 'Returns the floating point remainder (modulo) of the division of the arguments', 1042390525);
INSERT INTO php_manual VALUES (1252, 'getrandmax', 'PHP 3, PHP 4', 'int', 'void', 'Show largest possible random value', 1042390525);
INSERT INTO php_manual VALUES (1253, 'hexdec', 'PHP 3, PHP 4', 'int', 'string hex_string', 'Hexadecimal to decimal', 1042390525);
INSERT INTO php_manual VALUES (1254, 'hypot', 'PHP 4 >= 4.1.0', 'float', 'float num1, float num2', ' Returns sqrt( num1*num1 + num2*num2)', 1042390525);
INSERT INTO php_manual VALUES (1255, 'is_finite', 'PHP 4 >= 4.2.0', 'bool', 'float val', '', 1042390525);
INSERT INTO php_manual VALUES (1256, 'is_infinite', 'PHP 4 >= 4.2.0', 'bool', 'float val', '', 1042390525);
INSERT INTO php_manual VALUES (1257, 'is_nan', 'PHP 4 >= 4.2.0', 'bool', 'float val', '', 1042390525);
INSERT INTO php_manual VALUES (1258, 'lcg_value', 'PHP 4', 'float', 'void', 'Combined linear congruential generator', 1042390525);
INSERT INTO php_manual VALUES (1259, 'log', 'PHP 3, PHP 4', 'float', 'float arg, [float base]', 'Natural logarithm', 1042390525);
INSERT INTO php_manual VALUES (1260, 'log10', 'PHP 3, PHP 4', 'float', 'float arg', 'Base-10 logarithm', 1042390525);
INSERT INTO php_manual VALUES (1261, 'log1p', 'PHP 4 >= 4.1.0', 'float', 'float number', ' Returns log(1 + number), computed in a way that accurate even when the val ue of number is close to zero', 1042390525);
INSERT INTO php_manual VALUES (1262, 'max', 'PHP 3, PHP 4', 'mixed', 'mixed arg1, mixed arg2, mixed argn', 'Find highest value', 1042390525);
INSERT INTO php_manual VALUES (1263, 'min', 'PHP 3, PHP 4', 'number', 'number arg1, number arg2, [ ...], array numbers', 'Find lowest value', 1042390525);
INSERT INTO php_manual VALUES (1264, 'mt_getrandmax', 'PHP 3>= 3.0.6, PHP 4', 'int', 'void', 'Show largest possible random value', 1042390525);
INSERT INTO php_manual VALUES (1265, 'mt_rand', 'PHP 3>= 3.0.6, PHP 4', 'int', '[int min], int max', 'Generate a better random value', 1042390525);
INSERT INTO php_manual VALUES (1266, 'mt_srand', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int seed', 'Seed the better random number generator', 1042390525);
INSERT INTO php_manual VALUES (1267, 'octdec', 'PHP 3, PHP 4', 'int', 'string octal_string', 'Octal to decimal', 1042390525);
INSERT INTO php_manual VALUES (1268, 'pi', 'PHP 3, PHP 4', 'float', 'void', 'Get value of pi', 1042390525);
INSERT INTO php_manual VALUES (1269, 'pow', 'PHP 3, PHP 4', 'number', 'number base, number exp', 'Exponential expression', 1042390525);
INSERT INTO php_manual VALUES (1270, 'rad2deg', 'PHP 3>= 3.0.4, PHP 4', 'float', 'float number', ' Converts the radian number to the equivalent number in degrees', 1042390525);
INSERT INTO php_manual VALUES (1271, 'rand', 'PHP 3, PHP 4', 'int', '[int min], int max', 'Generate a random value', 1042390525);
INSERT INTO php_manual VALUES (1272, 'round', 'PHP 3, PHP 4', 'float', 'float val, [int precision]', 'Rounds a float', 1042390525);
INSERT INTO php_manual VALUES (1273, 'sin', 'PHP 3, PHP 4', 'float', 'float arg', 'Sine', 1042390525);
INSERT INTO php_manual VALUES (1274, 'sinh', 'PHP 4 >= 4.1.0', 'float', 'float arg', 'Hyperbolic sine', 1042390525);
INSERT INTO php_manual VALUES (1275, 'sqrt', 'PHP 3, PHP 4', 'float', 'float arg', 'Square root', 1042390525);
INSERT INTO php_manual VALUES (1276, 'srand', 'PHP 3, PHP 4', 'void', 'int seed', 'Seed the random number generator', 1042390525);
INSERT INTO php_manual VALUES (1277, 'tan', 'PHP 3, PHP 4', 'float', 'float arg', 'Tangent', 1042390525);
INSERT INTO php_manual VALUES (1278, 'tanh', 'PHP 4 >= 4.1.0', 'float', 'float arg', 'Hyperbolic tangent', 1042390525);
INSERT INTO php_manual VALUES (1279, 'mb_convert_case', 'PHP 4 >= 4.3.0', 'string', 'string str, int mode, [string encoding]', 'Perform case folding on a string', 1042390525);
INSERT INTO php_manual VALUES (1280, 'mb_convert_encoding', 'PHP 4 >= 4.0.6', 'string', 'string str, string to-encoding, [mixed from-encoding]', 'Convert character encoding', 1042390525);
INSERT INTO php_manual VALUES (1281, 'mb_convert_kana', 'PHP 4 >= 4.0.6', 'string', 'string str, string option, [mixed encoding]', ' Convert "kana" one from another ("zen-kaku" ,"han-kaku" and more)', 1042390525);
INSERT INTO php_manual VALUES (1282, 'mb_convert_variables', 'PHP 4 >= 4.0.6', 'string', 'string to-encoding, mixed from-encoding, mixed vars', 'Convert character code in variable(s)', 1042390525);
INSERT INTO php_manual VALUES (1283, 'mb_decode_mimeheader', 'PHP 4 >= 4.0.6', 'string', 'string str', 'Decode string in MIME header field', 1042390526);
INSERT INTO php_manual VALUES (1284, 'mb_decode_numericentity', 'PHP 4 >= 4.0.6', 'string', 'string str, array convmap, [string encoding]', ' Decode HTML numeric string reference to character', 1042390526);
INSERT INTO php_manual VALUES (1285, 'mb_detect_encoding', 'PHP 4 >= 4.0.6', 'string', 'string str, [mixed encoding-list]', 'Detect character encoding', 1042390526);
INSERT INTO php_manual VALUES (1286, 'mb_detect_order', 'PHP 4 >= 4.0.6', 'array', '[mixed encoding-list]', ' Set/Get character encoding detection order', 1042390526);
INSERT INTO php_manual VALUES (1287, 'mb_encode_mimeheader', 'PHP 4 >= 4.0.6', 'string', 'string str, [string charset], [string transfer-encoding], [string linefeed]', 'Encode string for MIME header', 1042390526);
INSERT INTO php_manual VALUES (1288, 'mb_encode_numericentity', 'PHP 4 >= 4.0.6', 'string', 'string str, array convmap, [string encoding]', ' Encode character to HTML numeric string reference', 1042390526);
INSERT INTO php_manual VALUES (1289, 'mb_ereg_match', '4.2.0 - 4.3.0 only', 'bool', 'string pattern, string string, [string option]', ' Regular expression match for multibyte string', 1042390526);
INSERT INTO php_manual VALUES (1290, 'mb_ereg_replace', '4.2.0 - 4.3.0 only', 'string', 'string pattern, string replacement, string string, [array option]', 'Replace regular expression with multibyte support', 1042390526);
INSERT INTO php_manual VALUES (1291, 'mb_ereg_search_getpos', '4.2.0 - 4.3.0 only', 'array', 'void', ' Returns start point for next regular expression match', 1042390526);
INSERT INTO php_manual VALUES (1292, 'mb_ereg_search_init', '4.2.0 - 4.3.0 only', 'array', 'string string, [string pattern], [string option]', ' Setup string and regular expression for multibyte regular expression match', 1042390526);
INSERT INTO php_manual VALUES (1293, 'mb_ereg_search_getregs', '4.2.0 - 4.3.0 only', 'array', 'void', ' Retrive the result from the last multibyte regular expression match', 1042390526);
INSERT INTO php_manual VALUES (1294, 'mb_ereg_search_pos', '4.2.0 - 4.3.0 only', 'array', '[string pattern], [string option]', ' Return position and length of matched part of multibyte regular expression for predefined multibyte string', 1042390526);
INSERT INTO php_manual VALUES (1295, 'mb_ereg_search_regs', '4.2.0 - 4.3.0 only', 'array', '[string pattern], [string option]', ' Returns the matched part of multibyte regular expression', 1042390526);
INSERT INTO php_manual VALUES (1296, 'mb_ereg_search_setpos', '4.2.0 - 4.3.0 only', 'array', 'void', ' Set start point of next regular expression match', 1042390526);
INSERT INTO php_manual VALUES (1297, 'mb_ereg_search', '4.2.0 - 4.3.0 only', 'bool', '[string pattern], [string option]', ' Multibyte regular expression match for predefined multibyte string', 1042390526);
INSERT INTO php_manual VALUES (1298, 'mb_ereg', '4.2.0 - 4.3.0 only', 'int', 'string pattern, string string, [array regs]', 'Regular expression match with multibyte support', 1042390526);
INSERT INTO php_manual VALUES (1299, 'mb_eregi_replace', '4.2.0 - 4.3.0 only', 'string', 'string pattern, string replace, string string', ' Replace regular expression with multibyte support ignoring case', 1042390526);
INSERT INTO php_manual VALUES (1300, 'mb_eregi', '4.2.0 - 4.3.0 only', 'int', 'string pattern, string string, [array regs]', ' Regular expression match ignoring case with multibyte support', 1042390526);
INSERT INTO php_manual VALUES (1301, 'mb_get_info', 'PHP 4 >= 4.2.0', 'string', '[string type]', 'Get internal settings of mbstring', 1042390526);
INSERT INTO php_manual VALUES (1302, 'mb_http_input', 'PHP 4 >= 4.0.6', 'string', '[string type]', 'Detect HTTP input character encoding', 1042390526);
INSERT INTO php_manual VALUES (1303, 'mb_http_output', 'PHP 4 >= 4.0.6', 'string', '[string encoding]', 'Set/Get HTTP output character encoding', 1042390526);
INSERT INTO php_manual VALUES (1304, 'mb_internal_encoding', 'PHP 4 >= 4.0.6', 'string', '[string encoding]', ' Set/Get internal character encoding', 1042390526);
INSERT INTO php_manual VALUES (1305, 'mb_language', 'PHP 4 >= 4.0.6', 'string', '[string language]', ' Set/Get current language', 1042390526);
INSERT INTO php_manual VALUES (1306, 'mb_output_handler', 'PHP 4 >= 4.0.6', 'string', 'string contents, int status', ' Callback function converts character encoding in output buffer', 1042390526);
INSERT INTO php_manual VALUES (1307, 'mb_parse_str', 'PHP 4 >= 4.0.6', 'boolean', 'string encoded_string, [array result]', ' Parse GET/POST/COOKIE data and set global variable', 1042390526);
INSERT INTO php_manual VALUES (1308, 'mb_preferred_mime_name', 'PHP 4 >= 4.0.6', 'string', 'string encoding', 'Get MIME charset string', 1042390526);
INSERT INTO php_manual VALUES (1309, 'mb_regex_encoding', '4.2.0 - 4.3.0 only', 'string', '[string encoding]', ' Returns current encoding for multibyte regex as string', 1042390526);
INSERT INTO php_manual VALUES (1310, 'mb_regex_set_options', 'PHP 4 4.3.0 only', 'string', '[string options]', ' Set/Get the default options for mbregex functions', 1042390526);
INSERT INTO php_manual VALUES (1311, 'mb_send_mail', 'PHP 4 >= 4.0.6', 'boolean', 'string to, string subject, string message, [string additional_headers], [string additional_parameter]', ' Send encoded mail.', 1042390526);
INSERT INTO php_manual VALUES (1312, 'mb_split', '4.2.0 - 4.3.0 only', 'array', 'string pattern, string string, [int limit]', 'Split multibyte string using regular expression', 1042390526);
INSERT INTO php_manual VALUES (1313, 'mb_strcut', 'PHP 4 >= 4.0.6', 'string', 'string str, int start, [int length], [string encoding]', 'Get part of string', 1042390526);
INSERT INTO php_manual VALUES (1314, 'mb_strimwidth', 'PHP 4 >= 4.0.6', 'string', 'string str, int start, int width, string trimmarker, [string encoding]', 'Get truncated string with specified width', 1042390526);
INSERT INTO php_manual VALUES (1315, 'mb_strlen', 'PHP 4 >= 4.0.6', 'string', 'string str, [string encoding]', 'Get string length', 1042390526);
INSERT INTO php_manual VALUES (1316, 'mb_strpos', 'PHP 4 >= 4.0.6', 'int', 'string haystack, string needle, [int offset], [string encoding]', ' Find position of first occurrence of string in a string', 1042390526);
INSERT INTO php_manual VALUES (1317, 'mb_strrpos', 'PHP 4 >= 4.0.6', 'int', 'string haystack, string needle, [string encoding]', ' Find position of last occurrence of a string in a string', 1042390526);
INSERT INTO php_manual VALUES (1318, 'mb_strtolower', 'PHP 4 >= 4.3.0', 'string', 'string str, [string encoding]', 'Make a string lowercase', 1042390526);
INSERT INTO php_manual VALUES (1319, 'mb_strtoupper', 'PHP 4 >= 4.3.0', 'string', 'string str, [string encoding]', 'Make a string uppercase', 1042390526);
INSERT INTO php_manual VALUES (1320, 'mb_strwidth', 'PHP 4 >= 4.0.6', 'int', 'string str, [string encoding]', 'Return width of string', 1042390526);
INSERT INTO php_manual VALUES (1321, 'mb_substitute_character', 'PHP 4 >= 4.0.6', 'mixed', '[mixed substrchar]', 'Set/Get substitution character', 1042390526);
INSERT INTO php_manual VALUES (1322, 'mb_substr_count', 'PHP 4 >= 4.3.0', 'int', 'string haystack, string needle, [string encoding]', 'Count the number of substring occurrences', 1042390526);
INSERT INTO php_manual VALUES (1323, 'mb_substr', 'PHP 4 >= 4.0.6', 'string', 'string str, int start, [int length], [string encoding]', 'Get part of string', 1042390527);
INSERT INTO php_manual VALUES (1324, 'mcal_append_event', 'PHP 4', 'int', 'int mcal_stream', 'Store a new event into an MCAL calendar', 1042390527);
INSERT INTO php_manual VALUES (1325, 'mcal_close', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int mcal_stream, int flags', 'Close an MCAL stream', 1042390527);
INSERT INTO php_manual VALUES (1326, 'mcal_create_calendar', 'PHP 3>= 3.0.13, PHP 4', 'string', 'int stream, string calendar', 'Create a new MCAL calendar', 1042390527);
INSERT INTO php_manual VALUES (1327, 'mcal_date_compare', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int a_year, int a_month, int a_day, int b_year, int b_month, int b_day', 'Compares two dates', 1042390527);
INSERT INTO php_manual VALUES (1328, 'mcal_date_valid', 'PHP 3>= 3.0.13, PHP 4', '', 'void', '', 1042390527);
INSERT INTO php_manual VALUES (1329, 'mcal_day_of_week', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int year, int month, int day', ' Returns the day of the week of the given date', 1042390527);
INSERT INTO php_manual VALUES (1330, 'mcal_day_of_year', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int year, int month, int day', ' Returns the day of the year of the given date', 1042390527);
INSERT INTO php_manual VALUES (1331, 'mcal_days_in_month', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int month, int leap year', ' Returns the number of days in the given month', 1042390527);
INSERT INTO php_manual VALUES (1332, 'mcal_delete_calendar', 'PHP 3>= 3.0.13, PHP 4', 'string', 'int stream, string calendar', 'Delete an MCAL calendar', 1042390527);
INSERT INTO php_manual VALUES (1333, 'mcal_delete_event', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int mcal_stream, [int event_id]', 'Delete an event from an MCAL calendar', 1042390527);
INSERT INTO php_manual VALUES (1334, 'mcal_event_add_attribute', 'PHP 3>= 3.0.15, PHP 4', 'void', 'int stream, string attribute, string value', ' Adds an attribute and a value to the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1335, 'mcal_event_init', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream', ' Initializes a streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1336, 'mcal_event_set_alarm', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int alarm', ' Sets the alarm of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1337, 'mcal_event_set_end', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, [int day ], [int hour ], [int min ], [int sec ]', ' Sets the end date and time of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1338, 'mcal_event_set_category', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, string category', ' Sets the category of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1339, 'mcal_event_set_class', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int class', ' Sets the class of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1340, 'mcal_event_set_description', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, string description', ' Sets the description of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1341, 'mcal_event_set_recur_daily', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, int day, int interval', ' Sets the recurrence of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1342, 'mcal_event_set_recur_monthly_mday', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, int day, int interval', ' Sets the recurrence of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1343, 'mcal_event_set_recur_monthly_wday', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, int day, int interval', ' Sets the recurrence of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1344, 'mcal_event_set_recur_none', 'PHP 3>= 3.0.15, PHP 4', 'int', 'int stream', ' Sets the recurrence of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1345, 'mcal_event_set_recur_weekly', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, int day, int interval, int weekdays', ' Sets the recurrence of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1346, 'mcal_event_set_recur_yearly', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, int day, int interval', ' Sets the recurrence of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1347, 'mcal_event_set_start', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int year, int month, [int day ], [int hour ], [int min], [int sec ]', ' Sets the start date and time of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1348, 'mcal_event_set_title', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, string title', ' Sets the title of the streams global event structure', 1042390527);
INSERT INTO php_manual VALUES (1349, 'mcal_expunge', '', 'int', 'int stream', ' Deletes all events marked for being expunged.', 1042390527);
INSERT INTO php_manual VALUES (1350, 'mcal_fetch_current_stream_event', 'PHP 3>= 3.0.13, PHP 4', 'object', 'int stream', ' Returns an object containing the current streams event structure', 1042390527);
INSERT INTO php_manual VALUES (1351, 'mcal_fetch_event', 'PHP 3>= 3.0.13, PHP 4', 'object', 'int mcal_stream, int event_id, [int options]', ' Fetches an event from the calendar stream', 1042390527);
INSERT INTO php_manual VALUES (1352, 'mcal_is_leap_year', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int year', ' Returns if the given year is a leap year or not', 1042390527);
INSERT INTO php_manual VALUES (1353, 'mcal_list_alarms', 'PHP 3>= 3.0.13, PHP 4', 'array', 'int mcal_stream, [int begin_year], [int begin_month], [int begin_day], [int end_year], [int end_month], [int end_day]', ' Return a list of events that has an alarm triggered at the given datetime', 1042390527);
INSERT INTO php_manual VALUES (1354, 'mcal_list_events', 'PHP 3>= 3.0.13, PHP 4', 'array', 'int mcal_stream, object begin_date, [object end_date]', ' Return a list of IDs for a date or a range of dates.', 1042390527);
INSERT INTO php_manual VALUES (1355, 'mcal_next_recurrence', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int stream, int weekstart, array next', 'Returns the next recurrence of the event', 1042390527);
INSERT INTO php_manual VALUES (1356, 'mcal_open', 'PHP 3>= 3.0.13, PHP 4', 'int', 'string calendar, string username, string password, [int options]', 'Opens up an MCAL connection', 1042390527);
INSERT INTO php_manual VALUES (1357, 'mcal_popen', 'PHP 3>= 3.0.13, PHP 4', 'int', 'string calendar, string username, string password, [int options]', 'Opens up a persistent MCAL connection', 1042390527);
INSERT INTO php_manual VALUES (1358, 'mcal_rename_calendar', 'PHP 3>= 3.0.13, PHP 4', 'string', 'int stream, string old_name, string new_name', 'Rename an MCAL calendar', 1042390527);
INSERT INTO php_manual VALUES (1359, 'mcal_reopen', 'PHP 3>= 3.0.13, PHP 4', 'int', 'string calendar, [int options]', 'Reopens an MCAL connection', 1042390527);
INSERT INTO php_manual VALUES (1360, 'mcal_snooze', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int id', 'Turn off an alarm for an event', 1042390527);
INSERT INTO php_manual VALUES (1361, 'mcal_store_event', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int mcal_stream', 'Modify an existing event in an MCAL calendar', 1042390527);
INSERT INTO php_manual VALUES (1362, 'mcal_time_valid', 'PHP 3>= 3.0.13, PHP 4', '', 'void', '', 1042390527);
INSERT INTO php_manual VALUES (1363, 'mcal_week_of_year', 'PHP 4', 'int', 'int day, int month, int year', ' Returns the week number of the given date', 1042390527);
INSERT INTO php_manual VALUES (1364, 'mcrypt_cbc', 'PHP 3>= 3.0.8, PHP 4', 'string', 'int cipher, string key, string data, int mode, [string iv], string cipher, string key, string data, int mode, [string iv]', 'Encrypt/decrypt data in CBC mode', 1042390527);
INSERT INTO php_manual VALUES (1365, 'mcrypt_cfb', 'PHP 3>= 3.0.8, PHP 4', 'string', 'int cipher, string key, string data, int mode, string iv, string cipher, string key, string data, int mode, [string iv]', 'Encrypt/decrypt data in CFB mode', 1042390527);
INSERT INTO php_manual VALUES (1366, 'mcrypt_create_iv', 'PHP 3>= 3.0.8, PHP 4', 'string', 'int size, int source', ' Create an initialization vector (IV) from a random source', 1042390527);
INSERT INTO php_manual VALUES (1367, 'mcrypt_decrypt', 'PHP 4 >= 4.0.2', 'string', 'string cipher, string key, string data, string mode, [string iv]', 'Decrypts crypttext with given parameters', 1042390527);
INSERT INTO php_manual VALUES (1368, 'mcrypt_ecb', 'PHP 3>= 3.0.8, PHP 4', 'string', 'int cipher, string key, string data, int mode, string cipher, string key, string data, int mode, [string iv]', 'Encrypt/decrypt data in ECB mode', 1042390528);
INSERT INTO php_manual VALUES (1369, 'mcrypt_enc_get_algorithms_name', 'PHP 4 >= 4.0.2', 'string', 'resource td', 'Returns the name of the opened algorithm', 1042390528);
INSERT INTO php_manual VALUES (1370, 'mcrypt_enc_get_block_size', 'PHP 4 >= 4.0.2', 'int', 'resource td', 'Returns the blocksize of the opened algorithm', 1042390528);
INSERT INTO php_manual VALUES (1371, 'mcrypt_enc_get_iv_size', 'PHP 4 >= 4.0.2', 'int', 'resource td', 'Returns the size of the IV of the opened algorithm', 1042390528);
INSERT INTO php_manual VALUES (1372, 'mcrypt_enc_get_key_size', 'PHP 4 >= 4.0.2', 'int', 'resource td', 'Returns the maximum supported keysize of the opened mode', 1042390528);
INSERT INTO php_manual VALUES (1373, 'mcrypt_enc_get_modes_name', 'PHP 4 >= 4.0.2', 'string', 'resource td', 'Returns the name of the opened mode', 1042390528);
INSERT INTO php_manual VALUES (1374, 'mcrypt_enc_get_supported_key_sizes', 'PHP 4 >= 4.0.2', 'array', 'resource td', 'Returns an array with the supported keysizes of the opened algorithm', 1042390528);
INSERT INTO php_manual VALUES (1375, 'mcrypt_enc_is_block_algorithm_mode', 'PHP 4 >= 4.0.2', 'bool', 'resource td', 'Checks whether the encryption of the opened mode works on blocks', 1042390528);
INSERT INTO php_manual VALUES (1376, 'mcrypt_encrypt', 'PHP 4 >= 4.0.2', 'string', 'string cipher, string key, string data, string mode, [string iv]', 'Encrypts plaintext with given parameters', 1042390528);
INSERT INTO php_manual VALUES (1377, 'mcrypt_enc_is_block_algorithm', 'PHP 4 >= 4.0.2', 'bool', 'resource td', 'Checks whether the algorithm of the opened mode is a block algorithm', 1042390528);
INSERT INTO php_manual VALUES (1378, 'mcrypt_enc_is_block_mode', 'PHP 4 >= 4.0.2', 'bool', 'resource td', 'Checks whether the opened mode outputs blocks', 1042390528);
INSERT INTO php_manual VALUES (1379, 'mcrypt_enc_self_test', 'PHP 4 >= 4.0.2', 'bool', 'resource td', 'This function runs a self test on the opened module', 1042390528);
INSERT INTO php_manual VALUES (1380, 'mcrypt_generic_deinit', 'PHP 4 >= 4.1.1', 'bool', 'resource td', ' This function deinitializes an encryption module', 1042390528);
INSERT INTO php_manual VALUES (1381, 'mcrypt_generic_end', 'PHP 4 >= 4.0.2', 'bool', 'resource td', 'This function terminates encryption', 1042390528);
INSERT INTO php_manual VALUES (1382, 'mcrypt_generic_init', 'PHP 4 >= 4.0.2', 'int', 'resource td, string key, string iv', 'This function initializes all buffers needed for encryption', 1042390528);
INSERT INTO php_manual VALUES (1383, 'mcrypt_generic', 'PHP 4 >= 4.0.2', 'string', 'resource td, string data', 'This function encrypts data', 1042390528);
INSERT INTO php_manual VALUES (1384, 'mcrypt_get_block_size', 'PHP 3>= 3.0.8, PHP 4', 'int', 'int cipher, string cipher, string module', 'Get the block size of the specified cipher', 1042390528);
INSERT INTO php_manual VALUES (1385, 'mcrypt_get_cipher_name', 'PHP 3>= 3.0.8, PHP 4', 'string', 'int cipher, string cipher', 'Get the name of the specified cipher', 1042390528);
INSERT INTO php_manual VALUES (1386, 'mcrypt_get_iv_size', 'PHP 4 >= 4.0.2', 'int', 'resource td, string cipher, string mode', 'Returns the size of the IV belonging to a specific cipher/mode combination', 1042390528);
INSERT INTO php_manual VALUES (1387, 'mcrypt_get_key_size', 'PHP 3>= 3.0.8, PHP 4', 'int', 'int cipher, string cipher, string module', 'Get the key size of the specified cipher', 1042390528);
INSERT INTO php_manual VALUES (1388, 'mcrypt_list_algorithms', 'PHP 4 >= 4.0.2', 'array', '[string lib_dir]', 'Get an array of all supported ciphers', 1042390528);
INSERT INTO php_manual VALUES (1389, 'mcrypt_list_modes', 'PHP 4 >= 4.0.2', 'array', '[string lib_dir]', 'Get an array of all supported modes', 1042390528);
INSERT INTO php_manual VALUES (1390, 'mcrypt_module_close', 'PHP 4 >= 4.0.2', 'bool', 'resource td', ' Close the mcrypt module', 1042390528);
INSERT INTO php_manual VALUES (1391, 'mcrypt_ofb', 'PHP 3>= 3.0.8, PHP 4', 'string', 'int cipher, string key, string data, int mode, string iv, string cipher, string key, string data, int mode, [string iv]', 'Encrypt/decrypt data in OFB mode', 1042390528);
INSERT INTO php_manual VALUES (1392, 'mcrypt_module_get_algo_block_size', 'PHP 4 >= 4.0.2', 'int', 'string algorithm, [string lib_dir]', 'Returns the blocksize of the specified algorithm', 1042390528);
INSERT INTO php_manual VALUES (1393, 'mcrypt_module_get_algo_key_size', 'PHP 4 >= 4.0.2', 'int', 'string algorithm, [string lib_dir]', 'Returns the maximum supported keysize of the opened mode', 1042390528);
INSERT INTO php_manual VALUES (1394, 'mcrypt_module_get_supported_key_sizes', 'PHP 4 >= 4.0.2', 'array', 'string algorithm, [string lib_dir]', 'Returns an array with the supported keysizes of the opened algorithm', 1042390528);
INSERT INTO php_manual VALUES (1395, 'mcrypt_module_is_block_algorithm_mode', 'PHP 4 >= 4.0.2', 'bool', 'string mode, [string lib_dir]', 'This function returns if the the specified module is a block algorithm or not', 1042390528);
INSERT INTO php_manual VALUES (1396, 'mcrypt_module_is_block_algorithm', 'PHP 4 >= 4.0.2', 'bool', 'string algorithm, [string lib_dir]', 'This function checks whether the specified algorithm is a block algorithm', 1042390528);
INSERT INTO php_manual VALUES (1397, 'mcrypt_module_is_block_mode', 'PHP 4 >= 4.0.2', 'bool', 'string mode, [string lib_dir]', 'This function returns if the the specified mode outputs blocks or not', 1042390528);
INSERT INTO php_manual VALUES (1398, 'mcrypt_module_open', 'PHP 4 >= 4.0.2', 'resource', 'string algorithm, string algorithm_directory, string mode, string mode_directory', 'This function opens the module of the algorithm and the mode to be used', 1042390528);
INSERT INTO php_manual VALUES (1399, 'mcrypt_module_self_test', 'PHP 4 >= 4.0.2', 'bool', 'string algorithm, [string lib_dir]', 'This function runs a self test on the specified module', 1042390528);
INSERT INTO php_manual VALUES (1400, 'mdecrypt_generic', 'PHP 4 >= 4.0.2', 'string', 'resource td, string data', 'This function decrypts data', 1042390528);
INSERT INTO php_manual VALUES (1401, 'mcve_adduser', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password, int usersetup', ' Add an MCVE user using usersetup structure', 1042390528);
INSERT INTO php_manual VALUES (1402, 'mcve_adduserarg', 'PHP 4 >= 4.2.0', 'int', 'resource usersetup, int argtype, string argval', ' Add a value to user configuration structure', 1042390528);
INSERT INTO php_manual VALUES (1403, 'mcve_bt', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password', ' Get unsettled batch totals', 1042390528);
INSERT INTO php_manual VALUES (1404, 'mcve_checkstatus', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Check to see if a transaction has completed', 1042390528);
INSERT INTO php_manual VALUES (1405, 'mcve_chkpwd', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password', ' Verify Password', 1042390528);
INSERT INTO php_manual VALUES (1406, 'mcve_completeauthorizations', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int &array', ' Number of complete authorizations in queue, returning an array of their identifiers', 1042390528);
INSERT INTO php_manual VALUES (1407, 'mcve_connect', 'PHP 4 >= 4.2.0', 'int', 'resource conn', ' Establish the connection to MCVE', 1042390528);
INSERT INTO php_manual VALUES (1408, 'mcve_connectionerror', 'PHP 4 >= 4.3.0', 'string', 'resource conn', ' Get a textual representation of why a connection failed', 1042390528);
INSERT INTO php_manual VALUES (1409, 'mcve_deleteresponse', 'PHP 4 >= 4.2.0', 'bool', 'resource conn, int identifier', ' Delete specified transaction from MCVE_CONN structure', 1042390528);
INSERT INTO php_manual VALUES (1410, 'mcve_deletetrans', 'PHP 4 >= 4.3.0', 'bool', 'resource conn, int identifier', ' Delete specified transaction from MCVE_CONN structure', 1042390528);
INSERT INTO php_manual VALUES (1411, 'mcve_deleteusersetup', 'PHP 4 >= 4.2.0', 'void', 'resource usersetup', ' Deallocate data associated with usersetup structure', 1042390528);
INSERT INTO php_manual VALUES (1412, 'mcve_deluser', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password, string username', ' Delete an MCVE user account', 1042390528);
INSERT INTO php_manual VALUES (1413, 'mcve_destroyconn', 'PHP 4 >= 4.2.0', 'void', 'resource conn', ' Destroy the connection and MCVE_CONN structure', 1042390528);
INSERT INTO php_manual VALUES (1414, 'mcve_edituser', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password, int usersetup', ' Edit MCVE user using usersetup structure', 1042390528);
INSERT INTO php_manual VALUES (1415, 'mcve_destroyengine', 'PHP 4 >= 4.2.0', 'void', 'void', ' Free memory associated with IP/SSL connectivity', 1042390528);
INSERT INTO php_manual VALUES (1416, 'mcve_disableuser', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password, string username', ' Disable an active MCVE user account', 1042390528);
INSERT INTO php_manual VALUES (1417, 'mcve_enableuser', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password, string username', ' Enable an inactive MCVE user account', 1042390529);
INSERT INTO php_manual VALUES (1418, 'mcve_force', 'PHP 4 >= 4.2.0', 'int', 'resiurce conn, string username, string password, string trackdata, string account, string expdate, float amount, string authcode, string comments, string clerkid, string stationid, int ptrannum', ' Send a FORCE to MCVE. (typically, a phone-authorization)', 1042390529);
INSERT INTO php_manual VALUES (1419, 'mcve_getcell', 'PHP 4 >= 4.2.0', 'string', 'resource conn, int identifier, string column, int row', ' Get a specific cell from a comma delimited response by column name', 1042390529);
INSERT INTO php_manual VALUES (1420, 'mcve_getcellbynum', 'PHP 4 >= 4.2.0', 'string', 'resource conn, int identifier, int column, int row', ' Get a specific cell from a comma delimited response by column number', 1042390529);
INSERT INTO php_manual VALUES (1421, 'mcve_getcommadelimited', 'PHP 4 >= 4.2.0', 'string', 'resource conn, int identifier', ' Get the RAW comma delimited data returned from MCVE', 1042390529);
INSERT INTO php_manual VALUES (1422, 'mcve_getheader', 'PHP 4 >= 4.2.0', 'string', 'resource conn, int identifier, int column_num', ' Get the name of the column in a comma-delimited response', 1042390529);
INSERT INTO php_manual VALUES (1423, 'mcve_getuserarg', 'PHP 4 >= 4.2.0', 'string', 'resource usersetup, int argtype', ' Grab a value from usersetup structure', 1042390529);
INSERT INTO php_manual VALUES (1424, 'mcve_getuserparam', 'PHP 4 >= 4.3.0', 'string', 'resource conn, long identifier, int key', ' Get a user response parameter', 1042390529);
INSERT INTO php_manual VALUES (1425, 'mcve_gft', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, int type, string account, string clerkid, string stationid, string comments, int ptrannum, string startdate, string enddate', ' Audit MCVE for Failed transactions', 1042390529);
INSERT INTO php_manual VALUES (1426, 'mcve_gl', 'PHP 4 >= 4.2.0', 'int', 'int conn, string username, string password, int type, string account, string batch, string clerkid, string stationid, string comments, int ptrannum, string startdate, string enddate', ' Audit MCVE for settled transactions', 1042390529);
INSERT INTO php_manual VALUES (1427, 'mcve_gut', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, int type, string account, string clerkid, string stationid, string comments, int ptrannum, string startdate, string enddate', ' Audit MCVE for Unsettled Transactions', 1042390529);
INSERT INTO php_manual VALUES (1428, 'mcve_initconn', 'PHP 4 >= 4.2.0', 'resource', 'void', ' Create and initialize an MCVE_CONN structure', 1042390529);
INSERT INTO php_manual VALUES (1429, 'mcve_initengine', 'PHP 4 >= 4.2.0', 'int', 'string location', ' Ready the client for IP/SSL Communication', 1042390529);
INSERT INTO php_manual VALUES (1430, 'mcve_initusersetup', 'PHP 4 >= 4.2.0', 'resource', 'void', ' Initialize structure to store user data', 1042390529);
INSERT INTO php_manual VALUES (1431, 'mcve_iscommadelimited', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Checks to see if response is comma delimited', 1042390529);
INSERT INTO php_manual VALUES (1432, 'mcve_qc', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, string clerkid, string stationid, string comments, int ptrannum', ' Audit MCVE for a list of transactions in the outgoing queue', 1042390529);
INSERT INTO php_manual VALUES (1433, 'mcve_liststats', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password', ' List statistics for all users on MCVE system', 1042390529);
INSERT INTO php_manual VALUES (1434, 'mcve_listusers', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string admin_password', ' List all users on MCVE system', 1042390529);
INSERT INTO php_manual VALUES (1435, 'mcve_maxconntimeout', 'PHP 4 >= 4.3.0', 'bool', 'resource conn, int secs', ' The maximum amount of time the API will attempt a connection to MCVE', 1042390529);
INSERT INTO php_manual VALUES (1436, 'mcve_monitor', 'PHP 4 >= 4.2.0', 'int', 'resource conn', ' Perform communication with MCVE (send/receive data) Non-blocking', 1042390529);
INSERT INTO php_manual VALUES (1437, 'mcve_numcolumns', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Number of columns returned in a comma delimited response', 1042390529);
INSERT INTO php_manual VALUES (1438, 'mcve_numrows', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Number of rows returned in a comma delimited response', 1042390529);
INSERT INTO php_manual VALUES (1439, 'mcve_override', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string street, string zip, string cv, string comments, string clerkid, string stationid, int ptrannum', ' Send an OVERRIDE to MCVE', 1042390529);
INSERT INTO php_manual VALUES (1440, 'mcve_parsecommadelimited', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Parse the comma delimited response so mcve_getcell, etc will work', 1042390529);
INSERT INTO php_manual VALUES (1441, 'mcve_ping', 'PHP 4 >= 4.3.0', 'int', 'resource conn', ' Send a ping request to MCVE', 1042390529);
INSERT INTO php_manual VALUES (1442, 'mcve_preauth', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string street, string zip, string cv, string comments, string clerkid, string stationid, int ptrannum', ' Send a PREAUTHORIZATION to MCVE', 1042390529);
INSERT INTO php_manual VALUES (1443, 'mcve_preauthcompletion', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, float finalamount, int sid, int ptrannum', ' Complete a PREAUTHORIZATION... Ready it for settlement', 1042390529);
INSERT INTO php_manual VALUES (1444, 'mcve_responseparam', 'PHP 4 >= 4.3.0', 'string', 'resource conn, long identifier, string key', ' Get a custom response parameter', 1042390529);
INSERT INTO php_manual VALUES (1445, 'mcve_return', 'PHP 4 >= 4.2.0', 'int', 'int conn, string username, string password, string trackdata, string account, string expdate, float amount, string comments, string clerkid, string stationid, int ptrannum', ' Issue a RETURN or CREDIT to MCVE', 1042390529);
INSERT INTO php_manual VALUES (1446, 'mcve_returncode', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Grab the exact return code from the transaction', 1042390529);
INSERT INTO php_manual VALUES (1447, 'mcve_returnstatus', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Check to see if the transaction was successful', 1042390529);
INSERT INTO php_manual VALUES (1448, 'mcve_sale', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, string trackdata, string account, string expdate, float amount, string street, string zip, string cv, string comments, string clerkid, string stationid, int ptrannum', ' Send a SALE to MCVE', 1042390529);
INSERT INTO php_manual VALUES (1449, 'mcve_setblocking', 'PHP 4 >= 4.3.0', 'int', 'resource conn, int tf', ' Set blocking/non-blocking mode for connection', 1042390529);
INSERT INTO php_manual VALUES (1450, 'mcve_setdropfile', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string directory', ' Set the connection method to Drop-File', 1042390529);
INSERT INTO php_manual VALUES (1451, 'mcve_setip', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string host, int port', ' Set the connection method to IP', 1042390529);
INSERT INTO php_manual VALUES (1452, 'mcve_setssl', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string host, int port', ' Set the connection method to SSL', 1042390529);
INSERT INTO php_manual VALUES (1453, 'mcve_settimeout', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int seconds', ' Set maximum transaction time (per trans)', 1042390529);
INSERT INTO php_manual VALUES (1454, 'mcve_settle', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, string batch', ' Issue a settlement command to do a batch deposit', 1042390529);
INSERT INTO php_manual VALUES (1455, 'mcve_text_avs', 'PHP 4 >= 4.3.0', 'string', 'string code', ' Get a textual representation of the return_avs', 1042390529);
INSERT INTO php_manual VALUES (1456, 'mcve_text_code', 'PHP 4 >= 4.3.0', 'string', 'string code', ' Get a textual representation of the return_code', 1042390529);
INSERT INTO php_manual VALUES (1457, 'mcve_text_cv', 'PHP 4 >= 4.3.0', 'string', 'int code', ' Get a textual representation of the return_cv', 1042390529);
INSERT INTO php_manual VALUES (1458, 'mcve_transactionauth', 'PHP 4 >= 4.2.0', 'string', 'resource conn, int identifier', ' Get the authorization number returned for the transaction (alpha-numeric)', 1042390529);
INSERT INTO php_manual VALUES (1459, 'mcve_transactionavs', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Get the Address Verification return status', 1042390529);
INSERT INTO php_manual VALUES (1460, 'mcve_transactionbatch', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Get the batch number associated with the transaction', 1042390529);
INSERT INTO php_manual VALUES (1461, 'mcve_transactioncv', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Get the CVC2/CVV2/CID return status', 1042390529);
INSERT INTO php_manual VALUES (1462, 'mcve_transactionid', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Get the unique system id for the transaction', 1042390529);
INSERT INTO php_manual VALUES (1463, 'mcve_transactionitem', 'PHP 4 >= 4.2.0', 'int', 'resource conn, int identifier', ' Get the ITEM number in the associated batch for this transaction', 1042390529);
INSERT INTO php_manual VALUES (1464, 'mcve_transactionssent', 'PHP 4 >= 4.2.0', 'int', 'resource conn', ' Check to see if outgoing buffer is clear', 1042390529);
INSERT INTO php_manual VALUES (1465, 'mcve_transactiontext', 'PHP 4 >= 4.2.0', 'string', 'resource conn, int identifier', ' Get verbiage (text) return from MCVE or processing institution', 1042390530);
INSERT INTO php_manual VALUES (1466, 'mcve_ub', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password', ' Get a list of all Unsettled batches', 1042390530);
INSERT INTO php_manual VALUES (1467, 'mcve_transinqueue', 'PHP 4 >= 4.2.0', 'int', 'resource conn', ' Number of transactions in client-queue', 1042390530);
INSERT INTO php_manual VALUES (1468, 'mcve_transnew', 'PHP 4 >= 4.3.0', 'int', 'resource conn', ' Start a new transaction', 1042390530);
INSERT INTO php_manual VALUES (1469, 'mcve_transparam', 'PHP 4 >= 4.3.0', 'int', 'resource conn, long identifier, int key', ' Add a parameter to a transaction', 1042390530);
INSERT INTO php_manual VALUES (1470, 'mcve_transsend', 'PHP 4 >= 4.3.0', 'int', 'resource conn, long identifier', ' Finalize and send the transaction', 1042390530);
INSERT INTO php_manual VALUES (1471, 'mcve_uwait', 'PHP 4 >= 4.3.0', 'int', 'long microsecs', ' Wait x microsecs', 1042390530);
INSERT INTO php_manual VALUES (1472, 'mcve_verifyconnection', 'PHP 4 >= 4.3.0', 'bool', 'resource conn, int tf', ' Set whether or not to PING upon connect to verify connection', 1042390530);
INSERT INTO php_manual VALUES (1473, 'mcve_verifysslcert', 'PHP 4 >= 4.3.0', 'bool', 'resource conn, int tf', ' Set whether or not to verify the server ssl certificate', 1042390530);
INSERT INTO php_manual VALUES (1474, 'mcve_void', 'PHP 4 >= 4.2.0', 'int', 'resource conn, string username, string password, int sid, int ptrannum', ' VOID a transaction in the settlement queue', 1042390530);
INSERT INTO php_manual VALUES (1475, 'mhash_count', 'PHP 3>= 3.0.9, PHP 4', 'int', 'void', 'Get the highest available hash id', 1042390530);
INSERT INTO php_manual VALUES (1476, 'mhash_get_block_size', 'PHP 3>= 3.0.9, PHP 4', 'int', 'int hash', 'Get the block size of the specified hash', 1042390530);
INSERT INTO php_manual VALUES (1477, 'mhash_get_hash_name', 'PHP 3>= 3.0.9, PHP 4', 'string', 'int hash', 'Get the name of the specified hash', 1042390530);
INSERT INTO php_manual VALUES (1478, 'mhash_keygen_s2k', 'PHP 4 >= 4.0.4', 'string', 'int hash, string password, string salt, int bytes', 'Generates a key', 1042390530);
INSERT INTO php_manual VALUES (1479, 'mhash', 'PHP 3>= 3.0.9, PHP 4', 'string', 'int hash, string data, [string key]', 'Compute hash', 1042390530);
INSERT INTO php_manual VALUES (1480, 'mime_content_type', 'PHP 4 >= 4.3.0', 'string', 'string filename', 'Detect MIME Content-type for a file', 1042390530);
INSERT INTO php_manual VALUES (1481, 'ming_setcubicthreshold', 'PHP 4 >= 4.0.5', 'void', 'int threshold', ' Set cubic threshold (?)', 1042390530);
INSERT INTO php_manual VALUES (1482, 'ming_setscale', 'PHP 4 >= 4.0.5', 'void', 'int scale', ' Set scale (?)', 1042390530);
INSERT INTO php_manual VALUES (1483, 'ming_useswfversion', 'PHP 4 >= 4.2.0', 'void', 'int version', ' Use SWF version (?)', 1042390530);
INSERT INTO php_manual VALUES (1484, 'SWFAction', 'PHP 4 >= 4.0.5', 'new', 'string script', 'Creates a new Action.', 1042390530);
INSERT INTO php_manual VALUES (1485, 'SWFBitmap', 'PHP 4 >= 4.0.5', 'new', 'string filename, [int alphafilename]', 'Loads Bitmap object', 1042390530);
INSERT INTO php_manual VALUES (1486, 'swfbutton_keypress', 'PHP 4 >= 4.0.5', 'int', 'string str', ' Returns the action flag for keyPress(char)', 1042390530);
INSERT INTO php_manual VALUES (1487, 'SWFbutton->addAction', '', 'void', 'ressource action, int flags', 'Adds an action', 1042390530);
INSERT INTO php_manual VALUES (1488, 'SWFbutton->addShape', '', 'void', 'ressource shape, int flags', 'Adds a shape to a button', 1042390530);
INSERT INTO php_manual VALUES (1489, 'SWFbutton->setAction', '', 'void', 'ressource action', 'Sets the action', 1042390530);
INSERT INTO php_manual VALUES (1490, 'SWFbutton->setdown', '', 'void', 'ressource shape', 'Alias for addShape(shape, SWFBUTTON_DOWN))', 1042390530);
INSERT INTO php_manual VALUES (1491, 'SWFbutton->setHit', '', 'void', 'ressource shape', 'Alias for addShape(shape, SWFBUTTON_HIT)', 1042390530);
INSERT INTO php_manual VALUES (1492, 'SWFbutton->setOver', '', 'void', 'ressource shape', 'Alias for addShape(shape, SWFBUTTON_OVER)', 1042390530);
INSERT INTO php_manual VALUES (1493, 'SWFFill', 'PHP 4 >= 4.0.5', '', 'void', 'Loads SWFFill object', 1042390530);
INSERT INTO php_manual VALUES (1494, 'SWFbutton->setUp', '', 'void', 'ressource shape', 'Alias for addShape(shape, SWFBUTTON_UP)', 1042390530);
INSERT INTO php_manual VALUES (1495, 'SWFbutton', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a new Button.', 1042390530);
INSERT INTO php_manual VALUES (1496, 'SWFDisplayItem->move', '', 'void', 'int dx, int dy', 'Moves object in relative coordinates.', 1042390530);
INSERT INTO php_manual VALUES (1497, 'SWFDisplayItem->moveTo', '', 'void', 'int x, int y', 'Moves object in global coordinates.', 1042390530);
INSERT INTO php_manual VALUES (1498, 'SWFDisplayItem->remove', '', 'void', 'void', 'Removes the object from the movie', 1042390530);
INSERT INTO php_manual VALUES (1499, 'SWFDisplayItem->Rotate', '', 'void', 'float ddegrees', 'Rotates in relative coordinates.', 1042390530);
INSERT INTO php_manual VALUES (1500, 'SWFDisplayItem->rotateTo', '', 'void', 'float degrees', 'Rotates the object in global coordinates.', 1042390530);
INSERT INTO php_manual VALUES (1501, 'SWFDisplayItem->scale', '', 'void', 'int dx, int dy', 'Scales the object in relative coordinates.', 1042390530);
INSERT INTO php_manual VALUES (1502, 'SWFDisplayItem->scaleTo', '', 'void', 'int x, int y', 'Scales the object in global coordinates.', 1042390530);
INSERT INTO php_manual VALUES (1503, 'SWFDisplayItem->setDepth', '', 'void', 'float depth', 'Sets z-order', 1042390530);
INSERT INTO php_manual VALUES (1504, 'SWFDisplayItem', '', 'new', 'void', 'Creates a new displayitem object.', 1042390530);
INSERT INTO php_manual VALUES (1505, 'SWFDisplayItem->skewX', '', 'void', 'float ddegrees', 'Sets the X-skew.', 1042390530);
INSERT INTO php_manual VALUES (1506, 'SWFDisplayItem->skewXTo', '', 'void', 'float degrees', 'Sets the X-skew.', 1042390530);
INSERT INTO php_manual VALUES (1507, 'SWFDisplayItem->skewY', '', 'void', 'float ddegrees', 'Sets the Y-skew.', 1042390530);
INSERT INTO php_manual VALUES (1508, 'SWFDisplayItem->skewYTo', '', 'void', 'float degrees', 'Sets the Y-skew.', 1042390530);
INSERT INTO php_manual VALUES (1509, 'SWFFill->moveTo', '', 'void', 'int x, int y', 'Moves fill origin', 1042390530);
INSERT INTO php_manual VALUES (1510, 'SWFFill->skewXTo', '', 'void', 'float x', 'Sets fill x-skew', 1042390530);
INSERT INTO php_manual VALUES (1511, 'SWFFill->skewYTo', '', 'void', 'float y', 'Sets fill y-skew', 1042390530);
INSERT INTO php_manual VALUES (1512, 'SWFFont', 'PHP 4 >= 4.0.5', 'new', 'string filename', 'Loads a font definition', 1042390530);
INSERT INTO php_manual VALUES (1513, 'SWFGradient->addEntry', '', 'void', 'float ratio, int red, int green, int blue, [int a]', 'Adds an entry to the gradient list.', 1042390530);
INSERT INTO php_manual VALUES (1514, 'SWFGradient', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a gradient object', 1042390530);
INSERT INTO php_manual VALUES (1515, 'SWFMorph->getshape1', '', 'mixed', 'void', 'Gets a handle to the starting shape', 1042390530);
INSERT INTO php_manual VALUES (1516, 'SWFMorph->getshape2', '', 'mixed', 'void', 'Gets a handle to the ending shape', 1042390530);
INSERT INTO php_manual VALUES (1517, 'SWFMorph', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a new SWFMorph object.', 1042390530);
INSERT INTO php_manual VALUES (1518, 'SWFMovie', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a new movie object, representing an SWF version 4 movie.', 1042390530);
INSERT INTO php_manual VALUES (1519, 'SWFMovie->add', '', 'void', 'ressource instance', 'Adds any type of data to a movie.', 1042390530);
INSERT INTO php_manual VALUES (1520, 'SWFMovie->nextframe', '', 'void', 'void', 'Moves to the next frame of the animation.', 1042390531);
INSERT INTO php_manual VALUES (1521, 'SWFMovie->output', '', 'void', 'void', 'Dumps your lovingly prepared movie out.', 1042390531);
INSERT INTO php_manual VALUES (1522, 'SWFMovie->remove', '', 'void', 'resource instance', 'Removes the object instance from the display list.', 1042390531);
INSERT INTO php_manual VALUES (1523, 'SWFMovie->save', '', 'void', 'string filename', 'Saves your movie in a file.', 1042390531);
INSERT INTO php_manual VALUES (1524, 'SWFMovie->setbackground', '', 'void', 'int red, int green, int blue', 'Sets the background color.', 1042390531);
INSERT INTO php_manual VALUES (1525, 'SWFMovie->setframes', '', 'void', 'string numberofframes', 'Sets the total number of frames in the animation.', 1042390531);
INSERT INTO php_manual VALUES (1526, 'SWFMovie->streammp3', '', 'void', 'string mp3FileName', 'Streams a MP3 file.', 1042390531);
INSERT INTO php_manual VALUES (1527, 'SWFShape->addFill', '', 'void', 'int red, int green, int blue, [int a]', 'Adds a solid fill to the shape.', 1042390531);
INSERT INTO php_manual VALUES (1528, 'SWFShape->drawCurve', '', 'void', 'int controldx, int controldy, int anchordx, int anchordy', 'Draws a curve (relative).', 1042390531);
INSERT INTO php_manual VALUES (1529, 'SWFShape->drawCurveTo', '', 'void', 'int controlx, int controly, int anchorx, int anchory', 'Draws a curve.', 1042390531);
INSERT INTO php_manual VALUES (1530, 'SWFShape->drawLine', '', 'void', 'int dx, int dy', 'Draws a line (relative).', 1042390531);
INSERT INTO php_manual VALUES (1531, 'SWFShape->drawLineTo', '', 'void', 'int x, int y', 'Draws a line.', 1042390531);
INSERT INTO php_manual VALUES (1532, 'SWFShape->setLeftFill', '', 'void', 'swfgradient fill', 'Sets left rasterizing color.', 1042390531);
INSERT INTO php_manual VALUES (1533, 'SWFShape->setRightFill', '', 'void', 'swfgradient fill', 'Sets right rasterizing color.', 1042390531);
INSERT INTO php_manual VALUES (1534, 'SWFShape', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a new shape object.', 1042390531);
INSERT INTO php_manual VALUES (1535, 'SWFSprite->add', '', 'void', 'resource object', 'Adds an object to a sprite', 1042390531);
INSERT INTO php_manual VALUES (1536, 'SWFSprite->nextframe', '', 'void', 'void', 'Moves to the next frame of the animation.', 1042390531);
INSERT INTO php_manual VALUES (1537, 'SWFSprite->remove', '', 'void', 'ressource object', 'Removes an object to a sprite', 1042390531);
INSERT INTO php_manual VALUES (1538, 'SWFSprite->setframes', '', 'void', 'int numberofframes', 'Sets the total number of frames in the animation.', 1042390531);
INSERT INTO php_manual VALUES (1539, 'SWFSprite', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a movie clip (a sprite)', 1042390531);
INSERT INTO php_manual VALUES (1540, 'SWFText->addString', '', 'void', 'string string', 'Draws a string', 1042390531);
INSERT INTO php_manual VALUES (1541, 'SWFText->moveTo', '', 'void', 'int x, int y', 'Moves the pen', 1042390531);
INSERT INTO php_manual VALUES (1542, 'SWFText->setColor', '', 'void', 'int red, int green, int blue, [int a]', 'Sets the current font color', 1042390531);
INSERT INTO php_manual VALUES (1543, 'SWFText->setFont', '', 'void', 'string font', 'Sets the current font', 1042390531);
INSERT INTO php_manual VALUES (1544, 'SWFText->setHeight', '', 'void', 'int height', 'Sets the current font height', 1042390531);
INSERT INTO php_manual VALUES (1545, 'SWFText', 'PHP 4 >= 4.0.5', 'new', 'void', 'Creates a new SWFText object.', 1042390531);
INSERT INTO php_manual VALUES (1546, 'SWFText->setSpacing', '', 'void', 'float spacing', 'Sets the current font spacing', 1042390531);
INSERT INTO php_manual VALUES (1547, 'SWFTextField->addstring', '', 'void', 'string string', 'Concatenates the given string to the text field', 1042390531);
INSERT INTO php_manual VALUES (1548, 'SWFTextField->align', '', 'void', 'int alignement', 'Sets the text field alignment', 1042390531);
INSERT INTO php_manual VALUES (1549, 'SWFTextField->setbounds', '', 'void', 'int width, int height', 'Sets the text field width and height', 1042390531);
INSERT INTO php_manual VALUES (1550, 'SWFTextField->setcolor', '', 'void', 'int red, int green, int blue, [int a]', 'Sets the color of the text field.', 1042390531);
INSERT INTO php_manual VALUES (1551, 'SWFTextField->setFont', '', 'void', 'string font', 'Sets the text field font', 1042390531);
INSERT INTO php_manual VALUES (1552, 'SWFTextField->setHeight', '', 'void', 'int height', 'Sets the font height of this text field font.', 1042390531);
INSERT INTO php_manual VALUES (1553, 'SWFTextField->setindentation', '', 'void', 'int width', 'Sets the indentation of the first line.', 1042390531);
INSERT INTO php_manual VALUES (1554, 'SWFTextField->setLeftMargin', '', 'void', 'int width', 'Sets the left margin width of the text field.', 1042390531);
INSERT INTO php_manual VALUES (1555, 'SWFTextField->setLineSpacing', '', 'void', 'int height', 'Sets the line spacing of the text field.', 1042390531);
INSERT INTO php_manual VALUES (1556, 'SWFTextField->setMargins', '', 'void', 'int left, int right', 'Sets the margins width of the text field.', 1042390531);
INSERT INTO php_manual VALUES (1557, 'SWFTextField->setname', '', 'void', 'string name', 'Sets the variable name', 1042390531);
INSERT INTO php_manual VALUES (1558, 'SWFTextField->setrightMargin', '', 'void', 'int width', 'Sets the right margin width of the text field.', 1042390531);
INSERT INTO php_manual VALUES (1559, 'SWFTextField', 'PHP 4 >= 4.0.5', 'new', '[int flags]', 'Creates a text field object', 1042390531);
INSERT INTO php_manual VALUES (1560, 'connection_aborted', 'PHP 3>= 3.0.7, PHP 4', '', 'void', '', 1042390531);
INSERT INTO php_manual VALUES (1561, 'connection_status', 'PHP 3>= 3.0.7, PHP 4', 'int', 'void', 'Returns connection status bitfield', 1042390531);
INSERT INTO php_manual VALUES (1562, 'connection_timeout', 'PHP 3>= 3.0.7, PHP 4  <= 4.0.4', '', 'void', '', 1042390531);
INSERT INTO php_manual VALUES (1563, 'constant', 'PHP 4 >= 4.0.4', 'mixed', 'string name', 'Returns the value of a constant', 1042390531);
INSERT INTO php_manual VALUES (1564, 'define', 'PHP 3, PHP 4', 'bool', 'string name, mixed value, [bool case_insensitive]', 'Defines a named constant.', 1042390531);
INSERT INTO php_manual VALUES (1565, 'defined', 'PHP 3, PHP 4', 'bool', 'string name', ' Checks whether a given named constant exists', 1042390531);
INSERT INTO php_manual VALUES (1566, 'die', '', '', 'void', 'Alias of exit', 1042390531);
INSERT INTO php_manual VALUES (1567, 'eval', '', 'mixed', 'string code_str', 'Evaluate a string as PHP code', 1042390531);
INSERT INTO php_manual VALUES (1568, 'exit', '', 'void', '[string status], int status', 'Output a message and terminate the current script', 1042390531);
INSERT INTO php_manual VALUES (1569, 'highlight_file', 'PHP 4', 'mixed', 'string filename, [bool return]', 'Syntax highlighting of a file', 1042390531);
INSERT INTO php_manual VALUES (1570, 'highlight_string', 'PHP 4', 'mixed', 'string str, [bool return]', 'Syntax highlighting of a string', 1042390531);
INSERT INTO php_manual VALUES (1571, 'ignore_user_abort', 'PHP 3>= 3.0.7, PHP 4', 'int', '[int setting]', ' Set whether a client disconnect should abort script execution', 1042390531);
INSERT INTO php_manual VALUES (1572, 'pack', 'PHP 3, PHP 4', 'string', 'string format, [mixed args]', 'Pack data into binary string.', 1042390531);
INSERT INTO php_manual VALUES (1573, 'show_source', 'PHP 4', 'bool', 'string filename, [bool return]', 'Syntax highlighting of a file', 1042390531);
INSERT INTO php_manual VALUES (1574, 'sleep', 'PHP 3, PHP 4', 'void', 'int seconds', 'Delay execution', 1042390531);
INSERT INTO php_manual VALUES (1575, 'uniqid', 'PHP 3, PHP 4', 'string', 'string prefix, [bool lcg]', 'Generate a unique ID', 1042390532);
INSERT INTO php_manual VALUES (1576, 'unpack', 'PHP 3, PHP 4', 'array', 'string format, string data', 'Unpack data from binary string', 1042390532);
INSERT INTO php_manual VALUES (1577, 'usleep', 'PHP 3, PHP 4', 'void', 'int micro_seconds', 'Delay execution in microseconds', 1042390532);
INSERT INTO php_manual VALUES (1578, 'udm_add_search_limit', 'PHP 4 >= 4.0.5', 'int', 'int agent, int var, string val', 'Add various search limits', 1042390532);
INSERT INTO php_manual VALUES (1579, 'udm_alloc_agent', 'PHP 4 >= 4.0.5', 'int', 'string dbaddr, [string dbmode]', 'Allocate mnoGoSearch session', 1042390532);
INSERT INTO php_manual VALUES (1580, 'udm_api_version', 'PHP 4 >= 4.0.5', 'int', 'void', 'Get mnoGoSearch API version.', 1042390532);
INSERT INTO php_manual VALUES (1581, 'udm_cat_list', 'PHP 4 >= 4.0.6', 'array', 'int agent, string category', 'Get all the categories on the same level with the current one.', 1042390532);
INSERT INTO php_manual VALUES (1582, 'udm_cat_path', 'PHP 4 >= 4.0.6', 'array', 'int agent, string category', 'Get the path to the current category.', 1042390532);
INSERT INTO php_manual VALUES (1583, 'udm_check_charset', 'PHP 4 >= 4.2.0', 'int', 'int agent, string charset', ' Check if the given charset is known to mnogosearch', 1042390532);
INSERT INTO php_manual VALUES (1584, 'udm_check_stored', 'PHP 4 >= 4.2.0', 'int', 'int agent, int link, string doc_id', ' Check connection to stored', 1042390532);
INSERT INTO php_manual VALUES (1585, 'udm_clear_search_limits', 'PHP 4 >= 4.0.5', 'int', 'int agent', 'Clear all mnoGoSearch search restrictions', 1042390532);
INSERT INTO php_manual VALUES (1586, 'udm_close_stored', 'PHP 4 >= 4.2.0', 'int', 'int agent, int link', ' Close connection to stored', 1042390532);
INSERT INTO php_manual VALUES (1587, 'udm_crc32', 'PHP 4 >= 4.2.0', 'int', 'int agent, string str', ' Return CRC32 checksum of gived string', 1042390532);
INSERT INTO php_manual VALUES (1588, 'udm_errno', 'PHP 4 >= 4.0.5', 'int', 'int agent', 'Get mnoGoSearch error number', 1042390532);
INSERT INTO php_manual VALUES (1589, 'udm_error', 'PHP 4 >= 4.0.5', 'string', 'int agent', 'Get mnoGoSearch error message', 1042390532);
INSERT INTO php_manual VALUES (1590, 'udm_find', 'PHP 4 >= 4.0.5', 'int', 'int agent, string query', 'Perform search', 1042390532);
INSERT INTO php_manual VALUES (1591, 'udm_free_agent', 'PHP 4 >= 4.0.5', 'int', 'int agent', 'Free mnoGoSearch session', 1042390532);
INSERT INTO php_manual VALUES (1592, 'udm_free_ispell_data', 'PHP 4 >= 4.0.5', 'int', 'int agent', 'Free memory allocated for ispell data', 1042390532);
INSERT INTO php_manual VALUES (1593, 'udm_free_res', 'PHP 4 >= 4.0.5', 'int', 'int res', 'Free mnoGoSearch result', 1042390532);
INSERT INTO php_manual VALUES (1594, 'udm_get_doc_count', 'PHP 4 >= 4.0.5', 'int', 'int agent', 'Get total number of documents in database.', 1042390532);
INSERT INTO php_manual VALUES (1595, 'udm_get_res_field', 'PHP 4 >= 4.0.5', 'string', 'int res, int row, int field', 'Fetch mnoGoSearch result field', 1042390532);
INSERT INTO php_manual VALUES (1596, 'udm_get_res_param', 'PHP 4 >= 4.0.5', 'string', 'int res, int param', 'Get mnoGoSearch result parameters', 1042390532);
INSERT INTO php_manual VALUES (1597, 'udm_load_ispell_data', 'PHP 4 >= 4.0.5', 'int', 'int agent, int var, string val1, string val2, int flag', 'Load ispell data', 1042390532);
INSERT INTO php_manual VALUES (1598, 'udm_open_stored', 'PHP 4 >= 4.2.0', 'int', 'int agent, string storedaddr', ' Open connection to stored', 1042390532);
INSERT INTO php_manual VALUES (1599, 'udm_set_agent_param', 'PHP 4 >= 4.0.5', 'int', 'int agent, int var, string val', 'Set mnoGoSearch agent session parameters', 1042390532);
INSERT INTO php_manual VALUES (1600, 'msession_connect', 'PHP 4 >= 4.2.0', 'bool', 'string host, string port', 'Connect to msession server', 1042390532);
INSERT INTO php_manual VALUES (1601, 'msession_count', 'PHP 4 >= 4.2.0', 'int', 'void', 'Get session count', 1042390532);
INSERT INTO php_manual VALUES (1602, 'msession_create', 'PHP 4 >= 4.2.0', 'bool', 'string session', 'Create a session', 1042390532);
INSERT INTO php_manual VALUES (1603, 'msession_destroy', 'PHP 4 >= 4.2.0', 'bool', 'string name', 'Destroy a session', 1042390532);
INSERT INTO php_manual VALUES (1604, 'msession_disconnect', 'PHP 4 >= 4.2.0', 'void', 'void', 'Close connection to msession server', 1042390532);
INSERT INTO php_manual VALUES (1605, 'msession_find', 'PHP 4 >= 4.2.0', 'array', 'string name, string value', 'Find value', 1042390532);
INSERT INTO php_manual VALUES (1606, 'msession_get_array', 'PHP 4 >= 4.2.0', 'array', 'string session', 'Get array of ... ?', 1042390532);
INSERT INTO php_manual VALUES (1607, 'msession_get', 'PHP 4 >= 4.2.0', 'string', 'string session, string name, string value', 'Get value from session', 1042390532);
INSERT INTO php_manual VALUES (1608, 'msession_getdata', '', 'string', 'string session', 'Get data ... ?', 1042390532);
INSERT INTO php_manual VALUES (1609, 'msession_inc', 'PHP 4 >= 4.2.0', 'string', 'string session, string name', 'Increment value in session', 1042390532);
INSERT INTO php_manual VALUES (1610, 'msession_list', 'PHP 4 >= 4.2.0', 'array', 'void', 'List ... ?', 1042390532);
INSERT INTO php_manual VALUES (1611, 'msession_listvar', 'PHP 4 >= 4.2.0', 'array', 'string name', 'List sessions with variable', 1042390532);
INSERT INTO php_manual VALUES (1612, 'msession_lock', 'PHP 4 >= 4.2.0', 'int', 'string name', 'Lock a session', 1042390532);
INSERT INTO php_manual VALUES (1613, 'msession_plugin', 'PHP 4 >= 4.2.0', 'string', 'string session, string val, [string param]', 'Call an escape function within the msession personality plugin', 1042390532);
INSERT INTO php_manual VALUES (1614, 'msession_randstr', 'PHP 4 >= 4.2.0', 'string', 'int param', 'Get random string', 1042390532);
INSERT INTO php_manual VALUES (1615, 'msession_set_array', 'PHP 4 >= 4.2.0', 'bool', 'string session, array tuples', 'Set array of ...', 1042390532);
INSERT INTO php_manual VALUES (1616, 'msession_set', 'PHP 4 >= 4.2.0', 'bool', 'string session, string name, string value', 'Set value in session', 1042390532);
INSERT INTO php_manual VALUES (1617, 'msession_setdata', '', 'bool', 'string session, string value', 'Set data ... ?', 1042390532);
INSERT INTO php_manual VALUES (1618, 'msession_timeout', 'PHP 4 >= 4.2.0', 'int', 'string session, [int param]', 'Set/get session timeout', 1042390532);
INSERT INTO php_manual VALUES (1619, 'msession_uniq', 'PHP 4 >= 4.2.0', 'string', 'int param', 'Get uniq id', 1042390532);
INSERT INTO php_manual VALUES (1620, 'msession_unlock', 'PHP 4 >= 4.2.0', 'int', 'string session, int key', 'Unlock a session', 1042390532);
INSERT INTO php_manual VALUES (1621, 'msql_affected_rows', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int query_identifier', 'Returns number of affected rows', 1042390532);
INSERT INTO php_manual VALUES (1622, 'msql_close', 'PHP 3, PHP 4', 'int', 'int link_identifier', 'Close mSQL connection', 1042390532);
INSERT INTO php_manual VALUES (1623, 'msql_connect', 'PHP 3, PHP 4', 'int', '[string hostname ], [string server ], [string username ], [string password ]', 'Open mSQL connection', 1042390532);
INSERT INTO php_manual VALUES (1624, 'msql_create_db', 'PHP 3, PHP 4', 'int', 'string database name, [int link_identifier]', 'Create mSQL database', 1042390532);
INSERT INTO php_manual VALUES (1625, 'msql_createdb', 'PHP 3, PHP 4', 'int', 'string database name, [int link_identifier]', 'Create mSQL database', 1042390532);
INSERT INTO php_manual VALUES (1626, 'msql_data_seek', 'PHP 3, PHP 4', 'int', 'int query_identifier, int row_number', 'Move internal row pointer', 1042390532);
INSERT INTO php_manual VALUES (1627, 'msql_dbname', 'PHP 3, PHP 4', 'string', 'int query_identifier, int i', 'Get current mSQL database name', 1042390532);
INSERT INTO php_manual VALUES (1628, 'msql_drop_db', 'PHP 3, PHP 4', 'int', 'string database_name, int link_identifier', 'Drop (delete) mSQL database', 1042390532);
INSERT INTO php_manual VALUES (1629, 'msql_dropdb', 'PHP 3, PHP 4', '', 'void', 'Drop (delete) mSQL database', 1042390532);
INSERT INTO php_manual VALUES (1630, 'msql_error', 'PHP 3, PHP 4', 'string', '[int link_identifier]', 'Returns error message of last msql call', 1042390532);
INSERT INTO php_manual VALUES (1631, 'msql_fetch_array', 'PHP 3, PHP 4', 'int', 'int query_identifier, [int result_type]', 'Fetch row as array', 1042390532);
INSERT INTO php_manual VALUES (1632, 'msql_fetch_field', 'PHP 3, PHP 4', 'object', 'int query_identifier, int field_offset', 'Get field information', 1042390533);
INSERT INTO php_manual VALUES (1633, 'msql_fetch_object', 'PHP 3, PHP 4', 'int', 'int query_identifier, [int result_type]', 'Fetch row as object', 1042390533);
INSERT INTO php_manual VALUES (1634, 'msql_fetch_row', 'PHP 3, PHP 4', 'array', 'int query_identifier', 'Get row as enumerated array', 1042390533);
INSERT INTO php_manual VALUES (1635, 'msql_field_seek', 'PHP 3, PHP 4', 'int', 'int query_identifier, int field_offset', 'Set field offset', 1042390533);
INSERT INTO php_manual VALUES (1636, 'msql_fieldflags', 'PHP 3, PHP 4', 'string', 'int query_identifier, int i', 'Get field flags', 1042390533);
INSERT INTO php_manual VALUES (1637, 'msql_fieldlen', 'PHP 3, PHP 4', 'int', 'int query_identifier, int i', 'Get field length', 1042390533);
INSERT INTO php_manual VALUES (1638, 'msql_fieldname', 'PHP 3, PHP 4', 'string', 'int query_identifier, int field', 'Get field name', 1042390533);
INSERT INTO php_manual VALUES (1639, 'msql_fieldtable', 'PHP 3, PHP 4', 'int', 'int query_identifier, int field', 'Get table name for field', 1042390533);
INSERT INTO php_manual VALUES (1640, 'msql_fieldtype', 'PHP 3, PHP 4', 'string', 'int query_identifier, int i', 'Get field type', 1042390533);
INSERT INTO php_manual VALUES (1641, 'msql_free_result', 'PHP 3, PHP 4', 'int', 'int query_identifier', 'Free result memory', 1042390533);
INSERT INTO php_manual VALUES (1642, 'msql_freeresult', 'PHP 3, PHP 4', '', 'void', 'Free result memory', 1042390533);
INSERT INTO php_manual VALUES (1643, 'msql_list_dbs', 'PHP 3, PHP 4', 'int', 'void', 'List mSQL databases on server', 1042390533);
INSERT INTO php_manual VALUES (1644, 'msql_list_fields', 'PHP 3, PHP 4', 'int', 'string database, string tablename', 'List result fields', 1042390533);
INSERT INTO php_manual VALUES (1645, 'msql_list_tables', 'PHP 3, PHP 4', 'int', 'string database', 'List tables in an mSQL database', 1042390533);
INSERT INTO php_manual VALUES (1646, 'msql_listdbs', 'PHP 3, PHP 4', '', 'void', 'List mSQL databases on server', 1042390533);
INSERT INTO php_manual VALUES (1647, 'msql_listfields', 'PHP 3, PHP 4', '', 'void', 'List result fields', 1042390533);
INSERT INTO php_manual VALUES (1648, 'msql_listtables', 'PHP 3, PHP 4', '', 'void', 'List tables in an mSQL database', 1042390533);
INSERT INTO php_manual VALUES (1649, 'msql_num_fields', 'PHP 3, PHP 4', 'int', 'int query_identifier', 'Get number of fields in result', 1042390533);
INSERT INTO php_manual VALUES (1650, 'msql_num_rows', 'PHP 3, PHP 4', 'int', 'int query_identifier', 'Get number of rows in result', 1042390533);
INSERT INTO php_manual VALUES (1651, 'msql_numfields', 'PHP 3, PHP 4', 'int', 'int query_identifier', 'Get number of fields in result', 1042390533);
INSERT INTO php_manual VALUES (1652, 'msql_numrows', 'PHP 3, PHP 4', 'int', 'void', 'Get number of rows in result', 1042390533);
INSERT INTO php_manual VALUES (1653, 'msql_pconnect', 'PHP 3, PHP 4', 'int', '[string server ], [string username ], [string password ]', 'Open persistent mSQL connection', 1042390533);
INSERT INTO php_manual VALUES (1654, 'msql_query', 'PHP 3, PHP 4', 'int', 'string query, int link_identifier', 'Send mSQL query', 1042390533);
INSERT INTO php_manual VALUES (1655, 'msql_regcase', 'PHP 3, PHP 4', '', 'void', ' Make regular expression for case insensitive match', 1042390533);
INSERT INTO php_manual VALUES (1656, 'msql_result', 'PHP 3, PHP 4', 'int', 'int query_identifier, int i, mixed field', 'Get result data', 1042390533);
INSERT INTO php_manual VALUES (1657, 'msql_select_db', 'PHP 3, PHP 4', 'int', 'string database_name, int link_identifier', 'Select mSQL database', 1042390533);
INSERT INTO php_manual VALUES (1658, 'msql_selectdb', 'PHP 3, PHP 4', '', 'void', 'Select mSQL database', 1042390533);
INSERT INTO php_manual VALUES (1659, 'msql_tablename', 'PHP 3, PHP 4', 'string', 'int query_identifier, int field', 'Get table name of field', 1042390533);
INSERT INTO php_manual VALUES (1660, 'msql', 'PHP 3, PHP 4', 'int', 'string database, string query, int link_identifier', 'Send mSQL query', 1042390533);
INSERT INTO php_manual VALUES (1661, 'mssql_bind', 'PHP 4 >= 4.1.0', 'int', 'int stmt, string param_name, mixed var, int type, [int is_output], [int is_null], [int maxlen]', ' Adds a parameter to a stored procedure or a remote stored procedure', 1042390533);
INSERT INTO php_manual VALUES (1662, 'mssql_close', 'PHP 3, PHP 4', 'int', '[int link_identifier]', 'Close MS SQL Server connection', 1042390533);
INSERT INTO php_manual VALUES (1663, 'mssql_connect', 'PHP 3, PHP 4', 'int', '[string servername], [string username], [string password]', 'Open MS SQL server connection', 1042390533);
INSERT INTO php_manual VALUES (1664, 'mssql_data_seek', 'PHP 3, PHP 4', 'int', 'int result_identifier, int row_number', 'Move internal row pointer', 1042390533);
INSERT INTO php_manual VALUES (1665, 'mssql_execute', 'PHP 4 >= 4.1.0', 'int', 'int stmt', ' Executes a stored procedure on a MS SQL server database', 1042390533);
INSERT INTO php_manual VALUES (1666, 'mssql_fetch_array', 'PHP 3, PHP 4', 'array', 'int result', 'Fetch row as array', 1042390533);
INSERT INTO php_manual VALUES (1667, 'mssql_fetch_assoc', 'PHP 4 >= 4.2.0', 'array', 'int result_id, [int result_type]', ' Returns an associative array of the current row in the result set specified by result_id', 1042390533);
INSERT INTO php_manual VALUES (1668, 'mssql_fetch_batch', 'PHP 4 >= 4.0.4', 'int', 'string result_index', ' Returns the next batch of records', 1042390533);
INSERT INTO php_manual VALUES (1669, 'mssql_fetch_field', 'PHP 3, PHP 4', 'object', 'int result, [int field_offset]', 'Get field information', 1042390533);
INSERT INTO php_manual VALUES (1670, 'mssql_fetch_object', 'PHP 4', 'int', 'int result', 'Fetch row as object', 1042390533);
INSERT INTO php_manual VALUES (1671, 'mssql_fetch_row', 'PHP 3, PHP 4', 'array', 'int result', 'Get row as enumerated array', 1042390533);
INSERT INTO php_manual VALUES (1672, 'mssql_field_length', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result, [int offset]', 'Get the length of a field', 1042390533);
INSERT INTO php_manual VALUES (1673, 'mssql_field_name', 'PHP 3>= 3.0.3, PHP 4', 'int', 'int result, [int offset]', 'Get the name of a field', 1042390533);
INSERT INTO php_manual VALUES (1674, 'mssql_field_seek', 'PHP 3, PHP 4', 'int', 'int result, int field_offset', 'Set field offset', 1042390533);
INSERT INTO php_manual VALUES (1675, 'mssql_field_type', 'PHP 3>= 3.0.3, PHP 4', 'string', 'int result, [int offset]', 'Get the type of a field', 1042390533);
INSERT INTO php_manual VALUES (1676, 'mssql_free_result', 'PHP 3, PHP 4', 'int', 'int result', 'Free result memory', 1042390533);
INSERT INTO php_manual VALUES (1677, 'mssql_get_last_message', 'PHP 3, PHP 4', 'string', 'void', ' Returns the last message from server (over min_message_severity?)', 1042390533);
INSERT INTO php_manual VALUES (1678, 'mssql_guid_string', 'PHP 4 >= 4.1.0', 'string', 'string binary, [int short_format]', ' Converts a 16 byte binary GUID to a string', 1042390533);
INSERT INTO php_manual VALUES (1679, 'mssql_init', 'PHP 4 >= 4.1.0', 'int', 'string sp_name, [int conn_id]', ' Initializes a stored procedure or a remote stored procedure', 1042390533);
INSERT INTO php_manual VALUES (1680, 'mssql_min_error_severity', 'PHP 3, PHP 4', 'void', 'int severity', 'Sets the lower error severity', 1042390533);
INSERT INTO php_manual VALUES (1681, 'mssql_min_message_severity', 'PHP 3, PHP 4', 'void', 'int severity', 'Sets the lower message severity', 1042390533);
INSERT INTO php_manual VALUES (1682, 'mssql_next_result', 'PHP 4 >= 4.0.5', 'bool', 'int result_id', 'Move the internal result pointer to the next result', 1042390533);
INSERT INTO php_manual VALUES (1683, 'mssql_num_fields', 'PHP 3, PHP 4', 'int', 'int result', 'Get number of fields in result', 1042390533);
INSERT INTO php_manual VALUES (1684, 'mssql_num_rows', 'PHP 3, PHP 4', 'int', 'string result', 'Get number of rows in result', 1042390533);
INSERT INTO php_manual VALUES (1685, 'mssql_pconnect', 'PHP 3, PHP 4', 'int', '[string servername], [string username], [string password]', 'Open persistent MS SQL connection', 1042390533);
INSERT INTO php_manual VALUES (1686, 'mssql_query', 'PHP 3, PHP 4', 'int', 'string query, [int link_identifier]', 'Send MS SQL query', 1042390533);
INSERT INTO php_manual VALUES (1687, 'mssql_result', 'PHP 3, PHP 4', 'int', 'int result, int i, mixed field', 'Get result data', 1042390533);
INSERT INTO php_manual VALUES (1688, 'mssql_rows_affected', 'PHP 4 >= 4.0.4', 'int', 'int conn_id', ' Returns the number of records affected by the query', 1042390533);
INSERT INTO php_manual VALUES (1689, 'mssql_select_db', 'PHP 3, PHP 4', 'int', 'string database_name, [int link_identifier]', 'Select MS SQL database', 1042390533);
INSERT INTO php_manual VALUES (1690, 'muscat_close', '4.0.5 - 4.2.3 only', 'int', 'resource muscat_handle', 'Shuts down the muscat session and releases any memory back to PHP.', 1042390533);
INSERT INTO php_manual VALUES (1691, 'muscat_get', '4.0.5 - 4.2.3 only', 'string', 'resource muscat_handle', 'Gets a line back from the core muscat API.', 1042390534);
INSERT INTO php_manual VALUES (1692, 'muscat_give', '4.0.5 - 4.2.3 only', 'int', 'resource muscat_handle, string string', 'Sends string to the core muscat API', 1042390534);
INSERT INTO php_manual VALUES (1693, 'muscat_setup_net', '4.0.5 - 4.2.3 only', 'resource', 'string muscat_host, int port', 'Creates a new muscat session and returns the handle.', 1042390534);
INSERT INTO php_manual VALUES (1694, 'muscat_setup', '4.0.5 - 4.2.3 only', 'resource', 'int size, [string muscat_dir]', 'Creates a new muscat session and returns the handle.', 1042390534);
INSERT INTO php_manual VALUES (1695, 'mysql_affected_rows', 'PHP 3, PHP 4', 'int', '[resource link_identifier ]', 'Get number of affected rows in previous MySQL operation', 1042390534);
INSERT INTO php_manual VALUES (1696, 'mysql_change_user', 'PHP 3>= 3.0.13', 'int', 'string user, string password, [string database ], [resource link_identifier ]', ' Change logged in user of the active connection', 1042390534);
INSERT INTO php_manual VALUES (1697, 'mysql_client_encoding', 'PHP 4 >= 4.3.0', 'int', '[resource link_identifier]', 'Returns the name of the character set', 1042390534);
INSERT INTO php_manual VALUES (1698, 'mysql_close', 'PHP 3, PHP 4', 'bool', '[resource link_identifier ]', 'Close MySQL connection', 1042390534);
INSERT INTO php_manual VALUES (1699, 'mysql_connect', 'PHP 3, PHP 4', 'resource', '[string server ], [string username ], [string password ], [bool new_link ], [int client_flags ]', 'Open a connection to a MySQL Server', 1042390534);
INSERT INTO php_manual VALUES (1700, 'mysql_create_db', 'PHP 3, PHP 4', 'bool', 'string database name, [resource link_identifier ]', 'Create a MySQL database', 1042390534);
INSERT INTO php_manual VALUES (1701, 'mysql_data_seek', 'PHP 3, PHP 4', 'bool', 'resource result_identifier, int row_number', 'Move internal result pointer', 1042390534);
INSERT INTO php_manual VALUES (1702, 'mysql_db_name', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource result, int row, [mixed field ]', 'Get result data', 1042390534);
INSERT INTO php_manual VALUES (1703, 'mysql_db_query', 'PHP 3, PHP 4', 'resource', 'string database, string query, [resource link_identifier ]', 'Send a MySQL query', 1042390534);
INSERT INTO php_manual VALUES (1704, 'mysql_drop_db', 'PHP 3, PHP 4', 'bool', 'string database_name, [resource link_identifier ]', 'Drop (delete) a MySQL database', 1042390534);
INSERT INTO php_manual VALUES (1705, 'mysql_errno', 'PHP 3, PHP 4', 'int', '[resource link_identifier ]', ' Returns the numerical value of the error message from previous MySQL operation', 1042390534);
INSERT INTO php_manual VALUES (1706, 'mysql_error', 'PHP 3, PHP 4', 'string', '[resource link_identifier ]', ' Returns the text of the error message from previous MySQL operation', 1042390534);
INSERT INTO php_manual VALUES (1707, 'mysql_escape_string', 'PHP 4 >= 4.0.3', 'string', 'string unescaped_string', ' Escapes a string for use in a mysql_query.', 1042390534);
INSERT INTO php_manual VALUES (1708, 'mysql_fetch_array', 'PHP 3, PHP 4', 'array', 'resource result, [int result_type ]', ' Fetch a result row as an associative array, a numeric array, or both.', 1042390534);
INSERT INTO php_manual VALUES (1709, 'mysql_fetch_assoc', 'PHP 4 >= 4.0.3', 'array', 'resource result', ' Fetch a result row as an associative array', 1042390534);
INSERT INTO php_manual VALUES (1710, 'mysql_fetch_field', 'PHP 3, PHP 4', 'object', 'resource result, [int field_offset ]', ' Get column information from a result and return as an object', 1042390534);
INSERT INTO php_manual VALUES (1711, 'mysql_fetch_lengths', 'PHP 3, PHP 4', 'array', 'resource result', ' Get the length of each output in a result', 1042390534);
INSERT INTO php_manual VALUES (1712, 'mysql_fetch_object', 'PHP 3, PHP 4', 'object', 'resource result', 'Fetch a result row as an object', 1042390534);
INSERT INTO php_manual VALUES (1713, 'mysql_fetch_row', 'PHP 3, PHP 4', 'array', 'resource result', 'Get a result row as an enumerated array', 1042390534);
INSERT INTO php_manual VALUES (1714, 'mysql_field_flags', 'PHP 3, PHP 4', 'string', 'resource result, int field_offset', ' Get the flags associated with the specified field in a result', 1042390534);
INSERT INTO php_manual VALUES (1715, 'mysql_field_len', 'PHP 3, PHP 4', 'int', 'resource result, int field_offset', ' Returns the length of the specified field', 1042390534);
INSERT INTO php_manual VALUES (1716, 'mysql_field_name', 'PHP 3, PHP 4', 'string', 'resource result, int field_index', ' Get the name of the specified field in a result', 1042390534);
INSERT INTO php_manual VALUES (1717, 'mysql_field_seek', 'PHP 3, PHP 4', 'int', 'resource result, int field_offset', ' Set result pointer to a specified field offset', 1042390534);
INSERT INTO php_manual VALUES (1718, 'mysql_field_table', 'PHP 3, PHP 4', 'string', 'resource result, int field_offset', ' Get name of the table the specified field is in', 1042390534);
INSERT INTO php_manual VALUES (1719, 'mysql_field_type', 'PHP 3, PHP 4', 'string', 'resource result, int field_offset', ' Get the type of the specified field in a result', 1042390534);
INSERT INTO php_manual VALUES (1720, 'mysql_free_result', 'PHP 3, PHP 4', 'bool', 'resource result', 'Free result memory', 1042390534);
INSERT INTO php_manual VALUES (1721, 'mysql_get_client_info', 'PHP 4 >= 4.0.5', 'string', 'void', 'Get MySQL client info', 1042390534);
INSERT INTO php_manual VALUES (1722, 'mysql_get_host_info', 'PHP 4 >= 4.0.5', 'string', '[resource link_identifier]', 'Get MySQL host info', 1042390534);
INSERT INTO php_manual VALUES (1723, 'mysql_get_proto_info', 'PHP 4 >= 4.0.5', 'int', '[resource link_identifier]', 'Get MySQL protocol info', 1042390534);
INSERT INTO php_manual VALUES (1724, 'mysql_get_server_info', 'PHP 4 >= 4.0.5', 'string', '[resource link_identifier]', 'Get MySQL server info', 1042390534);
INSERT INTO php_manual VALUES (1725, 'mysql_info', 'PHP 4 >= 4.3.0', 'string', '[resource link_identifier ]', ' Get information about the most recent query', 1042390534);
INSERT INTO php_manual VALUES (1726, 'mysql_insert_id', 'PHP 3, PHP 4', 'int', '[resource link_identifier ]', ' Get the ID generated from the previous INSERT operation', 1042390534);
INSERT INTO php_manual VALUES (1727, 'mysql_list_dbs', 'PHP 3, PHP 4', 'resource', '[resource link_identifier ]', ' List databases available on a MySQL server', 1042390534);
INSERT INTO php_manual VALUES (1728, 'mysql_list_fields', 'PHP 3, PHP 4', 'resource', 'string database_name, string table_name, [resource link_identifier ]', 'List MySQL result fields', 1042390534);
INSERT INTO php_manual VALUES (1729, 'mysql_list_processes', 'PHP 4 >= 4.3.0', 'resource', '[resource link_identifier ]', 'List MySQL processes', 1042390534);
INSERT INTO php_manual VALUES (1730, 'mysql_list_tables', 'PHP 3, PHP 4', 'resource', 'string database, [resource link_identifier ]', 'List tables in a MySQL database', 1042390534);
INSERT INTO php_manual VALUES (1731, 'mysql_num_fields', 'PHP 3, PHP 4', 'int', 'resource result', 'Get number of fields in result', 1042390534);
INSERT INTO php_manual VALUES (1732, 'mysql_num_rows', 'PHP 3, PHP 4', 'int', 'resource result', 'Get number of rows in result', 1042390534);
INSERT INTO php_manual VALUES (1733, 'mysql_pconnect', 'PHP 3, PHP 4', 'resource', '[string server ], [string username], [string password], [int client_flags]', ' Open a persistent connection to a MySQL server', 1042390534);
INSERT INTO php_manual VALUES (1734, 'mysql_ping', 'PHP 4 >= 4.3.0', 'bool', '[resource link_identifier ]', 'Ping a server connection or reconnect if there is no connection', 1042390535);
INSERT INTO php_manual VALUES (1735, 'mysql_query', 'PHP 3, PHP 4', 'resource', 'string query, [resource link_identifier], [int result_mode]', 'Send a MySQL query', 1042390535);
INSERT INTO php_manual VALUES (1736, 'mysql_real_escape_string', 'PHP 4 >= 4.3.0', 'string', 'string unescaped_string, [resource link_identifier]', ' Escapes special characters in a string for use in a SQL statement, taking into account the current charset of the connection.', 1042390535);
INSERT INTO php_manual VALUES (1737, 'mysql_result', 'PHP 3, PHP 4', 'mixed', 'resource result, int row, [mixed field ]', 'Get result data', 1042390535);
INSERT INTO php_manual VALUES (1738, 'mysql_select_db', 'PHP 3, PHP 4', 'bool', 'string database_name, [resource link_identifier ]', 'Select a MySQL database', 1042390535);
INSERT INTO php_manual VALUES (1739, 'mysql_stat', 'PHP 4 >= 4.3.0', 'string', '[resource link_identifier]', 'Get current system status', 1042390535);
INSERT INTO php_manual VALUES (1740, 'mysql_tablename', 'PHP 3, PHP 4', 'string', 'resource result, int i', 'Get table name of field', 1042390535);
INSERT INTO php_manual VALUES (1741, 'mysql_thread_id', 'PHP 4 >= 4.3.0', 'int', '[resource link_identifier]', 'Return the current thread ID', 1042390535);
INSERT INTO php_manual VALUES (1742, 'mysql_unbuffered_query', 'PHP 4 >= 4.0.6', 'resource', 'string query, [resource link_identifier], [int result_mode]', ' Send an SQL query to MySQL, without fetching and buffering the result rows', 1042390535);
INSERT INTO php_manual VALUES (1743, 'ncurses_addch', 'PHP 4 >= 4.1.0', 'int', 'int ch', 'Add character at current position and advance cursor', 1042390535);
INSERT INTO php_manual VALUES (1744, 'ncurses_addchnstr', 'PHP 4 >= 4.2.0', 'int', 'string s, int n', 'Add attributed string with specified length at current position', 1042390535);
INSERT INTO php_manual VALUES (1745, 'ncurses_addchstr', 'PHP 4 >= 4.2.0', 'int', 'string s', 'Add attributed string at current position', 1042390535);
INSERT INTO php_manual VALUES (1746, 'ncurses_addnstr', 'PHP 4 >= 4.2.0', 'int', 'string s, int n', 'Add string with specified length at current position', 1042390535);
INSERT INTO php_manual VALUES (1747, 'ncurses_addstr', 'PHP 4 >= 4.2.0', 'int', 'string text', 'Output text at current position', 1042390535);
INSERT INTO php_manual VALUES (1748, 'ncurses_assume_default_colors', 'PHP 4 >= 4.2.0', 'int', 'int fg, int bg', 'Define default colors for color 0', 1042390535);
INSERT INTO php_manual VALUES (1749, 'ncurses_attroff', 'PHP 4 >= 4.1.0', 'int', 'int attributes', 'Turn off the given attributes', 1042390535);
INSERT INTO php_manual VALUES (1750, 'ncurses_attron', 'PHP 4 >= 4.1.0', 'int', 'int attributes', 'Turn on the given attributes', 1042390535);
INSERT INTO php_manual VALUES (1751, 'ncurses_attrset', 'PHP 4 >= 4.1.0', 'int', 'int attributes', 'Set given attributes', 1042390535);
INSERT INTO php_manual VALUES (1752, 'ncurses_baudrate', 'PHP 4 >= 4.1.0', 'int', 'void', 'Returns baudrate of terminal', 1042390535);
INSERT INTO php_manual VALUES (1753, 'ncurses_beep', 'PHP 4 >= 4.1.0', 'int', 'void', 'Let the terminal beep', 1042390535);
INSERT INTO php_manual VALUES (1754, 'ncurses_bkgd', 'PHP 4 >= 4.1.0', 'int', 'int attrchar', 'Set background property for terminal screen', 1042390535);
INSERT INTO php_manual VALUES (1755, 'ncurses_bkgdset', 'PHP 4 >= 4.1.0', 'void', 'int attrchar', 'Control screen background', 1042390535);
INSERT INTO php_manual VALUES (1756, 'ncurses_border', 'PHP 4 >= 4.2.0', 'int', 'int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner', 'Draw a border around the screen using attributed characters', 1042390535);
INSERT INTO php_manual VALUES (1757, 'ncurses_cbreak', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Switch of input buffering', 1042390535);
INSERT INTO php_manual VALUES (1758, 'ncurses_mvcur', 'PHP 4 >= 4.2.0', 'int', 'int old_y, int old_x, int new_y, int new_x', 'Move cursor immediately', 1042390535);
INSERT INTO php_manual VALUES (1759, 'ncurses_can_change_color', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Check if we can change terminals colors', 1042390535);
INSERT INTO php_manual VALUES (1760, 'ncurses_clear', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Clear screen', 1042390535);
INSERT INTO php_manual VALUES (1761, 'ncurses_clrtobot', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Clear screen from current position to bottom', 1042390535);
INSERT INTO php_manual VALUES (1762, 'ncurses_clrtoeol', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Clear screen from current position to end of line', 1042390535);
INSERT INTO php_manual VALUES (1763, 'ncurses_color_set', 'PHP 4 >= 4.1.0', 'int', 'int pair', 'Set fore- and background color', 1042390535);
INSERT INTO php_manual VALUES (1764, 'ncurses_curs_set', 'PHP 4 >= 4.1.0', 'int', 'int visibility', 'Set cursor state', 1042390535);
INSERT INTO php_manual VALUES (1765, 'ncurses_def_prog_mode', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Saves terminals (program) mode', 1042390535);
INSERT INTO php_manual VALUES (1766, 'ncurses_def_shell_mode', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Saves terminals (shell) mode', 1042390535);
INSERT INTO php_manual VALUES (1767, 'ncurses_define_key', 'PHP 4 >= 4.2.0', 'int', 'string definition, int keycode', 'Define a keycode', 1042390535);
INSERT INTO php_manual VALUES (1768, 'ncurses_delay_output', 'PHP 4 >= 4.1.0', 'int', 'int milliseconds', 'Delay output on terminal using padding characters', 1042390535);
INSERT INTO php_manual VALUES (1769, 'ncurses_delch', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Delete character at current position, move rest of line left', 1042390535);
INSERT INTO php_manual VALUES (1770, 'ncurses_deleteln', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Delete line at current position, move rest of screen up', 1042390535);
INSERT INTO php_manual VALUES (1771, 'ncurses_delwin', 'PHP 4 >= 4.1.0', 'int', 'resource window', 'Delete a ncurses window', 1042390535);
INSERT INTO php_manual VALUES (1772, 'ncurses_doupdate', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Write all prepared refreshes to terminal', 1042390535);
INSERT INTO php_manual VALUES (1773, 'ncurses_echo', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Activate keyboard input echo', 1042390535);
INSERT INTO php_manual VALUES (1774, 'ncurses_end', 'PHP 4 >= 4.1.0', 'int', 'void', 'Stop using ncurses, clean up the screen', 1042390535);
INSERT INTO php_manual VALUES (1775, 'ncurses_echochar', 'PHP 4 >= 4.1.0', 'int', 'int character', 'Single character output including refresh', 1042390535);
INSERT INTO php_manual VALUES (1776, 'ncurses_erase', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Erase terminal screen', 1042390535);
INSERT INTO php_manual VALUES (1777, 'ncurses_erasechar', 'PHP 4 >= 4.1.0', 'string', 'void', 'Returns current erase character', 1042390535);
INSERT INTO php_manual VALUES (1778, 'ncurses_filter', 'PHP 4 >= 4.1.0', 'int', 'void', '', 1042390535);
INSERT INTO php_manual VALUES (1779, 'ncurses_flash', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Flash terminal screen (visual bell)', 1042390535);
INSERT INTO php_manual VALUES (1780, 'ncurses_flushinp', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Flush keyboard input buffer', 1042390535);
INSERT INTO php_manual VALUES (1781, 'ncurses_getch', 'PHP 4 >= 4.1.0', 'int', 'void', 'Read a character from keyboard', 1042390535);
INSERT INTO php_manual VALUES (1782, 'ncurses_getmouse', 'PHP 4 >= 4.2.0', 'bool', 'array mevent', 'Reads mouse event', 1042390535);
INSERT INTO php_manual VALUES (1783, 'ncurses_halfdelay', 'PHP 4 >= 4.1.0', 'int', 'int tenth', 'Put terminal into halfdelay mode', 1042390535);
INSERT INTO php_manual VALUES (1784, 'ncurses_has_colors', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Check if terminal has colors', 1042390535);
INSERT INTO php_manual VALUES (1785, 'ncurses_has_ic', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Check for insert- and delete-capabilities', 1042390535);
INSERT INTO php_manual VALUES (1786, 'ncurses_has_il', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Check for line insert- and delete-capabilities', 1042390535);
INSERT INTO php_manual VALUES (1787, 'ncurses_has_key', 'PHP 4 >= 4.1.0', 'int', 'int keycode', 'Check for presence of a function key on terminal keyboard', 1042390535);
INSERT INTO php_manual VALUES (1788, 'ncurses_hline', 'PHP 4 >= 4.2.0', 'int', 'int charattr, int n', 'Draw a horizontal line at current position using an attributed character and max. n characters long', 1042390535);
INSERT INTO php_manual VALUES (1789, 'ncurses_inch', 'PHP 4 >= 4.1.0', 'string', 'void', 'Get character and attribute at current position', 1042390535);
INSERT INTO php_manual VALUES (1790, 'ncurses_init_color', 'PHP 4 >= 4.2.0', 'int', 'int color, int r, int g, int b', 'Set new RGB value for color', 1042390535);
INSERT INTO php_manual VALUES (1791, 'ncurses_init_pair', 'PHP 4 >= 4.1.0', 'int', 'int pair, int fg, int bg', 'Allocate a color pair', 1042390535);
INSERT INTO php_manual VALUES (1792, 'ncurses_init', 'PHP 4 >= 4.1.0', 'int', 'void', 'Initialize ncurses', 1042390535);
INSERT INTO php_manual VALUES (1793, 'ncurses_insch', 'PHP 4 >= 4.1.0', 'int', 'int character', 'Insert character moving rest of line including character at current position', 1042390535);
INSERT INTO php_manual VALUES (1794, 'ncurses_insdelln', 'PHP 4 >= 4.1.0', 'int', 'int count', 'Insert lines before current line scrolling down (negative numbers delete and scroll up)', 1042390535);
INSERT INTO php_manual VALUES (1795, 'ncurses_insertln', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Insert a line, move rest of screen down', 1042390535);
INSERT INTO php_manual VALUES (1796, 'ncurses_insstr', 'PHP 4 >= 4.2.0', 'int', 'string text', 'Insert string at current position, moving rest of line right', 1042390535);
INSERT INTO php_manual VALUES (1797, 'ncurses_instr', 'PHP 4 >= 4.2.0', 'int', 'string buffer', 'Reads string from terminal screen', 1042390535);
INSERT INTO php_manual VALUES (1798, 'ncurses_isendwin', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Ncurses is in endwin mode, normal screen output may be performed', 1042390536);
INSERT INTO php_manual VALUES (1799, 'ncurses_keyok', 'PHP 4 >= 4.2.0', 'int', 'int keycode, bool enable', 'Enable or disable a keycode', 1042390536);
INSERT INTO php_manual VALUES (1800, 'ncurses_killchar', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Returns current line kill character', 1042390536);
INSERT INTO php_manual VALUES (1801, 'ncurses_longname', 'PHP 4 >= 4.2.0', 'string', 'void', 'Returns terminals description', 1042390536);
INSERT INTO php_manual VALUES (1802, 'ncurses_mouseinterval', 'PHP 4 >= 4.1.0', 'int', 'int milliseconds', 'Set timeout for mouse button clicks', 1042390536);
INSERT INTO php_manual VALUES (1803, 'ncurses_mousemask', 'PHP 4 >= 4.2.0', 'int', 'int newmask, int oldmask', 'Sets mouse options', 1042390536);
INSERT INTO php_manual VALUES (1804, 'ncurses_move', 'PHP 4 >= 4.1.0', 'int', 'int y, int x', 'Move output position', 1042390536);
INSERT INTO php_manual VALUES (1805, 'ncurses_mvaddch', 'PHP 4 >= 4.2.0', 'int', 'int y, int x, int c', 'Move current position and add character', 1042390536);
INSERT INTO php_manual VALUES (1806, 'ncurses_mvaddchnstr', 'PHP 4 >= 4.2.0', 'int', 'int y, int x, string s, int n', 'Move position and add attrributed string with specified length', 1042390536);
INSERT INTO php_manual VALUES (1807, 'ncurses_mvaddchstr', 'PHP 4 >= 4.2.0', 'int', 'int y, int x, string s', 'Move position and add attributed string', 1042390536);
INSERT INTO php_manual VALUES (1808, 'ncurses_mvaddnstr', 'PHP 4 >= 4.2.0', 'int', 'int y, int x, string s, int n', 'Move position and add string with specified length', 1042390536);
INSERT INTO php_manual VALUES (1809, 'ncurses_mvaddstr', 'PHP 4 >= 4.2.0', 'int', 'int y, int x, string s', 'Move position and add string', 1042390536);
INSERT INTO php_manual VALUES (1810, 'ncurses_mvdelch', 'PHP 4 >= 4.2.0', 'int', 'int y, int x', 'Move position and delete character, shift rest of line left', 1042390536);
INSERT INTO php_manual VALUES (1811, 'ncurses_mvgetch', 'PHP 4 >= 4.2.0', 'int', 'int y, int x', 'Move position and get character at new position', 1042390536);
INSERT INTO php_manual VALUES (1812, 'ncurses_mvhline', 'PHP 4 >= 4.2.0', 'int', 'int y, int x, int attrchar, int n', 'Set new position and draw a horizontal line using an attributed character and max. n characters long', 1042390536);
INSERT INTO php_manual VALUES (1813, 'ncurses_mvinch', 'PHP 4 >= 4.2.0', 'int', 'int y, int x', 'Move position and get attributed character at new position', 1042390536);
INSERT INTO php_manual VALUES (1814, 'ncurses_mvvline', '', 'int', 'int y, int x, int attrchar, int n', 'Set new position and draw a vertical line using an attributed character and max. n characters long', 1042390536);
INSERT INTO php_manual VALUES (1815, 'ncurses_mvwaddstr', 'PHP 4 >= 4.2.0', 'int', 'resource window, int y, int x, string text', 'Add string at new position in window', 1042390536);
INSERT INTO php_manual VALUES (1816, 'ncurses_napms', 'PHP 4 >= 4.1.0', 'int', 'int milliseconds', 'Sleep', 1042390536);
INSERT INTO php_manual VALUES (1817, 'ncurses_newwin', 'PHP 4 >= 4.1.0', 'int', 'int rows, int cols, int y, int x', 'Create a new window', 1042390536);
INSERT INTO php_manual VALUES (1818, 'ncurses_nl', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Translate newline and carriage return / line feed', 1042390536);
INSERT INTO php_manual VALUES (1819, 'ncurses_nocbreak', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Switch terminal to cooked mode', 1042390536);
INSERT INTO php_manual VALUES (1820, 'ncurses_noecho', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Switch off keyboard input echo', 1042390536);
INSERT INTO php_manual VALUES (1821, 'ncurses_nonl', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Do not translate newline and carriage return / line feed', 1042390536);
INSERT INTO php_manual VALUES (1822, 'ncurses_noqiflush', 'PHP 4 >= 4.1.0', 'int', 'void', 'Do not flush on signal characters', 1042390536);
INSERT INTO php_manual VALUES (1823, 'ncurses_noraw', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Switch terminal out of raw mode', 1042390536);
INSERT INTO php_manual VALUES (1824, 'ncurses_putp', 'PHP 4 >= 4.2.0', 'int', 'string text', '', 1042390536);
INSERT INTO php_manual VALUES (1825, 'ncurses_qiflush', 'PHP 4 >= 4.1.0', 'int', 'void', 'Flush on signal characters', 1042390536);
INSERT INTO php_manual VALUES (1826, 'ncurses_raw', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Switch terminal into raw mode', 1042390536);
INSERT INTO php_manual VALUES (1827, 'ncurses_refresh', 'PHP 4 >= 4.1.0', 'int', 'int ch', 'Refresh screen', 1042390536);
INSERT INTO php_manual VALUES (1828, 'ncurses_resetty', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Restores saved terminal state', 1042390536);
INSERT INTO php_manual VALUES (1829, 'ncurses_savetty', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Saves terminal state', 1042390536);
INSERT INTO php_manual VALUES (1830, 'ncurses_scr_dump', 'PHP 4 >= 4.2.0', 'int', 'string filename', 'Dump screen content to file', 1042390536);
INSERT INTO php_manual VALUES (1831, 'ncurses_scr_init', 'PHP 4 >= 4.2.0', 'int', 'string filename', 'Initialize screen from file dump', 1042390536);
INSERT INTO php_manual VALUES (1832, 'ncurses_scr_restore', 'PHP 4 >= 4.2.0', 'int', 'string filename', 'Restore screen from file dump', 1042390536);
INSERT INTO php_manual VALUES (1833, 'ncurses_scr_set', 'PHP 4 >= 4.2.0', 'int', 'string filename', 'Inherit screen from file dump', 1042390536);
INSERT INTO php_manual VALUES (1834, 'ncurses_scrl', 'PHP 4 >= 4.1.0', 'int', 'int count', 'Scroll window content up or down without changing current position', 1042390536);
INSERT INTO php_manual VALUES (1835, 'ncurses_slk_attr', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Returns current soft label key attribute', 1042390536);
INSERT INTO php_manual VALUES (1836, 'ncurses_slk_attroff', 'PHP 4 >= 4.1.0', 'int', 'int intarg', '', 1042390536);
INSERT INTO php_manual VALUES (1837, 'ncurses_slk_attron', 'PHP 4 >= 4.1.0', 'int', 'int intarg', '', 1042390536);
INSERT INTO php_manual VALUES (1838, 'ncurses_slk_attrset', 'PHP 4 >= 4.1.0', 'int', 'int intarg', '', 1042390536);
INSERT INTO php_manual VALUES (1839, 'ncurses_slk_clear', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Clears soft labels from screen', 1042390536);
INSERT INTO php_manual VALUES (1840, 'ncurses_slk_color', 'PHP 4 >= 4.1.0', 'int', 'int intarg', 'Sets color for soft label keys', 1042390536);
INSERT INTO php_manual VALUES (1841, 'ncurses_slk_init', 'PHP 4 >= 4.1.0', 'bool', 'int format', 'Initializes soft label key functions', 1042390536);
INSERT INTO php_manual VALUES (1842, 'ncurses_slk_noutrefresh', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Copies soft label keys to virtual screen', 1042390536);
INSERT INTO php_manual VALUES (1843, 'ncurses_slk_refresh', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Copies soft label keys to screen', 1042390536);
INSERT INTO php_manual VALUES (1844, 'ncurses_slk_restore', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Restores soft label keys', 1042390536);
INSERT INTO php_manual VALUES (1845, 'ncurses_slk_touch', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Fources output when ncurses_slk_noutrefresh is performed', 1042390536);
INSERT INTO php_manual VALUES (1846, 'ncurses_start_color', 'PHP 4 >= 4.1.0', 'int', 'void', 'Start using colors', 1042390536);
INSERT INTO php_manual VALUES (1847, 'ncurses_termattrs', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Returns a logical OR of all attribute flags supported by terminal', 1042390536);
INSERT INTO php_manual VALUES (1848, 'ncurses_termname', 'PHP 4 >= 4.2.0', 'string', 'void', 'Returns terminals (short)-name', 1042390536);
INSERT INTO php_manual VALUES (1849, 'ncurses_timeout', 'PHP 4 >= 4.1.0', 'void', 'int millisec', 'Set timeout for special key sequences', 1042390536);
INSERT INTO php_manual VALUES (1850, 'ncurses_typeahead', 'PHP 4 >= 4.1.0', 'int', 'int fd', 'Specify different filedescriptor for typeahead checking', 1042390536);
INSERT INTO php_manual VALUES (1851, 'ncurses_ungetch', 'PHP 4 >= 4.1.0', 'int', 'int keycode', 'Put a character back into the input stream', 1042390536);
INSERT INTO php_manual VALUES (1852, 'ncurses_ungetmouse', 'PHP 4 >= 4.2.0', 'bool', 'array mevent', 'Pushes mouse event to queue', 1042390536);
INSERT INTO php_manual VALUES (1853, 'ncurses_use_default_colors', 'PHP 4 >= 4.1.0', 'bool', 'void', 'Assign terminal default colors to color id -1', 1042390536);
INSERT INTO php_manual VALUES (1854, 'ncurses_use_env', 'PHP 4 >= 4.1.0', 'void', 'bool flag', 'Control use of environment information about terminal size', 1042390536);
INSERT INTO php_manual VALUES (1855, 'ncurses_vidattr', 'PHP 4 >= 4.1.0', 'int', 'int intarg', '', 1042390536);
INSERT INTO php_manual VALUES (1856, 'ncurses_use_extended_names', 'PHP 4 >= 4.1.0', 'int', 'bool flag', 'Control use of extended names in terminfo descriptions', 1042390536);
INSERT INTO php_manual VALUES (1857, 'ncurses_vline', 'PHP 4 >= 4.2.0', 'int', 'int charattr, int n', 'Draw a vertical line at current position using an attributed character and max. n characters long', 1042390536);
INSERT INTO php_manual VALUES (1858, 'ncurses_wrefresh', 'PHP 4 >= 4.2.0', 'int', 'resource window', 'Refresh window on terminal screen', 1042390536);
INSERT INTO php_manual VALUES (1859, 'checkdnsrr', 'PHP 3, PHP 4', 'int', 'string host, [string type]', ' Check DNS records corresponding to a given Internet host name or IP address', 1042390536);
INSERT INTO php_manual VALUES (1860, 'closelog', 'PHP 3, PHP 4', 'int', 'void', 'Close connection to system logger', 1042390536);
INSERT INTO php_manual VALUES (1861, 'debugger_off', 'PHP 3', 'int', 'void', 'Disable internal PHP debugger (PHP 3)', 1042390536);
INSERT INTO php_manual VALUES (1862, 'debugger_on', 'PHP 3', 'int', 'string address', 'Enable internal PHP debugger (PHP 3)', 1042390536);
INSERT INTO php_manual VALUES (1863, 'define_syslog_variables', 'PHP 3, PHP 4', 'void', 'void', 'Initializes all syslog related constants', 1042390536);
INSERT INTO php_manual VALUES (1864, 'dns_check_record', 'PHP 4  CVS only', 'int', 'string host, [string type]', 'Synonym for checkdnsrr', 1042390536);
INSERT INTO php_manual VALUES (1865, 'dns_get_mx', 'PHP 4  CVS only', 'int', 'string hostname, array mxhosts, [array &weight]', 'Synonym for getmxrr', 1042390536);
INSERT INTO php_manual VALUES (1866, 'dns_get_record', 'PHP 4  CVS only', 'array', 'string hostname, [int type], [array &authns], array &addtl', ' Fetch DNS Resource Records associated with a hostname', 1042390537);
INSERT INTO php_manual VALUES (1867, 'fsockopen', 'PHP 3, PHP 4', 'int', 'string hostname, int port, [int errno], [string errstr], [float timeout]', ' Open Internet or Unix domain socket connection', 1042390537);
INSERT INTO php_manual VALUES (1868, 'gethostbyaddr', 'PHP 3, PHP 4', 'string', 'string ip_address', ' Get the Internet host name corresponding to a given IP address', 1042390537);
INSERT INTO php_manual VALUES (1869, 'gethostbyname', 'PHP 3, PHP 4', 'string', 'string hostname', ' Get the IP address corresponding to a given Internet host name', 1042390537);
INSERT INTO php_manual VALUES (1870, 'gethostbynamel', 'PHP 3, PHP 4', 'array', 'string hostname', ' Get a list of IP addresses corresponding to a given Internet host name', 1042390537);
INSERT INTO php_manual VALUES (1871, 'getmxrr', 'PHP 3, PHP 4', 'int', 'string hostname, array mxhosts, [array weight]', ' Get MX records corresponding to a given Internet host name', 1042390537);
INSERT INTO php_manual VALUES (1872, 'getprotobyname', 'PHP 4', 'int', 'string name', ' Get protocol number associated with protocol name', 1042390537);
INSERT INTO php_manual VALUES (1873, 'getprotobynumber', 'PHP 4', 'string', 'int number', ' Get protocol name associated with protocol number', 1042390537);
INSERT INTO php_manual VALUES (1874, 'getservbyname', 'PHP 4', 'int', 'string service, string protocol', ' Get port number associated with an Internet service and protocol', 1042390537);
INSERT INTO php_manual VALUES (1875, 'getservbyport', 'PHP 4', 'string', 'int port, string protocol', ' Get Internet service which corresponds to port and protocol', 1042390537);
INSERT INTO php_manual VALUES (1876, 'ip2long', 'PHP 4', 'int', 'string ip_address', ' Converts a string containing an (IPv4) Internet Protocol dotted address into a proper address.', 1042390537);
INSERT INTO php_manual VALUES (1877, 'long2ip', 'PHP 4', 'string', 'int proper_address', ' Converts an (IPv4) Internet network address into a string in Internet standard dotted format', 1042390537);
INSERT INTO php_manual VALUES (1878, 'openlog', 'PHP 3, PHP 4', 'int', 'string ident, int option, int facility', 'Open connection to system logger', 1042390537);
INSERT INTO php_manual VALUES (1879, 'pfsockopen', 'PHP 3>= 3.0.7, PHP 4', 'int', 'string hostname, int port, [int errno], [string errstr], [int timeout]', ' Open persistent Internet or Unix domain socket connection', 1042390537);
INSERT INTO php_manual VALUES (1880, 'socket_get_status', 'PHP 4', '', 'void', ' Alias of stream_get_meta_data.', 1042390537);
INSERT INTO php_manual VALUES (1881, 'socket_set_blocking', 'PHP 4', '', 'void', 'Alias for stream_set_blocking', 1042390537);
INSERT INTO php_manual VALUES (1882, 'socket_set_timeout', 'PHP 4', '', 'void', 'Alias for stream_set_timeout', 1042390537);
INSERT INTO php_manual VALUES (1883, 'syslog', 'PHP 3, PHP 4', 'int', 'int priority, string message', 'Generate a system log message', 1042390537);
INSERT INTO php_manual VALUES (1884, 'yp_all', 'PHP 4 >= 4.0.6', 'void', 'string domain, string map, string callback', ' Traverse the map and call a function on each entry', 1042390537);
INSERT INTO php_manual VALUES (1885, 'yp_cat', 'PHP 4 >= 4.0.6', 'array', 'string domain, string map', ' Return an array containing the entire map', 1042390537);
INSERT INTO php_manual VALUES (1886, 'yp_err_string', 'PHP 4 >= 4.0.6', 'string', 'void', ' Returns the error string associated with the previous operation', 1042390537);
INSERT INTO php_manual VALUES (1887, 'yp_errno', 'PHP 4 >= 4.0.6', 'int', 'void', ' Returns the error code of the previous operation', 1042390537);
INSERT INTO php_manual VALUES (1888, 'yp_first', 'PHP 3>= 3.0.7, PHP 4', 'array', 'string domain, string map', ' Returns the first key-value pair from the named map', 1042390537);
INSERT INTO php_manual VALUES (1889, 'yp_master', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string domain, string map', ' Returns the machine name of the master NIS server for a map', 1042390537);
INSERT INTO php_manual VALUES (1890, 'yp_match', 'PHP 3>= 3.0.7, PHP 4', 'string', 'string domain, string map, string key', 'Returns the matched line', 1042390537);
INSERT INTO php_manual VALUES (1891, 'yp_next', 'PHP 3>= 3.0.7, PHP 4', 'array', 'string domain, string map, string key', 'Returns the next key-value pair in the named map.', 1042390537);
INSERT INTO php_manual VALUES (1892, 'yp_order', 'PHP 3>= 3.0.7, PHP 4', 'int', 'string domain, string map', 'Returns the order number for a map', 1042390537);
INSERT INTO php_manual VALUES (1893, 'notes_body', 'PHP 4 >= 4.0.5', 'array', 'string server, string mailbox, int msg_number', 'Open the message msg_number in the specified mailbox on the specified server (leave serv', 1042390537);
INSERT INTO php_manual VALUES (1894, 'notes_copy_db', 'PHP 4 >= 4.0.5', 'string', 'string from_database_name, string to_database_name', 'Create a note using form form_name', 1042390537);
INSERT INTO php_manual VALUES (1895, 'notes_create_db', 'PHP 4 >= 4.0.5', 'bool', 'string database_name', 'Create a Lotus Notes database', 1042390537);
INSERT INTO php_manual VALUES (1896, 'notes_create_note', 'PHP 4 >= 4.0.5', 'string', 'string database_name, string form_name', 'Create a note using form form_name', 1042390537);
INSERT INTO php_manual VALUES (1897, 'notes_drop_db', 'PHP 4 >= 4.0.5', 'bool', 'string database_name', 'Drop a Lotus Notes database', 1042390537);
INSERT INTO php_manual VALUES (1898, 'notes_find_note', 'PHP 4 >= 4.0.5', 'bool', 'string database_name, string name, [string type]', 'Returns a note id found in database_name. Specify the name of the note. Leaving type bla', 1042390537);
INSERT INTO php_manual VALUES (1899, 'notes_header_info', 'PHP 4 >= 4.0.5', 'object', 'string server, string mailbox, int msg_number', 'Open the message msg_number in the specified mailbox on the specified server (leave serv', 1042390537);
INSERT INTO php_manual VALUES (1900, 'notes_list_msgs', 'PHP 4 >= 4.0.5', 'bool', 'string db', 'Returns the notes from a selected database_name', 1042390537);
INSERT INTO php_manual VALUES (1901, 'notes_mark_read', 'PHP 4 >= 4.0.5', 'string', 'string database_name, string user_name, string note_id', 'Mark a note_id as read for the User user_name', 1042390537);
INSERT INTO php_manual VALUES (1902, 'notes_mark_unread', 'PHP 4 >= 4.0.5', 'string', 'string database_name, string user_name, string note_id', 'Mark a note_id as unread for the User user_name', 1042390537);
INSERT INTO php_manual VALUES (1903, 'notes_nav_create', 'PHP 4 >= 4.0.5', 'bool', 'string database_name, string name', 'Create a navigator name, in database_name', 1042390537);
INSERT INTO php_manual VALUES (1904, 'notes_search', 'PHP 4 >= 4.0.5', 'string', 'string database_name, string keywords', 'Find notes that match keywords in database_name', 1042390537);
INSERT INTO php_manual VALUES (1905, 'notes_version', 'PHP 4 >= 4.0.5', 'string', 'string database_name', 'Get the version Lotus Notes', 1042390537);
INSERT INTO php_manual VALUES (1906, 'aggregate_info', 'PHP 4  CVS only', 'array', 'object object', ' returns an associative array of the methods and properties from each class that has been aggregated to the object.', 1042390537);
INSERT INTO php_manual VALUES (1907, 'aggregate_methods_by_list', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name, array methods_list, [boolean exclude]', ' selective dynamic class methods aggregation to an object', 1042390537);
INSERT INTO php_manual VALUES (1908, 'aggregate_methods_by_regexp', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name, string regexp, [boolean exclude]', ' selective class methods aggregation to an object using a regular expression', 1042390537);
INSERT INTO php_manual VALUES (1909, 'aggregate_methods', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name', ' dynamic class and object aggregation of methods', 1042390537);
INSERT INTO php_manual VALUES (1910, 'aggregate_properties_by_list', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name, array properties_list, [boolean exclude]', ' selective dynamic class properties aggregation to an object', 1042390537);
INSERT INTO php_manual VALUES (1911, 'aggregate_properties_by_regexp', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name, string regexp, [boolean exclude]', ' selective class properties aggregation to an object using a regular expression', 1042390538);
INSERT INTO php_manual VALUES (1912, 'aggregate_properties', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name', ' dynamic aggregation of class properties to an object', 1042390538);
INSERT INTO php_manual VALUES (1913, 'aggregate', 'PHP 4 >= 4.2.0', 'void', 'object object, string class_name', ' dynamic class and object aggregation of methods and properties', 1042390538);
INSERT INTO php_manual VALUES (1914, 'aggregation_info', 'PHP 4 >= 4.2.0', 'array', 'object object', 'Synonym for aggregate_info', 1042390538);
INSERT INTO php_manual VALUES (1915, 'deaggregate', 'PHP 4 >= 4.2.0', 'void', 'object object, [string class_name]', ' removes the aggregated methods and properties from an object', 1042390538);
INSERT INTO php_manual VALUES (1916, 'OCIBindByName', 'PHP 3>= 3.0.4, PHP 4', 'bool', 'int stmt, string ph_name, mixed & variable, int length, [int type]', ' Bind a PHP variable to an Oracle Placeholder', 1042390538);
INSERT INTO php_manual VALUES (1917, 'OCICancel', 'PHP 3>= 3.0.8, PHP 4', 'bool', 'int stmt', 'Cancel reading from cursor', 1042390538);
INSERT INTO php_manual VALUES (1918, 'OCICollAppend', 'PHP 4 >= 4.0.6', 'bool', 'object collection, object object', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1919, 'OCICollAssign', 'PHP 4 >= 4.0.6', 'bool', 'object collection, object object', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1920, 'OCICollAssignElem', 'PHP 4 >= 4.0.6', 'bool', 'object collection, string ndx, string val', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1921, 'OCICollGetElem', 'PHP 4 >= 4.0.6', 'string', 'object collection, string ndx', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1922, 'OCICollMax', 'PHP 4 >= 4.0.6', 'int', 'object collection', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1923, 'OCICollSize', 'PHP 4 >= 4.0.6', 'int', 'object collection', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1924, 'OCICollTrim', 'PHP 4 >= 4.0.6', 'bool', 'object collection, int num', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1925, 'OCIColumnIsNULL', 'PHP 3>= 3.0.4, PHP 4', '', 'void', '', 1042390538);
INSERT INTO php_manual VALUES (1926, 'OCIColumnName', 'PHP 3>= 3.0.4, PHP 4', 'string', 'int stmt, int col', 'Returns the name of a column', 1042390538);
INSERT INTO php_manual VALUES (1927, 'OCIColumnPrecision', 'PHP 4', 'int', 'int stmt, int col', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1928, 'OCIColumnScale', 'PHP 4', 'int', 'int stmt, int col', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1929, 'OCIColumnSize', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int stmt, mixed column', 'Return result column size', 1042390538);
INSERT INTO php_manual VALUES (1930, 'OCIColumnType', 'PHP 3>= 3.0.4, PHP 4', 'mixed', 'int stmt, int col', 'Returns the data type of a column', 1042390538);
INSERT INTO php_manual VALUES (1931, 'OCIColumnTypeRaw', 'PHP 4', 'mixed', 'int stmt, int col', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1932, 'OCICommit', 'PHP 3>= 3.0.7, PHP 4', 'bool', 'int connection', 'Commits outstanding transactions', 1042390538);
INSERT INTO php_manual VALUES (1933, 'OCIDefineByName', 'PHP 3>= 3.0.7, PHP 4', 'bool', 'int stmt, string Column-Name, mixed variable, [int type]', ' Use a PHP variable for the define-step during a SELECT', 1042390538);
INSERT INTO php_manual VALUES (1934, 'OCIError', 'PHP 3>= 3.0.7, PHP 4', 'array', '[int stmt|conn|global]', 'Return the last error of stmt|conn|global', 1042390538);
INSERT INTO php_manual VALUES (1935, 'OCIExecute', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int statement, [int mode]', 'Execute a statement', 1042390538);
INSERT INTO php_manual VALUES (1936, 'OCIFetch', 'PHP 3>= 3.0.4, PHP 4', 'bool', 'int statement', 'Fetches the next row into result-buffer', 1042390538);
INSERT INTO php_manual VALUES (1937, 'OCIFetchInto', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int stmt, array & result, [int mode]', 'Fetches the next row into result-array', 1042390538);
INSERT INTO php_manual VALUES (1938, 'OCIFetchStatement', 'PHP 3>= 3.0.8, PHP 4', 'int', 'int stmt, array & variable', 'Fetch all rows of result data into an array', 1042390538);
INSERT INTO php_manual VALUES (1939, 'OCIFreeCollection', 'PHP 4 >= 4.1.0', 'bool', 'object lob', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1940, 'OCIFreeCursor', 'PHP 3>= 3.0.8, PHP 4', 'int', 'int stmt', ' Free all resources associated with a cursor', 1042390538);
INSERT INTO php_manual VALUES (1941, 'OCIFreeDesc', 'PHP 4', 'bool', 'object lob', 'Deletes a large object descriptor', 1042390538);
INSERT INTO php_manual VALUES (1942, 'OCIFreeStatement', 'PHP 3>= 3.0.5, PHP 4', 'bool', 'int stmt', ' Free all resources associated with a statement', 1042390538);
INSERT INTO php_manual VALUES (1943, 'OCIInternalDebug', 'PHP 3>= 3.0.4, PHP 4', 'void', 'int onoff', ' Enables or disables internal debug output', 1042390538);
INSERT INTO php_manual VALUES (1944, 'OCILoadLob', 'PHP 4', 'string', 'object lob', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1945, 'OCILogOff', 'PHP 3>= 3.0.4, PHP 4', 'bool', 'int connection', 'Disconnects from Oracle', 1042390538);
INSERT INTO php_manual VALUES (1946, 'OCILogon', 'PHP 3>= 3.0.4, PHP 4', 'int', 'string username, string password, [string db]', 'Establishes a connection to Oracle', 1042390538);
INSERT INTO php_manual VALUES (1947, 'OCINewCollection', 'PHP 4 >= 4.0.6', 'bool', 'int conn, string tdo, [string shema]', 'Coming soon', 1042390538);
INSERT INTO php_manual VALUES (1948, 'OCINewCursor', 'PHP 3>= 3.0.8, PHP 4', 'int', 'int conn', ' Return a new cursor (Statement-Handle)', 1042390538);
INSERT INTO php_manual VALUES (1949, 'OCINewDescriptor', 'PHP 3>= 3.0.7, PHP 4', 'string', 'int connection, [int type]', ' Initialize a new empty LOB or FILE descriptor', 1042390538);
INSERT INTO php_manual VALUES (1950, 'OCINLogon', 'PHP 3>= 3.0.8, PHP 4', 'int', 'string username, string password, [string db]', 'Establishes a new connection to Oracle', 1042390538);
INSERT INTO php_manual VALUES (1951, 'OCINumCols', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int stmt', ' Return the number of result columns in a statement', 1042390538);
INSERT INTO php_manual VALUES (1952, 'OCIParse', 'PHP 3>= 3.0.4, PHP 4', 'int', 'int conn, string query', 'Parse a query and return a statement', 1042390538);
INSERT INTO php_manual VALUES (1953, 'OCIPLogon', 'PHP 3>= 3.0.8, PHP 4', 'int', 'string username, string password, [string db]', 'Connect to an Oracle database using a persistent connection', 1042390538);
INSERT INTO php_manual VALUES (1954, 'OCIResult', 'PHP 3>= 3.0.4, PHP 4', 'mixed', 'int statement, mixed column', 'Returns column value for fetched row', 1042390538);
INSERT INTO php_manual VALUES (1955, 'OCIRollback', 'PHP 3>= 3.0.7, PHP 4', 'bool', 'int connection', 'Rolls back outstanding transactions', 1042390539);
INSERT INTO php_manual VALUES (1956, 'OCIRowCount', 'PHP 3>= 3.0.7, PHP 4', 'int', 'int statement', 'Gets the number of affected rows', 1042390539);
INSERT INTO php_manual VALUES (1957, 'OCISaveLob', 'PHP 4', 'bool', 'object lob', 'Coming soon', 1042390539);
INSERT INTO php_manual VALUES (1958, 'OCISaveLobFile', 'PHP 4', 'bool', 'object lob', 'Coming soon', 1042390539);
INSERT INTO php_manual VALUES (1959, 'OCIServerVersion', 'PHP 3>= 3.0.4, PHP 4', 'string', 'int conn', 'Return a string containing server version information', 1042390539);
INSERT INTO php_manual VALUES (1960, 'OCISetPrefetch', 'PHP 3>= 3.0.12, PHP 4', 'int', 'int stmt, int rows', 'Sets number of rows to be prefetched', 1042390539);
INSERT INTO php_manual VALUES (1961, 'OCIStatementType', 'PHP 3>= 3.0.5, PHP 4', 'string', 'int stmt', 'Return the type of an OCI statement', 1042390539);
INSERT INTO php_manual VALUES (1962, 'OCIWriteLobToFile', 'PHP 4', 'bool', 'object lob, [string filename], [int start], [int lenght]', 'Coming soon', 1042390539);
INSERT INTO php_manual VALUES (1963, 'openssl_csr_export_to_file', 'PHP 4 >= 4.2.0', 'bool', 'resource csr, string outfilename, [bool notext]', 'Exports a CSR to a file', 1042390539);
INSERT INTO php_manual VALUES (1964, 'openssl_csr_export', 'PHP 4 >= 4.2.0', 'bool', 'resource csr, string &out, [bool notext]', 'Exports a CSR as a string', 1042390539);
INSERT INTO php_manual VALUES (1965, 'openssl_csr_new', 'PHP 4 >= 4.2.0', 'bool', 'array dn, resource privkey, [array configargs], [array extraattribs]', 'Generates a CSR', 1042390539);
INSERT INTO php_manual VALUES (1966, 'openssl_csr_sign', 'PHP 4 >= 4.2.0', 'resource', 'mixed csr, mixed cacert, mixed priv_key, long days', 'Sign a CSR with another certificate (or itself) and generate a certificate', 1042390539);
INSERT INTO php_manual VALUES (1967, 'openssl_error_string', 'PHP 4 >= 4.0.6', 'mixed', 'void', 'Return openSSL error message', 1042390539);
INSERT INTO php_manual VALUES (1968, 'openssl_free_key', 'PHP 4 >= 4.0.4', 'void', 'resource key_identifier', 'Free key resource', 1042390539);
INSERT INTO php_manual VALUES (1969, 'openssl_get_privatekey', 'PHP 4 >= 4.0.4', 'resource', 'mixed key, [string passphrase]', 'Get a private key', 1042390539);
INSERT INTO php_manual VALUES (1970, 'openssl_get_publickey', 'PHP 4 >= 4.0.4', 'resource', 'mixed certificate', 'Extract public key from certificate and prepare it for use', 1042390539);
INSERT INTO php_manual VALUES (1971, 'openssl_open', 'PHP 4 >= 4.0.4', 'bool', 'string sealed_data, string open_data, string env_key, mixed priv_key_id', 'Open sealed data', 1042390539);
INSERT INTO php_manual VALUES (1972, 'openssl_pkcs7_decrypt', 'PHP 4 >= 4.0.6', 'bool', 'string infilename, string outfilename, mixed recipcert, [mixed recipkey]', 'Decrypts an S/MIME encrypted message', 1042390539);
INSERT INTO php_manual VALUES (1973, 'openssl_pkcs7_encrypt', 'PHP 4 >= 4.0.6', 'bool', 'string infile, string outfile, mixed recipcerts, array headers, [long flags]', 'Encrypt an S/MIME message', 1042390539);
INSERT INTO php_manual VALUES (1974, 'openssl_pkcs7_sign', 'PHP 4 >= 4.0.6', 'bool', 'string infilename, string outfilename, mixed signcert, mixed privkey, array headers, [long flags], [string extracertsfilename]', 'sign an S/MIME message', 1042390539);
INSERT INTO php_manual VALUES (1975, 'openssl_pkcs7_verify', 'PHP 4 >= 4.0.6', 'bool', 'string filename, int flags, [string outfilename], [array cainfo], [string extracerts]', 'Verifies the signature of an S/MIME signed message', 1042390539);
INSERT INTO php_manual VALUES (1976, 'openssl_pkey_export_to_file', 'PHP 4 >= 4.2.0', 'bool', 'mixed key, string outfilename, [string passphrase], [array configargs]', 'Gets an exportable representation of a key into a file', 1042390539);
INSERT INTO php_manual VALUES (1977, 'openssl_pkey_export', 'PHP 4 >= 4.2.0', 'bool', 'mixed key, string &out, [string passphrase], [array configargs]', 'Gets an exportable representation of a key into a string', 1042390539);
INSERT INTO php_manual VALUES (1978, 'openssl_pkey_get_private', 'PHP 4 >= 4.2.0', 'resource', 'mixed key, [string passphrase]', 'Get a private key', 1042390539);
INSERT INTO php_manual VALUES (1979, 'openssl_pkey_get_public', 'PHP 4 >= 4.2.0', 'resource', 'mixed certificate', 'Extract public key from certificate and prepare it for use', 1042390539);
INSERT INTO php_manual VALUES (1980, 'openssl_pkey_new', 'PHP 4 >= 4.2.0', 'resource', '[array configargs]', 'Generates a new private key', 1042390539);
INSERT INTO php_manual VALUES (1981, 'openssl_private_decrypt', 'PHP 4 >= 4.0.6', 'bool', 'string data, string &decrypted, mixed key, [int padding]', 'Decrypts data with private key', 1042390539);
INSERT INTO php_manual VALUES (1982, 'openssl_private_encrypt', 'PHP 4 >= 4.0.6', 'bool', 'string data, string crypted, mixed key, [int padding]', 'Encrypts data with private key', 1042390539);
INSERT INTO php_manual VALUES (1983, 'openssl_public_decrypt', 'PHP 4 >= 4.0.6', 'bool', 'string data, string crypted, resource key, [int padding]', 'Decrypts data with public key', 1042390539);
INSERT INTO php_manual VALUES (1984, 'openssl_public_encrypt', 'PHP 4 >= 4.0.6', 'bool', 'string data, string crypted, mixed key, [int padding]', 'Encrypts data with public key', 1042390539);
INSERT INTO php_manual VALUES (1985, 'openssl_seal', 'PHP 4 >= 4.0.4', 'int', 'string data, string sealed_data, array env_keys, array pub_key_ids', 'Seal (encrypt) data', 1042390539);
INSERT INTO php_manual VALUES (1986, 'openssl_sign', 'PHP 4 >= 4.0.4', 'bool', 'string data, string signature, mixed priv_key_id', 'Generate signature', 1042390539);
INSERT INTO php_manual VALUES (1987, 'openssl_verify', 'PHP 4 >= 4.0.4', 'int', 'string data, string signature, mixed pub_key_id', 'Verify signature', 1042390539);
INSERT INTO php_manual VALUES (1988, 'openssl_x509_check_private_key', 'PHP 4 >= 4.2.0', 'bool', 'mixed cert, mixed key', 'Checks if a private key corresponds to a certificate', 1042390539);
INSERT INTO php_manual VALUES (1989, 'openssl_x509_checkpurpose', 'PHP 4 >= 4.0.6', 'bool', 'mixed x509cert, int purpose, array cainfo, [string untrustedfile]', 'Verifies if a certificate can be used for a particular purpose', 1042390539);
INSERT INTO php_manual VALUES (1990, 'openssl_x509_export_to_file', 'PHP 4 >= 4.2.0', 'bool', 'mixed x509, string outfilename, [bool notext]', 'Exports a certificate to file', 1042390539);
INSERT INTO php_manual VALUES (1991, 'openssl_x509_export', 'PHP 4 >= 4.2.0', 'bool', 'mixed x509, string &output, [bool notext]', 'Exports a certificate as a string', 1042390539);
INSERT INTO php_manual VALUES (1992, 'openssl_x509_free', 'PHP 4 >= 4.0.6', 'void', 'resource x509cert', 'Free certificate resource', 1042390539);
INSERT INTO php_manual VALUES (1993, 'openssl_x509_parse', 'PHP 4 >= 4.0.6', 'array', 'mixed x509cert, [bool shortnames]', 'Parse an X509 certificate and return the information as an array', 1042390539);
INSERT INTO php_manual VALUES (1994, 'openssl_x509_read', 'PHP 4 >= 4.0.6', 'resource', 'mixed x509certdata', 'Parse an X.509 certificate and return a resource identifier for it', 1042390539);
INSERT INTO php_manual VALUES (1995, 'Ora_Bind', 'PHP 3, PHP 4', 'int', 'int cursor, string PHP variable name, string SQL parameter name, int length, [int type]', 'bind a PHP variable to an Oracle parameter', 1042390539);
INSERT INTO php_manual VALUES (1996, 'Ora_Close', 'PHP 3, PHP 4', 'int', 'int cursor', 'close an Oracle cursor', 1042390539);
INSERT INTO php_manual VALUES (1997, 'Ora_ColumnName', 'PHP 3, PHP 4', 'string', 'int cursor, int column', 'get name of Oracle result column', 1042390539);
INSERT INTO php_manual VALUES (1998, 'Ora_ColumnSize', 'PHP 3, PHP 4', 'int', 'int cursor, int column', 'get size of Oracle result column', 1042390539);
INSERT INTO php_manual VALUES (1999, 'Ora_ColumnType', 'PHP 3, PHP 4', 'string', 'int cursor, int column', 'get type of Oracle result column', 1042390539);
INSERT INTO php_manual VALUES (2000, 'Ora_Commit', 'PHP 3, PHP 4', 'int', 'int conn', 'commit an Oracle transaction', 1042390540);
INSERT INTO php_manual VALUES (2001, 'Ora_CommitOff', 'PHP 3, PHP 4', 'int', 'int conn', 'disable automatic commit', 1042390540);
INSERT INTO php_manual VALUES (2002, 'Ora_CommitOn', 'PHP 3, PHP 4', 'int', 'int conn', 'enable automatic commit', 1042390540);
INSERT INTO php_manual VALUES (2003, 'Ora_Do', 'PHP 3, PHP 4', 'int', 'int conn, string query', 'Parse, Exec, Fetch', 1042390540);
INSERT INTO php_manual VALUES (2004, 'Ora_Error', 'PHP 3, PHP 4', 'string', 'int cursor_or_connection', 'get Oracle error message', 1042390540);
INSERT INTO php_manual VALUES (2005, 'Ora_ErrorCode', 'PHP 3, PHP 4', 'int', 'int cursor_or_connection', 'get Oracle error code', 1042390540);
INSERT INTO php_manual VALUES (2006, 'Ora_Exec', 'PHP 3, PHP 4', 'int', 'int cursor', 'execute parsed statement on an Oracle cursor', 1042390540);
INSERT INTO php_manual VALUES (2007, 'Ora_Fetch_Into', 'PHP 3, PHP 4', 'int', 'int cursor, array result, [int flags ]', 'Fetch a row into the specified result array', 1042390540);
INSERT INTO php_manual VALUES (2008, 'Ora_Fetch', 'PHP 3, PHP 4', 'int', 'int cursor', 'fetch a row of data from a cursor', 1042390540);
INSERT INTO php_manual VALUES (2009, 'Ora_GetColumn', 'PHP 3, PHP 4', 'mixed', 'int cursor, mixed column', 'get data from a fetched column', 1042390540);
INSERT INTO php_manual VALUES (2010, 'Ora_Logoff', 'PHP 3, PHP 4', 'int', 'int connection', 'close an Oracle connection', 1042390540);
INSERT INTO php_manual VALUES (2011, 'Ora_Logon', 'PHP 3, PHP 4', 'int', 'string user, string password', 'open an Oracle connection', 1042390540);
INSERT INTO php_manual VALUES (2012, 'Ora_Numcols', 'PHP 3, PHP 4', 'int', 'int cursor_ind', 'Returns the number of columns', 1042390540);
INSERT INTO php_manual VALUES (2013, 'Ora_Numrows', 'PHP 3, PHP 4', 'int', 'int cursor_ind', 'Returns the number of rows', 1042390540);
INSERT INTO php_manual VALUES (2014, 'Ora_Open', 'PHP 3, PHP 4', 'int', 'int connection', 'open an Oracle cursor', 1042390540);
INSERT INTO php_manual VALUES (2015, 'Ora_Parse', 'PHP 3, PHP 4', 'int', 'int cursor_ind, string sql_statement, int defer', 'parse an SQL statement', 1042390540);
INSERT INTO php_manual VALUES (2016, 'Ora_pLogon', 'PHP 3, PHP 4', 'int', 'string user, string password', ' Open a persistent Oracle connection', 1042390540);
INSERT INTO php_manual VALUES (2017, 'Ora_Rollback', 'PHP 3, PHP 4', 'int', 'int connection', 'roll back transaction', 1042390540);
INSERT INTO php_manual VALUES (2018, 'flush', 'PHP 3, PHP 4', 'void', 'void', 'Flush the output buffer', 1042390540);
INSERT INTO php_manual VALUES (2019, 'ob_clean', 'PHP 4 >= 4.2.0', 'void', 'void', ' Clean (erase) the output buffer', 1042390540);
INSERT INTO php_manual VALUES (2020, 'ob_end_clean', 'PHP 4', 'void', 'void', ' Clean (erase) the output buffer and turn off output buffering', 1042390540);
INSERT INTO php_manual VALUES (2021, 'ob_end_flush', 'PHP 4', 'void', 'void', ' Flush (send) the output buffer and turn off output buffering', 1042390540);
INSERT INTO php_manual VALUES (2022, 'ob_flush', 'PHP 4 >= 4.2.0', 'void', 'void', ' Flush (send) the output buffer', 1042390540);
INSERT INTO php_manual VALUES (2023, 'ob_get_contents', 'PHP 4', 'string', 'void', ' Return the contents of the output buffer', 1042390540);
INSERT INTO php_manual VALUES (2024, 'ob_get_length', 'PHP 4 >= 4.0.2', 'string', 'void', ' Return the length of the output buffer', 1042390540);
INSERT INTO php_manual VALUES (2025, 'ob_get_level', 'PHP 4 >= 4.2.0', 'int', 'void', ' Return the nesting level of the output buffering mechanism', 1042390540);
INSERT INTO php_manual VALUES (2026, 'ob_get_status', 'PHP 4 >= 4.2.0', 'array', '[bool full_status]', ' Get status of output buffers', 1042390540);
INSERT INTO php_manual VALUES (2027, 'ob_gzhandler', 'PHP 4 >= 4.0.4', 'string', 'string buffer, [int mode]', ' ob_start callback function to gzip output buffer', 1042390540);
INSERT INTO php_manual VALUES (2028, 'ob_implicit_flush', 'PHP 4', 'void', '[int flag]', ' Turn implicit flush on/off', 1042390540);
INSERT INTO php_manual VALUES (2029, 'ob_start', 'PHP 4', 'void', '[string output_callback ]', 'Turn on output buffering', 1042390540);
INSERT INTO php_manual VALUES (2030, 'overload', 'PHP 4 >= 4.2.0', 'void', '[string class_name]', 'Enable property and method call overloading for a class', 1042390540);
INSERT INTO php_manual VALUES (2031, 'ovrimos_close', 'PHP 4 >= 4.0.3', 'void', 'int connection', 'Closes the connection to ovrimos', 1042390540);
INSERT INTO php_manual VALUES (2032, 'ovrimos_commit', 'PHP 4 >= 4.0.3', 'int', 'int connection_id', 'Commits the transaction', 1042390540);
INSERT INTO php_manual VALUES (2033, 'ovrimos_connect', 'PHP 4 >= 4.0.3', 'int', 'string host, string db, string user, string password', 'Connect to the specified database', 1042390540);
INSERT INTO php_manual VALUES (2034, 'ovrimos_cursor', 'PHP 4 >= 4.0.3', 'int', 'int result_id', 'Returns the name of the cursor', 1042390540);
INSERT INTO php_manual VALUES (2035, 'ovrimos_exec', 'PHP 4 >= 4.0.3', 'int', 'int connection_id, string query', 'Executes an SQL statement', 1042390540);
INSERT INTO php_manual VALUES (2036, 'ovrimos_execute', 'PHP 4 >= 4.0.3', 'bool', 'int result_id, [array parameters_array]', 'Executes a prepared SQL statement', 1042390540);
INSERT INTO php_manual VALUES (2037, 'ovrimos_fetch_into', 'PHP 4 >= 4.0.3', 'bool', 'int result_id, array result_array, [string how], [int rownumber]', 'Fetches a row from the result set', 1042390540);
INSERT INTO php_manual VALUES (2038, 'ovrimos_fetch_row', 'PHP 4 >= 4.0.3', 'bool', 'int result_id, [int how], [int row_number]', 'Fetches a row from the result set', 1042390540);
INSERT INTO php_manual VALUES (2039, 'ovrimos_field_len', 'PHP 4 >= 4.0.3', 'int', 'int result_id, int field_number', 'Returns the length of the output column', 1042390540);
INSERT INTO php_manual VALUES (2040, 'ovrimos_field_name', 'PHP 4 >= 4.0.3', 'int', 'int result_id, int field_number', 'Returns the output column name', 1042390540);
INSERT INTO php_manual VALUES (2041, 'ovrimos_field_num', 'PHP 4 >= 4.0.3', 'int', 'int result_id, string field_name', ' Returns the (1-based) index of the output column', 1042390540);
INSERT INTO php_manual VALUES (2042, 'ovrimos_field_type', 'PHP 4 >= 4.0.3', 'int', 'int result_id, int field_number', ' Returns the (numeric) type of the output column', 1042390540);
INSERT INTO php_manual VALUES (2043, 'ovrimos_free_result', 'PHP 4 >= 4.0.3', 'bool', 'int result_id', 'Frees the specified result_id', 1042390540);
INSERT INTO php_manual VALUES (2044, 'ovrimos_longreadlen', 'PHP 4 >= 4.0.3', 'int', 'int result_id, int length', ' Specifies how many bytes are to be retrieved from long datatypes', 1042390540);
INSERT INTO php_manual VALUES (2045, 'ovrimos_prepare', 'PHP 4 >= 4.0.3', 'int', 'int connection_id, string query', 'Prepares an SQL statement', 1042390540);
INSERT INTO php_manual VALUES (2046, 'ovrimos_num_fields', 'PHP 4 >= 4.0.3', 'int', 'int result_id', 'Returns the number of columns', 1042390540);
INSERT INTO php_manual VALUES (2047, 'ovrimos_num_rows', 'PHP 4 >= 4.0.3', 'int', 'int result_id', ' Returns the number of rows affected by update operations', 1042390540);
INSERT INTO php_manual VALUES (2048, 'ovrimos_result_all', 'PHP 4 >= 4.0.3', 'bool', 'int result_id, [string format]', ' Prints the whole result set as an HTML table', 1042390540);
INSERT INTO php_manual VALUES (2049, 'ovrimos_result', 'PHP 4 >= 4.0.3', 'int', 'int result_id, mixed field', 'Retrieves the output column', 1042390541);
INSERT INTO php_manual VALUES (2050, 'ovrimos_rollback', 'PHP 4 >= 4.0.3', 'int', 'int connection_id', 'Rolls back the transaction', 1042390541);
INSERT INTO php_manual VALUES (2051, 'pcntl_exec', 'PHP 4 >= 4.2.0', 'bool', 'string path, [array args], [array envs]', ' Executes specified program in current process space', 1042390541);
INSERT INTO php_manual VALUES (2052, 'pcntl_fork', 'PHP 4 >= 4.1.0', 'int', 'void', 'Forks the currently running process', 1042390541);
INSERT INTO php_manual VALUES (2053, 'pcntl_signal', 'PHP 4 >= 4.1.0', 'bool', 'int signo, mixed handle', 'Installs a signal handler', 1042390541);
INSERT INTO php_manual VALUES (2054, 'pcntl_waitpid', 'PHP 4 >= 4.1.0', 'int', 'int pid, int status, int options', 'Waits on or returns the status of a forked child', 1042390541);
INSERT INTO php_manual VALUES (2055, 'pcntl_wexitstatus', 'PHP 4 >= 4.1.0', 'int', 'int status', ' Returns the return code of a terminated child', 1042390541);
INSERT INTO php_manual VALUES (2056, 'pcntl_wifexited', 'PHP 4 >= 4.1.0', '', 'void', '', 1042390541);
INSERT INTO php_manual VALUES (2057, 'pcntl_wifsignaled', 'PHP 4 >= 4.1.0', '', 'void', '', 1042390541);
INSERT INTO php_manual VALUES (2058, 'pcntl_wifstopped', 'PHP 4 >= 4.1.0', '', 'void', '', 1042390541);
INSERT INTO php_manual VALUES (2059, 'pcntl_wstopsig', 'PHP 4 >= 4.1.0', 'int', 'int status', ' Returns the signal which caused the child to stop', 1042390541);
INSERT INTO php_manual VALUES (2060, 'pcntl_wtermsig', 'PHP 4 >= 4.1.0', 'int', 'int status', ' Returns the signal which caused the child to terminate', 1042390541);
INSERT INTO php_manual VALUES (2061, 'Pattern Modifiers', '', '', 'void', 'Describes possible modifiers in regex patterns', 1042390541);
INSERT INTO php_manual VALUES (2062, 'Pattern Syntax', '', '', 'void', 'Describes PCRE regex syntax', 1042390541);
INSERT INTO php_manual VALUES (2063, 'preg_grep', 'PHP 4', 'array', 'string pattern, array input', ' Return array entries that match the pattern', 1042390541);
INSERT INTO php_manual VALUES (2064, 'preg_match_all', 'PHP 3>= 3.0.9, PHP 4', 'int', 'string pattern, string subject, array matches, [int flags]', 'Perform a global regular expression match', 1042390541);
INSERT INTO php_manual VALUES (2065, 'preg_match', 'PHP 3>= 3.0.9, PHP 4', 'int', 'string pattern, string subject, [array matches], [int flags]', 'Perform a regular expression match', 1042390541);
INSERT INTO php_manual VALUES (2066, 'preg_quote', 'PHP 3>= 3.0.9, PHP 4', 'string', 'string str, [string delimiter]', 'Quote regular expression characters', 1042390541);
INSERT INTO php_manual VALUES (2067, 'preg_replace_callback', 'PHP 4 >= 4.0.5', 'mixed', 'mixed pattern, callback callback, mixed subject, [int limit]', 'Perform a regular expression search and replace using a callback', 1042390541);
INSERT INTO php_manual VALUES (2068, 'preg_replace', 'PHP 3>= 3.0.9, PHP 4', 'mixed', 'mixed pattern, mixed replacement, mixed subject, [int limit]', 'Perform a regular expression search and replace', 1042390541);
INSERT INTO php_manual VALUES (2069, 'preg_split', 'PHP 3>= 3.0.9, PHP 4', 'array', 'string pattern, string subject, [int limit], [int flags]', 'Split string by a regular expression', 1042390541);
INSERT INTO php_manual VALUES (2070, 'pdf_add_annotation', 'PHP 3>= 3.0.12, PHP 4', '', 'void', 'Deprecated: Adds annotation', 1042390541);
INSERT INTO php_manual VALUES (2071, 'pdf_add_bookmark', 'PHP 4 >= 4.0.1', 'int', 'int pdf object, string text, [int parent], [int open]', 'Adds bookmark for current page', 1042390541);
INSERT INTO php_manual VALUES (2072, 'pdf_add_launchlink', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, float llx, float lly, float urx, float ury, string filename', 'Add a launch annotation for current page', 1042390541);
INSERT INTO php_manual VALUES (2073, 'pdf_add_locallink', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, float llx, float lly, float urx, float ury, int page, string dest', 'Add a link annotation for current page', 1042390541);
INSERT INTO php_manual VALUES (2074, 'pdf_add_note', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, float llx, float lly, float urx, float ury, string contents, string title, string icon, int open', 'Add a note annotation for current page', 1042390541);
INSERT INTO php_manual VALUES (2075, 'pdf_add_outline', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Adds bookmark for current page', 1042390541);
INSERT INTO php_manual VALUES (2076, 'pdf_add_pdflink', 'PHP 3>= 3.0.12, PHP 4', 'int', 'int pdf object, float llx, float lly, float urx, float ury, string filename, int page, string dest', 'Adds file link annotation for current page', 1042390541);
INSERT INTO php_manual VALUES (2077, 'pdf_add_thumbnail', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, int image', 'Adds thumbnail for current page', 1042390541);
INSERT INTO php_manual VALUES (2078, 'pdf_add_weblink', 'PHP 3>= 3.0.12, PHP 4', 'int', 'int pdf object, float llx, float lly, float urx, float ury, string url', 'Adds weblink for current page', 1042390541);
INSERT INTO php_manual VALUES (2079, 'pdf_arc', 'PHP 3>= 3.0.6, PHP 4', 'void', 'resource pdf object, float x, float y, float r, float alpha, float beta', 'Draws an arc (counterclockwise)', 1042390541);
INSERT INTO php_manual VALUES (2080, 'pdf_arcn', 'PHP 4 >= 4.0.5', 'void', 'resource pdf object, float x, float y, float r, float alpha, float beta', 'Draws an arc (clockwise)', 1042390541);
INSERT INTO php_manual VALUES (2081, 'pdf_attach_file', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, float llx, float lly, float urx, float ury, string filename, string description, string author, string mimetype, string icon', 'Adds a file attachement for current page', 1042390542);
INSERT INTO php_manual VALUES (2082, 'pdf_begin_page', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float width, float height', 'Starts new page', 1042390542);
INSERT INTO php_manual VALUES (2083, 'pdf_begin_pattern', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, float width, float height, float xstep, float ystep, int painttype', 'Starts new pattern', 1042390542);
INSERT INTO php_manual VALUES (2084, 'pdf_begin_template', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, float width, float height', 'Starts new template', 1042390542);
INSERT INTO php_manual VALUES (2085, 'pdf_circle', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x, float y, float r', 'Draws a circle', 1042390542);
INSERT INTO php_manual VALUES (2086, 'pdf_clip', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Clips to current path', 1042390542);
INSERT INTO php_manual VALUES (2087, 'pdf_close_image', 'PHP 3>= 3.0.7, PHP 4', 'void', 'int pdf object, int image', 'Closes an image', 1042390542);
INSERT INTO php_manual VALUES (2088, 'pdf_close_pdi_page', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, int pagehandle', ' Close the page handle', 1042390542);
INSERT INTO php_manual VALUES (2089, 'pdf_close_pdi', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, int dochandle', ' Close the input PDF document', 1042390542);
INSERT INTO php_manual VALUES (2090, 'pdf_close', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Closes a pdf object', 1042390542);
INSERT INTO php_manual VALUES (2091, 'pdf_closepath_fill_stroke', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Closes, fills and strokes current path', 1042390542);
INSERT INTO php_manual VALUES (2092, 'pdf_closepath_stroke', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Closes path and draws line along path', 1042390542);
INSERT INTO php_manual VALUES (2093, 'pdf_closepath', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Closes path', 1042390542);
INSERT INTO php_manual VALUES (2094, 'pdf_concat', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, float a, float b, float c, float d, float e, float f', 'Concatenate a matrix to the CTM', 1042390542);
INSERT INTO php_manual VALUES (2095, 'pdf_continue_text', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, string text', 'Outputs text in next line', 1042390542);
INSERT INTO php_manual VALUES (2096, 'pdf_curveto', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x1, float y1, float x2, float y2, float x3, float y3', 'Draws a curve', 1042390542);
INSERT INTO php_manual VALUES (2097, 'pdf_delete', 'PHP 4 >= 4.0.5', 'void', 'int pdf object', 'Deletes a PDF object', 1042390542);
INSERT INTO php_manual VALUES (2098, 'pdf_end_page', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Ends a page', 1042390542);
INSERT INTO php_manual VALUES (2099, 'pdf_end_pattern', 'PHP 4 >= 4.0.5', 'void', 'int pdf object', 'Finish pattern', 1042390542);
INSERT INTO php_manual VALUES (2100, 'pdf_end_template', 'PHP 4 >= 4.0.5', 'void', 'int pdf object', 'Finish template', 1042390542);
INSERT INTO php_manual VALUES (2101, 'pdf_endpath', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Ends current path', 1042390542);
INSERT INTO php_manual VALUES (2102, 'pdf_fill_stroke', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Fills and strokes current path', 1042390542);
INSERT INTO php_manual VALUES (2103, 'pdf_fill', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Fills current path', 1042390542);
INSERT INTO php_manual VALUES (2104, 'pdf_findfont', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, string fontname, string encoding, int embed', 'Prepare font for later use with pdf_setfont.', 1042390542);
INSERT INTO php_manual VALUES (2105, 'pdf_get_buffer', 'PHP 4 >= 4.0.5', 'string', 'int pdf object', 'Fetch the buffer containig the generated PDF data.', 1042390542);
INSERT INTO php_manual VALUES (2106, 'pdf_get_font', 'PHP 4', '', 'void', 'Deprecated: font handling', 1042390542);
INSERT INTO php_manual VALUES (2107, 'pdf_get_fontname', 'PHP 4', '', 'void', 'Deprecated: font handling', 1042390542);
INSERT INTO php_manual VALUES (2108, 'pdf_get_fontsize', 'PHP 4', '', 'void', 'Deprecated: font handling', 1042390542);
INSERT INTO php_manual VALUES (2109, 'pdf_get_image_height', 'PHP 3>= 3.0.12, PHP 4', 'string', 'int pdf object, int image', 'Returns height of an image', 1042390542);
INSERT INTO php_manual VALUES (2110, 'pdf_get_image_width', 'PHP 3>= 3.0.12, PHP 4', 'string', 'int pdf object, int image', 'Returns width of an image', 1042390542);
INSERT INTO php_manual VALUES (2111, 'pdf_get_majorversion', 'PHP 4 >= 4.2.0', 'int', 'void', ' Returns the major version number of the PDFlib', 1042390542);
INSERT INTO php_manual VALUES (2112, 'pdf_get_minorversion', 'PHP 4 >= 4.2.0', 'int', 'void', ' Returns the minor version number of the PDFlib', 1042390542);
INSERT INTO php_manual VALUES (2113, 'pdf_get_parameter', 'PHP 4 >= 4.0.1', 'string', 'int pdf object, string key, [float modifier]', 'Gets certain parameters', 1042390542);
INSERT INTO php_manual VALUES (2114, 'pdf_get_pdi_parameter', 'PHP 4 >= 4.0.5', 'string', 'int pdf object, string key, int doc, int page, int index', 'Get some PDI string parameters', 1042390542);
INSERT INTO php_manual VALUES (2115, 'pdf_get_pdi_value', 'PHP 4 >= 4.0.5', 'string', 'int pdf object, string key, int doc, int page, int index', 'Gets some PDI numerical parameters', 1042390542);
INSERT INTO php_manual VALUES (2116, 'pdf_get_value', 'PHP 4 >= 4.0.1', 'float', 'int pdf object, string key, [float modifier]', 'Gets certain numerical value', 1042390542);
INSERT INTO php_manual VALUES (2117, 'pdf_initgraphics', 'PHP 4 >= 4.0.5', 'void', 'int pdf object', 'Resets graphic state', 1042390542);
INSERT INTO php_manual VALUES (2118, 'pdf_lineto', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x, float y', 'Draws a line', 1042390542);
INSERT INTO php_manual VALUES (2119, 'pdf_makespotcolor', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, string spotname', 'Makes a spotcolor', 1042390542);
INSERT INTO php_manual VALUES (2120, 'pdf_moveto', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x, float y', 'Sets current point', 1042390542);
INSERT INTO php_manual VALUES (2121, 'pdf_new', 'PHP 4 >= 4.0.5', 'int', '', 'Creates a new pdf object', 1042390542);
INSERT INTO php_manual VALUES (2122, 'pdf_open_CCITT', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, string filename, int width, int height, int BitReverse, int k, int Blackls1', 'Opens a new image file with raw CCITT data', 1042390542);
INSERT INTO php_manual VALUES (2123, 'pdf_open_file', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, [string filename]', 'Opens a new pdf object', 1042390542);
INSERT INTO php_manual VALUES (2124, 'pdf_open_gif', 'PHP 3>= 3.0.7, PHP 4', '', 'void', 'Deprecated: Opens a GIF image', 1042390542);
INSERT INTO php_manual VALUES (2125, 'pdf_open_image_file', 'PHP 3 CVS only, PHP 4', 'int', 'int PDF-document, string imagetype, string filename, [string stringparam], [string intparam]', 'Reads an image from a file', 1042390542);
INSERT INTO php_manual VALUES (2126, 'pdf_open_image', 'PHP 4 >= 4.0.5', 'int', 'int PDF-document, string imagetype, string source, string data, long length, int width, int height, int components, int bpc, string params', 'Versatile function for images', 1042390542);
INSERT INTO php_manual VALUES (2127, 'pdf_open_jpeg', 'PHP 3>= 3.0.7, PHP 4', '', 'void', 'Deprecated: Opens a JPEG image', 1042390542);
INSERT INTO php_manual VALUES (2128, 'pdf_open_pdi_page', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, int dochandle, int pagenumber, string pagelabel', ' Prepare a page', 1042390542);
INSERT INTO php_manual VALUES (2129, 'pdf_open_pdi', 'PHP 4 >= 4.0.5', 'int', 'int pdf object, string filename, string stringparam, int intparam', ' Opens a PDF file', 1042390542);
INSERT INTO php_manual VALUES (2130, 'pdf_open_png', 'PHP 4', '', 'void', ' Deprecated: Opens a PNG image', 1042390542);
INSERT INTO php_manual VALUES (2131, 'pdf_open_tiff', 'PHP 4', 'int', 'int PDF-document, string filename', 'Deprecated: Opens a TIFF image', 1042390542);
INSERT INTO php_manual VALUES (2132, 'pdf_open', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Open a new pdf object', 1042390542);
INSERT INTO php_manual VALUES (2133, 'pdf_place_image', 'PHP 3>= 3.0.7, PHP 4', 'void', 'int pdf object, int image, float x, float y, float scale', 'Places an image on the page', 1042390543);
INSERT INTO php_manual VALUES (2134, 'pdf_place_pdi_page', 'PHP 4 >= 4.0.6', 'void', 'int pdf object, int page, float x, float y, float sx, float sy', 'Places an image on the page', 1042390543);
INSERT INTO php_manual VALUES (2135, 'pdf_rect', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x, float y, float width, float height', 'Draws a rectangle', 1042390543);
INSERT INTO php_manual VALUES (2136, 'pdf_restore', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Restores formerly saved environment', 1042390543);
INSERT INTO php_manual VALUES (2137, 'pdf_rotate', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float phi', 'Sets rotation', 1042390543);
INSERT INTO php_manual VALUES (2138, 'pdf_save', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Saves the current environment', 1042390543);
INSERT INTO php_manual VALUES (2139, 'pdf_scale', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x-scale, float y-scale', 'Sets scaling', 1042390543);
INSERT INTO php_manual VALUES (2140, 'pdf_set_border_color', 'PHP 3>= 3.0.12, PHP 4', 'void', 'int pdf object, float red, float green, float blue', 'Sets color of border around links and annotations', 1042390543);
INSERT INTO php_manual VALUES (2141, 'pdf_set_border_dash', 'PHP 4 >= 4.0.1', 'void', 'int pdf object, float black, float white', 'Sets dash style of border around links and annotations', 1042390543);
INSERT INTO php_manual VALUES (2142, 'pdf_set_border_style', 'PHP 3>= 3.0.12, PHP 4', 'void', 'int pdf object, string style, float width', 'Sets style of border around links and annotations', 1042390543);
INSERT INTO php_manual VALUES (2143, 'pdf_set_char_spacing', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Sets character spacing', 1042390543);
INSERT INTO php_manual VALUES (2144, 'pdf_set_duration', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Sets duration between pages', 1042390543);
INSERT INTO php_manual VALUES (2145, 'pdf_set_font', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Selects a font face and size', 1042390543);
INSERT INTO php_manual VALUES (2146, 'pdf_set_horiz_scaling', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float scale', 'Sets horizontal scaling of text', 1042390543);
INSERT INTO php_manual VALUES (2147, 'pdf_set_info_author', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int pdfdoc, string author', ' Fills the author field of the document', 1042390543);
INSERT INTO php_manual VALUES (2148, 'pdf_set_info_creator', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int pdfdoc, string creator', ' Fills the creator field of the document', 1042390543);
INSERT INTO php_manual VALUES (2149, 'pdf_set_info_keywords', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int pdfdoc, string keywords', ' Fills the keywords field of the document', 1042390543);
INSERT INTO php_manual VALUES (2150, 'pdf_set_info_subject', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int pdfdoc, string subject', ' Fills the subject field of the document', 1042390543);
INSERT INTO php_manual VALUES (2151, 'pdf_set_info_title', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int pdfdoc, string title', ' Fills the title field of the document', 1042390543);
INSERT INTO php_manual VALUES (2152, 'pdf_set_info', 'PHP 4 >= 4.0.1', 'void', 'int pdf object, string key, string value', 'Fills a field of the document information', 1042390543);
INSERT INTO php_manual VALUES (2153, 'pdf_set_leading', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Sets distance between text lines', 1042390543);
INSERT INTO php_manual VALUES (2154, 'pdf_set_parameter', 'PHP 4', 'void', 'int pdf object, string key, string value', 'Sets certain parameters', 1042390543);
INSERT INTO php_manual VALUES (2155, 'pdf_set_text_matrix', 'PHP 3>= 3.0.6', '', 'void', 'Deprecated: Sets the text matrix', 1042390543);
INSERT INTO php_manual VALUES (2156, 'pdf_set_text_pos', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float x, float y', 'Sets text position', 1042390543);
INSERT INTO php_manual VALUES (2157, 'pdf_set_text_rendering', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Determines how text is rendered', 1042390543);
INSERT INTO php_manual VALUES (2158, 'pdf_set_text_rise', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Deprecated: Sets the text rise', 1042390543);
INSERT INTO php_manual VALUES (2159, 'pdf_set_value', 'PHP 4 >= 4.0.1', 'void', 'int pdf object, string key, float value', 'Sets certain numerical value', 1042390543);
INSERT INTO php_manual VALUES (2160, 'pdf_set_word_spacing', 'PHP 3>= 3.0.6, PHP 4', '', 'void', 'Depriciated: Sets spacing between words', 1042390543);
INSERT INTO php_manual VALUES (2161, 'pdf_setcolor', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, string type, string colorspace, float c1, [float c2], [float c3], [float c4]', 'Sets fill and stroke color', 1042390543);
INSERT INTO php_manual VALUES (2162, 'pdf_setdash', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float b, float w', 'Sets dash pattern', 1042390543);
INSERT INTO php_manual VALUES (2163, 'pdf_setflat', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float flatness', 'Sets flatness', 1042390543);
INSERT INTO php_manual VALUES (2164, 'pdf_setfont', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, int font, float size', 'Set the current font', 1042390543);
INSERT INTO php_manual VALUES (2165, 'pdf_setgray_fill', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float gray', 'Sets filling color to gray value', 1042390543);
INSERT INTO php_manual VALUES (2166, 'pdf_setgray_stroke', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float gray', 'Sets drawing color to gray value', 1042390543);
INSERT INTO php_manual VALUES (2167, 'pdf_setgray', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float gray', 'Sets drawing and filling color to gray value', 1042390543);
INSERT INTO php_manual VALUES (2168, 'pdf_setlinecap', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, int linecap', 'Sets linecap parameter', 1042390543);
INSERT INTO php_manual VALUES (2169, 'pdf_setlinejoin', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, long linejoin', 'Sets linejoin parameter', 1042390543);
INSERT INTO php_manual VALUES (2170, 'pdf_setlinewidth', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float width', 'Sets line width', 1042390543);
INSERT INTO php_manual VALUES (2171, 'pdf_setmatrix', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, float a, float b, float c, float d, float e, float f', 'Sets current transformation matrix', 1042390543);
INSERT INTO php_manual VALUES (2172, 'pdf_setmiterlimit', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float miter', 'Sets miter limit', 1042390543);
INSERT INTO php_manual VALUES (2173, 'pdf_setpolydash', 'PHP 4 >= 4.0.5', 'void', 'int pdf object, float * dasharray', 'Sets complicated dash pattern', 1042390543);
INSERT INTO php_manual VALUES (2174, 'pdf_setrgbcolor_fill', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float red value, float green value, float blue value', 'Sets filling color to rgb color value', 1042390543);
INSERT INTO php_manual VALUES (2175, 'pdf_setrgbcolor_stroke', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float red value, float green value, float blue value', 'Sets drawing color to rgb color value', 1042390543);
INSERT INTO php_manual VALUES (2176, 'pdf_setrgbcolor', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float red value, float green value, float blue value', 'Sets drawing and filling color to rgb color value', 1042390543);
INSERT INTO php_manual VALUES (2177, 'pdf_show_boxed', 'PHP 4', 'int', 'int pdf object, string text, float left, float top, float width, float height, string hmode, [string feature]', 'Output text in a box', 1042390543);
INSERT INTO php_manual VALUES (2178, 'pdf_show_xy', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, string text, float x, float y', 'Output text at given position', 1042390543);
INSERT INTO php_manual VALUES (2179, 'pdf_show', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, string text', 'Output text at current position', 1042390543);
INSERT INTO php_manual VALUES (2180, 'pdf_skew', 'PHP 4', 'void', 'int pdf object, float alpha, float beta', 'Skews the coordinate system', 1042390543);
INSERT INTO php_manual VALUES (2181, 'pdf_stringwidth', 'PHP 3>= 3.0.6, PHP 4', 'float', 'int pdf object, string text, [int font], [float size]', 'Returns width of text using current font', 1042390543);
INSERT INTO php_manual VALUES (2182, 'pdf_stroke', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object', 'Draws line along path', 1042390543);
INSERT INTO php_manual VALUES (2183, 'pdf_translate', 'PHP 3>= 3.0.6, PHP 4', 'void', 'int pdf object, float tx, float ty', 'Sets origin of coordinate system', 1042390544);
INSERT INTO php_manual VALUES (2184, 'pfpro_cleanup', 'PHP 4 >= 4.0.2', 'void', 'void', 'Shuts down the Payflow Pro library', 1042390544);
INSERT INTO php_manual VALUES (2185, 'pfpro_init', 'PHP 4 >= 4.0.2', 'void', 'void', 'Initialises the Payflow Pro library', 1042390544);
INSERT INTO php_manual VALUES (2186, 'pfpro_process_raw', 'PHP 4 >= 4.0.2', 'string', 'string parameters, [string address], [int port], [int timeout], [string proxy address], [int proxy port], [string proxy logon], [string proxy password]', 'Process a raw transaction with Payflow Pro', 1042390544);
INSERT INTO php_manual VALUES (2187, 'pfpro_process', 'PHP 4 >= 4.0.2', 'array', 'array parameters, [string address], [int port], [int timeout], [string proxy address], [int proxy port], [string proxy logon], [string proxy password]', 'Process a transaction with Payflow Pro', 1042390544);
INSERT INTO php_manual VALUES (2188, 'pfpro_version', 'PHP 4 >= 4.0.2', 'string', 'void', 'Returns the version of the Payflow Pro software', 1042390544);
INSERT INTO php_manual VALUES (2189, 'pg_affected_rows', 'PHP 4 >= 4.2.0', 'int', 'resource result', 'Returns number of affected records(tuples)', 1042390544);
INSERT INTO php_manual VALUES (2190, 'pg_cancel_query', 'PHP 4 >= 4.2.0', 'bool', 'resource connection', ' Cancel async query', 1042390544);
INSERT INTO php_manual VALUES (2191, 'pg_client_encoding', 'PHP 3 CVS only, PHP 4 >= 4.0.3', 'string', '[resource connection]', ' Get the client encoding', 1042390544);
INSERT INTO php_manual VALUES (2192, 'pg_close', 'PHP 3, PHP 4', 'bool', 'resource connection', 'Close a PostgreSQL connection', 1042390544);
INSERT INTO php_manual VALUES (2193, 'pg_connect', 'PHP 3, PHP 4', 'resource', 'string connection_string', 'Open a PostgreSQL connection', 1042390544);
INSERT INTO php_manual VALUES (2194, 'pg_connection_busy', 'PHP 4 >= 4.2.0', 'bool', 'resource connection', ' Get connection is busy or not', 1042390544);
INSERT INTO php_manual VALUES (2195, 'pg_connection_reset', 'PHP 4 >= 4.2.0', 'bool', 'resource connection', ' Reset connection (reconnect)', 1042390544);
INSERT INTO php_manual VALUES (2196, 'pg_connection_status', 'PHP 4 >= 4.2.0', 'int', 'resource connection', ' Get connection status', 1042390544);
INSERT INTO php_manual VALUES (2197, 'pg_convert', 'PHP 4 >= 4.3.0', 'array', 'resource connection, string table_name, array assoc_array, [int options]', ' Convert associative array value into suitable for SQL statement.', 1042390544);
INSERT INTO php_manual VALUES (2198, 'pg_copy_from', 'PHP 4 >= 4.2.0', 'bool', 'resource connection, string table_name, array rows, [string delimiter], [string null_as]', ' Insert records into a table from an array', 1042390544);
INSERT INTO php_manual VALUES (2199, 'pg_copy_to', 'PHP 4 >= 4.2.0', 'array', 'resource connection, string table_name, [string delimiter], [string null_as]', ' Copy a table to an array', 1042390544);
INSERT INTO php_manual VALUES (2200, 'pg_dbname', 'PHP 3, PHP 4', 'string', 'resource connection', 'Get the database name', 1042390544);
INSERT INTO php_manual VALUES (2201, 'pg_delete', 'PHP 4 >= 4.3.0', 'long', 'resource connection, string table_name, array assoc_array, [int options]', ' Delete records.', 1042390544);
INSERT INTO php_manual VALUES (2202, 'pg_end_copy', 'PHP 4 >= 4.0.3', 'bool', '[resource connection]', 'Sync with PostgreSQL backend', 1042390544);
INSERT INTO php_manual VALUES (2203, 'pg_escape_bytea', 'PHP 4 >= 4.2.0', 'string', 'string data', ' Escape binary for bytea type', 1042390544);
INSERT INTO php_manual VALUES (2204, 'pg_escape_string', 'PHP 4 >= 4.2.0', 'string', 'string data', ' Escape string for text/char type', 1042390544);
INSERT INTO php_manual VALUES (2205, 'pg_fetch_all', 'PHP 4 >= 4.3.0', 'array', 'resource result, [int row]', 'Fetch a row as an array', 1042390544);
INSERT INTO php_manual VALUES (2206, 'pg_fetch_array', 'PHP 3>= 3.0.1, PHP 4', 'array', 'resource result, [int row], [int result_type]', 'Fetch a row as an array', 1042390544);
INSERT INTO php_manual VALUES (2207, 'pg_fetch_assoc', 'PHP 4 >= 4.3.0', 'array', 'resource result, [int row]', 'Fetch a row as an array', 1042390544);
INSERT INTO php_manual VALUES (2208, 'pg_fetch_object', 'PHP 3>= 3.0.1, PHP 4', 'object', 'resource result, [int row], [int result_type]', 'Fetch a row as an object', 1042390544);
INSERT INTO php_manual VALUES (2209, 'pg_fetch_result', 'PHP 4 >= 4.2.0', 'mixed', 'resource result, int row, mixed field', 'Returns values from a result resource', 1042390544);
INSERT INTO php_manual VALUES (2210, 'pg_fetch_row', 'PHP 3>= 3.0.1, PHP 4', 'array', 'resource result, int row', 'Get a row as an enumerated array', 1042390544);
INSERT INTO php_manual VALUES (2211, 'pg_field_is_null', 'PHP 4 >= 4.2.0', '', 'void', '', 1042390544);
INSERT INTO php_manual VALUES (2212, 'pg_field_name', 'PHP 4 >= 4.2.0', 'string', 'resource result, int field_number', 'Returns the name of a field', 1042390544);
INSERT INTO php_manual VALUES (2213, 'pg_field_num', 'PHP 4 >= 4.2.0', 'int', 'resource result, string field_name', 'Returns the field number of the named field', 1042390544);
INSERT INTO php_manual VALUES (2214, 'pg_field_prtlen', 'PHP 4 >= 4.2.0', 'int', 'resource result, int row_number, string field_name', 'Returns the printed length', 1042390544);
INSERT INTO php_manual VALUES (2215, 'pg_field_size', 'PHP 4 >= 4.2.0', 'int', 'resource result, int field_number', ' Returns the internal storage size of the named field', 1042390544);
INSERT INTO php_manual VALUES (2216, 'pg_field_type', 'PHP 4 >= 4.2.0', 'string', 'resource result, int field_number', ' Returns the type name for the corresponding field number', 1042390544);
INSERT INTO php_manual VALUES (2217, 'pg_free_result', 'PHP 4 >= 4.2.0', 'bool', 'resource result', 'Free result memory', 1042390544);
INSERT INTO php_manual VALUES (2218, 'pg_get_notify', 'PHP 4 >= 4.3.0', 'array', 'resource connection, [int result_type]', 'Ping database connection', 1042390544);
INSERT INTO php_manual VALUES (2219, 'pg_get_pid', 'PHP 4 >= 4.3.0', 'int', 'resource connection', 'Ping database connection', 1042390544);
INSERT INTO php_manual VALUES (2220, 'pg_get_result', 'PHP 4 >= 4.2.0', 'resource', '[resource connection]', ' Get asynchronous query result', 1042390544);
INSERT INTO php_manual VALUES (2221, 'pg_host', 'PHP 3, PHP 4', 'string', 'resource connection', ' Returns the host name associated with the connection', 1042390544);
INSERT INTO php_manual VALUES (2222, 'pg_insert', 'PHP 4 >= 4.3.0', 'bool', 'resource connection, string table_name, array assoc_array, [int options]', ' Insert array into table.', 1042390544);
INSERT INTO php_manual VALUES (2223, 'pg_ping', 'PHP 4 >= 4.3.0', 'array', 'resource connection', 'Ping database connection', 1042390544);
INSERT INTO php_manual VALUES (2224, 'pg_last_error', 'PHP 4 >= 4.2.0', 'string', '[resource connection]', 'Get the last error message string of a connection', 1042390544);
INSERT INTO php_manual VALUES (2225, 'pg_last_notice', 'PHP 4 >= 4.0.6', 'string', 'resource connection', ' Returns the last notice message from PostgreSQL server', 1042390544);
INSERT INTO php_manual VALUES (2226, 'pg_lo_close', 'PHP 4 >= 4.2.0', 'bool', 'resource large_object', 'Close a large object', 1042390545);
INSERT INTO php_manual VALUES (2227, 'pg_lo_create', 'PHP 4 >= 4.2.0', 'int', 'resource connection', 'Create a large object', 1042390545);
INSERT INTO php_manual VALUES (2228, 'pg_lo_export', 'PHP 4 >= 4.2.0', 'bool', 'int oid, string pathname, [resource connection]', 'Export a large object to file', 1042390545);
INSERT INTO php_manual VALUES (2229, 'pg_lo_import', 'PHP 4 >= 4.2.0', 'int', '[resource connection], string pathname, string pathname, [resource connection]', 'Import a large object from file', 1042390545);
INSERT INTO php_manual VALUES (2230, 'pg_lo_open', 'PHP 4 >= 4.2.0', 'resource', 'resource connection, int oid, string mode', 'Open a large object', 1042390545);
INSERT INTO php_manual VALUES (2231, 'pg_lo_read_all', 'PHP 4 >= 4.2.0', 'int', 'resource large_object', ' Read a entire large object and send straight to browser', 1042390545);
INSERT INTO php_manual VALUES (2232, 'pg_lo_read', 'PHP 4 >= 4.2.0', 'string', 'resource large_object, int len', 'Read a large object', 1042390545);
INSERT INTO php_manual VALUES (2233, 'pg_lo_seek', 'PHP 4 >= 4.2.0', 'bool', 'resource large_object, int offset, [int whence]', ' Seeks position of large object', 1042390545);
INSERT INTO php_manual VALUES (2234, 'pg_lo_tell', 'PHP 4 >= 4.2.0', 'int', 'resource large_object', ' Returns current position of large object', 1042390545);
INSERT INTO php_manual VALUES (2235, 'pg_lo_unlink', 'PHP 4 >= 4.2.0', 'bool', 'resource connection, int oid', 'Delete a large object', 1042390545);
INSERT INTO php_manual VALUES (2236, 'pg_lo_write', 'PHP 4 >= 4.2.0', 'int', 'resource large_object, string data', 'Write a large object', 1042390545);
INSERT INTO php_manual VALUES (2237, 'pg_meta_data', 'PHP 4 >= 4.3.0', 'array', 'resource connection, string table_name', ' Get meta data for table.', 1042390545);
INSERT INTO php_manual VALUES (2238, 'pg_num_fields', 'PHP 4 >= 4.2.0', 'int', 'resource result', 'Returns the number of fields', 1042390545);
INSERT INTO php_manual VALUES (2239, 'pg_num_rows', 'PHP 4 >= 4.2.0', 'int', 'resource result', 'Returns the number of rows', 1042390545);
INSERT INTO php_manual VALUES (2240, 'pg_options', 'PHP 3, PHP 4', 'string', 'resource connection', 'Get the options associated with the connection', 1042390545);
INSERT INTO php_manual VALUES (2241, 'pg_pconnect', 'PHP 3, PHP 4', 'resource', 'string connection_string', 'Open a persistent PostgreSQL connection', 1042390545);
INSERT INTO php_manual VALUES (2242, 'pg_port', 'PHP 3, PHP 4', 'int', 'resource connection', ' Return the port number associated with the connection', 1042390545);
INSERT INTO php_manual VALUES (2243, 'pg_put_line', 'PHP 4 >= 4.0.3', 'bool', '[resource connection], string data', 'Send a NULL-terminated string to PostgreSQL backend', 1042390545);
INSERT INTO php_manual VALUES (2244, 'pg_query', 'PHP 4 >= 4.2.0', 'resource', 'resource connection, string query', 'Execute a query', 1042390545);
INSERT INTO php_manual VALUES (2245, 'pg_result_error', 'PHP 4 >= 4.2.0', 'string', 'resource result', ' Get error message associated with result', 1042390545);
INSERT INTO php_manual VALUES (2246, 'pg_result_seek', 'PHP 4 >= 4.3.0', 'array', 'resource result, int offset', 'Set internal row offset in result resource', 1042390545);
INSERT INTO php_manual VALUES (2247, 'pg_result_status', 'PHP 4 >= 4.2.0', 'int', 'resource result', ' Get status of query result', 1042390545);
INSERT INTO php_manual VALUES (2248, 'pg_select', 'PHP 4 >= 4.3.0', 'array', 'resource connection, string table_name, array assoc_array, [int options]', ' Select records.', 1042390545);
INSERT INTO php_manual VALUES (2249, 'pg_send_query', 'PHP 4 >= 4.2.0', 'bool', 'resource connection, string query, string query', ' Send asynchronous query', 1042390545);
INSERT INTO php_manual VALUES (2250, 'pg_set_client_encoding', 'PHP 3 CVS only, PHP 4 >= 4.0.3', 'int', '[resource connection], string encoding', ' Set the client encoding', 1042390545);
INSERT INTO php_manual VALUES (2251, 'pg_trace', 'PHP 4 >= 4.0.1', 'bool', 'string pathname, [string mode], [resource connection]', 'Enable tracing a PostgreSQL connection', 1042390545);
INSERT INTO php_manual VALUES (2252, 'pg_tty', 'PHP 3, PHP 4', 'string', 'resource connection', ' Return the tty name associated with the connection', 1042390545);
INSERT INTO php_manual VALUES (2253, 'pg_unescape_bytea', 'PHP 4 >= 4.3.0', 'string', 'string data', ' Escape binary for bytea type', 1042390545);
INSERT INTO php_manual VALUES (2254, 'pg_untrace', 'PHP 4 >= 4.0.1', 'bool', '[resource connection]', 'Disable tracing of a PostgreSQL connection', 1042390545);
INSERT INTO php_manual VALUES (2255, 'pg_update', 'PHP 4 >= 4.3.0', 'long', 'resource connection, string table_name, array condition, array data, [int options]', ' Update table.', 1042390545);
INSERT INTO php_manual VALUES (2256, 'posix_ctermid', 'PHP 3>= 3.0.13, PHP 4', 'string', 'void', 'Get path name of controlling terminal', 1042390545);
INSERT INTO php_manual VALUES (2257, 'posix_getcwd', 'PHP 3>= 3.0.13, PHP 4', 'string', 'void', 'Pathname of current directory', 1042390545);
INSERT INTO php_manual VALUES (2258, 'posix_getegid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', ' Return the effective group ID of the current process', 1042390545);
INSERT INTO php_manual VALUES (2259, 'posix_geteuid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', ' Return the effective user ID of the current process', 1042390545);
INSERT INTO php_manual VALUES (2260, 'posix_getgid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', ' Return the real group ID of the current process', 1042390545);
INSERT INTO php_manual VALUES (2261, 'posix_getgrgid', 'PHP 3>= 3.0.13, PHP 4', 'array', 'int gid', 'Return info about a group by group id', 1042390545);
INSERT INTO php_manual VALUES (2262, 'posix_getgrnam', 'PHP 3>= 3.0.13, PHP 4', 'array', 'string name', 'Return info about a group by name', 1042390545);
INSERT INTO php_manual VALUES (2263, 'posix_getgroups', 'PHP 3>= 3.0.10, PHP 4', 'array', 'void', ' Return the group set of the current process', 1042390545);
INSERT INTO php_manual VALUES (2264, 'posix_getlogin', 'PHP 3>= 3.0.13, PHP 4', 'string', 'void', 'Return login name', 1042390545);
INSERT INTO php_manual VALUES (2265, 'posix_getpgid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'int pid', 'Get process group id for job control', 1042390545);
INSERT INTO php_manual VALUES (2266, 'posix_getpgrp', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', ' Return the current process group identifier', 1042390545);
INSERT INTO php_manual VALUES (2267, 'posix_getpid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', 'Return the current process identifier', 1042390545);
INSERT INTO php_manual VALUES (2268, 'posix_getppid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', 'Return the parent process identifier', 1042390545);
INSERT INTO php_manual VALUES (2269, 'posix_getpwnam', 'PHP 3>= 3.0.13, PHP 4', 'array', 'string username', 'Return info about a user by username', 1042390545);
INSERT INTO php_manual VALUES (2270, 'posix_getpwuid', 'PHP 3>= 3.0.13, PHP 4', 'array', 'int uid', 'Return info about a user by user id', 1042390545);
INSERT INTO php_manual VALUES (2271, 'posix_getrlimit', 'PHP 3>= 3.0.10, PHP 4', 'array', 'void', 'Return info about system ressource limits', 1042390545);
INSERT INTO php_manual VALUES (2272, 'posix_getsid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'int pid', 'Get the current sid of the process', 1042390545);
INSERT INTO php_manual VALUES (2273, 'posix_getuid', 'PHP 3>= 3.0.10, PHP 4', 'int', 'void', ' Return the real user ID of the current process', 1042390546);
INSERT INTO php_manual VALUES (2274, 'posix_isatty', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'int fd', ' Determine if a file descriptor is an interactive terminal', 1042390546);
INSERT INTO php_manual VALUES (2275, 'posix_kill', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'int pid, int sig', 'Send a signal to a process', 1042390546);
INSERT INTO php_manual VALUES (2276, 'posix_mkfifo', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'string pathname, int mode', ' Create a fifo special file (a named pipe)', 1042390546);
INSERT INTO php_manual VALUES (2277, 'posix_setegid', 'PHP 4 >= 4.0.2', 'bool', 'int gid', ' Set the effective GID of the current process', 1042390546);
INSERT INTO php_manual VALUES (2278, 'posix_seteuid', 'PHP 4 >= 4.0.2', 'bool', 'int uid', ' Set the effective UID of the current process', 1042390546);
INSERT INTO php_manual VALUES (2279, 'posix_setgid', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'int gid', ' Set the GID of the current process', 1042390546);
INSERT INTO php_manual VALUES (2280, 'posix_setpgid', 'PHP 3>= 3.0.13, PHP 4', 'int', 'int pid, int pgid', 'set process group id for job control', 1042390546);
INSERT INTO php_manual VALUES (2281, 'posix_setsid', 'PHP 3>= 3.0.13, PHP 4', 'int', 'void', 'Make the current process a session leader', 1042390546);
INSERT INTO php_manual VALUES (2282, 'posix_setuid', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'int uid', ' Set the UID of the current process', 1042390546);
INSERT INTO php_manual VALUES (2283, 'posix_times', 'PHP 3>= 3.0.13, PHP 4', 'array', 'void', 'Get process times', 1042390546);
INSERT INTO php_manual VALUES (2284, 'posix_ttyname', 'PHP 3>= 3.0.13, PHP 4', 'string', 'int fd', 'Determine terminal device name', 1042390546);
INSERT INTO php_manual VALUES (2285, 'posix_uname', 'PHP 3>= 3.0.10, PHP 4', 'array', 'void', 'Get system name', 1042390546);
INSERT INTO php_manual VALUES (2286, 'printer_close', '', 'void', 'resource handle', 'Close an open printer connection', 1042390546);
INSERT INTO php_manual VALUES (2287, 'printer_create_brush', '', 'mixed', 'int style, string color', 'Create a new brush', 1042390546);
INSERT INTO php_manual VALUES (2288, 'printer_create_dc', '', 'void', 'resource handle', 'Create a new device context', 1042390546);
INSERT INTO php_manual VALUES (2289, 'printer_create_font', '', 'mixed', 'string face, int height, int width, int font_weight, bool italic, bool underline, bool strikeout, int orientaton', 'Create a new font', 1042390546);
INSERT INTO php_manual VALUES (2290, 'printer_create_pen', '', 'mixed', 'int style, int width, string color', 'Create a new pen', 1042390546);
INSERT INTO php_manual VALUES (2291, 'printer_delete_brush', '', 'bool', 'resource handle', 'Delete a brush', 1042390546);
INSERT INTO php_manual VALUES (2292, 'printer_delete_dc', '', 'bool', 'resource handle', 'Delete a device context', 1042390546);
INSERT INTO php_manual VALUES (2293, 'printer_delete_font', '', 'bool', 'resource handle', 'Delete a font', 1042390546);
INSERT INTO php_manual VALUES (2294, 'printer_delete_pen', '', 'bool', 'resource handle', 'Delete a pen', 1042390546);
INSERT INTO php_manual VALUES (2295, 'printer_draw_bmp', '', 'void', 'resource handle, string filename, int x, int y', 'Draw a bmp', 1042390546);
INSERT INTO php_manual VALUES (2296, 'printer_draw_chord', '', 'void', 'resource handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad_x, int rad_y, int rad_x1, int rad_y1', 'Draw a chord', 1042390546);
INSERT INTO php_manual VALUES (2297, 'printer_draw_elipse', '', 'void', 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y', 'Draw an ellipse', 1042390546);
INSERT INTO php_manual VALUES (2298, 'printer_draw_line', '', 'void', 'resource printer_handle, int from_x, int from_y, int to_x, int to_y', 'Draw a line', 1042390546);
INSERT INTO php_manual VALUES (2299, 'printer_draw_pie', '', 'void', 'resource handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad1_x, int rad1_y, int rad2_x, int rad2_y', 'Draw a pie', 1042390546);
INSERT INTO php_manual VALUES (2300, 'printer_draw_rectangle', '', 'void', 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y', 'Draw a rectangle', 1042390546);
INSERT INTO php_manual VALUES (2301, 'printer_draw_roundrect', '', 'void', 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y, int width, int height', 'Draw a rectangle with rounded corners', 1042390546);
INSERT INTO php_manual VALUES (2302, 'printer_draw_text', '', 'void', 'resource printer_handle, string text, int x, int y', 'Draw text', 1042390546);
INSERT INTO php_manual VALUES (2303, 'printer_end_doc', '', 'bool', 'resource handle', 'Close document', 1042390546);
INSERT INTO php_manual VALUES (2304, 'printer_end_page', '', 'bool', 'resource handle', 'Close active page', 1042390546);
INSERT INTO php_manual VALUES (2305, 'printer_get_option', '', 'mixed', 'resource handle, string option', 'Retrieve printer configuration data', 1042390546);
INSERT INTO php_manual VALUES (2306, 'printer_list', '', 'array', 'int enumtype, [string name], [int level]', 'Return an array of printers attached to the server', 1042390546);
INSERT INTO php_manual VALUES (2307, 'printer_logical_fontheight', '', 'int', 'resource handle, int height', 'Get logical font height', 1042390546);
INSERT INTO php_manual VALUES (2308, 'printer_open', '', 'mixed', '[string devicename]', 'Open connection to a printer', 1042390546);
INSERT INTO php_manual VALUES (2309, 'printer_select_brush', '', 'void', 'resource printer_handle, resource brush_handle', 'Select a brush', 1042390547);
INSERT INTO php_manual VALUES (2310, 'printer_select_font', '', 'void', 'resource printer_handle, resource font_handle', 'Select a font', 1042390547);
INSERT INTO php_manual VALUES (2311, 'printer_select_pen', '', 'void', 'resource printer_handle, resource pen_handle', 'Select a pen', 1042390547);
INSERT INTO php_manual VALUES (2312, 'printer_set_option', '', 'bool', 'resource handle, int option, mixed value', 'Configure the printer connection', 1042390547);
INSERT INTO php_manual VALUES (2313, 'printer_start_doc', '', 'bool', 'resource handle, [string document]', 'Start a new document', 1042390547);
INSERT INTO php_manual VALUES (2314, 'printer_start_page', '', 'bool', 'resource handle', 'Start a new page', 1042390547);
INSERT INTO php_manual VALUES (2315, 'printer_write', '', 'bool', 'resource handle, string content', 'Write data to the printer', 1042390547);
INSERT INTO php_manual VALUES (2316, 'pspell_add_to_personal', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, string word', 'Add the word to a personal wordlist', 1042390547);
INSERT INTO php_manual VALUES (2317, 'pspell_add_to_session', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, string word', 'Add the word to the wordlist in the current session', 1042390547);
INSERT INTO php_manual VALUES (2318, 'pspell_check', 'PHP 4 >= 4.0.2', 'bool', 'int dictionary_link, string word', 'Check a word', 1042390547);
INSERT INTO php_manual VALUES (2319, 'pspell_clear_session', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link', 'Clear the current session', 1042390547);
INSERT INTO php_manual VALUES (2320, 'pspell_config_create', 'PHP 4 >= 4.0.2', 'int', 'string language, [string spelling ], [string jargon ], [string encoding ]', 'Create a config used to open a dictionary', 1042390547);
INSERT INTO php_manual VALUES (2321, 'pspell_config_ignore', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, int n', 'Ignore words less than N characters long', 1042390547);
INSERT INTO php_manual VALUES (2322, 'pspell_config_mode', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, int mode', 'Change the mode number of suggestions returned', 1042390547);
INSERT INTO php_manual VALUES (2323, 'pspell_config_personal', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, string file', 'Set a file that contains personal wordlist', 1042390547);
INSERT INTO php_manual VALUES (2324, 'pspell_config_repl', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, string file', 'Set a file that contains replacement pairs', 1042390547);
INSERT INTO php_manual VALUES (2325, 'pspell_config_runtogether', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, bool flag', 'Consider run-together words as valid compounds', 1042390547);
INSERT INTO php_manual VALUES (2326, 'pspell_config_save_repl', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, bool flag', 'Determine whether to save a replacement pairs list along with the wordlist', 1042390547);
INSERT INTO php_manual VALUES (2327, 'pspell_new_config', 'PHP 4 >= 4.0.2', 'int', 'int config', 'Load a new dictionary with settings based on a given config', 1042390547);
INSERT INTO php_manual VALUES (2328, 'pspell_new_personal', 'PHP 4 >= 4.0.2', 'int', 'string personal, string language, [string spelling ], [string jargon ], [string encoding ], [int mode ]', 'Load a new dictionary with personal wordlist', 1042390547);
INSERT INTO php_manual VALUES (2329, 'pspell_new', 'PHP 4 >= 4.0.2', 'int', 'string language, [string spelling ], [string jargon ], [string encoding ], [int mode ]', 'Load a new dictionary', 1042390547);
INSERT INTO php_manual VALUES (2330, 'pspell_save_wordlist', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link', 'Save the personal wordlist to a file', 1042390547);
INSERT INTO php_manual VALUES (2331, 'pspell_store_replacement', 'PHP 4 >= 4.0.2', 'int', 'int dictionary_link, string misspelled, string correct', 'Store a replacement pair for a word', 1042390547);
INSERT INTO php_manual VALUES (2332, 'pspell_suggest', 'PHP 4 >= 4.0.2', 'array', 'int dictionary_link, string word', 'Suggest spellings of a word', 1042390547);
INSERT INTO php_manual VALUES (2333, 'qdom_error', 'PHP 4 >= 4.0.5', 'string', 'void', 'Returns the error string from the last QDOM operation or FALSE if no errors occured', 1042390547);
INSERT INTO php_manual VALUES (2334, 'qdom_tree', 'PHP 4 >= 4.0.4', 'object', '', 'creates a tree of an xml string', 1042390547);
INSERT INTO php_manual VALUES (2335, 'readline_add_history', 'PHP 4', 'void', 'string line', 'Adds a line to the history', 1042390547);
INSERT INTO php_manual VALUES (2336, 'readline_clear_history', 'PHP 4', 'bool', 'void', 'Clears the history', 1042390547);
INSERT INTO php_manual VALUES (2337, 'readline_completion_function', 'PHP 4', 'bool', 'string line', 'Registers a completion function', 1042390547);
INSERT INTO php_manual VALUES (2338, 'readline_info', 'PHP 4', 'mixed', '[string varname], [string newvalue]', 'Gets/sets various internal readline variables', 1042390547);
INSERT INTO php_manual VALUES (2339, 'readline_list_history', 'PHP 4', 'array', 'void', 'Lists the history', 1042390547);
INSERT INTO php_manual VALUES (2340, 'readline_read_history', 'PHP 4', 'bool', 'string filename', 'Reads the history', 1042390547);
INSERT INTO php_manual VALUES (2341, 'readline_write_history', 'PHP 4', 'bool', 'string filename', 'Writes the history', 1042390547);
INSERT INTO php_manual VALUES (2342, 'readline', 'PHP 4', 'string', '[string prompt]', 'Reads a line', 1042390547);
INSERT INTO php_manual VALUES (2343, 'recode_file', 'PHP 3>= 3.0.13, PHP 4', 'bool', 'string request, resource input, resource output', ' Recode from file to file according to recode request', 1042390547);
INSERT INTO php_manual VALUES (2344, 'recode_string', 'PHP 3>= 3.0.13, PHP 4', 'string', 'string request, string string', 'Recode a string according to a recode request', 1042390547);
INSERT INTO php_manual VALUES (2345, 'recode', 'PHP 4', 'string', 'string request, string string', 'Recode a string according to a recode request', 1042390547);
INSERT INTO php_manual VALUES (2346, 'ereg_replace', 'PHP 3, PHP 4', 'string', 'string pattern, string replacement, string string', 'Replace regular expression', 1042390548);
INSERT INTO php_manual VALUES (2347, 'ereg', 'PHP 3, PHP 4', 'int', 'string pattern, string string, [array regs]', 'Regular expression match', 1042390548);
INSERT INTO php_manual VALUES (2348, 'eregi_replace', 'PHP 3, PHP 4', 'string', 'string pattern, string replacement, string string', 'replace regular expression case insensitive', 1042390548);
INSERT INTO php_manual VALUES (2349, 'eregi', 'PHP 3, PHP 4', 'int', 'string pattern, string string, [array regs]', 'case insensitive regular expression match', 1042390548);
INSERT INTO php_manual VALUES (2350, 'split', 'PHP 3, PHP 4', 'array', 'string pattern, string string, [int limit]', 'split string into array by regular expression', 1042390548);
INSERT INTO php_manual VALUES (2351, 'spliti', 'PHP 4 >= 4.0.1', 'array', 'string pattern, string string, [int limit]', ' Split string into array by regular expression case insensitive', 1042390548);
INSERT INTO php_manual VALUES (2352, 'sql_regcase', 'PHP 3, PHP 4', 'string', 'string string', ' Make regular expression for case insensitive match', 1042390548);
INSERT INTO php_manual VALUES (2353, 'ftok', 'PHP 4 >= 4.2.0', 'int', 'string pathname, string proj', ' Convert a pathname and a project identifier to a System V IPC key', 1042390548);
INSERT INTO php_manual VALUES (2354, 'msg_get_queue', 'PHP 4 >= 4.3.0', 'int', 'int key, [int perms]', ' Create or attach to a message queue', 1042390548);
INSERT INTO php_manual VALUES (2355, 'msg_receive', 'PHP 4 >= 4.3.0', 'bool', 'int queue, int desiredmsgtype, int msgtype, int maxsize, mixed message, [bool unserialize], [int flags], [int errorcode]', ' Receive a message from a message queue', 1042390548);
INSERT INTO php_manual VALUES (2356, 'msg_remove_queue', 'PHP 4 >= 4.3.0', 'bool', 'int queue', ' Destroy a message queue', 1042390548);
INSERT INTO php_manual VALUES (2357, 'msg_send', 'PHP 4 >= 4.3.0', 'bool', 'int queue, int msgtype, mixed message, [bool serialize], [bool blocking], [int errorcode]', ' Send a message to a message queue', 1042390548);
INSERT INTO php_manual VALUES (2358, 'msg_set_queue', 'PHP 4 >= 4.3.0', 'bool', 'int queue, array data', ' Set information in the message queue data structure', 1042390548);
INSERT INTO php_manual VALUES (2359, 'msg_stat_queue', 'PHP 4 >= 4.3.0', 'array', 'int queue', ' Returns information from the message queue data structure', 1042390548);
INSERT INTO php_manual VALUES (2360, 'sem_acquire', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int sem_identifier', 'Acquire a semaphore', 1042390548);
INSERT INTO php_manual VALUES (2361, 'sem_get', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int key, [int max_acquire], [int perm]', 'Get a semaphore id', 1042390548);
INSERT INTO php_manual VALUES (2362, 'sem_release', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int sem_identifier', 'Release a semaphore', 1042390548);
INSERT INTO php_manual VALUES (2363, 'sem_remove', 'PHP 4 >= 4.1.0', 'bool', 'int sem_identifier', 'Remove a semaphore', 1042390548);
INSERT INTO php_manual VALUES (2364, 'shm_attach', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int key, [int memsize], [int perm]', 'Creates or open a shared memory segment', 1042390548);
INSERT INTO php_manual VALUES (2365, 'shm_detach', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'int shm_identifier', 'Disconnects from shared memory segment', 1042390548);
INSERT INTO php_manual VALUES (2366, 'shm_get_var', 'PHP 3>= 3.0.6, PHP 4', 'mixed', 'int id, int variable_key', 'Returns a variable from shared memory', 1042390548);
INSERT INTO php_manual VALUES (2367, 'shm_put_var', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int shm_identifier, int variable_key, mixed variable', 'Inserts or updates a variable in shared memory', 1042390548);
INSERT INTO php_manual VALUES (2368, 'shm_remove_var', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int id, int variable_key', 'Removes a variable from shared memory', 1042390548);
INSERT INTO php_manual VALUES (2369, 'shm_remove', 'PHP 3>= 3.0.6, PHP 4', 'int', 'int shm_identifier', 'Removes shared memory from Unix systems', 1042390548);
INSERT INTO php_manual VALUES (2370, 'sesam_affected_rows', 'PHP 3 CVS only', 'int', 'string result_id', ' Get number of rows affected by an immediate query', 1042390548);
INSERT INTO php_manual VALUES (2371, 'sesam_commit', 'PHP 3 CVS only', 'bool', 'void', ' Commit pending updates to the SESAM database', 1042390548);
INSERT INTO php_manual VALUES (2372, 'sesam_connect', 'PHP 3 CVS only', 'bool', 'string catalog, string schema, string user', 'Open SESAM database connection', 1042390548);
INSERT INTO php_manual VALUES (2373, 'sesam_diagnostic', 'PHP 3 CVS only', 'array', 'void', ' Return status information for last SESAM call', 1042390548);
INSERT INTO php_manual VALUES (2374, 'sesam_disconnect', 'PHP 3 CVS only', 'bool', 'void', 'Detach from SESAM connection', 1042390548);
INSERT INTO php_manual VALUES (2375, 'sesam_errormsg', 'PHP 3 CVS only', 'string', 'void', 'Returns error message of last SESAM call', 1042390548);
INSERT INTO php_manual VALUES (2376, 'sesam_execimm', 'PHP 3 CVS only', 'string', 'string query', 'Execute an "immediate" SQL-statement', 1042390548);
INSERT INTO php_manual VALUES (2377, 'sesam_fetch_array', 'PHP 3 CVS only', 'array', 'string result_id, [int whence], [int offset]', 'Fetch one row as an associative array', 1042390548);
INSERT INTO php_manual VALUES (2378, 'sesam_fetch_result', 'PHP 3 CVS only', 'mixed', 'string result_id, [int max_rows]', 'Return all or part of a query result', 1042390548);
INSERT INTO php_manual VALUES (2379, 'sesam_fetch_row', 'PHP 3 CVS only', 'array', 'string result_id, [int whence], [int offset]', 'Fetch one row as an array', 1042390548);
INSERT INTO php_manual VALUES (2380, 'sesam_field_array', 'PHP 3 CVS only', 'array', 'string result_id', ' Return meta information about individual columns in a result', 1042390548);
INSERT INTO php_manual VALUES (2381, 'sesam_field_name', 'PHP 3 CVS only', 'int', 'string result_id, int index', ' Return one column name of the result set', 1042390548);
INSERT INTO php_manual VALUES (2382, 'sesam_free_result', 'PHP 3 CVS only', 'int', 'string result_id', 'Releases resources for the query', 1042390548);
INSERT INTO php_manual VALUES (2383, 'sesam_num_fields', 'PHP 3 CVS only', 'int', 'string result_id', ' Return the number of fields/columns in a result set', 1042390548);
INSERT INTO php_manual VALUES (2384, 'sesam_query', 'PHP 3 CVS only', 'string', 'string query, [bool scrollable]', 'Perform a SESAM SQL query and prepare the result', 1042390549);
INSERT INTO php_manual VALUES (2385, 'sesam_rollback', 'PHP 3 CVS only', 'bool', 'void', ' Discard any pending updates to the SESAM database', 1042390549);
INSERT INTO php_manual VALUES (2386, 'sesam_seek_row', 'PHP 3 CVS only', 'bool', 'string result_id, int whence, [int offset]', ' Set scrollable cursor mode for subsequent fetches', 1042390549);
INSERT INTO php_manual VALUES (2387, 'sesam_settransaction', 'PHP 3 CVS only', 'bool', 'int isolation_level, int read_only', 'Set SESAM transaction parameters', 1042390549);
INSERT INTO php_manual VALUES (2388, 'session_cache_expire', 'PHP 4 >= 4.2.0', 'int', '[int new_cache_expire]', 'Return current cache expire', 1042390549);
INSERT INTO php_manual VALUES (2389, 'session_cache_limiter', 'PHP 4 >= 4.0.3', 'string', '[string cache_limiter]', 'Get and/or set the current cache limiter', 1042390549);
INSERT INTO php_manual VALUES (2390, 'session_decode', 'PHP 4', 'bool', 'string data', 'Decodes session data from a string', 1042390549);
INSERT INTO php_manual VALUES (2391, 'session_destroy', 'PHP 4', 'bool', 'void', 'Destroys all data registered to a session', 1042390549);
INSERT INTO php_manual VALUES (2392, 'session_encode', 'PHP 4', 'string', 'void', ' Encodes the current session data as a string', 1042390549);
INSERT INTO php_manual VALUES (2393, 'session_get_cookie_params', 'PHP 4', 'array', 'void', ' Get the session cookie parameters', 1042390549);
INSERT INTO php_manual VALUES (2394, 'session_id', 'PHP 4', 'string', '[string id]', 'Get and/or set the current session id', 1042390549);
INSERT INTO php_manual VALUES (2395, 'session_is_registered', 'PHP 4', 'bool', 'string name', ' Find out whether a global variable is registered in a session', 1042390549);
INSERT INTO php_manual VALUES (2396, 'session_module_name', 'PHP 4', 'string', '[string module]', 'Get and/or set the current session module', 1042390549);
INSERT INTO php_manual VALUES (2397, 'session_name', 'PHP 4', 'string', '[string name]', 'Get and/or set the current session name', 1042390549);
INSERT INTO php_manual VALUES (2398, 'session_readonly', '', 'void', 'void', 'Begin session - reinitializes frozen variables, but no writeback on request end', 1042390549);
INSERT INTO php_manual VALUES (2399, 'session_register', 'PHP 4', 'bool', 'mixed name, [mixed ...]', ' Register one or more global variables with the current session', 1042390549);
INSERT INTO php_manual VALUES (2400, 'session_save_path', 'PHP 4', 'string', '[string path]', 'Get and/or set the current session save path', 1042390549);
INSERT INTO php_manual VALUES (2401, 'session_set_cookie_params', 'PHP 4', 'void', 'int lifetime, [string path], [string domain], [bool secure]', ' Set the session cookie parameters', 1042390549);
INSERT INTO php_manual VALUES (2402, 'session_set_save_handler', 'PHP 4', 'bool', 'string open, string close, string read, string write, string destroy, string gc', ' Sets user-level session storage functions', 1042390549);
INSERT INTO php_manual VALUES (2403, 'session_start', 'PHP 4', 'bool', 'void', 'Initialize session data', 1042390549);
INSERT INTO php_manual VALUES (2404, 'session_unregister', 'PHP 4', 'bool', 'string name', ' Unregister a global variable from the current session', 1042390549);
INSERT INTO php_manual VALUES (2405, 'session_unset', 'PHP 4', 'void', 'void', ' Free all session variables', 1042390549);
INSERT INTO php_manual VALUES (2406, 'session_write_close', 'PHP 4 >= 4.0.4', 'void', 'void', 'Write session data and end session', 1042390549);
INSERT INTO php_manual VALUES (2407, 'shmop_close', 'PHP 4 >= 4.0.4', 'int', 'int shmid', 'Close shared memory block', 1042390549);
INSERT INTO php_manual VALUES (2408, 'shmop_delete', 'PHP 4 >= 4.0.4', 'int', 'int shmid', 'Delete shared memory block', 1042390549);
INSERT INTO php_manual VALUES (2409, 'shmop_open', 'PHP 4 >= 4.0.4', 'int', 'int key, string flags, int mode, int size', 'Create or open shared memory block', 1042390549);
INSERT INTO php_manual VALUES (2410, 'shmop_read', 'PHP 4 >= 4.0.4', 'string', 'int shmid, int start, int count', 'Read data from shared memory block', 1042390549);
INSERT INTO php_manual VALUES (2411, 'shmop_size', 'PHP 4 >= 4.0.4', 'int', 'int shmid', 'Get size of shared memory block', 1042390549);
INSERT INTO php_manual VALUES (2412, 'shmop_write', 'PHP 4 >= 4.0.4', 'int', 'int shmid, string data, int offset', 'Write data into shared memory block', 1042390549);
INSERT INTO php_manual VALUES (2413, 'snmp_set_quick_print', 'PHP 3>= 3.0.8, PHP 4', 'void', 'bool quick_print', 'Set the value of quick_print within the UCD SNMP library', 1042390549);
INSERT INTO php_manual VALUES (2414, 'snmpget', 'PHP 3, PHP 4', 'string', 'string hostname, string community, string object_id, [int timeout], [int retries]', 'Fetch an SNMP object', 1042390549);
INSERT INTO php_manual VALUES (2415, 'snmprealwalk', 'PHP 3>= 3.0.8, PHP 4', 'array', 'string host, string community, string object_id, [int timeout], [int retries]', ' Return all objects including their respective object ID within the specified one', 1042390549);
INSERT INTO php_manual VALUES (2416, 'snmpset', 'PHP 3>= 3.0.12, PHP 4', 'bool', 'string hostname, string community, string object_id, string type, mixed value, [int timeout], [int retries]', 'Set an SNMP object', 1042390549);
INSERT INTO php_manual VALUES (2417, 'snmpwalk', 'PHP 3, PHP 4', 'array', 'string hostname, string community, string object_id, [int timeout], [int retries]', 'Fetch all the SNMP objects from an agent', 1042390549);
INSERT INTO php_manual VALUES (2418, 'snmpwalkoid', 'PHP 3>= 3.0.8, PHP 4', 'array', 'string hostname, string community, string object_id, [int timeout], [int retries]', 'Query for a tree of information about a network entity', 1042390549);
INSERT INTO php_manual VALUES (2419, 'socket_accept', 'PHP 4 >= 4.1.0', 'resource', 'resource socket', 'Accepts a connection on a socket', 1042390549);
INSERT INTO php_manual VALUES (2420, 'socket_bind', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, string address, [int port]', 'Binds a name to a socket', 1042390549);
INSERT INTO php_manual VALUES (2421, 'socket_clear_error', 'PHP 4 >= 4.2.0', 'void', '[resource socket]', 'Clears the error on the socket or the last error code', 1042390549);
INSERT INTO php_manual VALUES (2422, 'socket_close', 'PHP 4 >= 4.1.0', 'void', 'resource socket', 'Closes a socket resource', 1042390549);
INSERT INTO php_manual VALUES (2423, 'socket_connect', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, string address, [int port]', 'Initiates a connection on a socket', 1042390549);
INSERT INTO php_manual VALUES (2424, 'socket_create_listen', 'PHP 4 >= 4.1.0', 'resource', 'int port, [int backlog]', 'Opens a socket on port to accept connections', 1042390549);
INSERT INTO php_manual VALUES (2425, 'socket_create_pair', 'PHP 4 >= 4.1.0', 'bool', 'int domain, int type, int protocol, array &fd', 'Creates a pair of indistinguishable sockets and stores them in fds.', 1042390549);
INSERT INTO php_manual VALUES (2426, 'socket_create', 'PHP 4 >= 4.1.0', 'resource', 'int domain, int type, int protocol', 'Create a socket (endpoint for communication)', 1042390550);
INSERT INTO php_manual VALUES (2427, 'socket_get_option', 'PHP 4 >= 4.3.0', 'mixed', 'resource socket, int level, int optname', 'Gets socket options for the socket', 1042390550);
INSERT INTO php_manual VALUES (2428, 'socket_getpeername', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, string &addr, [int &port]', ' Queries the remote side of the given socket which may either result in host/port or in a UNIX filesystem path, dependent on its type.', 1042390550);
INSERT INTO php_manual VALUES (2429, 'socket_getsockname', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, string &addr, [int &port]', ' Queries the local side of the given socket which may either result in host/port or in a UNIX filesystem path, dependent on its type.', 1042390550);
INSERT INTO php_manual VALUES (2430, 'socket_iovec_add', 'PHP 4 >= 4.1.0', 'bool', 'resource iovec, int iov_len', 'Adds a new vector to the scatter/gather array', 1042390550);
INSERT INTO php_manual VALUES (2431, 'socket_iovec_delete', 'PHP 4 >= 4.1.0', 'bool', 'resource iovec, int iov_pos', 'Deletes a vector from an array of vectors', 1042390550);
INSERT INTO php_manual VALUES (2432, 'socket_read', 'PHP 4 >= 4.1.0', 'string', 'resource socket, int length, [int type]', 'Reads a maximum of length bytes from a socket', 1042390550);
INSERT INTO php_manual VALUES (2433, 'socket_iovec_fetch', 'PHP 4 >= 4.1.0', 'string', 'resource iovec, int iovec_position', 'Returns the data held in the iovec specified by iovec_id[iovec_position]', 1042390550);
INSERT INTO php_manual VALUES (2434, 'socket_iovec_free', 'PHP 4 >= 4.1.0', 'bool', 'resource iovec', 'Frees the iovec specified by iovec_id', 1042390550);
INSERT INTO php_manual VALUES (2435, 'socket_iovec_set', 'PHP 4 >= 4.1.0', 'bool', 'resource iovec, int iovec_position, string new_val', 'Sets the data held in iovec_id[iovec_position] to new_val', 1042390550);
INSERT INTO php_manual VALUES (2436, 'socket_last_error', 'PHP 4 >= 4.1.0', 'int', '[resource socket]', 'Returns the last error on the socket', 1042390550);
INSERT INTO php_manual VALUES (2437, 'socket_listen', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, [int backlog]', 'Listens for a connection on a socket', 1042390550);
INSERT INTO php_manual VALUES (2438, 'socket_readv', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, resource iovec_id', 'Reads from an fd, using the scatter-gather array defined by iovec_id', 1042390550);
INSERT INTO php_manual VALUES (2439, 'socket_recv', 'PHP 4 >= 4.1.0', 'string', 'resource socket, int len, int flags', 'Receives data from a connected socket', 1042390550);
INSERT INTO php_manual VALUES (2440, 'socket_recvfrom', 'PHP 4 >= 4.1.0', 'int', 'resource socket, string &buf, int len, int flags, string &name, [int &port]', 'Receives data from a socket, connected or not', 1042390550);
INSERT INTO php_manual VALUES (2441, 'socket_recvmsg', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, resource iovec, array &control, int &controllen, int &flags, string &addr, [int &port]', 'Used to receive messages on a socket, whether connection-oriented or not', 1042390550);
INSERT INTO php_manual VALUES (2442, 'socket_select', 'PHP 4 >= 4.1.0', 'int', 'resource &read, resource &write, resource &except, int tv_sec, [int tv_usec]', 'Runs the select() system call on the given arrays of sockets with a timeout specified by tv_sec and tv_usec', 1042390550);
INSERT INTO php_manual VALUES (2443, 'socket_send', 'PHP 4 >= 4.1.0', 'int', 'resource socket, string buf, int len, int flags', 'Sends data to a connected socket', 1042390550);
INSERT INTO php_manual VALUES (2444, 'socket_sendmsg', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, resource iovec, int flags, string addr, [int port]', 'Sends a message to a socket, regardless of whether it is connection-oriented or not', 1042390550);
INSERT INTO php_manual VALUES (2445, 'socket_sendto', 'PHP 4 >= 4.1.0', 'int', 'resource socket, string buf, int len, int flags, string addr, [int port]', 'Sends a message to a socket, whether it is connected or not', 1042390550);
INSERT INTO php_manual VALUES (2446, 'socket_set_nonblock', 'PHP 4 >= 4.1.0', 'bool', 'resource socket', 'Sets nonblocking mode for file descriptor fd', 1042390550);
INSERT INTO php_manual VALUES (2447, 'socket_set_option', 'PHP 4 >= 4.3.0', 'bool', 'resource socket, int level, int optname', 'Sets socket options for the socket', 1042390550);
INSERT INTO php_manual VALUES (2448, 'socket_shutdown', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, [int how]', 'Shuts down a socket for receiving, sending, or both.', 1042390550);
INSERT INTO php_manual VALUES (2449, 'socket_strerror', 'PHP 4 >= 4.1.0', 'string', 'int errno', 'Return a string describing a socket error', 1042390550);
INSERT INTO php_manual VALUES (2450, 'socket_write', 'PHP 4 >= 4.1.0', 'int', 'resource socket, string buffer, [int length]', 'Write to a socket', 1042390550);
INSERT INTO php_manual VALUES (2451, 'socket_writev', 'PHP 4 >= 4.1.0', 'bool', 'resource socket, resource iovec_id', 'Writes to a file descriptor, fd, using the scatter-gather array defined by iovec_id', 1042390550);
INSERT INTO php_manual VALUES (2452, 'stream_get_meta_data', 'PHP 4 >= 4.3.0', 'array', 'resource stream', 'Retrieves header/meta data from streams/file pointers', 1042390550);
INSERT INTO php_manual VALUES (2453, 'stream_get_options', '', 'bool', 'resource stream|context', 'Retrieve options for a stream/wrapper/context', 1042390550);
INSERT INTO php_manual VALUES (2454, 'stream_get_wrappers', '', 'array', 'void', 'Retrieve list of registered streams', 1042390550);
INSERT INTO php_manual VALUES (2455, 'stream_register_wrapper', 'PHP 4 >= 4.3.0', 'boolean', 'string protocol, string classname', 'Register a URL wrapper implemented as a PHP class', 1042390550);
INSERT INTO php_manual VALUES (2456, 'stream_select', 'PHP 4 >= 4.3.0', 'int', 'resource &read, resource &write, resource &except, int tv_sec, [int tv_usec]', 'Runs the equivalent of the select() system call on the given arrays of streams with a timeout specified by tv_sec and tv_usec', 1042390550);
INSERT INTO php_manual VALUES (2457, 'stream_set_blocking', 'PHP 4 >= 4.3.0', 'bool', 'resource stream, int mode', 'Set blocking/non-blocking mode on a stream', 1042390550);
INSERT INTO php_manual VALUES (2458, 'stream_set_timeout', 'PHP 4 >= 4.3.0', 'bool', 'resource stream, int seconds, int microseconds', 'Set timeout period on a stream', 1042390550);
INSERT INTO php_manual VALUES (2459, 'stream_set_write_buffer', 'PHP 4 >= 4.3.0', 'int', 'resource stream, int buffer', 'Sets file buffering on the given stream', 1042390550);
INSERT INTO php_manual VALUES (2460, 'addcslashes', 'PHP 4', 'string', 'string str, string charlist', 'Quote string with slashes in a C style', 1042390550);
INSERT INTO php_manual VALUES (2461, 'addslashes', 'PHP 3, PHP 4', 'string', 'string str', 'Quote string with slashes', 1042390550);
INSERT INTO php_manual VALUES (2462, 'bin2hex', 'PHP 3>= 3.0.9, PHP 4', 'string', 'string str', ' Convert binary data into hexadecimal representation', 1042390550);
INSERT INTO php_manual VALUES (2463, 'chop', 'PHP 3, PHP 4', '', 'void', 'Alias of rtrim', 1042390550);
INSERT INTO php_manual VALUES (2464, 'chr', 'PHP 3, PHP 4', 'string', 'int ascii', 'Return a specific character', 1042390550);
INSERT INTO php_manual VALUES (2465, 'chunk_split', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string body, [int chunklen], [string end]', 'Split a string into smaller chunks', 1042390550);
INSERT INTO php_manual VALUES (2466, 'convert_cyr_string', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string str, string from, string to', ' Convert from one Cyrillic character set to another', 1042390550);
INSERT INTO php_manual VALUES (2467, 'count_chars', 'PHP 4', 'mixed', 'string string, [int mode]', ' Return information about characters used in a string', 1042390550);
INSERT INTO php_manual VALUES (2468, 'crc32', 'PHP 4 >= 4.0.1', 'int', 'string str', 'Calculates the crc32 polynomial of a string', 1042390550);
INSERT INTO php_manual VALUES (2469, 'crypt', 'PHP 3, PHP 4', 'string', 'string str, [string salt]', 'One-way string encryption (hashing)', 1042390550);
INSERT INTO php_manual VALUES (2470, 'echo', '', '', 'string arg1, [string argn...]', 'Output one or more strings', 1042390551);
INSERT INTO php_manual VALUES (2471, 'explode', 'PHP 3, PHP 4', 'array', 'string separator, string string, [int limit]', 'Split a string by string', 1042390551);
INSERT INTO php_manual VALUES (2472, 'get_html_translation_table', 'PHP 4', 'string', 'int table, [int quote_style]', ' Returns the translation table used by htmlspecialchars and htmlentities', 1042390551);
INSERT INTO php_manual VALUES (2473, 'get_meta_tags', 'PHP 3>= 3.0.4, PHP 4', 'array', 'string filename, [int use_include_path]', ' Extracts all meta tag content attributes from a file and returns an array', 1042390551);
INSERT INTO php_manual VALUES (2474, 'hebrev', 'PHP 3, PHP 4', 'string', 'string hebrew_text, [int max_chars_per_line]', ' Convert logical Hebrew text to visual text', 1042390551);
INSERT INTO php_manual VALUES (2475, 'hebrevc', 'PHP 3, PHP 4', 'string', 'string hebrew_text, [int max_chars_per_line]', ' Convert logical Hebrew text to visual text with newline conversion', 1042390551);
INSERT INTO php_manual VALUES (2476, 'html_entity_decode', 'PHP 4 >= 4.3.0', 'string', 'string string, [int quote_style], [string charset]', ' Convert all HTML entities to their applicable characters', 1042390551);
INSERT INTO php_manual VALUES (2477, 'htmlentities', 'PHP 3, PHP 4', 'string', 'string string, [int quote_style], [string charset]', ' Convert all applicable characters to HTML entities', 1042390551);
INSERT INTO php_manual VALUES (2478, 'implode', 'PHP 3, PHP 4', 'string', 'string glue, array pieces', 'Join array elements with a string', 1042390551);
INSERT INTO php_manual VALUES (2479, 'htmlspecialchars', 'PHP 3, PHP 4', 'string', 'string string, [int quote_style], [string charset]', ' Convert special characters to HTML entities', 1042390551);
INSERT INTO php_manual VALUES (2480, 'join', 'PHP 3, PHP 4', 'string', 'string glue, array pieces', 'Join array elements with a string', 1042390551);
INSERT INTO php_manual VALUES (2481, 'levenshtein', 'PHP 3>= 3.0.17, PHP 4 >= 4.0.1', 'int', 'string str1, string str2, string str1, string str2, int cost_ins, int cost_rep, int cost_del, string str1, string str2, function cost', ' Calculate Levenshtein distance between two strings', 1042390551);
INSERT INTO php_manual VALUES (2482, 'localeconv', 'PHP 4 >= 4.0.5', 'array', 'void', 'Get numeric formatting information', 1042390551);
INSERT INTO php_manual VALUES (2483, 'ltrim', 'PHP 3, PHP 4', 'string', 'string str, [string charlist]', ' Strip whitespace from the beginning of a string', 1042390551);
INSERT INTO php_manual VALUES (2484, 'md5_file', 'PHP 4 >= 4.2.0', 'string', 'string filename', 'Calculates the md5 hash of a given filename', 1042390551);
INSERT INTO php_manual VALUES (2485, 'md5', 'PHP 3, PHP 4', 'string', 'string str', 'Calculate the md5 hash of a string', 1042390551);
INSERT INTO php_manual VALUES (2486, 'metaphone', 'PHP 4', 'string', 'string str', 'Calculate the metaphone key of a string', 1042390551);
INSERT INTO php_manual VALUES (2487, 'money_format', 'PHP 4 >= 4.3.0', 'string', 'string format, float number', 'Formats a number as a currency string', 1042390551);
INSERT INTO php_manual VALUES (2488, 'nl_langinfo', 'PHP 4 >= 4.1.0', 'string', 'int item', ' Query language and locale information', 1042390551);
INSERT INTO php_manual VALUES (2489, 'nl2br', 'PHP 3, PHP 4', 'string', 'string string', ' Inserts HTML line breaks before all newlines in a string', 1042390551);
INSERT INTO php_manual VALUES (2490, 'number_format', 'PHP 3, PHP 4', 'string', 'float number, [int decimals], [string dec_point], [string thousands_sep]', 'Format a number with grouped thousands', 1042390551);
INSERT INTO php_manual VALUES (2491, 'ord', 'PHP 3, PHP 4', 'int', 'string string', 'Return ASCII value of character', 1042390551);
INSERT INTO php_manual VALUES (2492, 'parse_str', 'PHP 3, PHP 4', 'void', 'string str, [array arr ]', 'Parses the string into variables', 1042390551);
INSERT INTO php_manual VALUES (2493, 'print', '', '', 'string arg', 'Output a string', 1042390551);
INSERT INTO php_manual VALUES (2494, 'printf', 'PHP 3, PHP 4', 'void', 'string format, [mixed args]', 'Output a formatted string', 1042390551);
INSERT INTO php_manual VALUES (2495, 'quoted_printable_decode', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string str', ' Convert a quoted-printable string to an 8 bit string', 1042390551);
INSERT INTO php_manual VALUES (2496, 'quotemeta', 'PHP 3, PHP 4', 'string', 'string str', 'Quote meta characters', 1042390551);
INSERT INTO php_manual VALUES (2497, 'rtrim', 'PHP 3, PHP 4', 'string', 'string str, [string charlist]', ' Strip whitespace from the end of a string', 1042390552);
INSERT INTO php_manual VALUES (2498, 'setlocale', 'PHP 3, PHP 4', 'string', 'mixed category, string locale, [string ...], mixed category, array locale', 'Set locale information', 1042390552);
INSERT INTO php_manual VALUES (2499, 'sha1_file', 'PHP 4 >= 4.3.0', 'string', 'string filename', 'Calculate the sha1 hash of a file', 1042390552);
INSERT INTO php_manual VALUES (2500, 'sha1', 'PHP 4 >= 4.3.0', 'string', 'string str', 'Calculate the sha1 hash of a string', 1042390552);
INSERT INTO php_manual VALUES (2501, 'similar_text', 'PHP 3>= 3.0.7, PHP 4', 'int', 'string first, string second, [float percent]', ' Calculate the similarity between two strings', 1042390552);
INSERT INTO php_manual VALUES (2502, 'soundex', 'PHP 3, PHP 4', 'string', 'string str', 'Calculate the soundex key of a string', 1042390552);
INSERT INTO php_manual VALUES (2503, 'sprintf', 'PHP 3, PHP 4', 'string', 'string format, [mixed args]', 'Return a formatted string', 1042390552);
INSERT INTO php_manual VALUES (2504, 'sscanf', 'PHP 4 >= 4.0.1', 'mixed', 'string str, string format, [string var1]', ' Parses input from a string according to a format', 1042390552);
INSERT INTO php_manual VALUES (2505, 'str_pad', 'PHP 4 >= 4.0.1', 'string', 'string input, int pad_length, [string pad_string], [int pad_type]', ' Pad a string to a certain length with another string', 1042390552);
INSERT INTO php_manual VALUES (2506, 'str_repeat', 'PHP 4', 'string', 'string input, int multiplier', 'Repeat a string', 1042390552);
INSERT INTO php_manual VALUES (2507, 'str_replace', 'PHP 3>= 3.0.6, PHP 4', 'mixed', 'mixed search, mixed replace, mixed subject', ' Replace all occurrences of the search string with the replacement string', 1042390552);
INSERT INTO php_manual VALUES (2508, 'str_rot13', 'PHP 4 >= 4.2.0', 'string', 'string str', 'Perform the rot13 transform on a string', 1042390552);
INSERT INTO php_manual VALUES (2509, 'str_word_count', 'PHP 4 >= 4.3.0', 'mixed', 'string string, [int format]', ' Return information about words used in a string', 1042390552);
INSERT INTO php_manual VALUES (2510, 'strcasecmp', 'PHP 3>= 3.0.2, PHP 4', 'int', 'string str1, string str2', ' Binary safe case-insensitive string comparison', 1042390552);
INSERT INTO php_manual VALUES (2511, 'strchr', 'PHP 3, PHP 4', 'string', 'string haystack, string needle', ' Find the first occurrence of a character', 1042390552);
INSERT INTO php_manual VALUES (2512, 'strcmp', 'PHP 3, PHP 4', 'int', 'string str1, string str2', 'Binary safe string comparison', 1042390552);
INSERT INTO php_manual VALUES (2513, 'strcoll', 'PHP 4 >= 4.0.5', 'int', 'string str1, string str2', 'Locale based string comparison', 1042390552);
INSERT INTO php_manual VALUES (2514, 'strcspn', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string str1, string str2', ' Find length of initial segment not matching mask', 1042390552);
INSERT INTO php_manual VALUES (2515, 'strip_tags', 'PHP 3>= 3.0.8, PHP 4', 'string', 'string str, [string allowable_tags]', 'Strip HTML and PHP tags from a string', 1042390552);
INSERT INTO php_manual VALUES (2516, 'stripcslashes', 'PHP 4', 'string', 'string str', ' Un-quote string quoted with addcslashes', 1042390552);
INSERT INTO php_manual VALUES (2517, 'stripslashes', 'PHP 3, PHP 4', 'string', 'string str', ' Un-quote string quoted with addslashes', 1042390552);
INSERT INTO php_manual VALUES (2518, 'stristr', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string haystack, string needle', ' Case-insensitive strstr', 1042390552);
INSERT INTO php_manual VALUES (2519, 'strlen', 'PHP 3, PHP 4', 'int', 'string str', 'Get string length', 1042390552);
INSERT INTO php_manual VALUES (2520, 'strnatcasecmp', 'PHP 4', 'int', 'string str1, string str2', ' Case insensitive string comparisons using a "natural order" algorithm', 1042390552);
INSERT INTO php_manual VALUES (2521, 'strnatcmp', 'PHP 4', 'int', 'string str1, string str2', ' String comparisons using a "natural order" algorithm', 1042390552);
INSERT INTO php_manual VALUES (2522, 'strncasecmp', 'PHP 4 >= 4.0.2', 'int', 'string str1, string str2, int len', ' Binary safe case-insensitive string comparison of the first n characters', 1042390552);
INSERT INTO php_manual VALUES (2523, 'strncmp', 'PHP 4', 'int', 'string str1, string str2, int len', ' Binary safe string comparison of the first n characters', 1042390552);
INSERT INTO php_manual VALUES (2524, 'strpos', 'PHP 3, PHP 4', 'int', 'string haystack, string needle, [int offset]', ' Find position of first occurrence of a string', 1042390552);
INSERT INTO php_manual VALUES (2525, 'strrchr', 'PHP 3, PHP 4', 'string', 'string haystack, string needle', ' Find the last occurrence of a character in a string', 1042390552);
INSERT INTO php_manual VALUES (2526, 'strrev', 'PHP 3, PHP 4', 'string', 'string string', 'Reverse a string', 1042390552);
INSERT INTO php_manual VALUES (2527, 'strrpos', 'PHP 3, PHP 4', 'int', 'string haystack, char needle', ' Find position of last occurrence of a char in a string', 1042390552);
INSERT INTO php_manual VALUES (2528, 'strspn', 'PHP 3>= 3.0.3, PHP 4', 'int', 'string str1, string str2', ' Find length of initial segment matching mask', 1042390552);
INSERT INTO php_manual VALUES (2529, 'strstr', 'PHP 3, PHP 4', 'string', 'string haystack, string needle', 'Find first occurrence of a string', 1042390552);
INSERT INTO php_manual VALUES (2530, 'strtok', 'PHP 3, PHP 4', 'string', 'string arg1, string arg2', 'Tokenize string', 1042390552);
INSERT INTO php_manual VALUES (2531, 'strtolower', 'PHP 3, PHP 4', 'string', 'string str', 'Make a string lowercase', 1042390552);
INSERT INTO php_manual VALUES (2532, 'strtoupper', 'PHP 3, PHP 4', 'string', 'string string', 'Make a string uppercase', 1042390553);
INSERT INTO php_manual VALUES (2533, 'strtr', 'PHP 3, PHP 4', 'string', 'string str, string from, string to, string str, array replace_pairs', 'Translate certain characters', 1042390553);
INSERT INTO php_manual VALUES (2534, 'substr_count', 'PHP 4', 'int', 'string haystack, string needle', 'Count the number of substring occurrences', 1042390553);
INSERT INTO php_manual VALUES (2535, 'substr_replace', 'PHP 4', 'string', 'string string, string replacement, int start, [int length]', 'Replace text within a portion of a string', 1042390553);
INSERT INTO php_manual VALUES (2536, 'substr', 'PHP 3, PHP 4', 'string', 'string string, int start, [int length]', 'Return part of a string', 1042390553);
INSERT INTO php_manual VALUES (2537, 'trim', 'PHP 3, PHP 4', 'string', 'string str, [string charlist]', ' Strip whitespace from the beginning and end of a string', 1042390553);
INSERT INTO php_manual VALUES (2538, 'ucwords', 'PHP 3>= 3.0.3, PHP 4', 'string', 'string str', ' Uppercase the first character of each word in a string', 1042390553);
INSERT INTO php_manual VALUES (2539, 'vprintf', 'PHP 4 >= 4.1.0', 'void', 'string format, array args', 'Output a formatted string', 1042390553);
INSERT INTO php_manual VALUES (2540, 'vsprintf', 'PHP 4 >= 4.1.0', 'string', 'string format, array args', 'Return a formatted string', 1042390553);
INSERT INTO php_manual VALUES (2541, 'wordwrap', 'PHP 4 >= 4.0.2', 'string', 'string str, [int width], [string break], [int cut]', ' Wraps a string to a given number of characters using a string break character.', 1042390553);
INSERT INTO php_manual VALUES (2542, 'swf_actiongeturl', 'PHP 4', 'void', 'string url, string target', 'Get a URL from a Shockwave Flash movie', 1042390553);
INSERT INTO php_manual VALUES (2543, 'swf_actiongotoframe', 'PHP 4', 'void', 'int framenumber', 'Play a frame and then stop', 1042390553);
INSERT INTO php_manual VALUES (2544, 'swf_actiongotolabel', 'PHP 4', 'void', 'string label', ' Display a frame with the specified label', 1042390553);
INSERT INTO php_manual VALUES (2545, 'swf_actionnextframe', 'PHP 4', 'void', 'void', 'Go foward one frame', 1042390553);
INSERT INTO php_manual VALUES (2546, 'swf_actionplay', 'PHP 4', 'void', 'void', ' Start playing the flash movie from the current frame', 1042390553);
INSERT INTO php_manual VALUES (2547, 'swf_actionprevframe', 'PHP 4', 'void', 'void', 'Go backwards one frame', 1042390553);
INSERT INTO php_manual VALUES (2548, 'swf_actionsettarget', 'PHP 4', 'void', 'string target', 'Set the context for actions', 1042390553);
INSERT INTO php_manual VALUES (2549, 'swf_actionstop', 'PHP 4', 'void', 'void', ' Stop playing the flash movie at the current frame', 1042390553);
INSERT INTO php_manual VALUES (2550, 'swf_actiontogglequality', 'PHP 4', 'void', 'void', ' Toggle between low and high quality', 1042390553);
INSERT INTO php_manual VALUES (2551, 'swf_actionwaitforframe', 'PHP 4', 'void', 'int framenumber, int skipcount', ' Skip actions if a frame has not been loaded', 1042390553);
INSERT INTO php_manual VALUES (2552, 'swf_addbuttonrecord', 'PHP 4', 'void', 'int states, int shapeid, int depth', ' Controls location, appearance and active area of the current button', 1042390553);
INSERT INTO php_manual VALUES (2553, 'swf_addcolor', 'PHP 4', 'void', 'float r, float g, float b, float a', ' Set the global add color to the rgba value specified', 1042390553);
INSERT INTO php_manual VALUES (2554, 'swf_closefile', 'PHP 4', 'void', '[int return_file ]', 'Close the current Shockwave Flash file', 1042390553);
INSERT INTO php_manual VALUES (2555, 'swf_definebitmap', 'PHP 4', 'void', 'int objid, string image_name', 'Define a bitmap', 1042390553);
INSERT INTO php_manual VALUES (2556, 'swf_definefont', 'PHP 4', 'void', 'int fontid, string fontname', ' Defines a font', 1042390553);
INSERT INTO php_manual VALUES (2557, 'swf_defineline', 'PHP 4', 'void', 'int objid, float x1, float y1, float x2, float y2, float width', 'Define a line', 1042390553);
INSERT INTO php_manual VALUES (2558, 'swf_definepoly', 'PHP 4', 'void', 'int objid, array coords, int npoints, float width', ' Define a polygon', 1042390553);
INSERT INTO php_manual VALUES (2559, 'swf_definerect', 'PHP 4', 'void', 'int objid, float x1, float y1, float x2, float y2, float width', 'Define a rectangle', 1042390553);
INSERT INTO php_manual VALUES (2560, 'swf_definetext', 'PHP 4', 'void', 'int objid, string str, int docenter', 'Define a text string', 1042390553);
INSERT INTO php_manual VALUES (2561, 'swf_endbutton', 'PHP 4', 'void', 'void', ' End the definition of the current button', 1042390553);
INSERT INTO php_manual VALUES (2562, 'swf_enddoaction', 'PHP 4', 'void', 'void', 'End the current action', 1042390553);
INSERT INTO php_manual VALUES (2563, 'swf_endshape', 'PHP 4', 'void', 'void', ' Completes the definition of the current shape', 1042390553);
INSERT INTO php_manual VALUES (2564, 'swf_endsymbol', 'PHP 4', 'void', 'void', 'End the definition of a symbol', 1042390553);
INSERT INTO php_manual VALUES (2565, 'swf_fontsize', 'PHP 4', 'void', 'float size', 'Change the font size', 1042390553);
INSERT INTO php_manual VALUES (2566, 'swf_fontslant', 'PHP 4', 'void', 'float slant', 'Set the font slant', 1042390553);
INSERT INTO php_manual VALUES (2567, 'swf_fonttracking', 'PHP 4', 'void', 'float tracking', 'Set the current font tracking', 1042390553);
INSERT INTO php_manual VALUES (2568, 'swf_getbitmapinfo', 'PHP 4', 'array', 'int bitmapid', 'Get information about a bitmap', 1042390553);
INSERT INTO php_manual VALUES (2569, 'swf_getfontinfo', 'PHP 4', 'array', 'void', ' The height in pixels of a capital A and a lowercase x', 1042390553);
INSERT INTO php_manual VALUES (2570, 'swf_getframe', 'PHP 4', 'int', 'void', 'Get the frame number of the current frame', 1042390553);
INSERT INTO php_manual VALUES (2571, 'swf_labelframe', 'PHP 4', 'void', 'string name', 'Label the current frame', 1042390554);
INSERT INTO php_manual VALUES (2572, 'swf_lookat', 'PHP 4', 'void', 'float view_x, float view_y, float view_z, float reference_x, float reference_y, float reference_z, float twist', 'Define a viewing transformation', 1042390554);
INSERT INTO php_manual VALUES (2573, 'swf_modifyobject', 'PHP 4', 'void', 'int depth, int how', 'Modify an object', 1042390554);
INSERT INTO php_manual VALUES (2574, 'swf_mulcolor', 'PHP 4', 'void', 'float r, float g, float b, float a', ' Sets the global multiply color to the rgba value specified', 1042390554);
INSERT INTO php_manual VALUES (2575, 'swf_nextid', 'PHP 4', 'int', 'void', 'Returns the next free object id', 1042390554);
INSERT INTO php_manual VALUES (2576, 'swf_oncondition', 'PHP 4', 'void', 'int transition', ' Describe a transition used to trigger an action list', 1042390554);
INSERT INTO php_manual VALUES (2577, 'swf_openfile', 'PHP 4', 'void', 'string filename, float width, float height, float framerate, float r, float g, float b', 'Open a new Shockwave Flash file', 1042390554);
INSERT INTO php_manual VALUES (2578, 'swf_ortho', 'PHP 4 >= 4.0.1', 'void', 'float xmin, float xmax, float ymin, float ymax, float zmin, float zmax', ' Defines an orthographic mapping of user coordinates onto the current viewport', 1042390554);
INSERT INTO php_manual VALUES (2579, 'swf_ortho2', 'PHP 4', 'void', 'float xmin, float xmax, float ymin, float ymax', ' Defines 2D orthographic mapping of user coordinates onto the current viewport', 1042390554);
INSERT INTO php_manual VALUES (2580, 'swf_perspective', 'PHP 4', 'void', 'float fovy, float aspect, float near, float far', ' Define a perspective projection transformation', 1042390554);
INSERT INTO php_manual VALUES (2581, 'swf_placeobject', 'PHP 4', 'void', 'int objid, int depth', 'Place an object onto the screen', 1042390554);
INSERT INTO php_manual VALUES (2582, 'swf_popmatrix', 'PHP 4', 'void', 'void', ' Restore a previous transformation matrix', 1042390554);
INSERT INTO php_manual VALUES (2583, 'swf_posround', 'PHP 4', 'void', 'int round', ' Enables or Disables the rounding of the translation when objects are placed or moved', 1042390554);
INSERT INTO php_manual VALUES (2584, 'swf_pushmatrix', 'PHP 4', 'void', 'void', ' Push the current transformation matrix back unto the stack', 1042390554);
INSERT INTO php_manual VALUES (2585, 'swf_removeobject', 'PHP 4', 'void', 'int depth', 'Remove an object', 1042390554);
INSERT INTO php_manual VALUES (2586, 'swf_rotate', 'PHP 4', 'void', 'float angle, string axis', 'Rotate the current transformation', 1042390554);
INSERT INTO php_manual VALUES (2587, 'swf_scale', 'PHP 4', 'void', 'float x, float y, float z', 'Scale the current transformation', 1042390554);
INSERT INTO php_manual VALUES (2588, 'swf_setfont', 'PHP 4', 'void', 'int fontid', 'Change the current font', 1042390554);
INSERT INTO php_manual VALUES (2589, 'swf_setframe', 'PHP 4', 'void', 'int framenumber', 'Switch to a specified frame', 1042390554);
INSERT INTO php_manual VALUES (2590, 'swf_shapearc', 'PHP 4', 'void', 'float x, float y, float r, float ang1, float ang2', 'Draw a circular arc', 1042390554);
INSERT INTO php_manual VALUES (2591, 'swf_shapelineto', 'PHP 4', 'void', 'float x, float y', 'Draw a line', 1042390554);
INSERT INTO php_manual VALUES (2592, 'swf_shapecurveto', 'PHP 4', 'void', 'float x1, float y1, float x2, float y2', ' Draw a quadratic bezier curve between two points', 1042390554);
INSERT INTO php_manual VALUES (2593, 'swf_shapecurveto3', 'PHP 4', 'void', 'float x1, float y1, float x2, float y2, float x3, float y3', 'Draw a cubic bezier curve', 1042390554);
INSERT INTO php_manual VALUES (2594, 'swf_shapefillbitmapclip', 'PHP 4', 'void', 'int bitmapid', ' Set current fill mode to clipped bitmap', 1042390554);
INSERT INTO php_manual VALUES (2595, 'swf_shapefillbitmaptile', 'PHP 4', 'void', 'int bitmapid', ' Set current fill mode to tiled bitmap', 1042390554);
INSERT INTO php_manual VALUES (2596, 'swf_shapefilloff', 'PHP 4', 'void', 'void', 'Turns off filling', 1042390554);
INSERT INTO php_manual VALUES (2597, 'swf_shapefillsolid', 'PHP 4', 'void', 'float r, float g, float b, float a', ' Set the current fill style to the specified color', 1042390554);
INSERT INTO php_manual VALUES (2598, 'swf_shapelinesolid', 'PHP 4', 'void', 'float r, float g, float b, float a, float width', 'Set the current line style', 1042390554);
INSERT INTO php_manual VALUES (2599, 'swf_shapemoveto', 'PHP 4', 'void', 'float x, float y', 'Move the current position', 1042390554);
INSERT INTO php_manual VALUES (2600, 'swf_showframe', 'PHP 4', 'void', 'void', 'Display the current frame', 1042390554);
INSERT INTO php_manual VALUES (2601, 'swf_startbutton', 'PHP 4', 'void', 'int objid, int type', 'Start the definition of a button', 1042390554);
INSERT INTO php_manual VALUES (2602, 'swf_startdoaction', 'PHP 4', 'void', 'void', ' Start a description of an action list for the current frame', 1042390554);
INSERT INTO php_manual VALUES (2603, 'swf_startshape', 'PHP 4', 'void', 'int objid', 'Start a complex shape', 1042390554);
INSERT INTO php_manual VALUES (2604, 'swf_startsymbol', 'PHP 4', 'void', 'int objid', 'Define a symbol', 1042390554);
INSERT INTO php_manual VALUES (2605, 'swf_textwidth', 'PHP 4', 'float', 'string str', 'Get the width of a string', 1042390554);
INSERT INTO php_manual VALUES (2606, 'swf_translate', 'PHP 4', 'void', 'float x, float y, float z', 'Translate the current transformations', 1042390554);
INSERT INTO php_manual VALUES (2607, 'swf_viewport', 'PHP 4', 'void', 'float xmin, float xmax, float ymin, float ymax', 'Select an area for future drawing', 1042390554);
INSERT INTO php_manual VALUES (2608, 'sybase_affected_rows', 'PHP 3>= 3.0.6, PHP 4', 'int', '[int link_identifier ]', 'get number of affected rows in last query', 1042390554);
INSERT INTO php_manual VALUES (2609, 'sybase_close', 'PHP 3, PHP 4', 'bool', 'int link_identifier', 'close Sybase connection', 1042390554);
INSERT INTO php_manual VALUES (2610, 'sybase_connect', 'PHP 3, PHP 4', 'int', 'string servername, string username, string password, [string charset]', 'open Sybase server connection', 1042390554);
INSERT INTO php_manual VALUES (2611, 'sybase_data_seek', 'PHP 3, PHP 4', 'bool', 'int result_identifier, int row_number', 'move internal row pointer', 1042390554);
INSERT INTO php_manual VALUES (2612, 'sybase_fetch_array', 'PHP 3, PHP 4', 'array', 'int result', 'fetch row as array', 1042390554);
INSERT INTO php_manual VALUES (2613, 'sybase_fetch_field', 'PHP 3, PHP 4', 'object', 'int result, [int field_offset]', 'get field information', 1042390554);
INSERT INTO php_manual VALUES (2614, 'sybase_fetch_object', 'PHP 3, PHP 4', 'int', 'int result', 'fetch row as object', 1042390554);
INSERT INTO php_manual VALUES (2615, 'sybase_fetch_row', 'PHP 3, PHP 4', 'array', 'int result', 'get row as enumerated array', 1042390554);
INSERT INTO php_manual VALUES (2616, 'sybase_field_seek', 'PHP 3, PHP 4', 'int', 'int result, int field_offset', 'set field offset', 1042390555);
INSERT INTO php_manual VALUES (2617, 'sybase_free_result', 'PHP 3, PHP 4', 'bool', 'int result', 'free result memory', 1042390555);
INSERT INTO php_manual VALUES (2618, 'sybase_get_last_message', 'PHP 3, PHP 4', 'string', 'void', 'Returns the last message from the server', 1042390555);
INSERT INTO php_manual VALUES (2619, 'sybase_min_client_severity', 'PHP 3, PHP 4', 'void', 'int severity', 'Sets minimum client severity', 1042390555);
INSERT INTO php_manual VALUES (2620, 'sybase_min_error_severity', 'PHP 3, PHP 4', 'void', 'int severity', 'Sets minimum error severity', 1042390555);
INSERT INTO php_manual VALUES (2621, 'sybase_min_message_severity', 'PHP 3, PHP 4', 'void', 'int severity', 'Sets minimum message severity', 1042390555);
INSERT INTO php_manual VALUES (2622, 'sybase_min_server_severity', 'PHP 3, PHP 4', 'void', 'int severity', 'Sets minimum server severity', 1042390555);
INSERT INTO php_manual VALUES (2623, 'sybase_num_fields', 'PHP 3, PHP 4', 'int', 'int result', 'get number of fields in result', 1042390555);
INSERT INTO php_manual VALUES (2624, 'sybase_num_rows', 'PHP 3, PHP 4', 'int', 'int result', 'get number of rows in result', 1042390555);
INSERT INTO php_manual VALUES (2625, 'sybase_pconnect', 'PHP 3, PHP 4', 'int', 'string servername, string username, string password, [string charset]', 'open persistent Sybase connection', 1042390555);
INSERT INTO php_manual VALUES (2626, 'sybase_query', 'PHP 3, PHP 4', 'int', 'string query, int link_identifier', 'send Sybase query', 1042390555);
INSERT INTO php_manual VALUES (2627, 'sybase_result', 'PHP 3, PHP 4', 'string', 'int result, int row, mixed field', 'get result data', 1042390555);
INSERT INTO php_manual VALUES (2628, 'sybase_select_db', 'PHP 3, PHP 4', 'bool', 'string database_name, int link_identifier', 'select Sybase database', 1042390555);
INSERT INTO php_manual VALUES (2629, 'token_get_all', 'PHP 4 >= 4.2.0', 'array', 'string source', 'Split given source in tokens', 1042390555);
INSERT INTO php_manual VALUES (2630, 'token_name', 'PHP 4 >= 4.2.0', 'string', 'int type', 'Get the name of a given token', 1042390555);
INSERT INTO php_manual VALUES (2631, 'odbc_autocommit', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource connection_id, [bool OnOff]', 'Toggle autocommit behaviour', 1042390555);
INSERT INTO php_manual VALUES (2632, 'odbc_binmode', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id, int mode', 'Handling of binary column data', 1042390555);
INSERT INTO php_manual VALUES (2633, 'odbc_close_all', 'PHP 3>= 3.0.6, PHP 4', 'void', 'void', 'Close all ODBC connections', 1042390555);
INSERT INTO php_manual VALUES (2634, 'odbc_close', 'PHP 3>= 3.0.6, PHP 4', 'void', 'resource connection_id', 'Close an ODBC connection', 1042390555);
INSERT INTO php_manual VALUES (2635, 'odbc_columnprivileges', 'PHP 4', 'int', 'resource connection_id, [string qualifier], [string owner], [string table_name], [string column_name]', ' Returns a result identifier that can be used to fetch a list of columns and associated privileges', 1042390555);
INSERT INTO php_manual VALUES (2636, 'odbc_columns', 'PHP 4', 'int', 'resource connection_id, [string qualifier], [string schema], [string table_name], [string column_name]', ' Lists the column names in specified tables. Returns a result identifier containing the information.', 1042390555);
INSERT INTO php_manual VALUES (2637, 'odbc_commit', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource connection_id', 'Commit an ODBC transaction', 1042390555);
INSERT INTO php_manual VALUES (2638, 'odbc_connect', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'string dsn, string user, string password, [int cursor_type]', 'Connect to a datasource', 1042390555);
INSERT INTO php_manual VALUES (2639, 'odbc_cursor', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource result_id', 'Get cursorname', 1042390555);
INSERT INTO php_manual VALUES (2640, 'odbc_data_source', 'PHP 4 >= 4.3.0', 'resource', 'resource connection_id, constant fetch_type', 'Returns information about a current connection', 1042390555);
INSERT INTO php_manual VALUES (2641, 'odbc_do', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'resource conn_id, string query', 'Synonym for odbc_exec', 1042390555);
INSERT INTO php_manual VALUES (2642, 'odbc_error', 'PHP 4 >= 4.0.5', 'string', '[resource connection_id]', 'Get the last error code', 1042390555);
INSERT INTO php_manual VALUES (2643, 'odbc_errormsg', 'PHP 4 >= 4.0.5', 'string', '[resource connection_id]', 'Get the last error message', 1042390555);
INSERT INTO php_manual VALUES (2644, 'odbc_exec', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'resource connection_id, string query_string', 'Prepare and execute a SQL statement', 1042390555);
INSERT INTO php_manual VALUES (2645, 'odbc_execute', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource result_id, [array parameters_array]', 'Execute a prepared statement', 1042390555);
INSERT INTO php_manual VALUES (2646, 'odbc_fetch_array', 'PHP 4 >= 4.0.2', 'array', 'resource result, [int rownumber]', ' Fetch a result row as an associative array', 1042390555);
INSERT INTO php_manual VALUES (2647, 'odbc_fetch_into', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'resource result_id, [int rownumber], array result_array, resource result_id, array result_array, [int rownumber]', 'Fetch one result row into array', 1042390555);
INSERT INTO php_manual VALUES (2648, 'odbc_fetch_object', 'PHP 4 >= 4.0.2', 'object', 'resource result, [int rownumber]', ' Fetch a result row as an object', 1042390555);
INSERT INTO php_manual VALUES (2649, 'odbc_fetch_row', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource result_id, [int row_number]', 'Fetch a row', 1042390555);
INSERT INTO php_manual VALUES (2650, 'odbc_field_len', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id, int field_number', 'Get the length (precision) of a field', 1042390555);
INSERT INTO php_manual VALUES (2651, 'odbc_field_name', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource result_id, int field_number', 'Get the columnname', 1042390555);
INSERT INTO php_manual VALUES (2652, 'odbc_field_num', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id, string field_name', 'Return column number', 1042390555);
INSERT INTO php_manual VALUES (2653, 'odbc_field_precision', 'PHP 4', 'string', 'resource result_id, int field_number', 'Synonym for odbc_field_len', 1042390555);
INSERT INTO php_manual VALUES (2654, 'odbc_field_scale', 'PHP 4', 'string', 'resource result_id, int field_number', 'Get the scale of a field', 1042390555);
INSERT INTO php_manual VALUES (2655, 'odbc_field_type', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource result_id, int field_number', 'Datatype of a field', 1042390555);
INSERT INTO php_manual VALUES (2656, 'odbc_foreignkeys', 'PHP 4', 'resource', 'resource connection_id, string pk_qualifier, string pk_owner, string pk_table, string fk_qualifier, string fk_owner, string fk_table', ' Returns a list of foreign keys in the specified table or a list of foreign keys in other tables that refer to the primary key in the specified table', 1042390555);
INSERT INTO php_manual VALUES (2657, 'odbc_free_result', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource result_id', 'Free resources associated with a result', 1042390555);
INSERT INTO php_manual VALUES (2658, 'odbc_gettypeinfo', 'PHP 4', 'int', 'resource connection_id, [int data_type]', ' Returns a result identifier containing information about data types supported by the data source.', 1042390555);
INSERT INTO php_manual VALUES (2659, 'odbc_longreadlen', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id, int length', 'Handling of LONG columns', 1042390555);
INSERT INTO php_manual VALUES (2660, 'odbc_next_result', 'PHP 4 >= 4.0.5', 'bool', 'resource result_id', ' Checks if multiple results are avaiable', 1042390555);
INSERT INTO php_manual VALUES (2661, 'odbc_num_fields', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id', 'Number of columns in a result', 1042390555);
INSERT INTO php_manual VALUES (2662, 'odbc_num_rows', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id', 'Number of rows in a result', 1042390555);
INSERT INTO php_manual VALUES (2663, 'odbc_pconnect', 'PHP 3>= 3.0.6, PHP 4', 'int', 'string dsn, string user, string password, [int cursor_type]', 'Open a persistent database connection', 1042390555);
INSERT INTO php_manual VALUES (2664, 'odbc_prepare', 'PHP 3>= 3.0.6, PHP 4', 'resource', 'resource connection_id, string query_string', 'Prepares a statement for execution', 1042390555);
INSERT INTO php_manual VALUES (2665, 'odbc_primarykeys', 'PHP 4', 'resource', 'resource connection_id, string qualifier, string owner, string table', ' Returns a result identifier that can be used to fetch the column names that comprise the primary key for a table', 1042390555);
INSERT INTO php_manual VALUES (2666, 'odbc_procedurecolumns', 'PHP 4', 'resource', 'resource connection_id, [string qualifier], [string owner], [string proc], [string column]', ' Retrieve information about parameters to procedures', 1042390555);
INSERT INTO php_manual VALUES (2667, 'odbc_procedures', 'PHP 4', 'resource', 'resource connection_id, [string qualifier], [string owner], [string name]', ' Get the list of procedures stored in a specific data source. Returns a result identifier containing the information.', 1042390556);
INSERT INTO php_manual VALUES (2668, 'odbc_result_all', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource result_id, [string format]', 'Print result as HTML table', 1042390556);
INSERT INTO php_manual VALUES (2669, 'odbc_result', 'PHP 3>= 3.0.6, PHP 4', 'string', 'resource result_id, mixed field', 'Get result data', 1042390556);
INSERT INTO php_manual VALUES (2670, 'odbc_rollback', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource connection_id', 'Rollback a transaction', 1042390556);
INSERT INTO php_manual VALUES (2671, 'odbc_setoption', 'PHP 3>= 3.0.6, PHP 4', '', 'void', '', 1042390556);
INSERT INTO php_manual VALUES (2672, 'odbc_specialcolumns', 'PHP 4', 'resource', 'resource connection_id, int type, string qualifier, string owner, string table, int scope, int nullable', ' Returns either the optimal set of columns that uniquely identifies a row in the table or columns that are automatically updated when any value in the row is updated by a transaction', 1042390556);
INSERT INTO php_manual VALUES (2673, 'odbc_statistics', 'PHP 4', 'resource', 'resource connection_id, string qualifier, string owner, string table_name, int unique, int accuracy', 'Retrieve statistics about a table', 1042390556);
INSERT INTO php_manual VALUES (2674, 'odbc_tableprivileges', 'PHP 4', 'int', 'resource connection_id, [string qualifier], [string owner], [string name]', ' Lists tables and the privileges associated with each table', 1042390556);
INSERT INTO php_manual VALUES (2675, 'odbc_tables', 'PHP 3>= 3.0.17, PHP 4', 'int', 'resource connection_id, [string qualifier], [string owner], [string name], [string types]', ' Get the list of table names stored in a specific data source. Returns a result identifier containing the information.', 1042390556);
INSERT INTO php_manual VALUES (2676, 'base64_decode', 'PHP 3, PHP 4', 'string', 'string encoded_data', 'Decodes data encoded with MIME base64', 1042390556);
INSERT INTO php_manual VALUES (2677, 'base64_encode', 'PHP 3, PHP 4', 'string', 'string data', 'Encodes data with MIME base64', 1042390556);
INSERT INTO php_manual VALUES (2678, 'parse_url', 'PHP 3, PHP 4', 'array', 'string url', 'Parse a URL and return its components', 1042390556);
INSERT INTO php_manual VALUES (2679, 'rawurldecode', 'PHP 3, PHP 4', 'string', 'string str', 'Decode URL-encoded strings', 1042390556);
INSERT INTO php_manual VALUES (2680, 'rawurlencode', 'PHP 3, PHP 4', 'string', 'string str', 'URL-encode according to RFC 1738', 1042390556);
INSERT INTO php_manual VALUES (2681, 'urldecode', 'PHP 3, PHP 4', 'string', 'string str', 'Decodes URL-encoded string', 1042390556);
INSERT INTO php_manual VALUES (2682, 'urlencode', 'PHP 3, PHP 4', 'string', 'string str', 'URL-encodes string', 1042390556);
INSERT INTO php_manual VALUES (2683, 'doubleval', 'PHP 3, PHP 4', '', 'void', 'Alias of floatval', 1042390556);
INSERT INTO php_manual VALUES (2684, 'empty', '', 'boolean', 'mixed var', 'Determine whether a variable is set', 1042390556);
INSERT INTO php_manual VALUES (2685, 'floatval', 'PHP 4 >= 4.2.0', 'float', 'mixed var', 'Get float value of a variable', 1042390556);
INSERT INTO php_manual VALUES (2686, 'get_defined_vars', 'PHP 4 >= 4.0.4', 'array', 'void', ' Returns an array of all defined variables', 1042390556);
INSERT INTO php_manual VALUES (2687, 'get_resource_type', 'PHP 4 >= 4.0.2', 'string', 'resource handle', ' Returns the resource type', 1042390556);
INSERT INTO php_manual VALUES (2688, 'gettype', 'PHP 3, PHP 4', 'string', 'mixed var', 'Get the type of a variable', 1042390556);
INSERT INTO php_manual VALUES (2689, 'import_request_variables', 'PHP 4 >= 4.1.0', 'bool', 'string types, [string prefix]', 'Import GET/POST/Cookie variables into the global scope', 1042390556);
INSERT INTO php_manual VALUES (2690, 'intval', 'PHP 3, PHP 4', 'int', 'mixed var, [int base]', 'Get integer value of a variable', 1042390556);
INSERT INTO php_manual VALUES (2691, 'is_array', 'PHP 3, PHP 4', 'bool', 'mixed var', 'Finds whether a variable is an array', 1042390556);
INSERT INTO php_manual VALUES (2692, 'is_bool', 'PHP 4', 'bool', 'mixed var', ' Finds out whether a variable is a boolean', 1042390556);
INSERT INTO php_manual VALUES (2693, 'is_callable', 'PHP 4 >= 4.0.6', 'bool', 'mixed var, [bool syntax_only], [string callable_name]', ' Find out whether the argument is a valid callable construct', 1042390556);
INSERT INTO php_manual VALUES (2694, 'is_double', 'PHP 3, PHP 4', '', 'void', 'Alias of is_float', 1042390556);
INSERT INTO php_manual VALUES (2695, 'is_float', 'PHP 3, PHP 4', 'bool', 'mixed var', 'Finds whether a variable is a float', 1042390556);
INSERT INTO php_manual VALUES (2696, 'is_int', 'PHP 3, PHP 4', 'bool', 'mixed var', 'Find whether a variable is an integer', 1042390556);
INSERT INTO php_manual VALUES (2697, 'is_integer', 'PHP 3, PHP 4', '', 'void', 'Alias of is_int', 1042390556);
INSERT INTO php_manual VALUES (2698, 'is_long', 'PHP 3, PHP 4', '', 'void', 'Alias of is_int', 1042390556);
INSERT INTO php_manual VALUES (2699, 'is_null', 'PHP 4 >= 4.0.4', '', 'void', '', 1042390556);
INSERT INTO php_manual VALUES (2700, 'is_numeric', 'PHP 4', 'bool', 'mixed var', ' Finds whether a variable is a number or a numeric string', 1042390556);
INSERT INTO php_manual VALUES (2701, 'is_object', 'PHP 3, PHP 4', 'bool', 'mixed var', 'Finds whether a variable is an object', 1042390556);
INSERT INTO php_manual VALUES (2702, 'is_real', 'PHP 3, PHP 4', '', 'void', 'Alias of is_float', 1042390556);
INSERT INTO php_manual VALUES (2703, 'is_resource', 'PHP 4', 'bool', 'mixed var', ' Finds whether a variable is a resource', 1042390556);
INSERT INTO php_manual VALUES (2704, 'is_scalar', 'PHP 4 >= 4.0.5', 'bool', 'mixed var', ' Finds whether a variable is a scalar', 1042390556);
INSERT INTO php_manual VALUES (2705, 'is_string', 'PHP 3, PHP 4', 'bool', 'mixed var', 'Finds whether a variable is a string', 1042390556);
INSERT INTO php_manual VALUES (2706, 'isset', '', 'bool', 'mixed var, [mixed var], [ ...]', 'Determine whether a variable is set', 1042390556);
INSERT INTO php_manual VALUES (2707, 'print_r', 'PHP 4', 'bool', 'mixed expression', ' Prints human-readable information about a variable', 1042390556);
INSERT INTO php_manual VALUES (2708, 'serialize', 'PHP 3>= 3.0.5, PHP 4', 'string', 'mixed value', ' Generates a storable representation of a value', 1042390556);
INSERT INTO php_manual VALUES (2709, 'settype', 'PHP 3, PHP 4', 'bool', 'mixed var, string type', 'Set the type of a variable', 1042390556);
INSERT INTO php_manual VALUES (2710, 'strval', 'PHP 3, PHP 4', 'string', 'mixed var', 'Get string value of a variable', 1042390556);
INSERT INTO php_manual VALUES (2711, 'unserialize', 'PHP 3>= 3.0.5, PHP 4', 'mixed', 'string str, [string callback]', ' Creates a PHP value from a stored representation', 1042390556);
INSERT INTO php_manual VALUES (2712, 'unset', '', 'void', 'mixed var, [mixed var], [ ...]', 'Unset a given variable', 1042390556);
INSERT INTO php_manual VALUES (2713, 'var_dump', 'PHP 3>= 3.0.5, PHP 4', 'void', 'mixed expression, [mixed expression], [ ...]', 'Dumps information about a variable', 1042390557);
INSERT INTO php_manual VALUES (2714, 'var_export', 'PHP 4 >= 4.2.0', 'mixed', 'mixed expression, [bool return]', 'Outputs or returns a string representation of a variable', 1042390557);
INSERT INTO php_manual VALUES (2715, 'vpopmail_add_alias_domain_ex', '4.0.5 - 4.2.3 only', 'bool', 'string olddomain, string newdomain', 'Add alias to an existing virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2716, 'vpopmail_add_alias_domain', '4.0.5 - 4.2.3 only', 'bool', 'string domain, string aliasdomain', 'Add an alias for a virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2717, 'vpopmail_add_domain_ex', '4.0.5 - 4.2.3 only', 'bool', 'string domain, string passwd, [string quota], [string bounce], [bool apop]', 'Add a new virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2718, 'vpopmail_add_domain', '4.0.5 - 4.2.3 only', 'bool', 'string domain, string dir, int uid, int gid', 'Add a new virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2719, 'vpopmail_add_user', '4.0.5 - 4.2.3 only', 'bool', 'string user, string domain, string password, [string gecos], [bool apop]', 'Add a new user to the specified virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2720, 'vpopmail_alias_add', '4.1.0 - 4.2.3 only', 'bool', 'string user, string domain, string alias', 'insert a virtual alias', 1042390557);
INSERT INTO php_manual VALUES (2721, 'vpopmail_alias_del_domain', '4.1.0 - 4.2.3 only', 'bool', 'string domain', 'deletes all virtual aliases of a domain', 1042390557);
INSERT INTO php_manual VALUES (2722, 'vpopmail_alias_del', '4.1.0 - 4.2.3 only', 'bool', 'string user, string domain', 'deletes all virtual aliases of a user', 1042390557);
INSERT INTO php_manual VALUES (2723, 'vpopmail_alias_get_all', '4.1.0 - 4.2.3 only', 'array', 'string domain', 'get all lines of an alias for a domain', 1042390557);
INSERT INTO php_manual VALUES (2724, 'vpopmail_alias_get', '4.1.0 - 4.2.3 only', 'array', 'string alias, string domain', 'get all lines of an alias for a domain', 1042390557);
INSERT INTO php_manual VALUES (2725, 'vpopmail_auth_user', '4.0.5 - 4.2.3 only', 'bool', 'string user, string domain, string password, [string apop]', 'Attempt to validate a username/domain/password. Returns true/false', 1042390557);
INSERT INTO php_manual VALUES (2726, 'vpopmail_del_domain_ex', '4.0.5 - 4.2.3 only', 'bool', 'string domain', 'Delete a virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2727, 'vpopmail_error', '4.0.5 - 4.2.3 only', 'string', 'void', 'Get text message for last vpopmail error. Returns string', 1042390557);
INSERT INTO php_manual VALUES (2728, 'vpopmail_del_domain', '4.0.5 - 4.2.3 only', 'bool', 'string domain', 'Delete a virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2729, 'vpopmail_del_user', '4.0.5 - 4.2.3 only', 'bool', 'string user, string domain', 'Delete a user from a virtual domain', 1042390557);
INSERT INTO php_manual VALUES (2730, 'w32api_deftype', '4.2.0 - 4.2.3 only', 'bool', 'string typename, string member1_type, string member1_name, [string ...], [string ...]', 'Defines a type for use with other w32api_functions', 1042390557);
INSERT INTO php_manual VALUES (2731, 'w32api_init_dtype', '4.2.0 - 4.2.3 only', 'resource', 'string typename, mixed value, [mixed ...]', ' Creates an instance of the data type typename and fills it with the values passed', 1042390557);
INSERT INTO php_manual VALUES (2732, 'w32api_invoke_function', '4.2.0 - 4.2.3 only', 'mixed', 'string funcname, mixed argument, [mixed ...]', 'Invokes function funcname with the arguments passed after the function name', 1042390557);
INSERT INTO php_manual VALUES (2733, 'w32api_register_function', '4.2.0 - 4.2.3 only', 'bool', 'string libary, string function_name, string return_type', 'Registers function function_name from library with PHP', 1042390557);
INSERT INTO php_manual VALUES (2734, 'w32api_set_call_method', '4.2.0 - 4.2.3 only', 'void', 'int method', 'Sets the calling method used', 1042390557);
INSERT INTO php_manual VALUES (2735, 'wddx_add_vars', 'PHP 3>= 3.0.7, PHP 4', '', 'int packet_id, mixed name_var, [mixed ...]', ' Add variables to a WDDX packet with the specified ID', 1042390557);
INSERT INTO php_manual VALUES (2736, 'wddx_deserialize', 'PHP 3>= 3.0.7, PHP 4', 'mixed', 'string packet', 'Deserializes a WDDX packet', 1042390557);
INSERT INTO php_manual VALUES (2737, 'wddx_packet_end', 'PHP 3>= 3.0.7, PHP 4', 'string', 'int packet_id', 'Ends a WDDX packet with the specified ID', 1042390557);
INSERT INTO php_manual VALUES (2738, 'wddx_packet_start', 'PHP 3>= 3.0.7, PHP 4', 'int', '[string comment]', ' Starts a new WDDX packet with structure inside it', 1042390557);
INSERT INTO php_manual VALUES (2739, 'wddx_serialize_value', 'PHP 3>= 3.0.7, PHP 4', 'string', 'mixed var, [string comment]', 'Serialize a single value into a WDDX packet', 1042390557);
INSERT INTO php_manual VALUES (2740, 'wddx_serialize_vars', 'PHP 3>= 3.0.7, PHP 4', 'string', 'mixed var_name, [mixed ...]', 'Serialize variables into a WDDX packet', 1042390557);
INSERT INTO php_manual VALUES (2741, 'utf8_decode', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string data', ' Converts a string with ISO-8859-1 characters encoded with UTF-8 to single-byte ISO-8859-1.', 1042390557);
INSERT INTO php_manual VALUES (2742, 'utf8_encode', 'PHP 3>= 3.0.6, PHP 4', 'string', 'string data', 'encodes an ISO-8859-1 string to UTF-8', 1042390557);
INSERT INTO php_manual VALUES (2743, 'xml_error_string', 'PHP 3>= 3.0.6, PHP 4', 'string', 'int code', 'get XML parser error string', 1042390557);
INSERT INTO php_manual VALUES (2744, 'xml_get_current_byte_index', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource parser', 'get current byte index for an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2745, 'xml_get_current_column_number', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource parser', ' Get current column number for an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2746, 'xml_get_current_line_number', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource parser', 'get current line number for an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2747, 'xml_get_error_code', 'PHP 3>= 3.0.6, PHP 4', 'int', 'resource parser', 'get XML parser error code', 1042390557);
INSERT INTO php_manual VALUES (2748, 'xml_parse_into_struct', 'PHP 3>= 3.0.8, PHP 4', 'int', 'resource parser, string data, array &values, [array &index]', 'Parse XML data into an array structure', 1042390557);
INSERT INTO php_manual VALUES (2749, 'xml_parse', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string data, [bool is_final]', 'start parsing an XML document', 1042390557);
INSERT INTO php_manual VALUES (2750, 'xml_parser_create_ns', 'PHP 4 >= 4.0.5', 'resource', '[string encoding], [string sep]', ' Create an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2751, 'xml_parser_create', 'PHP 3>= 3.0.6, PHP 4', 'resource', '[string encoding]', 'create an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2752, 'xml_parser_free', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser', 'Free an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2753, 'xml_parser_get_option', 'PHP 3>= 3.0.6, PHP 4', 'mixed', 'resource parser, int option', 'get options from an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2754, 'xml_parser_set_option', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, int option, mixed value', 'set options in an XML parser', 1042390557);
INSERT INTO php_manual VALUES (2755, 'xml_set_character_data_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string handler', 'set up character data handler', 1042390557);
INSERT INTO php_manual VALUES (2756, 'xml_set_default_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string handler', 'set up default handler', 1042390557);
INSERT INTO php_manual VALUES (2757, 'xml_set_element_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string start_element_handler, string end_element_handler', 'set up start and end element handlers', 1042390558);
INSERT INTO php_manual VALUES (2758, 'xml_set_end_namespace_decl_handler', 'PHP 4 >= 4.0.5', 'bool', 'resource pind, string hdl', ' Set up character data handler', 1042390558);
INSERT INTO php_manual VALUES (2759, 'xml_set_external_entity_ref_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string handler', 'set up external entity reference handler', 1042390558);
INSERT INTO php_manual VALUES (2760, 'xml_set_notation_decl_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string handler', 'set up notation declaration handler', 1042390558);
INSERT INTO php_manual VALUES (2761, 'xml_set_object', 'PHP 4', 'void', 'resource parser, object object', 'Use XML Parser within an object', 1042390558);
INSERT INTO php_manual VALUES (2762, 'xml_set_processing_instruction_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string handler', ' Set up processing instruction (PI) handler', 1042390558);
INSERT INTO php_manual VALUES (2763, 'xml_set_start_namespace_decl_handler', 'PHP 4 >= 4.0.5', 'bool', 'resource pind, string hdl', ' Set up character data handler', 1042390558);
INSERT INTO php_manual VALUES (2764, 'xml_set_unparsed_entity_decl_handler', 'PHP 3>= 3.0.6, PHP 4', 'bool', 'resource parser, string handler', ' Set up unparsed entity declaration handler', 1042390558);
INSERT INTO php_manual VALUES (2765, 'xmlrpc_decode_request', 'PHP 4 >= 4.1.0', 'array', 'string xml, string method, [string encoding]', 'Decodes XML into native PHP types', 1042390558);
INSERT INTO php_manual VALUES (2766, 'xmlrpc_decode', 'PHP 4 >= 4.1.0', 'array', 'string xml, [string encoding]', 'Decodes XML into native PHP types', 1042390558);
INSERT INTO php_manual VALUES (2767, 'xmlrpc_encode_request', 'PHP 4 >= 4.1.0', 'string', 'string method, mixed params', 'Generates XML for a method request', 1042390558);
INSERT INTO php_manual VALUES (2768, 'xmlrpc_encode', 'PHP 4 >= 4.1.0', 'string', 'mixed value', 'Generates XML for a PHP value', 1042390558);
INSERT INTO php_manual VALUES (2769, 'xmlrpc_get_type', 'PHP 4 >= 4.1.0', 'string', 'mixed value', 'Gets xmlrpc type for a PHP value. Especially useful for base64 and datetime strings', 1042390558);
INSERT INTO php_manual VALUES (2770, 'xmlrpc_parse_method_descriptions', 'PHP 4 >= 4.1.0', 'array', 'string xml', 'Decodes XML into a list of method descriptions', 1042390558);
INSERT INTO php_manual VALUES (2771, 'xmlrpc_server_add_introspection_data', 'PHP 4 >= 4.1.0', 'int', 'resource server, array desc', 'Adds introspection documentation', 1042390558);
INSERT INTO php_manual VALUES (2772, 'xmlrpc_server_call_method', 'PHP 4 >= 4.1.0', 'mixed', 'resource server, string xml, mixed user_data, [array output_options]', 'Parses XML requests and call methods', 1042390558);
INSERT INTO php_manual VALUES (2773, 'xmlrpc_server_create', 'PHP 4 >= 4.1.0', 'resource', 'void', 'Creates an xmlrpc server', 1042390558);
INSERT INTO php_manual VALUES (2774, 'xmlrpc_server_destroy', 'PHP 4 >= 4.1.0', 'void', 'resource server', 'Destroys server resources', 1042390558);
INSERT INTO php_manual VALUES (2775, 'xmlrpc_server_register_introspection_callback', 'PHP 4 >= 4.1.0', 'bool', 'resource server, string function', 'Register a PHP function to generate documentation', 1042390558);
INSERT INTO php_manual VALUES (2776, 'xmlrpc_server_register_method', 'PHP 4 >= 4.1.0', 'bool', 'resource server, string method_name, string function', 'Register a PHP function to resource method matching method_name', 1042390558);
INSERT INTO php_manual VALUES (2777, 'xmlrpc_set_type', 'PHP 4 >= 4.1.0', 'bool', 'string value, string type', 'Sets xmlrpc type, base64 or datetime, for a PHP string value', 1042390558);
INSERT INTO php_manual VALUES (2778, 'xslt_create', 'PHP 4 >= 4.0.3', 'resource', 'void', 'Create a new XSLT processor', 1042390558);
INSERT INTO php_manual VALUES (2779, 'xslt_errno', 'PHP 4 >= 4.0.3', 'int', 'resource xh', 'Return a error number', 1042390558);
INSERT INTO php_manual VALUES (2780, 'xslt_error', 'PHP 4 >= 4.0.3', 'mixed', 'resource xh', 'Return a error string', 1042390558);
INSERT INTO php_manual VALUES (2781, 'xslt_free', 'PHP 4 >= 4.0.3', 'void', 'resource xh', 'Free XSLT processor', 1042390558);
INSERT INTO php_manual VALUES (2782, 'xslt_process', 'PHP 4 >= 4.0.3', 'mixed', 'resource xh, string xmlcontainer, string xslcontainer, [string resultcontainer], [array arguments], [array parameters]', 'Perform an XSLT transformation', 1042390558);
INSERT INTO php_manual VALUES (2783, 'xslt_set_base', 'PHP 4 >= 4.0.5', 'void', 'resource xh, string uri', 'Set the base URI for all XSLT transformations', 1042390558);
INSERT INTO php_manual VALUES (2784, 'xslt_set_encoding', 'PHP 4 >= 4.0.5', 'void', 'resource xh, string encoding', 'Set the encoding for the parsing of XML documents', 1042390558);
INSERT INTO php_manual VALUES (2785, 'xslt_set_error_handler', 'PHP 4 >= 4.0.4', 'void', 'resource xh, mixed handler', 'Set an error handler for a XSLT processor', 1042390558);
INSERT INTO php_manual VALUES (2786, 'xslt_set_log', 'PHP 4 >= 4.0.6', 'void', 'resource xh, mixed log', 'Set the log file to write log messages to', 1042390558);
INSERT INTO php_manual VALUES (2787, 'xslt_set_sax_handler', '4.0.3 - 4.0.6 only', 'void', 'resource xh, array handlers', 'Set SAX handlers for a XSLT processor', 1042390558);
INSERT INTO php_manual VALUES (2788, 'xslt_set_sax_handlers', 'PHP 4 >= 4.0.6', 'void', 'resource processor, array handlers', ' Set the SAX handlers to be called when the XML document gets processed', 1042390558);
INSERT INTO php_manual VALUES (2789, 'xslt_set_scheme_handler', '4.0.5 - 4.0.6 only', 'void', 'resource xh, array handlers', 'Set Scheme handlers for a XSLT processor', 1042390558);
INSERT INTO php_manual VALUES (2790, 'xslt_set_scheme_handlers', 'PHP 4 >= 4.0.6', 'void', 'resource processor, array handlers', ' Set the scheme handlers for the XSLT processor', 1042390558);
INSERT INTO php_manual VALUES (2791, 'yaz_addinfo', 'PHP 4 >= 4.0.1', 'int', 'int id', 'Returns additional error information', 1042390558);
INSERT INTO php_manual VALUES (2792, 'yaz_ccl_conf', 'PHP 4 >= 4.0.5', 'int', 'int id, array config', 'Configure CCL parser', 1042390558);
INSERT INTO php_manual VALUES (2793, 'yaz_ccl_parse', 'PHP 4 >= 4.0.5', 'int', 'int id, string query, array & result', 'Invoke CCL Parser', 1042390558);
INSERT INTO php_manual VALUES (2794, 'yaz_close', 'PHP 4 >= 4.0.1', 'int', 'int id', 'Closes a YAZ connection', 1042390558);
INSERT INTO php_manual VALUES (2795, 'yaz_connect', 'PHP 4 >= 4.0.1', 'int', 'string zurl, [mixed options]', ' Prepares for a connection and Z-association to a Z39.50 target.', 1042390558);
INSERT INTO php_manual VALUES (2796, 'yaz_database', 'PHP 4 >= 4.0.6', 'int', 'int id, string databases', ' Specifies the databases within a session', 1042390558);
INSERT INTO php_manual VALUES (2797, 'yaz_element', 'PHP 4 >= 4.0.1', 'int', 'int id, string elementset', ' Specifies Element-Set Name for retrieval', 1042390558);
INSERT INTO php_manual VALUES (2798, 'yaz_errno', 'PHP 4 >= 4.0.1', 'int', 'int id', 'Returns error number', 1042390558);
INSERT INTO php_manual VALUES (2799, 'yaz_error', 'PHP 4 >= 4.0.1', 'string', 'int id', 'Returns error description', 1042390558);
INSERT INTO php_manual VALUES (2800, 'yaz_hits', 'PHP 4 >= 4.0.1', 'int', 'int id', 'Returns number of hits for last search', 1042390558);
INSERT INTO php_manual VALUES (2801, 'yaz_itemorder', 'PHP 4 >= 4.0.5', 'int', 'array args', ' Prepares for Z39.50 Item Order with an ILL-Request package', 1042390559);
INSERT INTO php_manual VALUES (2802, 'yaz_present', 'PHP 4 >= 4.0.5', 'int', 'void', ' Prepares for retrieval (Z39.50 present).', 1042390559);
INSERT INTO php_manual VALUES (2803, 'yaz_range', 'PHP 4 >= 4.0.1', 'int', 'int id, int start, int number', ' Specifies the maximum number of records to retrieve', 1042390559);
INSERT INTO php_manual VALUES (2804, 'yaz_record', 'PHP 4 >= 4.0.1', 'int', 'int id, int pos, string type', 'Returns a record', 1042390559);
INSERT INTO php_manual VALUES (2805, 'yaz_scan_result', 'PHP 4 >= 4.0.5', 'array', 'int id, [array & result]', 'Returns Scan Response result', 1042390559);
INSERT INTO php_manual VALUES (2806, 'yaz_scan', 'PHP 4 >= 4.0.5', 'int', 'int id, string type, string startterm, [array flags]', 'Prepares for a scan', 1042390559);
INSERT INTO php_manual VALUES (2807, 'yaz_search', 'PHP 4 >= 4.0.1', 'int', 'int id, string type, string query', 'Prepares for a search', 1042390559);
INSERT INTO php_manual VALUES (2808, 'yaz_sort', 'PHP 4 >= 4.1.0', 'int', 'int id, string criteria', 'Sets sorting criteria', 1042390559);
INSERT INTO php_manual VALUES (2809, 'yaz_syntax', 'PHP 4 >= 4.0.1', 'int', 'int id, string syntax', ' Specifies the preferred record syntax for retrieval.', 1042390559);
INSERT INTO php_manual VALUES (2810, 'yaz_wait', 'PHP 4 >= 4.0.1', 'int', '[array options]', 'Wait for Z39.50 requests to complete', 1042390559);
INSERT INTO php_manual VALUES (2811, 'zip_close', 'PHP 4 >= 4.1.0', 'void', 'resource zip', 'Close a Zip File Archive', 1042390559);
INSERT INTO php_manual VALUES (2812, 'zip_entry_close', 'PHP 4 >= 4.1.0', 'void', 'resource zip_entry', 'Close a Directory Entry', 1042390559);
INSERT INTO php_manual VALUES (2813, 'zip_entry_compressedsize', 'PHP 4 >= 4.1.0', 'int', 'resource zip_entry', 'Retrieve the Compressed Size of a Directory Entry', 1042390559);
INSERT INTO php_manual VALUES (2814, 'zip_entry_compressionmethod', 'PHP 4 >= 4.1.0', 'string', 'resource zip_entry', 'Retrieve the Compression Method of a Directory Entry', 1042390559);
INSERT INTO php_manual VALUES (2815, 'zip_entry_filesize', 'PHP 4 >= 4.1.0', 'int', 'resource zip_entry', 'Retrieve the Actual File Size of a Directory Entry', 1042390559);
INSERT INTO php_manual VALUES (2816, 'zip_entry_name', 'PHP 4 >= 4.1.0', 'string', 'resource zip_entry', 'Retrieve the Name of a Directory Entry', 1042390559);
INSERT INTO php_manual VALUES (2817, 'zip_entry_open', 'PHP 4 >= 4.1.0', 'bool', 'resource zip, resource zip_entry, [string mode]', 'Open a Directory Entry for Reading', 1042390559);
INSERT INTO php_manual VALUES (2818, 'zip_entry_read', 'PHP 4 >= 4.1.0', 'string', 'resource zip_entry, [int length]', 'Read From an Open Directory Entry', 1042390559);
INSERT INTO php_manual VALUES (2819, 'zip_open', 'PHP 4 >= 4.1.0', 'resource', 'string filename', 'Open a Zip File Archive', 1042390559);
INSERT INTO php_manual VALUES (2820, 'zip_read', 'PHP 4 >= 4.1.0', 'resource', 'resource zip', 'Read Next Entry in a Zip File Archive', 1042390559);
INSERT INTO php_manual VALUES (2821, 'gzclose', 'PHP 3, PHP 4', 'int', 'resource zp', 'Close an open gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2822, 'gzcompress', 'PHP 4 >= 4.0.1', 'string', 'string data, [int level]', 'Compress a string', 1042390559);
INSERT INTO php_manual VALUES (2823, 'gzdeflate', 'PHP 4 >= 4.0.4', 'string', 'string data, [int level]', 'Deflate a string', 1042390559);
INSERT INTO php_manual VALUES (2824, 'gzencode', 'PHP 4 >= 4.0.4', 'string', 'string data, [int level], [int encoding_mode]', 'Create a gzip compressed string', 1042390559);
INSERT INTO php_manual VALUES (2825, 'gzeof', 'PHP 3, PHP 4', 'int', 'resource zp', 'Test for end-of-file on a gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2826, 'gzfile', 'PHP 3, PHP 4', 'array', 'string filename, [int use_include_path]', 'Read entire gz-file into an array', 1042390559);
INSERT INTO php_manual VALUES (2827, 'gzgetc', 'PHP 3, PHP 4', 'string', 'resource zp', 'Get character from gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2828, 'gzgets', 'PHP 3, PHP 4', 'string', 'resource zp, int length', 'Get line from file pointer', 1042390559);
INSERT INTO php_manual VALUES (2829, 'gzgetss', 'PHP 3, PHP 4', 'string', 'resource zp, int length, [string allowable_tags]', ' Get line from gz-file pointer and strip HTML tags', 1042390559);
INSERT INTO php_manual VALUES (2830, 'gzinflate', 'PHP 4 >= 4.0.4', 'string', 'string data, [int length]', 'Inflate a deflated string', 1042390559);
INSERT INTO php_manual VALUES (2831, 'gzopen', 'PHP 3, PHP 4', 'resource', 'string filename, string mode, [int use_include_path]', 'Open gz-file', 1042390559);
INSERT INTO php_manual VALUES (2832, 'gzpassthru', 'PHP 3, PHP 4', 'int', 'resource zp', ' Output all remaining data on a gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2833, 'gzputs', 'PHP 3, PHP 4', 'int', 'resource zp, string str, [int length]', 'Write to a gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2834, 'gzread', 'PHP 3, PHP 4', 'string', 'resource zp, int length', 'Binary-safe gz-file read', 1042390559);
INSERT INTO php_manual VALUES (2835, 'gzrewind', 'PHP 3, PHP 4', 'int', 'resource zp', 'Rewind the position of a gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2836, 'gzseek', 'PHP 3, PHP 4', 'int', 'resource zp, int offset', 'Seek on a gz-file pointer', 1042390559);
INSERT INTO php_manual VALUES (2837, 'gztell', 'PHP 3, PHP 4', 'int', 'resource zp', 'Tell gz-file pointer read/write position', 1042390559);
INSERT INTO php_manual VALUES (2838, 'gzuncompress', 'PHP 4 >= 4.0.1', 'string', 'string data, [int length]', 'Uncompress a deflated string', 1042390559);
INSERT INTO php_manual VALUES (2839, 'gzwrite', 'PHP 3, PHP 4', 'int', 'resource zp, string string, [int length]', 'Binary-safe gz-file write', 1042390559);
INSERT INTO php_manual VALUES (2840, 'readgzfile', 'PHP 3, PHP 4', 'int', 'string filename, [int use_include_path]', 'Output a gz-file', 1042390559);
INSERT INTO php_manual VALUES (2841, 'forexs_evil', 'PHP >= 4.3.0-dev (CVS Only)', 'bool', '[bool on/off]', 'Tests if Forexs is in "Evil mode" at this Time. The optional argument can attempt to change this mode.', 999999999);

