<?php
/**
 * DocBlock Generator
 *
 * PHP version 5
 *
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * + Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * + Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * + The names of its contributors may not be used to endorse or
 * promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  PHP
 * @package   PHP_DocBlockGenerator
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2007 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   SVN: $Id: DocBlockGeneratorTest.php 31 2007-09-13 10:21:01Z mcorne $
 * @link      http://pear.php.net/package/PHP_DocBlockGenerator
 */

// Keep tests from running twice when calling this file directly via PHPUnit.
$call_main = false;
if (strpos($_SERVER['argv'][0], 'phpunit') === false) {
    // Called via php, not PHPUnit.  Pass the request to PHPUnit.
    if (!defined('PHPUnit_MAIN_METHOD')) {
        /** The test's main method name */
        define('PHPUnit_MAIN_METHOD', 'tests_DocBlockGeneratorTest::main');
        $call_main = true;
    }
}

require_once dirname(__FILE__) . '/helper.inc';

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'PHP/DocBlockGenerator.php';

/**
 * Test class for PHP_DocBlockGenerator.
 * Generated by PHPUnit_Util_Skeleton on 2007-05-18 at 18:49:09.
 *
 * @category  PHP
 * @package   PHP_DocBlockGenerator
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2007 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   Release: @package_version@
 * @link      http://pear.php.net/package/PHP_DocBlockGenerator
 */
class tests_DocBlockGeneratorTest extends PHPUnit_Framework_TestCase
{
    /**
     * The PHP_DocBlockGenerator class instance
     *
     * @var    object
     * @access private
     */
    private $docBlockGen;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        $suite = new PHPUnit_Framework_TestSuite("PHP_DocBlockGeneratorTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $this->docBlockGen = new PHP_DocBlockGenerator();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown()
    {
    }

    /**
     * Tag alignment test
     *
     * A note from danielc@php.net while getting the test suite working:
     * In blocks other than page level and class level, the alignment isn't 
     * working between @tag names and their values.  One space is always used.  
     * Changing it at this point seemed like it would lead to unexpected and 
     * unnecessary whitespace changes for end users.  If this ever gets fixed, 
     * please remove th markTestSkipped() call, below.
     */
    public function testTagAlign()
    {
        $this->markTestSkipped('Did this ever work?');

        $param = array(
            'year' => '2007',
            );

        ($result = $this->genDocBlockTest('TagAlignments.php', $param)) === true or $this->fail($result);
    }

    /**
     * Tag types test
     */
    public function testTypes()
    {
        $param = array(
            'year' => '2007',
            );

        ($result = $this->genDocBlockTest('TagTypes.php', $param)) === true or $this->fail($result);
    }

    /**
     * Pear file test
     */
    public function testPearFile()
    {
        $param = array(
            'year' => '2007',
            );

        ($result = $this->genDocBlockTest('Pear.php', $param)) === true or $this->fail($result);
    }

    /**
     * Parameters test
     */
    public function testParameters()
    {
        $param = array(// /
            'author' => 'John Foo',
            'category' => 'PHP',
            'email' => 'jfoo@mail.com',
            'license' => 'apache20',
            'link' => 'http://link-to-some-url',
            'package' => 'DocBlockGeneratorTest',
            'version' => '1.23',
            'year' => '2000-2007',
            );

        ($result = $this->genDocBlockTest('Parameters.php', $param)) === true or $this->fail($result);
    }

    /**
     * Tests Doc Blocks tags, types, and alignements
     *
     * Reads each test input file, e.g. TypesTest.php. Creates the DocBlocks in
     * a (generated) file and compares with the test result file of reference,
     * e.g. TypesRefResult.php. Displays the first error for each file if any:
     * the line number, the expected line, the line generated by the test.
     *
     * The test result files of reference can be generated as whole with
     * the genrefresults script.
     *
     * @return void
     * @access private
     */
    private function genDocBlockTest($fileName, $param = array())
    {
        // creates the input, reference and generated file names
        $dir = dirname(__FILE__);
        $infile = "$dir/data/$fileName";
        $refFile = "$dir/reference/$fileName";
        $outfile = "$dir/generated/$fileName";
        // runs the process
        $this->docBlockGen->generate($infile, $param, $outfile) or die("Error! Cannot access|read|write the file: $infile");
        // reads the reference file, strips trailing spaces and eol characters
        $reference = file($refFile);
        $reference = preg_replace('~\$Id[^$]*\$~', '\$Id CVS DATA REMOVED FOR TESTING\$', $reference, 1);
        $reference = array_map('rtrim', $reference);
        // reads the output file, strips trailing spaces and eol characters
        $output = file($outfile);
        $output = preg_replace('~\$Id[^$]*\$~', '\$Id CVS DATA REMOVED FOR TESTING\$', $output, 1);
        $output = array_map('rtrim', $output);

        if ($diff = array_diff_assoc($reference, $output)) {
            // the output file is different from the reference
            $key = key($diff);
            // sets the line number of the first different line, builds the error message
            $lineNb = $key + 1;
            $error[] = "ERROR line: $lineNb";
            $error[] = "expecting :{$reference[$key]}, as in ./reference/$fileName";
            $error[] = "instead of:{$output[$key]}, in ./generated/$fileName";

            return implode("\n", $error);;
        }

        return true;
    }
}

if ($call_main) {
    tests_DocBlockGeneratorTest::main();
}
