<?php
/**
 * this is an example of a package
 *
 * calls to the tracer are added wherever there is a need to trace a function call
 * these calls can be left in the package, they are executed only if the tracer is loaded
 */
class math {
    /**
     * tracing the arguments and the returned parameter
     *
     * processing all return returned variables (empty means all)
     * the first user function is used by defaut
     *
     * note that traceReturn() calls traceArguments() by default which is fine here
     * since this method does call other methods to trace
     */
    public static function prod($x, $y)
    {
        // class_exists('PHP_FunctionCallTracer', false) and
        // PHP_FunctionCallTracer::traceArguments();
        $p = $x * $y;

        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceReturn($p) and
        PHP_FunctionCallTracer::processVariables();

        return $p;
    }

    /**
     * tracing the arguments and the returned parameter
     *
     * processing all arguments (true means all) with the second user function is used
     *
     * traceArguments() and/or processVariables() must be called here
     * since this method calls other methods
     * that may be traced, so that traced calls are displayed in the right order
     *
     * note that processVariables() calls traceArguments() by default
     */
    public static function square($x)
    {
        class_exists('PHP_FunctionCallTracer', false) and
        // PHP_FunctionCallTracer::traceArguments() and
        PHP_FunctionCallTracer::processVariables(null, true);

        $x2 = self::prod($x, $x);

        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceReturn($x2);
        return $x2;
    }
}

class geometry {
    private $pi = 3.14;

    /**
     * tracing the arguments and the returned parameter
     * another variable is traced along with the returned parameter
     *
     * processing the first and the second returned parameters
     * the first one with the second user function and
     * the second one with the third user function
     */
    public function circle($r)
    {
        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceArguments();

        $pi2 = 2 * $this->pi;
        $c = math::prod($r, $pi2);

        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceReturn($c, $pi2) and
        PHP_FunctionCallTracer::processVariables(null, array(0), array(1));
        return $c;
    }

    /**
     * tracing the arguments, some variables and the returned parameter
     *
     * processing the first and second traced variables with the third user function
     */
    public function disk($r)
    {
        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceArguments();

        $r2 = math::square($r);
        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceVariables($r2, $this->pi) and
        PHP_FunctionCallTracer::processVariables(null, null, array(0, 1));

        $d = math::prod($r2, $this->pi);

        class_exists('PHP_FunctionCallTracer', false) and
        PHP_FunctionCallTracer::traceReturn($d);
        return $d;
    }
}

?>