<?php
/**
 * This file contains sample codes to demonstrate PHP_UML's capabilities through its public API.
 *
 * See also the screen captures that you can obtain in various UML softwares, on the base of
 * the XMI generated by the following examples.
 *
 * BEWARE: test_example2.xmi is generated in XMI version 2, so you can import it only
 * in a UML tool compatible with the version 2 of XMI (like Eclipse or Bouml)
 *
 * PHP version 5
 *
 * @category PHP
 * @package  PHP_UML
 * @author   Baptiste Autin <ohlesbeauxjours@yahoo.fr>
 *
 */

error_reporting(E_ALL);
require_once 'PHP/UML.php';


/**
 * Example 1: Basic example with file "test.php", in UML/XMI version 2
 */

$t = new PHP_UML;
$t->setMatchPatterns('*');

$t->parseFile('test1.php.txt', 'global');   // We parse the file "test.php" ; the default namespace is 'global'
$t->export('xmi', 'test_example1.xmi');     // We export the model as XMI/UML code



/**
 * Example 2: Advanced example in UML/XMI version 1. It shows how to explicitely
 * use an Exporter object, in order to get access to more configuration options.
 */

$t = new PHP_UML;

$t->dollar         = false;    // We don't keep the $ before the variable names
$t->componentView  = false;    // We don't want a component view to be included
$t->deploymentView = false;    // We don't want a deployment view (artifacts+folders)
$t->docblocks      = true;     // We want the parser to look into the class/file comments

$t->setInput('test1.php.txt, test2.php.txt');   // We want only "test1.php.txt" and "test2.php.txt"
$t->parse('testModel');                // The files are parsed, and a UML model named "testModel" is built

// we retrieve an XMI implementation of an Exporter object, and set the model:
$e = new PHP_UML_Output_Xmi_Exporter();
$e->setModel($t->getModel());

// we set the XMI version (2.1 being the default if not set)
$e->setXmiVersion(1);
// we set the encoding (iso-8859-1 being the default if not set):
$e->setEncoding('UTF-8');
// and we export XMI to a file:
$e->export('test_example2.xmi');  

// we can also print the serialized XMI by retrieving an XmiDocument from the exporter object:
echo htmlentities($e->getXmiDocument()->dump());


/**
 * Example 3 : Example with a whole directory of PHP files to parse. We just want to
 * generate the API documentation in HTML.
 */
 
$t = new PHP_UML;

$t->setMatchPatterns(array('*.php', '*.txt'));   // We want to parse every file with an extension "php" or "txt"
$t->setIgnorePatterns('.svn');                   // We want all directories to be scanned, except the ".svn"

$t->setInput('./');                              // ... in the current directory
$t->parse();                                     // Starts parsing
$t->export('htmlnew', 'doc/');                   // And the HTML API is exported into the folder "doc/"
     
echo '<br/>Done !!';

?>
