<?php

require_once 'UnitTestCommon.php';

class Services_Facebook_BatchTest extends Services_Facebook_UnitTestCommon
{

    public function testRun()
    {
        $response = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<batch_run_response xmlns="http://api.facebook.com/1.0/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd" list="true">
  <batch_run_response_elt>&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;
&lt;admin_getRestrictionInfo_response xmlns=&quot;http://api.facebook.com/1.0/&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot; xsi:schemaLocation=&quot;http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd&quot;/&gt;
</batch_run_response_elt>
  <batch_run_response_elt>&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;
&lt;friends_get_response xmlns=&quot;http://api.facebook.com/1.0/&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot; xsi:schemaLocation=&quot;http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd&quot; list=&quot;true&quot;&gt;
  &lt;uid&gt;924343&lt;/uid&gt;
  &lt;uid&gt;1800610&lt;/uid&gt;
  &lt;uid&gt;1801217&lt;/uid&gt;
  &lt;uid&gt;1956303&lt;/uid&gt;
  &lt;uid&gt;2047410&lt;/uid&gt;
  &lt;uid&gt;2060613&lt;/uid&gt;
  &lt;uid&gt;2339274&lt;/uid&gt;
  &lt;uid&gt;2525874&lt;/uid&gt;
  &lt;uid&gt;2900526&lt;/uid&gt;
  &lt;uid&gt;3206887&lt;/uid&gt;
  &lt;uid&gt;3211942&lt;/uid&gt;
  &lt;uid&gt;3600830&lt;/uid&gt;
  &lt;uid&gt;3615689&lt;/uid&gt;
  &lt;uid&gt;5136658&lt;/uid&gt;
  &lt;uid&gt;5213428&lt;/uid&gt;
  &lt;uid&gt;5219119&lt;/uid&gt;
  &lt;uid&gt;5502809&lt;/uid&gt;
  &lt;uid&gt;5506555&lt;/uid&gt;
  &lt;uid&gt;6205900&lt;/uid&gt;
  &lt;uid&gt;6208191&lt;/uid&gt;
  &lt;uid&gt;6419079&lt;/uid&gt;
  &lt;uid&gt;6707823&lt;/uid&gt;
  &lt;uid&gt;6709381&lt;/uid&gt;
  &lt;uid&gt;7100591&lt;/uid&gt;
  &lt;uid&gt;7300752&lt;/uid&gt;
  &lt;uid&gt;7900976&lt;/uid&gt;
  &lt;uid&gt;7907485&lt;/uid&gt;
  &lt;uid&gt;10100090&lt;/uid&gt;
  &lt;uid&gt;10100094&lt;/uid&gt;
  &lt;uid&gt;10805374&lt;/uid&gt;
  &lt;uid&gt;10805407&lt;/uid&gt;
  &lt;uid&gt;11710089&lt;/uid&gt;
  &lt;uid&gt;11710442&lt;/uid&gt;
  &lt;uid&gt;11711995&lt;/uid&gt;
  &lt;uid&gt;11712668&lt;/uid&gt;
  &lt;uid&gt;11713628&lt;/uid&gt;
  &lt;uid&gt;13901499&lt;/uid&gt;
  &lt;uid&gt;16810426&lt;/uid&gt;
  &lt;uid&gt;19101078&lt;/uid&gt;
  &lt;uid&gt;24400215&lt;/uid&gt;
  &lt;uid&gt;24604046&lt;/uid&gt;
  &lt;uid&gt;25820054&lt;/uid&gt;
  &lt;uid&gt;28000695&lt;/uid&gt;
  &lt;uid&gt;31206956&lt;/uid&gt;
  &lt;uid&gt;31504263&lt;/uid&gt;
  &lt;uid&gt;31505226&lt;/uid&gt;
  &lt;uid&gt;48500398&lt;/uid&gt;
  &lt;uid&gt;139501608&lt;/uid&gt;
  &lt;uid&gt;150800301&lt;/uid&gt;
  &lt;uid&gt;205500751&lt;/uid&gt;
  &lt;uid&gt;207600079&lt;/uid&gt;
  &lt;uid&gt;300600986&lt;/uid&gt;
  &lt;uid&gt;500014674&lt;/uid&gt;
  &lt;uid&gt;500064183&lt;/uid&gt;
  &lt;uid&gt;500550877&lt;/uid&gt;
  &lt;uid&gt;501969281&lt;/uid&gt;
  &lt;uid&gt;502299309&lt;/uid&gt;
  &lt;uid&gt;502572405&lt;/uid&gt;
  &lt;uid&gt;504036696&lt;/uid&gt;
  &lt;uid&gt;505261656&lt;/uid&gt;
  &lt;uid&gt;506530677&lt;/uid&gt;
  &lt;uid&gt;506587162&lt;/uid&gt;
  &lt;uid&gt;506788940&lt;/uid&gt;
  &lt;uid&gt;507128476&lt;/uid&gt;
  &lt;uid&gt;507394162&lt;/uid&gt;
  &lt;uid&gt;507448344&lt;/uid&gt;
  &lt;uid&gt;507448584&lt;/uid&gt;
  &lt;uid&gt;507711850&lt;/uid&gt;
  &lt;uid&gt;507903603&lt;/uid&gt;
  &lt;uid&gt;508643272&lt;/uid&gt;
  &lt;uid&gt;508783820&lt;/uid&gt;
  &lt;uid&gt;510631642&lt;/uid&gt;
  &lt;uid&gt;510895546&lt;/uid&gt;
  &lt;uid&gt;511618270&lt;/uid&gt;
  &lt;uid&gt;512633777&lt;/uid&gt;
  &lt;uid&gt;515853053&lt;/uid&gt;
  &lt;uid&gt;516321254&lt;/uid&gt;
  &lt;uid&gt;516392300&lt;/uid&gt;
  &lt;uid&gt;516757131&lt;/uid&gt;
  &lt;uid&gt;516963717&lt;/uid&gt;
  &lt;uid&gt;517935176&lt;/uid&gt;
  &lt;uid&gt;518325749&lt;/uid&gt;
  &lt;uid&gt;518481798&lt;/uid&gt;
  &lt;uid&gt;520021154&lt;/uid&gt;
  &lt;uid&gt;521083801&lt;/uid&gt;
  &lt;uid&gt;521541519&lt;/uid&gt;
  &lt;uid&gt;521701871&lt;/uid&gt;
  &lt;uid&gt;523947141&lt;/uid&gt;
  &lt;uid&gt;524762567&lt;/uid&gt;
  &lt;uid&gt;525283734&lt;/uid&gt;
  &lt;uid&gt;526312843&lt;/uid&gt;
  &lt;uid&gt;527595441&lt;/uid&gt;
  &lt;uid&gt;533169573&lt;/uid&gt;
  &lt;uid&gt;533547433&lt;/uid&gt;
  &lt;uid&gt;533871460&lt;/uid&gt;
  &lt;uid&gt;536269226&lt;/uid&gt;
  &lt;uid&gt;536293752&lt;/uid&gt;
  &lt;uid&gt;536985977&lt;/uid&gt;
  &lt;uid&gt;540337396&lt;/uid&gt;
  &lt;uid&gt;540611343&lt;/uid&gt;
  &lt;uid&gt;541263020&lt;/uid&gt;
  &lt;uid&gt;541381164&lt;/uid&gt;
  &lt;uid&gt;542846298&lt;/uid&gt;
  &lt;uid&gt;543360467&lt;/uid&gt;
  &lt;uid&gt;543695617&lt;/uid&gt;
  &lt;uid&gt;544361673&lt;/uid&gt;
  &lt;uid&gt;544916521&lt;/uid&gt;
  &lt;uid&gt;547217860&lt;/uid&gt;
  &lt;uid&gt;547304461&lt;/uid&gt;
  &lt;uid&gt;549003324&lt;/uid&gt;
  &lt;uid&gt;549025920&lt;/uid&gt;
  &lt;uid&gt;550123083&lt;/uid&gt;
  &lt;uid&gt;551623090&lt;/uid&gt;
  &lt;uid&gt;553420695&lt;/uid&gt;
  &lt;uid&gt;554268300&lt;/uid&gt;
  &lt;uid&gt;555921469&lt;/uid&gt;
  &lt;uid&gt;556391032&lt;/uid&gt;
  &lt;uid&gt;557755726&lt;/uid&gt;
  &lt;uid&gt;558470465&lt;/uid&gt;
  &lt;uid&gt;561029031&lt;/uid&gt;
  &lt;uid&gt;561413796&lt;/uid&gt;
  &lt;uid&gt;565787064&lt;/uid&gt;
  &lt;uid&gt;566771148&lt;/uid&gt;
  &lt;uid&gt;567693799&lt;/uid&gt;
  &lt;uid&gt;570936903&lt;/uid&gt;
  &lt;uid&gt;571503332&lt;/uid&gt;
  &lt;uid&gt;571573101&lt;/uid&gt;
  &lt;uid&gt;571672353&lt;/uid&gt;
  &lt;uid&gt;572062896&lt;/uid&gt;
  &lt;uid&gt;572296682&lt;/uid&gt;
  &lt;uid&gt;574255686&lt;/uid&gt;
  &lt;uid&gt;576421097&lt;/uid&gt;
  &lt;uid&gt;576828685&lt;/uid&gt;
  &lt;uid&gt;576982991&lt;/uid&gt;
  &lt;uid&gt;578822015&lt;/uid&gt;
  &lt;uid&gt;579358722&lt;/uid&gt;
  &lt;uid&gt;582326215&lt;/uid&gt;
  &lt;uid&gt;586036296&lt;/uid&gt;
  &lt;uid&gt;586843227&lt;/uid&gt;
  &lt;uid&gt;587212468&lt;/uid&gt;
  &lt;uid&gt;588183661&lt;/uid&gt;
  &lt;uid&gt;590288834&lt;/uid&gt;
  &lt;uid&gt;591775885&lt;/uid&gt;
  &lt;uid&gt;592697827&lt;/uid&gt;
  &lt;uid&gt;594312720&lt;/uid&gt;
  &lt;uid&gt;595635887&lt;/uid&gt;
  &lt;uid&gt;596289435&lt;/uid&gt;
  &lt;uid&gt;596671190&lt;/uid&gt;
  &lt;uid&gt;597511912&lt;/uid&gt;
  &lt;uid&gt;597641690&lt;/uid&gt;
  &lt;uid&gt;599565900&lt;/uid&gt;
  &lt;uid&gt;600725188&lt;/uid&gt;
  &lt;uid&gt;601212815&lt;/uid&gt;
  &lt;uid&gt;602388611&lt;/uid&gt;
  &lt;uid&gt;602493988&lt;/uid&gt;
  &lt;uid&gt;602621859&lt;/uid&gt;
  &lt;uid&gt;604358504&lt;/uid&gt;
  &lt;uid&gt;604946655&lt;/uid&gt;
  &lt;uid&gt;606911109&lt;/uid&gt;
  &lt;uid&gt;607599534&lt;/uid&gt;
  &lt;uid&gt;608113377&lt;/uid&gt;
  &lt;uid&gt;608286842&lt;/uid&gt;
  &lt;uid&gt;609211484&lt;/uid&gt;
  &lt;uid&gt;610632906&lt;/uid&gt;
  &lt;uid&gt;613065196&lt;/uid&gt;
  &lt;uid&gt;615635031&lt;/uid&gt;
  &lt;uid&gt;616511426&lt;/uid&gt;
  &lt;uid&gt;617370918&lt;/uid&gt;
  &lt;uid&gt;619208974&lt;/uid&gt;
  &lt;uid&gt;620431575&lt;/uid&gt;
  &lt;uid&gt;621926171&lt;/uid&gt;
  &lt;uid&gt;625039006&lt;/uid&gt;
  &lt;uid&gt;626288316&lt;/uid&gt;
  &lt;uid&gt;627311631&lt;/uid&gt;
  &lt;uid&gt;628843106&lt;/uid&gt;
  &lt;uid&gt;629986493&lt;/uid&gt;
  &lt;uid&gt;633297258&lt;/uid&gt;
  &lt;uid&gt;634907956&lt;/uid&gt;
  &lt;uid&gt;635266168&lt;/uid&gt;
  &lt;uid&gt;639057390&lt;/uid&gt;
  &lt;uid&gt;640061028&lt;/uid&gt;
  &lt;uid&gt;641116400&lt;/uid&gt;
  &lt;uid&gt;641212743&lt;/uid&gt;
  &lt;uid&gt;641319101&lt;/uid&gt;
  &lt;uid&gt;642015822&lt;/uid&gt;
  &lt;uid&gt;643030443&lt;/uid&gt;
  &lt;uid&gt;644430608&lt;/uid&gt;
  &lt;uid&gt;646061993&lt;/uid&gt;
  &lt;uid&gt;646593393&lt;/uid&gt;
  &lt;uid&gt;649935359&lt;/uid&gt;
  &lt;uid&gt;649958816&lt;/uid&gt;
  &lt;uid&gt;651196926&lt;/uid&gt;
  &lt;uid&gt;652965146&lt;/uid&gt;
  &lt;uid&gt;654094921&lt;/uid&gt;
  &lt;uid&gt;654876210&lt;/uid&gt;
  &lt;uid&gt;655048618&lt;/uid&gt;
  &lt;uid&gt;656446026&lt;/uid&gt;
  &lt;uid&gt;658641336&lt;/uid&gt;
  &lt;uid&gt;659382260&lt;/uid&gt;
  &lt;uid&gt;659778406&lt;/uid&gt;
  &lt;uid&gt;660524972&lt;/uid&gt;
  &lt;uid&gt;661721333&lt;/uid&gt;
  &lt;uid&gt;662764289&lt;/uid&gt;
  &lt;uid&gt;663022026&lt;/uid&gt;
  &lt;uid&gt;665613168&lt;/uid&gt;
  &lt;uid&gt;666653204&lt;/uid&gt;
  &lt;uid&gt;667337224&lt;/uid&gt;
  &lt;uid&gt;667548457&lt;/uid&gt;
  &lt;uid&gt;669245952&lt;/uid&gt;
  &lt;uid&gt;670105209&lt;/uid&gt;
  &lt;uid&gt;670956942&lt;/uid&gt;
  &lt;uid&gt;672653037&lt;/uid&gt;
  &lt;uid&gt;673235384&lt;/uid&gt;
  &lt;uid&gt;675071752&lt;/uid&gt;
  &lt;uid&gt;675745947&lt;/uid&gt;
  &lt;uid&gt;676390573&lt;/uid&gt;
  &lt;uid&gt;679174934&lt;/uid&gt;
  &lt;uid&gt;680481527&lt;/uid&gt;
  &lt;uid&gt;680685997&lt;/uid&gt;
  &lt;uid&gt;682871390&lt;/uid&gt;
  &lt;uid&gt;683320891&lt;/uid&gt;
  &lt;uid&gt;684531501&lt;/uid&gt;
  &lt;uid&gt;686252440&lt;/uid&gt;
  &lt;uid&gt;686532196&lt;/uid&gt;
  &lt;uid&gt;687441766&lt;/uid&gt;
  &lt;uid&gt;687707451&lt;/uid&gt;
  &lt;uid&gt;687938316&lt;/uid&gt;
  &lt;uid&gt;688987220&lt;/uid&gt;
  &lt;uid&gt;689096433&lt;/uid&gt;
  &lt;uid&gt;689828410&lt;/uid&gt;
  &lt;uid&gt;690210392&lt;/uid&gt;
  &lt;uid&gt;692190054&lt;/uid&gt;
  &lt;uid&gt;692897180&lt;/uid&gt;
  &lt;uid&gt;695499141&lt;/uid&gt;
  &lt;uid&gt;695641750&lt;/uid&gt;
  &lt;uid&gt;697048711&lt;/uid&gt;
  &lt;uid&gt;697691163&lt;/uid&gt;
  &lt;uid&gt;700774063&lt;/uid&gt;
  &lt;uid&gt;702787551&lt;/uid&gt;
  &lt;uid&gt;706008656&lt;/uid&gt;
  &lt;uid&gt;706776770&lt;/uid&gt;
  &lt;uid&gt;707751678&lt;/uid&gt;
  &lt;uid&gt;708727040&lt;/uid&gt;
  &lt;uid&gt;709132233&lt;/uid&gt;
  &lt;uid&gt;709260942&lt;/uid&gt;
  &lt;uid&gt;709320825&lt;/uid&gt;
  &lt;uid&gt;710265293&lt;/uid&gt;
  &lt;uid&gt;711915061&lt;/uid&gt;
  &lt;uid&gt;713872353&lt;/uid&gt;
  &lt;uid&gt;714455356&lt;/uid&gt;
  &lt;uid&gt;715657454&lt;/uid&gt;
  &lt;uid&gt;718109851&lt;/uid&gt;
  &lt;uid&gt;718684161&lt;/uid&gt;
  &lt;uid&gt;719576868&lt;/uid&gt;
  &lt;uid&gt;720136749&lt;/uid&gt;
  &lt;uid&gt;720549661&lt;/uid&gt;
  &lt;uid&gt;721752198&lt;/uid&gt;
  &lt;uid&gt;721775649&lt;/uid&gt;
  &lt;uid&gt;722051392&lt;/uid&gt;
  &lt;uid&gt;725366340&lt;/uid&gt;
  &lt;uid&gt;725475385&lt;/uid&gt;
  &lt;uid&gt;726586304&lt;/uid&gt;
  &lt;uid&gt;727590181&lt;/uid&gt;
  &lt;uid&gt;728539606&lt;/uid&gt;
  &lt;uid&gt;730537898&lt;/uid&gt;
  &lt;uid&gt;732231862&lt;/uid&gt;
  &lt;uid&gt;732395944&lt;/uid&gt;
  &lt;uid&gt;735430450&lt;/uid&gt;
  &lt;uid&gt;737856139&lt;/uid&gt;
  &lt;uid&gt;739395134&lt;/uid&gt;
  &lt;uid&gt;742661693&lt;/uid&gt;
  &lt;uid&gt;745936519&lt;/uid&gt;
  &lt;uid&gt;747192526&lt;/uid&gt;
  &lt;uid&gt;751237848&lt;/uid&gt;
  &lt;uid&gt;753940266&lt;/uid&gt;
  &lt;uid&gt;760591799&lt;/uid&gt;
  &lt;uid&gt;760796612&lt;/uid&gt;
  &lt;uid&gt;762194630&lt;/uid&gt;
  &lt;uid&gt;765728102&lt;/uid&gt;
  &lt;uid&gt;777395203&lt;/uid&gt;
  &lt;uid&gt;781260172&lt;/uid&gt;
  &lt;uid&gt;784075172&lt;/uid&gt;
  &lt;uid&gt;790668494&lt;/uid&gt;
  &lt;uid&gt;791429352&lt;/uid&gt;
  &lt;uid&gt;791879224&lt;/uid&gt;
  &lt;uid&gt;795383134&lt;/uid&gt;
  &lt;uid&gt;799223573&lt;/uid&gt;
  &lt;uid&gt;802734193&lt;/uid&gt;
  &lt;uid&gt;807849767&lt;/uid&gt;
  &lt;uid&gt;812775243&lt;/uid&gt;
  &lt;uid&gt;817463397&lt;/uid&gt;
  &lt;uid&gt;818550430&lt;/uid&gt;
  &lt;uid&gt;821147747&lt;/uid&gt;
  &lt;uid&gt;830614423&lt;/uid&gt;
  &lt;uid&gt;833555899&lt;/uid&gt;
  &lt;uid&gt;833694201&lt;/uid&gt;
  &lt;uid&gt;855010639&lt;/uid&gt;
  &lt;uid&gt;898930299&lt;/uid&gt;
  &lt;uid&gt;1008565475&lt;/uid&gt;
  &lt;uid&gt;1030813535&lt;/uid&gt;
  &lt;uid&gt;1031820366&lt;/uid&gt;
  &lt;uid&gt;1041801699&lt;/uid&gt;
  &lt;uid&gt;1042800033&lt;/uid&gt;
  &lt;uid&gt;1047480003&lt;/uid&gt;
  &lt;uid&gt;1047480027&lt;/uid&gt;
  &lt;uid&gt;1047480028&lt;/uid&gt;
  &lt;uid&gt;1047480047&lt;/uid&gt;
  &lt;uid&gt;1047480049&lt;/uid&gt;
  &lt;uid&gt;1047480056&lt;/uid&gt;
  &lt;uid&gt;1047480068&lt;/uid&gt;
  &lt;uid&gt;1047480078&lt;/uid&gt;
  &lt;uid&gt;1047480082&lt;/uid&gt;
  &lt;uid&gt;1047480083&lt;/uid&gt;
  &lt;uid&gt;1047480094&lt;/uid&gt;
  &lt;uid&gt;1047480099&lt;/uid&gt;
  &lt;uid&gt;1047480138&lt;/uid&gt;
  &lt;uid&gt;1047480140&lt;/uid&gt;
  &lt;uid&gt;1047480162&lt;/uid&gt;
  &lt;uid&gt;1047480169&lt;/uid&gt;
  &lt;uid&gt;1047480175&lt;/uid&gt;
  &lt;uid&gt;1047480185&lt;/uid&gt;
  &lt;uid&gt;1047480188&lt;/uid&gt;
  &lt;uid&gt;1048530026&lt;/uid&gt;
  &lt;uid&gt;1049204751&lt;/uid&gt;
  &lt;uid&gt;1058400102&lt;/uid&gt;
  &lt;uid&gt;1058970042&lt;/uid&gt;
  &lt;uid&gt;1060999433&lt;/uid&gt;
  &lt;uid&gt;1064568546&lt;/uid&gt;
  &lt;uid&gt;1065231417&lt;/uid&gt;
  &lt;uid&gt;1068060088&lt;/uid&gt;
  &lt;uid&gt;1074024060&lt;/uid&gt;
  &lt;uid&gt;1093958202&lt;/uid&gt;
  &lt;uid&gt;1100506869&lt;/uid&gt;
  &lt;uid&gt;1105996949&lt;/uid&gt;
  &lt;uid&gt;1108230137&lt;/uid&gt;
  &lt;uid&gt;1122900356&lt;/uid&gt;
  &lt;uid&gt;1131083147&lt;/uid&gt;
  &lt;uid&gt;1191274762&lt;/uid&gt;
  &lt;uid&gt;1201217781&lt;/uid&gt;
  &lt;uid&gt;1204071413&lt;/uid&gt;
  &lt;uid&gt;1209156204&lt;/uid&gt;
  &lt;uid&gt;1212263224&lt;/uid&gt;
  &lt;uid&gt;1225675163&lt;/uid&gt;
  &lt;uid&gt;1244041233&lt;/uid&gt;
  &lt;uid&gt;1259109563&lt;/uid&gt;
  &lt;uid&gt;1262885018&lt;/uid&gt;
  &lt;uid&gt;1302414215&lt;/uid&gt;
  &lt;uid&gt;1303623749&lt;/uid&gt;
  &lt;uid&gt;1306177216&lt;/uid&gt;
  &lt;uid&gt;1306292746&lt;/uid&gt;
  &lt;uid&gt;1319042930&lt;/uid&gt;
  &lt;uid&gt;1327796747&lt;/uid&gt;
  &lt;uid&gt;1373260162&lt;/uid&gt;
  &lt;uid&gt;1398780274&lt;/uid&gt;
  &lt;uid&gt;1407927100&lt;/uid&gt;
  &lt;uid&gt;1415930588&lt;/uid&gt;
  &lt;uid&gt;1427857604&lt;/uid&gt;
  &lt;uid&gt;1455108770&lt;/uid&gt;
  &lt;uid&gt;1477906749&lt;/uid&gt;
  &lt;uid&gt;1491106587&lt;/uid&gt;
  &lt;uid&gt;1534789171&lt;/uid&gt;
  &lt;uid&gt;1548630129&lt;/uid&gt;
  &lt;uid&gt;1549787383&lt;/uid&gt;
  &lt;uid&gt;1556717803&lt;/uid&gt;
  &lt;uid&gt;1642191667&lt;/uid&gt;
&lt;/friends_get_response&gt;
</batch_run_response_elt>
  <batch_run_response_elt>&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;
&lt;friends_areFriends_response xmlns=&quot;http://api.facebook.com/1.0/&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot; xsi:schemaLocation=&quot;http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd&quot; list=&quot;true&quot;/&gt;
</batch_run_response_elt>
</batch_run_response>
XML;

        $this->mockSendRequest($response);

        $batch = $this->instance;
        $batch->sesionKey = 'foo';
        $batch->addCall('restriction', 'admin.getRestrictionInfo');
        $batch->addCall('friends', 'friends.get', array('uid' => 683226814));
        $batch->addCall('areFriends', 'friends.areFriends', array('uid1' => 617370918, 'uid2' => 683226814));
        $batch->run();

        $this->assertType('SimpleXMLElement', $batch['friends']);
        $this->assertType('SimpleXMLElement', $batch['restriction']);
        $this->assertType('SimpleXMLElement', $batch['areFriends']);
    }

}

?>
