<?php
/**
 * FIT Table
 * 
 * $Id: Table.php 6 2007-06-06 07:37:36Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Parser
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
  
/**
 * load node
 */
include_once 'Testing/FIT/Node.php';

/**
 * load fixture base class
 */
include_once 'Testing/FIT/Fixture.php';

/**
 * FIT Table
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_Table
{
   /**
    * parser holding tables
    * @var object
    */
    private $_parser = null;
    
   /**
    * current fixture
    * @var object
    */
    private $_fixture = null;
    
   /**
    * collecting information of this fixture
    * @var array
    */
    private $_summary = array();
    
   /**
    * run tables
    * 
    * load talbe data from parser
    * @param object $parser
    */
    public function doTables( Testing_FIT_Parser $parser )
    {
        $this->_parser  = $parser;
        
        $tables = $this->_parser->countChildNodes();
        
        // work through table
        for( $i = 0; $i < $tables; ++$i ) {
            if( !$this->_doTable( $i ) ) {
                return false;
            }
        }
        
        return true;
    }
    
   /**
    * process whole table
    * 
    * @param int $no table index
    */
    private function _doTable( $no ) 
    {
        $table = new Testing_FIT_Node( $this->_parser, $no );
        
        // extract fixture
        if( !$this->_startFixture( $no ) ) {
            return false;
        }
        return $this->_fixture->doTable( $table );
    }
    
   /**
    * find fixture in table and start corresponding object
    *
    * @param int $no table no
    * @return bool true on success
    */
    private function _startFixture( $no ) 
    {
        // fixture name is first thing in a table!
        $name   = $this->_parser->getNodeValue( 'cData', $no, 0, 0 );
        
        // no ficture found!
        if( empty( $name ) ) {
            // do something more intelligent on failure!
            return false;
        }
        
        // start fixture
        $this->_fixture = Testing_FIT_Fixture::loadFixture( $name );
        return true;
    }

}
?>