<?php
/**
 * FIT Fixture type filter: integer
 * 
 * $Id: Float.php 8 2007-08-07 07:15:22Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Parser
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * FIT Fixture type filter: integer
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_TypeFilter_Float extends Testing_FIT_TypeFilter
{
   /**
    * name of type
    * @var string
    */
    protected $type = 'float';
    
   /**
    * toleracce
    */
    const PRECISION = 0.000001;
    
   /**
    * compare string with PHP value
    * 
    * @param string $string
    * @param moxes $value
    * @return string 
    */
    public function isEqual( $string, $value ) 
    {
        $string = $this->in( $string );
        
        if( abs( $string - $value ) < self::PRECISION ) {
            return true;
        }
        return false;
    }
    
   /**
    * make string representation of value
    * 
    * @param mixed $value
    * @return string 
    */
    public function out( $value ) 
    {
        return strval( $value );
    }
    
   /**
    * parse string to figure out PHP value
    *
    * @param string $cData
    * @return mixed $value
    */
    public function in( $cData ) 
    {
        return floatval( $cData );
    }
}
?>