<?php
/**
 * FIT Examples
 * 
 * $Id: ArithmeticColumnFixture.php 12 2007-08-12 18:34:25Z gerd $
 * 
 * These examples are derived from http://fit.c2.com/ 
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Example
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */

/**
 * Load basic fixture: Column and HelloWorld 
 */
Testing_FIT_Loader::loadClass( 
            'Testing_FIT_Fixture'
            , 'Testing_FIT_Fixture_Column'
            );

/**
 * FIT Examples
 * 
 * @version 0.1.1
 * @package FIT
 * @subpackage Example
 */
class Math_ArithmeticColumnFixture extends Testing_FIT_Fixture_Column 
{    
    /**
    * number "x"
    * @var int
    */
	public $x = 0;
    
    /**
    * number "y"
    * @var int
    */
	public $y = 0; // not 0 to avoid that getReturnType (for floating() and divide()) throws an Exception
	
    /**
    * calculate
    * 
    * @return integer
    */
	public function plus() {
		return intval($this->x + $this->y);
	}

    /**
    * calculate
    * 
    * @return integer
    */
	public function minus() {
		return intval($this->x - $this->y);
	}

    /**
    * calculate
    * 
    * @return integer
    */
	public function times() {
		return intval($this->x * $this->y);
	}

    /**
    * calculate
    * 
    * @return integer
    */
	public function divide() {
		if ($this->y == 0)
			throw new Exception( "ArithmeticException: / by zero" );
		return intval($this->x / $this->y);
	}

    /**
    * calculate 
    * 
    * @return float
    */
	public function floating() {
		if ($this->y == 0)
			throw new Exception( "ArithmeticException: / by zero" );
		return floatval($this->x / $this->y);
	}
}
?>