<?php
/**
 * FIT Fixture ColumnFixture
 * 
 * $Id: Column.php 6 2007-06-06 07:37:36Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Fixture
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * FIT Fixture: ColumnFixture
 *
 * A ColumnFixture maps columns in the test data to fields or methods of its 
 * subclasses. SimpleExample and CalculatorExample use column fixtures.
 * 
 * @version 0.1.1
 * @package FIT
 * @subpackage Fixture
 */
class Testing_FIT_Fixture_Column extends Testing_FIT_Fixture 
{

   /**
    * Excecution state
    * @var bool
    */
	protected $_hasExecuted = false;
	
   /**
    * bind columsn to fixture and start row iterator
    * 
    * @param object $node
    * @return boolean true on success
    * @see doRow()
    */
    public function doRows( Testing_FIT_Node $node ) 
    {
        $node->next();
        $this->_bind( $node );
        
        return parent::doRows( $node );
    }
	
   /**
    * Process a table's row
    * 
    * @param Parce rows
    */  
    public function doRow( Testing_FIT_Node $node  ) 
    {
        $this->_hasExecuted = false;
        try {
            $this->reset();
            
            parent::doRow( $node );
            
            if( !$this->_hasExecuted ) {
                $this->execute();
            }
        } 
        catch( Exception $e ) {
            $node->markException( $e);
        }
        return true;
    }
	
   /**
    * process a single cell
    *
    * Generic processing of a table cell. Well, this function 
    * just ignores cells. 
    * 
    * This method may be overwritten by a subclass (ColumnFixture)
    * 
    * @param object $cell A parse object 
    * @return void
    */
    public function doCells( Testing_FIT_Node $node ) {

        $cells  = $node->getRowIterator();
        foreach( $cells as $no => $cdata ) {
            try {
                $bind   = $this->_columnBindings[$no];

                if( $bind['type'] == 'property' ) {
                    $this->$bind['name']    =   $this->_columnFilter[$no]->in( $cdata );
                    continue;
                }
            
                if( !$this->_hasExecuted ) {
                    $this->execute();
                }
                $this->_hasExecuted = true;
                $result =   call_user_func( array( $this, $bind['name'] ), $cdata );
                $this->_checkCell( $cells, $result );
            
            }
            catch( Exception $e ) {
                $cells->markException( $e );
            }
        }
        
        return true;
    }
    
   /**
    * This will be called once per row - first thing
    * 
    * @return boolean true on success
    */
	public function reset() {
	
	}
	
   /**
    * This will be called once per row 
    * 
    * (before the first fixture method will be called)
    * 
    * @return boolean true on success
    */
	public function execute() {
        return true;   
	}

}
?>