--TEST--
Validate_IS::address()
--FILE--
<?php
    error_reporting(E_ALL & ~E_STRICT);
    require_once "Validate/IS.php";

    $addresses = array(
        "Reglubraut"    => 1,
        "Mnagata"      => 7,
        "Aalstrti"    => 6,
        "Sblsbraut"   => 1,
        "Bgus"         => 0,
        "Vestmannabraut" => 1
    );

    foreach($addresses as $address => $count) {
        $result = Validate_IS::address($address);
        printf("%-20s: %d (%d)\n", $address, is_array($result) ? count($result) : 0, $count);
    }

    print "\n";
    
    foreach($addresses as $address => $count) {
        $result = Validate_IS::address($address, 200);
        printf("%-20s: %d\n", $address, is_array($result) ? count($result) : 0);
    }
?>
--EXPECT--
Reglubraut          : 1 (1)
Mnagata            : 7 (7)
Aalstrti          : 6 (6)
Sblsbraut         : 1 (1)
Bgus               : 0 (0)
Vestmannabraut      : 1 (1)

Reglubraut          : 0
Mnagata            : 0
Aalstrti          : 0
Sblsbraut         : 1
Bgus               : 0
Vestmannabraut      : 0
