<?php
/*
   +----------------------------------------------------------------------+
   | PEAR Web site version 1.0                                            |
   +----------------------------------------------------------------------+
   | Copyright (c) 2005 The PEAR Group                                    |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Martin Jansen <mj@php.net>                                   |
   +----------------------------------------------------------------------+
   $Id: apidoc-log.php 275749 2009-02-13 12:49:13Z cweiske $
*/

auth_require("pear.dev");
response_header("API Documentation Queue Log");

echo "<h1>API Documentation Queue Log</h1>";

if (!empty($_GET['filename'])) {
    $filename = urldecode($_GET['filename']);

    $query = "SELECT queued, finished, log FROM apidoc_queue WHERE filename = ?";
    $info = $dbh->getRow($query, array($filename), DB_FETCHMODE_ASSOC);

    if (!is_array($info)) {
        echo "<div class=\"errors\">No such file " . strip_tags($filename) . ".</div>\n";
    } else {
        echo "<p>Log for <strong>" . $filename . "</strong>:</p>\n";
        echo "<ul>\n";
        echo "  <li>Queued: " . $info['queued'] . "</li>\n";
        echo "  <li>Finished: " . $info['finished'] . "</li>\n";
        echo "  <li>Command output:<br /><pre>" . strip_tags($info['log']) . "</pre></li>\n";
        echo "</ul>\n";
    }
} else {
    $query = "SELECT filename FROM apidoc_queue ORDER BY queued DESC";
    $sth = $dbh->query($query);

    echo "<p>Select a filename:</p>\n\n";

    echo "<ul>";
    while ($row = $sth->fetchRow(DB_FETCHMODE_ASSOC)) {
        printf("<li><a href=\"/admin/apidoc-log.php?filename=%s\">%s</a></li>\n",
            urlencode($row['filename']),
            $row['filename']
        );
   }
   echo "</ul>";
}

response_footer();
?>
