/* Generated by re2c 1.0.3 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2018 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@php.net>                                 |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6

#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

#define ZEND_SYSTEM_INI CG(ini_parser_unbuffered_errors)

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yyleng) {                                 \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng && (                              \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, ZEND_SYSTEM_INI))


#define RETURN_TOKEN(type, str, len) {                             \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED &&            \
		(YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW))) {\
		zend_ini_copy_typed_value(ini_lval, type, str, len);       \
	} else {                                                       \
		zend_ini_copy_value(ini_lval, str, len);                   \
	}                                                              \
	return type;                                                   \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
ZEND_COLD int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
ZEND_COLD char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 387 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy12;
		}
		switch (yych) {
		case '\t':	goto yy6;
		case '\n':	goto yy9;
		case '\r':	goto yy11;
		case ' ':
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy14;
		case ';':	goto yy16;
		case '=':	goto yy18;
		case 'F':
		case 'f':	goto yy21;
		case 'N':
		case 'n':	goto yy22;
		case 'O':
		case 'o':	goto yy23;
		case 'T':
		case 't':	goto yy24;
		case 'Y':
		case 'y':	goto yy25;
		case '[':	goto yy26;
		default:	goto yy3;
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy4:
		YYDEBUG(4, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy3;
		}
		if (yych <= '=') goto yy5;
		if (yych <= '[') goto yy28;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 482 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 519 "Zend/zend_ini_scanner.c"
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(7, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy6;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy8;
			if (yych <= '\n') goto yy9;
			if (yych >= '\r') goto yy11;
		} else {
			if (yych <= ';') {
				if (yych >= ';') goto yy16;
			} else {
				if (yych == '=') goto yy18;
			}
		}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 635 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 548 "Zend/zend_ini_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 640 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 560 "Zend/zend_ini_scanner.c"
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy9;
		goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(13, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy12;
		}
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy3;
					if (yych <= '\t') goto yy6;
					goto yy9;
				} else {
					if (yych == '\r') goto yy11;
					goto yy3;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy3;
					goto yy5;
				} else {
					if (yych == '&') goto yy5;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy5;
					if (yych <= ':') goto yy3;
					goto yy16;
				} else {
					if (yych == '=') goto yy18;
					goto yy3;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy28;
					if (yych <= ']') goto yy3;
					goto yy5;
				} else {
					if (yych <= 'z') goto yy3;
					if (yych <= '~') goto yy5;
					goto yy3;
				}
			}
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(15, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 563 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 625 "Zend/zend_ini_scanner.c"
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy16;
		}
		if (yych <= '\n') goto yy31;
		goto yy33;
yy18:
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(19, *YYCURSOR);
		if (yych == '\t') goto yy18;
		if (yych == ' ') goto yy18;
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 492 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_RAW);
	} else {
		BEGIN(ST_VALUE);
	}
	return '=';
}
#line 656 "Zend/zend_ini_scanner.c"
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy34;
		if (yych == 'a') goto yy34;
		goto yy4;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy35;
			if (yych <= 'T') goto yy4;
			goto yy37;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy4;
				goto yy35;
			} else {
				if (yych == 'u') goto yy37;
				goto yy4;
			}
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy38;
			if (yych <= 'M') goto yy4;
			goto yy39;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy4;
				goto yy38;
			} else {
				if (yych == 'n') goto yy39;
				goto yy4;
			}
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy42;
		if (yych == 'r') goto yy42;
		goto yy4;
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy43;
		if (yych == 'e') goto yy43;
		goto yy4;
yy26:
		YYDEBUG(26, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 407 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_SECTION_RAW);
	} else {
		BEGIN(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
#line 722 "Zend/zend_ini_scanner.c"
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		if (yych == '\t') goto yy28;
		if (yych == ' ') goto yy28;
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 432 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	BEGIN(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 746 "Zend/zend_ini_scanner.c"
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 645 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 759 "Zend/zend_ini_scanner.c"
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy31;
		goto yy32;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy44;
		if (yych == 'l') goto yy44;
		goto yy4;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy4;
					if (yych <= '\t') goto yy45;
				} else {
					if (yych != '\r') goto yy4;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy47;
					if (yych >= '#') goto yy4;
				} else {
					if (yych == '%') goto yy4;
					if (yych >= '\'') goto yy4;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy36;
					if (yych <= ':') goto yy4;
				} else {
					if (yych == '=') goto yy36;
					if (yych <= 'M') goto yy4;
					goto yy49;
				}
			} else {
				if (yych <= 'm') {
					if (yych != '^') goto yy4;
				} else {
					if (yych <= 'n') goto yy49;
					if (yych <= 'z') goto yy4;
					if (yych >= 0x7F) goto yy4;
				}
			}
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 474 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 818 "Zend/zend_ini_scanner.c"
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy50;
		if (yych == 'l') goto yy50;
		goto yy4;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy47;
		if (yych == 'f') goto yy47;
		goto yy4;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(40, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy3;
					if (yych <= '\t') goto yy51;
				} else {
					if (yych != '\r') goto yy3;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych >= '#') goto yy3;
				} else {
					if (yych == '%') goto yy3;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy3;
					if (yych >= '*') goto yy3;
				} else {
					if (yych == '<') goto yy3;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy3;
				} else {
					if (yych <= '^') goto yy41;
					if (yych <= 'z') goto yy3;
					if (yych >= 0x7F) goto yy3;
				}
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 470 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 879 "Zend/zend_ini_scanner.c"
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy53;
		if (yych == 'u') goto yy53;
		goto yy4;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy39;
		if (yych == 's') goto yy39;
		goto yy4;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy49;
		if (yych == 's') goto yy49;
		goto yy4;
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		if (yych == '\t') goto yy45;
		if (yych == ' ') goto yy45;
		goto yy36;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy3;
					if (yych <= '\t') goto yy45;
					goto yy36;
				} else {
					if (yych == '\r') goto yy36;
					goto yy3;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy47;
					if (yych <= '"') goto yy36;
					goto yy3;
				} else {
					if (yych == '%') goto yy3;
					goto yy36;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy3;
					if (yych <= ')') goto yy36;
					goto yy3;
				} else {
					if (yych == '<') goto yy3;
					goto yy36;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy3;
				} else {
					if (yych <= '^') goto yy36;
					if (yych <= 'z') goto yy3;
					if (yych <= '~') goto yy36;
					goto yy3;
				}
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy47;
		if (yych == 'e') goto yy47;
		goto yy4;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy54;
		if (yych == 'l') goto yy54;
		goto yy4;
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		if (yych == '\t') goto yy51;
		if (yych == ' ') goto yy51;
		goto yy41;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy4;
yy54:
		YYDEBUG(54, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(55, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy3;
					if (yych <= '\t') goto yy57;
				} else {
					if (yych != '\r') goto yy3;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy54;
					if (yych >= '#') goto yy3;
				} else {
					if (yych == '%') goto yy3;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy3;
					if (yych >= '*') goto yy3;
				} else {
					if (yych == '<') goto yy3;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy3;
				} else {
					if (yych <= '^') goto yy56;
					if (yych <= 'z') goto yy3;
					if (yych >= 0x7F) goto yy3;
				}
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 478 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 1030 "Zend/zend_ini_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(58, *YYCURSOR);
		if (yych == '\t') goto yy57;
		if (yych == ' ') goto yy57;
		goto yy56;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(59, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy64;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy61;
					if (yych <= '\n') goto yy66;
				} else {
					if (yych <= '\r') goto yy66;
					if (yych >= '"') goto yy68;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy70;
				} else {
					if (yych <= '\'') goto yy71;
					if (yych <= ',') goto yy61;
					if (yych <= '.') goto yy72;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy73;
					if (yych >= ';') goto yy66;
				} else {
					if (yych <= '@') goto yy61;
					if (yych <= 'Z') goto yy76;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy79;
					if (yych <= ']') goto yy80;
				} else {
					if (yych == '`') goto yy61;
					if (yych <= 'z') goto yy76;
				}
			}
		}
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy62:
		YYDEBUG(62, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy61;
		}
		if (yych <= '"') goto yy63;
		if (yych <= '$') goto yy82;
		if (yych <= ';') goto yy63;
		if (yych <= '\\') goto yy79;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 581 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1143 "Zend/zend_ini_scanner.c"
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy64;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy61;
				if (yych <= '\n') goto yy63;
				if (yych <= '\f') goto yy61;
				goto yy63;
			} else {
				if (yych == '"') goto yy68;
				if (yych <= '#') goto yy61;
				goto yy82;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy63;
				if (yych <= ':') goto yy61;
				goto yy63;
			} else {
				if (yych <= '[') goto yy61;
				if (yych <= '\\') goto yy79;
				if (yych <= ']') goto yy80;
				goto yy61;
			}
		}
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 656 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1187 "Zend/zend_ini_scanner.c"
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(69, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 585 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 1198 "Zend/zend_ini_scanner.c"
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy67;
			if (yych <= '[') goto yy61;
			goto yy84;
		} else {
			if (yych == '{') goto yy86;
			goto yy61;
		}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy67;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy62;
		if (yych <= '9') goto yy90;
		goto yy62;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy73;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy75;
				if (yych <= '\f') goto yy61;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy61;
				} else {
					if (yych == '$') goto yy82;
					goto yy61;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy75;
				if (yych == '.') goto yy90;
				goto yy61;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy61;
				} else {
					if (yych <= '\\') goto yy79;
					if (yych >= '^') goto yy61;
				}
			}
		}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 559 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1267 "Zend/zend_ini_scanner.c"
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy76;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy78;
				if (yych <= '\f') goto yy61;
			} else {
				if (yych == '"') goto yy78;
				if (yych <= '#') goto yy61;
				goto yy82;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy78;
				if (yych <= ':') goto yy61;
			} else {
				if (yych <= '[') goto yy61;
				if (yych <= '\\') goto yy79;
				if (yych >= '^') goto yy61;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 555 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1304 "Zend/zend_ini_scanner.c"
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy61;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 445 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1321 "Zend/zend_ini_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy83;
			if (yych <= '[') goto yy61;
			goto yy84;
		} else {
			if (yych != '{') goto yy61;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy63;
			} else {
				goto yy75;
			}
		} else {
			goto yy78;
		}
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(85, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy84;
		}
		goto yy61;
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 450 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 1366 "Zend/zend_ini_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy92;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(91, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy75;
				if (yych <= '\f') goto yy61;
				goto yy75;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy61;
					goto yy75;
				} else {
					if (yych == '$') goto yy82;
					goto yy61;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy75;
				if (yych <= '/') goto yy61;
				if (yych <= '9') goto yy90;
				goto yy61;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy75;
					goto yy61;
				} else {
					if (yych <= '\\') goto yy79;
					if (yych <= ']') goto yy75;
					goto yy61;
				}
			}
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 417 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1429 "Zend/zend_ini_scanner.c"
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(94, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy99;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy96;
					if (yych <= '\n') goto yy101;
				} else {
					if (yych <= '\r') goto yy101;
					if (yych >= '"') goto yy103;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy105;
				} else {
					if (yych <= '\'') goto yy106;
					if (yych <= ',') goto yy96;
					if (yych <= '.') goto yy107;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy108;
					if (yych >= ';') goto yy101;
				} else {
					if (yych <= '@') goto yy96;
					if (yych <= 'Z') goto yy111;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy114;
					if (yych <= ']') goto yy115;
				} else {
					if (yych == '`') goto yy96;
					if (yych <= 'z') goto yy111;
				}
			}
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy97:
		YYDEBUG(97, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy96;
		}
		if (yych <= '"') goto yy98;
		if (yych <= '$') goto yy118;
		if (yych <= ';') goto yy98;
		if (yych <= '\\') goto yy114;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 581 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1533 "Zend/zend_ini_scanner.c"
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(100, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy99;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy96;
				if (yych <= '\n') goto yy98;
				if (yych <= '\f') goto yy96;
				goto yy98;
			} else {
				if (yych == '"') goto yy103;
				if (yych <= '#') goto yy96;
				goto yy118;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy98;
				if (yych <= ':') goto yy96;
				goto yy98;
			} else {
				if (yych <= '[') goto yy96;
				if (yych <= '\\') goto yy114;
				if (yych <= ']') goto yy98;
				goto yy96;
			}
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 656 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1577 "Zend/zend_ini_scanner.c"
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 585 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 1588 "Zend/zend_ini_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy102;
			if (yych <= '[') goto yy96;
			goto yy120;
		} else {
			if (yych == '{') goto yy122;
			goto yy96;
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy124;
		}
		goto yy102;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy97;
		if (yych <= '9') goto yy126;
		goto yy97;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy108;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy110;
				if (yych <= '\f') goto yy96;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy96;
				} else {
					if (yych == '$') goto yy118;
					goto yy96;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy110;
				if (yych == '.') goto yy126;
				goto yy96;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy96;
				} else {
					if (yych <= '\\') goto yy114;
					if (yych >= '^') goto yy96;
				}
			}
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 559 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1657 "Zend/zend_ini_scanner.c"
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(112, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy111;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy113;
				if (yych <= '\f') goto yy96;
			} else {
				if (yych == '"') goto yy113;
				if (yych <= '#') goto yy96;
				goto yy118;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy113;
				if (yych <= ':') goto yy96;
			} else {
				if (yych <= '[') goto yy96;
				if (yych <= '\\') goto yy114;
				if (yych >= '^') goto yy96;
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 555 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1694 "Zend/zend_ini_scanner.c"
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy96;
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(116, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy117;
			if (yych <= '\t') goto yy115;
			if (yych <= '\n') goto yy128;
		} else {
			if (yych <= '\r') goto yy129;
			if (yych == ' ') goto yy115;
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 426 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 1724 "Zend/zend_ini_scanner.c"
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy119;
			if (yych <= '[') goto yy96;
			goto yy120;
		} else {
			if (yych != '{') goto yy96;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy98;
			} else {
				goto yy110;
			}
		} else {
			goto yy113;
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy120;
		}
		goto yy96;
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 450 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 1769 "Zend/zend_ini_scanner.c"
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(125, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy124;
		}
		goto yy130;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(127, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy110;
				if (yych <= '\f') goto yy96;
				goto yy110;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy96;
					goto yy110;
				} else {
					if (yych == '$') goto yy118;
					goto yy96;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy110;
				if (yych <= '/') goto yy96;
				if (yych <= '9') goto yy126;
				goto yy96;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy110;
					goto yy96;
				} else {
					if (yych <= '\\') goto yy114;
					if (yych <= ']') goto yy110;
					goto yy96;
				}
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		goto yy117;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy128;
		goto yy117;
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 417 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1841 "Zend/zend_ini_scanner.c"
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 80,  82,  82,  82,  82,  82,  82,  82, 
			 82,  84,  64,  82,  82,  64,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 84,  80,  80,  82, 208,  82,  80,  16, 
			 80,  80,  82,  82,  82,  82,  82,  82, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  82,  80,  82,  80,  82,  82, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  82,  82,  80, 114, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  80,  82,  80,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
		};
		YYDEBUG(132, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy139;
		}
		switch (yych) {
		case 0x00:	goto yy134;
		case '\t':
		case '\n':	goto yy142;
		case '\r':	goto yy144;
		case ' ':
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy145;
		case '"':	goto yy148;
		case '$':	goto yy150;
		case '\'':	goto yy151;
		case '-':
		case '.':	goto yy152;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy153;
		case ';':	goto yy156;
		case '=':	goto yy158;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy160;
		case 'F':
		case 'f':	goto yy163;
		case 'N':
		case 'n':	goto yy164;
		case 'O':
		case 'o':	goto yy165;
		case 'T':
		case 't':	goto yy166;
		case 'Y':
		case 'y':	goto yy167;
		default:	goto yy136;
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 651 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1982 "Zend/zend_ini_scanner.c"
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy137:
		YYDEBUG(137, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy136;
		}
		if (yych <= '"') goto yy138;
		if (yych <= '$') goto yy168;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 577 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2003 "Zend/zend_ini_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(140, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy139;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy141;
			if (yych <= '\n') goto yy142;
			if (yych >= '\r') goto yy144;
		} else {
			if (yych <= '"') {
				if (yych >= '"') goto yy148;
			} else {
				if (yych == ';') goto yy156;
			}
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 631 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 2031 "Zend/zend_ini_scanner.c"
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 549 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2044 "Zend/zend_ini_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy142;
		goto yy143;
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		if (yych == '\t') goto yy145;
		if (yych == ' ') goto yy145;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 567 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 2064 "Zend/zend_ini_scanner.c"
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 585 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 2075 "Zend/zend_ini_scanner.c"
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy135;
			if (yych <= '[') goto yy136;
			goto yy170;
		} else {
			if (yych == '{') goto yy171;
			goto yy136;
		}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy173;
		}
		goto yy135;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy137;
		if (yych <= '9') goto yy175;
		goto yy137;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(154, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy153;
		}
		if (yych <= '-') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy155;
					if (yych <= 0x08) goto yy136;
				} else {
					if (yych != '\r') goto yy136;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy155;
					if (yych <= '#') goto yy136;
					goto yy168;
				} else {
					if (yych <= '%') goto yy136;
					if (yych >= '*') goto yy136;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '.') goto yy175;
					if (yych <= ':') goto yy136;
				} else {
					if (yych != '=') goto yy136;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy155;
					if (yych <= '{') goto yy136;
				} else {
					if (yych != '~') goto yy136;
				}
			}
		}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 559 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2153 "Zend/zend_ini_scanner.c"
yy156:
		YYDEBUG(156, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(157, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy156;
		}
		if (yych <= '\n') goto yy177;
		goto yy179;
yy158:
		YYDEBUG(158, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 571 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 2176 "Zend/zend_ini_scanner.c"
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy160;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy136;
				} else {
					if (yych <= '\n') goto yy162;
					if (yych <= '\f') goto yy136;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy136;
					if (yych >= '#') goto yy136;
				} else {
					if (yych <= '$') goto yy168;
					if (yych <= '%') goto yy136;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy136;
				} else {
					if (yych != '=') goto yy136;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy162;
					if (yych <= '{') goto yy136;
				} else {
					if (yych != '~') goto yy136;
				}
			}
		}
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 555 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2227 "Zend/zend_ini_scanner.c"
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					goto yy137;
				} else {
					if (yych <= '9') goto yy160;
					if (yych == ';') goto yy162;
					goto yy137;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy162;
					if (yych <= '@') goto yy137;
					goto yy180;
				} else {
					if (yych <= 'Z') goto yy160;
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					goto yy160;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy137;
					if (yych <= 'a') goto yy180;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					if (yych <= '\n') goto yy162;
					goto yy137;
				} else {
					if (yych <= '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					if (yych <= '"') goto yy162;
					goto yy137;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					if (yych <= '9') goto yy160;
					goto yy137;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy162;
						goto yy137;
					} else {
						if (yych <= '=') goto yy162;
						if (yych <= '@') goto yy137;
						goto yy160;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy181;
					if (yych == 'U') goto yy183;
					goto yy160;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy137;
						goto yy162;
					} else {
						if (yych == '`') goto yy137;
						goto yy160;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy181;
					if (yych == 'u') goto yy183;
					goto yy160;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy137;
						goto yy162;
					} else {
						if (yych == '~') goto yy162;
						goto yy137;
					}
				}
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					if (yych <= '\n') goto yy162;
					goto yy137;
				} else {
					if (yych <= '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					if (yych <= '"') goto yy162;
					goto yy137;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					if (yych <= '9') goto yy160;
					goto yy137;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy162;
						goto yy137;
					} else {
						if (yych <= '=') goto yy162;
						if (yych <= '@') goto yy137;
						goto yy160;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy184;
					if (yych == 'N') goto yy185;
					goto yy160;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy137;
						goto yy162;
					} else {
						if (yych == '`') goto yy137;
						goto yy160;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy184;
					if (yych == 'n') goto yy185;
					goto yy160;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy137;
						goto yy162;
					} else {
						if (yych == '~') goto yy162;
						goto yy137;
					}
				}
			}
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'R') goto yy187;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy187;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'E') goto yy188;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy188;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy169;
			if (yych <= '[') goto yy136;
			goto yy170;
		} else {
			if (yych != '{') goto yy136;
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy138;
				} else {
					goto yy155;
				}
			} else {
				goto yy162;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy182;
				} else {
					goto yy186;
				}
			} else {
				goto yy203;
			}
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy189;
		}
		goto yy136;
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 450 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 2566 "Zend/zend_ini_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(174, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy173;
		}
		goto yy191;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(176, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy155;
					if (yych <= 0x08) goto yy136;
					goto yy155;
				} else {
					if (yych == '\r') goto yy155;
					goto yy136;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy155;
					if (yych <= '#') goto yy136;
					goto yy168;
				} else {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy155;
					goto yy136;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy175;
					if (yych <= ':') goto yy136;
					goto yy155;
				} else {
					if (yych == '=') goto yy155;
					goto yy136;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy155;
					if (yych <= '{') goto yy136;
					goto yy155;
				} else {
					if (yych == '~') goto yy155;
					goto yy136;
				}
			}
		}
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 645 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2638 "Zend/zend_ini_scanner.c"
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy177;
		goto yy178;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'L') goto yy193;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy193;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy182;
					if (yych <= 0x08) goto yy137;
					if (yych <= '\t') goto yy194;
				} else {
					if (yych == '\r') goto yy182;
					if (yych <= 0x1F) goto yy137;
					goto yy194;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy182;
					if (yych <= '%') goto yy137;
					if (yych >= '*') goto yy137;
				} else {
					if (yych <= '9') goto yy160;
					if (yych != ';') goto yy137;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy182;
					if (yych <= '@') goto yy137;
					if (yych <= 'M') goto yy160;
					goto yy196;
				} else {
					if (yych <= 'Z') goto yy160;
					if (yych <= ']') goto yy137;
					if (yych >= '_') goto yy160;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy137;
					if (yych == 'n') goto yy196;
					goto yy160;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy137;
					} else {
						if (yych != '~') goto yy137;
					}
				}
			}
		}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 474 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 2753 "Zend/zend_ini_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'L') goto yy197;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy197;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'F') goto yy198;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy198;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy160;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy137;
				} else {
					if (yych <= '\t') goto yy199;
					if (yych >= '\v') goto yy137;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy186;
					if (yych <= 0x1F) goto yy137;
					goto yy199;
				} else {
					if (yych <= '"') goto yy186;
					if (yych <= '%') goto yy137;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy137;
				} else {
					if (yych != '=') goto yy137;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy186;
					if (yych <= '{') goto yy137;
				} else {
					if (yych != '~') goto yy137;
				}
			}
		}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 470 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 2904 "Zend/zend_ini_scanner.c"
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'U') goto yy201;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy201;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'S') goto yy185;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy185;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy189;
		}
		if (yych <= 0x00) goto yy138;
		if (yych == '\\') goto yy170;
		goto yy136;
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 417 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 3033 "Zend/zend_ini_scanner.c"
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'S') goto yy196;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy196;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(195, *YYCURSOR);
		if (yych == '\t') goto yy194;
		if (yych == ' ') goto yy194;
		goto yy182;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'E') goto yy198;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy198;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'L') goto yy202;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy202;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy160;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy182;
					goto yy137;
				} else {
					if (yych <= '\t') goto yy194;
					if (yych <= '\n') goto yy182;
					goto yy137;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy182;
					if (yych <= 0x1F) goto yy137;
					goto yy194;
				} else {
					if (yych <= '"') goto yy182;
					if (yych <= '%') goto yy137;
					goto yy182;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy137;
					goto yy182;
				} else {
					if (yych == '=') goto yy182;
					goto yy137;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy182;
					if (yych <= '{') goto yy137;
					goto yy182;
				} else {
					if (yych == '~') goto yy182;
					goto yy137;
				}
			}
		}
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		if (yych == '\t') goto yy199;
		if (yych == ' ') goto yy199;
		goto yy186;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy162;
					if (yych <= 0x08) goto yy137;
					goto yy162;
				} else {
					if (yych == '\r') goto yy162;
					if (yych <= 0x1F) goto yy137;
					goto yy162;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy162;
					if (yych <= '/') goto yy137;
					goto yy160;
				} else {
					if (yych == ';') goto yy162;
					if (yych <= '<') goto yy137;
					goto yy162;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy137;
					if (yych == 'E') goto yy185;
					goto yy160;
				} else {
					if (yych <= ']') goto yy137;
					if (yych <= '^') goto yy162;
					if (yych <= '_') goto yy160;
					goto yy137;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy185;
					if (yych <= 'z') goto yy160;
					goto yy137;
				} else {
					if (yych == '}') goto yy137;
					if (yych <= '~') goto yy162;
					goto yy137;
				}
			}
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy160;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy137;
				} else {
					if (yych <= '\t') goto yy204;
					if (yych >= '\v') goto yy137;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy203;
					if (yych <= 0x1F) goto yy137;
					goto yy204;
				} else {
					if (yych <= '"') goto yy203;
					if (yych <= '%') goto yy137;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy137;
				} else {
					if (yych != '=') goto yy137;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy203;
					if (yych <= '{') goto yy137;
				} else {
					if (yych != '~') goto yy137;
				}
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 478 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 3352 "Zend/zend_ini_scanner.c"
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		if (yych == '\t') goto yy204;
		if (yych == ' ') goto yy204;
		goto yy203;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(206, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy208;
		}
		if (yych <= '\r') goto yy211;
		goto yy213;
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy208;
		}
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 545 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 3423 "Zend/zend_ini_scanner.c"
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 656 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 3433 "Zend/zend_ini_scanner.c"
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy213;
		}
		if (yych <= 0x08) goto yy215;
		if (yych <= '\n') goto yy216;
		if (yych == '\r') goto yy217;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 426 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 3455 "Zend/zend_ini_scanner.c"
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		goto yy215;
yy217:
		YYDEBUG(217, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy216;
		goto yy215;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(218, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy222;
		if (yych == '$') goto yy225;
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 595 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
#line 3549 "Zend/zend_ini_scanner.c"
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy222;
		}
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 590 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
#line 3566 "Zend/zend_ini_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy221;
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 450 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 3580 "Zend/zend_ini_scanner.c"
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(228, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy230;
		}
		if (yych == '}') goto yy235;
		goto yy233;
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(231, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy230;
		}
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 455 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 3648 "Zend/zend_ini_scanner.c"
yy233:
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 656 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 3658 "Zend/zend_ini_scanner.c"
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 465 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
#line 3669 "Zend/zend_ini_scanner.c"
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(237, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy241;
			} else {
				if (yych <= '\t') goto yy243;
				if (yych <= '\n') goto yy244;
				goto yy241;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy246;
				if (yych <= 0x1F) goto yy241;
				goto yy243;
			} else {
				if (yych == ';') goto yy247;
				goto yy241;
			}
		}
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 651 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3738 "Zend/zend_ini_scanner.c"
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 501 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	EAT_LEADING_WHITESPACE();
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				YYCURSOR++;
				break;
			case '"':
				if (yytext[0] == '"') {
					sc = NULL;
				}
				YYCURSOR++;
				break;
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	if (sc) {
		yyleng = sc - SCNG(yy_text);
	} else {
		yyleng = YYCURSOR - SCNG(yy_text);
	}

	EAT_TRAILING_WHITESPACE();

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}

	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 3789 "Zend/zend_ini_scanner.c"
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy242;
			if (yych <= '\n') goto yy250;
			if (yych <= '\f') goto yy242;
			goto yy250;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy242;
				goto yy250;
			} else {
				if (yych == ';') goto yy250;
				goto yy242;
			}
		}
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 549 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 3819 "Zend/zend_ini_scanner.c"
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy244;
		goto yy245;
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy247;
		}
		if (yych <= '\n') goto yy252;
		goto yy254;
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy250:
		YYDEBUG(250, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy249;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy251;
			if (yych <= '\n') goto yy244;
		} else {
			if (yych <= '\r') goto yy246;
			if (yych == ';') goto yy247;
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 635 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 3861 "Zend/zend_ini_scanner.c"
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 645 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 3874 "Zend/zend_ini_scanner.c"
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy252;
		goto yy253;
	}
}
#line 660 "Zend/zend_ini_scanner.l"

}
