/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xslf;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.AxisTickMark;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public final class ChartFromScratch {
    private static final int COLUMN_LANGUAGES = 0;
    private static final int COLUMN_COUNTRIES = 1;
    private static final int COLUMN_SPEAKERS = 2;

    private ChartFromScratch() {
    }

    private static void usage() {
        System.out.println("Usage: ChartFromScratch <bar-chart-data.txt>");
        System.out.println("    bar-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            ChartFromScratch.usage();
            return;
        }
        try (BufferedReader modelReader = Files.newBufferedReader(Paths.get(args[0], new String[0]), StandardCharsets.UTF_8);){
            Throwable throwable;
            String ln;
            String chartTitle = modelReader.readLine();
            String seriesText = modelReader.readLine();
            String[] series = seriesText == null ? new String[]{} : seriesText.split(",");
            ArrayList<String> listLanguages = new ArrayList<String>(10);
            ArrayList<Double> listCountries = new ArrayList<Double>(10);
            ArrayList<Double> listSpeakers = new ArrayList<Double>(10);
            while ((ln = modelReader.readLine()) != null) {
                String[] vals = ln.split(",");
                listCountries.add(Double.valueOf(vals[0]));
                listSpeakers.add(Double.valueOf(vals[1]));
                listLanguages.add(vals[2]);
            }
            String[] categories = listLanguages.toArray(new String[0]);
            Double[] values1 = listCountries.toArray(new Double[0]);
            Double[] values2 = listSpeakers.toArray(new Double[0]);
            try (XMLSlideShow ppt = new XMLSlideShow();){
                ChartFromScratch.createSlideWithChart(ppt, chartTitle, series, categories, values1, values2);
                ChartFromScratch.createSlideWithChart(ppt, chartTitle, series, categories, values1, values2);
                ChartFromScratch.createSlideWithChart(ppt, chartTitle, series, categories, values1, values2);
                throwable = null;
                try (FileOutputStream out = new FileOutputStream("chart-from-scratch.pptx");){
                    ppt.write((OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            var14_16 = null;
            try (FileInputStream is = new FileInputStream("chart-from-scratch.pptx");){
                throwable = null;
                try (XMLSlideShow ppt = new XMLSlideShow((InputStream)is);){
                    for (XSLFSlide slide : ppt.getSlides()) {
                        for (XSLFShape shape : slide.getShapes()) {
                            XSLFGraphicFrame frame;
                            if (!(shape instanceof XSLFGraphicFrame) || !(frame = (XSLFGraphicFrame)shape).hasChart()) continue;
                            System.out.println(frame.getChart().getTitleShape().getText());
                        }
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var14_16 = throwable4;
                throw throwable4;
            }
        }
        System.out.println("Done");
    }

    private static void createSlideWithChart(XMLSlideShow ppt, String chartTitle, String[] series, String[] categories, Double[] values1, Double[] values2) {
        XSLFSlide slide = ppt.createSlide();
        XSLFChart chart = ppt.createChart();
        Rectangle rect2D = new Rectangle(ChartFromScratch.fromCM(1.5), ChartFromScratch.fromCM(4.0), ChartFromScratch.fromCM(22.0), ChartFromScratch.fromCM(14.0));
        slide.addChart(chart, (Rectangle2D)rect2D);
        ChartFromScratch.setBarData(chart, chartTitle, series, categories, values1, values2);
    }

    private static int fromCM(double cm) {
        return (int)Math.rint(cm * 360000.0);
    }

    private static void setBarData(XSLFChart chart, String chartTitle, String[] series, String[] categories, Double[] values1, Double[] values2) {
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        bottomAxis.setTitle(series[2]);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        leftAxis.setTitle(series[0] + "," + series[1]);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        leftAxis.setMajorTickMark(AxisTickMark.OUT);
        leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        int numOfPoints = categories.length;
        String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
        String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 1, 1));
        String valuesDataRange2 = chart.formatRange(new CellRangeAddress(1, numOfPoints, 2, 2));
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
        XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values1, (String)valuesDataRange, (int)1);
        valuesData.setFormatCode("General");
        values1[6] = 16.0;
        XDDFNumericalDataSource valuesData2 = XDDFDataSourcesFactory.fromArray((Number[])values2, (String)valuesDataRange2, (int)2);
        valuesData2.setFormatCode("General");
        XDDFBarChartData bar = (XDDFBarChartData)chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, leftAxis);
        bar.setBarGrouping(BarGrouping.CLUSTERED);
        XDDFBarChartData.Series series1 = (XDDFBarChartData.Series)bar.addSeries((XDDFDataSource)categoriesData, valuesData);
        series1.setTitle(series[0], chart.setSheetTitle(series[0], 1));
        XDDFBarChartData.Series series2 = (XDDFBarChartData.Series)bar.addSeries((XDDFDataSource)categoriesData, valuesData2);
        series2.setTitle(series[1], chart.setSheetTitle(series[1], 2));
        bar.setVaryColors(Boolean.valueOf(true));
        bar.setBarDirection(BarDirection.COL);
        chart.plot((XDDFChartData)bar);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(LegendPosition.LEFT);
        legend.setOverlay(false);
        chart.setTitleText(chartTitle);
        chart.setTitleOverlay(false);
        chart.setAutoTitleDeleted(false);
    }
}

