/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class FunctionGeneratorRemote
extends VRPNDevice
implements Runnable {
    protected Vector channelListeners = new Vector();
    protected Vector startStopListeners = new Vector();
    protected Vector sampleRateListeners = new Vector();
    protected Vector interpreterListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected static final Object notifyingChannelListenersLock = new Object();
    protected static final Object notifyingStartStopListenersLock = new Object();
    protected static final Object notifyingSampleRateListenersLock = new Object();
    protected static final Object notifyingInterpreterListenersLock = new Object();
    protected static final Object notifyingErrorListenersLock = new Object();

    public FunctionGeneratorRemote(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setChannel(int channelNumber, Channel c) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            if (c.function instanceof Function_NULL) {
                retval = this.setChannelNULL_native(channelNumber);
            } else if (c.function instanceof Function_script) {
                retval = this.setChannelScript_native(channelNumber, ((Function_script)c.function).script);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestChannel(int channelNumber) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestChannel_native(channelNumber);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestAllChannels() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestAllChannels_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestStart() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestStart_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestStop() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestStop_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestSampleRate(float rate) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestSampleRate_native(rate);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestInterpreterDescription() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestInterpreterDescription_native();
        }
        return retval;
    }

    public synchronized void addChannelReplyListener(ChannelReplyListener listener) {
        this.channelListeners.addElement(listener);
    }

    public synchronized boolean removeChannelReplyListener(ChannelReplyListener listener) {
        return this.channelListeners.removeElement(listener);
    }

    public synchronized void addStartStopReplyListener(StartStopReplyListener listener) {
        this.startStopListeners.addElement(listener);
    }

    public synchronized boolean removeStartStopReplyListener(StartStopReplyListener listener) {
        return this.startStopListeners.removeElement(listener);
    }

    public synchronized void addSampleRateReplyListener(SampleRateReplyListener listener) {
        this.sampleRateListeners.addElement(listener);
    }

    public synchronized boolean removeSampleRateReplyListener(SampleRateReplyListener listener) {
        return this.sampleRateListeners.removeElement(listener);
    }

    public synchronized void addInterpreterReplyListener(InterpreterReplyListener listener) {
        this.interpreterListeners.addElement(listener);
    }

    public synchronized boolean removeInterpreterReplyListener(InterpreterReplyListener listener) {
        return this.interpreterListeners.removeElement(listener);
    }

    public synchronized void addErrorListener(ErrorListener listener) {
        this.errorListeners.addElement(listener);
    }

    public synchronized boolean removeErrorListener(ErrorListener listener) {
        return this.errorListeners.removeElement(listener);
    }

    protected native boolean setChannelNULL_native(int var1);

    protected native boolean setChannelScript_native(int var1, String var2);

    protected native boolean requestChannel_native(int var1);

    protected native boolean requestAllChannels_native();

    protected native boolean requestStart_native();

    protected native boolean requestStop_native();

    protected native boolean requestSampleRate_native(float var1);

    protected native boolean requestInterpreterDescription_native();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.channelListeners.removeAllElements();
        this.startStopListeners.removeAllElements();
        this.sampleRateListeners.removeAllElements();
        this.interpreterListeners.removeAllElements();
        this.errorListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownFunctionGenerator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelChange_NULL(long tv_sec, long tv_usec, int channelNumber) {
        Object object = notifyingChannelListenersLock;
        synchronized (object) {
            ChannelReply c = new ChannelReply();
            c.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            c.channelNumber = channelNumber;
            c.channel = new Channel();
            Enumeration e = this.channelListeners.elements();
            while (e.hasMoreElements()) {
                ChannelReplyListener l = (ChannelReplyListener)e.nextElement();
                l.fgChannelReply(c, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelChange_Script(long tv_sec, long tv_usec, int channelNumber, String script) {
        Object object = notifyingChannelListenersLock;
        synchronized (object) {
            ChannelReply c = new ChannelReply();
            c.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            c.channelNumber = channelNumber;
            c.channel = new Channel();
            c.channel.function = new Function_script(script);
            Enumeration e = this.channelListeners.elements();
            while (e.hasMoreElements()) {
                ChannelReplyListener l = (ChannelReplyListener)e.nextElement();
                l.fgChannelReply(c, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStartReply(long tv_sec, long tv_usec, boolean isStarted) {
        Object object = notifyingStartStopListenersLock;
        synchronized (object) {
            StartReply s = new StartReply();
            s.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            s.isStarted = isStarted;
            Enumeration e = this.startStopListeners.elements();
            while (e.hasMoreElements()) {
                StartStopReplyListener l = (StartStopReplyListener)e.nextElement();
                l.fgStartReply(s, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStopReply(long tv_sec, long tv_usec, boolean isStopped) {
        Object object = notifyingStartStopListenersLock;
        synchronized (object) {
            StopReply s = new StopReply();
            s.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            s.isStopped = isStopped;
            Enumeration e = this.startStopListeners.elements();
            while (e.hasMoreElements()) {
                StartStopReplyListener l = (StartStopReplyListener)e.nextElement();
                l.fgStopReply(s, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSampleRateReply(long tv_sec, long tv_usec, double rate) {
        Object object = notifyingSampleRateListenersLock;
        synchronized (object) {
            SampleRateReply s = new SampleRateReply();
            s.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            s.sampleRate = rate;
            Enumeration e = this.sampleRateListeners.elements();
            while (e.hasMoreElements()) {
                SampleRateReplyListener l = (SampleRateReplyListener)e.nextElement();
                l.fgSampleRateReply(s, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInterpreterDescription(long tv_sec, long tv_usec, String desc) {
        Object object = notifyingInterpreterListenersLock;
        synchronized (object) {
            InterpreterReply r = new InterpreterReply();
            r.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            r.description = desc;
            Enumeration e = this.interpreterListeners.elements();
            while (e.hasMoreElements()) {
                InterpreterReplyListener l = (InterpreterReplyListener)e.nextElement();
                l.fgInterpreterReply(r, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleErrorReport(long tv_sec, long tv_usec, int err, int channel) {
        Object object = notifyingErrorListenersLock;
        synchronized (object) {
            ErrorReply r = new ErrorReply();
            r.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            r.error = FGError.getErrorFromCode(err);
            r.channel = channel;
            Enumeration e = this.errorListeners.elements();
            while (e.hasMoreElements()) {
                ErrorListener l = (ErrorListener)e.nextElement();
                l.fgErrorReply(r, this);
            }
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownFunctionGenerator();

    @Override
    protected native void mainloop();

    public static class Channel {
        public Function function = new Function_NULL();

        public Channel(Function f) {
            this.function = f;
        }

        public Channel() {
        }
    }

    public class ChannelReply {
        public Date msg_time = new Date();
        public int channelNumber = 0;
        public Channel channel = new Channel();
    }

    public static interface ChannelReplyListener {
        public void fgChannelReply(ChannelReply var1, FunctionGeneratorRemote var2);
    }

    public static interface ErrorListener {
        public void fgErrorReply(ErrorReply var1, FunctionGeneratorRemote var2);
    }

    public class ErrorReply {
        public Date msg_time = new Date();
        public FGError error;
        public int channel;
    }

    public static enum FGError {
        NO_FG_ERROR(0),
        INTERPRETER_ERROR(1),
        TAKING_TOO_LONG(2),
        INVALID_RESULT_QUANTITY(3),
        INVALID_RESULT_RANGE(4),
        UNKNOWN_ERROR(9999);

        private final int errorCode;

        private FGError(int err) {
            this.errorCode = err;
        }

        public static FGError getErrorFromCode(int err) {
            FGError[] fGErrorArray = FGError.values();
            int n = fGErrorArray.length;
            int n2 = 0;
            while (n2 < n) {
                FGError fgerror = fGErrorArray[n2];
                if (err == fgerror.errorCode) {
                    return fgerror;
                }
                ++n2;
            }
            return UNKNOWN_ERROR;
        }
    }

    public static interface Function {
    }

    public static class Function_NULL
    implements Function {
    }

    public static class Function_script
    implements Function {
        public String script = "";

        public Function_script(String script) {
            this.script = script;
        }
    }

    public class InterpreterReply {
        public Date msg_time = new Date();
        public String description = "";
    }

    public static interface InterpreterReplyListener {
        public void fgInterpreterReply(InterpreterReply var1, FunctionGeneratorRemote var2);
    }

    public class SampleRateReply {
        public Date msg_time = new Date();
        public double sampleRate = 0.0;
    }

    public static interface SampleRateReplyListener {
        public void fgSampleRateReply(SampleRateReply var1, FunctionGeneratorRemote var2);
    }

    public class StartReply {
        public Date msg_time = new Date();
        public boolean isStarted = false;
    }

    public static interface StartStopReplyListener {
        public void fgStartReply(StartReply var1, FunctionGeneratorRemote var2);

        public void fgStopReply(StopReply var1, FunctionGeneratorRemote var2);
    }

    public class StopReply {
        public Date msg_time = new Date();
        public boolean isStopped = false;
    }
}

