/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class Euler
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    int numberOfSteps = 1;
    double[][] tempData;

    public Euler(int numOfEquations) {
        this.setNumOfEquations(numOfEquations);
    }

    public Euler() {
        this(1);
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public void setNumberOfSteps(int numberOfSteps) {
        if (numberOfSteps < 1) {
            throw new IllegalArgumentException(" number of steps must be positive");
        }
        this.numberOfSteps = numberOfSteps;
    }

    @Override
    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    @Override
    public void setNumOfEquations(int numOfEquations) {
        if (this.numOfEquations == numOfEquations) {
            return;
        }
        this.numOfEquations = numOfEquations;
        this.tempData = new double[5][numOfEquations];
    }

    @Override
    public void odex(ODE ode, double[] x, double tStart, double tEnd) {
        if (this.numOfEquations < ode.getNumberOfEquations()) {
            this.setNumOfEquations(ode.getNumberOfEquations());
        }
        Euler.odex(ode, x, tStart, tEnd, this.numberOfSteps, this.tempData);
    }

    public static void step(ODE ode, double t, double[] x, double[] r, double h, double[][] tempData) {
        int n = ode.getNumberOfEquations();
        double[] y = tempData[0];
        ode.eval(t, x, y);
        int k = 0;
        while (k < n) {
            r[k] = y[k] * h + x[k];
            ++k;
        }
    }

    public static void step(ODE ode, double t, double[] x, double[] r, double h, double[][] tempData, int intermediateSteps) {
        double hh = h / (double)(intermediateSteps + 1);
        Euler.step(ode, t, x, r, hh, tempData);
        int i = 0;
        while (i < intermediateSteps) {
            Euler.step(ode, t += hh, r, r, hh, tempData);
            ++i;
        }
    }

    public static void odex(ODE ode, double[] x, double tStart, double tEnd, int numOfSteps, double[][] tempData) {
        double h = (tEnd - tStart) / (double)numOfSteps;
        double t = tStart;
        int i = 0;
        while (i < numOfSteps) {
            Euler.step(ode, t, x, x, h, tempData);
            t += h;
            ++i;
        }
    }

    public static void table(ODE ode, double[] x, double tStart, double tEnd, double[][] table) {
        Euler.table(ode, x, tStart, tEnd, table, 0);
    }

    public static void table(ODE ode, double[] x, double tStart, double tEnd, double[][] table, int intermediateSteps) {
        int numOfSteps = table.length - 1;
        double h = (tEnd - tStart) / (double)numOfSteps;
        int noe = ode.getNumberOfEquations();
        double[][] tempData = new double[5][noe];
        System.arraycopy(x, 0, table[0], 0, noe);
        double t = tStart;
        if (intermediateSteps == 0) {
            int i = 0;
            while (i < numOfSteps) {
                Euler.step(ode, t, table[i], table[i + 1], h, tempData);
                t += h;
                ++i;
            }
        } else {
            int i = 0;
            while (i < numOfSteps) {
                Euler.step(ode, t, table[i], table[i + 1], h, tempData, intermediateSteps);
                t += h;
                ++i;
            }
        }
    }
}

