/*
 * Decompiled with CFR 0.152.
 */
package de.smrj;

import de.smrj.RemoteKey;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;

public final class RemoteCall
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int TYPE_STATIC_FACTORY = 3;
    static final int TYPE_CONSTRUCTOR = 2;
    static final int TYPE_METHOD = 1;
    static final HashMap<String, Class[]> signatureToClassArray = new HashMap();
    static final WeakHashMap<Method, String> methodToSignature = new WeakHashMap();
    private final Object key;
    private final String name;
    private final Object[] parameter;
    private final String signature;
    private final int type;

    private RemoteCall(int type, RemoteKey key, String name, Object[] parameter, String signature) {
        this.type = type;
        this.key = key;
        this.name = name;
        this.parameter = parameter;
        this.signature = signature;
    }

    public static RemoteCall method(RemoteKey key, Method method, Object[] arg) {
        return new RemoteCall(1, key, method.getName(), arg, RemoteCall.methodSignature(method));
    }

    private static String methodSignature(Method method) {
        String sig = methodToSignature.get(method);
        if (sig != null) {
            return sig;
        }
        sig = RemoteCall.classToSignature(method.getParameterTypes());
        methodToSignature.put(method, sig);
        return sig;
    }

    public static RemoteCall constructor(RemoteKey key, Class clazz, Class[] pTypes, Object[] arg) {
        return new RemoteCall(2, key, clazz.getName(), arg, RemoteCall.classToSignature(pTypes));
    }

    public static RemoteCall factoryMethod(RemoteKey key, Class clazz, String methodName, Class[] pTypes, Object[] arg) {
        return new RemoteCall(3, key, clazz.getName() + "@" + methodName, arg, RemoteCall.classToSignature(pTypes));
    }

    RemoteKey getKey() {
        return (RemoteKey)this.key;
    }

    Object getObject() {
        return this.key;
    }

    protected Object[] getParameters() {
        return this.parameter;
    }

    public Class[] getSignature() throws ClassNotFoundException {
        return this.signToClass(this.signature);
    }

    public String getSignatureString() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    private Class[] signToClass(String signature) throws ClassNotFoundException {
        int ix;
        if (signature.length() == 0) {
            return null;
        }
        Class[] param = signatureToClassArray.get(signature);
        if (param != null) {
            return param;
        }
        int numParam = 0;
        block4: for (ix = 0; ix < signature.length(); ++ix) {
            switch (signature.charAt(ix)) {
                case '[': {
                    ++ix;
                    while (signature.charAt(ix) == '[') {
                        ++ix;
                    }
                    if (signature.charAt(ix) != 'L') {
                        ++numParam;
                        continue block4;
                    }
                }
                case 'L': {
                    ix = signature.indexOf(59, ix + 1);
                    ++numParam;
                    continue block4;
                }
                default: {
                    ++numParam;
                }
            }
        }
        param = new Class[numParam];
        ix = 0;
        int pix = 0;
        while (ix < signature.length()) {
            ix = this.classFor(signature, ix, param, pix++);
        }
        signatureToClassArray.put(signature, param);
        return param;
    }

    private int classFor(String signature, int ix, Class[] param, int pi) throws ClassNotFoundException {
        switch (signature.charAt(ix)) {
            case '[': {
                int r = this.classFor(signature, ix + 1, param, pi);
                param[pi] = Array.newInstance(param[pi], 0).getClass();
                return r;
            }
            case 'L': {
                int r = signature.indexOf(59, ix + 1);
                param[pi] = Class.forName(signature.substring(ix + 1, r));
                return r + 1;
            }
            case 'B': {
                param[pi] = Byte.TYPE;
                return ix + 1;
            }
            case 'Z': {
                param[pi] = Boolean.TYPE;
                return ix + 1;
            }
            case 'S': {
                param[pi] = Short.TYPE;
                return ix + 1;
            }
            case 'I': {
                param[pi] = Integer.TYPE;
                return ix + 1;
            }
            case 'J': {
                param[pi] = Long.TYPE;
                return ix + 1;
            }
            case 'F': {
                param[pi] = Float.TYPE;
                return ix + 1;
            }
            case 'D': {
                param[pi] = Double.TYPE;
                return ix + 1;
            }
            case 'C': {
                param[pi] = Character.TYPE;
                return ix + 1;
            }
        }
        throw new IllegalArgumentException("signature " + signature);
    }

    static String classToSignature(Class[] cl) {
        if (cl == null || cl.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(cl.length << 3);
        for (int ix = 0; ix < cl.length; ++ix) {
            char c;
            Class<?> class1 = cl[ix];
            while (class1.isArray()) {
                sb.append('[');
                class1 = class1.getComponentType();
            }
            if (!class1.isPrimitive()) {
                sb.append('L').append(class1.getName()).append(';');
                continue;
            }
            switch (class1.getName().charAt(0)) {
                case 'b': {
                    c = class1 == Byte.TYPE ? (char)'B' : 'Z';
                    break;
                }
                case 's': {
                    c = 'S';
                    break;
                }
                case 'i': {
                    c = 'I';
                    break;
                }
                case 'l': {
                    c = 'J';
                    break;
                }
                case 'f': {
                    c = 'F';
                    break;
                }
                case 'd': {
                    c = 'D';
                    break;
                }
                case 'c': {
                    c = 'C';
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    boolean isConstructor() {
        return this.type == 2;
    }

    boolean isMethod() {
        return this.type == 1;
    }

    boolean isStaticFactoryMethod() {
        return this.type == 3;
    }
}

