/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp;

import de.smrj.Broadcaster;
import de.smrj.RemoteCall;
import de.smrj.tcp.util.ByteArrayOutputStream;
import de.smrj.tcp.util.ByteOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TCPBroadcaster
extends Broadcaster {
    boolean acceptListenerReady;
    private static boolean measure = false;
    private PrintWriter timeWriter;
    protected Object returnValue;
    protected int port;
    protected ByteOutputStream bosOUT = new ByteArrayOutputStream(0x100000);
    protected ByteOutputStream bosIN = new ByteArrayOutputStream(0x100000);
    private volatile ObjectOutputStream oos;
    static final boolean SEND_LENGTH = true;
    private ClientConnectListener clientListener;
    protected boolean doSend;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPBroadcaster(int port, int type) {
        super(type);
        this.port = port;
        this.clientListener = this.createClientConnectListener();
        new Thread(this.clientListener).start();
        Logger.getLogger("SMRJ").fine("TCPBroadcaster.TCPBroadcaster()");
        TCPBroadcaster tCPBroadcaster = this;
        synchronized (tCPBroadcaster) {
            try {
                while (!this.acceptListenerReady) {
                    this.wait();
                }
                Logger.getLogger("SMRJ").log(Level.INFO, "TCPBroadcaster: accepting connections");
            }
            catch (InterruptedException e) {
                Logger.getLogger("SMRJ").log(Level.SEVERE, "sync", e);
            }
        }
        Logger.getLogger("SMRJ").log(Level.INFO, "TCPBroadcaster started.  port={0}", new Object[]{new Integer(port)});
        if (measure) {
            try {
                this.timeWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream("measure.txt")));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                measure = false;
            }
        }
    }

    protected abstract ClientConnectListener createClientConnectListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeRemoteCall(RemoteCall rc) throws IOException {
        TCPBroadcaster tCPBroadcaster = this;
        synchronized (tCPBroadcaster) {
            this.returnValue = null;
            this.bosOUT.reset();
            if (this.oos == null) {
                this.oos = this.createObjectOutputStream(this.bosOUT);
            }
            this.oos.reset();
            long s = System.currentTimeMillis();
            this.oos.writeObject(rc);
            long t = System.currentTimeMillis() - s;
            this.bosOUT.prepare();
            s = System.currentTimeMillis();
            this.send();
            if (measure) {
                long t2 = System.currentTimeMillis() - s;
                this.timeWriter.println(t + ":" + t2 + ":" + rc.getName() + "[" + rc.getSignatureString() + "]");
                this.timeWriter.flush();
            }
            return this.returnValue;
        }
    }

    public void dispose() {
        super.dispose();
        this.clientListener.endAccepting();
    }

    protected abstract void send() throws IOException;

    static {
        String foo = System.getProperty("smrj.measure", "false");
        if (foo.trim().startsWith("true")) {
            measure = true;
        }
    }

    protected abstract class ClientConnectListener
    implements Runnable {
        protected boolean acceptConnections = true;

        protected ClientConnectListener() {
        }

        public void endAccepting() {
            this.acceptConnections = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.getLogger("SMRJ").info("binding");
            try {
                this.init();
            }
            catch (IOException e1) {
                Logger.getLogger("SMRJ").log(Level.SEVERE, "bind error", e1);
            }
            TCPBroadcaster e1 = TCPBroadcaster.this;
            synchronized (e1) {
                TCPBroadcaster.this.acceptListenerReady = true;
                TCPBroadcaster.this.notifyAll();
            }
            try {
                while (this.acceptConnections) {
                    Logger.getLogger("SMRJ").log(Level.INFO, "TCPBroadcaster: accepting client");
                    this.acceptClient();
                }
            }
            catch (IOException e) {
                Logger.getLogger("SMRJ").log(Level.WARNING, "connect error", e);
            }
        }

        protected abstract void acceptClient() throws IOException;

        protected abstract void init() throws IOException;
    }
}

