/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.util;

import de.smrj.tcp.util.ByteOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;

public final class ByteBufferOutputStream
extends ByteOutputStream {
    final Object BUF_LOCK = new Object();
    ByteBuffer BBUF = ByteBufferOutputStream.allocDirect(1024);
    private static final boolean debug = false;
    private boolean isDefault = true;

    public ByteBufferOutputStream() {
        this.BBUF.position(4);
        this.BBUF.limit(this.BBUF.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        Object object = this.BUF_LOCK;
        synchronized (object) {
            if (this.BBUF.remaining() < 0) {
                this.growBuffer(this.BBUF.capacity() + 1, 1);
            }
            this.BBUF.put((byte)b);
        }
    }

    private void growBuffer(int newcount, int shift) {
        ByteBuffer temp = this.BBUF;
        temp.flip();
        int newSize = Math.max(this.BBUF.capacity() << shift, newcount);
        this.BBUF = ByteBufferOutputStream.allocDirect(newSize);
        this.BBUF.put(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Object object = this.BUF_LOCK;
        synchronized (object) {
            if (len > this.BBUF.remaining()) {
                this.growBuffer(this.BBUF.position() + len, 1);
            }
            this.BBUF.put(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(SocketChannel s) throws IOException {
        ByteBuffer bb;
        Object object = this.BUF_LOCK;
        synchronized (object) {
            bb = this.BBUF.duplicate();
        }
        bb.flip();
        if (this.isDefault) {
            bb.position(4);
        }
        s.write(bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream s) throws IOException {
        ByteBuffer bb;
        Object object = this.BUF_LOCK;
        synchronized (object) {
            bb = this.BBUF.duplicate();
        }
        bb.flip();
        if (this.isDefault) {
            bb.position(4);
        }
        Channels.newChannel(s).write(bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.BUF_LOCK;
        synchronized (object) {
            this.BBUF.clear().position(4);
            this.isDefault = true;
        }
    }

    public int size() {
        return this.isDefault ? this.BBUF.position() - 4 : this.BBUF.position();
    }

    public String toString() {
        return "BBOut: [" + this.BBUF.toString() + "]";
    }

    private static ByteBuffer allocDirect(int num) {
        return ByteBuffer.allocateDirect(num).order(ByteOrder.nativeOrder());
    }

    public byte[] toArray() {
        ByteBuffer bb = this.BBUF.duplicate();
        bb.flip();
        if (this.isDefault) {
            bb.position(4);
        }
        byte[] ret = new byte[bb.remaining()];
        bb.get(ret);
        return ret;
    }

    void debug() {
        System.out.println(new Exception().getStackTrace()[1] + " " + this.toString());
    }

    public void prepare() {
        int length = this.size();
        ByteOrder oldOrder = this.BBUF.order();
        this.BBUF.order(ByteOrder.BIG_ENDIAN).putInt(0, length).order(oldOrder);
        this.isDefault = false;
    }

    public ByteBuffer duplicateBuffer() {
        return (ByteBuffer)this.BBUF.duplicate().flip().position(this.isDefault ? 4 : 0);
    }
}

