/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.IClass;
import org.codehaus.janino.Location;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.Traverser;
import org.codehaus.janino.util.iterator.ReverseListIterator;

public class Java {
    private Java() {
    }

    public static String join(Object[] objectArray, String string) {
        return Java.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string, int n, int n2) {
        if (objectArray == null) {
            return "(null)";
        }
        if (n >= n2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(objectArray[n].toString());
        ++n;
        while (n < n2) {
            stringBuffer.append(string);
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void setEnclosingBlockStatement(ArrayInitializerOrRvalue arrayInitializerOrRvalue, BlockStatement blockStatement) {
        if (arrayInitializerOrRvalue instanceof Rvalue) {
            ((Rvalue)arrayInitializerOrRvalue).setEnclosingBlockStatement(blockStatement);
        } else if (arrayInitializerOrRvalue instanceof ArrayInitializer) {
            ArrayInitializerOrRvalue[] arrayInitializerOrRvalueArray = ((ArrayInitializer)arrayInitializerOrRvalue).values;
            int n = 0;
            while (n < arrayInitializerOrRvalueArray.length) {
                Java.setEnclosingBlockStatement(arrayInitializerOrRvalueArray[n], blockStatement);
                ++n;
            }
        } else {
            throw new RuntimeException("Unexpected array or initializer class " + arrayInitializerOrRvalue.getClass().getName());
        }
    }

    public static interface Scope {
        public Scope getEnclosingScope();
    }

    public static interface Locatable {
        public Location getLocation();

        public void throwParseException(String var1) throws Parser.ParseException;
    }

    public static abstract class Located
    implements Locatable {
        private final Location location;

        protected Located(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public void throwParseException(String string) throws Parser.ParseException {
            throw new Parser.ParseException(string, this.location);
        }
    }

    public static final class CompilationUnit
    implements Scope {
        public String optionalFileName;
        public PackageDeclaration optionalPackageDeclaration = null;
        public final List importDeclarations = new ArrayList();
        public final List packageMemberTypeDeclarations = new ArrayList();

        public CompilationUnit(String string) {
            this.optionalFileName = string;
        }

        public void addImportDeclaration(ImportDeclaration importDeclaration) {
            this.importDeclarations.add(importDeclaration);
        }

        public void addPackageMemberTypeDeclaration(PackageMemberTypeDeclaration packageMemberTypeDeclaration) {
            this.packageMemberTypeDeclarations.add(packageMemberTypeDeclaration);
            packageMemberTypeDeclaration.setDeclaringCompilationUnit(this);
        }

        public Scope getEnclosingScope() {
            throw new RuntimeException("A compilation unit has no enclosing scope");
        }

        public PackageMemberTypeDeclaration getPackageMemberTypeDeclaration(String string) {
            Iterator iterator = this.packageMemberTypeDeclarations.iterator();
            while (iterator.hasNext()) {
                PackageMemberTypeDeclaration packageMemberTypeDeclaration = (PackageMemberTypeDeclaration)iterator.next();
                if (!packageMemberTypeDeclaration.getName().equals(string)) continue;
                return packageMemberTypeDeclaration;
            }
            return null;
        }

        public PackageMemberTypeDeclaration[] getPackageMemberTypeDeclarations() {
            return this.packageMemberTypeDeclarations.toArray(new PackageMemberTypeDeclaration[this.packageMemberTypeDeclarations.size()]);
        }

        public void setPackageDeclaration(PackageDeclaration packageDeclaration) {
            if (this.optionalPackageDeclaration != null) {
                throw new RuntimeException("Re-setting package declaration");
            }
            this.optionalPackageDeclaration = packageDeclaration;
        }

        public static class SingleTypeImportDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public SingleTypeImportDeclaration(Location location, String[] stringArray) {
                super(location);
                this.identifiers = stringArray;
            }

            public final void accept(Visitor.ImportVisitor importVisitor) {
                importVisitor.visitSingleTypeImportDeclaration(this);
            }
        }

        public static class TypeImportOnDemandDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public TypeImportOnDemandDeclaration(Location location, String[] stringArray) {
                super(location);
                this.identifiers = stringArray;
            }

            public final void accept(Visitor.ImportVisitor importVisitor) {
                importVisitor.visitTypeImportOnDemandDeclaration(this);
            }
        }

        public static class SingleStaticImportDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public SingleStaticImportDeclaration(Location location, String[] stringArray) {
                super(location);
                this.identifiers = stringArray;
            }

            public final void accept(Visitor.ImportVisitor importVisitor) {
                importVisitor.visitSingleStaticImportDeclaration(this);
            }
        }

        public static class StaticImportOnDemandDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public StaticImportOnDemandDeclaration(Location location, String[] stringArray) {
                super(location);
                this.identifiers = stringArray;
            }

            public final void accept(Visitor.ImportVisitor importVisitor) {
                importVisitor.visitStaticImportOnDemandDeclaration(this);
            }
        }

        public static abstract class ImportDeclaration
        extends Located {
            public ImportDeclaration(Location location) {
                super(location);
            }

            public abstract void accept(Visitor.ImportVisitor var1);
        }
    }

    public static class PackageDeclaration
    extends Located {
        public final String packageName;

        public PackageDeclaration(Location location, String string) {
            super(location);
            this.packageName = string;
        }
    }

    public static interface TypeDeclaration
    extends Locatable,
    Scope {
        public void accept(Visitor.TypeDeclarationVisitor var1);

        public String createAnonymousClassName();

        public String createLocalTypeName(String var1);

        public String getClassName();

        public MemberTypeDeclaration getMemberTypeDeclaration(String var1);
    }

    public static interface DocCommentable {
        public String getDocComment();

        public boolean hasDeprecatedDocTag();
    }

    public static interface PackageMemberTypeDeclaration
    extends NamedTypeDeclaration {
        public CompilationUnit getDeclaringCompilationUnit();

        public void setDeclaringCompilationUnit(CompilationUnit var1);
    }

    public static interface MemberTypeDeclaration
    extends NamedTypeDeclaration,
    TypeBodyDeclaration {
    }

    public static interface NamedTypeDeclaration
    extends TypeDeclaration {
        public String getName();
    }

    static interface InnerClassDeclaration
    extends TypeDeclaration {
        public void defineSyntheticField(IClass.IField var1) throws CompileException;
    }

    public static abstract class AbstractTypeDeclaration
    implements TypeDeclaration {
        private final Location location;
        public final short modifiers;
        public final List declaredMethods = new ArrayList();
        public final List declaredClassesAndInterfaces = new ArrayList();
        private Scope enclosingScope = null;
        IClass resolvedType = null;
        public int anonymousClassCount = 0;
        public int localClassCount = 0;

        public AbstractTypeDeclaration(Location location, short s) {
            this.location = location;
            this.modifiers = s;
        }

        public abstract void accept(Visitor.TypeDeclarationVisitor var1);

        public void addDeclaredMethod(MethodDeclarator methodDeclarator) {
            this.declaredMethods.add(methodDeclarator);
            methodDeclarator.setDeclaringType(this);
        }

        public void addMemberTypeDeclaration(MemberTypeDeclaration memberTypeDeclaration) {
            this.declaredClassesAndInterfaces.add(memberTypeDeclaration);
            memberTypeDeclaration.setDeclaringType(this);
        }

        public String createAnonymousClassName() {
            return String.valueOf(this.getClassName()) + '$' + ++this.anonymousClassCount;
        }

        public String createLocalTypeName(String string) {
            return String.valueOf(this.getClassName()) + '$' + ++this.localClassCount + '$' + string;
        }

        public abstract String getClassName();

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public Location getLocation() {
            return this.location;
        }

        public MemberTypeDeclaration getMemberTypeDeclaration(String string) {
            Iterator iterator = this.declaredClassesAndInterfaces.iterator();
            while (iterator.hasNext()) {
                MemberTypeDeclaration memberTypeDeclaration = (MemberTypeDeclaration)iterator.next();
                if (!memberTypeDeclaration.getName().equals(string)) continue;
                return memberTypeDeclaration;
            }
            return null;
        }

        public Collection getMemberTypeDeclarations() {
            return this.declaredClassesAndInterfaces;
        }

        public void setEnclosingScope(Scope scope) {
            if (this.enclosingScope != null && scope != this.enclosingScope) {
                throw new RuntimeException("Enclosing scope is already set for type declaration \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = scope;
        }

        public void throwParseException(String string) throws Parser.ParseException {
            throw new Parser.ParseException(string, this.location);
        }

        public abstract String toString();
    }

    public static abstract class ClassDeclaration
    extends AbstractTypeDeclaration {
        public final List constructors = new ArrayList();
        public final List variableDeclaratorsAndInitializers = new ArrayList();
        final SortedMap syntheticFields = new TreeMap();

        public ClassDeclaration(Location location, short s) {
            super(location, s);
        }

        public void addConstructor(ConstructorDeclarator constructorDeclarator) {
            this.constructors.add(constructorDeclarator);
            constructorDeclarator.setDeclaringType(this);
        }

        public void addVariableDeclaratorOrInitializer(TypeBodyDeclaration typeBodyDeclaration) {
            this.variableDeclaratorsAndInitializers.add(typeBodyDeclaration);
            typeBodyDeclaration.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.declaredIFields = null;
            }
        }

        public void defineSyntheticField(IClass.IField iField) throws CompileException {
            if (!(this instanceof InnerClassDeclaration)) {
                throw new RuntimeException();
            }
            IClass.IField iField2 = (IClass.IField)this.syntheticFields.get(iField.getName());
            if (iField2 != null) {
                if (iField.getType() != iField2.getType()) {
                    throw new RuntimeException();
                }
                return;
            }
            this.syntheticFields.put(iField.getName(), iField);
        }

        ConstructorDeclarator[] getConstructors() {
            if (this.constructors.isEmpty()) {
                ConstructorDeclarator constructorDeclarator = new ConstructorDeclarator(this.getLocation(), null, 1, new FunctionDeclarator.FormalParameter[0], new Type[0], null, new Block(this.getLocation()));
                constructorDeclarator.setDeclaringType(this);
                return new ConstructorDeclarator[]{constructorDeclarator};
            }
            return this.constructors.toArray(new ConstructorDeclarator[this.constructors.size()]);
        }
    }

    public static final class AnonymousClassDeclaration
    extends ClassDeclaration
    implements InnerClassDeclaration {
        public final Type baseType;
        private String myName = null;

        public AnonymousClassDeclaration(Location location, Type type) {
            super(location, (short)18);
            this.baseType = type;
            this.baseType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitAnonymousClassDeclaration(this);
        }

        public String getClassName() {
            if (this.myName == null) {
                Scope scope = this.getEnclosingScope();
                while (!(scope instanceof TypeDeclaration)) {
                    scope = scope.getEnclosingScope();
                }
                this.myName = ((TypeDeclaration)scope).createAnonymousClassName();
            }
            return this.myName;
        }

        public String toString() {
            return this.getClassName();
        }
    }

    public static abstract class NamedClassDeclaration
    extends ClassDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final String name;
        public final Type optionalExtendedType;
        public final Type[] implementedTypes;

        public NamedClassDeclaration(Location location, String string, short s, String string2, Type type, Type[] typeArray) {
            super(location, s);
            this.optionalDocComment = string;
            this.name = string2;
            this.optionalExtendedType = type;
            if (type != null) {
                type.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
            this.implementedTypes = typeArray;
            int n = 0;
            while (n < typeArray.length) {
                typeArray[n].setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
                ++n;
            }
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class EnclosingScopeOfTypeDeclaration
    implements Scope {
        public final TypeDeclaration typeDeclaration;

        public EnclosingScopeOfTypeDeclaration(TypeDeclaration typeDeclaration) {
            this.typeDeclaration = typeDeclaration;
        }

        public Scope getEnclosingScope() {
            return this.typeDeclaration.getEnclosingScope();
        }
    }

    public static final class MemberClassDeclaration
    extends NamedClassDeclaration
    implements MemberTypeDeclaration,
    InnerClassDeclaration {
        public MemberClassDeclaration(Location location, String string, short s, String string2, Type type, Type[] typeArray) {
            super(location, string, s, string2, type, typeArray);
        }

        public void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitMemberClassDeclaration(this);
        }

        public void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitMemberClassDeclaration(this);
        }

        public String getClassName() {
            return String.valueOf(this.getDeclaringType().getClassName()) + '$' + this.getName();
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public void setDeclaringType(TypeDeclaration typeDeclaration) {
            this.setEnclosingScope(typeDeclaration);
        }
    }

    public static final class LocalClassDeclaration
    extends NamedClassDeclaration
    implements InnerClassDeclaration {
        public LocalClassDeclaration(Location location, String string, short s, String string2, Type type, Type[] typeArray) {
            super(location, string, s, string2, type, typeArray);
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitLocalClassDeclaration(this);
        }

        public String getClassName() {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            return String.valueOf(((TypeDeclaration)scope).getClassName()) + '$' + this.name;
        }

        protected IClass getOuterIClass2() {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof FunctionDeclarator)) {
                scope = scope.getEnclosingScope();
            }
            boolean bl = scope instanceof MethodDeclarator && (((FunctionDeclarator)scope).modifiers & 8) != 0;
            while (!(scope instanceof TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)scope;
            return typeDeclaration instanceof ClassDeclaration && !bl ? (IClass)((Object)typeDeclaration) : null;
        }
    }

    public static final class PackageMemberClassDeclaration
    extends NamedClassDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberClassDeclaration(Location location, String string, short s, String string2, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, string, s, string2, type, typeArray);
            if ((s & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member class declaration");
            }
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitPackageMemberClassDeclaration(this);
        }

        public String getClassName() {
            String string = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                string = String.valueOf(compilationUnit.optionalPackageDeclaration.packageName) + '.' + string;
            }
            return string;
        }

        public CompilationUnit getDeclaringCompilationUnit() {
            return (CompilationUnit)this.getEnclosingScope();
        }

        protected IClass getOuterIClass2() {
            return null;
        }

        public void setDeclaringCompilationUnit(CompilationUnit compilationUnit) {
            this.setEnclosingScope(compilationUnit);
        }
    }

    public static abstract class InterfaceDeclaration
    extends AbstractTypeDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public String name;
        public Type[] extendedTypes;
        public final List constantDeclarations = new ArrayList();
        IClass[] interfaces = null;

        protected InterfaceDeclaration(Location location, String string, short s, String string2, Type[] typeArray) {
            super(location, s);
            this.optionalDocComment = string;
            this.name = string2;
            this.extendedTypes = typeArray;
            int n = 0;
            while (n < typeArray.length) {
                typeArray[n].setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
                ++n;
            }
        }

        public void addConstantDeclaration(FieldDeclaration fieldDeclaration) {
            this.constantDeclarations.add(fieldDeclaration);
            fieldDeclaration.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.declaredIFields = null;
            }
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class MemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements MemberTypeDeclaration {
        public MemberInterfaceDeclaration(Location location, String string, short s, String string2, Type[] typeArray) {
            super(location, string, s, string2, typeArray);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitMemberInterfaceDeclaration(this);
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitMemberInterfaceDeclaration(this);
        }

        public String getClassName() {
            NamedTypeDeclaration namedTypeDeclaration = (NamedTypeDeclaration)this.getEnclosingScope();
            return String.valueOf(namedTypeDeclaration.getClassName()) + '$' + this.getName();
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public void setDeclaringType(TypeDeclaration typeDeclaration) {
            this.setEnclosingScope(typeDeclaration);
        }
    }

    public static final class PackageMemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberInterfaceDeclaration(Location location, String string, short s, String string2, Type[] typeArray) throws Parser.ParseException {
            super(location, string, s, string2, typeArray);
            if ((s & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member interface declaration");
            }
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitPackageMemberInterfaceDeclaration(this);
        }

        public String getClassName() {
            String string = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                string = String.valueOf(compilationUnit.optionalPackageDeclaration.packageName) + '.' + string;
            }
            return string;
        }

        public CompilationUnit getDeclaringCompilationUnit() {
            return (CompilationUnit)this.getEnclosingScope();
        }

        public void setDeclaringCompilationUnit(CompilationUnit compilationUnit) {
            this.setEnclosingScope(compilationUnit);
        }
    }

    public static interface TypeBodyDeclaration
    extends Locatable,
    Scope {
        public void accept(Visitor.TypeBodyDeclarationVisitor var1);

        public TypeDeclaration getDeclaringType();

        public boolean isStatic();

        public void setDeclaringType(TypeDeclaration var1);
    }

    public static abstract class AbstractTypeBodyDeclaration
    extends Located
    implements TypeBodyDeclaration {
        private TypeDeclaration declaringType;
        public final boolean statiC;

        protected AbstractTypeBodyDeclaration(Location location, boolean bl) {
            super(location);
            this.statiC = bl;
        }

        public abstract void accept(Visitor.TypeBodyDeclarationVisitor var1);

        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        public Scope getEnclosingScope() {
            return this.declaringType;
        }

        public boolean isStatic() {
            return this.statiC;
        }

        public void setDeclaringType(TypeDeclaration typeDeclaration) {
            if (this.declaringType != null && typeDeclaration != null) {
                throw new RuntimeException("Declaring type for type body declaration \"" + this.toString() + "\"at " + this.getLocation() + " is already set");
            }
            this.declaringType = typeDeclaration;
        }

        public void setEnclosingScope(Scope scope) {
            this.declaringType = (TypeDeclaration)scope;
        }
    }

    public static final class Initializer
    extends AbstractTypeBodyDeclaration
    implements BlockStatement {
        public final Block block;

        public Initializer(Location location, boolean bl, Block block) {
            super(location, bl);
            this.block = block;
            this.block.setEnclosingScope(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitInitializer(this);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitInitializer(this);
        }
    }

    public static abstract class FunctionDeclarator
    extends AbstractTypeBodyDeclaration
    implements DocCommentable {
        private final String optionalDocComment;
        public final short modifiers;
        public final Type type;
        public final String name;
        public final FormalParameter[] formalParameters;
        public final Type[] thrownExceptions;
        public final Block optionalBody;
        IClass returnType = null;

        public FunctionDeclarator(Location location, String string, short s, Type type, String string2, FormalParameter[] formalParameterArray, Type[] typeArray, Block block) {
            super(location, (s & 8) != 0);
            this.optionalDocComment = string;
            this.modifiers = s;
            this.type = type;
            this.type.setEnclosingScope(this);
            this.name = string2;
            this.formalParameters = formalParameterArray;
            int n = 0;
            while (n < formalParameterArray.length) {
                formalParameterArray[n].type.setEnclosingScope(this);
                ++n;
            }
            this.thrownExceptions = typeArray;
            int n2 = 0;
            while (n2 < typeArray.length) {
                typeArray[n2].setEnclosingScope(this);
                ++n2;
            }
            this.optionalBody = block;
            if (block != null) {
                block.setEnclosingScope(this);
            }
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public Scope getEnclosingScope() {
            return this.getDeclaringType();
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public static final class FormalParameter
        extends Located {
            public final boolean finaL;
            public final Type type;
            public final String name;
            public LocalVariable localVariable = null;

            public FormalParameter(Location location, boolean bl, Type type, String string) {
                super(location);
                this.finaL = bl;
                this.type = type;
                this.name = string;
            }

            public String toString() {
                return String.valueOf(this.type.toString()) + ' ' + this.name;
            }
        }
    }

    public static final class ConstructorDeclarator
    extends FunctionDeclarator {
        IClass.IConstructor iConstructor = null;
        public ConstructorInvocation optionalConstructorInvocation = null;
        Map syntheticParameters = new HashMap();

        public ConstructorDeclarator(Location location, String string, short s, FunctionDeclarator.FormalParameter[] formalParameterArray, Type[] typeArray, ConstructorInvocation constructorInvocation, Block block) {
            super(location, string, s, new BasicType(location, 0), "<init>", formalParameterArray, typeArray, block);
            this.optionalConstructorInvocation = constructorInvocation;
            if (constructorInvocation != null) {
                constructorInvocation.setEnclosingScope(this);
            }
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitConstructorDeclarator(this);
        }

        public ClassDeclaration getDeclaringClass() {
            return (ClassDeclaration)this.getEnclosingScope();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getDeclaringClass().getClassName());
            stringBuffer.append('(');
            FunctionDeclarator.FormalParameter[] formalParameterArray = this.formalParameters;
            int n = 0;
            while (n < formalParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(formalParameterArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class MethodDeclarator
    extends FunctionDeclarator {
        IClass.IMethod iMethod = null;

        public MethodDeclarator(Location location, String string, short s, Type type, String string2, FunctionDeclarator.FormalParameter[] formalParameterArray, Type[] typeArray, Block block) {
            super(location, string, s, type, string2, formalParameterArray, typeArray, block);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitMethodDeclarator(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            stringBuffer.append('(');
            FunctionDeclarator.FormalParameter[] formalParameterArray = this.formalParameters;
            int n = 0;
            while (n < formalParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(formalParameterArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class FieldDeclaration
    extends Statement
    implements TypeBodyDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final short modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public FieldDeclaration(Location location, String string, short s, Type type, VariableDeclarator[] variableDeclaratorArray) {
            super(location);
            this.optionalDocComment = string;
            this.modifiers = s;
            this.type = type;
            this.type.setEnclosingScope(this);
            this.variableDeclarators = variableDeclaratorArray;
            int n = 0;
            while (n < variableDeclaratorArray.length) {
                VariableDeclarator variableDeclarator = variableDeclaratorArray[n];
                if (variableDeclarator.optionalInitializer != null) {
                    Java.setEnclosingBlockStatement(variableDeclarator.optionalInitializer, this);
                }
                ++n;
            }
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitFieldDeclaration(this);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitFieldDeclaration(this);
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public void setDeclaringType(TypeDeclaration typeDeclaration) {
            this.setEnclosingScope(typeDeclaration);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Mod.shortToString(this.modifiers)).append(' ').append(this.type).append(' ').append(this.variableDeclarators[0]);
            int n = 1;
            while (n < this.variableDeclarators.length) {
                stringBuffer.append(", ").append(this.variableDeclarators[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public static final class VariableDeclarator
    extends Located {
        public final String name;
        public final int brackets;
        public final ArrayInitializerOrRvalue optionalInitializer;
        public LocalVariable localVariable = null;

        public VariableDeclarator(Location location, String string, int n, ArrayInitializerOrRvalue arrayInitializerOrRvalue) {
            super(location);
            this.name = string;
            this.brackets = n;
            this.optionalInitializer = arrayInitializerOrRvalue;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            int n = 0;
            while (n < this.brackets) {
                stringBuffer.append("[]");
                ++n;
            }
            if (this.optionalInitializer != null) {
                stringBuffer.append(" = ").append(this.optionalInitializer);
            }
            return stringBuffer.toString();
        }
    }

    public static interface BlockStatement
    extends Locatable,
    Scope {
        public void accept(Visitor.BlockStatementVisitor var1);

        public Scope getEnclosingScope();

        public void setEnclosingScope(Scope var1);
    }

    public static abstract class Statement
    extends Located
    implements BlockStatement {
        private Scope enclosingScope = null;

        protected Statement(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.BlockStatementVisitor var1);

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public void setEnclosingScope(Scope scope) {
            if (this.enclosingScope != null && scope != this.enclosingScope) {
                throw new RuntimeException("Enclosing scope is already set for statement \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = scope;
        }
    }

    public static final class LabeledStatement
    extends BreakableStatement {
        public final String label;
        public final Statement body;

        public LabeledStatement(Location location, String string, Statement statement) {
            super(location);
            this.label = string;
            this.body = statement;
            this.body.setEnclosingScope(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitLabeledStatement(this);
        }
    }

    public static final class Block
    extends Statement {
        public final List statements = new ArrayList();

        public Block(Location location) {
            super(location);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitBlock(this);
        }

        void addButDontEncloseStatement(BlockStatement blockStatement) {
            this.statements.add(blockStatement);
        }

        public void addButDontEncloseStatements(List list) {
            this.statements.addAll(list);
        }

        public void addStatement(BlockStatement blockStatement) {
            this.statements.add(blockStatement);
            blockStatement.setEnclosingScope(this);
        }

        public void addStatements(List list) {
            this.statements.addAll(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((BlockStatement)iterator.next()).setEnclosingScope(this);
            }
        }

        public BlockStatement[] getStatements() {
            return this.statements.toArray(new BlockStatement[this.statements.size()]);
        }
    }

    public static abstract class BreakableStatement
    extends Statement {
        CodeContext.Offset whereToBreak = null;

        protected BreakableStatement(Location location) {
            super(location);
        }
    }

    public static abstract class ContinuableStatement
    extends BreakableStatement {
        protected CodeContext.Offset whereToContinue = null;
        protected boolean bodyHasContinue = false;

        protected ContinuableStatement(Location location) {
            super(location);
        }
    }

    public static final class ExpressionStatement
    extends Statement {
        public final Rvalue rvalue;

        public ExpressionStatement(Rvalue rvalue) throws Parser.ParseException {
            super(rvalue.getLocation());
            if (!(rvalue instanceof Assignment || rvalue instanceof Crement || rvalue instanceof MethodInvocation || rvalue instanceof SuperclassMethodInvocation || rvalue instanceof NewClassInstance)) {
                this.throwParseException("This kind of expression is not allowed in an expression statement");
            }
            this.rvalue = rvalue;
            this.rvalue.setEnclosingBlockStatement(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitExpressionStatement(this);
        }
    }

    public static final class LocalClassDeclarationStatement
    extends Statement {
        public final LocalClassDeclaration lcd;

        public LocalClassDeclarationStatement(LocalClassDeclaration localClassDeclaration) {
            super(localClassDeclaration.getLocation());
            this.lcd = localClassDeclaration;
            this.lcd.setEnclosingScope(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitLocalClassDeclarationStatement(this);
        }
    }

    public static final class IfStatement
    extends Statement {
        public final Rvalue condition;
        public final BlockStatement thenStatement;
        public final BlockStatement optionalElseStatement;

        public IfStatement(Location location, Rvalue rvalue, BlockStatement blockStatement, BlockStatement blockStatement2) {
            super(location);
            this.condition = rvalue;
            this.condition.setEnclosingBlockStatement(this);
            this.thenStatement = blockStatement;
            this.thenStatement.setEnclosingScope(this);
            this.optionalElseStatement = blockStatement2;
            if (blockStatement2 != null) {
                blockStatement2.setEnclosingScope(this);
            }
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitIfStatement(this);
        }
    }

    public static final class ForStatement
    extends ContinuableStatement {
        public final BlockStatement optionalInit;
        public final Rvalue optionalCondition;
        public final Rvalue[] optionalUpdate;
        public final BlockStatement body;

        public ForStatement(Location location, BlockStatement blockStatement, Rvalue rvalue, Rvalue[] rvalueArray, BlockStatement blockStatement2) {
            super(location);
            this.optionalInit = blockStatement;
            if (blockStatement != null) {
                blockStatement.setEnclosingScope(this);
            }
            this.optionalCondition = rvalue;
            if (rvalue != null) {
                rvalue.setEnclosingBlockStatement(this);
            }
            this.optionalUpdate = rvalueArray;
            if (rvalueArray != null) {
                int n = 0;
                while (n < rvalueArray.length) {
                    rvalueArray[n].setEnclosingBlockStatement(this);
                    ++n;
                }
            }
            this.body = blockStatement2;
            this.body.setEnclosingScope(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitForStatement(this);
        }
    }

    public static final class WhileStatement
    extends ContinuableStatement {
        public final Rvalue condition;
        public final BlockStatement body;

        public WhileStatement(Location location, Rvalue rvalue, BlockStatement blockStatement) {
            super(location);
            this.condition = rvalue;
            this.condition.setEnclosingBlockStatement(this);
            this.body = blockStatement;
            this.body.setEnclosingScope(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitWhileStatement(this);
        }
    }

    public static final class TryStatement
    extends Statement {
        public final BlockStatement body;
        public final List catchClauses;
        public final Block optionalFinally;
        CodeContext.Offset finallyOffset = null;

        public TryStatement(Location location, BlockStatement blockStatement, List list, Block block) {
            super(location);
            this.body = blockStatement;
            this.body.setEnclosingScope(this);
            this.catchClauses = list;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((CatchClause)iterator.next()).setEnclosingTryStatement(this);
            }
            this.optionalFinally = block;
            if (block != null) {
                block.setEnclosingScope(this);
            }
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitTryStatement(this);
        }
    }

    public static class CatchClause
    extends Located
    implements Scope {
        public final FunctionDeclarator.FormalParameter caughtException;
        public final Block body;
        private TryStatement enclosingTryStatement = null;

        public CatchClause(Location location, FunctionDeclarator.FormalParameter formalParameter, Block block) {
            super(location);
            this.caughtException = formalParameter;
            this.caughtException.type.setEnclosingScope(this);
            this.body = block;
            this.body.setEnclosingScope(this);
        }

        public Scope getEnclosingScope() {
            return this.enclosingTryStatement;
        }

        public void setEnclosingTryStatement(TryStatement tryStatement) {
            if (this.enclosingTryStatement != null && tryStatement != this.enclosingTryStatement) {
                throw new RuntimeException("Enclosing TYR statement already set for catch clause " + this.toString() + " at " + this.getLocation());
            }
            this.enclosingTryStatement = tryStatement;
        }
    }

    public static final class SwitchStatement
    extends BreakableStatement {
        public final Rvalue condition;
        public final List sbsgs;

        public SwitchStatement(Location location, Rvalue rvalue, List list) {
            super(location);
            this.condition = rvalue;
            this.condition.setEnclosingBlockStatement(this);
            this.sbsgs = list;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SwitchBlockStatementGroup switchBlockStatementGroup = (SwitchBlockStatementGroup)iterator.next();
                Iterator iterator2 = switchBlockStatementGroup.caseLabels.iterator();
                while (iterator2.hasNext()) {
                    ((Rvalue)iterator2.next()).setEnclosingBlockStatement(this);
                }
                Iterator iterator3 = switchBlockStatementGroup.blockStatements.iterator();
                while (iterator3.hasNext()) {
                    ((BlockStatement)iterator3.next()).setEnclosingScope(this);
                }
            }
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitSwitchStatement(this);
        }

        public static class SwitchBlockStatementGroup
        extends Located {
            public final List caseLabels;
            public final boolean hasDefaultLabel;
            public final List blockStatements;

            public SwitchBlockStatementGroup(Location location, List list, boolean bl, List list2) {
                super(location);
                this.caseLabels = list;
                this.hasDefaultLabel = bl;
                this.blockStatements = list2;
            }
        }
    }

    static class Padder
    extends CodeContext.Inserter
    implements CodeContext.FixUp {
        public Padder(CodeContext codeContext) {
        }

        public void fixUp() {
            int n = this.offset % 4;
            if (n != 0) {
                CodeContext codeContext = this.getCodeContext();
                codeContext.pushInserter(this);
                codeContext.write((short)-1, new byte[4 - n]);
                codeContext.popInserter();
            }
        }
    }

    public static final class SynchronizedStatement
    extends Statement {
        public final Rvalue expression;
        public final BlockStatement body;
        short monitorLvIndex = (short)-1;

        public SynchronizedStatement(Location location, Rvalue rvalue, BlockStatement blockStatement) {
            super(location);
            this.expression = rvalue;
            this.expression.setEnclosingBlockStatement(this);
            this.body = blockStatement;
            this.body.setEnclosingScope(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitSynchronizedStatement(this);
        }
    }

    public static final class DoStatement
    extends ContinuableStatement {
        public final BlockStatement body;
        public final Rvalue condition;

        public DoStatement(Location location, BlockStatement blockStatement, Rvalue rvalue) {
            super(location);
            this.body = blockStatement;
            this.body.setEnclosingScope(this);
            this.condition = rvalue;
            this.condition.setEnclosingBlockStatement(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitDoStatement(this);
        }
    }

    public static final class LocalVariableDeclarationStatement
    extends Statement {
        public final short modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public LocalVariableDeclarationStatement(Location location, short s, Type type, VariableDeclarator[] variableDeclaratorArray) {
            super(location);
            this.modifiers = s;
            this.type = type;
            this.type.setEnclosingScope(this);
            this.variableDeclarators = variableDeclaratorArray;
            int n = 0;
            while (n < variableDeclaratorArray.length) {
                VariableDeclarator variableDeclarator = variableDeclaratorArray[n];
                if (variableDeclarator.optionalInitializer != null) {
                    Java.setEnclosingBlockStatement(variableDeclarator.optionalInitializer, this);
                }
                ++n;
            }
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitLocalVariableDeclarationStatement(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.modifiers != 0) {
                stringBuffer.append(Mod.shortToString(this.modifiers)).append(' ');
            }
            stringBuffer.append(this.type).append(' ').append(this.variableDeclarators[0].toString());
            int n = 1;
            while (n < this.variableDeclarators.length) {
                stringBuffer.append(", ").append(this.variableDeclarators[n].toString());
                ++n;
            }
            return stringBuffer.append(';').toString();
        }
    }

    public static final class ReturnStatement
    extends Statement {
        public final Rvalue optionalReturnValue;

        public ReturnStatement(Location location, Rvalue rvalue) {
            super(location);
            this.optionalReturnValue = rvalue;
            if (rvalue != null) {
                rvalue.setEnclosingBlockStatement(this);
            }
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitReturnStatement(this);
        }
    }

    public static final class ThrowStatement
    extends Statement {
        public final Rvalue expression;

        public ThrowStatement(Location location, Rvalue rvalue) {
            super(location);
            this.expression = rvalue;
            this.expression.setEnclosingBlockStatement(this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitThrowStatement(this);
        }
    }

    public static final class BreakStatement
    extends Statement {
        public final String optionalLabel;

        public BreakStatement(Location location, String string) {
            super(location);
            this.optionalLabel = string;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitBreakStatement(this);
        }
    }

    public static final class ContinueStatement
    extends Statement {
        public final String optionalLabel;

        public ContinueStatement(Location location, String string) {
            super(location);
            this.optionalLabel = string;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitContinueStatement(this);
        }
    }

    public static final class EmptyStatement
    extends Statement {
        public EmptyStatement(Location location) {
            super(location);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitEmptyStatement(this);
        }
    }

    public static abstract class Atom
    extends Located {
        public Atom(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.AtomVisitor var1);

        public Lvalue toLvalue() {
            return null;
        }

        public final Lvalue toLvalueOrPE() throws Parser.ParseException {
            Lvalue lvalue = this.toLvalue();
            if (lvalue == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an lvalue");
            }
            return lvalue;
        }

        public Rvalue toRvalue() {
            return null;
        }

        public final Rvalue toRvalueOrPE() throws Parser.ParseException {
            Rvalue rvalue = this.toRvalue();
            if (rvalue == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an rvalue");
            }
            return rvalue;
        }

        public abstract String toString();

        public Type toType() {
            return null;
        }

        public final Type toTypeOrPE() throws Parser.ParseException {
            Type type = this.toType();
            if (type == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not a type");
            }
            return type;
        }
    }

    public static abstract class Type
    extends Atom {
        private Scope enclosingScope = null;

        protected Type(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.TypeVisitor var1);

        static /* synthetic */ Scope access$0(Type type) {
            return type.enclosingScope;
        }

        static /* synthetic */ void access$1(Type type, Scope scope) {
            type.enclosingScope = scope;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public void setEnclosingScope(Scope scope) {
            if (this.enclosingScope != null && scope != this.enclosingScope) {
                throw new RuntimeException("Enclosing scope already set for type \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = scope;
        }

        public Type toType() {
            return this;
        }
    }

    public static final class SimpleType
    extends Type {
        public final IClass iClass;

        public SimpleType(Location location, IClass iClass) {
            super(location);
            this.iClass = iClass;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitSimpleType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitSimpleType(this);
        }

        public String toString() {
            return this.iClass.toString();
        }
    }

    public static final class BasicType
    extends Type {
        public int index;
        public static final int VOID = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int CHAR = 3;
        public static final int INT = 4;
        public static final int LONG = 5;
        public static final int FLOAT = 6;
        public static final int DOUBLE = 7;
        public static final int BOOLEAN = 8;

        public BasicType(Location location, int n) {
            super(location);
            this.index = n;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitBasicType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitBasicType(this);
        }

        public String toString() {
            switch (this.index) {
                case 0: {
                    return "void";
                }
                case 1: {
                    return "byte";
                }
                case 2: {
                    return "short";
                }
                case 3: {
                    return "char";
                }
                case 4: {
                    return "int";
                }
                case 5: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: {
                    return "double";
                }
                case 8: {
                    return "boolean";
                }
            }
            throw new RuntimeException("Invalid index " + this.index);
        }
    }

    public static final class ReferenceType
    extends Type {
        public final String[] identifiers;

        public ReferenceType(Location location, String[] stringArray) {
            super(location);
            this.identifiers = stringArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitReferenceType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitReferenceType(this);
        }

        public String toString() {
            return Java.join(this.identifiers, ".");
        }
    }

    public static final class RvalueMemberType
    extends Type {
        public final Rvalue rvalue;
        public final String identifier;

        public RvalueMemberType(Location location, Rvalue rvalue, String string) {
            super(location);
            this.rvalue = rvalue;
            this.identifier = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitRvalueMemberType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitRvalueMemberType(this);
        }

        public String toString() {
            return this.identifier;
        }
    }

    public static final class ArrayType
    extends Type {
        public final Type componentType;

        public ArrayType(Type type) {
            super(type.getLocation());
            this.componentType = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitArrayType(this);
        }

        public void setEnclosingScope(Scope scope) {
            super.setEnclosingScope(scope);
            this.componentType.setEnclosingScope(scope);
        }

        public String toString() {
            return String.valueOf(this.componentType.toString()) + "[]";
        }
    }

    public static abstract class Rvalue
    extends Atom
    implements ArrayInitializerOrRvalue {
        private BlockStatement enclosingBlockStatement = null;
        static final Object CONSTANT_VALUE_UNKNOWN = new Object();
        Object constantValue = CONSTANT_VALUE_UNKNOWN;
        public static final Object CONSTANT_VALUE_NULL = new Throwable();
        public static final boolean JUMP_IF_TRUE = true;
        public static final boolean JUMP_IF_FALSE = false;

        protected Rvalue(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.RvalueVisitor var1);

        static /* synthetic */ BlockStatement access$0(Rvalue rvalue) {
            return rvalue.enclosingBlockStatement;
        }

        static /* synthetic */ void access$1(Rvalue rvalue, BlockStatement blockStatement) {
            rvalue.enclosingBlockStatement = blockStatement;
        }

        public BlockStatement getEnclosingBlockStatement() {
            return this.enclosingBlockStatement;
        }

        public final void setEnclosingBlockStatement(BlockStatement blockStatement) {
            this.accept((Visitor.RvalueVisitor)new Traverser((BlockStatement)blockStatement){
                private final /* synthetic */ BlockStatement val$enclosingBlockStatement;
                {
                    this.val$enclosingBlockStatement = blockStatement;
                }

                public void traverseAnonymousClassDeclaration(AnonymousClassDeclaration anonymousClassDeclaration) {
                    anonymousClassDeclaration.setEnclosingScope(this.val$enclosingBlockStatement);
                }

                public void traverseRvalue(Rvalue rvalue) {
                    if (Rvalue.access$0(rvalue) != null && this.val$enclosingBlockStatement != Rvalue.access$0(rvalue)) {
                        throw new RuntimeException("Enclosing block statement for rvalue \"" + rvalue + "\" at " + rvalue.getLocation() + " is already set");
                    }
                    Rvalue.access$1(rvalue, this.val$enclosingBlockStatement);
                    super.traverseRvalue(rvalue);
                }

                public void traverseType(Type type) {
                    if (Type.access$0(type) != null && this.val$enclosingBlockStatement != Type.access$0(type)) {
                        throw new RuntimeException("Enclosing scope already set for type \"" + this.toString() + "\" at " + type.getLocation());
                    }
                    Type.access$1(type, this.val$enclosingBlockStatement);
                    super.traverseType(type);
                }
            }.cv);
        }

        public Rvalue toRvalue() {
            return this;
        }
    }

    public static abstract class BooleanRvalue
    extends Rvalue {
        protected BooleanRvalue(Location location) {
            super(location);
        }
    }

    public static abstract class Lvalue
    extends Rvalue {
        protected Lvalue(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.LvalueVisitor var1);

        public Lvalue toLvalue() {
            return this;
        }
    }

    public static final class AmbiguousName
    extends Lvalue {
        public final String[] identifiers;
        public final int n;
        private Type type = null;
        Atom reclassified = null;

        public AmbiguousName(Location location, String[] stringArray) {
            this(location, stringArray, stringArray.length);
        }

        public AmbiguousName(Location location, String[] stringArray, int n) {
            super(location);
            this.identifiers = stringArray;
            this.n = n;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitAmbiguousName(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitAmbiguousName(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitAmbiguousName(this);
        }

        public String toString() {
            return Java.join(this.identifiers, ".", 0, this.n);
        }

        public Type toType() {
            if (this.type == null) {
                String[] stringArray = new String[this.n];
                System.arraycopy(this.identifiers, 0, stringArray, 0, this.n);
                this.type = new ReferenceType(this.getLocation(), stringArray);
                this.type.setEnclosingScope(this.getEnclosingBlockStatement());
            }
            return this.type;
        }
    }

    public static final class Package
    extends Atom {
        public final String name;

        public Package(Location location, String string) {
            super(location);
            this.name = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitPackage(this);
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class LocalVariableAccess
    extends Lvalue {
        public LocalVariable localVariable;

        public LocalVariableAccess(Location location, LocalVariable localVariable) {
            super(location);
            this.localVariable = localVariable;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitLocalVariableAccess(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitLocalVariableAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitLocalVariableAccess(this);
        }

        public String toString() {
            return this.localVariable.toString();
        }
    }

    public static final class FieldAccess
    extends Lvalue {
        public final Atom lhs;
        public final IClass.IField field;

        public FieldAccess(Location location, Atom atom, IClass.IField iField) {
            super(location);
            this.lhs = atom;
            this.field = iField;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitFieldAccess(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitFieldAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitFieldAccess(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '.' + this.field.toString();
        }
    }

    public static final class ArrayLength
    extends Rvalue {
        public final Rvalue lhs;

        public ArrayLength(Location location, Rvalue rvalue) {
            super(location);
            this.lhs = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayLength(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitArrayLength(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ".length";
        }
    }

    public static final class ThisReference
    extends Rvalue {
        IClass iClass = null;

        public ThisReference(Location location) {
            super(location);
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitThisReference(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitThisReference(this);
        }

        public String toString() {
            return "this";
        }
    }

    public static final class QualifiedThisReference
    extends Rvalue {
        public final Type qualification;
        ClassDeclaration declaringClass = null;
        TypeBodyDeclaration declaringTypeBodyDeclaration = null;
        IClass targetIClass = null;

        public QualifiedThisReference(Location location, Type type) {
            super(location);
            if (type == null) {
                throw new NullPointerException();
            }
            this.qualification = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitQualifiedThisReference(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitQualifiedThisReference(this);
        }

        public String toString() {
            return String.valueOf(this.qualification.toString()) + ".this";
        }
    }

    public static final class ClassLiteral
    extends Rvalue {
        public final Type type;

        public ClassLiteral(Location location, Type type) {
            super(location);
            this.type = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitClassLiteral(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitClassLiteral(this);
        }

        public String toString() {
            return String.valueOf(this.type.toString()) + ".class";
        }
    }

    public static final class Assignment
    extends Rvalue {
        public final Lvalue lhs;
        public final String operator;
        public final Rvalue rhs;

        public Assignment(Location location, Lvalue lvalue, String string, Rvalue rvalue) {
            super(location);
            this.lhs = lvalue;
            this.operator = string;
            this.rhs = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitAssignment(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitAssignment(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ' ' + this.operator + ' ' + this.rhs.toString();
        }
    }

    public static final class ConditionalExpression
    extends Rvalue {
        public final Rvalue lhs;
        public final Rvalue mhs;
        public final Rvalue rhs;

        public ConditionalExpression(Location location, Rvalue rvalue, Rvalue rvalue2, Rvalue rvalue3) {
            super(location);
            this.lhs = rvalue;
            this.mhs = rvalue2;
            this.rhs = rvalue3;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitConditionalExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitConditionalExpression(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + " ? " + this.mhs.toString() + " : " + this.rhs.toString();
        }
    }

    public static final class Crement
    extends Rvalue {
        public final boolean pre;
        public final String operator;
        public final Lvalue operand;

        public Crement(Location location, String string, Lvalue lvalue) {
            super(location);
            this.pre = true;
            this.operator = string;
            this.operand = lvalue;
        }

        public Crement(Location location, Lvalue lvalue, String string) {
            super(location);
            this.pre = false;
            this.operator = string;
            this.operand = lvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitCrement(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitCrement(this);
        }

        public String toString() {
            return this.pre ? String.valueOf(this.operator) + this.operand : String.valueOf(String.valueOf(this.operand)) + this.operator;
        }
    }

    public static final class ArrayAccessExpression
    extends Lvalue {
        public final Rvalue lhs;
        public final Rvalue index;

        public ArrayAccessExpression(Location location, Rvalue rvalue, Rvalue rvalue2) {
            super(location);
            this.lhs = rvalue;
            this.index = rvalue2;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitArrayAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitArrayAccessExpression(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '[' + this.index + ']';
        }
    }

    public static final class FieldAccessExpression
    extends Lvalue {
        public final Atom lhs;
        public final String fieldName;
        Rvalue value = null;

        public FieldAccessExpression(Location location, Atom atom, String string) {
            super(location);
            this.lhs = atom;
            this.fieldName = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitFieldAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitFieldAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitFieldAccessExpression(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '.' + this.fieldName;
        }
    }

    public static final class UnaryOperation
    extends BooleanRvalue {
        public final String operator;
        public final Rvalue operand;

        public UnaryOperation(Location location, String string, Rvalue rvalue) {
            super(location);
            this.operator = string;
            this.operand = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitUnaryOperation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitUnaryOperation(this);
        }

        public String toString() {
            return String.valueOf(this.operator) + this.operand.toString();
        }
    }

    public static final class Instanceof
    extends Rvalue {
        public final Rvalue lhs;
        public final Type rhs;

        public Instanceof(Location location, Rvalue rvalue, Type type) {
            super(location);
            this.lhs = rvalue;
            this.rhs = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitInstanceof(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitInstanceof(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + " instanceof " + this.rhs.toString();
        }
    }

    public static final class BinaryOperation
    extends BooleanRvalue {
        public final Rvalue lhs;
        public final String op;
        public final Rvalue rhs;

        public BinaryOperation(Location location, Rvalue rvalue, String string, Rvalue rvalue2) {
            super(location);
            this.lhs = rvalue;
            this.op = string;
            this.rhs = rvalue2;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitBinaryOperation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitBinaryOperation(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ' ' + this.op + ' ' + this.rhs.toString();
        }

        public Iterator unrollLeftAssociation() {
            Rvalue rvalue;
            ArrayList<Rvalue> arrayList = new ArrayList<Rvalue>();
            BinaryOperation binaryOperation = this;
            while (true) {
                arrayList.add(binaryOperation.rhs);
                rvalue = binaryOperation.lhs;
                if (!(rvalue instanceof BinaryOperation) || ((BinaryOperation)rvalue).op != this.op) break;
                binaryOperation = (BinaryOperation)rvalue;
            }
            arrayList.add(rvalue);
            return new ReverseListIterator(arrayList.listIterator(arrayList.size()));
        }
    }

    public static final class Cast
    extends Rvalue {
        public final Type targetType;
        public final Rvalue value;

        public Cast(Location location, Type type, Rvalue rvalue) {
            super(location);
            this.targetType = type;
            this.value = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitCast(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitCast(this);
        }

        public String toString() {
            return String.valueOf('(') + this.targetType.toString() + ") " + this.value.toString();
        }
    }

    public static final class ParenthesizedExpression
    extends Lvalue {
        public final Rvalue value;

        public ParenthesizedExpression(Location location, Rvalue rvalue) {
            super(location);
            this.value = rvalue;
        }

        public void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitParenthesizedExpression(this);
        }

        public void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitParenthesizedExpression(this);
        }

        public void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitParenthesizedExpression(this);
        }

        public String toString() {
            return String.valueOf('(') + this.value.toString() + ')';
        }
    }

    public static abstract class ConstructorInvocation
    extends Atom
    implements BlockStatement {
        public final Rvalue[] arguments;
        private Scope enclosingScope = null;

        protected ConstructorInvocation(Location location, Rvalue[] rvalueArray) {
            super(location);
            this.arguments = rvalueArray;
            int n = 0;
            while (n < rvalueArray.length) {
                rvalueArray[n].setEnclosingBlockStatement(this);
                ++n;
            }
        }

        public abstract void accept(Visitor.BlockStatementVisitor var1);

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public void setEnclosingScope(Scope scope) {
            if (this.enclosingScope != null && scope != null) {
                throw new RuntimeException("Enclosing scope is already set for statement \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = scope;
        }
    }

    public static final class AlternateConstructorInvocation
    extends ConstructorInvocation {
        public AlternateConstructorInvocation(Location location, Rvalue[] rvalueArray) {
            super(location, rvalueArray);
        }

        public void accept(Visitor.AtomVisitor atomVisitor) {
            ((Visitor.BlockStatementVisitor)((Object)atomVisitor)).visitAlternateConstructorInvocation(this);
        }

        public void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitAlternateConstructorInvocation(this);
        }

        public String toString() {
            return "this()";
        }
    }

    public static final class SuperConstructorInvocation
    extends ConstructorInvocation {
        public final Rvalue optionalQualification;

        public SuperConstructorInvocation(Location location, Rvalue rvalue, Rvalue[] rvalueArray) {
            super(location, rvalueArray);
            this.optionalQualification = rvalue;
            if (rvalue != null) {
                rvalue.setEnclosingBlockStatement(this);
            }
        }

        public void accept(Visitor.AtomVisitor atomVisitor) {
            ((Visitor.BlockStatementVisitor)((Object)atomVisitor)).visitSuperConstructorInvocation(this);
        }

        public void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitSuperConstructorInvocation(this);
        }

        public String toString() {
            return "super()";
        }
    }

    public static final class MethodInvocation
    extends Invocation {
        public final Atom optionalTarget;
        public final String methodName;
        IClass.IMethod iMethod;

        public MethodInvocation(Location location, Atom atom, String string, Rvalue[] rvalueArray) {
            super(location, rvalueArray);
            this.optionalTarget = atom;
            this.methodName = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitMethodInvocation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitMethodInvocation(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalTarget != null) {
                stringBuffer.append(this.optionalTarget.toString()).append('.');
            }
            stringBuffer.append(this.methodName).append('(');
            int n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.arguments[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class SuperclassMethodInvocation
    extends Invocation {
        public final String methodName;

        public SuperclassMethodInvocation(Location location, String string, Rvalue[] rvalueArray) {
            super(location, rvalueArray);
            this.methodName = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitSuperclassMethodInvocation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitSuperclassMethodInvocation(this);
        }

        public String toString() {
            return "super." + this.methodName + "()";
        }
    }

    public static abstract class Invocation
    extends Rvalue {
        public final Rvalue[] arguments;

        protected Invocation(Location location, Rvalue[] rvalueArray) {
            super(location);
            this.arguments = rvalueArray;
        }
    }

    public static final class NewClassInstance
    extends Rvalue {
        public final Rvalue optionalQualification;
        public final Type type;
        public final Rvalue[] arguments;
        protected IClass iClass = null;

        public NewClassInstance(Location location, Rvalue rvalue, IClass iClass, Rvalue[] rvalueArray) {
            super(location);
            this.optionalQualification = rvalue;
            this.type = null;
            this.arguments = rvalueArray;
            this.iClass = iClass;
        }

        public NewClassInstance(Location location, Rvalue rvalue, Type type, Rvalue[] rvalueArray) {
            super(location);
            this.optionalQualification = rvalue;
            this.type = type;
            this.arguments = rvalueArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewClassInstance(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewClassInstance(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalQualification != null) {
                stringBuffer.append(this.optionalQualification.toString()).append('.');
            }
            stringBuffer.append("new ");
            if (this.type != null) {
                stringBuffer.append(this.type.toString());
            } else if (this.iClass != null) {
                stringBuffer.append(this.iClass.toString());
            } else {
                stringBuffer.append("???");
            }
            stringBuffer.append('(');
            int n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.arguments[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class NewAnonymousClassInstance
    extends Rvalue {
        public final Rvalue optionalQualification;
        public final AnonymousClassDeclaration anonymousClassDeclaration;
        public final Rvalue[] arguments;

        public NewAnonymousClassInstance(Location location, Rvalue rvalue, AnonymousClassDeclaration anonymousClassDeclaration, Rvalue[] rvalueArray) {
            super(location);
            this.optionalQualification = rvalue;
            this.anonymousClassDeclaration = anonymousClassDeclaration;
            this.arguments = rvalueArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewAnonymousClassInstance(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewAnonymousClassInstance(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalQualification != null) {
                stringBuffer.append(this.optionalQualification.toString()).append('.');
            }
            stringBuffer.append("new ").append(this.anonymousClassDeclaration.baseType.toString()).append("() { ... }");
            return stringBuffer.toString();
        }
    }

    public static final class ParameterAccess
    extends Rvalue {
        public final FunctionDeclarator.FormalParameter formalParameter;

        public ParameterAccess(Location location, FunctionDeclarator.FormalParameter formalParameter) {
            super(location);
            this.formalParameter = formalParameter;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitParameterAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitParameterAccess(this);
        }

        public String toString() {
            return this.formalParameter.name;
        }
    }

    public static final class NewArray
    extends Rvalue {
        public final Type type;
        public final Rvalue[] dimExprs;
        public final int dims;

        public NewArray(Location location, Type type, Rvalue[] rvalueArray, int n) {
            super(location);
            this.type = type;
            this.dimExprs = rvalueArray;
            this.dims = n;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewArray(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewArray(this);
        }

        public String toString() {
            return "new " + this.type.toString() + "[]...";
        }
    }

    public static final class NewInitializedArray
    extends Rvalue {
        public final ArrayType arrayType;
        public final ArrayInitializer arrayInitializer;

        public NewInitializedArray(Location location, ArrayType arrayType, ArrayInitializer arrayInitializer) {
            super(location);
            this.arrayType = arrayType;
            this.arrayInitializer = arrayInitializer;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewInitializedArray(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewInitializedArray(this);
        }

        public String toString() {
            return "new " + this.arrayType.toString() + " { ... }";
        }
    }

    public static final class ArrayInitializer
    extends Located
    implements ArrayInitializerOrRvalue {
        public final ArrayInitializerOrRvalue[] values;

        public ArrayInitializer(Location location, ArrayInitializerOrRvalue[] arrayInitializerOrRvalueArray) {
            super(location);
            this.values = arrayInitializerOrRvalueArray;
        }
    }

    public static interface ArrayInitializerOrRvalue {
    }

    public static final class Literal
    extends Rvalue {
        public final Object value;

        public Literal(Location location, Object object) {
            super(location);
            this.value = object;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitLiteral(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitLiteral(this);
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }
    }

    public static final class ConstantValue
    extends Rvalue {
        public final Object constantValue;

        public ConstantValue(Location location, Object object) {
            super(location);
            this.constantValue = object == null ? Rvalue.CONSTANT_VALUE_NULL : object;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitConstantValue(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitConstantValue(this);
        }

        public String toString() {
            return this.constantValue.toString();
        }
    }

    public static class LocalVariable {
        public final boolean finaL;
        public final IClass type;
        public short localVariableArrayIndex = (short)-1;

        public LocalVariable(boolean bl, IClass iClass) {
            this.finaL = bl;
            this.type = iClass;
        }
    }
}

