/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.iterator.MultiDimensionalIterator;
import org.codehaus.janino.util.iterator.TransformingIterator;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;
import org.codehaus.janino.util.resource.ZipFileResourceFinder;

public class JarDirectoriesResourceFinder
extends LazyMultiResourceFinder {
    public JarDirectoriesResourceFinder(File[] fileArray) {
        super(new MultiDimensionalIterator(new TransformingIterator(Arrays.asList(fileArray).iterator()){

            protected Object transform(Object object) {
                File file = (File)object;
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                });
                return new TransformingIterator(Arrays.asList(fileArray).iterator()){

                    protected Object transform(Object object) {
                        File file = (File)object;
                        try {
                            return new ZipFileResourceFinder(new ZipFile(file));
                        }
                        catch (IOException iOException) {
                            return ResourceFinder.EMPTY_RESOURCE_FINDER;
                        }
                    }
                };
            }
        }, 2));
    }
}

