/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.JComboBox;
import javax.swing.JPanel;

public abstract class ChoiceEditor extends PropertyEditorSupport {
	protected HashMap<Object,String> valuesToStrings = new HashMap<Object,String>();
	protected HashMap<String,Object> stringsToValues = new HashMap<String,Object>();
	
	final JComboBox box = new JComboBox();
	
	public ChoiceEditor() {
		defineValuesToStrings();
		updateStringsToValues();
	}
	
	public boolean supportsCustomEditor() {
		return true;
	}
	
	public Component getCustomEditor() {
		JPanel comp = new JPanel(new BorderLayout());
		box.setSelectedItem(getValue());
		box.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				setValue(stringsToValues.get(box.getSelectedItem()));
			}
		});
		comp.add("Center", box);
		return comp;
	}
	
	public void setValue(Object value) {
		super.setValue(value);
		box.setSelectedItem(value == null ? getNameOfNull() : valuesToStrings.get(value));
	}
	
	protected abstract void defineValuesToStrings();
	
	protected String getNameOfNull() {
		return null;
	}
	
	private void updateStringsToValues() {
		String nameOfNull = getNameOfNull();
		if (nameOfNull != null) {
			box.addItem(nameOfNull);
			stringsToValues.put(nameOfNull, null);
		}
		Iterator i = valuesToStrings.keySet().iterator();
		while (i.hasNext()) {
			Object value = i.next();
			String string = valuesToStrings.get(value);
			stringsToValues.put(string, value);
			box.addItem(string);
		}
	}
}
