/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class AuxiliaryLoggerRemote
extends VRPNDevice
implements Runnable {
    protected Vector listeners = new Vector();
    protected static final Object notifyingListenersLock = new Object();

    public AuxiliaryLoggerRemote(String name) throws InstantiationException {
        super(name, null, null, null, null);
    }

    public synchronized native boolean sendLoggingRequest(String var1, String var2, String var3, String var4);

    public synchronized native boolean sendLoggingStatusRequest();

    public synchronized void addLoggingReportListener(LoggingReportListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized boolean removeLoggingReportListener(LoggingReportListener listener) {
        return this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLoggingReport(long tv_sec, long tv_usec, String localIn, String localOut, String remoteIn, String remoteOut) {
        Object object = notifyingListenersLock;
        synchronized (object) {
            LoggingReport r = new LoggingReport();
            r.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            r.localInLogfileName = localIn;
            r.localOutLogfileName = localOut;
            r.remoteInLogfileName = remoteIn;
            r.remoteOutLogfileName = remoteOut;
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                LoggingReportListener l = (LoggingReportListener)e.nextElement();
                l.loggingReport(r, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.listeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownAuxiliaryLogger();
        }
    }

    protected native void shutdownAuxiliaryLogger();

    @Override
    protected native void mainloop();

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    public class LoggingReport {
        public Date msg_time = new Date();
        public String localInLogfileName = "";
        public String localOutLogfileName = "";
        public String remoteInLogfileName = "";
        public String remoteOutLogfileName = "";
    }

    public static interface LoggingReportListener {
        public void loggingReport(LoggingReport var1, AuxiliaryLoggerRemote var2);
    }
}

